/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <SaveSubWindowsAttributes.h>
#include <DataNode.h>

// ****************************************************************************
// Method: SaveSubWindowsAttributes::SaveSubWindowsAttributes
//
// Purpose: 
//   Init utility for the SaveSubWindowsAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void SaveSubWindowsAttributes::Init()
{

    SaveSubWindowsAttributes::SelectAll();
}

// ****************************************************************************
// Method: SaveSubWindowsAttributes::SaveSubWindowsAttributes
//
// Purpose: 
//   Copy utility for the SaveSubWindowsAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void SaveSubWindowsAttributes::Copy(const SaveSubWindowsAttributes &obj)
{
    win1 = obj.win1;
    win2 = obj.win2;
    win3 = obj.win3;
    win4 = obj.win4;
    win5 = obj.win5;
    win6 = obj.win6;
    win7 = obj.win7;
    win8 = obj.win8;
    win9 = obj.win9;
    win10 = obj.win10;
    win11 = obj.win11;
    win12 = obj.win12;
    win13 = obj.win13;
    win14 = obj.win14;
    win15 = obj.win15;
    win16 = obj.win16;

    SaveSubWindowsAttributes::SelectAll();
}

// Type map format string
const char *SaveSubWindowsAttributes::TypeMapFormatString = SAVESUBWINDOWSATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t SaveSubWindowsAttributes::TmfsStruct = {SAVESUBWINDOWSATTRIBUTES_TMFS};


// ****************************************************************************
// Method: SaveSubWindowsAttributes::SaveSubWindowsAttributes
//
// Purpose: 
//   Default constructor for the SaveSubWindowsAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SaveSubWindowsAttributes::SaveSubWindowsAttributes() : 
    AttributeSubject(SaveSubWindowsAttributes::TypeMapFormatString)
{
    SaveSubWindowsAttributes::Init();
}

// ****************************************************************************
// Method: SaveSubWindowsAttributes::SaveSubWindowsAttributes
//
// Purpose: 
//   Constructor for the derived classes of SaveSubWindowsAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SaveSubWindowsAttributes::SaveSubWindowsAttributes(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    SaveSubWindowsAttributes::Init();
}

// ****************************************************************************
// Method: SaveSubWindowsAttributes::SaveSubWindowsAttributes
//
// Purpose: 
//   Copy constructor for the SaveSubWindowsAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SaveSubWindowsAttributes::SaveSubWindowsAttributes(const SaveSubWindowsAttributes &obj) : 
    AttributeSubject(SaveSubWindowsAttributes::TypeMapFormatString)
{
    SaveSubWindowsAttributes::Copy(obj);
}

// ****************************************************************************
// Method: SaveSubWindowsAttributes::SaveSubWindowsAttributes
//
// Purpose: 
//   Copy constructor for derived classes of the SaveSubWindowsAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SaveSubWindowsAttributes::SaveSubWindowsAttributes(const SaveSubWindowsAttributes &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    SaveSubWindowsAttributes::Copy(obj);
}

// ****************************************************************************
// Method: SaveSubWindowsAttributes::~SaveSubWindowsAttributes
//
// Purpose: 
//   Destructor for the SaveSubWindowsAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SaveSubWindowsAttributes::~SaveSubWindowsAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: SaveSubWindowsAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the SaveSubWindowsAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SaveSubWindowsAttributes& 
SaveSubWindowsAttributes::operator = (const SaveSubWindowsAttributes &obj)
{
    if (this == &obj) return *this;

    SaveSubWindowsAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: SaveSubWindowsAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the SaveSubWindowsAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
SaveSubWindowsAttributes::operator == (const SaveSubWindowsAttributes &obj) const
{
    // Create the return value
    return ((win1 == obj.win1) &&
            (win2 == obj.win2) &&
            (win3 == obj.win3) &&
            (win4 == obj.win4) &&
            (win5 == obj.win5) &&
            (win6 == obj.win6) &&
            (win7 == obj.win7) &&
            (win8 == obj.win8) &&
            (win9 == obj.win9) &&
            (win10 == obj.win10) &&
            (win11 == obj.win11) &&
            (win12 == obj.win12) &&
            (win13 == obj.win13) &&
            (win14 == obj.win14) &&
            (win15 == obj.win15) &&
            (win16 == obj.win16));
}

// ****************************************************************************
// Method: SaveSubWindowsAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the SaveSubWindowsAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
SaveSubWindowsAttributes::operator != (const SaveSubWindowsAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: SaveSubWindowsAttributes::TypeName
//
// Purpose: 
//   Type name method for the SaveSubWindowsAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
SaveSubWindowsAttributes::TypeName() const
{
    return "SaveSubWindowsAttributes";
}

// ****************************************************************************
// Method: SaveSubWindowsAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the SaveSubWindowsAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
SaveSubWindowsAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const SaveSubWindowsAttributes *tmp = (const SaveSubWindowsAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: SaveSubWindowsAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the SaveSubWindowsAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
SaveSubWindowsAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new SaveSubWindowsAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: SaveSubWindowsAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the SaveSubWindowsAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
SaveSubWindowsAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new SaveSubWindowsAttributes(*this);
    else
        retval = new SaveSubWindowsAttributes;

    return retval;
}

// ****************************************************************************
// Method: SaveSubWindowsAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
SaveSubWindowsAttributes::SelectAll()
{
    Select(ID_win1,  (void *)&win1);
    Select(ID_win2,  (void *)&win2);
    Select(ID_win3,  (void *)&win3);
    Select(ID_win4,  (void *)&win4);
    Select(ID_win5,  (void *)&win5);
    Select(ID_win6,  (void *)&win6);
    Select(ID_win7,  (void *)&win7);
    Select(ID_win8,  (void *)&win8);
    Select(ID_win9,  (void *)&win9);
    Select(ID_win10, (void *)&win10);
    Select(ID_win11, (void *)&win11);
    Select(ID_win12, (void *)&win12);
    Select(ID_win13, (void *)&win13);
    Select(ID_win14, (void *)&win14);
    Select(ID_win15, (void *)&win15);
    Select(ID_win16, (void *)&win16);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: SaveSubWindowsAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
SaveSubWindowsAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    SaveSubWindowsAttributes defaultObject;
    bool addToParent = false;
    // Create a node for SaveSubWindowsAttributes.
    DataNode *node = new DataNode("SaveSubWindowsAttributes");

    if(completeSave || !FieldsEqual(ID_win1, &defaultObject))
    {
        DataNode *win1Node = new DataNode("win1");
        if(win1.CreateNode(win1Node, completeSave, false))
        {
            addToParent = true;
            node->AddNode(win1Node);
        }
        else
            delete win1Node;
    }

    if(completeSave || !FieldsEqual(ID_win2, &defaultObject))
    {
        DataNode *win2Node = new DataNode("win2");
        if(win2.CreateNode(win2Node, completeSave, false))
        {
            addToParent = true;
            node->AddNode(win2Node);
        }
        else
            delete win2Node;
    }

    if(completeSave || !FieldsEqual(ID_win3, &defaultObject))
    {
        DataNode *win3Node = new DataNode("win3");
        if(win3.CreateNode(win3Node, completeSave, false))
        {
            addToParent = true;
            node->AddNode(win3Node);
        }
        else
            delete win3Node;
    }

    if(completeSave || !FieldsEqual(ID_win4, &defaultObject))
    {
        DataNode *win4Node = new DataNode("win4");
        if(win4.CreateNode(win4Node, completeSave, false))
        {
            addToParent = true;
            node->AddNode(win4Node);
        }
        else
            delete win4Node;
    }

    if(completeSave || !FieldsEqual(ID_win5, &defaultObject))
    {
        DataNode *win5Node = new DataNode("win5");
        if(win5.CreateNode(win5Node, completeSave, false))
        {
            addToParent = true;
            node->AddNode(win5Node);
        }
        else
            delete win5Node;
    }

    if(completeSave || !FieldsEqual(ID_win6, &defaultObject))
    {
        DataNode *win6Node = new DataNode("win6");
        if(win6.CreateNode(win6Node, completeSave, false))
        {
            addToParent = true;
            node->AddNode(win6Node);
        }
        else
            delete win6Node;
    }

    if(completeSave || !FieldsEqual(ID_win7, &defaultObject))
    {
        DataNode *win7Node = new DataNode("win7");
        if(win7.CreateNode(win7Node, completeSave, false))
        {
            addToParent = true;
            node->AddNode(win7Node);
        }
        else
            delete win7Node;
    }

    if(completeSave || !FieldsEqual(ID_win8, &defaultObject))
    {
        DataNode *win8Node = new DataNode("win8");
        if(win8.CreateNode(win8Node, completeSave, false))
        {
            addToParent = true;
            node->AddNode(win8Node);
        }
        else
            delete win8Node;
    }

    if(completeSave || !FieldsEqual(ID_win9, &defaultObject))
    {
        DataNode *win9Node = new DataNode("win9");
        if(win9.CreateNode(win9Node, completeSave, false))
        {
            addToParent = true;
            node->AddNode(win9Node);
        }
        else
            delete win9Node;
    }

    if(completeSave || !FieldsEqual(ID_win10, &defaultObject))
    {
        DataNode *win10Node = new DataNode("win10");
        if(win10.CreateNode(win10Node, completeSave, false))
        {
            addToParent = true;
            node->AddNode(win10Node);
        }
        else
            delete win10Node;
    }

    if(completeSave || !FieldsEqual(ID_win11, &defaultObject))
    {
        DataNode *win11Node = new DataNode("win11");
        if(win11.CreateNode(win11Node, completeSave, false))
        {
            addToParent = true;
            node->AddNode(win11Node);
        }
        else
            delete win11Node;
    }

    if(completeSave || !FieldsEqual(ID_win12, &defaultObject))
    {
        DataNode *win12Node = new DataNode("win12");
        if(win12.CreateNode(win12Node, completeSave, false))
        {
            addToParent = true;
            node->AddNode(win12Node);
        }
        else
            delete win12Node;
    }

    if(completeSave || !FieldsEqual(ID_win13, &defaultObject))
    {
        DataNode *win13Node = new DataNode("win13");
        if(win13.CreateNode(win13Node, completeSave, false))
        {
            addToParent = true;
            node->AddNode(win13Node);
        }
        else
            delete win13Node;
    }

    if(completeSave || !FieldsEqual(ID_win14, &defaultObject))
    {
        DataNode *win14Node = new DataNode("win14");
        if(win14.CreateNode(win14Node, completeSave, false))
        {
            addToParent = true;
            node->AddNode(win14Node);
        }
        else
            delete win14Node;
    }

    if(completeSave || !FieldsEqual(ID_win15, &defaultObject))
    {
        DataNode *win15Node = new DataNode("win15");
        if(win15.CreateNode(win15Node, completeSave, false))
        {
            addToParent = true;
            node->AddNode(win15Node);
        }
        else
            delete win15Node;
    }

    if(completeSave || !FieldsEqual(ID_win16, &defaultObject))
    {
        DataNode *win16Node = new DataNode("win16");
        if(win16.CreateNode(win16Node, completeSave, false))
        {
            addToParent = true;
            node->AddNode(win16Node);
        }
        else
            delete win16Node;
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: SaveSubWindowsAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
SaveSubWindowsAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("SaveSubWindowsAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("win1")) != 0)
        win1.SetFromNode(node);
    if((node = searchNode->GetNode("win2")) != 0)
        win2.SetFromNode(node);
    if((node = searchNode->GetNode("win3")) != 0)
        win3.SetFromNode(node);
    if((node = searchNode->GetNode("win4")) != 0)
        win4.SetFromNode(node);
    if((node = searchNode->GetNode("win5")) != 0)
        win5.SetFromNode(node);
    if((node = searchNode->GetNode("win6")) != 0)
        win6.SetFromNode(node);
    if((node = searchNode->GetNode("win7")) != 0)
        win7.SetFromNode(node);
    if((node = searchNode->GetNode("win8")) != 0)
        win8.SetFromNode(node);
    if((node = searchNode->GetNode("win9")) != 0)
        win9.SetFromNode(node);
    if((node = searchNode->GetNode("win10")) != 0)
        win10.SetFromNode(node);
    if((node = searchNode->GetNode("win11")) != 0)
        win11.SetFromNode(node);
    if((node = searchNode->GetNode("win12")) != 0)
        win12.SetFromNode(node);
    if((node = searchNode->GetNode("win13")) != 0)
        win13.SetFromNode(node);
    if((node = searchNode->GetNode("win14")) != 0)
        win14.SetFromNode(node);
    if((node = searchNode->GetNode("win15")) != 0)
        win15.SetFromNode(node);
    if((node = searchNode->GetNode("win16")) != 0)
        win16.SetFromNode(node);
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
SaveSubWindowsAttributes::SetWin1(const SaveSubWindowAttributes &win1_)
{
    win1 = win1_;
    Select(ID_win1, (void *)&win1);
}

void
SaveSubWindowsAttributes::SetWin2(const SaveSubWindowAttributes &win2_)
{
    win2 = win2_;
    Select(ID_win2, (void *)&win2);
}

void
SaveSubWindowsAttributes::SetWin3(const SaveSubWindowAttributes &win3_)
{
    win3 = win3_;
    Select(ID_win3, (void *)&win3);
}

void
SaveSubWindowsAttributes::SetWin4(const SaveSubWindowAttributes &win4_)
{
    win4 = win4_;
    Select(ID_win4, (void *)&win4);
}

void
SaveSubWindowsAttributes::SetWin5(const SaveSubWindowAttributes &win5_)
{
    win5 = win5_;
    Select(ID_win5, (void *)&win5);
}

void
SaveSubWindowsAttributes::SetWin6(const SaveSubWindowAttributes &win6_)
{
    win6 = win6_;
    Select(ID_win6, (void *)&win6);
}

void
SaveSubWindowsAttributes::SetWin7(const SaveSubWindowAttributes &win7_)
{
    win7 = win7_;
    Select(ID_win7, (void *)&win7);
}

void
SaveSubWindowsAttributes::SetWin8(const SaveSubWindowAttributes &win8_)
{
    win8 = win8_;
    Select(ID_win8, (void *)&win8);
}

void
SaveSubWindowsAttributes::SetWin9(const SaveSubWindowAttributes &win9_)
{
    win9 = win9_;
    Select(ID_win9, (void *)&win9);
}

void
SaveSubWindowsAttributes::SetWin10(const SaveSubWindowAttributes &win10_)
{
    win10 = win10_;
    Select(ID_win10, (void *)&win10);
}

void
SaveSubWindowsAttributes::SetWin11(const SaveSubWindowAttributes &win11_)
{
    win11 = win11_;
    Select(ID_win11, (void *)&win11);
}

void
SaveSubWindowsAttributes::SetWin12(const SaveSubWindowAttributes &win12_)
{
    win12 = win12_;
    Select(ID_win12, (void *)&win12);
}

void
SaveSubWindowsAttributes::SetWin13(const SaveSubWindowAttributes &win13_)
{
    win13 = win13_;
    Select(ID_win13, (void *)&win13);
}

void
SaveSubWindowsAttributes::SetWin14(const SaveSubWindowAttributes &win14_)
{
    win14 = win14_;
    Select(ID_win14, (void *)&win14);
}

void
SaveSubWindowsAttributes::SetWin15(const SaveSubWindowAttributes &win15_)
{
    win15 = win15_;
    Select(ID_win15, (void *)&win15);
}

void
SaveSubWindowsAttributes::SetWin16(const SaveSubWindowAttributes &win16_)
{
    win16 = win16_;
    Select(ID_win16, (void *)&win16);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const SaveSubWindowAttributes &
SaveSubWindowsAttributes::GetWin1() const
{
    return win1;
}

SaveSubWindowAttributes &
SaveSubWindowsAttributes::GetWin1()
{
    return win1;
}

const SaveSubWindowAttributes &
SaveSubWindowsAttributes::GetWin2() const
{
    return win2;
}

SaveSubWindowAttributes &
SaveSubWindowsAttributes::GetWin2()
{
    return win2;
}

const SaveSubWindowAttributes &
SaveSubWindowsAttributes::GetWin3() const
{
    return win3;
}

SaveSubWindowAttributes &
SaveSubWindowsAttributes::GetWin3()
{
    return win3;
}

const SaveSubWindowAttributes &
SaveSubWindowsAttributes::GetWin4() const
{
    return win4;
}

SaveSubWindowAttributes &
SaveSubWindowsAttributes::GetWin4()
{
    return win4;
}

const SaveSubWindowAttributes &
SaveSubWindowsAttributes::GetWin5() const
{
    return win5;
}

SaveSubWindowAttributes &
SaveSubWindowsAttributes::GetWin5()
{
    return win5;
}

const SaveSubWindowAttributes &
SaveSubWindowsAttributes::GetWin6() const
{
    return win6;
}

SaveSubWindowAttributes &
SaveSubWindowsAttributes::GetWin6()
{
    return win6;
}

const SaveSubWindowAttributes &
SaveSubWindowsAttributes::GetWin7() const
{
    return win7;
}

SaveSubWindowAttributes &
SaveSubWindowsAttributes::GetWin7()
{
    return win7;
}

const SaveSubWindowAttributes &
SaveSubWindowsAttributes::GetWin8() const
{
    return win8;
}

SaveSubWindowAttributes &
SaveSubWindowsAttributes::GetWin8()
{
    return win8;
}

const SaveSubWindowAttributes &
SaveSubWindowsAttributes::GetWin9() const
{
    return win9;
}

SaveSubWindowAttributes &
SaveSubWindowsAttributes::GetWin9()
{
    return win9;
}

const SaveSubWindowAttributes &
SaveSubWindowsAttributes::GetWin10() const
{
    return win10;
}

SaveSubWindowAttributes &
SaveSubWindowsAttributes::GetWin10()
{
    return win10;
}

const SaveSubWindowAttributes &
SaveSubWindowsAttributes::GetWin11() const
{
    return win11;
}

SaveSubWindowAttributes &
SaveSubWindowsAttributes::GetWin11()
{
    return win11;
}

const SaveSubWindowAttributes &
SaveSubWindowsAttributes::GetWin12() const
{
    return win12;
}

SaveSubWindowAttributes &
SaveSubWindowsAttributes::GetWin12()
{
    return win12;
}

const SaveSubWindowAttributes &
SaveSubWindowsAttributes::GetWin13() const
{
    return win13;
}

SaveSubWindowAttributes &
SaveSubWindowsAttributes::GetWin13()
{
    return win13;
}

const SaveSubWindowAttributes &
SaveSubWindowsAttributes::GetWin14() const
{
    return win14;
}

SaveSubWindowAttributes &
SaveSubWindowsAttributes::GetWin14()
{
    return win14;
}

const SaveSubWindowAttributes &
SaveSubWindowsAttributes::GetWin15() const
{
    return win15;
}

SaveSubWindowAttributes &
SaveSubWindowsAttributes::GetWin15()
{
    return win15;
}

const SaveSubWindowAttributes &
SaveSubWindowsAttributes::GetWin16() const
{
    return win16;
}

SaveSubWindowAttributes &
SaveSubWindowsAttributes::GetWin16()
{
    return win16;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
SaveSubWindowsAttributes::SelectWin1()
{
    Select(ID_win1, (void *)&win1);
}

void
SaveSubWindowsAttributes::SelectWin2()
{
    Select(ID_win2, (void *)&win2);
}

void
SaveSubWindowsAttributes::SelectWin3()
{
    Select(ID_win3, (void *)&win3);
}

void
SaveSubWindowsAttributes::SelectWin4()
{
    Select(ID_win4, (void *)&win4);
}

void
SaveSubWindowsAttributes::SelectWin5()
{
    Select(ID_win5, (void *)&win5);
}

void
SaveSubWindowsAttributes::SelectWin6()
{
    Select(ID_win6, (void *)&win6);
}

void
SaveSubWindowsAttributes::SelectWin7()
{
    Select(ID_win7, (void *)&win7);
}

void
SaveSubWindowsAttributes::SelectWin8()
{
    Select(ID_win8, (void *)&win8);
}

void
SaveSubWindowsAttributes::SelectWin9()
{
    Select(ID_win9, (void *)&win9);
}

void
SaveSubWindowsAttributes::SelectWin10()
{
    Select(ID_win10, (void *)&win10);
}

void
SaveSubWindowsAttributes::SelectWin11()
{
    Select(ID_win11, (void *)&win11);
}

void
SaveSubWindowsAttributes::SelectWin12()
{
    Select(ID_win12, (void *)&win12);
}

void
SaveSubWindowsAttributes::SelectWin13()
{
    Select(ID_win13, (void *)&win13);
}

void
SaveSubWindowsAttributes::SelectWin14()
{
    Select(ID_win14, (void *)&win14);
}

void
SaveSubWindowsAttributes::SelectWin15()
{
    Select(ID_win15, (void *)&win15);
}

void
SaveSubWindowsAttributes::SelectWin16()
{
    Select(ID_win16, (void *)&win16);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: SaveSubWindowsAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
SaveSubWindowsAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_win1:  return "win1";
    case ID_win2:  return "win2";
    case ID_win3:  return "win3";
    case ID_win4:  return "win4";
    case ID_win5:  return "win5";
    case ID_win6:  return "win6";
    case ID_win7:  return "win7";
    case ID_win8:  return "win8";
    case ID_win9:  return "win9";
    case ID_win10: return "win10";
    case ID_win11: return "win11";
    case ID_win12: return "win12";
    case ID_win13: return "win13";
    case ID_win14: return "win14";
    case ID_win15: return "win15";
    case ID_win16: return "win16";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: SaveSubWindowsAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
SaveSubWindowsAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_win1:  return FieldType_att;
    case ID_win2:  return FieldType_att;
    case ID_win3:  return FieldType_att;
    case ID_win4:  return FieldType_att;
    case ID_win5:  return FieldType_att;
    case ID_win6:  return FieldType_att;
    case ID_win7:  return FieldType_att;
    case ID_win8:  return FieldType_att;
    case ID_win9:  return FieldType_att;
    case ID_win10: return FieldType_att;
    case ID_win11: return FieldType_att;
    case ID_win12: return FieldType_att;
    case ID_win13: return FieldType_att;
    case ID_win14: return FieldType_att;
    case ID_win15: return FieldType_att;
    case ID_win16: return FieldType_att;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: SaveSubWindowsAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
SaveSubWindowsAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_win1:  return "att";
    case ID_win2:  return "att";
    case ID_win3:  return "att";
    case ID_win4:  return "att";
    case ID_win5:  return "att";
    case ID_win6:  return "att";
    case ID_win7:  return "att";
    case ID_win8:  return "att";
    case ID_win9:  return "att";
    case ID_win10: return "att";
    case ID_win11: return "att";
    case ID_win12: return "att";
    case ID_win13: return "att";
    case ID_win14: return "att";
    case ID_win15: return "att";
    case ID_win16: return "att";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: SaveSubWindowsAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
SaveSubWindowsAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const SaveSubWindowsAttributes &obj = *((const SaveSubWindowsAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_win1:
        {  // new scope
        retval = (win1 == obj.win1);
        }
        break;
    case ID_win2:
        {  // new scope
        retval = (win2 == obj.win2);
        }
        break;
    case ID_win3:
        {  // new scope
        retval = (win3 == obj.win3);
        }
        break;
    case ID_win4:
        {  // new scope
        retval = (win4 == obj.win4);
        }
        break;
    case ID_win5:
        {  // new scope
        retval = (win5 == obj.win5);
        }
        break;
    case ID_win6:
        {  // new scope
        retval = (win6 == obj.win6);
        }
        break;
    case ID_win7:
        {  // new scope
        retval = (win7 == obj.win7);
        }
        break;
    case ID_win8:
        {  // new scope
        retval = (win8 == obj.win8);
        }
        break;
    case ID_win9:
        {  // new scope
        retval = (win9 == obj.win9);
        }
        break;
    case ID_win10:
        {  // new scope
        retval = (win10 == obj.win10);
        }
        break;
    case ID_win11:
        {  // new scope
        retval = (win11 == obj.win11);
        }
        break;
    case ID_win12:
        {  // new scope
        retval = (win12 == obj.win12);
        }
        break;
    case ID_win13:
        {  // new scope
        retval = (win13 == obj.win13);
        }
        break;
    case ID_win14:
        {  // new scope
        retval = (win14 == obj.win14);
        }
        break;
    case ID_win15:
        {  // new scope
        retval = (win15 == obj.win15);
        }
        break;
    case ID_win16:
        {  // new scope
        retval = (win16 == obj.win16);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

// *************************************************************
//  Method: SaveSubWindowAttributes::GetAttsForWindow
//
//  Purpose:
//      There are 16 window attributes in this class, each 
//      with their own name.  This is an easy way to access
//      them according to index.
//
//  Programmer: Hank Childs
//  Creation:   July 21, 2010
// 
// *************************************************************

SaveSubWindowAttributes &
SaveSubWindowsAttributes::GetAttsForWindow(int win)
{
    switch (win)
    {
        case 1:
          return GetWin1();
          break;
        case 2:
          return GetWin2();
          break;
        case 3:
          return GetWin3();
          break;
        case 4:
          return GetWin4();
          break;
        case 5:
          return GetWin5();
          break;
        case 6:
          return GetWin6();
          break;
        case 7:
          return GetWin7();
          break;
        case 8:
          return GetWin8();
          break;
        case 9:
          return GetWin9();
          break;
        case 10:
          return GetWin10();
          break;
        case 11:
          return GetWin11();
          break;
        case 12:
          return GetWin12();
          break;
        case 13:
          return GetWin13();
          break;
        case 14:
          return GetWin14();
          break;
        case 15:
          return GetWin15();
          break;
        case 16:
          return GetWin16();
          break;

    }

    EXCEPTION1(VisItException, "Window ID is out of range");
}

