/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <MultiCurveAttributes.h>
#include <DataNode.h>
#include <ColorControlPoint.h>

//
// Enum conversion methods for MultiCurveAttributes::ColoringMethod
//

static const char *ColoringMethod_strings[] = {
"ColorBySingleColor", "ColorByMultipleColors"};

std::string
MultiCurveAttributes::ColoringMethod_ToString(MultiCurveAttributes::ColoringMethod t)
{
    int index = int(t);
    if(index < 0 || index >= 2) index = 0;
    return ColoringMethod_strings[index];
}

std::string
MultiCurveAttributes::ColoringMethod_ToString(int t)
{
    int index = (t < 0 || t >= 2) ? 0 : t;
    return ColoringMethod_strings[index];
}

bool
MultiCurveAttributes::ColoringMethod_FromString(const std::string &s, MultiCurveAttributes::ColoringMethod &val)
{
    val = MultiCurveAttributes::ColorBySingleColor;
    for(int i = 0; i < 2; ++i)
    {
        if(s == ColoringMethod_strings[i])
        {
            val = (ColoringMethod)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: MultiCurveAttributes::MultiCurveAttributes
//
// Purpose: 
//   Init utility for the MultiCurveAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void MultiCurveAttributes::Init()
{
    colorType = ColorByMultipleColors;
    lineWidth = 0;
    yAxisTitleFormat = "%g";
    useYAxisTickSpacing = false;
    yAxisTickSpacing = 1;
    displayMarkers = true;
    markerScale = 1;
    markerLineWidth = 0;
    markerVariable = "default";
    displayIds = false;
    idVariable = "default";
    legendFlag = true;

    MultiCurveAttributes::SelectAll();
}

// ****************************************************************************
// Method: MultiCurveAttributes::MultiCurveAttributes
//
// Purpose: 
//   Copy utility for the MultiCurveAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void MultiCurveAttributes::Copy(const MultiCurveAttributes &obj)
{
    defaultPalette = obj.defaultPalette;
    changedColors = obj.changedColors;
    colorType = obj.colorType;
    singleColor = obj.singleColor;
    multiColor = obj.multiColor;
    lineWidth = obj.lineWidth;
    yAxisTitleFormat = obj.yAxisTitleFormat;
    useYAxisTickSpacing = obj.useYAxisTickSpacing;
    yAxisTickSpacing = obj.yAxisTickSpacing;
    displayMarkers = obj.displayMarkers;
    markerScale = obj.markerScale;
    markerLineWidth = obj.markerLineWidth;
    markerVariable = obj.markerVariable;
    displayIds = obj.displayIds;
    idVariable = obj.idVariable;
    legendFlag = obj.legendFlag;

    MultiCurveAttributes::SelectAll();
}

// Type map format string
const char *MultiCurveAttributes::TypeMapFormatString = MULTICURVEATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t MultiCurveAttributes::TmfsStruct = {MULTICURVEATTRIBUTES_TMFS};


// ****************************************************************************
// Method: MultiCurveAttributes::MultiCurveAttributes
//
// Purpose: 
//   Default constructor for the MultiCurveAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

MultiCurveAttributes::MultiCurveAttributes() : 
    AttributeSubject(MultiCurveAttributes::TypeMapFormatString),
    singleColor(255, 0, 0)
{
    MultiCurveAttributes::Init();
}

// ****************************************************************************
// Method: MultiCurveAttributes::MultiCurveAttributes
//
// Purpose: 
//   Constructor for the derived classes of MultiCurveAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

MultiCurveAttributes::MultiCurveAttributes(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs),
    singleColor(255, 0, 0)
{
    MultiCurveAttributes::Init();
}

// ****************************************************************************
// Method: MultiCurveAttributes::MultiCurveAttributes
//
// Purpose: 
//   Copy constructor for the MultiCurveAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

MultiCurveAttributes::MultiCurveAttributes(const MultiCurveAttributes &obj) : 
    AttributeSubject(MultiCurveAttributes::TypeMapFormatString)
{
    MultiCurveAttributes::Copy(obj);
}

// ****************************************************************************
// Method: MultiCurveAttributes::MultiCurveAttributes
//
// Purpose: 
//   Copy constructor for derived classes of the MultiCurveAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

MultiCurveAttributes::MultiCurveAttributes(const MultiCurveAttributes &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    MultiCurveAttributes::Copy(obj);
}

// ****************************************************************************
// Method: MultiCurveAttributes::~MultiCurveAttributes
//
// Purpose: 
//   Destructor for the MultiCurveAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

MultiCurveAttributes::~MultiCurveAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: MultiCurveAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the MultiCurveAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

MultiCurveAttributes& 
MultiCurveAttributes::operator = (const MultiCurveAttributes &obj)
{
    if (this == &obj) return *this;

    MultiCurveAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: MultiCurveAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the MultiCurveAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
MultiCurveAttributes::operator == (const MultiCurveAttributes &obj) const
{
    // Create the return value
    return (true /* can ignore defaultPalette */ &&
            true /* can ignore changedColors */ &&
            (colorType == obj.colorType) &&
            (singleColor == obj.singleColor) &&
            (multiColor == obj.multiColor) &&
            (lineWidth == obj.lineWidth) &&
            (yAxisTitleFormat == obj.yAxisTitleFormat) &&
            (useYAxisTickSpacing == obj.useYAxisTickSpacing) &&
            (yAxisTickSpacing == obj.yAxisTickSpacing) &&
            (displayMarkers == obj.displayMarkers) &&
            (markerScale == obj.markerScale) &&
            (markerLineWidth == obj.markerLineWidth) &&
            (markerVariable == obj.markerVariable) &&
            (displayIds == obj.displayIds) &&
            (idVariable == obj.idVariable) &&
            (legendFlag == obj.legendFlag));
}

// ****************************************************************************
// Method: MultiCurveAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the MultiCurveAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
MultiCurveAttributes::operator != (const MultiCurveAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: MultiCurveAttributes::TypeName
//
// Purpose: 
//   Type name method for the MultiCurveAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
MultiCurveAttributes::TypeName() const
{
    return "MultiCurveAttributes";
}

// ****************************************************************************
// Method: MultiCurveAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the MultiCurveAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
MultiCurveAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const MultiCurveAttributes *tmp = (const MultiCurveAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: MultiCurveAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the MultiCurveAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
MultiCurveAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new MultiCurveAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: MultiCurveAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the MultiCurveAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
MultiCurveAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new MultiCurveAttributes(*this);
    else
        retval = new MultiCurveAttributes;

    return retval;
}

// ****************************************************************************
// Method: MultiCurveAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
MultiCurveAttributes::SelectAll()
{
    Select(ID_defaultPalette,      (void *)&defaultPalette);
    Select(ID_changedColors,       (void *)&changedColors);
    Select(ID_colorType,           (void *)&colorType);
    Select(ID_singleColor,         (void *)&singleColor);
    Select(ID_multiColor,          (void *)&multiColor);
    Select(ID_lineWidth,           (void *)&lineWidth);
    Select(ID_yAxisTitleFormat,    (void *)&yAxisTitleFormat);
    Select(ID_useYAxisTickSpacing, (void *)&useYAxisTickSpacing);
    Select(ID_yAxisTickSpacing,    (void *)&yAxisTickSpacing);
    Select(ID_displayMarkers,      (void *)&displayMarkers);
    Select(ID_markerScale,         (void *)&markerScale);
    Select(ID_markerLineWidth,     (void *)&markerLineWidth);
    Select(ID_markerVariable,      (void *)&markerVariable);
    Select(ID_displayIds,          (void *)&displayIds);
    Select(ID_idVariable,          (void *)&idVariable);
    Select(ID_legendFlag,          (void *)&legendFlag);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: MultiCurveAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
MultiCurveAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    MultiCurveAttributes defaultObject;
    bool addToParent = false;
    // Create a node for MultiCurveAttributes.
    DataNode *node = new DataNode("MultiCurveAttributes");

    if(completeSave || !FieldsEqual(ID_defaultPalette, &defaultObject))
    {
        DataNode *defaultPaletteNode = new DataNode("defaultPalette");
        if(defaultPalette.CreateNode(defaultPaletteNode, completeSave, false))
        {
            addToParent = true;
            node->AddNode(defaultPaletteNode);
        }
        else
            delete defaultPaletteNode;
    }

    if(completeSave || !FieldsEqual(ID_changedColors, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("changedColors", changedColors));
    }

    if(completeSave || !FieldsEqual(ID_colorType, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("colorType", ColoringMethod_ToString(colorType)));
    }

        DataNode *singleColorNode = new DataNode("singleColor");
        if(singleColor.CreateNode(singleColorNode, completeSave, true))
        {
            addToParent = true;
            node->AddNode(singleColorNode);
        }
        else
            delete singleColorNode;
    if(completeSave || !FieldsEqual(ID_multiColor, &defaultObject))
    {
        DataNode *multiColorNode = new DataNode("multiColor");
        if(multiColor.CreateNode(multiColorNode, completeSave, false))
        {
            addToParent = true;
            node->AddNode(multiColorNode);
        }
        else
            delete multiColorNode;
    }

    if(completeSave || !FieldsEqual(ID_lineWidth, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("lineWidth", lineWidth));
    }

    if(completeSave || !FieldsEqual(ID_yAxisTitleFormat, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("yAxisTitleFormat", yAxisTitleFormat));
    }

    if(completeSave || !FieldsEqual(ID_useYAxisTickSpacing, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("useYAxisTickSpacing", useYAxisTickSpacing));
    }

    if(completeSave || !FieldsEqual(ID_yAxisTickSpacing, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("yAxisTickSpacing", yAxisTickSpacing));
    }

    if(completeSave || !FieldsEqual(ID_displayMarkers, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("displayMarkers", displayMarkers));
    }

    if(completeSave || !FieldsEqual(ID_markerScale, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("markerScale", markerScale));
    }

    if(completeSave || !FieldsEqual(ID_markerLineWidth, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("markerLineWidth", markerLineWidth));
    }

    if(completeSave || !FieldsEqual(ID_markerVariable, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("markerVariable", markerVariable));
    }

    if(completeSave || !FieldsEqual(ID_displayIds, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("displayIds", displayIds));
    }

    if(completeSave || !FieldsEqual(ID_idVariable, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("idVariable", idVariable));
    }

    if(completeSave || !FieldsEqual(ID_legendFlag, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("legendFlag", legendFlag));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: MultiCurveAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
MultiCurveAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("MultiCurveAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("defaultPalette")) != 0)
        defaultPalette.SetFromNode(node);
    if((node = searchNode->GetNode("changedColors")) != 0)
        SetChangedColors(node->AsUnsignedCharVector());
    if((node = searchNode->GetNode("colorType")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 2)
                SetColorType(ColoringMethod(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            ColoringMethod value;
            if(ColoringMethod_FromString(node->AsString(), value))
                SetColorType(value);
        }
    }
    if((node = searchNode->GetNode("singleColor")) != 0)
        singleColor.SetFromNode(node);
    if((node = searchNode->GetNode("multiColor")) != 0)
        multiColor.SetFromNode(node);
    if((node = searchNode->GetNode("lineWidth")) != 0)
        SetLineWidth(node->AsInt());
    if((node = searchNode->GetNode("yAxisTitleFormat")) != 0)
        SetYAxisTitleFormat(node->AsString());
    if((node = searchNode->GetNode("useYAxisTickSpacing")) != 0)
        SetUseYAxisTickSpacing(node->AsBool());
    if((node = searchNode->GetNode("yAxisTickSpacing")) != 0)
        SetYAxisTickSpacing(node->AsDouble());
    if((node = searchNode->GetNode("displayMarkers")) != 0)
        SetDisplayMarkers(node->AsBool());
    if((node = searchNode->GetNode("markerScale")) != 0)
        SetMarkerScale(node->AsDouble());
    if((node = searchNode->GetNode("markerLineWidth")) != 0)
        SetMarkerLineWidth(node->AsInt());
    if((node = searchNode->GetNode("markerVariable")) != 0)
        SetMarkerVariable(node->AsString());
    if((node = searchNode->GetNode("displayIds")) != 0)
        SetDisplayIds(node->AsBool());
    if((node = searchNode->GetNode("idVariable")) != 0)
        SetIdVariable(node->AsString());
    if((node = searchNode->GetNode("legendFlag")) != 0)
        SetLegendFlag(node->AsBool());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
MultiCurveAttributes::SetDefaultPalette(const ColorControlPointList &defaultPalette_)
{
    defaultPalette = defaultPalette_;
    Select(ID_defaultPalette, (void *)&defaultPalette);
}

void
MultiCurveAttributes::SetChangedColors(const unsignedCharVector &changedColors_)
{
    changedColors = changedColors_;
    Select(ID_changedColors, (void *)&changedColors);
}

void
MultiCurveAttributes::SetColorType(MultiCurveAttributes::ColoringMethod colorType_)
{
    colorType = colorType_;
    Select(ID_colorType, (void *)&colorType);
}

void
MultiCurveAttributes::SetSingleColor(const ColorAttribute &singleColor_)
{
    singleColor = singleColor_;
    Select(ID_singleColor, (void *)&singleColor);
}

void
MultiCurveAttributes::SetMultiColor(const ColorAttributeList &multiColor_)
{
    multiColor = multiColor_;
    Select(ID_multiColor, (void *)&multiColor);
}

void
MultiCurveAttributes::SetLineWidth(int lineWidth_)
{
    lineWidth = lineWidth_;
    Select(ID_lineWidth, (void *)&lineWidth);
}

void
MultiCurveAttributes::SetYAxisTitleFormat(const std::string &yAxisTitleFormat_)
{
    yAxisTitleFormat = yAxisTitleFormat_;
    Select(ID_yAxisTitleFormat, (void *)&yAxisTitleFormat);
}

void
MultiCurveAttributes::SetUseYAxisTickSpacing(bool useYAxisTickSpacing_)
{
    useYAxisTickSpacing = useYAxisTickSpacing_;
    Select(ID_useYAxisTickSpacing, (void *)&useYAxisTickSpacing);
}

void
MultiCurveAttributes::SetYAxisTickSpacing(double yAxisTickSpacing_)
{
    yAxisTickSpacing = yAxisTickSpacing_;
    Select(ID_yAxisTickSpacing, (void *)&yAxisTickSpacing);
}

void
MultiCurveAttributes::SetDisplayMarkers(bool displayMarkers_)
{
    displayMarkers = displayMarkers_;
    Select(ID_displayMarkers, (void *)&displayMarkers);
}

void
MultiCurveAttributes::SetMarkerScale(double markerScale_)
{
    markerScale = markerScale_;
    Select(ID_markerScale, (void *)&markerScale);
}

void
MultiCurveAttributes::SetMarkerLineWidth(int markerLineWidth_)
{
    markerLineWidth = markerLineWidth_;
    Select(ID_markerLineWidth, (void *)&markerLineWidth);
}

void
MultiCurveAttributes::SetMarkerVariable(const std::string &markerVariable_)
{
    markerVariable = markerVariable_;
    Select(ID_markerVariable, (void *)&markerVariable);
}

void
MultiCurveAttributes::SetDisplayIds(bool displayIds_)
{
    displayIds = displayIds_;
    Select(ID_displayIds, (void *)&displayIds);
}

void
MultiCurveAttributes::SetIdVariable(const std::string &idVariable_)
{
    idVariable = idVariable_;
    Select(ID_idVariable, (void *)&idVariable);
}

void
MultiCurveAttributes::SetLegendFlag(bool legendFlag_)
{
    legendFlag = legendFlag_;
    Select(ID_legendFlag, (void *)&legendFlag);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const ColorControlPointList &
MultiCurveAttributes::GetDefaultPalette() const
{
    return defaultPalette;
}

ColorControlPointList &
MultiCurveAttributes::GetDefaultPalette()
{
    return defaultPalette;
}

const unsignedCharVector &
MultiCurveAttributes::GetChangedColors() const
{
    return changedColors;
}

unsignedCharVector &
MultiCurveAttributes::GetChangedColors()
{
    return changedColors;
}

MultiCurveAttributes::ColoringMethod
MultiCurveAttributes::GetColorType() const
{
    return ColoringMethod(colorType);
}

const ColorAttribute &
MultiCurveAttributes::GetSingleColor() const
{
    return singleColor;
}

ColorAttribute &
MultiCurveAttributes::GetSingleColor()
{
    return singleColor;
}

const ColorAttributeList &
MultiCurveAttributes::GetMultiColor() const
{
    return multiColor;
}

ColorAttributeList &
MultiCurveAttributes::GetMultiColor()
{
    return multiColor;
}

int
MultiCurveAttributes::GetLineWidth() const
{
    return lineWidth;
}

const std::string &
MultiCurveAttributes::GetYAxisTitleFormat() const
{
    return yAxisTitleFormat;
}

std::string &
MultiCurveAttributes::GetYAxisTitleFormat()
{
    return yAxisTitleFormat;
}

bool
MultiCurveAttributes::GetUseYAxisTickSpacing() const
{
    return useYAxisTickSpacing;
}

double
MultiCurveAttributes::GetYAxisTickSpacing() const
{
    return yAxisTickSpacing;
}

bool
MultiCurveAttributes::GetDisplayMarkers() const
{
    return displayMarkers;
}

double
MultiCurveAttributes::GetMarkerScale() const
{
    return markerScale;
}

int
MultiCurveAttributes::GetMarkerLineWidth() const
{
    return markerLineWidth;
}

const std::string &
MultiCurveAttributes::GetMarkerVariable() const
{
    return markerVariable;
}

std::string &
MultiCurveAttributes::GetMarkerVariable()
{
    return markerVariable;
}

bool
MultiCurveAttributes::GetDisplayIds() const
{
    return displayIds;
}

const std::string &
MultiCurveAttributes::GetIdVariable() const
{
    return idVariable;
}

std::string &
MultiCurveAttributes::GetIdVariable()
{
    return idVariable;
}

bool
MultiCurveAttributes::GetLegendFlag() const
{
    return legendFlag;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
MultiCurveAttributes::SelectDefaultPalette()
{
    Select(ID_defaultPalette, (void *)&defaultPalette);
}

void
MultiCurveAttributes::SelectChangedColors()
{
    Select(ID_changedColors, (void *)&changedColors);
}

void
MultiCurveAttributes::SelectSingleColor()
{
    Select(ID_singleColor, (void *)&singleColor);
}

void
MultiCurveAttributes::SelectMultiColor()
{
    Select(ID_multiColor, (void *)&multiColor);
}

void
MultiCurveAttributes::SelectYAxisTitleFormat()
{
    Select(ID_yAxisTitleFormat, (void *)&yAxisTitleFormat);
}

void
MultiCurveAttributes::SelectMarkerVariable()
{
    Select(ID_markerVariable, (void *)&markerVariable);
}

void
MultiCurveAttributes::SelectIdVariable()
{
    Select(ID_idVariable, (void *)&idVariable);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: MultiCurveAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
MultiCurveAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_defaultPalette:      return "defaultPalette";
    case ID_changedColors:       return "changedColors";
    case ID_colorType:           return "colorType";
    case ID_singleColor:         return "singleColor";
    case ID_multiColor:          return "multiColor";
    case ID_lineWidth:           return "lineWidth";
    case ID_yAxisTitleFormat:    return "yAxisTitleFormat";
    case ID_useYAxisTickSpacing: return "useYAxisTickSpacing";
    case ID_yAxisTickSpacing:    return "yAxisTickSpacing";
    case ID_displayMarkers:      return "displayMarkers";
    case ID_markerScale:         return "markerScale";
    case ID_markerLineWidth:     return "markerLineWidth";
    case ID_markerVariable:      return "markerVariable";
    case ID_displayIds:          return "displayIds";
    case ID_idVariable:          return "idVariable";
    case ID_legendFlag:          return "legendFlag";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: MultiCurveAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
MultiCurveAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_defaultPalette:      return FieldType_att;
    case ID_changedColors:       return FieldType_ucharVector;
    case ID_colorType:           return FieldType_enum;
    case ID_singleColor:         return FieldType_color;
    case ID_multiColor:          return FieldType_att;
    case ID_lineWidth:           return FieldType_linewidth;
    case ID_yAxisTitleFormat:    return FieldType_string;
    case ID_useYAxisTickSpacing: return FieldType_bool;
    case ID_yAxisTickSpacing:    return FieldType_double;
    case ID_displayMarkers:      return FieldType_bool;
    case ID_markerScale:         return FieldType_double;
    case ID_markerLineWidth:     return FieldType_linewidth;
    case ID_markerVariable:      return FieldType_string;
    case ID_displayIds:          return FieldType_bool;
    case ID_idVariable:          return FieldType_string;
    case ID_legendFlag:          return FieldType_bool;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: MultiCurveAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
MultiCurveAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_defaultPalette:      return "att";
    case ID_changedColors:       return "ucharVector";
    case ID_colorType:           return "enum";
    case ID_singleColor:         return "color";
    case ID_multiColor:          return "att";
    case ID_lineWidth:           return "linewidth";
    case ID_yAxisTitleFormat:    return "string";
    case ID_useYAxisTickSpacing: return "bool";
    case ID_yAxisTickSpacing:    return "double";
    case ID_displayMarkers:      return "bool";
    case ID_markerScale:         return "double";
    case ID_markerLineWidth:     return "linewidth";
    case ID_markerVariable:      return "string";
    case ID_displayIds:          return "bool";
    case ID_idVariable:          return "string";
    case ID_legendFlag:          return "bool";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: MultiCurveAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
MultiCurveAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const MultiCurveAttributes &obj = *((const MultiCurveAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_defaultPalette:
        {  // new scope
        retval = (defaultPalette == obj.defaultPalette);
        }
        break;
    case ID_changedColors:
        {  // new scope
        retval = (changedColors == obj.changedColors);
        }
        break;
    case ID_colorType:
        {  // new scope
        retval = (colorType == obj.colorType);
        }
        break;
    case ID_singleColor:
        {  // new scope
        retval = (singleColor == obj.singleColor);
        }
        break;
    case ID_multiColor:
        {  // new scope
        retval = (multiColor == obj.multiColor);
        }
        break;
    case ID_lineWidth:
        {  // new scope
        retval = (lineWidth == obj.lineWidth);
        }
        break;
    case ID_yAxisTitleFormat:
        {  // new scope
        retval = (yAxisTitleFormat == obj.yAxisTitleFormat);
        }
        break;
    case ID_useYAxisTickSpacing:
        {  // new scope
        retval = (useYAxisTickSpacing == obj.useYAxisTickSpacing);
        }
        break;
    case ID_yAxisTickSpacing:
        {  // new scope
        retval = (yAxisTickSpacing == obj.yAxisTickSpacing);
        }
        break;
    case ID_displayMarkers:
        {  // new scope
        retval = (displayMarkers == obj.displayMarkers);
        }
        break;
    case ID_markerScale:
        {  // new scope
        retval = (markerScale == obj.markerScale);
        }
        break;
    case ID_markerLineWidth:
        {  // new scope
        retval = (markerLineWidth == obj.markerLineWidth);
        }
        break;
    case ID_markerVariable:
        {  // new scope
        retval = (markerVariable == obj.markerVariable);
        }
        break;
    case ID_displayIds:
        {  // new scope
        retval = (displayIds == obj.displayIds);
        }
        break;
    case ID_idVariable:
        {  // new scope
        retval = (idVariable == obj.idVariable);
        }
        break;
    case ID_legendFlag:
        {  // new scope
        retval = (legendFlag == obj.legendFlag);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: MultiCurveAttributes::EnlargeMultiColor
//
// Purpose:
//   Enlarges the multiColor vector to the new size.
//
// Arguments:
//   newSize    The new size of the color vector.
//
// Programmer: Eric Brugger
// Creation:   December 9, 2008
//
// Modifications:
//
// ****************************************************************************

void
MultiCurveAttributes::EnlargeMultiColor(int newSize)
{
    // Add any colors that are needed to the end of the vector to ensure
    // we have the right number of elements in the vector.
    if(newSize > 0)
    {
        unsigned char *rgb = new unsigned char[newSize * 4];

        // If it's a discrete color table, just use the colors of
        // the control points. Otherwise, sample the color table.
        if(defaultPalette.GetDiscreteFlag())
        {
            int nColors = defaultPalette.GetNumControlPoints();
            for(int i = 0, index = 0; i < newSize; ++i, index += 4)
            {
                int j = i % nColors;
                const ColorControlPoint &ccp = defaultPalette.operator[](j);
                const unsigned char *c = ccp.GetColors();
                rgb[index] = c[0];
                rgb[index+1] = c[1];
                rgb[index+2] = c[2];
                rgb[index+3] = c[3];
            }
        }
        else
        {
            defaultPalette.GetColors(rgb, newSize);
        }

        bool modified = false;
        for(int i = 0; i < newSize; ++i)
        {
            int j = i * 4;
            if(i < multiColor.GetNumColors())
            {
                if(!ColorIsChanged(i))
                {
                    ColorAttribute &ca = multiColor.GetColors(i);
                    ca.SetRgba(int(rgb[j]), int(rgb[j+1]), int(rgb[j+2]),int(rgb[j+3]));
                }
            }
            else
            {
                multiColor.AddColors(ColorAttribute(rgb[j],
                                                    rgb[j+1],
                                                    rgb[j+2],
                                                    rgb[j+3]));
            }
            modified = true;
        }
        delete [] rgb;

        // If the multiColor vector was modified, select it.
        if(modified)
            SelectMultiColor();
    }
}

// ****************************************************************************
// Method: MultiCurveAttributes::ColorIsChanged
//
// Purpose:
//   Returns whether or not a color has been modified.
//
// Arguments:
//   index      A color index.
//
// Programmer: Eric Brugger
// Creation:   December 9, 2008
//
// Modifications:
//
// ***************************************************************************
bool
MultiCurveAttributes::ColorIsChanged(int index) const
{
    size_t i = 0;
    for(; i < changedColors.size(); ++i)
    {
        if(changedColors[i] == ((unsigned char)index))
            break;
    }

    return (i < changedColors.size());
}

// ****************************************************************************
// Method: MultiCurveAttributes::MarkColorAsChanged
//
// Purpose:
//   Marks a color as having been modified.
//
// Arguments:
//   index      A color index.
//
// Programmer: Eric Brugger
// Creation:   December 9, 2008
//
// Modifications:
//
// ****************************************************************************
void
MultiCurveAttributes::MarkColorAsChanged(int index)
{
    if(!ColorIsChanged(index))
    {
        changedColors.push_back(((unsigned char)index));
        SelectChangedColors();
    }
}

// ****************************************************************************
// Method: MultiCurveAttributes::ChangesRequireRecalculation
//
// Purpose:
//   Returns a boolean indicating if the changes to the attributes require
//   a pipeline re-execution.
//
// Arguments:
//   obj        The new attributes.
//
// Programmer: Eric Brugger
// Creation:   December 9, 2008
//
// Modifications:
//   Eric Brugger, Wed Jan 21 08:07:40 PST 2009
//   I added yAxisTitleFormat, useYAxisRange, and yAxisRange.
//
//   Eric Brugger, Tue Feb 17 18:03:08 PST 2009
//   I added idVariable.
//
//   Eric Brugger, Thu Mar  5 17:54:39 PST 2009
//   I replaced useYAxisRange and yAxisRange with useYAxisTickSpacing and
//   yAxisTickSpacing.
//
// ****************************************************************************
bool
MultiCurveAttributes::ChangesRequireRecalculation(const MultiCurveAttributes &obj) const
{
    if (yAxisTitleFormat != obj.yAxisTitleFormat ||
        useYAxisTickSpacing != obj.useYAxisTickSpacing ||
        yAxisTickSpacing != obj.yAxisTickSpacing ||
        markerVariable != obj.markerVariable ||
        idVariable != obj.idVariable)
        return true;

    return false;
}

