/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

// ************************************************************************* //
//                       PlotDimensionalityException.C                       //
// ************************************************************************* //

#include <stdio.h>  // for sprintf
#include <PlotDimensionalityException.h>


// ****************************************************************************
//  Method: PlotDimensionalityException constructor
//
//  Programmer: Hank Childs
//  Creation:   May 16, 2000
//
//  Modifications:
//    Kathleen Bonnell, Tue May  7 08:33:54 PDT 2002
//    Added WINMODE_CURVE.  
//
//    Jeremy Meredith, Mon Jan 28 17:39:51 EST 2008
//    Added WINMODE_AXISARRAY.
//
// ****************************************************************************

PlotDimensionalityException::PlotDimensionalityException(WINDOW_MODE oldMode,
                               WINDOW_MODE newMode, int numPlots)
{
    std::string  oldModeS;
    switch (oldMode)
    {
      case WINMODE_2D:
        oldModeS = "2D";
        break;
      case WINMODE_3D:
        oldModeS = "3D";
        break;
      case WINMODE_CURVE:
        oldModeS = "Curve";
        break;
      case WINMODE_AXISARRAY:
        oldModeS = "AxisArray";
        break;
      case WINMODE_NONE:
        oldModeS = "None";
        break;
      default:
        oldModeS = "Unaccounted For Mode";
        break;
    };

    std::string  newModeS;
    switch (newMode)
    {
      case WINMODE_2D:
        newModeS = "2D";
        break;
      case WINMODE_3D:
        newModeS = "3D";
        break;
      case WINMODE_CURVE:
        newModeS = "Curve";
        break;
      case WINMODE_AXISARRAY:
        newModeS = "AxisArray";
        break;
      case WINMODE_NONE:
        newModeS = "None";
        break;
      default:
        newModeS = "Unaccounted For Mode";
        break;
    };

    char  numPlotsString[30];
    sprintf(numPlotsString, "%d", numPlots);
    msg = "Tried to enter mode " + newModeS + " when there were " 
          + numPlotsString + " plots of dimension " + oldModeS;
}


