/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <TubeAttributes.h>
#include <DataNode.h>

//
// Enum conversion methods for TubeAttributes::TubeRadiusType
//

static const char *TubeRadiusType_strings[] = {
"FractionOfBBox", "Absolute"};

std::string
TubeAttributes::TubeRadiusType_ToString(TubeAttributes::TubeRadiusType t)
{
    int index = int(t);
    if(index < 0 || index >= 2) index = 0;
    return TubeRadiusType_strings[index];
}

std::string
TubeAttributes::TubeRadiusType_ToString(int t)
{
    int index = (t < 0 || t >= 2) ? 0 : t;
    return TubeRadiusType_strings[index];
}

bool
TubeAttributes::TubeRadiusType_FromString(const std::string &s, TubeAttributes::TubeRadiusType &val)
{
    val = TubeAttributes::FractionOfBBox;
    for(int i = 0; i < 2; ++i)
    {
        if(s == TubeRadiusType_strings[i])
        {
            val = (TubeRadiusType)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: TubeAttributes::TubeAttributes
//
// Purpose: 
//   Init utility for the TubeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void TubeAttributes::Init()
{
    scaleByVarFlag = false;
    tubeRadiusType = FractionOfBBox;
    radiusFractionBBox = 0.01;
    radiusAbsolute = 1;
    fineness = 5;
    capping = false;

    TubeAttributes::SelectAll();
}

// ****************************************************************************
// Method: TubeAttributes::TubeAttributes
//
// Purpose: 
//   Copy utility for the TubeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void TubeAttributes::Copy(const TubeAttributes &obj)
{
    scaleByVarFlag = obj.scaleByVarFlag;
    tubeRadiusType = obj.tubeRadiusType;
    radiusFractionBBox = obj.radiusFractionBBox;
    radiusAbsolute = obj.radiusAbsolute;
    scaleVariable = obj.scaleVariable;
    fineness = obj.fineness;
    capping = obj.capping;

    TubeAttributes::SelectAll();
}

// Type map format string
const char *TubeAttributes::TypeMapFormatString = TUBEATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t TubeAttributes::TmfsStruct = {TUBEATTRIBUTES_TMFS};


// ****************************************************************************
// Method: TubeAttributes::TubeAttributes
//
// Purpose: 
//   Default constructor for the TubeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

TubeAttributes::TubeAttributes() : 
    AttributeSubject(TubeAttributes::TypeMapFormatString),
    scaleVariable("default")
{
    TubeAttributes::Init();
}

// ****************************************************************************
// Method: TubeAttributes::TubeAttributes
//
// Purpose: 
//   Constructor for the derived classes of TubeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

TubeAttributes::TubeAttributes(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs),
    scaleVariable("default")
{
    TubeAttributes::Init();
}

// ****************************************************************************
// Method: TubeAttributes::TubeAttributes
//
// Purpose: 
//   Copy constructor for the TubeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

TubeAttributes::TubeAttributes(const TubeAttributes &obj) : 
    AttributeSubject(TubeAttributes::TypeMapFormatString)
{
    TubeAttributes::Copy(obj);
}

// ****************************************************************************
// Method: TubeAttributes::TubeAttributes
//
// Purpose: 
//   Copy constructor for derived classes of the TubeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

TubeAttributes::TubeAttributes(const TubeAttributes &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    TubeAttributes::Copy(obj);
}

// ****************************************************************************
// Method: TubeAttributes::~TubeAttributes
//
// Purpose: 
//   Destructor for the TubeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

TubeAttributes::~TubeAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: TubeAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the TubeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

TubeAttributes& 
TubeAttributes::operator = (const TubeAttributes &obj)
{
    if (this == &obj) return *this;

    TubeAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: TubeAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the TubeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
TubeAttributes::operator == (const TubeAttributes &obj) const
{
    // Create the return value
    return ((scaleByVarFlag == obj.scaleByVarFlag) &&
            (tubeRadiusType == obj.tubeRadiusType) &&
            (radiusFractionBBox == obj.radiusFractionBBox) &&
            (radiusAbsolute == obj.radiusAbsolute) &&
            (scaleVariable == obj.scaleVariable) &&
            (fineness == obj.fineness) &&
            (capping == obj.capping));
}

// ****************************************************************************
// Method: TubeAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the TubeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
TubeAttributes::operator != (const TubeAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: TubeAttributes::TypeName
//
// Purpose: 
//   Type name method for the TubeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
TubeAttributes::TypeName() const
{
    return "TubeAttributes";
}

// ****************************************************************************
// Method: TubeAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the TubeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
TubeAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const TubeAttributes *tmp = (const TubeAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: TubeAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the TubeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
TubeAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new TubeAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: TubeAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the TubeAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
TubeAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new TubeAttributes(*this);
    else
        retval = new TubeAttributes;

    return retval;
}

// ****************************************************************************
// Method: TubeAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
TubeAttributes::SelectAll()
{
    Select(ID_scaleByVarFlag,     (void *)&scaleByVarFlag);
    Select(ID_tubeRadiusType,     (void *)&tubeRadiusType);
    Select(ID_radiusFractionBBox, (void *)&radiusFractionBBox);
    Select(ID_radiusAbsolute,     (void *)&radiusAbsolute);
    Select(ID_scaleVariable,      (void *)&scaleVariable);
    Select(ID_fineness,           (void *)&fineness);
    Select(ID_capping,            (void *)&capping);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: TubeAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
TubeAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    TubeAttributes defaultObject;
    bool addToParent = false;
    // Create a node for TubeAttributes.
    DataNode *node = new DataNode("TubeAttributes");

    if(completeSave || !FieldsEqual(ID_scaleByVarFlag, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("scaleByVarFlag", scaleByVarFlag));
    }

    if(completeSave || !FieldsEqual(ID_tubeRadiusType, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("tubeRadiusType", TubeRadiusType_ToString(tubeRadiusType)));
    }

    if(completeSave || !FieldsEqual(ID_radiusFractionBBox, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("radiusFractionBBox", radiusFractionBBox));
    }

    if(completeSave || !FieldsEqual(ID_radiusAbsolute, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("radiusAbsolute", radiusAbsolute));
    }

    if(completeSave || !FieldsEqual(ID_scaleVariable, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("scaleVariable", scaleVariable));
    }

    if(completeSave || !FieldsEqual(ID_fineness, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("fineness", fineness));
    }

    if(completeSave || !FieldsEqual(ID_capping, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("capping", capping));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: TubeAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
TubeAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("TubeAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("scaleByVarFlag")) != 0)
        SetScaleByVarFlag(node->AsBool());
    if((node = searchNode->GetNode("tubeRadiusType")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 2)
                SetTubeRadiusType(TubeRadiusType(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            TubeRadiusType value;
            if(TubeRadiusType_FromString(node->AsString(), value))
                SetTubeRadiusType(value);
        }
    }
    if((node = searchNode->GetNode("radiusFractionBBox")) != 0)
        SetRadiusFractionBBox(node->AsDouble());
    if((node = searchNode->GetNode("radiusAbsolute")) != 0)
        SetRadiusAbsolute(node->AsDouble());
    if((node = searchNode->GetNode("scaleVariable")) != 0)
        SetScaleVariable(node->AsString());
    if((node = searchNode->GetNode("fineness")) != 0)
        SetFineness(node->AsInt());
    if((node = searchNode->GetNode("capping")) != 0)
        SetCapping(node->AsBool());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
TubeAttributes::SetScaleByVarFlag(bool scaleByVarFlag_)
{
    scaleByVarFlag = scaleByVarFlag_;
    Select(ID_scaleByVarFlag, (void *)&scaleByVarFlag);
}

void
TubeAttributes::SetTubeRadiusType(TubeAttributes::TubeRadiusType tubeRadiusType_)
{
    tubeRadiusType = tubeRadiusType_;
    Select(ID_tubeRadiusType, (void *)&tubeRadiusType);
}

void
TubeAttributes::SetRadiusFractionBBox(double radiusFractionBBox_)
{
    radiusFractionBBox = radiusFractionBBox_;
    Select(ID_radiusFractionBBox, (void *)&radiusFractionBBox);
}

void
TubeAttributes::SetRadiusAbsolute(double radiusAbsolute_)
{
    radiusAbsolute = radiusAbsolute_;
    Select(ID_radiusAbsolute, (void *)&radiusAbsolute);
}

void
TubeAttributes::SetScaleVariable(const std::string &scaleVariable_)
{
    scaleVariable = scaleVariable_;
    Select(ID_scaleVariable, (void *)&scaleVariable);
}

void
TubeAttributes::SetFineness(int fineness_)
{
    fineness = fineness_;
    Select(ID_fineness, (void *)&fineness);
}

void
TubeAttributes::SetCapping(bool capping_)
{
    capping = capping_;
    Select(ID_capping, (void *)&capping);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

bool
TubeAttributes::GetScaleByVarFlag() const
{
    return scaleByVarFlag;
}

TubeAttributes::TubeRadiusType
TubeAttributes::GetTubeRadiusType() const
{
    return TubeRadiusType(tubeRadiusType);
}

double
TubeAttributes::GetRadiusFractionBBox() const
{
    return radiusFractionBBox;
}

double
TubeAttributes::GetRadiusAbsolute() const
{
    return radiusAbsolute;
}

const std::string &
TubeAttributes::GetScaleVariable() const
{
    return scaleVariable;
}

std::string &
TubeAttributes::GetScaleVariable()
{
    return scaleVariable;
}

int
TubeAttributes::GetFineness() const
{
    return fineness;
}

bool
TubeAttributes::GetCapping() const
{
    return capping;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
TubeAttributes::SelectScaleVariable()
{
    Select(ID_scaleVariable, (void *)&scaleVariable);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: TubeAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
TubeAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_scaleByVarFlag:     return "scaleByVarFlag";
    case ID_tubeRadiusType:     return "tubeRadiusType";
    case ID_radiusFractionBBox: return "radiusFractionBBox";
    case ID_radiusAbsolute:     return "radiusAbsolute";
    case ID_scaleVariable:      return "scaleVariable";
    case ID_fineness:           return "fineness";
    case ID_capping:            return "capping";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: TubeAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
TubeAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_scaleByVarFlag:     return FieldType_bool;
    case ID_tubeRadiusType:     return FieldType_enum;
    case ID_radiusFractionBBox: return FieldType_double;
    case ID_radiusAbsolute:     return FieldType_double;
    case ID_scaleVariable:      return FieldType_variablename;
    case ID_fineness:           return FieldType_int;
    case ID_capping:            return FieldType_bool;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: TubeAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
TubeAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_scaleByVarFlag:     return "bool";
    case ID_tubeRadiusType:     return "enum";
    case ID_radiusFractionBBox: return "double";
    case ID_radiusAbsolute:     return "double";
    case ID_scaleVariable:      return "variablename";
    case ID_fineness:           return "int";
    case ID_capping:            return "bool";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: TubeAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
TubeAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const TubeAttributes &obj = *((const TubeAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_scaleByVarFlag:
        {  // new scope
        retval = (scaleByVarFlag == obj.scaleByVarFlag);
        }
        break;
    case ID_tubeRadiusType:
        {  // new scope
        retval = (tubeRadiusType == obj.tubeRadiusType);
        }
        break;
    case ID_radiusFractionBBox:
        {  // new scope
        retval = (radiusFractionBBox == obj.radiusFractionBBox);
        }
        break;
    case ID_radiusAbsolute:
        {  // new scope
        retval = (radiusAbsolute == obj.radiusAbsolute);
        }
        break;
    case ID_scaleVariable:
        {  // new scope
        retval = (scaleVariable == obj.scaleVariable);
        }
        break;
    case ID_fineness:
        {  // new scope
        retval = (fineness == obj.fineness);
        }
        break;
    case ID_capping:
        {  // new scope
        retval = (capping == obj.capping);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

