// ***************************************************************************
//
// Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
// Produced at the Lawrence Livermore National Laboratory
// LLNL-CODE-442911
// All rights reserved.
//
// This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
// full copyright notice is contained in the file COPYRIGHT located at the root
// of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
//
// Redistribution  and  use  in  source  and  binary  forms,  with  or  without
// modification, are permitted provided that the following conditions are met:
//
//  - Redistributions of  source code must  retain the above  copyright notice,
//    this list of conditions and the disclaimer below.
//  - Redistributions in binary form must reproduce the above copyright notice,
//    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
//    documentation and/or other materials provided with the distribution.
//  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
//    be used to endorse or promote products derived from this software without
//    specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
// ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
// LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
// DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
// SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
// CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
// LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
// OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
// DAMAGE.
//
// ***************************************************************************

package llnl.visit.operators;

import llnl.visit.AttributeSubject;
import llnl.visit.CommunicationBuffer;
import llnl.visit.Plugin;
import java.lang.Double;
import java.util.Vector;

// ****************************************************************************
// Class: IntegralCurveAttributes
//
// Purpose:
//    Attributes for the IntegralCurve
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

public class IntegralCurveAttributes extends AttributeSubject implements Plugin
{
    private static int IntegralCurveAttributes_numAdditionalAtts = 71;

    // Enum values
    public final static int SOURCETYPE_SPECIFIEDPOINT = 0;
    public final static int SOURCETYPE_POINTLIST = 1;
    public final static int SOURCETYPE_SPECIFIEDLINE = 2;
    public final static int SOURCETYPE_CIRCLE = 3;
    public final static int SOURCETYPE_SPECIFIEDPLANE = 4;
    public final static int SOURCETYPE_SPECIFIEDSPHERE = 5;
    public final static int SOURCETYPE_SPECIFIEDBOX = 6;
    public final static int SOURCETYPE_SELECTION = 7;
    public final static int SOURCETYPE_FIELDDATA = 8;

    public final static int DATAVALUE_SOLID = 0;
    public final static int DATAVALUE_SEEDPOINTID = 1;
    public final static int DATAVALUE_SPEED = 2;
    public final static int DATAVALUE_VORTICITY = 3;
    public final static int DATAVALUE_ARCLENGTH = 4;
    public final static int DATAVALUE_TIMEABSOLUTE = 5;
    public final static int DATAVALUE_TIMERELATIVE = 6;
    public final static int DATAVALUE_AVERAGEDISTANCEFROMSEED = 7;
    public final static int DATAVALUE_CORRELATIONDISTANCE = 8;
    public final static int DATAVALUE_DIFFERENCE = 9;
    public final static int DATAVALUE_VARIABLE = 10;

    public final static int CLEANUPMETHOD_NOCLEANUP = 0;
    public final static int CLEANUPMETHOD_MERGE = 1;
    public final static int CLEANUPMETHOD_BEFORE = 2;
    public final static int CLEANUPMETHOD_AFTER = 3;

    public final static int CROPVALUE_DISTANCE = 0;
    public final static int CROPVALUE_TIME = 1;
    public final static int CROPVALUE_STEPNUMBER = 2;

    public final static int DISPLAYGEOMETRY_LINES = 0;
    public final static int DISPLAYGEOMETRY_TUBES = 1;
    public final static int DISPLAYGEOMETRY_RIBBONS = 2;

    public final static int INTEGRATIONDIRECTION_FORWARD = 0;
    public final static int INTEGRATIONDIRECTION_BACKWARD = 1;
    public final static int INTEGRATIONDIRECTION_BOTH = 2;
    public final static int INTEGRATIONDIRECTION_FORWARDDIRECTIONLESS = 3;
    public final static int INTEGRATIONDIRECTION_BACKWARDDIRECTIONLESS = 4;
    public final static int INTEGRATIONDIRECTION_BOTHDIRECTIONLESS = 5;

    public final static int PARALLELIZATIONALGORITHMTYPE_LOADONDEMAND = 0;
    public final static int PARALLELIZATIONALGORITHMTYPE_PARALLELSTATICDOMAINS = 1;
    public final static int PARALLELIZATIONALGORITHMTYPE_MASTERSLAVE = 2;
    public final static int PARALLELIZATIONALGORITHMTYPE_VISITSELECTS = 3;

    public final static int FIELDTYPE_DEFAULT = 0;
    public final static int FIELDTYPE_FLASHFIELD = 1;
    public final static int FIELDTYPE_M3DC12DFIELD = 2;
    public final static int FIELDTYPE_M3DC13DFIELD = 3;
    public final static int FIELDTYPE_NEK5000FIELD = 4;
    public final static int FIELDTYPE_NEKTARPPFIELD = 5;
    public final static int FIELDTYPE_NIMRODFIELD = 6;

    public final static int INTEGRATIONTYPE_EULER = 0;
    public final static int INTEGRATIONTYPE_LEAPFROG = 1;
    public final static int INTEGRATIONTYPE_DORMANDPRINCE = 2;
    public final static int INTEGRATIONTYPE_ADAMSBASHFORTH = 3;
    public final static int INTEGRATIONTYPE_RK4 = 4;
    public final static int INTEGRATIONTYPE_M3DC12DINTEGRATOR = 5;

    public final static int PATHLINESCMFE_CONN_CMFE = 0;
    public final static int PATHLINESCMFE_POS_CMFE = 1;

    public final static int SIZETYPE_ABSOLUTE = 0;
    public final static int SIZETYPE_FRACTIONOFBBOX = 1;


    public IntegralCurveAttributes()
    {
        super(IntegralCurveAttributes_numAdditionalAtts);

        sourceType = SOURCETYPE_SPECIFIEDPOINT;
        pointSource = new double[3];
        pointSource[0] = 0;
        pointSource[1] = 0;
        pointSource[2] = 0;
        lineStart = new double[3];
        lineStart[0] = 0;
        lineStart[1] = 0;
        lineStart[2] = 0;
        lineEnd = new double[3];
        lineEnd[0] = 1;
        lineEnd[1] = 0;
        lineEnd[2] = 0;
        planeOrigin = new double[3];
        planeOrigin[0] = 0;
        planeOrigin[1] = 0;
        planeOrigin[2] = 0;
        planeNormal = new double[3];
        planeNormal[0] = 0;
        planeNormal[1] = 0;
        planeNormal[2] = 1;
        planeUpAxis = new double[3];
        planeUpAxis[0] = 0;
        planeUpAxis[1] = 1;
        planeUpAxis[2] = 0;
        radius = 1;
        sphereOrigin = new double[3];
        sphereOrigin[0] = 0;
        sphereOrigin[1] = 0;
        sphereOrigin[2] = 0;
        boxExtents = new double[6];
        boxExtents[0] = 0;
        boxExtents[1] = 1;
        boxExtents[2] = 0;
        boxExtents[3] = 1;
        boxExtents[4] = 0;
        boxExtents[5] = 1;
        useWholeBox = true;
        pointList = new Vector();
        pointList.addElement(new Double(0));
        pointList.addElement(new Double(0));
        pointList.addElement(new Double(0));
        pointList.addElement(new Double(1));
        pointList.addElement(new Double(0));
        pointList.addElement(new Double(0));
        pointList.addElement(new Double(0));
        pointList.addElement(new Double(1));
        pointList.addElement(new Double(0));
        fieldData = new Vector();
        sampleDensity0 = 2;
        sampleDensity1 = 2;
        sampleDensity2 = 2;
        dataValue = DATAVALUE_TIMEABSOLUTE;
        dataVariable = new String("");
        integrationDirection = INTEGRATIONDIRECTION_FORWARD;
        maxSteps = 1000;
        terminateByDistance = false;
        termDistance = 10;
        terminateByTime = false;
        termTime = 10;
        maxStepLength = 0.1;
        limitMaximumTimestep = false;
        maxTimeStep = 0.1;
        relTol = 0.0001;
        absTolSizeType = SIZETYPE_FRACTIONOFBBOX;
        absTolAbsolute = 1e-06;
        absTolBBox = 1e-06;
        fieldType = FIELDTYPE_DEFAULT;
        fieldConstant = 1;
        velocitySource = new double[3];
        velocitySource[0] = 0;
        velocitySource[1] = 0;
        velocitySource[2] = 0;
        integrationType = INTEGRATIONTYPE_DORMANDPRINCE;
        parallelizationAlgorithmType = PARALLELIZATIONALGORITHMTYPE_VISITSELECTS;
        maxProcessCount = 10;
        maxDomainCacheSize = 3;
        workGroupSize = 32;
        pathlines = false;
        pathlinesOverrideStartingTimeFlag = false;
        pathlinesOverrideStartingTime = 0;
        pathlinesPeriod = 0;
        pathlinesCMFE = PATHLINESCMFE_POS_CMFE;
        displayGeometry = DISPLAYGEOMETRY_LINES;
        cleanupMethod = CLEANUPMETHOD_NOCLEANUP;
        cleanupThreshold = 1e-08;
        cropBeginFlag = false;
        cropBegin = 0;
        cropEndFlag = false;
        cropEnd = 0;
        cropValue = CROPVALUE_TIME;
        sampleDistance0 = 10;
        sampleDistance1 = 10;
        sampleDistance2 = 10;
        fillInterior = true;
        randomSamples = false;
        randomSeed = 0;
        numberOfRandomSamples = 1;
        issueAdvectionWarnings = true;
        issueBoundaryWarnings = true;
        issueTerminationWarnings = true;
        issueStepsizeWarnings = true;
        issueStiffnessWarnings = true;
        issueCriticalPointsWarnings = true;
        criticalPointThreshold = 0.001;
        correlationDistanceAngTol = 5;
        correlationDistanceMinDistAbsolute = 1;
        correlationDistanceMinDistBBox = 0.005;
        correlationDistanceMinDistType = SIZETYPE_FRACTIONOFBBOX;
        selection = new String("");
    }

    public IntegralCurveAttributes(int nMoreFields)
    {
        super(IntegralCurveAttributes_numAdditionalAtts + nMoreFields);

        sourceType = SOURCETYPE_SPECIFIEDPOINT;
        pointSource = new double[3];
        pointSource[0] = 0;
        pointSource[1] = 0;
        pointSource[2] = 0;
        lineStart = new double[3];
        lineStart[0] = 0;
        lineStart[1] = 0;
        lineStart[2] = 0;
        lineEnd = new double[3];
        lineEnd[0] = 1;
        lineEnd[1] = 0;
        lineEnd[2] = 0;
        planeOrigin = new double[3];
        planeOrigin[0] = 0;
        planeOrigin[1] = 0;
        planeOrigin[2] = 0;
        planeNormal = new double[3];
        planeNormal[0] = 0;
        planeNormal[1] = 0;
        planeNormal[2] = 1;
        planeUpAxis = new double[3];
        planeUpAxis[0] = 0;
        planeUpAxis[1] = 1;
        planeUpAxis[2] = 0;
        radius = 1;
        sphereOrigin = new double[3];
        sphereOrigin[0] = 0;
        sphereOrigin[1] = 0;
        sphereOrigin[2] = 0;
        boxExtents = new double[6];
        boxExtents[0] = 0;
        boxExtents[1] = 1;
        boxExtents[2] = 0;
        boxExtents[3] = 1;
        boxExtents[4] = 0;
        boxExtents[5] = 1;
        useWholeBox = true;
        pointList = new Vector();
        pointList.addElement(new Double(0));
        pointList.addElement(new Double(0));
        pointList.addElement(new Double(0));
        pointList.addElement(new Double(1));
        pointList.addElement(new Double(0));
        pointList.addElement(new Double(0));
        pointList.addElement(new Double(0));
        pointList.addElement(new Double(1));
        pointList.addElement(new Double(0));
        fieldData = new Vector();
        sampleDensity0 = 2;
        sampleDensity1 = 2;
        sampleDensity2 = 2;
        dataValue = DATAVALUE_TIMEABSOLUTE;
        dataVariable = new String("");
        integrationDirection = INTEGRATIONDIRECTION_FORWARD;
        maxSteps = 1000;
        terminateByDistance = false;
        termDistance = 10;
        terminateByTime = false;
        termTime = 10;
        maxStepLength = 0.1;
        limitMaximumTimestep = false;
        maxTimeStep = 0.1;
        relTol = 0.0001;
        absTolSizeType = SIZETYPE_FRACTIONOFBBOX;
        absTolAbsolute = 1e-06;
        absTolBBox = 1e-06;
        fieldType = FIELDTYPE_DEFAULT;
        fieldConstant = 1;
        velocitySource = new double[3];
        velocitySource[0] = 0;
        velocitySource[1] = 0;
        velocitySource[2] = 0;
        integrationType = INTEGRATIONTYPE_DORMANDPRINCE;
        parallelizationAlgorithmType = PARALLELIZATIONALGORITHMTYPE_VISITSELECTS;
        maxProcessCount = 10;
        maxDomainCacheSize = 3;
        workGroupSize = 32;
        pathlines = false;
        pathlinesOverrideStartingTimeFlag = false;
        pathlinesOverrideStartingTime = 0;
        pathlinesPeriod = 0;
        pathlinesCMFE = PATHLINESCMFE_POS_CMFE;
        displayGeometry = DISPLAYGEOMETRY_LINES;
        cleanupMethod = CLEANUPMETHOD_NOCLEANUP;
        cleanupThreshold = 1e-08;
        cropBeginFlag = false;
        cropBegin = 0;
        cropEndFlag = false;
        cropEnd = 0;
        cropValue = CROPVALUE_TIME;
        sampleDistance0 = 10;
        sampleDistance1 = 10;
        sampleDistance2 = 10;
        fillInterior = true;
        randomSamples = false;
        randomSeed = 0;
        numberOfRandomSamples = 1;
        issueAdvectionWarnings = true;
        issueBoundaryWarnings = true;
        issueTerminationWarnings = true;
        issueStepsizeWarnings = true;
        issueStiffnessWarnings = true;
        issueCriticalPointsWarnings = true;
        criticalPointThreshold = 0.001;
        correlationDistanceAngTol = 5;
        correlationDistanceMinDistAbsolute = 1;
        correlationDistanceMinDistBBox = 0.005;
        correlationDistanceMinDistType = SIZETYPE_FRACTIONOFBBOX;
        selection = new String("");
    }

    public IntegralCurveAttributes(IntegralCurveAttributes obj)
    {
        super(obj);

        int i;

        sourceType = obj.sourceType;
        pointSource = new double[3];
        pointSource[0] = obj.pointSource[0];
        pointSource[1] = obj.pointSource[1];
        pointSource[2] = obj.pointSource[2];

        lineStart = new double[3];
        lineStart[0] = obj.lineStart[0];
        lineStart[1] = obj.lineStart[1];
        lineStart[2] = obj.lineStart[2];

        lineEnd = new double[3];
        lineEnd[0] = obj.lineEnd[0];
        lineEnd[1] = obj.lineEnd[1];
        lineEnd[2] = obj.lineEnd[2];

        planeOrigin = new double[3];
        planeOrigin[0] = obj.planeOrigin[0];
        planeOrigin[1] = obj.planeOrigin[1];
        planeOrigin[2] = obj.planeOrigin[2];

        planeNormal = new double[3];
        planeNormal[0] = obj.planeNormal[0];
        planeNormal[1] = obj.planeNormal[1];
        planeNormal[2] = obj.planeNormal[2];

        planeUpAxis = new double[3];
        planeUpAxis[0] = obj.planeUpAxis[0];
        planeUpAxis[1] = obj.planeUpAxis[1];
        planeUpAxis[2] = obj.planeUpAxis[2];

        radius = obj.radius;
        sphereOrigin = new double[3];
        sphereOrigin[0] = obj.sphereOrigin[0];
        sphereOrigin[1] = obj.sphereOrigin[1];
        sphereOrigin[2] = obj.sphereOrigin[2];

        boxExtents = new double[6];
        for(i = 0; i < obj.boxExtents.length; ++i)
            boxExtents[i] = obj.boxExtents[i];

        useWholeBox = obj.useWholeBox;
        pointList = new Vector(obj.pointList.size());
        for(i = 0; i < obj.pointList.size(); ++i)
        {
            Double dv = (Double)obj.pointList.elementAt(i);
            pointList.addElement(new Double(dv.doubleValue()));
        }

        fieldData = new Vector(obj.fieldData.size());
        for(i = 0; i < obj.fieldData.size(); ++i)
        {
            Double dv = (Double)obj.fieldData.elementAt(i);
            fieldData.addElement(new Double(dv.doubleValue()));
        }

        sampleDensity0 = obj.sampleDensity0;
        sampleDensity1 = obj.sampleDensity1;
        sampleDensity2 = obj.sampleDensity2;
        dataValue = obj.dataValue;
        dataVariable = new String(obj.dataVariable);
        integrationDirection = obj.integrationDirection;
        maxSteps = obj.maxSteps;
        terminateByDistance = obj.terminateByDistance;
        termDistance = obj.termDistance;
        terminateByTime = obj.terminateByTime;
        termTime = obj.termTime;
        maxStepLength = obj.maxStepLength;
        limitMaximumTimestep = obj.limitMaximumTimestep;
        maxTimeStep = obj.maxTimeStep;
        relTol = obj.relTol;
        absTolSizeType = obj.absTolSizeType;
        absTolAbsolute = obj.absTolAbsolute;
        absTolBBox = obj.absTolBBox;
        fieldType = obj.fieldType;
        fieldConstant = obj.fieldConstant;
        velocitySource = new double[3];
        velocitySource[0] = obj.velocitySource[0];
        velocitySource[1] = obj.velocitySource[1];
        velocitySource[2] = obj.velocitySource[2];

        integrationType = obj.integrationType;
        parallelizationAlgorithmType = obj.parallelizationAlgorithmType;
        maxProcessCount = obj.maxProcessCount;
        maxDomainCacheSize = obj.maxDomainCacheSize;
        workGroupSize = obj.workGroupSize;
        pathlines = obj.pathlines;
        pathlinesOverrideStartingTimeFlag = obj.pathlinesOverrideStartingTimeFlag;
        pathlinesOverrideStartingTime = obj.pathlinesOverrideStartingTime;
        pathlinesPeriod = obj.pathlinesPeriod;
        pathlinesCMFE = obj.pathlinesCMFE;
        displayGeometry = obj.displayGeometry;
        cleanupMethod = obj.cleanupMethod;
        cleanupThreshold = obj.cleanupThreshold;
        cropBeginFlag = obj.cropBeginFlag;
        cropBegin = obj.cropBegin;
        cropEndFlag = obj.cropEndFlag;
        cropEnd = obj.cropEnd;
        cropValue = obj.cropValue;
        sampleDistance0 = obj.sampleDistance0;
        sampleDistance1 = obj.sampleDistance1;
        sampleDistance2 = obj.sampleDistance2;
        fillInterior = obj.fillInterior;
        randomSamples = obj.randomSamples;
        randomSeed = obj.randomSeed;
        numberOfRandomSamples = obj.numberOfRandomSamples;
        issueAdvectionWarnings = obj.issueAdvectionWarnings;
        issueBoundaryWarnings = obj.issueBoundaryWarnings;
        issueTerminationWarnings = obj.issueTerminationWarnings;
        issueStepsizeWarnings = obj.issueStepsizeWarnings;
        issueStiffnessWarnings = obj.issueStiffnessWarnings;
        issueCriticalPointsWarnings = obj.issueCriticalPointsWarnings;
        criticalPointThreshold = obj.criticalPointThreshold;
        correlationDistanceAngTol = obj.correlationDistanceAngTol;
        correlationDistanceMinDistAbsolute = obj.correlationDistanceMinDistAbsolute;
        correlationDistanceMinDistBBox = obj.correlationDistanceMinDistBBox;
        correlationDistanceMinDistType = obj.correlationDistanceMinDistType;
        selection = new String(obj.selection);

        SelectAll();
    }

    public int Offset()
    {
        return super.Offset() + super.GetNumAdditionalAttributes();
    }

    public int GetNumAdditionalAttributes()
    {
        return IntegralCurveAttributes_numAdditionalAtts;
    }

    public boolean equals(IntegralCurveAttributes obj)
    {
        int i;

        // Compare the pointSource arrays.
        boolean pointSource_equal = true;
        for(i = 0; i < 3 && pointSource_equal; ++i)
            pointSource_equal = (pointSource[i] == obj.pointSource[i]);

        // Compare the lineStart arrays.
        boolean lineStart_equal = true;
        for(i = 0; i < 3 && lineStart_equal; ++i)
            lineStart_equal = (lineStart[i] == obj.lineStart[i]);

        // Compare the lineEnd arrays.
        boolean lineEnd_equal = true;
        for(i = 0; i < 3 && lineEnd_equal; ++i)
            lineEnd_equal = (lineEnd[i] == obj.lineEnd[i]);

        // Compare the planeOrigin arrays.
        boolean planeOrigin_equal = true;
        for(i = 0; i < 3 && planeOrigin_equal; ++i)
            planeOrigin_equal = (planeOrigin[i] == obj.planeOrigin[i]);

        // Compare the planeNormal arrays.
        boolean planeNormal_equal = true;
        for(i = 0; i < 3 && planeNormal_equal; ++i)
            planeNormal_equal = (planeNormal[i] == obj.planeNormal[i]);

        // Compare the planeUpAxis arrays.
        boolean planeUpAxis_equal = true;
        for(i = 0; i < 3 && planeUpAxis_equal; ++i)
            planeUpAxis_equal = (planeUpAxis[i] == obj.planeUpAxis[i]);

        // Compare the sphereOrigin arrays.
        boolean sphereOrigin_equal = true;
        for(i = 0; i < 3 && sphereOrigin_equal; ++i)
            sphereOrigin_equal = (sphereOrigin[i] == obj.sphereOrigin[i]);

        // Compare the boxExtents arrays.
        boolean boxExtents_equal = true;
        for(i = 0; i < 6 && boxExtents_equal; ++i)
            boxExtents_equal = (boxExtents[i] == obj.boxExtents[i]);

        // Compare the elements in the pointList vector.
        boolean pointList_equal = (obj.pointList.size() == pointList.size());
        for(i = 0; (i < pointList.size()) && pointList_equal; ++i)
        {
            // Make references to Double from Object.
            Double pointList1 = (Double)pointList.elementAt(i);
            Double pointList2 = (Double)obj.pointList.elementAt(i);
            pointList_equal = pointList1.equals(pointList2);
        }
        // Compare the elements in the fieldData vector.
        boolean fieldData_equal = (obj.fieldData.size() == fieldData.size());
        for(i = 0; (i < fieldData.size()) && fieldData_equal; ++i)
        {
            // Make references to Double from Object.
            Double fieldData1 = (Double)fieldData.elementAt(i);
            Double fieldData2 = (Double)obj.fieldData.elementAt(i);
            fieldData_equal = fieldData1.equals(fieldData2);
        }
        // Compare the velocitySource arrays.
        boolean velocitySource_equal = true;
        for(i = 0; i < 3 && velocitySource_equal; ++i)
            velocitySource_equal = (velocitySource[i] == obj.velocitySource[i]);

        // Create the return value
        return ((sourceType == obj.sourceType) &&
                pointSource_equal &&
                lineStart_equal &&
                lineEnd_equal &&
                planeOrigin_equal &&
                planeNormal_equal &&
                planeUpAxis_equal &&
                (radius == obj.radius) &&
                sphereOrigin_equal &&
                boxExtents_equal &&
                (useWholeBox == obj.useWholeBox) &&
                pointList_equal &&
                fieldData_equal &&
                (sampleDensity0 == obj.sampleDensity0) &&
                (sampleDensity1 == obj.sampleDensity1) &&
                (sampleDensity2 == obj.sampleDensity2) &&
                (dataValue == obj.dataValue) &&
                (dataVariable.equals(obj.dataVariable)) &&
                (integrationDirection == obj.integrationDirection) &&
                (maxSteps == obj.maxSteps) &&
                (terminateByDistance == obj.terminateByDistance) &&
                (termDistance == obj.termDistance) &&
                (terminateByTime == obj.terminateByTime) &&
                (termTime == obj.termTime) &&
                (maxStepLength == obj.maxStepLength) &&
                (limitMaximumTimestep == obj.limitMaximumTimestep) &&
                (maxTimeStep == obj.maxTimeStep) &&
                (relTol == obj.relTol) &&
                (absTolSizeType == obj.absTolSizeType) &&
                (absTolAbsolute == obj.absTolAbsolute) &&
                (absTolBBox == obj.absTolBBox) &&
                (fieldType == obj.fieldType) &&
                (fieldConstant == obj.fieldConstant) &&
                velocitySource_equal &&
                (integrationType == obj.integrationType) &&
                (parallelizationAlgorithmType == obj.parallelizationAlgorithmType) &&
                (maxProcessCount == obj.maxProcessCount) &&
                (maxDomainCacheSize == obj.maxDomainCacheSize) &&
                (workGroupSize == obj.workGroupSize) &&
                (pathlines == obj.pathlines) &&
                (pathlinesOverrideStartingTimeFlag == obj.pathlinesOverrideStartingTimeFlag) &&
                (pathlinesOverrideStartingTime == obj.pathlinesOverrideStartingTime) &&
                (pathlinesPeriod == obj.pathlinesPeriod) &&
                (pathlinesCMFE == obj.pathlinesCMFE) &&
                (displayGeometry == obj.displayGeometry) &&
                (cleanupMethod == obj.cleanupMethod) &&
                (cleanupThreshold == obj.cleanupThreshold) &&
                (cropBeginFlag == obj.cropBeginFlag) &&
                (cropBegin == obj.cropBegin) &&
                (cropEndFlag == obj.cropEndFlag) &&
                (cropEnd == obj.cropEnd) &&
                (cropValue == obj.cropValue) &&
                (sampleDistance0 == obj.sampleDistance0) &&
                (sampleDistance1 == obj.sampleDistance1) &&
                (sampleDistance2 == obj.sampleDistance2) &&
                (fillInterior == obj.fillInterior) &&
                (randomSamples == obj.randomSamples) &&
                (randomSeed == obj.randomSeed) &&
                (numberOfRandomSamples == obj.numberOfRandomSamples) &&
                (issueAdvectionWarnings == obj.issueAdvectionWarnings) &&
                (issueBoundaryWarnings == obj.issueBoundaryWarnings) &&
                (issueTerminationWarnings == obj.issueTerminationWarnings) &&
                (issueStepsizeWarnings == obj.issueStepsizeWarnings) &&
                (issueStiffnessWarnings == obj.issueStiffnessWarnings) &&
                (issueCriticalPointsWarnings == obj.issueCriticalPointsWarnings) &&
                (criticalPointThreshold == obj.criticalPointThreshold) &&
                (correlationDistanceAngTol == obj.correlationDistanceAngTol) &&
                (correlationDistanceMinDistAbsolute == obj.correlationDistanceMinDistAbsolute) &&
                (correlationDistanceMinDistBBox == obj.correlationDistanceMinDistBBox) &&
                (correlationDistanceMinDistType == obj.correlationDistanceMinDistType) &&
                (selection.equals(obj.selection)));
    }

    public String GetName() { return "IntegralCurve"; }
    public String GetVersion() { return "1.0"; }

    // Property setting methods
    public void SetSourceType(int sourceType_)
    {
        sourceType = sourceType_;
        Select(0);
    }

    public void SetPointSource(double[] pointSource_)
    {
        pointSource[0] = pointSource_[0];
        pointSource[1] = pointSource_[1];
        pointSource[2] = pointSource_[2];
        Select(1);
    }

    public void SetPointSource(double e0, double e1, double e2)
    {
        pointSource[0] = e0;
        pointSource[1] = e1;
        pointSource[2] = e2;
        Select(1);
    }

    public void SetLineStart(double[] lineStart_)
    {
        lineStart[0] = lineStart_[0];
        lineStart[1] = lineStart_[1];
        lineStart[2] = lineStart_[2];
        Select(2);
    }

    public void SetLineStart(double e0, double e1, double e2)
    {
        lineStart[0] = e0;
        lineStart[1] = e1;
        lineStart[2] = e2;
        Select(2);
    }

    public void SetLineEnd(double[] lineEnd_)
    {
        lineEnd[0] = lineEnd_[0];
        lineEnd[1] = lineEnd_[1];
        lineEnd[2] = lineEnd_[2];
        Select(3);
    }

    public void SetLineEnd(double e0, double e1, double e2)
    {
        lineEnd[0] = e0;
        lineEnd[1] = e1;
        lineEnd[2] = e2;
        Select(3);
    }

    public void SetPlaneOrigin(double[] planeOrigin_)
    {
        planeOrigin[0] = planeOrigin_[0];
        planeOrigin[1] = planeOrigin_[1];
        planeOrigin[2] = planeOrigin_[2];
        Select(4);
    }

    public void SetPlaneOrigin(double e0, double e1, double e2)
    {
        planeOrigin[0] = e0;
        planeOrigin[1] = e1;
        planeOrigin[2] = e2;
        Select(4);
    }

    public void SetPlaneNormal(double[] planeNormal_)
    {
        planeNormal[0] = planeNormal_[0];
        planeNormal[1] = planeNormal_[1];
        planeNormal[2] = planeNormal_[2];
        Select(5);
    }

    public void SetPlaneNormal(double e0, double e1, double e2)
    {
        planeNormal[0] = e0;
        planeNormal[1] = e1;
        planeNormal[2] = e2;
        Select(5);
    }

    public void SetPlaneUpAxis(double[] planeUpAxis_)
    {
        planeUpAxis[0] = planeUpAxis_[0];
        planeUpAxis[1] = planeUpAxis_[1];
        planeUpAxis[2] = planeUpAxis_[2];
        Select(6);
    }

    public void SetPlaneUpAxis(double e0, double e1, double e2)
    {
        planeUpAxis[0] = e0;
        planeUpAxis[1] = e1;
        planeUpAxis[2] = e2;
        Select(6);
    }

    public void SetRadius(double radius_)
    {
        radius = radius_;
        Select(7);
    }

    public void SetSphereOrigin(double[] sphereOrigin_)
    {
        sphereOrigin[0] = sphereOrigin_[0];
        sphereOrigin[1] = sphereOrigin_[1];
        sphereOrigin[2] = sphereOrigin_[2];
        Select(8);
    }

    public void SetSphereOrigin(double e0, double e1, double e2)
    {
        sphereOrigin[0] = e0;
        sphereOrigin[1] = e1;
        sphereOrigin[2] = e2;
        Select(8);
    }

    public void SetBoxExtents(double[] boxExtents_)
    {
        for(int i = 0; i < 6; ++i)
             boxExtents[i] = boxExtents_[i];
        Select(9);
    }

    public void SetUseWholeBox(boolean useWholeBox_)
    {
        useWholeBox = useWholeBox_;
        Select(10);
    }

    public void SetPointList(Vector pointList_)
    {
        pointList = pointList_;
        Select(11);
    }

    public void SetFieldData(Vector fieldData_)
    {
        fieldData = fieldData_;
        Select(12);
    }

    public void SetSampleDensity0(int sampleDensity0_)
    {
        sampleDensity0 = sampleDensity0_;
        Select(13);
    }

    public void SetSampleDensity1(int sampleDensity1_)
    {
        sampleDensity1 = sampleDensity1_;
        Select(14);
    }

    public void SetSampleDensity2(int sampleDensity2_)
    {
        sampleDensity2 = sampleDensity2_;
        Select(15);
    }

    public void SetDataValue(int dataValue_)
    {
        dataValue = dataValue_;
        Select(16);
    }

    public void SetDataVariable(String dataVariable_)
    {
        dataVariable = dataVariable_;
        Select(17);
    }

    public void SetIntegrationDirection(int integrationDirection_)
    {
        integrationDirection = integrationDirection_;
        Select(18);
    }

    public void SetMaxSteps(int maxSteps_)
    {
        maxSteps = maxSteps_;
        Select(19);
    }

    public void SetTerminateByDistance(boolean terminateByDistance_)
    {
        terminateByDistance = terminateByDistance_;
        Select(20);
    }

    public void SetTermDistance(double termDistance_)
    {
        termDistance = termDistance_;
        Select(21);
    }

    public void SetTerminateByTime(boolean terminateByTime_)
    {
        terminateByTime = terminateByTime_;
        Select(22);
    }

    public void SetTermTime(double termTime_)
    {
        termTime = termTime_;
        Select(23);
    }

    public void SetMaxStepLength(double maxStepLength_)
    {
        maxStepLength = maxStepLength_;
        Select(24);
    }

    public void SetLimitMaximumTimestep(boolean limitMaximumTimestep_)
    {
        limitMaximumTimestep = limitMaximumTimestep_;
        Select(25);
    }

    public void SetMaxTimeStep(double maxTimeStep_)
    {
        maxTimeStep = maxTimeStep_;
        Select(26);
    }

    public void SetRelTol(double relTol_)
    {
        relTol = relTol_;
        Select(27);
    }

    public void SetAbsTolSizeType(int absTolSizeType_)
    {
        absTolSizeType = absTolSizeType_;
        Select(28);
    }

    public void SetAbsTolAbsolute(double absTolAbsolute_)
    {
        absTolAbsolute = absTolAbsolute_;
        Select(29);
    }

    public void SetAbsTolBBox(double absTolBBox_)
    {
        absTolBBox = absTolBBox_;
        Select(30);
    }

    public void SetFieldType(int fieldType_)
    {
        fieldType = fieldType_;
        Select(31);
    }

    public void SetFieldConstant(double fieldConstant_)
    {
        fieldConstant = fieldConstant_;
        Select(32);
    }

    public void SetVelocitySource(double[] velocitySource_)
    {
        velocitySource[0] = velocitySource_[0];
        velocitySource[1] = velocitySource_[1];
        velocitySource[2] = velocitySource_[2];
        Select(33);
    }

    public void SetVelocitySource(double e0, double e1, double e2)
    {
        velocitySource[0] = e0;
        velocitySource[1] = e1;
        velocitySource[2] = e2;
        Select(33);
    }

    public void SetIntegrationType(int integrationType_)
    {
        integrationType = integrationType_;
        Select(34);
    }

    public void SetParallelizationAlgorithmType(int parallelizationAlgorithmType_)
    {
        parallelizationAlgorithmType = parallelizationAlgorithmType_;
        Select(35);
    }

    public void SetMaxProcessCount(int maxProcessCount_)
    {
        maxProcessCount = maxProcessCount_;
        Select(36);
    }

    public void SetMaxDomainCacheSize(int maxDomainCacheSize_)
    {
        maxDomainCacheSize = maxDomainCacheSize_;
        Select(37);
    }

    public void SetWorkGroupSize(int workGroupSize_)
    {
        workGroupSize = workGroupSize_;
        Select(38);
    }

    public void SetPathlines(boolean pathlines_)
    {
        pathlines = pathlines_;
        Select(39);
    }

    public void SetPathlinesOverrideStartingTimeFlag(boolean pathlinesOverrideStartingTimeFlag_)
    {
        pathlinesOverrideStartingTimeFlag = pathlinesOverrideStartingTimeFlag_;
        Select(40);
    }

    public void SetPathlinesOverrideStartingTime(double pathlinesOverrideStartingTime_)
    {
        pathlinesOverrideStartingTime = pathlinesOverrideStartingTime_;
        Select(41);
    }

    public void SetPathlinesPeriod(double pathlinesPeriod_)
    {
        pathlinesPeriod = pathlinesPeriod_;
        Select(42);
    }

    public void SetPathlinesCMFE(int pathlinesCMFE_)
    {
        pathlinesCMFE = pathlinesCMFE_;
        Select(43);
    }

    public void SetDisplayGeometry(int displayGeometry_)
    {
        displayGeometry = displayGeometry_;
        Select(44);
    }

    public void SetCleanupMethod(int cleanupMethod_)
    {
        cleanupMethod = cleanupMethod_;
        Select(45);
    }

    public void SetCleanupThreshold(double cleanupThreshold_)
    {
        cleanupThreshold = cleanupThreshold_;
        Select(46);
    }

    public void SetCropBeginFlag(boolean cropBeginFlag_)
    {
        cropBeginFlag = cropBeginFlag_;
        Select(47);
    }

    public void SetCropBegin(double cropBegin_)
    {
        cropBegin = cropBegin_;
        Select(48);
    }

    public void SetCropEndFlag(boolean cropEndFlag_)
    {
        cropEndFlag = cropEndFlag_;
        Select(49);
    }

    public void SetCropEnd(double cropEnd_)
    {
        cropEnd = cropEnd_;
        Select(50);
    }

    public void SetCropValue(int cropValue_)
    {
        cropValue = cropValue_;
        Select(51);
    }

    public void SetSampleDistance0(double sampleDistance0_)
    {
        sampleDistance0 = sampleDistance0_;
        Select(52);
    }

    public void SetSampleDistance1(double sampleDistance1_)
    {
        sampleDistance1 = sampleDistance1_;
        Select(53);
    }

    public void SetSampleDistance2(double sampleDistance2_)
    {
        sampleDistance2 = sampleDistance2_;
        Select(54);
    }

    public void SetFillInterior(boolean fillInterior_)
    {
        fillInterior = fillInterior_;
        Select(55);
    }

    public void SetRandomSamples(boolean randomSamples_)
    {
        randomSamples = randomSamples_;
        Select(56);
    }

    public void SetRandomSeed(int randomSeed_)
    {
        randomSeed = randomSeed_;
        Select(57);
    }

    public void SetNumberOfRandomSamples(int numberOfRandomSamples_)
    {
        numberOfRandomSamples = numberOfRandomSamples_;
        Select(58);
    }

    public void SetIssueAdvectionWarnings(boolean issueAdvectionWarnings_)
    {
        issueAdvectionWarnings = issueAdvectionWarnings_;
        Select(59);
    }

    public void SetIssueBoundaryWarnings(boolean issueBoundaryWarnings_)
    {
        issueBoundaryWarnings = issueBoundaryWarnings_;
        Select(60);
    }

    public void SetIssueTerminationWarnings(boolean issueTerminationWarnings_)
    {
        issueTerminationWarnings = issueTerminationWarnings_;
        Select(61);
    }

    public void SetIssueStepsizeWarnings(boolean issueStepsizeWarnings_)
    {
        issueStepsizeWarnings = issueStepsizeWarnings_;
        Select(62);
    }

    public void SetIssueStiffnessWarnings(boolean issueStiffnessWarnings_)
    {
        issueStiffnessWarnings = issueStiffnessWarnings_;
        Select(63);
    }

    public void SetIssueCriticalPointsWarnings(boolean issueCriticalPointsWarnings_)
    {
        issueCriticalPointsWarnings = issueCriticalPointsWarnings_;
        Select(64);
    }

    public void SetCriticalPointThreshold(double criticalPointThreshold_)
    {
        criticalPointThreshold = criticalPointThreshold_;
        Select(65);
    }

    public void SetCorrelationDistanceAngTol(double correlationDistanceAngTol_)
    {
        correlationDistanceAngTol = correlationDistanceAngTol_;
        Select(66);
    }

    public void SetCorrelationDistanceMinDistAbsolute(double correlationDistanceMinDistAbsolute_)
    {
        correlationDistanceMinDistAbsolute = correlationDistanceMinDistAbsolute_;
        Select(67);
    }

    public void SetCorrelationDistanceMinDistBBox(double correlationDistanceMinDistBBox_)
    {
        correlationDistanceMinDistBBox = correlationDistanceMinDistBBox_;
        Select(68);
    }

    public void SetCorrelationDistanceMinDistType(int correlationDistanceMinDistType_)
    {
        correlationDistanceMinDistType = correlationDistanceMinDistType_;
        Select(69);
    }

    public void SetSelection(String selection_)
    {
        selection = selection_;
        Select(70);
    }

    // Property getting methods
    public int      GetSourceType() { return sourceType; }
    public double[] GetPointSource() { return pointSource; }
    public double[] GetLineStart() { return lineStart; }
    public double[] GetLineEnd() { return lineEnd; }
    public double[] GetPlaneOrigin() { return planeOrigin; }
    public double[] GetPlaneNormal() { return planeNormal; }
    public double[] GetPlaneUpAxis() { return planeUpAxis; }
    public double   GetRadius() { return radius; }
    public double[] GetSphereOrigin() { return sphereOrigin; }
    public double[] GetBoxExtents() { return boxExtents; }
    public boolean  GetUseWholeBox() { return useWholeBox; }
    public Vector   GetPointList() { return pointList; }
    public Vector   GetFieldData() { return fieldData; }
    public int      GetSampleDensity0() { return sampleDensity0; }
    public int      GetSampleDensity1() { return sampleDensity1; }
    public int      GetSampleDensity2() { return sampleDensity2; }
    public int      GetDataValue() { return dataValue; }
    public String   GetDataVariable() { return dataVariable; }
    public int      GetIntegrationDirection() { return integrationDirection; }
    public int      GetMaxSteps() { return maxSteps; }
    public boolean  GetTerminateByDistance() { return terminateByDistance; }
    public double   GetTermDistance() { return termDistance; }
    public boolean  GetTerminateByTime() { return terminateByTime; }
    public double   GetTermTime() { return termTime; }
    public double   GetMaxStepLength() { return maxStepLength; }
    public boolean  GetLimitMaximumTimestep() { return limitMaximumTimestep; }
    public double   GetMaxTimeStep() { return maxTimeStep; }
    public double   GetRelTol() { return relTol; }
    public int      GetAbsTolSizeType() { return absTolSizeType; }
    public double   GetAbsTolAbsolute() { return absTolAbsolute; }
    public double   GetAbsTolBBox() { return absTolBBox; }
    public int      GetFieldType() { return fieldType; }
    public double   GetFieldConstant() { return fieldConstant; }
    public double[] GetVelocitySource() { return velocitySource; }
    public int      GetIntegrationType() { return integrationType; }
    public int      GetParallelizationAlgorithmType() { return parallelizationAlgorithmType; }
    public int      GetMaxProcessCount() { return maxProcessCount; }
    public int      GetMaxDomainCacheSize() { return maxDomainCacheSize; }
    public int      GetWorkGroupSize() { return workGroupSize; }
    public boolean  GetPathlines() { return pathlines; }
    public boolean  GetPathlinesOverrideStartingTimeFlag() { return pathlinesOverrideStartingTimeFlag; }
    public double   GetPathlinesOverrideStartingTime() { return pathlinesOverrideStartingTime; }
    public double   GetPathlinesPeriod() { return pathlinesPeriod; }
    public int      GetPathlinesCMFE() { return pathlinesCMFE; }
    public int      GetDisplayGeometry() { return displayGeometry; }
    public int      GetCleanupMethod() { return cleanupMethod; }
    public double   GetCleanupThreshold() { return cleanupThreshold; }
    public boolean  GetCropBeginFlag() { return cropBeginFlag; }
    public double   GetCropBegin() { return cropBegin; }
    public boolean  GetCropEndFlag() { return cropEndFlag; }
    public double   GetCropEnd() { return cropEnd; }
    public int      GetCropValue() { return cropValue; }
    public double   GetSampleDistance0() { return sampleDistance0; }
    public double   GetSampleDistance1() { return sampleDistance1; }
    public double   GetSampleDistance2() { return sampleDistance2; }
    public boolean  GetFillInterior() { return fillInterior; }
    public boolean  GetRandomSamples() { return randomSamples; }
    public int      GetRandomSeed() { return randomSeed; }
    public int      GetNumberOfRandomSamples() { return numberOfRandomSamples; }
    public boolean  GetIssueAdvectionWarnings() { return issueAdvectionWarnings; }
    public boolean  GetIssueBoundaryWarnings() { return issueBoundaryWarnings; }
    public boolean  GetIssueTerminationWarnings() { return issueTerminationWarnings; }
    public boolean  GetIssueStepsizeWarnings() { return issueStepsizeWarnings; }
    public boolean  GetIssueStiffnessWarnings() { return issueStiffnessWarnings; }
    public boolean  GetIssueCriticalPointsWarnings() { return issueCriticalPointsWarnings; }
    public double   GetCriticalPointThreshold() { return criticalPointThreshold; }
    public double   GetCorrelationDistanceAngTol() { return correlationDistanceAngTol; }
    public double   GetCorrelationDistanceMinDistAbsolute() { return correlationDistanceMinDistAbsolute; }
    public double   GetCorrelationDistanceMinDistBBox() { return correlationDistanceMinDistBBox; }
    public int      GetCorrelationDistanceMinDistType() { return correlationDistanceMinDistType; }
    public String   GetSelection() { return selection; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteInt(sourceType);
        if(WriteSelect(1, buf))
            buf.WriteDoubleArray(pointSource);
        if(WriteSelect(2, buf))
            buf.WriteDoubleArray(lineStart);
        if(WriteSelect(3, buf))
            buf.WriteDoubleArray(lineEnd);
        if(WriteSelect(4, buf))
            buf.WriteDoubleArray(planeOrigin);
        if(WriteSelect(5, buf))
            buf.WriteDoubleArray(planeNormal);
        if(WriteSelect(6, buf))
            buf.WriteDoubleArray(planeUpAxis);
        if(WriteSelect(7, buf))
            buf.WriteDouble(radius);
        if(WriteSelect(8, buf))
            buf.WriteDoubleArray(sphereOrigin);
        if(WriteSelect(9, buf))
            buf.WriteDoubleArray(boxExtents);
        if(WriteSelect(10, buf))
            buf.WriteBool(useWholeBox);
        if(WriteSelect(11, buf))
            buf.WriteDoubleVector(pointList);
        if(WriteSelect(12, buf))
            buf.WriteDoubleVector(fieldData);
        if(WriteSelect(13, buf))
            buf.WriteInt(sampleDensity0);
        if(WriteSelect(14, buf))
            buf.WriteInt(sampleDensity1);
        if(WriteSelect(15, buf))
            buf.WriteInt(sampleDensity2);
        if(WriteSelect(16, buf))
            buf.WriteInt(dataValue);
        if(WriteSelect(17, buf))
            buf.WriteString(dataVariable);
        if(WriteSelect(18, buf))
            buf.WriteInt(integrationDirection);
        if(WriteSelect(19, buf))
            buf.WriteInt(maxSteps);
        if(WriteSelect(20, buf))
            buf.WriteBool(terminateByDistance);
        if(WriteSelect(21, buf))
            buf.WriteDouble(termDistance);
        if(WriteSelect(22, buf))
            buf.WriteBool(terminateByTime);
        if(WriteSelect(23, buf))
            buf.WriteDouble(termTime);
        if(WriteSelect(24, buf))
            buf.WriteDouble(maxStepLength);
        if(WriteSelect(25, buf))
            buf.WriteBool(limitMaximumTimestep);
        if(WriteSelect(26, buf))
            buf.WriteDouble(maxTimeStep);
        if(WriteSelect(27, buf))
            buf.WriteDouble(relTol);
        if(WriteSelect(28, buf))
            buf.WriteInt(absTolSizeType);
        if(WriteSelect(29, buf))
            buf.WriteDouble(absTolAbsolute);
        if(WriteSelect(30, buf))
            buf.WriteDouble(absTolBBox);
        if(WriteSelect(31, buf))
            buf.WriteInt(fieldType);
        if(WriteSelect(32, buf))
            buf.WriteDouble(fieldConstant);
        if(WriteSelect(33, buf))
            buf.WriteDoubleArray(velocitySource);
        if(WriteSelect(34, buf))
            buf.WriteInt(integrationType);
        if(WriteSelect(35, buf))
            buf.WriteInt(parallelizationAlgorithmType);
        if(WriteSelect(36, buf))
            buf.WriteInt(maxProcessCount);
        if(WriteSelect(37, buf))
            buf.WriteInt(maxDomainCacheSize);
        if(WriteSelect(38, buf))
            buf.WriteInt(workGroupSize);
        if(WriteSelect(39, buf))
            buf.WriteBool(pathlines);
        if(WriteSelect(40, buf))
            buf.WriteBool(pathlinesOverrideStartingTimeFlag);
        if(WriteSelect(41, buf))
            buf.WriteDouble(pathlinesOverrideStartingTime);
        if(WriteSelect(42, buf))
            buf.WriteDouble(pathlinesPeriod);
        if(WriteSelect(43, buf))
            buf.WriteInt(pathlinesCMFE);
        if(WriteSelect(44, buf))
            buf.WriteInt(displayGeometry);
        if(WriteSelect(45, buf))
            buf.WriteInt(cleanupMethod);
        if(WriteSelect(46, buf))
            buf.WriteDouble(cleanupThreshold);
        if(WriteSelect(47, buf))
            buf.WriteBool(cropBeginFlag);
        if(WriteSelect(48, buf))
            buf.WriteDouble(cropBegin);
        if(WriteSelect(49, buf))
            buf.WriteBool(cropEndFlag);
        if(WriteSelect(50, buf))
            buf.WriteDouble(cropEnd);
        if(WriteSelect(51, buf))
            buf.WriteInt(cropValue);
        if(WriteSelect(52, buf))
            buf.WriteDouble(sampleDistance0);
        if(WriteSelect(53, buf))
            buf.WriteDouble(sampleDistance1);
        if(WriteSelect(54, buf))
            buf.WriteDouble(sampleDistance2);
        if(WriteSelect(55, buf))
            buf.WriteBool(fillInterior);
        if(WriteSelect(56, buf))
            buf.WriteBool(randomSamples);
        if(WriteSelect(57, buf))
            buf.WriteInt(randomSeed);
        if(WriteSelect(58, buf))
            buf.WriteInt(numberOfRandomSamples);
        if(WriteSelect(59, buf))
            buf.WriteBool(issueAdvectionWarnings);
        if(WriteSelect(60, buf))
            buf.WriteBool(issueBoundaryWarnings);
        if(WriteSelect(61, buf))
            buf.WriteBool(issueTerminationWarnings);
        if(WriteSelect(62, buf))
            buf.WriteBool(issueStepsizeWarnings);
        if(WriteSelect(63, buf))
            buf.WriteBool(issueStiffnessWarnings);
        if(WriteSelect(64, buf))
            buf.WriteBool(issueCriticalPointsWarnings);
        if(WriteSelect(65, buf))
            buf.WriteDouble(criticalPointThreshold);
        if(WriteSelect(66, buf))
            buf.WriteDouble(correlationDistanceAngTol);
        if(WriteSelect(67, buf))
            buf.WriteDouble(correlationDistanceMinDistAbsolute);
        if(WriteSelect(68, buf))
            buf.WriteDouble(correlationDistanceMinDistBBox);
        if(WriteSelect(69, buf))
            buf.WriteInt(correlationDistanceMinDistType);
        if(WriteSelect(70, buf))
            buf.WriteString(selection);
    }

    public void ReadAtts(int index, CommunicationBuffer buf)
    {
        switch(index)
        {
        case 0:
            SetSourceType(buf.ReadInt());
            break;
        case 1:
            SetPointSource(buf.ReadDoubleArray());
            break;
        case 2:
            SetLineStart(buf.ReadDoubleArray());
            break;
        case 3:
            SetLineEnd(buf.ReadDoubleArray());
            break;
        case 4:
            SetPlaneOrigin(buf.ReadDoubleArray());
            break;
        case 5:
            SetPlaneNormal(buf.ReadDoubleArray());
            break;
        case 6:
            SetPlaneUpAxis(buf.ReadDoubleArray());
            break;
        case 7:
            SetRadius(buf.ReadDouble());
            break;
        case 8:
            SetSphereOrigin(buf.ReadDoubleArray());
            break;
        case 9:
            SetBoxExtents(buf.ReadDoubleArray());
            break;
        case 10:
            SetUseWholeBox(buf.ReadBool());
            break;
        case 11:
            SetPointList(buf.ReadDoubleVector());
            break;
        case 12:
            SetFieldData(buf.ReadDoubleVector());
            break;
        case 13:
            SetSampleDensity0(buf.ReadInt());
            break;
        case 14:
            SetSampleDensity1(buf.ReadInt());
            break;
        case 15:
            SetSampleDensity2(buf.ReadInt());
            break;
        case 16:
            SetDataValue(buf.ReadInt());
            break;
        case 17:
            SetDataVariable(buf.ReadString());
            break;
        case 18:
            SetIntegrationDirection(buf.ReadInt());
            break;
        case 19:
            SetMaxSteps(buf.ReadInt());
            break;
        case 20:
            SetTerminateByDistance(buf.ReadBool());
            break;
        case 21:
            SetTermDistance(buf.ReadDouble());
            break;
        case 22:
            SetTerminateByTime(buf.ReadBool());
            break;
        case 23:
            SetTermTime(buf.ReadDouble());
            break;
        case 24:
            SetMaxStepLength(buf.ReadDouble());
            break;
        case 25:
            SetLimitMaximumTimestep(buf.ReadBool());
            break;
        case 26:
            SetMaxTimeStep(buf.ReadDouble());
            break;
        case 27:
            SetRelTol(buf.ReadDouble());
            break;
        case 28:
            SetAbsTolSizeType(buf.ReadInt());
            break;
        case 29:
            SetAbsTolAbsolute(buf.ReadDouble());
            break;
        case 30:
            SetAbsTolBBox(buf.ReadDouble());
            break;
        case 31:
            SetFieldType(buf.ReadInt());
            break;
        case 32:
            SetFieldConstant(buf.ReadDouble());
            break;
        case 33:
            SetVelocitySource(buf.ReadDoubleArray());
            break;
        case 34:
            SetIntegrationType(buf.ReadInt());
            break;
        case 35:
            SetParallelizationAlgorithmType(buf.ReadInt());
            break;
        case 36:
            SetMaxProcessCount(buf.ReadInt());
            break;
        case 37:
            SetMaxDomainCacheSize(buf.ReadInt());
            break;
        case 38:
            SetWorkGroupSize(buf.ReadInt());
            break;
        case 39:
            SetPathlines(buf.ReadBool());
            break;
        case 40:
            SetPathlinesOverrideStartingTimeFlag(buf.ReadBool());
            break;
        case 41:
            SetPathlinesOverrideStartingTime(buf.ReadDouble());
            break;
        case 42:
            SetPathlinesPeriod(buf.ReadDouble());
            break;
        case 43:
            SetPathlinesCMFE(buf.ReadInt());
            break;
        case 44:
            SetDisplayGeometry(buf.ReadInt());
            break;
        case 45:
            SetCleanupMethod(buf.ReadInt());
            break;
        case 46:
            SetCleanupThreshold(buf.ReadDouble());
            break;
        case 47:
            SetCropBeginFlag(buf.ReadBool());
            break;
        case 48:
            SetCropBegin(buf.ReadDouble());
            break;
        case 49:
            SetCropEndFlag(buf.ReadBool());
            break;
        case 50:
            SetCropEnd(buf.ReadDouble());
            break;
        case 51:
            SetCropValue(buf.ReadInt());
            break;
        case 52:
            SetSampleDistance0(buf.ReadDouble());
            break;
        case 53:
            SetSampleDistance1(buf.ReadDouble());
            break;
        case 54:
            SetSampleDistance2(buf.ReadDouble());
            break;
        case 55:
            SetFillInterior(buf.ReadBool());
            break;
        case 56:
            SetRandomSamples(buf.ReadBool());
            break;
        case 57:
            SetRandomSeed(buf.ReadInt());
            break;
        case 58:
            SetNumberOfRandomSamples(buf.ReadInt());
            break;
        case 59:
            SetIssueAdvectionWarnings(buf.ReadBool());
            break;
        case 60:
            SetIssueBoundaryWarnings(buf.ReadBool());
            break;
        case 61:
            SetIssueTerminationWarnings(buf.ReadBool());
            break;
        case 62:
            SetIssueStepsizeWarnings(buf.ReadBool());
            break;
        case 63:
            SetIssueStiffnessWarnings(buf.ReadBool());
            break;
        case 64:
            SetIssueCriticalPointsWarnings(buf.ReadBool());
            break;
        case 65:
            SetCriticalPointThreshold(buf.ReadDouble());
            break;
        case 66:
            SetCorrelationDistanceAngTol(buf.ReadDouble());
            break;
        case 67:
            SetCorrelationDistanceMinDistAbsolute(buf.ReadDouble());
            break;
        case 68:
            SetCorrelationDistanceMinDistBBox(buf.ReadDouble());
            break;
        case 69:
            SetCorrelationDistanceMinDistType(buf.ReadInt());
            break;
        case 70:
            SetSelection(buf.ReadString());
            break;
        }
    }

    public String toString(String indent)
    {
        String str = new String();
        str = str + indent + "sourceType = ";
        if(sourceType == SOURCETYPE_SPECIFIEDPOINT)
            str = str + "SOURCETYPE_SPECIFIEDPOINT";
        if(sourceType == SOURCETYPE_POINTLIST)
            str = str + "SOURCETYPE_POINTLIST";
        if(sourceType == SOURCETYPE_SPECIFIEDLINE)
            str = str + "SOURCETYPE_SPECIFIEDLINE";
        if(sourceType == SOURCETYPE_CIRCLE)
            str = str + "SOURCETYPE_CIRCLE";
        if(sourceType == SOURCETYPE_SPECIFIEDPLANE)
            str = str + "SOURCETYPE_SPECIFIEDPLANE";
        if(sourceType == SOURCETYPE_SPECIFIEDSPHERE)
            str = str + "SOURCETYPE_SPECIFIEDSPHERE";
        if(sourceType == SOURCETYPE_SPECIFIEDBOX)
            str = str + "SOURCETYPE_SPECIFIEDBOX";
        if(sourceType == SOURCETYPE_SELECTION)
            str = str + "SOURCETYPE_SELECTION";
        if(sourceType == SOURCETYPE_FIELDDATA)
            str = str + "SOURCETYPE_FIELDDATA";
        str = str + "\n";
        str = str + doubleArrayToString("pointSource", pointSource, indent) + "\n";
        str = str + doubleArrayToString("lineStart", lineStart, indent) + "\n";
        str = str + doubleArrayToString("lineEnd", lineEnd, indent) + "\n";
        str = str + doubleArrayToString("planeOrigin", planeOrigin, indent) + "\n";
        str = str + doubleArrayToString("planeNormal", planeNormal, indent) + "\n";
        str = str + doubleArrayToString("planeUpAxis", planeUpAxis, indent) + "\n";
        str = str + doubleToString("radius", radius, indent) + "\n";
        str = str + doubleArrayToString("sphereOrigin", sphereOrigin, indent) + "\n";
        str = str + doubleArrayToString("boxExtents", boxExtents, indent) + "\n";
        str = str + boolToString("useWholeBox", useWholeBox, indent) + "\n";
        str = str + doubleVectorToString("pointList", pointList, indent) + "\n";
        str = str + doubleVectorToString("fieldData", fieldData, indent) + "\n";
        str = str + intToString("sampleDensity0", sampleDensity0, indent) + "\n";
        str = str + intToString("sampleDensity1", sampleDensity1, indent) + "\n";
        str = str + intToString("sampleDensity2", sampleDensity2, indent) + "\n";
        str = str + indent + "dataValue = ";
        if(dataValue == DATAVALUE_SOLID)
            str = str + "DATAVALUE_SOLID";
        if(dataValue == DATAVALUE_SEEDPOINTID)
            str = str + "DATAVALUE_SEEDPOINTID";
        if(dataValue == DATAVALUE_SPEED)
            str = str + "DATAVALUE_SPEED";
        if(dataValue == DATAVALUE_VORTICITY)
            str = str + "DATAVALUE_VORTICITY";
        if(dataValue == DATAVALUE_ARCLENGTH)
            str = str + "DATAVALUE_ARCLENGTH";
        if(dataValue == DATAVALUE_TIMEABSOLUTE)
            str = str + "DATAVALUE_TIMEABSOLUTE";
        if(dataValue == DATAVALUE_TIMERELATIVE)
            str = str + "DATAVALUE_TIMERELATIVE";
        if(dataValue == DATAVALUE_AVERAGEDISTANCEFROMSEED)
            str = str + "DATAVALUE_AVERAGEDISTANCEFROMSEED";
        if(dataValue == DATAVALUE_CORRELATIONDISTANCE)
            str = str + "DATAVALUE_CORRELATIONDISTANCE";
        if(dataValue == DATAVALUE_DIFFERENCE)
            str = str + "DATAVALUE_DIFFERENCE";
        if(dataValue == DATAVALUE_VARIABLE)
            str = str + "DATAVALUE_VARIABLE";
        str = str + "\n";
        str = str + stringToString("dataVariable", dataVariable, indent) + "\n";
        str = str + indent + "integrationDirection = ";
        if(integrationDirection == INTEGRATIONDIRECTION_FORWARD)
            str = str + "INTEGRATIONDIRECTION_FORWARD";
        if(integrationDirection == INTEGRATIONDIRECTION_BACKWARD)
            str = str + "INTEGRATIONDIRECTION_BACKWARD";
        if(integrationDirection == INTEGRATIONDIRECTION_BOTH)
            str = str + "INTEGRATIONDIRECTION_BOTH";
        if(integrationDirection == INTEGRATIONDIRECTION_FORWARDDIRECTIONLESS)
            str = str + "INTEGRATIONDIRECTION_FORWARDDIRECTIONLESS";
        if(integrationDirection == INTEGRATIONDIRECTION_BACKWARDDIRECTIONLESS)
            str = str + "INTEGRATIONDIRECTION_BACKWARDDIRECTIONLESS";
        if(integrationDirection == INTEGRATIONDIRECTION_BOTHDIRECTIONLESS)
            str = str + "INTEGRATIONDIRECTION_BOTHDIRECTIONLESS";
        str = str + "\n";
        str = str + intToString("maxSteps", maxSteps, indent) + "\n";
        str = str + boolToString("terminateByDistance", terminateByDistance, indent) + "\n";
        str = str + doubleToString("termDistance", termDistance, indent) + "\n";
        str = str + boolToString("terminateByTime", terminateByTime, indent) + "\n";
        str = str + doubleToString("termTime", termTime, indent) + "\n";
        str = str + doubleToString("maxStepLength", maxStepLength, indent) + "\n";
        str = str + boolToString("limitMaximumTimestep", limitMaximumTimestep, indent) + "\n";
        str = str + doubleToString("maxTimeStep", maxTimeStep, indent) + "\n";
        str = str + doubleToString("relTol", relTol, indent) + "\n";
        str = str + indent + "absTolSizeType = ";
        if(absTolSizeType == SIZETYPE_ABSOLUTE)
            str = str + "SIZETYPE_ABSOLUTE";
        if(absTolSizeType == SIZETYPE_FRACTIONOFBBOX)
            str = str + "SIZETYPE_FRACTIONOFBBOX";
        str = str + "\n";
        str = str + doubleToString("absTolAbsolute", absTolAbsolute, indent) + "\n";
        str = str + doubleToString("absTolBBox", absTolBBox, indent) + "\n";
        str = str + indent + "fieldType = ";
        if(fieldType == FIELDTYPE_DEFAULT)
            str = str + "FIELDTYPE_DEFAULT";
        if(fieldType == FIELDTYPE_FLASHFIELD)
            str = str + "FIELDTYPE_FLASHFIELD";
        if(fieldType == FIELDTYPE_M3DC12DFIELD)
            str = str + "FIELDTYPE_M3DC12DFIELD";
        if(fieldType == FIELDTYPE_M3DC13DFIELD)
            str = str + "FIELDTYPE_M3DC13DFIELD";
        if(fieldType == FIELDTYPE_NEK5000FIELD)
            str = str + "FIELDTYPE_NEK5000FIELD";
        if(fieldType == FIELDTYPE_NEKTARPPFIELD)
            str = str + "FIELDTYPE_NEKTARPPFIELD";
        if(fieldType == FIELDTYPE_NIMRODFIELD)
            str = str + "FIELDTYPE_NIMRODFIELD";
        str = str + "\n";
        str = str + doubleToString("fieldConstant", fieldConstant, indent) + "\n";
        str = str + doubleArrayToString("velocitySource", velocitySource, indent) + "\n";
        str = str + indent + "integrationType = ";
        if(integrationType == INTEGRATIONTYPE_EULER)
            str = str + "INTEGRATIONTYPE_EULER";
        if(integrationType == INTEGRATIONTYPE_LEAPFROG)
            str = str + "INTEGRATIONTYPE_LEAPFROG";
        if(integrationType == INTEGRATIONTYPE_DORMANDPRINCE)
            str = str + "INTEGRATIONTYPE_DORMANDPRINCE";
        if(integrationType == INTEGRATIONTYPE_ADAMSBASHFORTH)
            str = str + "INTEGRATIONTYPE_ADAMSBASHFORTH";
        if(integrationType == INTEGRATIONTYPE_RK4)
            str = str + "INTEGRATIONTYPE_RK4";
        if(integrationType == INTEGRATIONTYPE_M3DC12DINTEGRATOR)
            str = str + "INTEGRATIONTYPE_M3DC12DINTEGRATOR";
        str = str + "\n";
        str = str + indent + "parallelizationAlgorithmType = ";
        if(parallelizationAlgorithmType == PARALLELIZATIONALGORITHMTYPE_LOADONDEMAND)
            str = str + "PARALLELIZATIONALGORITHMTYPE_LOADONDEMAND";
        if(parallelizationAlgorithmType == PARALLELIZATIONALGORITHMTYPE_PARALLELSTATICDOMAINS)
            str = str + "PARALLELIZATIONALGORITHMTYPE_PARALLELSTATICDOMAINS";
        if(parallelizationAlgorithmType == PARALLELIZATIONALGORITHMTYPE_MASTERSLAVE)
            str = str + "PARALLELIZATIONALGORITHMTYPE_MASTERSLAVE";
        if(parallelizationAlgorithmType == PARALLELIZATIONALGORITHMTYPE_VISITSELECTS)
            str = str + "PARALLELIZATIONALGORITHMTYPE_VISITSELECTS";
        str = str + "\n";
        str = str + intToString("maxProcessCount", maxProcessCount, indent) + "\n";
        str = str + intToString("maxDomainCacheSize", maxDomainCacheSize, indent) + "\n";
        str = str + intToString("workGroupSize", workGroupSize, indent) + "\n";
        str = str + boolToString("pathlines", pathlines, indent) + "\n";
        str = str + boolToString("pathlinesOverrideStartingTimeFlag", pathlinesOverrideStartingTimeFlag, indent) + "\n";
        str = str + doubleToString("pathlinesOverrideStartingTime", pathlinesOverrideStartingTime, indent) + "\n";
        str = str + doubleToString("pathlinesPeriod", pathlinesPeriod, indent) + "\n";
        str = str + indent + "pathlinesCMFE = ";
        if(pathlinesCMFE == PATHLINESCMFE_CONN_CMFE)
            str = str + "PATHLINESCMFE_CONN_CMFE";
        if(pathlinesCMFE == PATHLINESCMFE_POS_CMFE)
            str = str + "PATHLINESCMFE_POS_CMFE";
        str = str + "\n";
        str = str + indent + "displayGeometry = ";
        if(displayGeometry == DISPLAYGEOMETRY_LINES)
            str = str + "DISPLAYGEOMETRY_LINES";
        if(displayGeometry == DISPLAYGEOMETRY_TUBES)
            str = str + "DISPLAYGEOMETRY_TUBES";
        if(displayGeometry == DISPLAYGEOMETRY_RIBBONS)
            str = str + "DISPLAYGEOMETRY_RIBBONS";
        str = str + "\n";
        str = str + indent + "cleanupMethod = ";
        if(cleanupMethod == CLEANUPMETHOD_NOCLEANUP)
            str = str + "CLEANUPMETHOD_NOCLEANUP";
        if(cleanupMethod == CLEANUPMETHOD_MERGE)
            str = str + "CLEANUPMETHOD_MERGE";
        if(cleanupMethod == CLEANUPMETHOD_BEFORE)
            str = str + "CLEANUPMETHOD_BEFORE";
        if(cleanupMethod == CLEANUPMETHOD_AFTER)
            str = str + "CLEANUPMETHOD_AFTER";
        str = str + "\n";
        str = str + doubleToString("cleanupThreshold", cleanupThreshold, indent) + "\n";
        str = str + boolToString("cropBeginFlag", cropBeginFlag, indent) + "\n";
        str = str + doubleToString("cropBegin", cropBegin, indent) + "\n";
        str = str + boolToString("cropEndFlag", cropEndFlag, indent) + "\n";
        str = str + doubleToString("cropEnd", cropEnd, indent) + "\n";
        str = str + indent + "cropValue = ";
        if(cropValue == CROPVALUE_DISTANCE)
            str = str + "CROPVALUE_DISTANCE";
        if(cropValue == CROPVALUE_TIME)
            str = str + "CROPVALUE_TIME";
        if(cropValue == CROPVALUE_STEPNUMBER)
            str = str + "CROPVALUE_STEPNUMBER";
        str = str + "\n";
        str = str + doubleToString("sampleDistance0", sampleDistance0, indent) + "\n";
        str = str + doubleToString("sampleDistance1", sampleDistance1, indent) + "\n";
        str = str + doubleToString("sampleDistance2", sampleDistance2, indent) + "\n";
        str = str + boolToString("fillInterior", fillInterior, indent) + "\n";
        str = str + boolToString("randomSamples", randomSamples, indent) + "\n";
        str = str + intToString("randomSeed", randomSeed, indent) + "\n";
        str = str + intToString("numberOfRandomSamples", numberOfRandomSamples, indent) + "\n";
        str = str + boolToString("issueAdvectionWarnings", issueAdvectionWarnings, indent) + "\n";
        str = str + boolToString("issueBoundaryWarnings", issueBoundaryWarnings, indent) + "\n";
        str = str + boolToString("issueTerminationWarnings", issueTerminationWarnings, indent) + "\n";
        str = str + boolToString("issueStepsizeWarnings", issueStepsizeWarnings, indent) + "\n";
        str = str + boolToString("issueStiffnessWarnings", issueStiffnessWarnings, indent) + "\n";
        str = str + boolToString("issueCriticalPointsWarnings", issueCriticalPointsWarnings, indent) + "\n";
        str = str + doubleToString("criticalPointThreshold", criticalPointThreshold, indent) + "\n";
        str = str + doubleToString("correlationDistanceAngTol", correlationDistanceAngTol, indent) + "\n";
        str = str + doubleToString("correlationDistanceMinDistAbsolute", correlationDistanceMinDistAbsolute, indent) + "\n";
        str = str + doubleToString("correlationDistanceMinDistBBox", correlationDistanceMinDistBBox, indent) + "\n";
        str = str + indent + "correlationDistanceMinDistType = ";
        if(correlationDistanceMinDistType == SIZETYPE_ABSOLUTE)
            str = str + "SIZETYPE_ABSOLUTE";
        if(correlationDistanceMinDistType == SIZETYPE_FRACTIONOFBBOX)
            str = str + "SIZETYPE_FRACTIONOFBBOX";
        str = str + "\n";
        str = str + stringToString("selection", selection, indent) + "\n";
        return str;
    }


    // Attributes
    private int      sourceType;
    private double[] pointSource;
    private double[] lineStart;
    private double[] lineEnd;
    private double[] planeOrigin;
    private double[] planeNormal;
    private double[] planeUpAxis;
    private double   radius;
    private double[] sphereOrigin;
    private double[] boxExtents;
    private boolean  useWholeBox;
    private Vector   pointList; // vector of Double objects
    private Vector   fieldData; // vector of Double objects
    private int      sampleDensity0;
    private int      sampleDensity1;
    private int      sampleDensity2;
    private int      dataValue;
    private String   dataVariable;
    private int      integrationDirection;
    private int      maxSteps;
    private boolean  terminateByDistance;
    private double   termDistance;
    private boolean  terminateByTime;
    private double   termTime;
    private double   maxStepLength;
    private boolean  limitMaximumTimestep;
    private double   maxTimeStep;
    private double   relTol;
    private int      absTolSizeType;
    private double   absTolAbsolute;
    private double   absTolBBox;
    private int      fieldType;
    private double   fieldConstant;
    private double[] velocitySource;
    private int      integrationType;
    private int      parallelizationAlgorithmType;
    private int      maxProcessCount;
    private int      maxDomainCacheSize;
    private int      workGroupSize;
    private boolean  pathlines;
    private boolean  pathlinesOverrideStartingTimeFlag;
    private double   pathlinesOverrideStartingTime;
    private double   pathlinesPeriod;
    private int      pathlinesCMFE;
    private int      displayGeometry;
    private int      cleanupMethod;
    private double   cleanupThreshold;
    private boolean  cropBeginFlag;
    private double   cropBegin;
    private boolean  cropEndFlag;
    private double   cropEnd;
    private int      cropValue;
    private double   sampleDistance0;
    private double   sampleDistance1;
    private double   sampleDistance2;
    private boolean  fillInterior;
    private boolean  randomSamples;
    private int      randomSeed;
    private int      numberOfRandomSamples;
    private boolean  issueAdvectionWarnings;
    private boolean  issueBoundaryWarnings;
    private boolean  issueTerminationWarnings;
    private boolean  issueStepsizeWarnings;
    private boolean  issueStiffnessWarnings;
    private boolean  issueCriticalPointsWarnings;
    private double   criticalPointThreshold;
    private double   correlationDistanceAngTol;
    private double   correlationDistanceMinDistAbsolute;
    private double   correlationDistanceMinDistBBox;
    private int      correlationDistanceMinDistType;
    private String   selection;
}

