/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include "QvisAxisAlignedSlice4DWindow.h"

#include <AxisAlignedSlice4DAttributes.h>

#include <QLabel>
#include <QLayout>
#include <QLineEdit>


// ****************************************************************************
// Method: QvisAxisAlignedSlice4DWindow::QvisAxisAlignedSlice4DWindow
//
// Purpose: 
//   Constructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisAxisAlignedSlice4DWindow::QvisAxisAlignedSlice4DWindow(const int type,
                         AxisAlignedSlice4DAttributes *subj,
                         const QString &caption,
                         const QString &shortName,
                         QvisNotepadArea *notepad)
    : QvisOperatorWindow(type,subj, caption, shortName, notepad)
{
    atts = subj;
}


// ****************************************************************************
// Method: QvisAxisAlignedSlice4DWindow::~QvisAxisAlignedSlice4DWindow
//
// Purpose: 
//   Destructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisAxisAlignedSlice4DWindow::~QvisAxisAlignedSlice4DWindow()
{
}


// ****************************************************************************
// Method: QvisAxisAlignedSlice4DWindow::CreateWindowContents
//
// Purpose: 
//   Creates the widgets for the window.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisAxisAlignedSlice4DWindow::CreateWindowContents()
{
    QGridLayout *mainLayout = new QGridLayout(0);
    topLayout->addLayout(mainLayout);

    ILabel = new QLabel(tr("I"), central);
    mainLayout->addWidget(ILabel,0,0);
    I = new QLineEdit(central);
    connect(I, SIGNAL(returnPressed()),
            this, SLOT(IProcessText()));
    mainLayout->addWidget(I, 0,1);

    JLabel = new QLabel(tr("J"), central);
    mainLayout->addWidget(JLabel,1,0);
    J = new QLineEdit(central);
    connect(J, SIGNAL(returnPressed()),
            this, SLOT(JProcessText()));
    mainLayout->addWidget(J, 1,1);

    KLabel = new QLabel(tr("K"), central);
    mainLayout->addWidget(KLabel,2,0);
    K = new QLineEdit(central);
    connect(K, SIGNAL(returnPressed()),
            this, SLOT(KProcessText()));
    mainLayout->addWidget(K, 2,1);

    LLabel = new QLabel(tr("L"), central);
    mainLayout->addWidget(LLabel,3,0);
    L = new QLineEdit(central);
    connect(L, SIGNAL(returnPressed()),
            this, SLOT(LProcessText()));
    mainLayout->addWidget(L, 3,1);

}


// ****************************************************************************
// Method: QvisAxisAlignedSlice4DWindow::UpdateWindow
//
// Purpose: 
//   Updates the widgets in the window when the subject changes.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisAxisAlignedSlice4DWindow::UpdateWindow(bool doAll)
{

    for(int i = 0; i < atts->NumAttributes(); ++i)
    {
        if(!doAll)
        {
            if(!atts->IsSelected(i))
            {
                continue;
            }
        }

        switch(i)
        {
          case AxisAlignedSlice4DAttributes::ID_I:
            I->setText(IntsToQString(atts->GetI()));
            break;
          case AxisAlignedSlice4DAttributes::ID_J:
            J->setText(IntsToQString(atts->GetJ()));
            break;
          case AxisAlignedSlice4DAttributes::ID_K:
            K->setText(IntsToQString(atts->GetK()));
            break;
          case AxisAlignedSlice4DAttributes::ID_L:
            L->setText(IntsToQString(atts->GetL()));
            break;
        }
    }
}


// ****************************************************************************
// Method: QvisAxisAlignedSlice4DWindow::GetCurrentValues
//
// Purpose: 
//   Gets values from certain widgets and stores them in the subject.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisAxisAlignedSlice4DWindow::GetCurrentValues(int which_widget)
{
    bool doAll = (which_widget == -1);

    // Do I
    if(which_widget == AxisAlignedSlice4DAttributes::ID_I || doAll)
    {
        intVector val;
        if(I->text().isEmpty() || LineEditGetInts(I, val))
            atts->SetI(val);
        else
        {
            ResettingError(tr("I"),
                IntsToQString(atts->GetI()));
            atts->SetI(atts->GetI());
        }
    }

    // Do J
    if(which_widget == AxisAlignedSlice4DAttributes::ID_J || doAll)
    {
        intVector val;
        if(J->text().isEmpty() || LineEditGetInts(J, val))
            atts->SetJ(val);
        else
        {
            ResettingError(tr("J"),
                IntsToQString(atts->GetJ()));
            atts->SetJ(atts->GetJ());
        }
    }

    // Do K
    if(which_widget == AxisAlignedSlice4DAttributes::ID_K || doAll)
    {
        intVector val;
        if(K->text().isEmpty() || LineEditGetInts(K, val))
            atts->SetK(val);
        else
        {
            ResettingError(tr("K"),
                IntsToQString(atts->GetK()));
            atts->SetK(atts->GetK());
        }
    }

    // Do L
    if(which_widget == AxisAlignedSlice4DAttributes::ID_L || doAll)
    {
        intVector val;
        if(L->text().isEmpty() || LineEditGetInts(L, val))
            atts->SetL(val);
        else
        {
            ResettingError(tr("L"),
                IntsToQString(atts->GetL()));
            atts->SetL(atts->GetL());
        }
    }

}


//
// Qt Slot functions
//


void
QvisAxisAlignedSlice4DWindow::IProcessText()
{
    GetCurrentValues(AxisAlignedSlice4DAttributes::ID_I);
    Apply();
}


void
QvisAxisAlignedSlice4DWindow::JProcessText()
{
    GetCurrentValues(AxisAlignedSlice4DAttributes::ID_J);
    Apply();
}


void
QvisAxisAlignedSlice4DWindow::KProcessText()
{
    GetCurrentValues(AxisAlignedSlice4DAttributes::ID_K);
    Apply();
}


void
QvisAxisAlignedSlice4DWindow::LProcessText()
{
    GetCurrentValues(AxisAlignedSlice4DAttributes::ID_L);
    Apply();
}


