/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

// ************************************************************************* //
//  File: avtSmoothFilter.C
// ************************************************************************* //

#include <avtSmoothFilter.h>

#include <vtkPolyData.h>
#include <vtkSmoothPolyDataFilter.h>
#include <vtkGeometryFilter.h>

#include <avtCallback.h>

// ****************************************************************************
//  Method: avtSmoothFilter constructor
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Sun Aug 14 11:59:58 PDT 2005
//
// ****************************************************************************

avtSmoothFilter::avtSmoothFilter()
{
}


// ****************************************************************************
//  Method: avtSmoothFilter destructor
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Sun Aug 14 11:59:58 PDT 2005
//
//  Modifications:
//
// ****************************************************************************

avtSmoothFilter::~avtSmoothFilter()
{
}


// ****************************************************************************
//  Method:  avtSmoothFilter::Create
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Sun Aug 14 11:59:58 PDT 2005
//
// ****************************************************************************

avtFilter *
avtSmoothFilter::Create()
{
    return new avtSmoothFilter();
}


// ****************************************************************************
//  Method:      avtSmoothFilter::SetAtts
//
//  Purpose:
//      Sets the state of the filter based on the attribute object.
//
//  Arguments:
//      a        The attributes to use.
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Sun Aug 14 11:59:58 PDT 2005
//
// ****************************************************************************

void
avtSmoothFilter::SetAtts(const AttributeGroup *a)
{
    atts = *(const SmoothOperatorAttributes*)a;
}


// ****************************************************************************
//  Method: avtSmoothFilter::Equivalent
//
//  Purpose:
//      Returns true if creating a new avtSmoothFilter with the given
//      parameters would result in an equivalent avtSmoothFilter.
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Sun Aug 14 11:59:58 PDT 2005
//
// ****************************************************************************

bool
avtSmoothFilter::Equivalent(const AttributeGroup *a)
{
    return (atts == *(SmoothOperatorAttributes*)a);
}


// ****************************************************************************
//  Method: avtSmoothFilter::PreExecute
//
//  Purpose:
//      Called before ExecuteData, this will initialize issuedWarning.
//
//  Programmer: Hank Childs
//  Creation:   August 14, 2005
//
//  Modifications:
//    Jeremy Meredith, Thu Feb 15 11:55:03 EST 2007
//    Call inherited PreExecute before everything else.
//
//    Jeremy Meredith, Fri Apr 30 16:54:29 EDT 2010
//    Removed warning for non-polydata -- just try to fix it instead.
//
// ****************************************************************************

void
avtSmoothFilter::PreExecute(void)
{
    avtPluginDataTreeIterator::PreExecute();
}


// ****************************************************************************
//  Method: avtSmoothFilter::ExecuteData
//
//  Purpose:
//      Sends the specified input and output through the Smooth filter.
//
//  Arguments:
//      in_dr      The input data representation.
//
//  Returns:       The output data representation.
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Sun Aug 14 11:59:58 PDT 2005
//
//  Modifications:
//    Jeremy Meredith, Fri Apr 30 16:48:54 EDT 2010
//    Even applying the External Surface filter doesn't always give us
//    polydata -- it might be topo-2D structured grids, for example.
//    Instead of warning and doing nothing, just apply the vtkGeometry 
//    filter.  It's not optimal, but generally works.
//
//    Eric Brugger, Thu Aug 14 16:40:25 PDT 2014
//    Modified the class to work with avtDataRepresentation.
//
// ****************************************************************************

avtDataRepresentation *
avtSmoothFilter::ExecuteData(avtDataRepresentation *in_dr)
{
    //
    // Get the VTK data set.
    //
    vtkDataSet *in_ds = in_dr->GetDataVTK();

    // We only work on surface data
    vtkGeometryFilter *geom = NULL;
    vtkSmoothPolyDataFilter *smooth = vtkSmoothPolyDataFilter::New();
    if (in_ds->GetDataObjectType() != VTK_POLY_DATA)
    {
        geom = vtkGeometryFilter::New();
        geom->SetInputData(in_ds);
        smooth->SetInputConnection(geom->GetOutputPort());
        // FIX_ME_VTK6.0, ESB, can we delete geom here since smooth has
        //                     a reference to it? Can the also make geom
        //                     defined locally in the if scope
    }
    else
    {
        smooth->SetInputData(in_ds);
    }

    smooth->SetConvergence(atts.GetConvergence());
    smooth->SetNumberOfIterations(atts.GetNumIterations());
    smooth->SetRelaxationFactor(atts.GetRelaxationFactor());
    smooth->SetFeatureEdgeSmoothing(atts.GetMaintainFeatures());
    smooth->SetFeatureAngle(atts.GetFeatureAngle());
    smooth->SetEdgeAngle(atts.GetEdgeAngle());
    smooth->SetBoundarySmoothing(atts.GetSmoothBoundaries());
    smooth->Update();

    vtkPolyData *output = smooth->GetOutput();

    avtDataRepresentation *out_dr = new avtDataRepresentation(output,
        in_dr->GetDomain(), in_dr->GetLabel());

    smooth->Delete();
    if (geom)
        geom->Delete();

    return out_dr;
}

// ****************************************************************************
// Method: avtSmoothFilter::UpdateDataObjectInfo
//
// Purpose:
//   Update the data object information.
//
// Note:       Work partially supported by DOE Grant SC0007548.
//
// Programmer: Brad Whitlock
// Creation:   Tue Mar 18 10:53:05 PDT 2014
//
// Modifications:
//
// ****************************************************************************

void
avtSmoothFilter::UpdateDataObjectInfo(void)
{
    avtPluginDataTreeIterator::UpdateDataObjectInfo();

    GetOutput()->GetInfo().GetAttributes().AddFilterMetaData("Smooth");
}
