/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <LineSurfaceAttributes.h>
#include <DataNode.h>

// ****************************************************************************
// Method: LineSurfaceAttributes::LineSurfaceAttributes
//
// Purpose: 
//   Init utility for the LineSurfaceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void LineSurfaceAttributes::Init()
{
    startTime = 0;
    endTime = 1;
    stride = 1;
    point1[0] = 0;
    point1[1] = 0;
    point1[2] = 0;
    point2[0] = 0;
    point2[1] = 0;
    point2[2] = 0;

    LineSurfaceAttributes::SelectAll();
}

// ****************************************************************************
// Method: LineSurfaceAttributes::LineSurfaceAttributes
//
// Purpose: 
//   Copy utility for the LineSurfaceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void LineSurfaceAttributes::Copy(const LineSurfaceAttributes &obj)
{
    startTime = obj.startTime;
    endTime = obj.endTime;
    stride = obj.stride;
    point1[0] = obj.point1[0];
    point1[1] = obj.point1[1];
    point1[2] = obj.point1[2];

    point2[0] = obj.point2[0];
    point2[1] = obj.point2[1];
    point2[2] = obj.point2[2];


    LineSurfaceAttributes::SelectAll();
}

// Type map format string
const char *LineSurfaceAttributes::TypeMapFormatString = LINESURFACEATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t LineSurfaceAttributes::TmfsStruct = {LINESURFACEATTRIBUTES_TMFS};


// ****************************************************************************
// Method: LineSurfaceAttributes::LineSurfaceAttributes
//
// Purpose: 
//   Default constructor for the LineSurfaceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

LineSurfaceAttributes::LineSurfaceAttributes() : 
    AttributeSubject(LineSurfaceAttributes::TypeMapFormatString)
{
    LineSurfaceAttributes::Init();
}

// ****************************************************************************
// Method: LineSurfaceAttributes::LineSurfaceAttributes
//
// Purpose: 
//   Constructor for the derived classes of LineSurfaceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

LineSurfaceAttributes::LineSurfaceAttributes(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    LineSurfaceAttributes::Init();
}

// ****************************************************************************
// Method: LineSurfaceAttributes::LineSurfaceAttributes
//
// Purpose: 
//   Copy constructor for the LineSurfaceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

LineSurfaceAttributes::LineSurfaceAttributes(const LineSurfaceAttributes &obj) : 
    AttributeSubject(LineSurfaceAttributes::TypeMapFormatString)
{
    LineSurfaceAttributes::Copy(obj);
}

// ****************************************************************************
// Method: LineSurfaceAttributes::LineSurfaceAttributes
//
// Purpose: 
//   Copy constructor for derived classes of the LineSurfaceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

LineSurfaceAttributes::LineSurfaceAttributes(const LineSurfaceAttributes &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    LineSurfaceAttributes::Copy(obj);
}

// ****************************************************************************
// Method: LineSurfaceAttributes::~LineSurfaceAttributes
//
// Purpose: 
//   Destructor for the LineSurfaceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

LineSurfaceAttributes::~LineSurfaceAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: LineSurfaceAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the LineSurfaceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

LineSurfaceAttributes& 
LineSurfaceAttributes::operator = (const LineSurfaceAttributes &obj)
{
    if (this == &obj) return *this;

    LineSurfaceAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: LineSurfaceAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the LineSurfaceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
LineSurfaceAttributes::operator == (const LineSurfaceAttributes &obj) const
{
    // Compare the point1 arrays.
    bool point1_equal = true;
    for(int i = 0; i < 3 && point1_equal; ++i)
        point1_equal = (point1[i] == obj.point1[i]);

    // Compare the point2 arrays.
    bool point2_equal = true;
    for(int i = 0; i < 3 && point2_equal; ++i)
        point2_equal = (point2[i] == obj.point2[i]);

    // Create the return value
    return ((startTime == obj.startTime) &&
            (endTime == obj.endTime) &&
            (stride == obj.stride) &&
            point1_equal &&
            point2_equal);
}

// ****************************************************************************
// Method: LineSurfaceAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the LineSurfaceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
LineSurfaceAttributes::operator != (const LineSurfaceAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: LineSurfaceAttributes::TypeName
//
// Purpose: 
//   Type name method for the LineSurfaceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
LineSurfaceAttributes::TypeName() const
{
    return "LineSurfaceAttributes";
}

// ****************************************************************************
// Method: LineSurfaceAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the LineSurfaceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
LineSurfaceAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const LineSurfaceAttributes *tmp = (const LineSurfaceAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: LineSurfaceAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the LineSurfaceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
LineSurfaceAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new LineSurfaceAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: LineSurfaceAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the LineSurfaceAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
LineSurfaceAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new LineSurfaceAttributes(*this);
    else
        retval = new LineSurfaceAttributes;

    return retval;
}

// ****************************************************************************
// Method: LineSurfaceAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
LineSurfaceAttributes::SelectAll()
{
    Select(ID_startTime, (void *)&startTime);
    Select(ID_endTime,   (void *)&endTime);
    Select(ID_stride,    (void *)&stride);
    Select(ID_point1,    (void *)point1, 3);
    Select(ID_point2,    (void *)point2, 3);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: LineSurfaceAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
LineSurfaceAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    LineSurfaceAttributes defaultObject;
    bool addToParent = false;
    // Create a node for LineSurfaceAttributes.
    DataNode *node = new DataNode("LineSurfaceAttributes");

    if(completeSave || !FieldsEqual(ID_startTime, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("startTime", startTime));
    }

    if(completeSave || !FieldsEqual(ID_endTime, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("endTime", endTime));
    }

    if(completeSave || !FieldsEqual(ID_stride, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("stride", stride));
    }

    if(completeSave || !FieldsEqual(ID_point1, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("point1", point1, 3));
    }

    if(completeSave || !FieldsEqual(ID_point2, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("point2", point2, 3));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: LineSurfaceAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
LineSurfaceAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("LineSurfaceAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("startTime")) != 0)
        SetStartTime(node->AsInt());
    if((node = searchNode->GetNode("endTime")) != 0)
        SetEndTime(node->AsInt());
    if((node = searchNode->GetNode("stride")) != 0)
        SetStride(node->AsInt());
    if((node = searchNode->GetNode("point1")) != 0)
        SetPoint1(node->AsDoubleArray());
    if((node = searchNode->GetNode("point2")) != 0)
        SetPoint2(node->AsDoubleArray());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
LineSurfaceAttributes::SetStartTime(int startTime_)
{
    startTime = startTime_;
    Select(ID_startTime, (void *)&startTime);
}

void
LineSurfaceAttributes::SetEndTime(int endTime_)
{
    endTime = endTime_;
    Select(ID_endTime, (void *)&endTime);
}

void
LineSurfaceAttributes::SetStride(int stride_)
{
    stride = stride_;
    Select(ID_stride, (void *)&stride);
}

void
LineSurfaceAttributes::SetPoint1(const double *point1_)
{
    point1[0] = point1_[0];
    point1[1] = point1_[1];
    point1[2] = point1_[2];
    Select(ID_point1, (void *)point1, 3);
}

void
LineSurfaceAttributes::SetPoint2(const double *point2_)
{
    point2[0] = point2_[0];
    point2[1] = point2_[1];
    point2[2] = point2_[2];
    Select(ID_point2, (void *)point2, 3);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

int
LineSurfaceAttributes::GetStartTime() const
{
    return startTime;
}

int
LineSurfaceAttributes::GetEndTime() const
{
    return endTime;
}

int
LineSurfaceAttributes::GetStride() const
{
    return stride;
}

const double *
LineSurfaceAttributes::GetPoint1() const
{
    return point1;
}

double *
LineSurfaceAttributes::GetPoint1()
{
    return point1;
}

const double *
LineSurfaceAttributes::GetPoint2() const
{
    return point2;
}

double *
LineSurfaceAttributes::GetPoint2()
{
    return point2;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
LineSurfaceAttributes::SelectPoint1()
{
    Select(ID_point1, (void *)point1, 3);
}

void
LineSurfaceAttributes::SelectPoint2()
{
    Select(ID_point2, (void *)point2, 3);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: LineSurfaceAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
LineSurfaceAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_startTime: return "startTime";
    case ID_endTime:   return "endTime";
    case ID_stride:    return "stride";
    case ID_point1:    return "point1";
    case ID_point2:    return "point2";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: LineSurfaceAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
LineSurfaceAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_startTime: return FieldType_int;
    case ID_endTime:   return FieldType_int;
    case ID_stride:    return FieldType_int;
    case ID_point1:    return FieldType_doubleArray;
    case ID_point2:    return FieldType_doubleArray;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: LineSurfaceAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
LineSurfaceAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_startTime: return "int";
    case ID_endTime:   return "int";
    case ID_stride:    return "int";
    case ID_point1:    return "doubleArray";
    case ID_point2:    return "doubleArray";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: LineSurfaceAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
LineSurfaceAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const LineSurfaceAttributes &obj = *((const LineSurfaceAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_startTime:
        {  // new scope
        retval = (startTime == obj.startTime);
        }
        break;
    case ID_endTime:
        {  // new scope
        retval = (endTime == obj.endTime);
        }
        break;
    case ID_stride:
        {  // new scope
        retval = (stride == obj.stride);
        }
        break;
    case ID_point1:
        {  // new scope
        // Compare the point1 arrays.
        bool point1_equal = true;
        for(int i = 0; i < 3 && point1_equal; ++i)
            point1_equal = (point1[i] == obj.point1[i]);

        retval = point1_equal;
        }
        break;
    case ID_point2:
        {  // new scope
        // Compare the point2 arrays.
        bool point2_equal = true;
        for(int i = 0; i < 3 && point2_equal; ++i)
            point2_equal = (point2[i] == obj.point2[i]);

        retval = point2_equal;
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

