/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <ContextAttributes.h>
#include <DataNode.h>

//
// Enum conversion methods for ContextAttributes::Amount
//

static const char *Amount_strings[] = {
"Some", "All"};

std::string
ContextAttributes::Amount_ToString(ContextAttributes::Amount t)
{
    int index = int(t);
    if(index < 0 || index >= 2) index = 0;
    return Amount_strings[index];
}

std::string
ContextAttributes::Amount_ToString(int t)
{
    int index = (t < 0 || t >= 2) ? 0 : t;
    return Amount_strings[index];
}

bool
ContextAttributes::Amount_FromString(const std::string &s, ContextAttributes::Amount &val)
{
    val = ContextAttributes::Some;
    for(int i = 0; i < 2; ++i)
    {
        if(s == Amount_strings[i])
        {
            val = (Amount)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: ContextAttributes::ContextAttributes
//
// Purpose: 
//   Init utility for the ContextAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void ContextAttributes::Init()
{
    offset = 2;
    low = 2;
    hi = 2;
    cutoff = 0;
    below = 0;
    above = 1;

    ContextAttributes::SelectAll();
}

// ****************************************************************************
// Method: ContextAttributes::ContextAttributes
//
// Purpose: 
//   Copy utility for the ContextAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void ContextAttributes::Copy(const ContextAttributes &obj)
{
    offset = obj.offset;
    low = obj.low;
    hi = obj.hi;
    context = obj.context;
    cutoff = obj.cutoff;
    below = obj.below;
    above = obj.above;

    ContextAttributes::SelectAll();
}

// Type map format string
const char *ContextAttributes::TypeMapFormatString = CONTEXTATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t ContextAttributes::TmfsStruct = {CONTEXTATTRIBUTES_TMFS};


// ****************************************************************************
// Method: ContextAttributes::ContextAttributes
//
// Purpose: 
//   Default constructor for the ContextAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ContextAttributes::ContextAttributes() : 
    AttributeSubject(ContextAttributes::TypeMapFormatString),
    context("default")
{
    ContextAttributes::Init();
}

// ****************************************************************************
// Method: ContextAttributes::ContextAttributes
//
// Purpose: 
//   Constructor for the derived classes of ContextAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ContextAttributes::ContextAttributes(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs),
    context("default")
{
    ContextAttributes::Init();
}

// ****************************************************************************
// Method: ContextAttributes::ContextAttributes
//
// Purpose: 
//   Copy constructor for the ContextAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ContextAttributes::ContextAttributes(const ContextAttributes &obj) : 
    AttributeSubject(ContextAttributes::TypeMapFormatString)
{
    ContextAttributes::Copy(obj);
}

// ****************************************************************************
// Method: ContextAttributes::ContextAttributes
//
// Purpose: 
//   Copy constructor for derived classes of the ContextAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ContextAttributes::ContextAttributes(const ContextAttributes &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    ContextAttributes::Copy(obj);
}

// ****************************************************************************
// Method: ContextAttributes::~ContextAttributes
//
// Purpose: 
//   Destructor for the ContextAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ContextAttributes::~ContextAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: ContextAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the ContextAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ContextAttributes& 
ContextAttributes::operator = (const ContextAttributes &obj)
{
    if (this == &obj) return *this;

    ContextAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: ContextAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the ContextAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ContextAttributes::operator == (const ContextAttributes &obj) const
{
    // Create the return value
    return ((offset == obj.offset) &&
            (low == obj.low) &&
            (hi == obj.hi) &&
            (context == obj.context) &&
            (cutoff == obj.cutoff) &&
            (below == obj.below) &&
            (above == obj.above));
}

// ****************************************************************************
// Method: ContextAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the ContextAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ContextAttributes::operator != (const ContextAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: ContextAttributes::TypeName
//
// Purpose: 
//   Type name method for the ContextAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
ContextAttributes::TypeName() const
{
    return "ContextAttributes";
}

// ****************************************************************************
// Method: ContextAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the ContextAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ContextAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const ContextAttributes *tmp = (const ContextAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: ContextAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the ContextAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
ContextAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new ContextAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: ContextAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the ContextAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
ContextAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new ContextAttributes(*this);
    else
        retval = new ContextAttributes;

    return retval;
}

// ****************************************************************************
// Method: ContextAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
ContextAttributes::SelectAll()
{
    Select(ID_offset,  (void *)&offset);
    Select(ID_low,     (void *)&low);
    Select(ID_hi,      (void *)&hi);
    Select(ID_context, (void *)&context);
    Select(ID_cutoff,  (void *)&cutoff);
    Select(ID_below,   (void *)&below);
    Select(ID_above,   (void *)&above);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ContextAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ContextAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    ContextAttributes defaultObject;
    bool addToParent = false;
    // Create a node for ContextAttributes.
    DataNode *node = new DataNode("ContextAttributes");

    if(completeSave || !FieldsEqual(ID_offset, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("offset", offset));
    }

    if(completeSave || !FieldsEqual(ID_low, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("low", low));
    }

    if(completeSave || !FieldsEqual(ID_hi, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("hi", hi));
    }

    if(completeSave || !FieldsEqual(ID_context, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("context", context));
    }

    if(completeSave || !FieldsEqual(ID_cutoff, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("cutoff", cutoff));
    }

    if(completeSave || !FieldsEqual(ID_below, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("below", below));
    }

    if(completeSave || !FieldsEqual(ID_above, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("above", above));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: ContextAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
ContextAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("ContextAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("offset")) != 0)
        SetOffset(node->AsDouble());
    if((node = searchNode->GetNode("low")) != 0)
        SetLow(node->AsDouble());
    if((node = searchNode->GetNode("hi")) != 0)
        SetHi(node->AsDouble());
    if((node = searchNode->GetNode("context")) != 0)
        SetContext(node->AsString());
    if((node = searchNode->GetNode("cutoff")) != 0)
        SetCutoff(node->AsDouble());
    if((node = searchNode->GetNode("below")) != 0)
        SetBelow(node->AsDouble());
    if((node = searchNode->GetNode("above")) != 0)
        SetAbove(node->AsDouble());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
ContextAttributes::SetOffset(double offset_)
{
    offset = offset_;
    Select(ID_offset, (void *)&offset);
}

void
ContextAttributes::SetLow(double low_)
{
    low = low_;
    Select(ID_low, (void *)&low);
}

void
ContextAttributes::SetHi(double hi_)
{
    hi = hi_;
    Select(ID_hi, (void *)&hi);
}

void
ContextAttributes::SetContext(const std::string &context_)
{
    context = context_;
    Select(ID_context, (void *)&context);
}

void
ContextAttributes::SetCutoff(double cutoff_)
{
    cutoff = cutoff_;
    Select(ID_cutoff, (void *)&cutoff);
}

void
ContextAttributes::SetBelow(double below_)
{
    below = below_;
    Select(ID_below, (void *)&below);
}

void
ContextAttributes::SetAbove(double above_)
{
    above = above_;
    Select(ID_above, (void *)&above);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

double
ContextAttributes::GetOffset() const
{
    return offset;
}

double
ContextAttributes::GetLow() const
{
    return low;
}

double
ContextAttributes::GetHi() const
{
    return hi;
}

const std::string &
ContextAttributes::GetContext() const
{
    return context;
}

std::string &
ContextAttributes::GetContext()
{
    return context;
}

double
ContextAttributes::GetCutoff() const
{
    return cutoff;
}

double
ContextAttributes::GetBelow() const
{
    return below;
}

double
ContextAttributes::GetAbove() const
{
    return above;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
ContextAttributes::SelectContext()
{
    Select(ID_context, (void *)&context);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ContextAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
ContextAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_offset:  return "offset";
    case ID_low:     return "low";
    case ID_hi:      return "hi";
    case ID_context: return "context";
    case ID_cutoff:  return "cutoff";
    case ID_below:   return "below";
    case ID_above:   return "above";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ContextAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
ContextAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_offset:  return FieldType_double;
    case ID_low:     return FieldType_double;
    case ID_hi:      return FieldType_double;
    case ID_context: return FieldType_variablename;
    case ID_cutoff:  return FieldType_double;
    case ID_below:   return FieldType_double;
    case ID_above:   return FieldType_double;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: ContextAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
ContextAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_offset:  return "double";
    case ID_low:     return "double";
    case ID_hi:      return "double";
    case ID_context: return "variablename";
    case ID_cutoff:  return "double";
    case ID_below:   return "double";
    case ID_above:   return "double";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ContextAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ContextAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const ContextAttributes &obj = *((const ContextAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_offset:
        {  // new scope
        retval = (offset == obj.offset);
        }
        break;
    case ID_low:
        {  // new scope
        retval = (low == obj.low);
        }
        break;
    case ID_hi:
        {  // new scope
        retval = (hi == obj.hi);
        }
        break;
    case ID_context:
        {  // new scope
        retval = (context == obj.context);
        }
        break;
    case ID_cutoff:
        {  // new scope
        retval = (cutoff == obj.cutoff);
        }
        break;
    case ID_below:
        {  // new scope
        retval = (below == obj.below);
        }
        break;
    case ID_above:
        {  // new scope
        retval = (above == obj.above);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

