/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyTransformAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PyTransformAttributes
//
// Purpose: 
//   This class contains attributes for the transform operator.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a TransformAttributes.
//
struct TransformAttributesObject
{
    PyObject_HEAD
    TransformAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewTransformAttributes(int);

std::string
PyTransformAttributes_ToString(const TransformAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    if(atts->GetDoRotate())
        SNPRINTF(tmpStr, 1000, "%sdoRotate = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sdoRotate = 0\n", prefix);
    str += tmpStr;
    {   const double *rotateOrigin = atts->GetRotateOrigin();
        SNPRINTF(tmpStr, 1000, "%srotateOrigin = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", rotateOrigin[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const double *rotateAxis = atts->GetRotateAxis();
        SNPRINTF(tmpStr, 1000, "%srotateAxis = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", rotateAxis[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    SNPRINTF(tmpStr, 1000, "%srotateAmount = %g\n", prefix, atts->GetRotateAmount());
    str += tmpStr;
    const char *rotateType_names = "Deg, Rad";
    switch (atts->GetRotateType())
    {
      case TransformAttributes::Deg:
          SNPRINTF(tmpStr, 1000, "%srotateType = %sDeg  # %s\n", prefix, prefix, rotateType_names);
          str += tmpStr;
          break;
      case TransformAttributes::Rad:
          SNPRINTF(tmpStr, 1000, "%srotateType = %sRad  # %s\n", prefix, prefix, rotateType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    if(atts->GetDoScale())
        SNPRINTF(tmpStr, 1000, "%sdoScale = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sdoScale = 0\n", prefix);
    str += tmpStr;
    {   const double *scaleOrigin = atts->GetScaleOrigin();
        SNPRINTF(tmpStr, 1000, "%sscaleOrigin = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", scaleOrigin[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    SNPRINTF(tmpStr, 1000, "%sscaleX = %g\n", prefix, atts->GetScaleX());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sscaleY = %g\n", prefix, atts->GetScaleY());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sscaleZ = %g\n", prefix, atts->GetScaleZ());
    str += tmpStr;
    if(atts->GetDoTranslate())
        SNPRINTF(tmpStr, 1000, "%sdoTranslate = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sdoTranslate = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%stranslateX = %g\n", prefix, atts->GetTranslateX());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%stranslateY = %g\n", prefix, atts->GetTranslateY());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%stranslateZ = %g\n", prefix, atts->GetTranslateZ());
    str += tmpStr;
    const char *transformType_names = "Similarity, Coordinate, Linear";
    switch (atts->GetTransformType())
    {
      case TransformAttributes::Similarity:
          SNPRINTF(tmpStr, 1000, "%stransformType = %sSimilarity  # %s\n", prefix, prefix, transformType_names);
          str += tmpStr;
          break;
      case TransformAttributes::Coordinate:
          SNPRINTF(tmpStr, 1000, "%stransformType = %sCoordinate  # %s\n", prefix, prefix, transformType_names);
          str += tmpStr;
          break;
      case TransformAttributes::Linear:
          SNPRINTF(tmpStr, 1000, "%stransformType = %sLinear  # %s\n", prefix, prefix, transformType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const char *inputCoordSys_names = "Cartesian, Cylindrical, Spherical";
    switch (atts->GetInputCoordSys())
    {
      case TransformAttributes::Cartesian:
          SNPRINTF(tmpStr, 1000, "%sinputCoordSys = %sCartesian  # %s\n", prefix, prefix, inputCoordSys_names);
          str += tmpStr;
          break;
      case TransformAttributes::Cylindrical:
          SNPRINTF(tmpStr, 1000, "%sinputCoordSys = %sCylindrical  # %s\n", prefix, prefix, inputCoordSys_names);
          str += tmpStr;
          break;
      case TransformAttributes::Spherical:
          SNPRINTF(tmpStr, 1000, "%sinputCoordSys = %sSpherical  # %s\n", prefix, prefix, inputCoordSys_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const char *outputCoordSys_names = "Cartesian, Cylindrical, Spherical";
    switch (atts->GetOutputCoordSys())
    {
      case TransformAttributes::Cartesian:
          SNPRINTF(tmpStr, 1000, "%soutputCoordSys = %sCartesian  # %s\n", prefix, prefix, outputCoordSys_names);
          str += tmpStr;
          break;
      case TransformAttributes::Cylindrical:
          SNPRINTF(tmpStr, 1000, "%soutputCoordSys = %sCylindrical  # %s\n", prefix, prefix, outputCoordSys_names);
          str += tmpStr;
          break;
      case TransformAttributes::Spherical:
          SNPRINTF(tmpStr, 1000, "%soutputCoordSys = %sSpherical  # %s\n", prefix, prefix, outputCoordSys_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    if(atts->GetContinuousPhi())
        SNPRINTF(tmpStr, 1000, "%scontinuousPhi = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%scontinuousPhi = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sm00 = %g\n", prefix, atts->GetM00());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sm01 = %g\n", prefix, atts->GetM01());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sm02 = %g\n", prefix, atts->GetM02());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sm03 = %g\n", prefix, atts->GetM03());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sm10 = %g\n", prefix, atts->GetM10());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sm11 = %g\n", prefix, atts->GetM11());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sm12 = %g\n", prefix, atts->GetM12());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sm13 = %g\n", prefix, atts->GetM13());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sm20 = %g\n", prefix, atts->GetM20());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sm21 = %g\n", prefix, atts->GetM21());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sm22 = %g\n", prefix, atts->GetM22());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sm23 = %g\n", prefix, atts->GetM23());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sm30 = %g\n", prefix, atts->GetM30());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sm31 = %g\n", prefix, atts->GetM31());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sm32 = %g\n", prefix, atts->GetM32());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sm33 = %g\n", prefix, atts->GetM33());
    str += tmpStr;
    if(atts->GetInvertLinearTransform())
        SNPRINTF(tmpStr, 1000, "%sinvertLinearTransform = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sinvertLinearTransform = 0\n", prefix);
    str += tmpStr;
    const char *vectorTransformMethod_names = "None, AsPoint, AsDisplacement, AsDirection";
    switch (atts->GetVectorTransformMethod())
    {
      case TransformAttributes::None:
          SNPRINTF(tmpStr, 1000, "%svectorTransformMethod = %sNone  # %s\n", prefix, prefix, vectorTransformMethod_names);
          str += tmpStr;
          break;
      case TransformAttributes::AsPoint:
          SNPRINTF(tmpStr, 1000, "%svectorTransformMethod = %sAsPoint  # %s\n", prefix, prefix, vectorTransformMethod_names);
          str += tmpStr;
          break;
      case TransformAttributes::AsDisplacement:
          SNPRINTF(tmpStr, 1000, "%svectorTransformMethod = %sAsDisplacement  # %s\n", prefix, prefix, vectorTransformMethod_names);
          str += tmpStr;
          break;
      case TransformAttributes::AsDirection:
          SNPRINTF(tmpStr, 1000, "%svectorTransformMethod = %sAsDirection  # %s\n", prefix, prefix, vectorTransformMethod_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    if(atts->GetTransformVectors())
        SNPRINTF(tmpStr, 1000, "%stransformVectors = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%stransformVectors = 0\n", prefix);
    str += tmpStr;
    return str;
}

static PyObject *
TransformAttributes_Notify(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TransformAttributes_SetDoRotate(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the doRotate in the object.
    obj->data->SetDoRotate(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TransformAttributes_GetDoRotate(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetDoRotate()?1L:0L);
    return retval;
}

/*static*/ PyObject *
TransformAttributes_SetRotateOrigin(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    double *dvals = obj->data->GetRotateOrigin();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the rotateOrigin in the object as modified.
    obj->data->SelectRotateOrigin();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TransformAttributes_GetRotateOrigin(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the rotateOrigin.
    PyObject *retval = PyTuple_New(3);
    const double *rotateOrigin = obj->data->GetRotateOrigin();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(rotateOrigin[i]));
    return retval;
}

/*static*/ PyObject *
TransformAttributes_SetRotateAxis(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    double *dvals = obj->data->GetRotateAxis();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the rotateAxis in the object as modified.
    obj->data->SelectRotateAxis();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TransformAttributes_GetRotateAxis(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the rotateAxis.
    PyObject *retval = PyTuple_New(3);
    const double *rotateAxis = obj->data->GetRotateAxis();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(rotateAxis[i]));
    return retval;
}

/*static*/ PyObject *
TransformAttributes_SetRotateAmount(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the rotateAmount in the object.
    obj->data->SetRotateAmount(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TransformAttributes_GetRotateAmount(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetRotateAmount());
    return retval;
}

/*static*/ PyObject *
TransformAttributes_SetRotateType(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the rotateType in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetRotateType(TransformAttributes::AngleType(ival));
    else
    {
        fprintf(stderr, "An invalid rotateType value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "Deg, Rad.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TransformAttributes_GetRotateType(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetRotateType()));
    return retval;
}

/*static*/ PyObject *
TransformAttributes_SetDoScale(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the doScale in the object.
    obj->data->SetDoScale(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TransformAttributes_GetDoScale(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetDoScale()?1L:0L);
    return retval;
}

/*static*/ PyObject *
TransformAttributes_SetScaleOrigin(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    double *dvals = obj->data->GetScaleOrigin();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the scaleOrigin in the object as modified.
    obj->data->SelectScaleOrigin();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TransformAttributes_GetScaleOrigin(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the scaleOrigin.
    PyObject *retval = PyTuple_New(3);
    const double *scaleOrigin = obj->data->GetScaleOrigin();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(scaleOrigin[i]));
    return retval;
}

/*static*/ PyObject *
TransformAttributes_SetScaleX(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the scaleX in the object.
    obj->data->SetScaleX(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TransformAttributes_GetScaleX(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetScaleX());
    return retval;
}

/*static*/ PyObject *
TransformAttributes_SetScaleY(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the scaleY in the object.
    obj->data->SetScaleY(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TransformAttributes_GetScaleY(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetScaleY());
    return retval;
}

/*static*/ PyObject *
TransformAttributes_SetScaleZ(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the scaleZ in the object.
    obj->data->SetScaleZ(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TransformAttributes_GetScaleZ(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetScaleZ());
    return retval;
}

/*static*/ PyObject *
TransformAttributes_SetDoTranslate(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the doTranslate in the object.
    obj->data->SetDoTranslate(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TransformAttributes_GetDoTranslate(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetDoTranslate()?1L:0L);
    return retval;
}

/*static*/ PyObject *
TransformAttributes_SetTranslateX(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the translateX in the object.
    obj->data->SetTranslateX(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TransformAttributes_GetTranslateX(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetTranslateX());
    return retval;
}

/*static*/ PyObject *
TransformAttributes_SetTranslateY(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the translateY in the object.
    obj->data->SetTranslateY(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TransformAttributes_GetTranslateY(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetTranslateY());
    return retval;
}

/*static*/ PyObject *
TransformAttributes_SetTranslateZ(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the translateZ in the object.
    obj->data->SetTranslateZ(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TransformAttributes_GetTranslateZ(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetTranslateZ());
    return retval;
}

/*static*/ PyObject *
TransformAttributes_SetTransformType(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the transformType in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetTransformType(TransformAttributes::TransformType(ival));
    else
    {
        fprintf(stderr, "An invalid transformType value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Similarity, Coordinate, Linear.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TransformAttributes_GetTransformType(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetTransformType()));
    return retval;
}

/*static*/ PyObject *
TransformAttributes_SetInputCoordSys(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the inputCoordSys in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetInputCoordSys(TransformAttributes::CoordinateSystem(ival));
    else
    {
        fprintf(stderr, "An invalid inputCoordSys value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Cartesian, Cylindrical, Spherical.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TransformAttributes_GetInputCoordSys(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetInputCoordSys()));
    return retval;
}

/*static*/ PyObject *
TransformAttributes_SetOutputCoordSys(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the outputCoordSys in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetOutputCoordSys(TransformAttributes::CoordinateSystem(ival));
    else
    {
        fprintf(stderr, "An invalid outputCoordSys value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Cartesian, Cylindrical, Spherical.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TransformAttributes_GetOutputCoordSys(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetOutputCoordSys()));
    return retval;
}

/*static*/ PyObject *
TransformAttributes_SetContinuousPhi(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the continuousPhi in the object.
    obj->data->SetContinuousPhi(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TransformAttributes_GetContinuousPhi(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetContinuousPhi()?1L:0L);
    return retval;
}

/*static*/ PyObject *
TransformAttributes_SetM00(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the m00 in the object.
    obj->data->SetM00(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TransformAttributes_GetM00(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetM00());
    return retval;
}

/*static*/ PyObject *
TransformAttributes_SetM01(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the m01 in the object.
    obj->data->SetM01(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TransformAttributes_GetM01(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetM01());
    return retval;
}

/*static*/ PyObject *
TransformAttributes_SetM02(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the m02 in the object.
    obj->data->SetM02(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TransformAttributes_GetM02(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetM02());
    return retval;
}

/*static*/ PyObject *
TransformAttributes_SetM03(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the m03 in the object.
    obj->data->SetM03(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TransformAttributes_GetM03(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetM03());
    return retval;
}

/*static*/ PyObject *
TransformAttributes_SetM10(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the m10 in the object.
    obj->data->SetM10(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TransformAttributes_GetM10(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetM10());
    return retval;
}

/*static*/ PyObject *
TransformAttributes_SetM11(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the m11 in the object.
    obj->data->SetM11(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TransformAttributes_GetM11(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetM11());
    return retval;
}

/*static*/ PyObject *
TransformAttributes_SetM12(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the m12 in the object.
    obj->data->SetM12(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TransformAttributes_GetM12(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetM12());
    return retval;
}

/*static*/ PyObject *
TransformAttributes_SetM13(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the m13 in the object.
    obj->data->SetM13(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TransformAttributes_GetM13(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetM13());
    return retval;
}

/*static*/ PyObject *
TransformAttributes_SetM20(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the m20 in the object.
    obj->data->SetM20(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TransformAttributes_GetM20(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetM20());
    return retval;
}

/*static*/ PyObject *
TransformAttributes_SetM21(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the m21 in the object.
    obj->data->SetM21(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TransformAttributes_GetM21(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetM21());
    return retval;
}

/*static*/ PyObject *
TransformAttributes_SetM22(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the m22 in the object.
    obj->data->SetM22(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TransformAttributes_GetM22(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetM22());
    return retval;
}

/*static*/ PyObject *
TransformAttributes_SetM23(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the m23 in the object.
    obj->data->SetM23(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TransformAttributes_GetM23(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetM23());
    return retval;
}

/*static*/ PyObject *
TransformAttributes_SetM30(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the m30 in the object.
    obj->data->SetM30(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TransformAttributes_GetM30(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetM30());
    return retval;
}

/*static*/ PyObject *
TransformAttributes_SetM31(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the m31 in the object.
    obj->data->SetM31(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TransformAttributes_GetM31(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetM31());
    return retval;
}

/*static*/ PyObject *
TransformAttributes_SetM32(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the m32 in the object.
    obj->data->SetM32(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TransformAttributes_GetM32(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetM32());
    return retval;
}

/*static*/ PyObject *
TransformAttributes_SetM33(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the m33 in the object.
    obj->data->SetM33(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TransformAttributes_GetM33(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetM33());
    return retval;
}

/*static*/ PyObject *
TransformAttributes_SetInvertLinearTransform(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the invertLinearTransform in the object.
    obj->data->SetInvertLinearTransform(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TransformAttributes_GetInvertLinearTransform(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetInvertLinearTransform()?1L:0L);
    return retval;
}

/*static*/ PyObject *
TransformAttributes_SetVectorTransformMethod(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the vectorTransformMethod in the object.
    if(ival >= 0 && ival < 4)
        obj->data->SetVectorTransformMethod(TransformAttributes::VectorTransformMethod(ival));
    else
    {
        fprintf(stderr, "An invalid vectorTransformMethod value was given. "
                        "Valid values are in the range of [0,3]. "
                        "You can also use the following names: "
                        "None, AsPoint, AsDisplacement, AsDirection.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TransformAttributes_GetVectorTransformMethod(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetVectorTransformMethod()));
    return retval;
}

/*static*/ PyObject *
TransformAttributes_SetTransformVectors(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the transformVectors in the object.
    obj->data->SetTransformVectors(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TransformAttributes_GetTransformVectors(PyObject *self, PyObject *args)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetTransformVectors()?1L:0L);
    return retval;
}



PyMethodDef PyTransformAttributes_methods[TRANSFORMATTRIBUTES_NMETH] = {
    {"Notify", TransformAttributes_Notify, METH_VARARGS},
    {"SetDoRotate", TransformAttributes_SetDoRotate, METH_VARARGS},
    {"GetDoRotate", TransformAttributes_GetDoRotate, METH_VARARGS},
    {"SetRotateOrigin", TransformAttributes_SetRotateOrigin, METH_VARARGS},
    {"GetRotateOrigin", TransformAttributes_GetRotateOrigin, METH_VARARGS},
    {"SetRotateAxis", TransformAttributes_SetRotateAxis, METH_VARARGS},
    {"GetRotateAxis", TransformAttributes_GetRotateAxis, METH_VARARGS},
    {"SetRotateAmount", TransformAttributes_SetRotateAmount, METH_VARARGS},
    {"GetRotateAmount", TransformAttributes_GetRotateAmount, METH_VARARGS},
    {"SetRotateType", TransformAttributes_SetRotateType, METH_VARARGS},
    {"GetRotateType", TransformAttributes_GetRotateType, METH_VARARGS},
    {"SetDoScale", TransformAttributes_SetDoScale, METH_VARARGS},
    {"GetDoScale", TransformAttributes_GetDoScale, METH_VARARGS},
    {"SetScaleOrigin", TransformAttributes_SetScaleOrigin, METH_VARARGS},
    {"GetScaleOrigin", TransformAttributes_GetScaleOrigin, METH_VARARGS},
    {"SetScaleX", TransformAttributes_SetScaleX, METH_VARARGS},
    {"GetScaleX", TransformAttributes_GetScaleX, METH_VARARGS},
    {"SetScaleY", TransformAttributes_SetScaleY, METH_VARARGS},
    {"GetScaleY", TransformAttributes_GetScaleY, METH_VARARGS},
    {"SetScaleZ", TransformAttributes_SetScaleZ, METH_VARARGS},
    {"GetScaleZ", TransformAttributes_GetScaleZ, METH_VARARGS},
    {"SetDoTranslate", TransformAttributes_SetDoTranslate, METH_VARARGS},
    {"GetDoTranslate", TransformAttributes_GetDoTranslate, METH_VARARGS},
    {"SetTranslateX", TransformAttributes_SetTranslateX, METH_VARARGS},
    {"GetTranslateX", TransformAttributes_GetTranslateX, METH_VARARGS},
    {"SetTranslateY", TransformAttributes_SetTranslateY, METH_VARARGS},
    {"GetTranslateY", TransformAttributes_GetTranslateY, METH_VARARGS},
    {"SetTranslateZ", TransformAttributes_SetTranslateZ, METH_VARARGS},
    {"GetTranslateZ", TransformAttributes_GetTranslateZ, METH_VARARGS},
    {"SetTransformType", TransformAttributes_SetTransformType, METH_VARARGS},
    {"GetTransformType", TransformAttributes_GetTransformType, METH_VARARGS},
    {"SetInputCoordSys", TransformAttributes_SetInputCoordSys, METH_VARARGS},
    {"GetInputCoordSys", TransformAttributes_GetInputCoordSys, METH_VARARGS},
    {"SetOutputCoordSys", TransformAttributes_SetOutputCoordSys, METH_VARARGS},
    {"GetOutputCoordSys", TransformAttributes_GetOutputCoordSys, METH_VARARGS},
    {"SetContinuousPhi", TransformAttributes_SetContinuousPhi, METH_VARARGS},
    {"GetContinuousPhi", TransformAttributes_GetContinuousPhi, METH_VARARGS},
    {"SetM00", TransformAttributes_SetM00, METH_VARARGS},
    {"GetM00", TransformAttributes_GetM00, METH_VARARGS},
    {"SetM01", TransformAttributes_SetM01, METH_VARARGS},
    {"GetM01", TransformAttributes_GetM01, METH_VARARGS},
    {"SetM02", TransformAttributes_SetM02, METH_VARARGS},
    {"GetM02", TransformAttributes_GetM02, METH_VARARGS},
    {"SetM03", TransformAttributes_SetM03, METH_VARARGS},
    {"GetM03", TransformAttributes_GetM03, METH_VARARGS},
    {"SetM10", TransformAttributes_SetM10, METH_VARARGS},
    {"GetM10", TransformAttributes_GetM10, METH_VARARGS},
    {"SetM11", TransformAttributes_SetM11, METH_VARARGS},
    {"GetM11", TransformAttributes_GetM11, METH_VARARGS},
    {"SetM12", TransformAttributes_SetM12, METH_VARARGS},
    {"GetM12", TransformAttributes_GetM12, METH_VARARGS},
    {"SetM13", TransformAttributes_SetM13, METH_VARARGS},
    {"GetM13", TransformAttributes_GetM13, METH_VARARGS},
    {"SetM20", TransformAttributes_SetM20, METH_VARARGS},
    {"GetM20", TransformAttributes_GetM20, METH_VARARGS},
    {"SetM21", TransformAttributes_SetM21, METH_VARARGS},
    {"GetM21", TransformAttributes_GetM21, METH_VARARGS},
    {"SetM22", TransformAttributes_SetM22, METH_VARARGS},
    {"GetM22", TransformAttributes_GetM22, METH_VARARGS},
    {"SetM23", TransformAttributes_SetM23, METH_VARARGS},
    {"GetM23", TransformAttributes_GetM23, METH_VARARGS},
    {"SetM30", TransformAttributes_SetM30, METH_VARARGS},
    {"GetM30", TransformAttributes_GetM30, METH_VARARGS},
    {"SetM31", TransformAttributes_SetM31, METH_VARARGS},
    {"GetM31", TransformAttributes_GetM31, METH_VARARGS},
    {"SetM32", TransformAttributes_SetM32, METH_VARARGS},
    {"GetM32", TransformAttributes_GetM32, METH_VARARGS},
    {"SetM33", TransformAttributes_SetM33, METH_VARARGS},
    {"GetM33", TransformAttributes_GetM33, METH_VARARGS},
    {"SetInvertLinearTransform", TransformAttributes_SetInvertLinearTransform, METH_VARARGS},
    {"GetInvertLinearTransform", TransformAttributes_GetInvertLinearTransform, METH_VARARGS},
    {"SetVectorTransformMethod", TransformAttributes_SetVectorTransformMethod, METH_VARARGS},
    {"GetVectorTransformMethod", TransformAttributes_GetVectorTransformMethod, METH_VARARGS},
    {"SetTransformVectors", TransformAttributes_SetTransformVectors, METH_VARARGS},
    {"GetTransformVectors", TransformAttributes_GetTransformVectors, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
TransformAttributes_dealloc(PyObject *v)
{
   TransformAttributesObject *obj = (TransformAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
TransformAttributes_compare(PyObject *v, PyObject *w)
{
    TransformAttributes *a = ((TransformAttributesObject *)v)->data;
    TransformAttributes *b = ((TransformAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyTransformAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "doRotate") == 0)
        return TransformAttributes_GetDoRotate(self, NULL);
    if(strcmp(name, "rotateOrigin") == 0)
        return TransformAttributes_GetRotateOrigin(self, NULL);
    if(strcmp(name, "rotateAxis") == 0)
        return TransformAttributes_GetRotateAxis(self, NULL);
    if(strcmp(name, "rotateAmount") == 0)
        return TransformAttributes_GetRotateAmount(self, NULL);
    if(strcmp(name, "rotateType") == 0)
        return TransformAttributes_GetRotateType(self, NULL);
    if(strcmp(name, "Deg") == 0)
        return PyInt_FromLong(long(TransformAttributes::Deg));
    if(strcmp(name, "Rad") == 0)
        return PyInt_FromLong(long(TransformAttributes::Rad));

    if(strcmp(name, "doScale") == 0)
        return TransformAttributes_GetDoScale(self, NULL);
    if(strcmp(name, "scaleOrigin") == 0)
        return TransformAttributes_GetScaleOrigin(self, NULL);
    if(strcmp(name, "scaleX") == 0)
        return TransformAttributes_GetScaleX(self, NULL);
    if(strcmp(name, "scaleY") == 0)
        return TransformAttributes_GetScaleY(self, NULL);
    if(strcmp(name, "scaleZ") == 0)
        return TransformAttributes_GetScaleZ(self, NULL);
    if(strcmp(name, "doTranslate") == 0)
        return TransformAttributes_GetDoTranslate(self, NULL);
    if(strcmp(name, "translateX") == 0)
        return TransformAttributes_GetTranslateX(self, NULL);
    if(strcmp(name, "translateY") == 0)
        return TransformAttributes_GetTranslateY(self, NULL);
    if(strcmp(name, "translateZ") == 0)
        return TransformAttributes_GetTranslateZ(self, NULL);
    if(strcmp(name, "transformType") == 0)
        return TransformAttributes_GetTransformType(self, NULL);
    if(strcmp(name, "Similarity") == 0)
        return PyInt_FromLong(long(TransformAttributes::Similarity));
    if(strcmp(name, "Coordinate") == 0)
        return PyInt_FromLong(long(TransformAttributes::Coordinate));
    if(strcmp(name, "Linear") == 0)
        return PyInt_FromLong(long(TransformAttributes::Linear));

    if(strcmp(name, "inputCoordSys") == 0)
        return TransformAttributes_GetInputCoordSys(self, NULL);
    if(strcmp(name, "Cartesian") == 0)
        return PyInt_FromLong(long(TransformAttributes::Cartesian));
    if(strcmp(name, "Cylindrical") == 0)
        return PyInt_FromLong(long(TransformAttributes::Cylindrical));
    if(strcmp(name, "Spherical") == 0)
        return PyInt_FromLong(long(TransformAttributes::Spherical));

    if(strcmp(name, "outputCoordSys") == 0)
        return TransformAttributes_GetOutputCoordSys(self, NULL);
    if(strcmp(name, "Cartesian") == 0)
        return PyInt_FromLong(long(TransformAttributes::Cartesian));
    if(strcmp(name, "Cylindrical") == 0)
        return PyInt_FromLong(long(TransformAttributes::Cylindrical));
    if(strcmp(name, "Spherical") == 0)
        return PyInt_FromLong(long(TransformAttributes::Spherical));

    if(strcmp(name, "continuousPhi") == 0)
        return TransformAttributes_GetContinuousPhi(self, NULL);
    if(strcmp(name, "m00") == 0)
        return TransformAttributes_GetM00(self, NULL);
    if(strcmp(name, "m01") == 0)
        return TransformAttributes_GetM01(self, NULL);
    if(strcmp(name, "m02") == 0)
        return TransformAttributes_GetM02(self, NULL);
    if(strcmp(name, "m03") == 0)
        return TransformAttributes_GetM03(self, NULL);
    if(strcmp(name, "m10") == 0)
        return TransformAttributes_GetM10(self, NULL);
    if(strcmp(name, "m11") == 0)
        return TransformAttributes_GetM11(self, NULL);
    if(strcmp(name, "m12") == 0)
        return TransformAttributes_GetM12(self, NULL);
    if(strcmp(name, "m13") == 0)
        return TransformAttributes_GetM13(self, NULL);
    if(strcmp(name, "m20") == 0)
        return TransformAttributes_GetM20(self, NULL);
    if(strcmp(name, "m21") == 0)
        return TransformAttributes_GetM21(self, NULL);
    if(strcmp(name, "m22") == 0)
        return TransformAttributes_GetM22(self, NULL);
    if(strcmp(name, "m23") == 0)
        return TransformAttributes_GetM23(self, NULL);
    if(strcmp(name, "m30") == 0)
        return TransformAttributes_GetM30(self, NULL);
    if(strcmp(name, "m31") == 0)
        return TransformAttributes_GetM31(self, NULL);
    if(strcmp(name, "m32") == 0)
        return TransformAttributes_GetM32(self, NULL);
    if(strcmp(name, "m33") == 0)
        return TransformAttributes_GetM33(self, NULL);
    if(strcmp(name, "invertLinearTransform") == 0)
        return TransformAttributes_GetInvertLinearTransform(self, NULL);
    if(strcmp(name, "vectorTransformMethod") == 0)
        return TransformAttributes_GetVectorTransformMethod(self, NULL);
    if(strcmp(name, "None") == 0)
        return PyInt_FromLong(long(TransformAttributes::None));
    if(strcmp(name, "AsPoint") == 0)
        return PyInt_FromLong(long(TransformAttributes::AsPoint));
    if(strcmp(name, "AsDisplacement") == 0)
        return PyInt_FromLong(long(TransformAttributes::AsDisplacement));
    if(strcmp(name, "AsDirection") == 0)
        return PyInt_FromLong(long(TransformAttributes::AsDirection));

    if(strcmp(name, "transformVectors") == 0)
        return TransformAttributes_GetTransformVectors(self, NULL);

    return Py_FindMethod(PyTransformAttributes_methods, self, name);
}

int
PyTransformAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "doRotate") == 0)
        obj = TransformAttributes_SetDoRotate(self, tuple);
    else if(strcmp(name, "rotateOrigin") == 0)
        obj = TransformAttributes_SetRotateOrigin(self, tuple);
    else if(strcmp(name, "rotateAxis") == 0)
        obj = TransformAttributes_SetRotateAxis(self, tuple);
    else if(strcmp(name, "rotateAmount") == 0)
        obj = TransformAttributes_SetRotateAmount(self, tuple);
    else if(strcmp(name, "rotateType") == 0)
        obj = TransformAttributes_SetRotateType(self, tuple);
    else if(strcmp(name, "doScale") == 0)
        obj = TransformAttributes_SetDoScale(self, tuple);
    else if(strcmp(name, "scaleOrigin") == 0)
        obj = TransformAttributes_SetScaleOrigin(self, tuple);
    else if(strcmp(name, "scaleX") == 0)
        obj = TransformAttributes_SetScaleX(self, tuple);
    else if(strcmp(name, "scaleY") == 0)
        obj = TransformAttributes_SetScaleY(self, tuple);
    else if(strcmp(name, "scaleZ") == 0)
        obj = TransformAttributes_SetScaleZ(self, tuple);
    else if(strcmp(name, "doTranslate") == 0)
        obj = TransformAttributes_SetDoTranslate(self, tuple);
    else if(strcmp(name, "translateX") == 0)
        obj = TransformAttributes_SetTranslateX(self, tuple);
    else if(strcmp(name, "translateY") == 0)
        obj = TransformAttributes_SetTranslateY(self, tuple);
    else if(strcmp(name, "translateZ") == 0)
        obj = TransformAttributes_SetTranslateZ(self, tuple);
    else if(strcmp(name, "transformType") == 0)
        obj = TransformAttributes_SetTransformType(self, tuple);
    else if(strcmp(name, "inputCoordSys") == 0)
        obj = TransformAttributes_SetInputCoordSys(self, tuple);
    else if(strcmp(name, "outputCoordSys") == 0)
        obj = TransformAttributes_SetOutputCoordSys(self, tuple);
    else if(strcmp(name, "continuousPhi") == 0)
        obj = TransformAttributes_SetContinuousPhi(self, tuple);
    else if(strcmp(name, "m00") == 0)
        obj = TransformAttributes_SetM00(self, tuple);
    else if(strcmp(name, "m01") == 0)
        obj = TransformAttributes_SetM01(self, tuple);
    else if(strcmp(name, "m02") == 0)
        obj = TransformAttributes_SetM02(self, tuple);
    else if(strcmp(name, "m03") == 0)
        obj = TransformAttributes_SetM03(self, tuple);
    else if(strcmp(name, "m10") == 0)
        obj = TransformAttributes_SetM10(self, tuple);
    else if(strcmp(name, "m11") == 0)
        obj = TransformAttributes_SetM11(self, tuple);
    else if(strcmp(name, "m12") == 0)
        obj = TransformAttributes_SetM12(self, tuple);
    else if(strcmp(name, "m13") == 0)
        obj = TransformAttributes_SetM13(self, tuple);
    else if(strcmp(name, "m20") == 0)
        obj = TransformAttributes_SetM20(self, tuple);
    else if(strcmp(name, "m21") == 0)
        obj = TransformAttributes_SetM21(self, tuple);
    else if(strcmp(name, "m22") == 0)
        obj = TransformAttributes_SetM22(self, tuple);
    else if(strcmp(name, "m23") == 0)
        obj = TransformAttributes_SetM23(self, tuple);
    else if(strcmp(name, "m30") == 0)
        obj = TransformAttributes_SetM30(self, tuple);
    else if(strcmp(name, "m31") == 0)
        obj = TransformAttributes_SetM31(self, tuple);
    else if(strcmp(name, "m32") == 0)
        obj = TransformAttributes_SetM32(self, tuple);
    else if(strcmp(name, "m33") == 0)
        obj = TransformAttributes_SetM33(self, tuple);
    else if(strcmp(name, "invertLinearTransform") == 0)
        obj = TransformAttributes_SetInvertLinearTransform(self, tuple);
    else if(strcmp(name, "vectorTransformMethod") == 0)
        obj = TransformAttributes_SetVectorTransformMethod(self, tuple);
    else if(strcmp(name, "transformVectors") == 0)
        obj = TransformAttributes_SetTransformVectors(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
TransformAttributes_print(PyObject *v, FILE *fp, int flags)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)v;
    fprintf(fp, "%s", PyTransformAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
TransformAttributes_str(PyObject *v)
{
    TransformAttributesObject *obj = (TransformAttributesObject *)v;
    return PyString_FromString(PyTransformAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *TransformAttributes_Purpose = "This class contains attributes for the transform operator.";
#else
static char *TransformAttributes_Purpose = "This class contains attributes for the transform operator.";
#endif

//
// The type description structure
//
static PyTypeObject TransformAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "TransformAttributes",                    // tp_name
    sizeof(TransformAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)TransformAttributes_dealloc,  // tp_dealloc
    (printfunc)TransformAttributes_print,     // tp_print
    (getattrfunc)PyTransformAttributes_getattr, // tp_getattr
    (setattrfunc)PyTransformAttributes_setattr, // tp_setattr
    (cmpfunc)TransformAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)TransformAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    TransformAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static TransformAttributes *defaultAtts = 0;
static TransformAttributes *currentAtts = 0;

static PyObject *
NewTransformAttributes(int useCurrent)
{
    TransformAttributesObject *newObject;
    newObject = PyObject_NEW(TransformAttributesObject, &TransformAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new TransformAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new TransformAttributes(*defaultAtts);
    else
        newObject->data = new TransformAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapTransformAttributes(const TransformAttributes *attr)
{
    TransformAttributesObject *newObject;
    newObject = PyObject_NEW(TransformAttributesObject, &TransformAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (TransformAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
TransformAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewTransformAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef TransformAttributesMethods[] = {
    {"TransformAttributes", TransformAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *TransformAttributesObserver = 0;

std::string
PyTransformAttributes_GetLogString()
{
    std::string s("TransformAtts = TransformAttributes()\n");
    if(currentAtts != 0)
        s += PyTransformAttributes_ToString(currentAtts, "TransformAtts.");
    return s;
}

static void
PyTransformAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("TransformAtts = TransformAttributes()\n");
        s += PyTransformAttributes_ToString(currentAtts, "TransformAtts.");
        cb(s);
    }
}

void
PyTransformAttributes_StartUp(TransformAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyTransformAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(TransformAttributesObserver == 0)
    {
        TransformAttributesObserver = new ObserverToCallback(subj,
            PyTransformAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyTransformAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete TransformAttributesObserver;
    TransformAttributesObserver = 0;
}

PyMethodDef *
PyTransformAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return TransformAttributesMethods;
}

bool
PyTransformAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &TransformAttributesType);
}

TransformAttributes *
PyTransformAttributes_FromPyObject(PyObject *obj)
{
    TransformAttributesObject *obj2 = (TransformAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyTransformAttributes_New()
{
    return NewTransformAttributes(0);
}

PyObject *
PyTransformAttributes_Wrap(const TransformAttributes *attr)
{
    return WrapTransformAttributes(attr);
}

void
PyTransformAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    TransformAttributesObject *obj2 = (TransformAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyTransformAttributes_SetDefaults(const TransformAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new TransformAttributes(*atts);
}

