/*****************************************************************************
*
* Copyright (c) 2000 - 2018, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

// ************************************************************************* //
//                            avtPVLDFileFormat.h                           //
// ************************************************************************* //

#ifndef AVT_PVLD_FILE_FORMAT_H
#define AVT_PVLD_FILE_FORMAT_H

#include <avtSTMDFileFormat.h>

#include <pvldReader.h>
#include <pvldPartReader.h>

class vtkFloatArray;
class vtkPoints;
class vtkUnstructuredGrid;

// ****************************************************************************
//  Class: avtPVLDFileFormat
//
//  Purpose:
//      Reads in PVLD files as a plugin to VisIt.
//
//  Programmer: hpan -- generated by xml2avt
//  Creation:   Tue Sep 25 14:55:38 PST 2012
//
//  Modifications:
//    Brad Whitlock, Fri Jun 20 13:05:07 PDT 2014
//    Add time-varying metadata.
//
// ****************************************************************************

class avtPVLDFileFormat : public avtSTMDFileFormat
{
public:
    avtPVLDFileFormat(const char *);
    virtual           ~avtPVLDFileFormat();

    //
    // This is used to return unconvention data -- ranging from material
    // information to information about block connectivity.
    //
    virtual void      *GetAuxiliaryData(const char *var, int domain,
                                        const char *type, void *args,
                                        DestructorFunction &);


    virtual int       GetCycle(void)
    {
        return preader_->GetCycle();
    }
    virtual double    GetTime(void)
    {
        return preader_->GetTime();
    }

    // Tell VisIt that the Metadata and SIL change over time.
    bool                   HasInvariantMetaData(void) const
    {
        return false;
    }

    bool                   HasInvariantSIL(void) const
    {
        return false;
    }

    void                   ActivateTimestep(void);
    virtual const char    *GetType(void)
    {
        return "PVLD";
    };
    virtual void           FreeUpResources(void);

    virtual vtkDataSet    *GetMesh(int, const char *);
    virtual vtkDataArray  *GetVar(int, const char *);
    virtual vtkDataArray  *GetVectorVar(int, const char *);

protected:
    // DATA MEMBERS
    bool  hasTOCread_;
    bool  add_missing_parts_;
    bool  enablePVLD;
    PVLD_Reader  *preader_;

    virtual void           PopulateDatabaseMetaData(avtDatabaseMetaData *);

protected:
    void ReadTOC();

    void AddSolidMesh( avtDatabaseMetaData *md );
    void AddShellMesh( avtDatabaseMetaData *md );
    void AddBeamMesh(  avtDatabaseMetaData *md );
    void AddSurfaceMesh( avtDatabaseMetaData *md );
    void AddSphMesh( avtDatabaseMetaData *md );
    void AddTiedSetMesh( avtDatabaseMetaData *md );
    void AddContactMesh( avtDatabaseMetaData *md );

    void AddSolidVariables( avtDatabaseMetaData *md );
    void AddShellVariables( avtDatabaseMetaData *md );
    void AddBeamVariables(  avtDatabaseMetaData *md );
    void AddSurfaceVariables( avtDatabaseMetaData *md );
    void AddNodeVariables( const std::string& meshname, avtDatabaseMetaData *md );
    void AddSphVariables( avtDatabaseMetaData *md );
    void AddTiedSetVariables( avtDatabaseMetaData *md );
    void AddContactVariables( avtDatabaseMetaData *md );

    void AddSolidMaterial( avtDatabaseMetaData *md );
    void AddShellMaterial( avtDatabaseMetaData *md );
    void AddBeamMaterial(  avtDatabaseMetaData *md );
    void AddSurfaceMaterial( avtDatabaseMetaData *md );
    void AddSphMaterial( avtDatabaseMetaData *md );

    vtkPoints *MakePoints(std::vector<float> &crd);

    vtkUnstructuredGrid* GenerateSolidMesh( std::vector<float>& crd, const std::vector<int>& elm );
    vtkUnstructuredGrid* GenerateShellMesh( std::vector<float>& crd, const std::vector<int>& elm );
    vtkUnstructuredGrid* GenerateBeamMesh(  std::vector<float>& crd, const std::vector<int>& elm );
    vtkUnstructuredGrid* GenerateSphMesh( std::vector<float>& crd, const std::vector<int>& elm );
    vtkUnstructuredGrid* GeneratePointMesh( std::vector<float>& crd );
    vtkUnstructuredGrid* GenerateBondMesh( const std::vector<float>& crd1, const std::vector<float>& crd2 );

    void CreateGlobalNodeIds(int domain, const char *meshname, const std::vector<int> &vmap);

    vtkFloatArray* GenerateVariable( const std::vector<int>& dim, std::vector<float>& dat );
    vtkFloatArray* GenerateDyna3dStressTensor( const std::vector<int>& dims, const std::vector<float>& dat );
    vtkFloatArray* GenerateSphStressTensor( const std::vector<int>& dims, const std::vector<float>& dat );


    void AddSolidIndexVariables( avtDatabaseMetaData *md );
    void AddShellIndexVariables( avtDatabaseMetaData *md );
    void AddIndexVariables( const std::string& meshname,
                            const std::string& idxname,
                            const std::vector<std::string>& dsname,
                            const std::vector<std::vector<int> >& dsdims,
                            avtDatabaseMetaData *md );

};


#endif
