/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PySurfaceNormalAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PySurfaceNormalAttributes
//
// Purpose: 
//   Attributes for SurfaceNormal operator
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a SurfaceNormalAttributes.
//
struct SurfaceNormalAttributesObject
{
    PyObject_HEAD
    SurfaceNormalAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewSurfaceNormalAttributes(int);

std::string
PySurfaceNormalAttributes_ToString(const SurfaceNormalAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    const char *centering_names = "Point, Cell";
    switch (atts->GetCentering())
    {
      case SurfaceNormalAttributes::Point:
          SNPRINTF(tmpStr, 1000, "%scentering = %sPoint  # %s\n", prefix, prefix, centering_names);
          str += tmpStr;
          break;
      case SurfaceNormalAttributes::Cell:
          SNPRINTF(tmpStr, 1000, "%scentering = %sCell  # %s\n", prefix, prefix, centering_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    return str;
}

static PyObject *
SurfaceNormalAttributes_Notify(PyObject *self, PyObject *args)
{
    SurfaceNormalAttributesObject *obj = (SurfaceNormalAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SurfaceNormalAttributes_SetCentering(PyObject *self, PyObject *args)
{
    SurfaceNormalAttributesObject *obj = (SurfaceNormalAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the centering in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetCentering(SurfaceNormalAttributes::Centering(ival));
    else
    {
        fprintf(stderr, "An invalid centering value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "Point, Cell.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
SurfaceNormalAttributes_GetCentering(PyObject *self, PyObject *args)
{
    SurfaceNormalAttributesObject *obj = (SurfaceNormalAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetCentering()));
    return retval;
}



PyMethodDef PySurfaceNormalAttributes_methods[SURFACENORMALATTRIBUTES_NMETH] = {
    {"Notify", SurfaceNormalAttributes_Notify, METH_VARARGS},
    {"SetCentering", SurfaceNormalAttributes_SetCentering, METH_VARARGS},
    {"GetCentering", SurfaceNormalAttributes_GetCentering, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
SurfaceNormalAttributes_dealloc(PyObject *v)
{
   SurfaceNormalAttributesObject *obj = (SurfaceNormalAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
SurfaceNormalAttributes_compare(PyObject *v, PyObject *w)
{
    SurfaceNormalAttributes *a = ((SurfaceNormalAttributesObject *)v)->data;
    SurfaceNormalAttributes *b = ((SurfaceNormalAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PySurfaceNormalAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "centering") == 0)
        return SurfaceNormalAttributes_GetCentering(self, NULL);
    if(strcmp(name, "Point") == 0)
        return PyInt_FromLong(long(SurfaceNormalAttributes::Point));
    if(strcmp(name, "Cell") == 0)
        return PyInt_FromLong(long(SurfaceNormalAttributes::Cell));


    return Py_FindMethod(PySurfaceNormalAttributes_methods, self, name);
}

int
PySurfaceNormalAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "centering") == 0)
        obj = SurfaceNormalAttributes_SetCentering(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
SurfaceNormalAttributes_print(PyObject *v, FILE *fp, int flags)
{
    SurfaceNormalAttributesObject *obj = (SurfaceNormalAttributesObject *)v;
    fprintf(fp, "%s", PySurfaceNormalAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
SurfaceNormalAttributes_str(PyObject *v)
{
    SurfaceNormalAttributesObject *obj = (SurfaceNormalAttributesObject *)v;
    return PyString_FromString(PySurfaceNormalAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *SurfaceNormalAttributes_Purpose = "Attributes for SurfaceNormal operator";
#else
static char *SurfaceNormalAttributes_Purpose = "Attributes for SurfaceNormal operator";
#endif

//
// The type description structure
//
static PyTypeObject SurfaceNormalAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "SurfaceNormalAttributes",                    // tp_name
    sizeof(SurfaceNormalAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)SurfaceNormalAttributes_dealloc,  // tp_dealloc
    (printfunc)SurfaceNormalAttributes_print,     // tp_print
    (getattrfunc)PySurfaceNormalAttributes_getattr, // tp_getattr
    (setattrfunc)PySurfaceNormalAttributes_setattr, // tp_setattr
    (cmpfunc)SurfaceNormalAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)SurfaceNormalAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    SurfaceNormalAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static SurfaceNormalAttributes *defaultAtts = 0;
static SurfaceNormalAttributes *currentAtts = 0;

static PyObject *
NewSurfaceNormalAttributes(int useCurrent)
{
    SurfaceNormalAttributesObject *newObject;
    newObject = PyObject_NEW(SurfaceNormalAttributesObject, &SurfaceNormalAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new SurfaceNormalAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new SurfaceNormalAttributes(*defaultAtts);
    else
        newObject->data = new SurfaceNormalAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapSurfaceNormalAttributes(const SurfaceNormalAttributes *attr)
{
    SurfaceNormalAttributesObject *newObject;
    newObject = PyObject_NEW(SurfaceNormalAttributesObject, &SurfaceNormalAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (SurfaceNormalAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
SurfaceNormalAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewSurfaceNormalAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef SurfaceNormalAttributesMethods[] = {
    {"SurfaceNormalAttributes", SurfaceNormalAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *SurfaceNormalAttributesObserver = 0;

std::string
PySurfaceNormalAttributes_GetLogString()
{
    std::string s("SurfaceNormalAtts = SurfaceNormalAttributes()\n");
    if(currentAtts != 0)
        s += PySurfaceNormalAttributes_ToString(currentAtts, "SurfaceNormalAtts.");
    return s;
}

static void
PySurfaceNormalAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("SurfaceNormalAtts = SurfaceNormalAttributes()\n");
        s += PySurfaceNormalAttributes_ToString(currentAtts, "SurfaceNormalAtts.");
        cb(s);
    }
}

void
PySurfaceNormalAttributes_StartUp(SurfaceNormalAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PySurfaceNormalAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(SurfaceNormalAttributesObserver == 0)
    {
        SurfaceNormalAttributesObserver = new ObserverToCallback(subj,
            PySurfaceNormalAttributes_CallLogRoutine, (void *)data);
    }

}

void
PySurfaceNormalAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete SurfaceNormalAttributesObserver;
    SurfaceNormalAttributesObserver = 0;
}

PyMethodDef *
PySurfaceNormalAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return SurfaceNormalAttributesMethods;
}

bool
PySurfaceNormalAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &SurfaceNormalAttributesType);
}

SurfaceNormalAttributes *
PySurfaceNormalAttributes_FromPyObject(PyObject *obj)
{
    SurfaceNormalAttributesObject *obj2 = (SurfaceNormalAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PySurfaceNormalAttributes_New()
{
    return NewSurfaceNormalAttributes(0);
}

PyObject *
PySurfaceNormalAttributes_Wrap(const SurfaceNormalAttributes *attr)
{
    return WrapSurfaceNormalAttributes(attr);
}

void
PySurfaceNormalAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    SurfaceNormalAttributesObject *obj2 = (SurfaceNormalAttributesObject *)obj;
    obj2->parent = parent;
}

void
PySurfaceNormalAttributes_SetDefaults(const SurfaceNormalAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new SurfaceNormalAttributes(*atts);
}

