/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyConstructDataBinningAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PyConstructDataBinningAttributes
//
// Purpose: 
//   Attributes for constructing a data binning
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a ConstructDataBinningAttributes.
//
struct ConstructDataBinningAttributesObject
{
    PyObject_HEAD
    ConstructDataBinningAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewConstructDataBinningAttributes(int);

std::string
PyConstructDataBinningAttributes_ToString(const ConstructDataBinningAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    SNPRINTF(tmpStr, 1000, "%sname = \"%s\"\n", prefix, atts->GetName().c_str());
    str += tmpStr;
    {   const stringVector &varnames = atts->GetVarnames();
        SNPRINTF(tmpStr, 1000, "%svarnames = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < varnames.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "\"%s\"", varnames[i].c_str());
            str += tmpStr;
            if(i < varnames.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const unsignedCharVector &binType = atts->GetBinType();
        SNPRINTF(tmpStr, 1000, "%sbinType = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < binType.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%d", int(binType[i]));
            str += tmpStr;
            if(i < binType.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const doubleVector &binBoundaries = atts->GetBinBoundaries();
        SNPRINTF(tmpStr, 1000, "%sbinBoundaries = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < binBoundaries.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", binBoundaries[i]);
            str += tmpStr;
            if(i < binBoundaries.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    const char *reductionOperator_names = "Average, Minimum, Maximum, StandardDeviation, Variance, "
        "Sum, Count, RMS, PDF";
    switch (atts->GetReductionOperator())
    {
      case ConstructDataBinningAttributes::Average:
          SNPRINTF(tmpStr, 1000, "%sreductionOperator = %sAverage  # %s\n", prefix, prefix, reductionOperator_names);
          str += tmpStr;
          break;
      case ConstructDataBinningAttributes::Minimum:
          SNPRINTF(tmpStr, 1000, "%sreductionOperator = %sMinimum  # %s\n", prefix, prefix, reductionOperator_names);
          str += tmpStr;
          break;
      case ConstructDataBinningAttributes::Maximum:
          SNPRINTF(tmpStr, 1000, "%sreductionOperator = %sMaximum  # %s\n", prefix, prefix, reductionOperator_names);
          str += tmpStr;
          break;
      case ConstructDataBinningAttributes::StandardDeviation:
          SNPRINTF(tmpStr, 1000, "%sreductionOperator = %sStandardDeviation  # %s\n", prefix, prefix, reductionOperator_names);
          str += tmpStr;
          break;
      case ConstructDataBinningAttributes::Variance:
          SNPRINTF(tmpStr, 1000, "%sreductionOperator = %sVariance  # %s\n", prefix, prefix, reductionOperator_names);
          str += tmpStr;
          break;
      case ConstructDataBinningAttributes::Sum:
          SNPRINTF(tmpStr, 1000, "%sreductionOperator = %sSum  # %s\n", prefix, prefix, reductionOperator_names);
          str += tmpStr;
          break;
      case ConstructDataBinningAttributes::Count:
          SNPRINTF(tmpStr, 1000, "%sreductionOperator = %sCount  # %s\n", prefix, prefix, reductionOperator_names);
          str += tmpStr;
          break;
      case ConstructDataBinningAttributes::RMS:
          SNPRINTF(tmpStr, 1000, "%sreductionOperator = %sRMS  # %s\n", prefix, prefix, reductionOperator_names);
          str += tmpStr;
          break;
      case ConstructDataBinningAttributes::PDF:
          SNPRINTF(tmpStr, 1000, "%sreductionOperator = %sPDF  # %s\n", prefix, prefix, reductionOperator_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%svarForReductionOperator = \"%s\"\n", prefix, atts->GetVarForReductionOperator().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sundefinedValue = %g\n", prefix, atts->GetUndefinedValue());
    str += tmpStr;
    const char *binningScheme_names = "Uniform, Unknown";
    switch (atts->GetBinningScheme())
    {
      case ConstructDataBinningAttributes::Uniform:
          SNPRINTF(tmpStr, 1000, "%sbinningScheme = %sUniform  # %s\n", prefix, prefix, binningScheme_names);
          str += tmpStr;
          break;
      case ConstructDataBinningAttributes::Unknown:
          SNPRINTF(tmpStr, 1000, "%sbinningScheme = %sUnknown  # %s\n", prefix, prefix, binningScheme_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    {   const intVector &numBins = atts->GetNumBins();
        SNPRINTF(tmpStr, 1000, "%snumBins = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < numBins.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%d", numBins[i]);
            str += tmpStr;
            if(i < numBins.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    if(atts->GetOverTime())
        SNPRINTF(tmpStr, 1000, "%soverTime = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%soverTime = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%stimeStart = %d\n", prefix, atts->GetTimeStart());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%stimeEnd = %d\n", prefix, atts->GetTimeEnd());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%stimeStride = %d\n", prefix, atts->GetTimeStride());
    str += tmpStr;
    const char *outOfBoundsBehavior_names = "Clamp, Discard";
    switch (atts->GetOutOfBoundsBehavior())
    {
      case ConstructDataBinningAttributes::Clamp:
          SNPRINTF(tmpStr, 1000, "%soutOfBoundsBehavior = %sClamp  # %s\n", prefix, prefix, outOfBoundsBehavior_names);
          str += tmpStr;
          break;
      case ConstructDataBinningAttributes::Discard:
          SNPRINTF(tmpStr, 1000, "%soutOfBoundsBehavior = %sDiscard  # %s\n", prefix, prefix, outOfBoundsBehavior_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    return str;
}

static PyObject *
ConstructDataBinningAttributes_Notify(PyObject *self, PyObject *args)
{
    ConstructDataBinningAttributesObject *obj = (ConstructDataBinningAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ConstructDataBinningAttributes_SetName(PyObject *self, PyObject *args)
{
    ConstructDataBinningAttributesObject *obj = (ConstructDataBinningAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the name in the object.
    obj->data->SetName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ConstructDataBinningAttributes_GetName(PyObject *self, PyObject *args)
{
    ConstructDataBinningAttributesObject *obj = (ConstructDataBinningAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetName().c_str());
    return retval;
}

/*static*/ PyObject *
ConstructDataBinningAttributes_SetVarnames(PyObject *self, PyObject *args)
{
    ConstructDataBinningAttributesObject *obj = (ConstructDataBinningAttributesObject *)self;

    stringVector  &vec = obj->data->GetVarnames();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyString_Check(item))
                vec[i] = std::string(PyString_AS_STRING(item));
            else
                vec[i] = std::string("");
        }
    }
    else if(PyString_Check(tuple))
    {
        vec.resize(1);
        vec[0] = std::string(PyString_AS_STRING(tuple));
    }
    else
        return NULL;

    // Mark the varnames in the object as modified.
    obj->data->SelectVarnames();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ConstructDataBinningAttributes_GetVarnames(PyObject *self, PyObject *args)
{
    ConstructDataBinningAttributesObject *obj = (ConstructDataBinningAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the varnames.
    const stringVector &varnames = obj->data->GetVarnames();
    PyObject *retval = PyTuple_New(varnames.size());
    for(size_t i = 0; i < varnames.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyString_FromString(varnames[i].c_str()));
    return retval;
}

/*static*/ PyObject *
ConstructDataBinningAttributes_SetBinType(PyObject *self, PyObject *args)
{
    ConstructDataBinningAttributesObject *obj = (ConstructDataBinningAttributesObject *)self;

    unsignedCharVector  &vec = obj->data->GetBinType();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            int c;
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                c = int(PyFloat_AS_DOUBLE(item));
            else if(PyInt_Check(item))
                c = int(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                c = int(PyLong_AsDouble(item));
            else
                c = 0;

            if(c < 0) c = 0;
            if(c > 255) c = 255;
            vec[i] = (unsigned char)(c);
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        int c = int(PyFloat_AS_DOUBLE(tuple));
        if(c < 0) c = 0;
        if(c > 255) c = 255;
        vec[0] = (unsigned char)(c);
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        int c = int(PyInt_AS_LONG(tuple));
        if(c < 0) c = 0;
        if(c > 255) c = 255;
        vec[0] = (unsigned char)(c);
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        int c = PyLong_AsLong(tuple);
        if(c < 0) c = 0;
        if(c > 255) c = 255;
        vec[0] = (unsigned char)(c);
    }
    else
        return NULL;

    // Mark the binType in the object as modified.
    obj->data->SelectBinType();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ConstructDataBinningAttributes_GetBinType(PyObject *self, PyObject *args)
{
    ConstructDataBinningAttributesObject *obj = (ConstructDataBinningAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the binType.
    const unsignedCharVector &binType = obj->data->GetBinType();
    PyObject *retval = PyTuple_New(binType.size());
    for(size_t i = 0; i < binType.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(binType[i])));
    return retval;
}

/*static*/ PyObject *
ConstructDataBinningAttributes_SetBinBoundaries(PyObject *self, PyObject *args)
{
    ConstructDataBinningAttributesObject *obj = (ConstructDataBinningAttributesObject *)self;

    doubleVector  &vec = obj->data->GetBinBoundaries();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = PyFloat_AS_DOUBLE(item);
            else if(PyInt_Check(item))
                vec[i] = double(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = PyLong_AsDouble(item);
            else
                vec[i] = 0.;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyFloat_AS_DOUBLE(tuple);
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = double(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyLong_AsDouble(tuple);
    }
    else
        return NULL;

    // Mark the binBoundaries in the object as modified.
    obj->data->SelectBinBoundaries();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ConstructDataBinningAttributes_GetBinBoundaries(PyObject *self, PyObject *args)
{
    ConstructDataBinningAttributesObject *obj = (ConstructDataBinningAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the binBoundaries.
    const doubleVector &binBoundaries = obj->data->GetBinBoundaries();
    PyObject *retval = PyTuple_New(binBoundaries.size());
    for(size_t i = 0; i < binBoundaries.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(binBoundaries[i]));
    return retval;
}

/*static*/ PyObject *
ConstructDataBinningAttributes_SetReductionOperator(PyObject *self, PyObject *args)
{
    ConstructDataBinningAttributesObject *obj = (ConstructDataBinningAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the reductionOperator in the object.
    if(ival >= 0 && ival < 9)
        obj->data->SetReductionOperator(ConstructDataBinningAttributes::ReductionOperator(ival));
    else
    {
        fprintf(stderr, "An invalid reductionOperator value was given. "
                        "Valid values are in the range of [0,8]. "
                        "You can also use the following names: "
                        "Average, Minimum, Maximum, StandardDeviation, Variance, "
                        "Sum, Count, RMS, PDF"
                        ".");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ConstructDataBinningAttributes_GetReductionOperator(PyObject *self, PyObject *args)
{
    ConstructDataBinningAttributesObject *obj = (ConstructDataBinningAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetReductionOperator()));
    return retval;
}

/*static*/ PyObject *
ConstructDataBinningAttributes_SetVarForReductionOperator(PyObject *self, PyObject *args)
{
    ConstructDataBinningAttributesObject *obj = (ConstructDataBinningAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the varForReductionOperator in the object.
    obj->data->SetVarForReductionOperator(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ConstructDataBinningAttributes_GetVarForReductionOperator(PyObject *self, PyObject *args)
{
    ConstructDataBinningAttributesObject *obj = (ConstructDataBinningAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetVarForReductionOperator().c_str());
    return retval;
}

/*static*/ PyObject *
ConstructDataBinningAttributes_SetUndefinedValue(PyObject *self, PyObject *args)
{
    ConstructDataBinningAttributesObject *obj = (ConstructDataBinningAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the undefinedValue in the object.
    obj->data->SetUndefinedValue(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ConstructDataBinningAttributes_GetUndefinedValue(PyObject *self, PyObject *args)
{
    ConstructDataBinningAttributesObject *obj = (ConstructDataBinningAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetUndefinedValue());
    return retval;
}

/*static*/ PyObject *
ConstructDataBinningAttributes_SetBinningScheme(PyObject *self, PyObject *args)
{
    ConstructDataBinningAttributesObject *obj = (ConstructDataBinningAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the binningScheme in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetBinningScheme(ConstructDataBinningAttributes::BinningScheme(ival));
    else
    {
        fprintf(stderr, "An invalid binningScheme value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "Uniform, Unknown.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ConstructDataBinningAttributes_GetBinningScheme(PyObject *self, PyObject *args)
{
    ConstructDataBinningAttributesObject *obj = (ConstructDataBinningAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetBinningScheme()));
    return retval;
}

/*static*/ PyObject *
ConstructDataBinningAttributes_SetNumBins(PyObject *self, PyObject *args)
{
    ConstructDataBinningAttributesObject *obj = (ConstructDataBinningAttributesObject *)self;

    intVector  &vec = obj->data->GetNumBins();
    PyObject   *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = int(PyFloat_AS_DOUBLE(item));
            else if(PyInt_Check(item))
                vec[i] = int(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = int(PyLong_AsLong(item));
            else
                vec[i] = 0;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyFloat_AS_DOUBLE(tuple));
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyLong_AsLong(tuple));
    }
    else
        return NULL;

    // Mark the numBins in the object as modified.
    obj->data->SelectNumBins();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ConstructDataBinningAttributes_GetNumBins(PyObject *self, PyObject *args)
{
    ConstructDataBinningAttributesObject *obj = (ConstructDataBinningAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the numBins.
    const intVector &numBins = obj->data->GetNumBins();
    PyObject *retval = PyTuple_New(numBins.size());
    for(size_t i = 0; i < numBins.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(numBins[i])));
    return retval;
}

/*static*/ PyObject *
ConstructDataBinningAttributes_SetOverTime(PyObject *self, PyObject *args)
{
    ConstructDataBinningAttributesObject *obj = (ConstructDataBinningAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the overTime in the object.
    obj->data->SetOverTime(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ConstructDataBinningAttributes_GetOverTime(PyObject *self, PyObject *args)
{
    ConstructDataBinningAttributesObject *obj = (ConstructDataBinningAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetOverTime()?1L:0L);
    return retval;
}

/*static*/ PyObject *
ConstructDataBinningAttributes_SetTimeStart(PyObject *self, PyObject *args)
{
    ConstructDataBinningAttributesObject *obj = (ConstructDataBinningAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the timeStart in the object.
    obj->data->SetTimeStart((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ConstructDataBinningAttributes_GetTimeStart(PyObject *self, PyObject *args)
{
    ConstructDataBinningAttributesObject *obj = (ConstructDataBinningAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetTimeStart()));
    return retval;
}

/*static*/ PyObject *
ConstructDataBinningAttributes_SetTimeEnd(PyObject *self, PyObject *args)
{
    ConstructDataBinningAttributesObject *obj = (ConstructDataBinningAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the timeEnd in the object.
    obj->data->SetTimeEnd((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ConstructDataBinningAttributes_GetTimeEnd(PyObject *self, PyObject *args)
{
    ConstructDataBinningAttributesObject *obj = (ConstructDataBinningAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetTimeEnd()));
    return retval;
}

/*static*/ PyObject *
ConstructDataBinningAttributes_SetTimeStride(PyObject *self, PyObject *args)
{
    ConstructDataBinningAttributesObject *obj = (ConstructDataBinningAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the timeStride in the object.
    obj->data->SetTimeStride((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ConstructDataBinningAttributes_GetTimeStride(PyObject *self, PyObject *args)
{
    ConstructDataBinningAttributesObject *obj = (ConstructDataBinningAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetTimeStride()));
    return retval;
}

/*static*/ PyObject *
ConstructDataBinningAttributes_SetOutOfBoundsBehavior(PyObject *self, PyObject *args)
{
    ConstructDataBinningAttributesObject *obj = (ConstructDataBinningAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the outOfBoundsBehavior in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetOutOfBoundsBehavior(ConstructDataBinningAttributes::OutOfBoundsBehavior(ival));
    else
    {
        fprintf(stderr, "An invalid outOfBoundsBehavior value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "Clamp, Discard.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ConstructDataBinningAttributes_GetOutOfBoundsBehavior(PyObject *self, PyObject *args)
{
    ConstructDataBinningAttributesObject *obj = (ConstructDataBinningAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetOutOfBoundsBehavior()));
    return retval;
}



PyMethodDef PyConstructDataBinningAttributes_methods[CONSTRUCTDATABINNINGATTRIBUTES_NMETH] = {
    {"Notify", ConstructDataBinningAttributes_Notify, METH_VARARGS},
    {"SetName", ConstructDataBinningAttributes_SetName, METH_VARARGS},
    {"GetName", ConstructDataBinningAttributes_GetName, METH_VARARGS},
    {"SetVarnames", ConstructDataBinningAttributes_SetVarnames, METH_VARARGS},
    {"GetVarnames", ConstructDataBinningAttributes_GetVarnames, METH_VARARGS},
    {"SetBinType", ConstructDataBinningAttributes_SetBinType, METH_VARARGS},
    {"GetBinType", ConstructDataBinningAttributes_GetBinType, METH_VARARGS},
    {"SetBinBoundaries", ConstructDataBinningAttributes_SetBinBoundaries, METH_VARARGS},
    {"GetBinBoundaries", ConstructDataBinningAttributes_GetBinBoundaries, METH_VARARGS},
    {"SetReductionOperator", ConstructDataBinningAttributes_SetReductionOperator, METH_VARARGS},
    {"GetReductionOperator", ConstructDataBinningAttributes_GetReductionOperator, METH_VARARGS},
    {"SetVarForReductionOperator", ConstructDataBinningAttributes_SetVarForReductionOperator, METH_VARARGS},
    {"GetVarForReductionOperator", ConstructDataBinningAttributes_GetVarForReductionOperator, METH_VARARGS},
    {"SetUndefinedValue", ConstructDataBinningAttributes_SetUndefinedValue, METH_VARARGS},
    {"GetUndefinedValue", ConstructDataBinningAttributes_GetUndefinedValue, METH_VARARGS},
    {"SetBinningScheme", ConstructDataBinningAttributes_SetBinningScheme, METH_VARARGS},
    {"GetBinningScheme", ConstructDataBinningAttributes_GetBinningScheme, METH_VARARGS},
    {"SetNumBins", ConstructDataBinningAttributes_SetNumBins, METH_VARARGS},
    {"GetNumBins", ConstructDataBinningAttributes_GetNumBins, METH_VARARGS},
    {"SetOverTime", ConstructDataBinningAttributes_SetOverTime, METH_VARARGS},
    {"GetOverTime", ConstructDataBinningAttributes_GetOverTime, METH_VARARGS},
    {"SetTimeStart", ConstructDataBinningAttributes_SetTimeStart, METH_VARARGS},
    {"GetTimeStart", ConstructDataBinningAttributes_GetTimeStart, METH_VARARGS},
    {"SetTimeEnd", ConstructDataBinningAttributes_SetTimeEnd, METH_VARARGS},
    {"GetTimeEnd", ConstructDataBinningAttributes_GetTimeEnd, METH_VARARGS},
    {"SetTimeStride", ConstructDataBinningAttributes_SetTimeStride, METH_VARARGS},
    {"GetTimeStride", ConstructDataBinningAttributes_GetTimeStride, METH_VARARGS},
    {"SetOutOfBoundsBehavior", ConstructDataBinningAttributes_SetOutOfBoundsBehavior, METH_VARARGS},
    {"GetOutOfBoundsBehavior", ConstructDataBinningAttributes_GetOutOfBoundsBehavior, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
ConstructDataBinningAttributes_dealloc(PyObject *v)
{
   ConstructDataBinningAttributesObject *obj = (ConstructDataBinningAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
ConstructDataBinningAttributes_compare(PyObject *v, PyObject *w)
{
    ConstructDataBinningAttributes *a = ((ConstructDataBinningAttributesObject *)v)->data;
    ConstructDataBinningAttributes *b = ((ConstructDataBinningAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyConstructDataBinningAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "name") == 0)
        return ConstructDataBinningAttributes_GetName(self, NULL);
    if(strcmp(name, "varnames") == 0)
        return ConstructDataBinningAttributes_GetVarnames(self, NULL);
    if(strcmp(name, "binType") == 0)
        return ConstructDataBinningAttributes_GetBinType(self, NULL);
    if(strcmp(name, "binBoundaries") == 0)
        return ConstructDataBinningAttributes_GetBinBoundaries(self, NULL);
    if(strcmp(name, "reductionOperator") == 0)
        return ConstructDataBinningAttributes_GetReductionOperator(self, NULL);
    if(strcmp(name, "Average") == 0)
        return PyInt_FromLong(long(ConstructDataBinningAttributes::Average));
    if(strcmp(name, "Minimum") == 0)
        return PyInt_FromLong(long(ConstructDataBinningAttributes::Minimum));
    if(strcmp(name, "Maximum") == 0)
        return PyInt_FromLong(long(ConstructDataBinningAttributes::Maximum));
    if(strcmp(name, "StandardDeviation") == 0)
        return PyInt_FromLong(long(ConstructDataBinningAttributes::StandardDeviation));
    if(strcmp(name, "Variance") == 0)
        return PyInt_FromLong(long(ConstructDataBinningAttributes::Variance));
    if(strcmp(name, "Sum") == 0)
        return PyInt_FromLong(long(ConstructDataBinningAttributes::Sum));
    if(strcmp(name, "Count") == 0)
        return PyInt_FromLong(long(ConstructDataBinningAttributes::Count));
    if(strcmp(name, "RMS") == 0)
        return PyInt_FromLong(long(ConstructDataBinningAttributes::RMS));
    if(strcmp(name, "PDF") == 0)
        return PyInt_FromLong(long(ConstructDataBinningAttributes::PDF));

    if(strcmp(name, "varForReductionOperator") == 0)
        return ConstructDataBinningAttributes_GetVarForReductionOperator(self, NULL);
    if(strcmp(name, "undefinedValue") == 0)
        return ConstructDataBinningAttributes_GetUndefinedValue(self, NULL);
    if(strcmp(name, "binningScheme") == 0)
        return ConstructDataBinningAttributes_GetBinningScheme(self, NULL);
    if(strcmp(name, "Uniform") == 0)
        return PyInt_FromLong(long(ConstructDataBinningAttributes::Uniform));
    if(strcmp(name, "Unknown") == 0)
        return PyInt_FromLong(long(ConstructDataBinningAttributes::Unknown));

    if(strcmp(name, "numBins") == 0)
        return ConstructDataBinningAttributes_GetNumBins(self, NULL);
    if(strcmp(name, "overTime") == 0)
        return ConstructDataBinningAttributes_GetOverTime(self, NULL);
    if(strcmp(name, "timeStart") == 0)
        return ConstructDataBinningAttributes_GetTimeStart(self, NULL);
    if(strcmp(name, "timeEnd") == 0)
        return ConstructDataBinningAttributes_GetTimeEnd(self, NULL);
    if(strcmp(name, "timeStride") == 0)
        return ConstructDataBinningAttributes_GetTimeStride(self, NULL);
    if(strcmp(name, "outOfBoundsBehavior") == 0)
        return ConstructDataBinningAttributes_GetOutOfBoundsBehavior(self, NULL);
    if(strcmp(name, "Clamp") == 0)
        return PyInt_FromLong(long(ConstructDataBinningAttributes::Clamp));
    if(strcmp(name, "Discard") == 0)
        return PyInt_FromLong(long(ConstructDataBinningAttributes::Discard));


    // try to handle old ddf attributes
    if(strcmp(name, "ddfName") == 0)
        return ConstructDataBinningAttributes_GetName(self, NULL);
    if(strcmp(name, "ranges") == 0)
        return ConstructDataBinningAttributes_GetBinBoundaries(self, NULL);
    if(strcmp(name, "statisticalOperator") == 0)
        return ConstructDataBinningAttributes_GetReductionOperator(self, NULL);
    if(strcmp(name, "codomainName") == 0)
        return ConstructDataBinningAttributes_GetVarForReductionOperator(self, NULL);
    if(strcmp(name, "numSamples") == 0)
        return ConstructDataBinningAttributes_GetNumBins(self, NULL);
    return Py_FindMethod(PyConstructDataBinningAttributes_methods, self, name);
}

int
PyConstructDataBinningAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "name") == 0)
        obj = ConstructDataBinningAttributes_SetName(self, tuple);
    else if(strcmp(name, "varnames") == 0)
        obj = ConstructDataBinningAttributes_SetVarnames(self, tuple);
    else if(strcmp(name, "binType") == 0)
        obj = ConstructDataBinningAttributes_SetBinType(self, tuple);
    else if(strcmp(name, "binBoundaries") == 0)
        obj = ConstructDataBinningAttributes_SetBinBoundaries(self, tuple);
    else if(strcmp(name, "reductionOperator") == 0)
        obj = ConstructDataBinningAttributes_SetReductionOperator(self, tuple);
    else if(strcmp(name, "varForReductionOperator") == 0)
        obj = ConstructDataBinningAttributes_SetVarForReductionOperator(self, tuple);
    else if(strcmp(name, "undefinedValue") == 0)
        obj = ConstructDataBinningAttributes_SetUndefinedValue(self, tuple);
    else if(strcmp(name, "binningScheme") == 0)
        obj = ConstructDataBinningAttributes_SetBinningScheme(self, tuple);
    else if(strcmp(name, "numBins") == 0)
        obj = ConstructDataBinningAttributes_SetNumBins(self, tuple);
    else if(strcmp(name, "overTime") == 0)
        obj = ConstructDataBinningAttributes_SetOverTime(self, tuple);
    else if(strcmp(name, "timeStart") == 0)
        obj = ConstructDataBinningAttributes_SetTimeStart(self, tuple);
    else if(strcmp(name, "timeEnd") == 0)
        obj = ConstructDataBinningAttributes_SetTimeEnd(self, tuple);
    else if(strcmp(name, "timeStride") == 0)
        obj = ConstructDataBinningAttributes_SetTimeStride(self, tuple);
    else if(strcmp(name, "outOfBoundsBehavior") == 0)
        obj = ConstructDataBinningAttributes_SetOutOfBoundsBehavior(self, tuple);

    // try to handle old ddf attributes
    if(strcmp(name, "ddfName") == 0)
        obj = ConstructDataBinningAttributes_SetName(self, tuple);
    else if(strcmp(name, "ranges") == 0)
        obj = ConstructDataBinningAttributes_SetBinBoundaries(self, tuple);
    else if(strcmp(name, "statisticalOperator") == 0)
        obj = ConstructDataBinningAttributes_SetReductionOperator(self, tuple);
    else if(strcmp(name, "codomainName") == 0)
        obj = ConstructDataBinningAttributes_SetVarForReductionOperator(self, tuple);
    else if(strcmp(name, "numSamples") == 0)
        obj = ConstructDataBinningAttributes_SetNumBins(self, tuple);
    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
ConstructDataBinningAttributes_print(PyObject *v, FILE *fp, int flags)
{
    ConstructDataBinningAttributesObject *obj = (ConstructDataBinningAttributesObject *)v;
    fprintf(fp, "%s", PyConstructDataBinningAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
ConstructDataBinningAttributes_str(PyObject *v)
{
    ConstructDataBinningAttributesObject *obj = (ConstructDataBinningAttributesObject *)v;
    return PyString_FromString(PyConstructDataBinningAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *ConstructDataBinningAttributes_Purpose = "Attributes for constructing a data binning";
#else
static char *ConstructDataBinningAttributes_Purpose = "Attributes for constructing a data binning";
#endif

//
// The type description structure
//
static PyTypeObject ConstructDataBinningAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "ConstructDataBinningAttributes",                    // tp_name
    sizeof(ConstructDataBinningAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)ConstructDataBinningAttributes_dealloc,  // tp_dealloc
    (printfunc)ConstructDataBinningAttributes_print,     // tp_print
    (getattrfunc)PyConstructDataBinningAttributes_getattr, // tp_getattr
    (setattrfunc)PyConstructDataBinningAttributes_setattr, // tp_setattr
    (cmpfunc)ConstructDataBinningAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)ConstructDataBinningAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    ConstructDataBinningAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static ConstructDataBinningAttributes *defaultAtts = 0;
static ConstructDataBinningAttributes *currentAtts = 0;

static PyObject *
NewConstructDataBinningAttributes(int useCurrent)
{
    ConstructDataBinningAttributesObject *newObject;
    newObject = PyObject_NEW(ConstructDataBinningAttributesObject, &ConstructDataBinningAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new ConstructDataBinningAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new ConstructDataBinningAttributes(*defaultAtts);
    else
        newObject->data = new ConstructDataBinningAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapConstructDataBinningAttributes(const ConstructDataBinningAttributes *attr)
{
    ConstructDataBinningAttributesObject *newObject;
    newObject = PyObject_NEW(ConstructDataBinningAttributesObject, &ConstructDataBinningAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (ConstructDataBinningAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
ConstructDataBinningAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewConstructDataBinningAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef ConstructDataBinningAttributesMethods[] = {
    {"ConstructDataBinningAttributes", ConstructDataBinningAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *ConstructDataBinningAttributesObserver = 0;

std::string
PyConstructDataBinningAttributes_GetLogString()
{
    std::string s("ConstructDataBinningAtts = ConstructDataBinningAttributes()\n");
    if(currentAtts != 0)
        s += PyConstructDataBinningAttributes_ToString(currentAtts, "ConstructDataBinningAtts.");
    return s;
}

static void
PyConstructDataBinningAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("ConstructDataBinningAtts = ConstructDataBinningAttributes()\n");
        s += PyConstructDataBinningAttributes_ToString(currentAtts, "ConstructDataBinningAtts.");
        cb(s);
    }
}

void
PyConstructDataBinningAttributes_StartUp(ConstructDataBinningAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyConstructDataBinningAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(ConstructDataBinningAttributesObserver == 0)
    {
        ConstructDataBinningAttributesObserver = new ObserverToCallback(subj,
            PyConstructDataBinningAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyConstructDataBinningAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete ConstructDataBinningAttributesObserver;
    ConstructDataBinningAttributesObserver = 0;
}

PyMethodDef *
PyConstructDataBinningAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return ConstructDataBinningAttributesMethods;
}

bool
PyConstructDataBinningAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &ConstructDataBinningAttributesType);
}

ConstructDataBinningAttributes *
PyConstructDataBinningAttributes_FromPyObject(PyObject *obj)
{
    ConstructDataBinningAttributesObject *obj2 = (ConstructDataBinningAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyConstructDataBinningAttributes_New()
{
    return NewConstructDataBinningAttributes(0);
}

PyObject *
PyConstructDataBinningAttributes_Wrap(const ConstructDataBinningAttributes *attr)
{
    return WrapConstructDataBinningAttributes(attr);
}

void
PyConstructDataBinningAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    ConstructDataBinningAttributesObject *obj2 = (ConstructDataBinningAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyConstructDataBinningAttributes_SetDefaults(const ConstructDataBinningAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new ConstructDataBinningAttributes(*atts);
}

