/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyRemoveCellsAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PyRemoveCellsAttributes
//
// Purpose: 
//   This class contains attributes for the RemoveCells operator.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a RemoveCellsAttributes.
//
struct RemoveCellsAttributesObject
{
    PyObject_HEAD
    RemoveCellsAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewRemoveCellsAttributes(int);

std::string
PyRemoveCellsAttributes_ToString(const RemoveCellsAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    {   const intVector &cellList = atts->GetCellList();
        SNPRINTF(tmpStr, 1000, "%scellList = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < cellList.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%d", cellList[i]);
            str += tmpStr;
            if(i < cellList.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const intVector &domainList = atts->GetDomainList();
        SNPRINTF(tmpStr, 1000, "%sdomainList = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < domainList.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%d", domainList[i]);
            str += tmpStr;
            if(i < domainList.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    return str;
}

static PyObject *
RemoveCellsAttributes_Notify(PyObject *self, PyObject *args)
{
    RemoveCellsAttributesObject *obj = (RemoveCellsAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
RemoveCellsAttributes_SetCellList(PyObject *self, PyObject *args)
{
    RemoveCellsAttributesObject *obj = (RemoveCellsAttributesObject *)self;

    intVector  &vec = obj->data->GetCellList();
    PyObject   *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = int(PyFloat_AS_DOUBLE(item));
            else if(PyInt_Check(item))
                vec[i] = int(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = int(PyLong_AsLong(item));
            else
                vec[i] = 0;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyFloat_AS_DOUBLE(tuple));
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyLong_AsLong(tuple));
    }
    else
        return NULL;

    // Mark the cellList in the object as modified.
    obj->data->SelectCellList();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
RemoveCellsAttributes_GetCellList(PyObject *self, PyObject *args)
{
    RemoveCellsAttributesObject *obj = (RemoveCellsAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the cellList.
    const intVector &cellList = obj->data->GetCellList();
    PyObject *retval = PyTuple_New(cellList.size());
    for(size_t i = 0; i < cellList.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(cellList[i])));
    return retval;
}

/*static*/ PyObject *
RemoveCellsAttributes_SetDomainList(PyObject *self, PyObject *args)
{
    RemoveCellsAttributesObject *obj = (RemoveCellsAttributesObject *)self;

    intVector  &vec = obj->data->GetDomainList();
    PyObject   *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = int(PyFloat_AS_DOUBLE(item));
            else if(PyInt_Check(item))
                vec[i] = int(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = int(PyLong_AsLong(item));
            else
                vec[i] = 0;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyFloat_AS_DOUBLE(tuple));
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyLong_AsLong(tuple));
    }
    else
        return NULL;

    // Mark the domainList in the object as modified.
    obj->data->SelectDomainList();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
RemoveCellsAttributes_GetDomainList(PyObject *self, PyObject *args)
{
    RemoveCellsAttributesObject *obj = (RemoveCellsAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the domainList.
    const intVector &domainList = obj->data->GetDomainList();
    PyObject *retval = PyTuple_New(domainList.size());
    for(size_t i = 0; i < domainList.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(domainList[i])));
    return retval;
}



PyMethodDef PyRemoveCellsAttributes_methods[REMOVECELLSATTRIBUTES_NMETH] = {
    {"Notify", RemoveCellsAttributes_Notify, METH_VARARGS},
    {"SetCellList", RemoveCellsAttributes_SetCellList, METH_VARARGS},
    {"GetCellList", RemoveCellsAttributes_GetCellList, METH_VARARGS},
    {"SetDomainList", RemoveCellsAttributes_SetDomainList, METH_VARARGS},
    {"GetDomainList", RemoveCellsAttributes_GetDomainList, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
RemoveCellsAttributes_dealloc(PyObject *v)
{
   RemoveCellsAttributesObject *obj = (RemoveCellsAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
RemoveCellsAttributes_compare(PyObject *v, PyObject *w)
{
    RemoveCellsAttributes *a = ((RemoveCellsAttributesObject *)v)->data;
    RemoveCellsAttributes *b = ((RemoveCellsAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyRemoveCellsAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "cellList") == 0)
        return RemoveCellsAttributes_GetCellList(self, NULL);
    if(strcmp(name, "domainList") == 0)
        return RemoveCellsAttributes_GetDomainList(self, NULL);

    return Py_FindMethod(PyRemoveCellsAttributes_methods, self, name);
}

int
PyRemoveCellsAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "cellList") == 0)
        obj = RemoveCellsAttributes_SetCellList(self, tuple);
    else if(strcmp(name, "domainList") == 0)
        obj = RemoveCellsAttributes_SetDomainList(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
RemoveCellsAttributes_print(PyObject *v, FILE *fp, int flags)
{
    RemoveCellsAttributesObject *obj = (RemoveCellsAttributesObject *)v;
    fprintf(fp, "%s", PyRemoveCellsAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
RemoveCellsAttributes_str(PyObject *v)
{
    RemoveCellsAttributesObject *obj = (RemoveCellsAttributesObject *)v;
    return PyString_FromString(PyRemoveCellsAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *RemoveCellsAttributes_Purpose = "This class contains attributes for the RemoveCells operator.";
#else
static char *RemoveCellsAttributes_Purpose = "This class contains attributes for the RemoveCells operator.";
#endif

//
// The type description structure
//
static PyTypeObject RemoveCellsAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "RemoveCellsAttributes",                    // tp_name
    sizeof(RemoveCellsAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)RemoveCellsAttributes_dealloc,  // tp_dealloc
    (printfunc)RemoveCellsAttributes_print,     // tp_print
    (getattrfunc)PyRemoveCellsAttributes_getattr, // tp_getattr
    (setattrfunc)PyRemoveCellsAttributes_setattr, // tp_setattr
    (cmpfunc)RemoveCellsAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)RemoveCellsAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    RemoveCellsAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static RemoveCellsAttributes *defaultAtts = 0;
static RemoveCellsAttributes *currentAtts = 0;

static PyObject *
NewRemoveCellsAttributes(int useCurrent)
{
    RemoveCellsAttributesObject *newObject;
    newObject = PyObject_NEW(RemoveCellsAttributesObject, &RemoveCellsAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new RemoveCellsAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new RemoveCellsAttributes(*defaultAtts);
    else
        newObject->data = new RemoveCellsAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapRemoveCellsAttributes(const RemoveCellsAttributes *attr)
{
    RemoveCellsAttributesObject *newObject;
    newObject = PyObject_NEW(RemoveCellsAttributesObject, &RemoveCellsAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (RemoveCellsAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
RemoveCellsAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewRemoveCellsAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef RemoveCellsAttributesMethods[] = {
    {"RemoveCellsAttributes", RemoveCellsAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *RemoveCellsAttributesObserver = 0;

std::string
PyRemoveCellsAttributes_GetLogString()
{
    std::string s("RemoveCellsAtts = RemoveCellsAttributes()\n");
    if(currentAtts != 0)
        s += PyRemoveCellsAttributes_ToString(currentAtts, "RemoveCellsAtts.");
    return s;
}

static void
PyRemoveCellsAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("RemoveCellsAtts = RemoveCellsAttributes()\n");
        s += PyRemoveCellsAttributes_ToString(currentAtts, "RemoveCellsAtts.");
        cb(s);
    }
}

void
PyRemoveCellsAttributes_StartUp(RemoveCellsAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyRemoveCellsAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(RemoveCellsAttributesObserver == 0)
    {
        RemoveCellsAttributesObserver = new ObserverToCallback(subj,
            PyRemoveCellsAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyRemoveCellsAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete RemoveCellsAttributesObserver;
    RemoveCellsAttributesObserver = 0;
}

PyMethodDef *
PyRemoveCellsAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return RemoveCellsAttributesMethods;
}

bool
PyRemoveCellsAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &RemoveCellsAttributesType);
}

RemoveCellsAttributes *
PyRemoveCellsAttributes_FromPyObject(PyObject *obj)
{
    RemoveCellsAttributesObject *obj2 = (RemoveCellsAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyRemoveCellsAttributes_New()
{
    return NewRemoveCellsAttributes(0);
}

PyObject *
PyRemoveCellsAttributes_Wrap(const RemoveCellsAttributes *attr)
{
    return WrapRemoveCellsAttributes(attr);
}

void
PyRemoveCellsAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    RemoveCellsAttributesObject *obj2 = (RemoveCellsAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyRemoveCellsAttributes_SetDefaults(const RemoveCellsAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new RemoveCellsAttributes(*atts);
}

