/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyOnionPeelAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PyOnionPeelAttributes
//
// Purpose: 
//   Attributes for the onion peel operator
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a OnionPeelAttributes.
//
struct OnionPeelAttributesObject
{
    PyObject_HEAD
    OnionPeelAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewOnionPeelAttributes(int);

std::string
PyOnionPeelAttributes_ToString(const OnionPeelAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    const char *adjacencyType_names = "Node, Face";
    switch (atts->GetAdjacencyType())
    {
      case OnionPeelAttributes::Node:
          SNPRINTF(tmpStr, 1000, "%sadjacencyType = %sNode  # %s\n", prefix, prefix, adjacencyType_names);
          str += tmpStr;
          break;
      case OnionPeelAttributes::Face:
          SNPRINTF(tmpStr, 1000, "%sadjacencyType = %sFace  # %s\n", prefix, prefix, adjacencyType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    if(atts->GetUseGlobalId())
        SNPRINTF(tmpStr, 1000, "%suseGlobalId = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%suseGlobalId = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%scategoryName = \"%s\"\n", prefix, atts->GetCategoryName().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%ssubsetName = \"%s\"\n", prefix, atts->GetSubsetName().c_str());
    str += tmpStr;
    {   const intVector &index = atts->GetIndex();
        SNPRINTF(tmpStr, 1000, "%sindex = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < index.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "%d", index[i]);
            str += tmpStr;
            if(i < index.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    if(atts->GetLogical())
        SNPRINTF(tmpStr, 1000, "%slogical = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%slogical = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%srequestedLayer = %d\n", prefix, atts->GetRequestedLayer());
    str += tmpStr;
    const char *seedType_names = "SeedCell, SeedNode";
    switch (atts->GetSeedType())
    {
      case OnionPeelAttributes::SeedCell:
          SNPRINTF(tmpStr, 1000, "%sseedType = %sSeedCell  # %s\n", prefix, prefix, seedType_names);
          str += tmpStr;
          break;
      case OnionPeelAttributes::SeedNode:
          SNPRINTF(tmpStr, 1000, "%sseedType = %sSeedNode  # %s\n", prefix, prefix, seedType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    if(atts->GetHonorOriginalMesh())
        SNPRINTF(tmpStr, 1000, "%shonorOriginalMesh = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%shonorOriginalMesh = 0\n", prefix);
    str += tmpStr;
    return str;
}

static PyObject *
OnionPeelAttributes_Notify(PyObject *self, PyObject *args)
{
    OnionPeelAttributesObject *obj = (OnionPeelAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
OnionPeelAttributes_SetAdjacencyType(PyObject *self, PyObject *args)
{
    OnionPeelAttributesObject *obj = (OnionPeelAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the adjacencyType in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetAdjacencyType(OnionPeelAttributes::NodeFace(ival));
    else
    {
        fprintf(stderr, "An invalid adjacencyType value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "Node, Face.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
OnionPeelAttributes_GetAdjacencyType(PyObject *self, PyObject *args)
{
    OnionPeelAttributesObject *obj = (OnionPeelAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetAdjacencyType()));
    return retval;
}

/*static*/ PyObject *
OnionPeelAttributes_SetUseGlobalId(PyObject *self, PyObject *args)
{
    OnionPeelAttributesObject *obj = (OnionPeelAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the useGlobalId in the object.
    obj->data->SetUseGlobalId(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
OnionPeelAttributes_GetUseGlobalId(PyObject *self, PyObject *args)
{
    OnionPeelAttributesObject *obj = (OnionPeelAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetUseGlobalId()?1L:0L);
    return retval;
}

/*static*/ PyObject *
OnionPeelAttributes_SetCategoryName(PyObject *self, PyObject *args)
{
    OnionPeelAttributesObject *obj = (OnionPeelAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the categoryName in the object.
    obj->data->SetCategoryName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
OnionPeelAttributes_GetCategoryName(PyObject *self, PyObject *args)
{
    OnionPeelAttributesObject *obj = (OnionPeelAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetCategoryName().c_str());
    return retval;
}

/*static*/ PyObject *
OnionPeelAttributes_SetSubsetName(PyObject *self, PyObject *args)
{
    OnionPeelAttributesObject *obj = (OnionPeelAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the subsetName in the object.
    obj->data->SetSubsetName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
OnionPeelAttributes_GetSubsetName(PyObject *self, PyObject *args)
{
    OnionPeelAttributesObject *obj = (OnionPeelAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetSubsetName().c_str());
    return retval;
}

/*static*/ PyObject *
OnionPeelAttributes_SetIndex(PyObject *self, PyObject *args)
{
    OnionPeelAttributesObject *obj = (OnionPeelAttributesObject *)self;

    intVector  &vec = obj->data->GetIndex();
    PyObject   *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = int(PyFloat_AS_DOUBLE(item));
            else if(PyInt_Check(item))
                vec[i] = int(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = int(PyLong_AsLong(item));
            else
                vec[i] = 0;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyFloat_AS_DOUBLE(tuple));
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = int(PyLong_AsLong(tuple));
    }
    else
        return NULL;

    // Mark the index in the object as modified.
    obj->data->SelectIndex();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
OnionPeelAttributes_GetIndex(PyObject *self, PyObject *args)
{
    OnionPeelAttributesObject *obj = (OnionPeelAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the index.
    const intVector &index = obj->data->GetIndex();
    PyObject *retval = PyTuple_New(index.size());
    for(size_t i = 0; i < index.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyInt_FromLong(long(index[i])));
    return retval;
}

/*static*/ PyObject *
OnionPeelAttributes_SetLogical(PyObject *self, PyObject *args)
{
    OnionPeelAttributesObject *obj = (OnionPeelAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the logical in the object.
    obj->data->SetLogical(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
OnionPeelAttributes_GetLogical(PyObject *self, PyObject *args)
{
    OnionPeelAttributesObject *obj = (OnionPeelAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetLogical()?1L:0L);
    return retval;
}

/*static*/ PyObject *
OnionPeelAttributes_SetRequestedLayer(PyObject *self, PyObject *args)
{
    OnionPeelAttributesObject *obj = (OnionPeelAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the requestedLayer in the object.
    obj->data->SetRequestedLayer((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
OnionPeelAttributes_GetRequestedLayer(PyObject *self, PyObject *args)
{
    OnionPeelAttributesObject *obj = (OnionPeelAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetRequestedLayer()));
    return retval;
}

/*static*/ PyObject *
OnionPeelAttributes_SetSeedType(PyObject *self, PyObject *args)
{
    OnionPeelAttributesObject *obj = (OnionPeelAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the seedType in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetSeedType(OnionPeelAttributes::SeedIdType(ival));
    else
    {
        fprintf(stderr, "An invalid seedType value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "SeedCell, SeedNode.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
OnionPeelAttributes_GetSeedType(PyObject *self, PyObject *args)
{
    OnionPeelAttributesObject *obj = (OnionPeelAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetSeedType()));
    return retval;
}

/*static*/ PyObject *
OnionPeelAttributes_SetHonorOriginalMesh(PyObject *self, PyObject *args)
{
    OnionPeelAttributesObject *obj = (OnionPeelAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the honorOriginalMesh in the object.
    obj->data->SetHonorOriginalMesh(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
OnionPeelAttributes_GetHonorOriginalMesh(PyObject *self, PyObject *args)
{
    OnionPeelAttributesObject *obj = (OnionPeelAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetHonorOriginalMesh()?1L:0L);
    return retval;
}



PyMethodDef PyOnionPeelAttributes_methods[ONIONPEELATTRIBUTES_NMETH] = {
    {"Notify", OnionPeelAttributes_Notify, METH_VARARGS},
    {"SetAdjacencyType", OnionPeelAttributes_SetAdjacencyType, METH_VARARGS},
    {"GetAdjacencyType", OnionPeelAttributes_GetAdjacencyType, METH_VARARGS},
    {"SetUseGlobalId", OnionPeelAttributes_SetUseGlobalId, METH_VARARGS},
    {"GetUseGlobalId", OnionPeelAttributes_GetUseGlobalId, METH_VARARGS},
    {"SetCategoryName", OnionPeelAttributes_SetCategoryName, METH_VARARGS},
    {"GetCategoryName", OnionPeelAttributes_GetCategoryName, METH_VARARGS},
    {"SetSubsetName", OnionPeelAttributes_SetSubsetName, METH_VARARGS},
    {"GetSubsetName", OnionPeelAttributes_GetSubsetName, METH_VARARGS},
    {"SetIndex", OnionPeelAttributes_SetIndex, METH_VARARGS},
    {"GetIndex", OnionPeelAttributes_GetIndex, METH_VARARGS},
    {"SetLogical", OnionPeelAttributes_SetLogical, METH_VARARGS},
    {"GetLogical", OnionPeelAttributes_GetLogical, METH_VARARGS},
    {"SetRequestedLayer", OnionPeelAttributes_SetRequestedLayer, METH_VARARGS},
    {"GetRequestedLayer", OnionPeelAttributes_GetRequestedLayer, METH_VARARGS},
    {"SetSeedType", OnionPeelAttributes_SetSeedType, METH_VARARGS},
    {"GetSeedType", OnionPeelAttributes_GetSeedType, METH_VARARGS},
    {"SetHonorOriginalMesh", OnionPeelAttributes_SetHonorOriginalMesh, METH_VARARGS},
    {"GetHonorOriginalMesh", OnionPeelAttributes_GetHonorOriginalMesh, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
OnionPeelAttributes_dealloc(PyObject *v)
{
   OnionPeelAttributesObject *obj = (OnionPeelAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
OnionPeelAttributes_compare(PyObject *v, PyObject *w)
{
    OnionPeelAttributes *a = ((OnionPeelAttributesObject *)v)->data;
    OnionPeelAttributes *b = ((OnionPeelAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyOnionPeelAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "adjacencyType") == 0)
        return OnionPeelAttributes_GetAdjacencyType(self, NULL);
    if(strcmp(name, "Node") == 0)
        return PyInt_FromLong(long(OnionPeelAttributes::Node));
    if(strcmp(name, "Face") == 0)
        return PyInt_FromLong(long(OnionPeelAttributes::Face));

    if(strcmp(name, "useGlobalId") == 0)
        return OnionPeelAttributes_GetUseGlobalId(self, NULL);
    if(strcmp(name, "categoryName") == 0)
        return OnionPeelAttributes_GetCategoryName(self, NULL);
    if(strcmp(name, "subsetName") == 0)
        return OnionPeelAttributes_GetSubsetName(self, NULL);
    if(strcmp(name, "index") == 0)
        return OnionPeelAttributes_GetIndex(self, NULL);
    if(strcmp(name, "logical") == 0)
        return OnionPeelAttributes_GetLogical(self, NULL);
    if(strcmp(name, "requestedLayer") == 0)
        return OnionPeelAttributes_GetRequestedLayer(self, NULL);
    if(strcmp(name, "seedType") == 0)
        return OnionPeelAttributes_GetSeedType(self, NULL);
    if(strcmp(name, "SeedCell") == 0)
        return PyInt_FromLong(long(OnionPeelAttributes::SeedCell));
    if(strcmp(name, "SeedNode") == 0)
        return PyInt_FromLong(long(OnionPeelAttributes::SeedNode));

    if(strcmp(name, "honorOriginalMesh") == 0)
        return OnionPeelAttributes_GetHonorOriginalMesh(self, NULL);

    return Py_FindMethod(PyOnionPeelAttributes_methods, self, name);
}

int
PyOnionPeelAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "adjacencyType") == 0)
        obj = OnionPeelAttributes_SetAdjacencyType(self, tuple);
    else if(strcmp(name, "useGlobalId") == 0)
        obj = OnionPeelAttributes_SetUseGlobalId(self, tuple);
    else if(strcmp(name, "categoryName") == 0)
        obj = OnionPeelAttributes_SetCategoryName(self, tuple);
    else if(strcmp(name, "subsetName") == 0)
        obj = OnionPeelAttributes_SetSubsetName(self, tuple);
    else if(strcmp(name, "index") == 0)
        obj = OnionPeelAttributes_SetIndex(self, tuple);
    else if(strcmp(name, "logical") == 0)
        obj = OnionPeelAttributes_SetLogical(self, tuple);
    else if(strcmp(name, "requestedLayer") == 0)
        obj = OnionPeelAttributes_SetRequestedLayer(self, tuple);
    else if(strcmp(name, "seedType") == 0)
        obj = OnionPeelAttributes_SetSeedType(self, tuple);
    else if(strcmp(name, "honorOriginalMesh") == 0)
        obj = OnionPeelAttributes_SetHonorOriginalMesh(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
OnionPeelAttributes_print(PyObject *v, FILE *fp, int flags)
{
    OnionPeelAttributesObject *obj = (OnionPeelAttributesObject *)v;
    fprintf(fp, "%s", PyOnionPeelAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
OnionPeelAttributes_str(PyObject *v)
{
    OnionPeelAttributesObject *obj = (OnionPeelAttributesObject *)v;
    return PyString_FromString(PyOnionPeelAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *OnionPeelAttributes_Purpose = "Attributes for the onion peel operator";
#else
static char *OnionPeelAttributes_Purpose = "Attributes for the onion peel operator";
#endif

//
// The type description structure
//
static PyTypeObject OnionPeelAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "OnionPeelAttributes",                    // tp_name
    sizeof(OnionPeelAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)OnionPeelAttributes_dealloc,  // tp_dealloc
    (printfunc)OnionPeelAttributes_print,     // tp_print
    (getattrfunc)PyOnionPeelAttributes_getattr, // tp_getattr
    (setattrfunc)PyOnionPeelAttributes_setattr, // tp_setattr
    (cmpfunc)OnionPeelAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)OnionPeelAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    OnionPeelAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static OnionPeelAttributes *defaultAtts = 0;
static OnionPeelAttributes *currentAtts = 0;

static PyObject *
NewOnionPeelAttributes(int useCurrent)
{
    OnionPeelAttributesObject *newObject;
    newObject = PyObject_NEW(OnionPeelAttributesObject, &OnionPeelAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new OnionPeelAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new OnionPeelAttributes(*defaultAtts);
    else
        newObject->data = new OnionPeelAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapOnionPeelAttributes(const OnionPeelAttributes *attr)
{
    OnionPeelAttributesObject *newObject;
    newObject = PyObject_NEW(OnionPeelAttributesObject, &OnionPeelAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (OnionPeelAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
OnionPeelAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewOnionPeelAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef OnionPeelAttributesMethods[] = {
    {"OnionPeelAttributes", OnionPeelAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *OnionPeelAttributesObserver = 0;

std::string
PyOnionPeelAttributes_GetLogString()
{
    std::string s("OnionPeelAtts = OnionPeelAttributes()\n");
    if(currentAtts != 0)
        s += PyOnionPeelAttributes_ToString(currentAtts, "OnionPeelAtts.");
    return s;
}

static void
PyOnionPeelAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("OnionPeelAtts = OnionPeelAttributes()\n");
        s += PyOnionPeelAttributes_ToString(currentAtts, "OnionPeelAtts.");
        cb(s);
    }
}

void
PyOnionPeelAttributes_StartUp(OnionPeelAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyOnionPeelAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(OnionPeelAttributesObserver == 0)
    {
        OnionPeelAttributesObserver = new ObserverToCallback(subj,
            PyOnionPeelAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyOnionPeelAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete OnionPeelAttributesObserver;
    OnionPeelAttributesObserver = 0;
}

PyMethodDef *
PyOnionPeelAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return OnionPeelAttributesMethods;
}

bool
PyOnionPeelAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &OnionPeelAttributesType);
}

OnionPeelAttributes *
PyOnionPeelAttributes_FromPyObject(PyObject *obj)
{
    OnionPeelAttributesObject *obj2 = (OnionPeelAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyOnionPeelAttributes_New()
{
    return NewOnionPeelAttributes(0);
}

PyObject *
PyOnionPeelAttributes_Wrap(const OnionPeelAttributes *attr)
{
    return WrapOnionPeelAttributes(attr);
}

void
PyOnionPeelAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    OnionPeelAttributesObject *obj2 = (OnionPeelAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyOnionPeelAttributes_SetDefaults(const OnionPeelAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new OnionPeelAttributes(*atts);
}

