// ***************************************************************************
//
// Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
// Produced at the Lawrence Livermore National Laboratory
// LLNL-CODE-442911
// All rights reserved.
//
// This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
// full copyright notice is contained in the file COPYRIGHT located at the root
// of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
//
// Redistribution  and  use  in  source  and  binary  forms,  with  or  without
// modification, are permitted provided that the following conditions are met:
//
//  - Redistributions of  source code must  retain the above  copyright notice,
//    this list of conditions and the disclaimer below.
//  - Redistributions in binary form must reproduce the above copyright notice,
//    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
//    documentation and/or other materials provided with the distribution.
//  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
//    be used to endorse or promote products derived from this software without
//    specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
// ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
// LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
// DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
// SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
// CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
// LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
// OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
// DAMAGE.
//
// ***************************************************************************

package llnl.visit;

import java.util.Vector;
import java.lang.Integer;

// ****************************************************************************
// Class: ViewerRPC
//
// Purpose:
//    This class contains the attributes for controlling the viewer.
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

public class ViewerRPC extends AttributeSubject
{
    private static int ViewerRPC_numAdditionalAtts = 32;

    // Enum values
    public final static int VIEWERRPCTYPE_CLOSERPC = 0;
    public final static int VIEWERRPCTYPE_DETACHRPC = 1;
    public final static int VIEWERRPCTYPE_ADDWINDOWRPC = 2;
    public final static int VIEWERRPCTYPE_DELETEWINDOWRPC = 3;
    public final static int VIEWERRPCTYPE_SETWINDOWLAYOUTRPC = 4;
    public final static int VIEWERRPCTYPE_SETACTIVEWINDOWRPC = 5;
    public final static int VIEWERRPCTYPE_CLEARWINDOWRPC = 6;
    public final static int VIEWERRPCTYPE_CLEARALLWINDOWSRPC = 7;
    public final static int VIEWERRPCTYPE_OPENDATABASERPC = 8;
    public final static int VIEWERRPCTYPE_CLOSEDATABASERPC = 9;
    public final static int VIEWERRPCTYPE_ACTIVATEDATABASERPC = 10;
    public final static int VIEWERRPCTYPE_CHECKFORNEWSTATESRPC = 11;
    public final static int VIEWERRPCTYPE_CREATEDATABASECORRELATIONRPC = 12;
    public final static int VIEWERRPCTYPE_ALTERDATABASECORRELATIONRPC = 13;
    public final static int VIEWERRPCTYPE_DELETEDATABASECORRELATIONRPC = 14;
    public final static int VIEWERRPCTYPE_REOPENDATABASERPC = 15;
    public final static int VIEWERRPCTYPE_REPLACEDATABASERPC = 16;
    public final static int VIEWERRPCTYPE_OVERLAYDATABASERPC = 17;
    public final static int VIEWERRPCTYPE_OPENCOMPUTEENGINERPC = 18;
    public final static int VIEWERRPCTYPE_CLOSECOMPUTEENGINERPC = 19;
    public final static int VIEWERRPCTYPE_ANIMATIONSETNFRAMESRPC = 20;
    public final static int VIEWERRPCTYPE_ANIMATIONPLAYRPC = 21;
    public final static int VIEWERRPCTYPE_ANIMATIONREVERSEPLAYRPC = 22;
    public final static int VIEWERRPCTYPE_ANIMATIONSTOPRPC = 23;
    public final static int VIEWERRPCTYPE_TIMESLIDERNEXTSTATERPC = 24;
    public final static int VIEWERRPCTYPE_TIMESLIDERPREVIOUSSTATERPC = 25;
    public final static int VIEWERRPCTYPE_SETTIMESLIDERSTATERPC = 26;
    public final static int VIEWERRPCTYPE_SETACTIVETIMESLIDERRPC = 27;
    public final static int VIEWERRPCTYPE_ADDPLOTRPC = 28;
    public final static int VIEWERRPCTYPE_ADDEMBEDDEDPLOTRPC = 29;
    public final static int VIEWERRPCTYPE_SETPLOTFRAMERANGERPC = 30;
    public final static int VIEWERRPCTYPE_DELETEPLOTKEYFRAMERPC = 31;
    public final static int VIEWERRPCTYPE_MOVEPLOTKEYFRAMERPC = 32;
    public final static int VIEWERRPCTYPE_DELETEACTIVEPLOTSRPC = 33;
    public final static int VIEWERRPCTYPE_HIDEACTIVEPLOTSRPC = 34;
    public final static int VIEWERRPCTYPE_DRAWPLOTSRPC = 35;
    public final static int VIEWERRPCTYPE_DISABLEREDRAWRPC = 36;
    public final static int VIEWERRPCTYPE_REDRAWRPC = 37;
    public final static int VIEWERRPCTYPE_SETACTIVEPLOTSRPC = 38;
    public final static int VIEWERRPCTYPE_CHANGEACTIVEPLOTSVARRPC = 39;
    public final static int VIEWERRPCTYPE_ADDOPERATORRPC = 40;
    public final static int VIEWERRPCTYPE_ADDINITIALIZEDOPERATORRPC = 41;
    public final static int VIEWERRPCTYPE_PROMOTEOPERATORRPC = 42;
    public final static int VIEWERRPCTYPE_DEMOTEOPERATORRPC = 43;
    public final static int VIEWERRPCTYPE_REMOVEOPERATORRPC = 44;
    public final static int VIEWERRPCTYPE_REMOVELASTOPERATORRPC = 45;
    public final static int VIEWERRPCTYPE_REMOVEALLOPERATORSRPC = 46;
    public final static int VIEWERRPCTYPE_SAVEWINDOWRPC = 47;
    public final static int VIEWERRPCTYPE_SETDEFAULTPLOTOPTIONSRPC = 48;
    public final static int VIEWERRPCTYPE_SETPLOTOPTIONSRPC = 49;
    public final static int VIEWERRPCTYPE_SETDEFAULTOPERATOROPTIONSRPC = 50;
    public final static int VIEWERRPCTYPE_SETOPERATOROPTIONSRPC = 51;
    public final static int VIEWERRPCTYPE_WRITECONFIGFILERPC = 52;
    public final static int VIEWERRPCTYPE_CONNECTTOMETADATASERVERRPC = 53;
    public final static int VIEWERRPCTYPE_ICONIFYALLWINDOWSRPC = 54;
    public final static int VIEWERRPCTYPE_DEICONIFYALLWINDOWSRPC = 55;
    public final static int VIEWERRPCTYPE_SHOWALLWINDOWSRPC = 56;
    public final static int VIEWERRPCTYPE_HIDEALLWINDOWSRPC = 57;
    public final static int VIEWERRPCTYPE_UPDATECOLORTABLERPC = 58;
    public final static int VIEWERRPCTYPE_SETANNOTATIONATTRIBUTESRPC = 59;
    public final static int VIEWERRPCTYPE_SETDEFAULTANNOTATIONATTRIBUTESRPC = 60;
    public final static int VIEWERRPCTYPE_RESETANNOTATIONATTRIBUTESRPC = 61;
    public final static int VIEWERRPCTYPE_SETKEYFRAMEATTRIBUTESRPC = 62;
    public final static int VIEWERRPCTYPE_SETPLOTSILRESTRICTIONRPC = 63;
    public final static int VIEWERRPCTYPE_SETVIEWAXISARRAYRPC = 64;
    public final static int VIEWERRPCTYPE_SETVIEWCURVERPC = 65;
    public final static int VIEWERRPCTYPE_SETVIEW2DRPC = 66;
    public final static int VIEWERRPCTYPE_SETVIEW3DRPC = 67;
    public final static int VIEWERRPCTYPE_RESETPLOTOPTIONSRPC = 68;
    public final static int VIEWERRPCTYPE_RESETOPERATOROPTIONSRPC = 69;
    public final static int VIEWERRPCTYPE_SETAPPEARANCERPC = 70;
    public final static int VIEWERRPCTYPE_PROCESSEXPRESSIONSRPC = 71;
    public final static int VIEWERRPCTYPE_SETLIGHTLISTRPC = 72;
    public final static int VIEWERRPCTYPE_SETDEFAULTLIGHTLISTRPC = 73;
    public final static int VIEWERRPCTYPE_RESETLIGHTLISTRPC = 74;
    public final static int VIEWERRPCTYPE_SETANIMATIONATTRIBUTESRPC = 75;
    public final static int VIEWERRPCTYPE_SETWINDOWAREARPC = 76;
    public final static int VIEWERRPCTYPE_PRINTWINDOWRPC = 77;
    public final static int VIEWERRPCTYPE_RESETVIEWRPC = 78;
    public final static int VIEWERRPCTYPE_RECENTERVIEWRPC = 79;
    public final static int VIEWERRPCTYPE_TOGGLEALLOWPOPUPRPC = 80;
    public final static int VIEWERRPCTYPE_TOGGLEMAINTAINVIEWMODERPC = 81;
    public final static int VIEWERRPCTYPE_TOGGLEBOUNDINGBOXMODERPC = 82;
    public final static int VIEWERRPCTYPE_TOGGLECAMERAVIEWMODERPC = 83;
    public final static int VIEWERRPCTYPE_TOGGLEPERSPECTIVEVIEWRPC = 84;
    public final static int VIEWERRPCTYPE_TOGGLESPINMODERPC = 85;
    public final static int VIEWERRPCTYPE_TOGGLELOCKTIMERPC = 86;
    public final static int VIEWERRPCTYPE_TOGGLELOCKTOOLSRPC = 87;
    public final static int VIEWERRPCTYPE_TOGGLELOCKVIEWMODERPC = 88;
    public final static int VIEWERRPCTYPE_TOGGLEFULLFRAMERPC = 89;
    public final static int VIEWERRPCTYPE_UNDOVIEWRPC = 90;
    public final static int VIEWERRPCTYPE_REDOVIEWRPC = 91;
    public final static int VIEWERRPCTYPE_INVERTBACKGROUNDRPC = 92;
    public final static int VIEWERRPCTYPE_CLEARPICKPOINTSRPC = 93;
    public final static int VIEWERRPCTYPE_SETWINDOWMODERPC = 94;
    public final static int VIEWERRPCTYPE_ENABLETOOLRPC = 95;
    public final static int VIEWERRPCTYPE_SETTOOLUPDATEMODERPC = 96;
    public final static int VIEWERRPCTYPE_COPYVIEWTOWINDOWRPC = 97;
    public final static int VIEWERRPCTYPE_COPYLIGHTINGTOWINDOWRPC = 98;
    public final static int VIEWERRPCTYPE_COPYANNOTATIONSTOWINDOWRPC = 99;
    public final static int VIEWERRPCTYPE_COPYPLOTSTOWINDOWRPC = 100;
    public final static int VIEWERRPCTYPE_CLEARCACHERPC = 101;
    public final static int VIEWERRPCTYPE_CLEARCACHEFORALLENGINESRPC = 102;
    public final static int VIEWERRPCTYPE_SETVIEWEXTENTSTYPERPC = 103;
    public final static int VIEWERRPCTYPE_CLEARREFLINESRPC = 104;
    public final static int VIEWERRPCTYPE_SETRENDERINGATTRIBUTESRPC = 105;
    public final static int VIEWERRPCTYPE_QUERYRPC = 106;
    public final static int VIEWERRPCTYPE_CLONEWINDOWRPC = 107;
    public final static int VIEWERRPCTYPE_SETMATERIALATTRIBUTESRPC = 108;
    public final static int VIEWERRPCTYPE_SETDEFAULTMATERIALATTRIBUTESRPC = 109;
    public final static int VIEWERRPCTYPE_RESETMATERIALATTRIBUTESRPC = 110;
    public final static int VIEWERRPCTYPE_SETPLOTDATABASESTATERPC = 111;
    public final static int VIEWERRPCTYPE_DELETEPLOTDATABASEKEYFRAMERPC = 112;
    public final static int VIEWERRPCTYPE_MOVEPLOTDATABASEKEYFRAMERPC = 113;
    public final static int VIEWERRPCTYPE_CLEARVIEWKEYFRAMESRPC = 114;
    public final static int VIEWERRPCTYPE_DELETEVIEWKEYFRAMERPC = 115;
    public final static int VIEWERRPCTYPE_MOVEVIEWKEYFRAMERPC = 116;
    public final static int VIEWERRPCTYPE_SETVIEWKEYFRAMERPC = 117;
    public final static int VIEWERRPCTYPE_OPENMDSERVERRPC = 118;
    public final static int VIEWERRPCTYPE_ENABLETOOLBARRPC = 119;
    public final static int VIEWERRPCTYPE_HIDETOOLBARSRPC = 120;
    public final static int VIEWERRPCTYPE_HIDETOOLBARSFORALLWINDOWSRPC = 121;
    public final static int VIEWERRPCTYPE_SHOWTOOLBARSRPC = 122;
    public final static int VIEWERRPCTYPE_SHOWTOOLBARSFORALLWINDOWSRPC = 123;
    public final static int VIEWERRPCTYPE_SETTOOLBARICONSIZERPC = 124;
    public final static int VIEWERRPCTYPE_SAVEVIEWRPC = 125;
    public final static int VIEWERRPCTYPE_SETGLOBALLINEOUTATTRIBUTESRPC = 126;
    public final static int VIEWERRPCTYPE_SETPICKATTRIBUTESRPC = 127;
    public final static int VIEWERRPCTYPE_EXPORTCOLORTABLERPC = 128;
    public final static int VIEWERRPCTYPE_EXPORTENTIRESTATERPC = 129;
    public final static int VIEWERRPCTYPE_IMPORTENTIRESTATERPC = 130;
    public final static int VIEWERRPCTYPE_IMPORTENTIRESTATEWITHDIFFERENTSOURCESRPC = 131;
    public final static int VIEWERRPCTYPE_RESETPICKATTRIBUTESRPC = 132;
    public final static int VIEWERRPCTYPE_ADDANNOTATIONOBJECTRPC = 133;
    public final static int VIEWERRPCTYPE_HIDEACTIVEANNOTATIONOBJECTSRPC = 134;
    public final static int VIEWERRPCTYPE_DELETEACTIVEANNOTATIONOBJECTSRPC = 135;
    public final static int VIEWERRPCTYPE_RAISEACTIVEANNOTATIONOBJECTSRPC = 136;
    public final static int VIEWERRPCTYPE_LOWERACTIVEANNOTATIONOBJECTSRPC = 137;
    public final static int VIEWERRPCTYPE_SETANNOTATIONOBJECTOPTIONSRPC = 138;
    public final static int VIEWERRPCTYPE_SETDEFAULTANNOTATIONOBJECTLISTRPC = 139;
    public final static int VIEWERRPCTYPE_RESETANNOTATIONOBJECTLISTRPC = 140;
    public final static int VIEWERRPCTYPE_RESETPICKLETTERRPC = 141;
    public final static int VIEWERRPCTYPE_SETDEFAULTPICKATTRIBUTESRPC = 142;
    public final static int VIEWERRPCTYPE_CHOOSECENTEROFROTATIONRPC = 143;
    public final static int VIEWERRPCTYPE_SETCENTEROFROTATIONRPC = 144;
    public final static int VIEWERRPCTYPE_SETQUERYOVERTIMEATTRIBUTESRPC = 145;
    public final static int VIEWERRPCTYPE_SETDEFAULTQUERYOVERTIMEATTRIBUTESRPC = 146;
    public final static int VIEWERRPCTYPE_RESETQUERYOVERTIMEATTRIBUTESRPC = 147;
    public final static int VIEWERRPCTYPE_RESETLINEOUTCOLORRPC = 148;
    public final static int VIEWERRPCTYPE_SETINTERACTORATTRIBUTESRPC = 149;
    public final static int VIEWERRPCTYPE_SETDEFAULTINTERACTORATTRIBUTESRPC = 150;
    public final static int VIEWERRPCTYPE_RESETINTERACTORATTRIBUTESRPC = 151;
    public final static int VIEWERRPCTYPE_GETPROCINFORPC = 152;
    public final static int VIEWERRPCTYPE_SENDSIMULATIONCOMMANDRPC = 153;
    public final static int VIEWERRPCTYPE_UPDATEDBPLUGININFORPC = 154;
    public final static int VIEWERRPCTYPE_EXPORTDBRPC = 155;
    public final static int VIEWERRPCTYPE_SETTRYHARDERCYCLESTIMESRPC = 156;
    public final static int VIEWERRPCTYPE_OPENCLIENTRPC = 157;
    public final static int VIEWERRPCTYPE_OPENGUICLIENTRPC = 158;
    public final static int VIEWERRPCTYPE_OPENCLICLIENTRPC = 159;
    public final static int VIEWERRPCTYPE_SUPPRESSQUERYOUTPUTRPC = 160;
    public final static int VIEWERRPCTYPE_SETQUERYFLOATFORMATRPC = 161;
    public final static int VIEWERRPCTYPE_SETMESHMANAGEMENTATTRIBUTESRPC = 162;
    public final static int VIEWERRPCTYPE_SETDEFAULTMESHMANAGEMENTATTRIBUTESRPC = 163;
    public final static int VIEWERRPCTYPE_RESETMESHMANAGEMENTATTRIBUTESRPC = 164;
    public final static int VIEWERRPCTYPE_RESIZEWINDOWRPC = 165;
    public final static int VIEWERRPCTYPE_MOVEWINDOWRPC = 166;
    public final static int VIEWERRPCTYPE_MOVEANDRESIZEWINDOWRPC = 167;
    public final static int VIEWERRPCTYPE_SETSTATELOGGINGRPC = 168;
    public final static int VIEWERRPCTYPE_CONSTRUCTDATABINNINGRPC = 169;
    public final static int VIEWERRPCTYPE_REQUESTMETADATARPC = 170;
    public final static int VIEWERRPCTYPE_SETTREATALLDBSASTIMEVARYINGRPC = 171;
    public final static int VIEWERRPCTYPE_SETCREATEMESHQUALITYEXPRESSIONSRPC = 172;
    public final static int VIEWERRPCTYPE_SETCREATETIMEDERIVATIVEEXPRESSIONSRPC = 173;
    public final static int VIEWERRPCTYPE_SETCREATEVECTORMAGNITUDEEXPRESSIONSRPC = 174;
    public final static int VIEWERRPCTYPE_SETPRECISIONTYPERPC = 175;
    public final static int VIEWERRPCTYPE_SETBACKENDTYPERPC = 176;
    public final static int VIEWERRPCTYPE_COPYACTIVEPLOTSRPC = 177;
    public final static int VIEWERRPCTYPE_SETPLOTFOLLOWSTIMERPC = 178;
    public final static int VIEWERRPCTYPE_TURNOFFALLLOCKSRPC = 179;
    public final static int VIEWERRPCTYPE_SETDEFAULTFILEOPENOPTIONSRPC = 180;
    public final static int VIEWERRPCTYPE_SETSUPPRESSMESSAGESRPC = 181;
    public final static int VIEWERRPCTYPE_APPLYNAMEDSELECTIONRPC = 182;
    public final static int VIEWERRPCTYPE_CREATENAMEDSELECTIONRPC = 183;
    public final static int VIEWERRPCTYPE_DELETENAMEDSELECTIONRPC = 184;
    public final static int VIEWERRPCTYPE_LOADNAMEDSELECTIONRPC = 185;
    public final static int VIEWERRPCTYPE_SAVENAMEDSELECTIONRPC = 186;
    public final static int VIEWERRPCTYPE_SETNAMEDSELECTIONAUTOAPPLYRPC = 187;
    public final static int VIEWERRPCTYPE_UPDATENAMEDSELECTIONRPC = 188;
    public final static int VIEWERRPCTYPE_INITIALIZENAMEDSELECTIONVARIABLESRPC = 189;
    public final static int VIEWERRPCTYPE_MENUQUITRPC = 190;
    public final static int VIEWERRPCTYPE_SETPLOTDESCRIPTIONRPC = 191;
    public final static int VIEWERRPCTYPE_MOVEPLOTORDERTOWARDFIRSTRPC = 192;
    public final static int VIEWERRPCTYPE_MOVEPLOTORDERTOWARDLASTRPC = 193;
    public final static int VIEWERRPCTYPE_SETPLOTORDERTOFIRSTRPC = 194;
    public final static int VIEWERRPCTYPE_SETPLOTORDERTOLASTRPC = 195;
    public final static int VIEWERRPCTYPE_RENAMEPICKLABELRPC = 196;
    public final static int VIEWERRPCTYPE_GETQUERYPARAMETERSRPC = 197;
    public final static int VIEWERRPCTYPE_DDTCONNECTRPC = 198;
    public final static int VIEWERRPCTYPE_DDTFOCUSRPC = 199;
    public final static int VIEWERRPCTYPE_RELEASETODDTRPC = 200;
    public final static int VIEWERRPCTYPE_PLOTDDTVISPOINTVARIABLESRPC = 201;
    public final static int VIEWERRPCTYPE_EXPORTRPC = 202;
    public final static int VIEWERRPCTYPE_EXPORTHOSTPROFILERPC = 203;
    public final static int VIEWERRPCTYPE_READHOSTPROFILESFROMDIRECTORYRPC = 204;
    public final static int VIEWERRPCTYPE_SETREMOVEDUPLICATENODESRPC = 205;
    public final static int VIEWERRPCTYPE_MAXRPC = 206;


    public ViewerRPC()
    {
        super(ViewerRPC_numAdditionalAtts);

        RPCType = VIEWERRPCTYPE_CLOSERPC;
        windowLayout = 1;
        windowId = 0;
        windowMode = 0;
        windowArea = new String("");
        database = new String("");
        programHost = new String("");
        programSim = new String("");
        programOptions = new Vector();
        nFrames = 0;
        stateNumber = 0;
        frameRange = new int[2];
        frameRange[0] = 0;
        frameRange[1] = 0;
        frame = 0;
        plotType = 0;
        operatorType = 0;
        variable = new String("");
        activePlotIds = new Vector();
        activeOperatorIds = new Vector();
        expandedPlotIds = new Vector();
        colorTableName = new String("");
        queryName = new String("");
        queryPoint1 = new double[3];
        queryPoint1[0] = 0;
        queryPoint1[1] = 0;
        queryPoint1[2] = 0;
        toolId = 0;
        embeddedPlotId = 0;
        boolFlag = false;
        intArg1 = 0;
        intArg2 = 0;
        intArg3 = 0;
        stringArg1 = new String("");
        stringArg2 = new String("");
        toolUpdateMode = 1;
        queryParams = new MapNode();
    }

    public ViewerRPC(int nMoreFields)
    {
        super(ViewerRPC_numAdditionalAtts + nMoreFields);

        RPCType = VIEWERRPCTYPE_CLOSERPC;
        windowLayout = 1;
        windowId = 0;
        windowMode = 0;
        windowArea = new String("");
        database = new String("");
        programHost = new String("");
        programSim = new String("");
        programOptions = new Vector();
        nFrames = 0;
        stateNumber = 0;
        frameRange = new int[2];
        frameRange[0] = 0;
        frameRange[1] = 0;
        frame = 0;
        plotType = 0;
        operatorType = 0;
        variable = new String("");
        activePlotIds = new Vector();
        activeOperatorIds = new Vector();
        expandedPlotIds = new Vector();
        colorTableName = new String("");
        queryName = new String("");
        queryPoint1 = new double[3];
        queryPoint1[0] = 0;
        queryPoint1[1] = 0;
        queryPoint1[2] = 0;
        toolId = 0;
        embeddedPlotId = 0;
        boolFlag = false;
        intArg1 = 0;
        intArg2 = 0;
        intArg3 = 0;
        stringArg1 = new String("");
        stringArg2 = new String("");
        toolUpdateMode = 1;
        queryParams = new MapNode();
    }

    public ViewerRPC(ViewerRPC obj)
    {
        super(obj);

        int i;

        RPCType = obj.RPCType;
        windowLayout = obj.windowLayout;
        windowId = obj.windowId;
        windowMode = obj.windowMode;
        windowArea = new String(obj.windowArea);
        database = new String(obj.database);
        programHost = new String(obj.programHost);
        programSim = new String(obj.programSim);
        programOptions = new Vector(obj.programOptions.size());
        for(i = 0; i < obj.programOptions.size(); ++i)
            programOptions.addElement(new String((String)obj.programOptions.elementAt(i)));

        nFrames = obj.nFrames;
        stateNumber = obj.stateNumber;
        frameRange = new int[2];
        frameRange[0] = obj.frameRange[0];
        frameRange[1] = obj.frameRange[1];

        frame = obj.frame;
        plotType = obj.plotType;
        operatorType = obj.operatorType;
        variable = new String(obj.variable);
        activePlotIds = new Vector();
        for(i = 0; i < obj.activePlotIds.size(); ++i)
        {
            Integer iv = (Integer)obj.activePlotIds.elementAt(i);
            activePlotIds.addElement(new Integer(iv.intValue()));
        }
        activeOperatorIds = new Vector();
        for(i = 0; i < obj.activeOperatorIds.size(); ++i)
        {
            Integer iv = (Integer)obj.activeOperatorIds.elementAt(i);
            activeOperatorIds.addElement(new Integer(iv.intValue()));
        }
        expandedPlotIds = new Vector();
        for(i = 0; i < obj.expandedPlotIds.size(); ++i)
        {
            Integer iv = (Integer)obj.expandedPlotIds.elementAt(i);
            expandedPlotIds.addElement(new Integer(iv.intValue()));
        }
        colorTableName = new String(obj.colorTableName);
        queryName = new String(obj.queryName);
        queryPoint1 = new double[3];
        queryPoint1[0] = obj.queryPoint1[0];
        queryPoint1[1] = obj.queryPoint1[1];
        queryPoint1[2] = obj.queryPoint1[2];

        toolId = obj.toolId;
        embeddedPlotId = obj.embeddedPlotId;
        boolFlag = obj.boolFlag;
        intArg1 = obj.intArg1;
        intArg2 = obj.intArg2;
        intArg3 = obj.intArg3;
        stringArg1 = new String(obj.stringArg1);
        stringArg2 = new String(obj.stringArg2);
        toolUpdateMode = obj.toolUpdateMode;
        queryParams = new MapNode(obj.queryParams);

        SelectAll();
    }

    public int Offset()
    {
        return super.Offset() + super.GetNumAdditionalAttributes();
    }

    public int GetNumAdditionalAttributes()
    {
        return ViewerRPC_numAdditionalAtts;
    }

    public boolean equals(ViewerRPC obj)
    {
        int i;

        // Compare the elements in the programOptions vector.
        boolean programOptions_equal = (obj.programOptions.size() == programOptions.size());
        for(i = 0; (i < programOptions.size()) && programOptions_equal; ++i)
        {
            // Make references to String from Object.
            String programOptions1 = (String)programOptions.elementAt(i);
            String programOptions2 = (String)obj.programOptions.elementAt(i);
            programOptions_equal = programOptions1.equals(programOptions2);
        }
        // Compare the frameRange arrays.
        boolean frameRange_equal = true;
        for(i = 0; i < 2 && frameRange_equal; ++i)
            frameRange_equal = (frameRange[i] == obj.frameRange[i]);

        // Compare the elements in the activePlotIds vector.
        boolean activePlotIds_equal = (obj.activePlotIds.size() == activePlotIds.size());
        for(i = 0; (i < activePlotIds.size()) && activePlotIds_equal; ++i)
        {
            // Make references to Integer from Object.
            Integer activePlotIds1 = (Integer)activePlotIds.elementAt(i);
            Integer activePlotIds2 = (Integer)obj.activePlotIds.elementAt(i);
            activePlotIds_equal = activePlotIds1.equals(activePlotIds2);
        }
        // Compare the elements in the activeOperatorIds vector.
        boolean activeOperatorIds_equal = (obj.activeOperatorIds.size() == activeOperatorIds.size());
        for(i = 0; (i < activeOperatorIds.size()) && activeOperatorIds_equal; ++i)
        {
            // Make references to Integer from Object.
            Integer activeOperatorIds1 = (Integer)activeOperatorIds.elementAt(i);
            Integer activeOperatorIds2 = (Integer)obj.activeOperatorIds.elementAt(i);
            activeOperatorIds_equal = activeOperatorIds1.equals(activeOperatorIds2);
        }
        // Compare the elements in the expandedPlotIds vector.
        boolean expandedPlotIds_equal = (obj.expandedPlotIds.size() == expandedPlotIds.size());
        for(i = 0; (i < expandedPlotIds.size()) && expandedPlotIds_equal; ++i)
        {
            // Make references to Integer from Object.
            Integer expandedPlotIds1 = (Integer)expandedPlotIds.elementAt(i);
            Integer expandedPlotIds2 = (Integer)obj.expandedPlotIds.elementAt(i);
            expandedPlotIds_equal = expandedPlotIds1.equals(expandedPlotIds2);
        }
        // Compare the queryPoint1 arrays.
        boolean queryPoint1_equal = true;
        for(i = 0; i < 3 && queryPoint1_equal; ++i)
            queryPoint1_equal = (queryPoint1[i] == obj.queryPoint1[i]);

        // Create the return value
        return ((RPCType == obj.RPCType) &&
                (windowLayout == obj.windowLayout) &&
                (windowId == obj.windowId) &&
                (windowMode == obj.windowMode) &&
                (windowArea.equals(obj.windowArea)) &&
                (database.equals(obj.database)) &&
                (programHost.equals(obj.programHost)) &&
                (programSim.equals(obj.programSim)) &&
                programOptions_equal &&
                (nFrames == obj.nFrames) &&
                (stateNumber == obj.stateNumber) &&
                frameRange_equal &&
                (frame == obj.frame) &&
                (plotType == obj.plotType) &&
                (operatorType == obj.operatorType) &&
                (variable.equals(obj.variable)) &&
                activePlotIds_equal &&
                activeOperatorIds_equal &&
                expandedPlotIds_equal &&
                (colorTableName.equals(obj.colorTableName)) &&
                (queryName.equals(obj.queryName)) &&
                queryPoint1_equal &&
                (toolId == obj.toolId) &&
                (embeddedPlotId == obj.embeddedPlotId) &&
                (boolFlag == obj.boolFlag) &&
                (intArg1 == obj.intArg1) &&
                (intArg2 == obj.intArg2) &&
                (intArg3 == obj.intArg3) &&
                (stringArg1.equals(obj.stringArg1)) &&
                (stringArg2.equals(obj.stringArg2)) &&
                (toolUpdateMode == obj.toolUpdateMode) &&
                (queryParams.equals(obj.queryParams)));
    }

    // Property setting methods
    public void SetRPCType(int RPCType_)
    {
        RPCType = RPCType_;
        Select(0);
    }

    public void SetWindowLayout(int windowLayout_)
    {
        windowLayout = windowLayout_;
        Select(1);
    }

    public void SetWindowId(int windowId_)
    {
        windowId = windowId_;
        Select(2);
    }

    public void SetWindowMode(int windowMode_)
    {
        windowMode = windowMode_;
        Select(3);
    }

    public void SetWindowArea(String windowArea_)
    {
        windowArea = windowArea_;
        Select(4);
    }

    public void SetDatabase(String database_)
    {
        database = database_;
        Select(5);
    }

    public void SetProgramHost(String programHost_)
    {
        programHost = programHost_;
        Select(6);
    }

    public void SetProgramSim(String programSim_)
    {
        programSim = programSim_;
        Select(7);
    }

    public void SetProgramOptions(Vector programOptions_)
    {
        programOptions = programOptions_;
        Select(8);
    }

    public void SetNFrames(int nFrames_)
    {
        nFrames = nFrames_;
        Select(9);
    }

    public void SetStateNumber(int stateNumber_)
    {
        stateNumber = stateNumber_;
        Select(10);
    }

    public void SetFrameRange(int[] frameRange_)
    {
        frameRange[0] = frameRange_[0];
        frameRange[1] = frameRange_[1];
        Select(11);
    }

    public void SetFrameRange(int e0, int e1)
    {
        frameRange[0] = e0;
        frameRange[1] = e1;
        Select(11);
    }

    public void SetFrame(int frame_)
    {
        frame = frame_;
        Select(12);
    }

    public void SetPlotType(int plotType_)
    {
        plotType = plotType_;
        Select(13);
    }

    public void SetOperatorType(int operatorType_)
    {
        operatorType = operatorType_;
        Select(14);
    }

    public void SetVariable(String variable_)
    {
        variable = variable_;
        Select(15);
    }

    public void SetActivePlotIds(Vector activePlotIds_)
    {
        activePlotIds = activePlotIds_;
        Select(16);
    }

    public void SetActiveOperatorIds(Vector activeOperatorIds_)
    {
        activeOperatorIds = activeOperatorIds_;
        Select(17);
    }

    public void SetExpandedPlotIds(Vector expandedPlotIds_)
    {
        expandedPlotIds = expandedPlotIds_;
        Select(18);
    }

    public void SetColorTableName(String colorTableName_)
    {
        colorTableName = colorTableName_;
        Select(19);
    }

    public void SetQueryName(String queryName_)
    {
        queryName = queryName_;
        Select(20);
    }

    public void SetQueryPoint1(double[] queryPoint1_)
    {
        queryPoint1[0] = queryPoint1_[0];
        queryPoint1[1] = queryPoint1_[1];
        queryPoint1[2] = queryPoint1_[2];
        Select(21);
    }

    public void SetQueryPoint1(double e0, double e1, double e2)
    {
        queryPoint1[0] = e0;
        queryPoint1[1] = e1;
        queryPoint1[2] = e2;
        Select(21);
    }

    public void SetToolId(int toolId_)
    {
        toolId = toolId_;
        Select(22);
    }

    public void SetEmbeddedPlotId(int embeddedPlotId_)
    {
        embeddedPlotId = embeddedPlotId_;
        Select(23);
    }

    public void SetBoolFlag(boolean boolFlag_)
    {
        boolFlag = boolFlag_;
        Select(24);
    }

    public void SetIntArg1(int intArg1_)
    {
        intArg1 = intArg1_;
        Select(25);
    }

    public void SetIntArg2(int intArg2_)
    {
        intArg2 = intArg2_;
        Select(26);
    }

    public void SetIntArg3(int intArg3_)
    {
        intArg3 = intArg3_;
        Select(27);
    }

    public void SetStringArg1(String stringArg1_)
    {
        stringArg1 = stringArg1_;
        Select(28);
    }

    public void SetStringArg2(String stringArg2_)
    {
        stringArg2 = stringArg2_;
        Select(29);
    }

    public void SetToolUpdateMode(int toolUpdateMode_)
    {
        toolUpdateMode = toolUpdateMode_;
        Select(30);
    }

    public void SetQueryParams(MapNode queryParams_)
    {
        queryParams = queryParams_;
        Select(31);
    }

    // Property getting methods
    public int      GetRPCType() { return RPCType; }
    public int      GetWindowLayout() { return windowLayout; }
    public int      GetWindowId() { return windowId; }
    public int      GetWindowMode() { return windowMode; }
    public String   GetWindowArea() { return windowArea; }
    public String   GetDatabase() { return database; }
    public String   GetProgramHost() { return programHost; }
    public String   GetProgramSim() { return programSim; }
    public Vector   GetProgramOptions() { return programOptions; }
    public int      GetNFrames() { return nFrames; }
    public int      GetStateNumber() { return stateNumber; }
    public int[]    GetFrameRange() { return frameRange; }
    public int      GetFrame() { return frame; }
    public int      GetPlotType() { return plotType; }
    public int      GetOperatorType() { return operatorType; }
    public String   GetVariable() { return variable; }
    public Vector   GetActivePlotIds() { return activePlotIds; }
    public Vector   GetActiveOperatorIds() { return activeOperatorIds; }
    public Vector   GetExpandedPlotIds() { return expandedPlotIds; }
    public String   GetColorTableName() { return colorTableName; }
    public String   GetQueryName() { return queryName; }
    public double[] GetQueryPoint1() { return queryPoint1; }
    public int      GetToolId() { return toolId; }
    public int      GetEmbeddedPlotId() { return embeddedPlotId; }
    public boolean  GetBoolFlag() { return boolFlag; }
    public int      GetIntArg1() { return intArg1; }
    public int      GetIntArg2() { return intArg2; }
    public int      GetIntArg3() { return intArg3; }
    public String   GetStringArg1() { return stringArg1; }
    public String   GetStringArg2() { return stringArg2; }
    public int      GetToolUpdateMode() { return toolUpdateMode; }
    public MapNode  GetQueryParams() { return queryParams; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteInt(RPCType);
        if(WriteSelect(1, buf))
            buf.WriteInt(windowLayout);
        if(WriteSelect(2, buf))
            buf.WriteInt(windowId);
        if(WriteSelect(3, buf))
            buf.WriteInt(windowMode);
        if(WriteSelect(4, buf))
            buf.WriteString(windowArea);
        if(WriteSelect(5, buf))
            buf.WriteString(database);
        if(WriteSelect(6, buf))
            buf.WriteString(programHost);
        if(WriteSelect(7, buf))
            buf.WriteString(programSim);
        if(WriteSelect(8, buf))
            buf.WriteStringVector(programOptions);
        if(WriteSelect(9, buf))
            buf.WriteInt(nFrames);
        if(WriteSelect(10, buf))
            buf.WriteInt(stateNumber);
        if(WriteSelect(11, buf))
            buf.WriteIntArray(frameRange);
        if(WriteSelect(12, buf))
            buf.WriteInt(frame);
        if(WriteSelect(13, buf))
            buf.WriteInt(plotType);
        if(WriteSelect(14, buf))
            buf.WriteInt(operatorType);
        if(WriteSelect(15, buf))
            buf.WriteString(variable);
        if(WriteSelect(16, buf))
            buf.WriteIntVector(activePlotIds);
        if(WriteSelect(17, buf))
            buf.WriteIntVector(activeOperatorIds);
        if(WriteSelect(18, buf))
            buf.WriteIntVector(expandedPlotIds);
        if(WriteSelect(19, buf))
            buf.WriteString(colorTableName);
        if(WriteSelect(20, buf))
            buf.WriteString(queryName);
        if(WriteSelect(21, buf))
            buf.WriteDoubleArray(queryPoint1);
        if(WriteSelect(22, buf))
            buf.WriteInt(toolId);
        if(WriteSelect(23, buf))
            buf.WriteInt(embeddedPlotId);
        if(WriteSelect(24, buf))
            buf.WriteBool(boolFlag);
        if(WriteSelect(25, buf))
            buf.WriteInt(intArg1);
        if(WriteSelect(26, buf))
            buf.WriteInt(intArg2);
        if(WriteSelect(27, buf))
            buf.WriteInt(intArg3);
        if(WriteSelect(28, buf))
            buf.WriteString(stringArg1);
        if(WriteSelect(29, buf))
            buf.WriteString(stringArg2);
        if(WriteSelect(30, buf))
            buf.WriteInt(toolUpdateMode);
        if(WriteSelect(31, buf))
            queryParams.Write(buf);
    }

    public void ReadAtts(int index, CommunicationBuffer buf)
    {
        switch(index)
        {
        case 0:
            SetRPCType(buf.ReadInt());
            break;
        case 1:
            SetWindowLayout(buf.ReadInt());
            break;
        case 2:
            SetWindowId(buf.ReadInt());
            break;
        case 3:
            SetWindowMode(buf.ReadInt());
            break;
        case 4:
            SetWindowArea(buf.ReadString());
            break;
        case 5:
            SetDatabase(buf.ReadString());
            break;
        case 6:
            SetProgramHost(buf.ReadString());
            break;
        case 7:
            SetProgramSim(buf.ReadString());
            break;
        case 8:
            SetProgramOptions(buf.ReadStringVector());
            break;
        case 9:
            SetNFrames(buf.ReadInt());
            break;
        case 10:
            SetStateNumber(buf.ReadInt());
            break;
        case 11:
            SetFrameRange(buf.ReadIntArray());
            break;
        case 12:
            SetFrame(buf.ReadInt());
            break;
        case 13:
            SetPlotType(buf.ReadInt());
            break;
        case 14:
            SetOperatorType(buf.ReadInt());
            break;
        case 15:
            SetVariable(buf.ReadString());
            break;
        case 16:
            SetActivePlotIds(buf.ReadIntVector());
            break;
        case 17:
            SetActiveOperatorIds(buf.ReadIntVector());
            break;
        case 18:
            SetExpandedPlotIds(buf.ReadIntVector());
            break;
        case 19:
            SetColorTableName(buf.ReadString());
            break;
        case 20:
            SetQueryName(buf.ReadString());
            break;
        case 21:
            SetQueryPoint1(buf.ReadDoubleArray());
            break;
        case 22:
            SetToolId(buf.ReadInt());
            break;
        case 23:
            SetEmbeddedPlotId(buf.ReadInt());
            break;
        case 24:
            SetBoolFlag(buf.ReadBool());
            break;
        case 25:
            SetIntArg1(buf.ReadInt());
            break;
        case 26:
            SetIntArg2(buf.ReadInt());
            break;
        case 27:
            SetIntArg3(buf.ReadInt());
            break;
        case 28:
            SetStringArg1(buf.ReadString());
            break;
        case 29:
            SetStringArg2(buf.ReadString());
            break;
        case 30:
            SetToolUpdateMode(buf.ReadInt());
            break;
        case 31:
            queryParams.Read(buf);
            break;
        }
    }

    public String toString(String indent)
    {
        String str = new String();
        str = str + indent + "RPCType = ";
        if(RPCType == VIEWERRPCTYPE_CLOSERPC)
            str = str + "VIEWERRPCTYPE_CLOSERPC";
        if(RPCType == VIEWERRPCTYPE_DETACHRPC)
            str = str + "VIEWERRPCTYPE_DETACHRPC";
        if(RPCType == VIEWERRPCTYPE_ADDWINDOWRPC)
            str = str + "VIEWERRPCTYPE_ADDWINDOWRPC";
        if(RPCType == VIEWERRPCTYPE_DELETEWINDOWRPC)
            str = str + "VIEWERRPCTYPE_DELETEWINDOWRPC";
        if(RPCType == VIEWERRPCTYPE_SETWINDOWLAYOUTRPC)
            str = str + "VIEWERRPCTYPE_SETWINDOWLAYOUTRPC";
        if(RPCType == VIEWERRPCTYPE_SETACTIVEWINDOWRPC)
            str = str + "VIEWERRPCTYPE_SETACTIVEWINDOWRPC";
        if(RPCType == VIEWERRPCTYPE_CLEARWINDOWRPC)
            str = str + "VIEWERRPCTYPE_CLEARWINDOWRPC";
        if(RPCType == VIEWERRPCTYPE_CLEARALLWINDOWSRPC)
            str = str + "VIEWERRPCTYPE_CLEARALLWINDOWSRPC";
        if(RPCType == VIEWERRPCTYPE_OPENDATABASERPC)
            str = str + "VIEWERRPCTYPE_OPENDATABASERPC";
        if(RPCType == VIEWERRPCTYPE_CLOSEDATABASERPC)
            str = str + "VIEWERRPCTYPE_CLOSEDATABASERPC";
        if(RPCType == VIEWERRPCTYPE_ACTIVATEDATABASERPC)
            str = str + "VIEWERRPCTYPE_ACTIVATEDATABASERPC";
        if(RPCType == VIEWERRPCTYPE_CHECKFORNEWSTATESRPC)
            str = str + "VIEWERRPCTYPE_CHECKFORNEWSTATESRPC";
        if(RPCType == VIEWERRPCTYPE_CREATEDATABASECORRELATIONRPC)
            str = str + "VIEWERRPCTYPE_CREATEDATABASECORRELATIONRPC";
        if(RPCType == VIEWERRPCTYPE_ALTERDATABASECORRELATIONRPC)
            str = str + "VIEWERRPCTYPE_ALTERDATABASECORRELATIONRPC";
        if(RPCType == VIEWERRPCTYPE_DELETEDATABASECORRELATIONRPC)
            str = str + "VIEWERRPCTYPE_DELETEDATABASECORRELATIONRPC";
        if(RPCType == VIEWERRPCTYPE_REOPENDATABASERPC)
            str = str + "VIEWERRPCTYPE_REOPENDATABASERPC";
        if(RPCType == VIEWERRPCTYPE_REPLACEDATABASERPC)
            str = str + "VIEWERRPCTYPE_REPLACEDATABASERPC";
        if(RPCType == VIEWERRPCTYPE_OVERLAYDATABASERPC)
            str = str + "VIEWERRPCTYPE_OVERLAYDATABASERPC";
        if(RPCType == VIEWERRPCTYPE_OPENCOMPUTEENGINERPC)
            str = str + "VIEWERRPCTYPE_OPENCOMPUTEENGINERPC";
        if(RPCType == VIEWERRPCTYPE_CLOSECOMPUTEENGINERPC)
            str = str + "VIEWERRPCTYPE_CLOSECOMPUTEENGINERPC";
        if(RPCType == VIEWERRPCTYPE_ANIMATIONSETNFRAMESRPC)
            str = str + "VIEWERRPCTYPE_ANIMATIONSETNFRAMESRPC";
        if(RPCType == VIEWERRPCTYPE_ANIMATIONPLAYRPC)
            str = str + "VIEWERRPCTYPE_ANIMATIONPLAYRPC";
        if(RPCType == VIEWERRPCTYPE_ANIMATIONREVERSEPLAYRPC)
            str = str + "VIEWERRPCTYPE_ANIMATIONREVERSEPLAYRPC";
        if(RPCType == VIEWERRPCTYPE_ANIMATIONSTOPRPC)
            str = str + "VIEWERRPCTYPE_ANIMATIONSTOPRPC";
        if(RPCType == VIEWERRPCTYPE_TIMESLIDERNEXTSTATERPC)
            str = str + "VIEWERRPCTYPE_TIMESLIDERNEXTSTATERPC";
        if(RPCType == VIEWERRPCTYPE_TIMESLIDERPREVIOUSSTATERPC)
            str = str + "VIEWERRPCTYPE_TIMESLIDERPREVIOUSSTATERPC";
        if(RPCType == VIEWERRPCTYPE_SETTIMESLIDERSTATERPC)
            str = str + "VIEWERRPCTYPE_SETTIMESLIDERSTATERPC";
        if(RPCType == VIEWERRPCTYPE_SETACTIVETIMESLIDERRPC)
            str = str + "VIEWERRPCTYPE_SETACTIVETIMESLIDERRPC";
        if(RPCType == VIEWERRPCTYPE_ADDPLOTRPC)
            str = str + "VIEWERRPCTYPE_ADDPLOTRPC";
        if(RPCType == VIEWERRPCTYPE_ADDEMBEDDEDPLOTRPC)
            str = str + "VIEWERRPCTYPE_ADDEMBEDDEDPLOTRPC";
        if(RPCType == VIEWERRPCTYPE_SETPLOTFRAMERANGERPC)
            str = str + "VIEWERRPCTYPE_SETPLOTFRAMERANGERPC";
        if(RPCType == VIEWERRPCTYPE_DELETEPLOTKEYFRAMERPC)
            str = str + "VIEWERRPCTYPE_DELETEPLOTKEYFRAMERPC";
        if(RPCType == VIEWERRPCTYPE_MOVEPLOTKEYFRAMERPC)
            str = str + "VIEWERRPCTYPE_MOVEPLOTKEYFRAMERPC";
        if(RPCType == VIEWERRPCTYPE_DELETEACTIVEPLOTSRPC)
            str = str + "VIEWERRPCTYPE_DELETEACTIVEPLOTSRPC";
        if(RPCType == VIEWERRPCTYPE_HIDEACTIVEPLOTSRPC)
            str = str + "VIEWERRPCTYPE_HIDEACTIVEPLOTSRPC";
        if(RPCType == VIEWERRPCTYPE_DRAWPLOTSRPC)
            str = str + "VIEWERRPCTYPE_DRAWPLOTSRPC";
        if(RPCType == VIEWERRPCTYPE_DISABLEREDRAWRPC)
            str = str + "VIEWERRPCTYPE_DISABLEREDRAWRPC";
        if(RPCType == VIEWERRPCTYPE_REDRAWRPC)
            str = str + "VIEWERRPCTYPE_REDRAWRPC";
        if(RPCType == VIEWERRPCTYPE_SETACTIVEPLOTSRPC)
            str = str + "VIEWERRPCTYPE_SETACTIVEPLOTSRPC";
        if(RPCType == VIEWERRPCTYPE_CHANGEACTIVEPLOTSVARRPC)
            str = str + "VIEWERRPCTYPE_CHANGEACTIVEPLOTSVARRPC";
        if(RPCType == VIEWERRPCTYPE_ADDOPERATORRPC)
            str = str + "VIEWERRPCTYPE_ADDOPERATORRPC";
        if(RPCType == VIEWERRPCTYPE_ADDINITIALIZEDOPERATORRPC)
            str = str + "VIEWERRPCTYPE_ADDINITIALIZEDOPERATORRPC";
        if(RPCType == VIEWERRPCTYPE_PROMOTEOPERATORRPC)
            str = str + "VIEWERRPCTYPE_PROMOTEOPERATORRPC";
        if(RPCType == VIEWERRPCTYPE_DEMOTEOPERATORRPC)
            str = str + "VIEWERRPCTYPE_DEMOTEOPERATORRPC";
        if(RPCType == VIEWERRPCTYPE_REMOVEOPERATORRPC)
            str = str + "VIEWERRPCTYPE_REMOVEOPERATORRPC";
        if(RPCType == VIEWERRPCTYPE_REMOVELASTOPERATORRPC)
            str = str + "VIEWERRPCTYPE_REMOVELASTOPERATORRPC";
        if(RPCType == VIEWERRPCTYPE_REMOVEALLOPERATORSRPC)
            str = str + "VIEWERRPCTYPE_REMOVEALLOPERATORSRPC";
        if(RPCType == VIEWERRPCTYPE_SAVEWINDOWRPC)
            str = str + "VIEWERRPCTYPE_SAVEWINDOWRPC";
        if(RPCType == VIEWERRPCTYPE_SETDEFAULTPLOTOPTIONSRPC)
            str = str + "VIEWERRPCTYPE_SETDEFAULTPLOTOPTIONSRPC";
        if(RPCType == VIEWERRPCTYPE_SETPLOTOPTIONSRPC)
            str = str + "VIEWERRPCTYPE_SETPLOTOPTIONSRPC";
        if(RPCType == VIEWERRPCTYPE_SETDEFAULTOPERATOROPTIONSRPC)
            str = str + "VIEWERRPCTYPE_SETDEFAULTOPERATOROPTIONSRPC";
        if(RPCType == VIEWERRPCTYPE_SETOPERATOROPTIONSRPC)
            str = str + "VIEWERRPCTYPE_SETOPERATOROPTIONSRPC";
        if(RPCType == VIEWERRPCTYPE_WRITECONFIGFILERPC)
            str = str + "VIEWERRPCTYPE_WRITECONFIGFILERPC";
        if(RPCType == VIEWERRPCTYPE_CONNECTTOMETADATASERVERRPC)
            str = str + "VIEWERRPCTYPE_CONNECTTOMETADATASERVERRPC";
        if(RPCType == VIEWERRPCTYPE_ICONIFYALLWINDOWSRPC)
            str = str + "VIEWERRPCTYPE_ICONIFYALLWINDOWSRPC";
        if(RPCType == VIEWERRPCTYPE_DEICONIFYALLWINDOWSRPC)
            str = str + "VIEWERRPCTYPE_DEICONIFYALLWINDOWSRPC";
        if(RPCType == VIEWERRPCTYPE_SHOWALLWINDOWSRPC)
            str = str + "VIEWERRPCTYPE_SHOWALLWINDOWSRPC";
        if(RPCType == VIEWERRPCTYPE_HIDEALLWINDOWSRPC)
            str = str + "VIEWERRPCTYPE_HIDEALLWINDOWSRPC";
        if(RPCType == VIEWERRPCTYPE_UPDATECOLORTABLERPC)
            str = str + "VIEWERRPCTYPE_UPDATECOLORTABLERPC";
        if(RPCType == VIEWERRPCTYPE_SETANNOTATIONATTRIBUTESRPC)
            str = str + "VIEWERRPCTYPE_SETANNOTATIONATTRIBUTESRPC";
        if(RPCType == VIEWERRPCTYPE_SETDEFAULTANNOTATIONATTRIBUTESRPC)
            str = str + "VIEWERRPCTYPE_SETDEFAULTANNOTATIONATTRIBUTESRPC";
        if(RPCType == VIEWERRPCTYPE_RESETANNOTATIONATTRIBUTESRPC)
            str = str + "VIEWERRPCTYPE_RESETANNOTATIONATTRIBUTESRPC";
        if(RPCType == VIEWERRPCTYPE_SETKEYFRAMEATTRIBUTESRPC)
            str = str + "VIEWERRPCTYPE_SETKEYFRAMEATTRIBUTESRPC";
        if(RPCType == VIEWERRPCTYPE_SETPLOTSILRESTRICTIONRPC)
            str = str + "VIEWERRPCTYPE_SETPLOTSILRESTRICTIONRPC";
        if(RPCType == VIEWERRPCTYPE_SETVIEWAXISARRAYRPC)
            str = str + "VIEWERRPCTYPE_SETVIEWAXISARRAYRPC";
        if(RPCType == VIEWERRPCTYPE_SETVIEWCURVERPC)
            str = str + "VIEWERRPCTYPE_SETVIEWCURVERPC";
        if(RPCType == VIEWERRPCTYPE_SETVIEW2DRPC)
            str = str + "VIEWERRPCTYPE_SETVIEW2DRPC";
        if(RPCType == VIEWERRPCTYPE_SETVIEW3DRPC)
            str = str + "VIEWERRPCTYPE_SETVIEW3DRPC";
        if(RPCType == VIEWERRPCTYPE_RESETPLOTOPTIONSRPC)
            str = str + "VIEWERRPCTYPE_RESETPLOTOPTIONSRPC";
        if(RPCType == VIEWERRPCTYPE_RESETOPERATOROPTIONSRPC)
            str = str + "VIEWERRPCTYPE_RESETOPERATOROPTIONSRPC";
        if(RPCType == VIEWERRPCTYPE_SETAPPEARANCERPC)
            str = str + "VIEWERRPCTYPE_SETAPPEARANCERPC";
        if(RPCType == VIEWERRPCTYPE_PROCESSEXPRESSIONSRPC)
            str = str + "VIEWERRPCTYPE_PROCESSEXPRESSIONSRPC";
        if(RPCType == VIEWERRPCTYPE_SETLIGHTLISTRPC)
            str = str + "VIEWERRPCTYPE_SETLIGHTLISTRPC";
        if(RPCType == VIEWERRPCTYPE_SETDEFAULTLIGHTLISTRPC)
            str = str + "VIEWERRPCTYPE_SETDEFAULTLIGHTLISTRPC";
        if(RPCType == VIEWERRPCTYPE_RESETLIGHTLISTRPC)
            str = str + "VIEWERRPCTYPE_RESETLIGHTLISTRPC";
        if(RPCType == VIEWERRPCTYPE_SETANIMATIONATTRIBUTESRPC)
            str = str + "VIEWERRPCTYPE_SETANIMATIONATTRIBUTESRPC";
        if(RPCType == VIEWERRPCTYPE_SETWINDOWAREARPC)
            str = str + "VIEWERRPCTYPE_SETWINDOWAREARPC";
        if(RPCType == VIEWERRPCTYPE_PRINTWINDOWRPC)
            str = str + "VIEWERRPCTYPE_PRINTWINDOWRPC";
        if(RPCType == VIEWERRPCTYPE_RESETVIEWRPC)
            str = str + "VIEWERRPCTYPE_RESETVIEWRPC";
        if(RPCType == VIEWERRPCTYPE_RECENTERVIEWRPC)
            str = str + "VIEWERRPCTYPE_RECENTERVIEWRPC";
        if(RPCType == VIEWERRPCTYPE_TOGGLEALLOWPOPUPRPC)
            str = str + "VIEWERRPCTYPE_TOGGLEALLOWPOPUPRPC";
        if(RPCType == VIEWERRPCTYPE_TOGGLEMAINTAINVIEWMODERPC)
            str = str + "VIEWERRPCTYPE_TOGGLEMAINTAINVIEWMODERPC";
        if(RPCType == VIEWERRPCTYPE_TOGGLEBOUNDINGBOXMODERPC)
            str = str + "VIEWERRPCTYPE_TOGGLEBOUNDINGBOXMODERPC";
        if(RPCType == VIEWERRPCTYPE_TOGGLECAMERAVIEWMODERPC)
            str = str + "VIEWERRPCTYPE_TOGGLECAMERAVIEWMODERPC";
        if(RPCType == VIEWERRPCTYPE_TOGGLEPERSPECTIVEVIEWRPC)
            str = str + "VIEWERRPCTYPE_TOGGLEPERSPECTIVEVIEWRPC";
        if(RPCType == VIEWERRPCTYPE_TOGGLESPINMODERPC)
            str = str + "VIEWERRPCTYPE_TOGGLESPINMODERPC";
        if(RPCType == VIEWERRPCTYPE_TOGGLELOCKTIMERPC)
            str = str + "VIEWERRPCTYPE_TOGGLELOCKTIMERPC";
        if(RPCType == VIEWERRPCTYPE_TOGGLELOCKTOOLSRPC)
            str = str + "VIEWERRPCTYPE_TOGGLELOCKTOOLSRPC";
        if(RPCType == VIEWERRPCTYPE_TOGGLELOCKVIEWMODERPC)
            str = str + "VIEWERRPCTYPE_TOGGLELOCKVIEWMODERPC";
        if(RPCType == VIEWERRPCTYPE_TOGGLEFULLFRAMERPC)
            str = str + "VIEWERRPCTYPE_TOGGLEFULLFRAMERPC";
        if(RPCType == VIEWERRPCTYPE_UNDOVIEWRPC)
            str = str + "VIEWERRPCTYPE_UNDOVIEWRPC";
        if(RPCType == VIEWERRPCTYPE_REDOVIEWRPC)
            str = str + "VIEWERRPCTYPE_REDOVIEWRPC";
        if(RPCType == VIEWERRPCTYPE_INVERTBACKGROUNDRPC)
            str = str + "VIEWERRPCTYPE_INVERTBACKGROUNDRPC";
        if(RPCType == VIEWERRPCTYPE_CLEARPICKPOINTSRPC)
            str = str + "VIEWERRPCTYPE_CLEARPICKPOINTSRPC";
        if(RPCType == VIEWERRPCTYPE_SETWINDOWMODERPC)
            str = str + "VIEWERRPCTYPE_SETWINDOWMODERPC";
        if(RPCType == VIEWERRPCTYPE_ENABLETOOLRPC)
            str = str + "VIEWERRPCTYPE_ENABLETOOLRPC";
        if(RPCType == VIEWERRPCTYPE_SETTOOLUPDATEMODERPC)
            str = str + "VIEWERRPCTYPE_SETTOOLUPDATEMODERPC";
        if(RPCType == VIEWERRPCTYPE_COPYVIEWTOWINDOWRPC)
            str = str + "VIEWERRPCTYPE_COPYVIEWTOWINDOWRPC";
        if(RPCType == VIEWERRPCTYPE_COPYLIGHTINGTOWINDOWRPC)
            str = str + "VIEWERRPCTYPE_COPYLIGHTINGTOWINDOWRPC";
        if(RPCType == VIEWERRPCTYPE_COPYANNOTATIONSTOWINDOWRPC)
            str = str + "VIEWERRPCTYPE_COPYANNOTATIONSTOWINDOWRPC";
        if(RPCType == VIEWERRPCTYPE_COPYPLOTSTOWINDOWRPC)
            str = str + "VIEWERRPCTYPE_COPYPLOTSTOWINDOWRPC";
        if(RPCType == VIEWERRPCTYPE_CLEARCACHERPC)
            str = str + "VIEWERRPCTYPE_CLEARCACHERPC";
        if(RPCType == VIEWERRPCTYPE_CLEARCACHEFORALLENGINESRPC)
            str = str + "VIEWERRPCTYPE_CLEARCACHEFORALLENGINESRPC";
        if(RPCType == VIEWERRPCTYPE_SETVIEWEXTENTSTYPERPC)
            str = str + "VIEWERRPCTYPE_SETVIEWEXTENTSTYPERPC";
        if(RPCType == VIEWERRPCTYPE_CLEARREFLINESRPC)
            str = str + "VIEWERRPCTYPE_CLEARREFLINESRPC";
        if(RPCType == VIEWERRPCTYPE_SETRENDERINGATTRIBUTESRPC)
            str = str + "VIEWERRPCTYPE_SETRENDERINGATTRIBUTESRPC";
        if(RPCType == VIEWERRPCTYPE_QUERYRPC)
            str = str + "VIEWERRPCTYPE_QUERYRPC";
        if(RPCType == VIEWERRPCTYPE_CLONEWINDOWRPC)
            str = str + "VIEWERRPCTYPE_CLONEWINDOWRPC";
        if(RPCType == VIEWERRPCTYPE_SETMATERIALATTRIBUTESRPC)
            str = str + "VIEWERRPCTYPE_SETMATERIALATTRIBUTESRPC";
        if(RPCType == VIEWERRPCTYPE_SETDEFAULTMATERIALATTRIBUTESRPC)
            str = str + "VIEWERRPCTYPE_SETDEFAULTMATERIALATTRIBUTESRPC";
        if(RPCType == VIEWERRPCTYPE_RESETMATERIALATTRIBUTESRPC)
            str = str + "VIEWERRPCTYPE_RESETMATERIALATTRIBUTESRPC";
        if(RPCType == VIEWERRPCTYPE_SETPLOTDATABASESTATERPC)
            str = str + "VIEWERRPCTYPE_SETPLOTDATABASESTATERPC";
        if(RPCType == VIEWERRPCTYPE_DELETEPLOTDATABASEKEYFRAMERPC)
            str = str + "VIEWERRPCTYPE_DELETEPLOTDATABASEKEYFRAMERPC";
        if(RPCType == VIEWERRPCTYPE_MOVEPLOTDATABASEKEYFRAMERPC)
            str = str + "VIEWERRPCTYPE_MOVEPLOTDATABASEKEYFRAMERPC";
        if(RPCType == VIEWERRPCTYPE_CLEARVIEWKEYFRAMESRPC)
            str = str + "VIEWERRPCTYPE_CLEARVIEWKEYFRAMESRPC";
        if(RPCType == VIEWERRPCTYPE_DELETEVIEWKEYFRAMERPC)
            str = str + "VIEWERRPCTYPE_DELETEVIEWKEYFRAMERPC";
        if(RPCType == VIEWERRPCTYPE_MOVEVIEWKEYFRAMERPC)
            str = str + "VIEWERRPCTYPE_MOVEVIEWKEYFRAMERPC";
        if(RPCType == VIEWERRPCTYPE_SETVIEWKEYFRAMERPC)
            str = str + "VIEWERRPCTYPE_SETVIEWKEYFRAMERPC";
        if(RPCType == VIEWERRPCTYPE_OPENMDSERVERRPC)
            str = str + "VIEWERRPCTYPE_OPENMDSERVERRPC";
        if(RPCType == VIEWERRPCTYPE_ENABLETOOLBARRPC)
            str = str + "VIEWERRPCTYPE_ENABLETOOLBARRPC";
        if(RPCType == VIEWERRPCTYPE_HIDETOOLBARSRPC)
            str = str + "VIEWERRPCTYPE_HIDETOOLBARSRPC";
        if(RPCType == VIEWERRPCTYPE_HIDETOOLBARSFORALLWINDOWSRPC)
            str = str + "VIEWERRPCTYPE_HIDETOOLBARSFORALLWINDOWSRPC";
        if(RPCType == VIEWERRPCTYPE_SHOWTOOLBARSRPC)
            str = str + "VIEWERRPCTYPE_SHOWTOOLBARSRPC";
        if(RPCType == VIEWERRPCTYPE_SHOWTOOLBARSFORALLWINDOWSRPC)
            str = str + "VIEWERRPCTYPE_SHOWTOOLBARSFORALLWINDOWSRPC";
        if(RPCType == VIEWERRPCTYPE_SETTOOLBARICONSIZERPC)
            str = str + "VIEWERRPCTYPE_SETTOOLBARICONSIZERPC";
        if(RPCType == VIEWERRPCTYPE_SAVEVIEWRPC)
            str = str + "VIEWERRPCTYPE_SAVEVIEWRPC";
        if(RPCType == VIEWERRPCTYPE_SETGLOBALLINEOUTATTRIBUTESRPC)
            str = str + "VIEWERRPCTYPE_SETGLOBALLINEOUTATTRIBUTESRPC";
        if(RPCType == VIEWERRPCTYPE_SETPICKATTRIBUTESRPC)
            str = str + "VIEWERRPCTYPE_SETPICKATTRIBUTESRPC";
        if(RPCType == VIEWERRPCTYPE_EXPORTCOLORTABLERPC)
            str = str + "VIEWERRPCTYPE_EXPORTCOLORTABLERPC";
        if(RPCType == VIEWERRPCTYPE_EXPORTENTIRESTATERPC)
            str = str + "VIEWERRPCTYPE_EXPORTENTIRESTATERPC";
        if(RPCType == VIEWERRPCTYPE_IMPORTENTIRESTATERPC)
            str = str + "VIEWERRPCTYPE_IMPORTENTIRESTATERPC";
        if(RPCType == VIEWERRPCTYPE_IMPORTENTIRESTATEWITHDIFFERENTSOURCESRPC)
            str = str + "VIEWERRPCTYPE_IMPORTENTIRESTATEWITHDIFFERENTSOURCESRPC";
        if(RPCType == VIEWERRPCTYPE_RESETPICKATTRIBUTESRPC)
            str = str + "VIEWERRPCTYPE_RESETPICKATTRIBUTESRPC";
        if(RPCType == VIEWERRPCTYPE_ADDANNOTATIONOBJECTRPC)
            str = str + "VIEWERRPCTYPE_ADDANNOTATIONOBJECTRPC";
        if(RPCType == VIEWERRPCTYPE_HIDEACTIVEANNOTATIONOBJECTSRPC)
            str = str + "VIEWERRPCTYPE_HIDEACTIVEANNOTATIONOBJECTSRPC";
        if(RPCType == VIEWERRPCTYPE_DELETEACTIVEANNOTATIONOBJECTSRPC)
            str = str + "VIEWERRPCTYPE_DELETEACTIVEANNOTATIONOBJECTSRPC";
        if(RPCType == VIEWERRPCTYPE_RAISEACTIVEANNOTATIONOBJECTSRPC)
            str = str + "VIEWERRPCTYPE_RAISEACTIVEANNOTATIONOBJECTSRPC";
        if(RPCType == VIEWERRPCTYPE_LOWERACTIVEANNOTATIONOBJECTSRPC)
            str = str + "VIEWERRPCTYPE_LOWERACTIVEANNOTATIONOBJECTSRPC";
        if(RPCType == VIEWERRPCTYPE_SETANNOTATIONOBJECTOPTIONSRPC)
            str = str + "VIEWERRPCTYPE_SETANNOTATIONOBJECTOPTIONSRPC";
        if(RPCType == VIEWERRPCTYPE_SETDEFAULTANNOTATIONOBJECTLISTRPC)
            str = str + "VIEWERRPCTYPE_SETDEFAULTANNOTATIONOBJECTLISTRPC";
        if(RPCType == VIEWERRPCTYPE_RESETANNOTATIONOBJECTLISTRPC)
            str = str + "VIEWERRPCTYPE_RESETANNOTATIONOBJECTLISTRPC";
        if(RPCType == VIEWERRPCTYPE_RESETPICKLETTERRPC)
            str = str + "VIEWERRPCTYPE_RESETPICKLETTERRPC";
        if(RPCType == VIEWERRPCTYPE_SETDEFAULTPICKATTRIBUTESRPC)
            str = str + "VIEWERRPCTYPE_SETDEFAULTPICKATTRIBUTESRPC";
        if(RPCType == VIEWERRPCTYPE_CHOOSECENTEROFROTATIONRPC)
            str = str + "VIEWERRPCTYPE_CHOOSECENTEROFROTATIONRPC";
        if(RPCType == VIEWERRPCTYPE_SETCENTEROFROTATIONRPC)
            str = str + "VIEWERRPCTYPE_SETCENTEROFROTATIONRPC";
        if(RPCType == VIEWERRPCTYPE_SETQUERYOVERTIMEATTRIBUTESRPC)
            str = str + "VIEWERRPCTYPE_SETQUERYOVERTIMEATTRIBUTESRPC";
        if(RPCType == VIEWERRPCTYPE_SETDEFAULTQUERYOVERTIMEATTRIBUTESRPC)
            str = str + "VIEWERRPCTYPE_SETDEFAULTQUERYOVERTIMEATTRIBUTESRPC";
        if(RPCType == VIEWERRPCTYPE_RESETQUERYOVERTIMEATTRIBUTESRPC)
            str = str + "VIEWERRPCTYPE_RESETQUERYOVERTIMEATTRIBUTESRPC";
        if(RPCType == VIEWERRPCTYPE_RESETLINEOUTCOLORRPC)
            str = str + "VIEWERRPCTYPE_RESETLINEOUTCOLORRPC";
        if(RPCType == VIEWERRPCTYPE_SETINTERACTORATTRIBUTESRPC)
            str = str + "VIEWERRPCTYPE_SETINTERACTORATTRIBUTESRPC";
        if(RPCType == VIEWERRPCTYPE_SETDEFAULTINTERACTORATTRIBUTESRPC)
            str = str + "VIEWERRPCTYPE_SETDEFAULTINTERACTORATTRIBUTESRPC";
        if(RPCType == VIEWERRPCTYPE_RESETINTERACTORATTRIBUTESRPC)
            str = str + "VIEWERRPCTYPE_RESETINTERACTORATTRIBUTESRPC";
        if(RPCType == VIEWERRPCTYPE_GETPROCINFORPC)
            str = str + "VIEWERRPCTYPE_GETPROCINFORPC";
        if(RPCType == VIEWERRPCTYPE_SENDSIMULATIONCOMMANDRPC)
            str = str + "VIEWERRPCTYPE_SENDSIMULATIONCOMMANDRPC";
        if(RPCType == VIEWERRPCTYPE_UPDATEDBPLUGININFORPC)
            str = str + "VIEWERRPCTYPE_UPDATEDBPLUGININFORPC";
        if(RPCType == VIEWERRPCTYPE_EXPORTDBRPC)
            str = str + "VIEWERRPCTYPE_EXPORTDBRPC";
        if(RPCType == VIEWERRPCTYPE_SETTRYHARDERCYCLESTIMESRPC)
            str = str + "VIEWERRPCTYPE_SETTRYHARDERCYCLESTIMESRPC";
        if(RPCType == VIEWERRPCTYPE_OPENCLIENTRPC)
            str = str + "VIEWERRPCTYPE_OPENCLIENTRPC";
        if(RPCType == VIEWERRPCTYPE_OPENGUICLIENTRPC)
            str = str + "VIEWERRPCTYPE_OPENGUICLIENTRPC";
        if(RPCType == VIEWERRPCTYPE_OPENCLICLIENTRPC)
            str = str + "VIEWERRPCTYPE_OPENCLICLIENTRPC";
        if(RPCType == VIEWERRPCTYPE_SUPPRESSQUERYOUTPUTRPC)
            str = str + "VIEWERRPCTYPE_SUPPRESSQUERYOUTPUTRPC";
        if(RPCType == VIEWERRPCTYPE_SETQUERYFLOATFORMATRPC)
            str = str + "VIEWERRPCTYPE_SETQUERYFLOATFORMATRPC";
        if(RPCType == VIEWERRPCTYPE_SETMESHMANAGEMENTATTRIBUTESRPC)
            str = str + "VIEWERRPCTYPE_SETMESHMANAGEMENTATTRIBUTESRPC";
        if(RPCType == VIEWERRPCTYPE_SETDEFAULTMESHMANAGEMENTATTRIBUTESRPC)
            str = str + "VIEWERRPCTYPE_SETDEFAULTMESHMANAGEMENTATTRIBUTESRPC";
        if(RPCType == VIEWERRPCTYPE_RESETMESHMANAGEMENTATTRIBUTESRPC)
            str = str + "VIEWERRPCTYPE_RESETMESHMANAGEMENTATTRIBUTESRPC";
        if(RPCType == VIEWERRPCTYPE_RESIZEWINDOWRPC)
            str = str + "VIEWERRPCTYPE_RESIZEWINDOWRPC";
        if(RPCType == VIEWERRPCTYPE_MOVEWINDOWRPC)
            str = str + "VIEWERRPCTYPE_MOVEWINDOWRPC";
        if(RPCType == VIEWERRPCTYPE_MOVEANDRESIZEWINDOWRPC)
            str = str + "VIEWERRPCTYPE_MOVEANDRESIZEWINDOWRPC";
        if(RPCType == VIEWERRPCTYPE_SETSTATELOGGINGRPC)
            str = str + "VIEWERRPCTYPE_SETSTATELOGGINGRPC";
        if(RPCType == VIEWERRPCTYPE_CONSTRUCTDATABINNINGRPC)
            str = str + "VIEWERRPCTYPE_CONSTRUCTDATABINNINGRPC";
        if(RPCType == VIEWERRPCTYPE_REQUESTMETADATARPC)
            str = str + "VIEWERRPCTYPE_REQUESTMETADATARPC";
        if(RPCType == VIEWERRPCTYPE_SETTREATALLDBSASTIMEVARYINGRPC)
            str = str + "VIEWERRPCTYPE_SETTREATALLDBSASTIMEVARYINGRPC";
        if(RPCType == VIEWERRPCTYPE_SETCREATEMESHQUALITYEXPRESSIONSRPC)
            str = str + "VIEWERRPCTYPE_SETCREATEMESHQUALITYEXPRESSIONSRPC";
        if(RPCType == VIEWERRPCTYPE_SETCREATETIMEDERIVATIVEEXPRESSIONSRPC)
            str = str + "VIEWERRPCTYPE_SETCREATETIMEDERIVATIVEEXPRESSIONSRPC";
        if(RPCType == VIEWERRPCTYPE_SETCREATEVECTORMAGNITUDEEXPRESSIONSRPC)
            str = str + "VIEWERRPCTYPE_SETCREATEVECTORMAGNITUDEEXPRESSIONSRPC";
        if(RPCType == VIEWERRPCTYPE_SETPRECISIONTYPERPC)
            str = str + "VIEWERRPCTYPE_SETPRECISIONTYPERPC";
        if(RPCType == VIEWERRPCTYPE_SETBACKENDTYPERPC)
            str = str + "VIEWERRPCTYPE_SETBACKENDTYPERPC";
        if(RPCType == VIEWERRPCTYPE_COPYACTIVEPLOTSRPC)
            str = str + "VIEWERRPCTYPE_COPYACTIVEPLOTSRPC";
        if(RPCType == VIEWERRPCTYPE_SETPLOTFOLLOWSTIMERPC)
            str = str + "VIEWERRPCTYPE_SETPLOTFOLLOWSTIMERPC";
        if(RPCType == VIEWERRPCTYPE_TURNOFFALLLOCKSRPC)
            str = str + "VIEWERRPCTYPE_TURNOFFALLLOCKSRPC";
        if(RPCType == VIEWERRPCTYPE_SETDEFAULTFILEOPENOPTIONSRPC)
            str = str + "VIEWERRPCTYPE_SETDEFAULTFILEOPENOPTIONSRPC";
        if(RPCType == VIEWERRPCTYPE_SETSUPPRESSMESSAGESRPC)
            str = str + "VIEWERRPCTYPE_SETSUPPRESSMESSAGESRPC";
        if(RPCType == VIEWERRPCTYPE_APPLYNAMEDSELECTIONRPC)
            str = str + "VIEWERRPCTYPE_APPLYNAMEDSELECTIONRPC";
        if(RPCType == VIEWERRPCTYPE_CREATENAMEDSELECTIONRPC)
            str = str + "VIEWERRPCTYPE_CREATENAMEDSELECTIONRPC";
        if(RPCType == VIEWERRPCTYPE_DELETENAMEDSELECTIONRPC)
            str = str + "VIEWERRPCTYPE_DELETENAMEDSELECTIONRPC";
        if(RPCType == VIEWERRPCTYPE_LOADNAMEDSELECTIONRPC)
            str = str + "VIEWERRPCTYPE_LOADNAMEDSELECTIONRPC";
        if(RPCType == VIEWERRPCTYPE_SAVENAMEDSELECTIONRPC)
            str = str + "VIEWERRPCTYPE_SAVENAMEDSELECTIONRPC";
        if(RPCType == VIEWERRPCTYPE_SETNAMEDSELECTIONAUTOAPPLYRPC)
            str = str + "VIEWERRPCTYPE_SETNAMEDSELECTIONAUTOAPPLYRPC";
        if(RPCType == VIEWERRPCTYPE_UPDATENAMEDSELECTIONRPC)
            str = str + "VIEWERRPCTYPE_UPDATENAMEDSELECTIONRPC";
        if(RPCType == VIEWERRPCTYPE_INITIALIZENAMEDSELECTIONVARIABLESRPC)
            str = str + "VIEWERRPCTYPE_INITIALIZENAMEDSELECTIONVARIABLESRPC";
        if(RPCType == VIEWERRPCTYPE_MENUQUITRPC)
            str = str + "VIEWERRPCTYPE_MENUQUITRPC";
        if(RPCType == VIEWERRPCTYPE_SETPLOTDESCRIPTIONRPC)
            str = str + "VIEWERRPCTYPE_SETPLOTDESCRIPTIONRPC";
        if(RPCType == VIEWERRPCTYPE_MOVEPLOTORDERTOWARDFIRSTRPC)
            str = str + "VIEWERRPCTYPE_MOVEPLOTORDERTOWARDFIRSTRPC";
        if(RPCType == VIEWERRPCTYPE_MOVEPLOTORDERTOWARDLASTRPC)
            str = str + "VIEWERRPCTYPE_MOVEPLOTORDERTOWARDLASTRPC";
        if(RPCType == VIEWERRPCTYPE_SETPLOTORDERTOFIRSTRPC)
            str = str + "VIEWERRPCTYPE_SETPLOTORDERTOFIRSTRPC";
        if(RPCType == VIEWERRPCTYPE_SETPLOTORDERTOLASTRPC)
            str = str + "VIEWERRPCTYPE_SETPLOTORDERTOLASTRPC";
        if(RPCType == VIEWERRPCTYPE_RENAMEPICKLABELRPC)
            str = str + "VIEWERRPCTYPE_RENAMEPICKLABELRPC";
        if(RPCType == VIEWERRPCTYPE_GETQUERYPARAMETERSRPC)
            str = str + "VIEWERRPCTYPE_GETQUERYPARAMETERSRPC";
        if(RPCType == VIEWERRPCTYPE_DDTCONNECTRPC)
            str = str + "VIEWERRPCTYPE_DDTCONNECTRPC";
        if(RPCType == VIEWERRPCTYPE_DDTFOCUSRPC)
            str = str + "VIEWERRPCTYPE_DDTFOCUSRPC";
        if(RPCType == VIEWERRPCTYPE_RELEASETODDTRPC)
            str = str + "VIEWERRPCTYPE_RELEASETODDTRPC";
        if(RPCType == VIEWERRPCTYPE_PLOTDDTVISPOINTVARIABLESRPC)
            str = str + "VIEWERRPCTYPE_PLOTDDTVISPOINTVARIABLESRPC";
        if(RPCType == VIEWERRPCTYPE_EXPORTRPC)
            str = str + "VIEWERRPCTYPE_EXPORTRPC";
        if(RPCType == VIEWERRPCTYPE_EXPORTHOSTPROFILERPC)
            str = str + "VIEWERRPCTYPE_EXPORTHOSTPROFILERPC";
        if(RPCType == VIEWERRPCTYPE_READHOSTPROFILESFROMDIRECTORYRPC)
            str = str + "VIEWERRPCTYPE_READHOSTPROFILESFROMDIRECTORYRPC";
        if(RPCType == VIEWERRPCTYPE_SETREMOVEDUPLICATENODESRPC)
            str = str + "VIEWERRPCTYPE_SETREMOVEDUPLICATENODESRPC";
        if(RPCType == VIEWERRPCTYPE_MAXRPC)
            str = str + "VIEWERRPCTYPE_MAXRPC";
        str = str + "\n";
        str = str + intToString("windowLayout", windowLayout, indent) + "\n";
        str = str + intToString("windowId", windowId, indent) + "\n";
        str = str + intToString("windowMode", windowMode, indent) + "\n";
        str = str + stringToString("windowArea", windowArea, indent) + "\n";
        str = str + stringToString("database", database, indent) + "\n";
        str = str + stringToString("programHost", programHost, indent) + "\n";
        str = str + stringToString("programSim", programSim, indent) + "\n";
        str = str + stringVectorToString("programOptions", programOptions, indent) + "\n";
        str = str + intToString("nFrames", nFrames, indent) + "\n";
        str = str + intToString("stateNumber", stateNumber, indent) + "\n";
        str = str + intArrayToString("frameRange", frameRange, indent) + "\n";
        str = str + intToString("frame", frame, indent) + "\n";
        str = str + intToString("plotType", plotType, indent) + "\n";
        str = str + intToString("operatorType", operatorType, indent) + "\n";
        str = str + stringToString("variable", variable, indent) + "\n";
        str = str + intVectorToString("activePlotIds", activePlotIds, indent) + "\n";
        str = str + intVectorToString("activeOperatorIds", activeOperatorIds, indent) + "\n";
        str = str + intVectorToString("expandedPlotIds", expandedPlotIds, indent) + "\n";
        str = str + stringToString("colorTableName", colorTableName, indent) + "\n";
        str = str + stringToString("queryName", queryName, indent) + "\n";
        str = str + doubleArrayToString("queryPoint1", queryPoint1, indent) + "\n";
        str = str + intToString("toolId", toolId, indent) + "\n";
        str = str + intToString("embeddedPlotId", embeddedPlotId, indent) + "\n";
        str = str + boolToString("boolFlag", boolFlag, indent) + "\n";
        str = str + intToString("intArg1", intArg1, indent) + "\n";
        str = str + intToString("intArg2", intArg2, indent) + "\n";
        str = str + intToString("intArg3", intArg3, indent) + "\n";
        str = str + stringToString("stringArg1", stringArg1, indent) + "\n";
        str = str + stringToString("stringArg2", stringArg2, indent) + "\n";
        str = str + intToString("toolUpdateMode", toolUpdateMode, indent) + "\n";
        str = str + indent + "queryParams = " + queryParams.toString(indent);
        return str;
    }


    // Attributes
    private int      RPCType;
    private int      windowLayout;
    private int      windowId;
    private int      windowMode;
    private String   windowArea;
    private String   database;
    private String   programHost;
    private String   programSim;
    private Vector   programOptions; // vector of String objects
    private int      nFrames;
    private int      stateNumber;
    private int[]    frameRange;
    private int      frame;
    private int      plotType;
    private int      operatorType;
    private String   variable;
    private Vector   activePlotIds; // vector of Integer objects
    private Vector   activeOperatorIds; // vector of Integer objects
    private Vector   expandedPlotIds; // vector of Integer objects
    private String   colorTableName;
    private String   queryName;
    private double[] queryPoint1;
    private int      toolId;
    private int      embeddedPlotId;
    private boolean  boolFlag;
    private int      intArg1;
    private int      intArg2;
    private int      intArg3;
    private String   stringArg1;
    private String   stringArg2;
    private int      toolUpdateMode;
    private MapNode  queryParams;
}

