/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <ViewAttributes.h>
#include <DataNode.h>

// ****************************************************************************
// Method: ViewAttributes::ViewAttributes
//
// Purpose: 
//   Init utility for the ViewAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void ViewAttributes::Init()
{
    viewNormal[0] = 0;
    viewNormal[1] = 0;
    viewNormal[2] = 1;
    focus[0] = 0;
    focus[1] = 0;
    focus[2] = 0;
    viewUp[0] = 0;
    viewUp[1] = 1;
    viewUp[2] = 0;
    viewAngle = 30;
    setScale = false;
    parallelScale = 1;
    nearPlane = 0.001;
    farPlane = 100;
    imagePan[0] = 0;
    imagePan[1] = 0;
    imageZoom = 1;
    perspective = true;
    windowCoords[0] = 0;
    windowCoords[1] = 0;
    windowCoords[2] = 1;
    windowCoords[3] = 1;
    viewportCoords[0] = 0.1;
    viewportCoords[1] = 0.1;
    viewportCoords[2] = 0.9;
    viewportCoords[3] = 0.9;
    eyeAngle = 2;

    ViewAttributes::SelectAll();
}

// ****************************************************************************
// Method: ViewAttributes::ViewAttributes
//
// Purpose: 
//   Copy utility for the ViewAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void ViewAttributes::Copy(const ViewAttributes &obj)
{

    viewNormal[0] = obj.viewNormal[0];
    viewNormal[1] = obj.viewNormal[1];
    viewNormal[2] = obj.viewNormal[2];

    focus[0] = obj.focus[0];
    focus[1] = obj.focus[1];
    focus[2] = obj.focus[2];

    viewUp[0] = obj.viewUp[0];
    viewUp[1] = obj.viewUp[1];
    viewUp[2] = obj.viewUp[2];

    viewAngle = obj.viewAngle;
    setScale = obj.setScale;
    parallelScale = obj.parallelScale;
    nearPlane = obj.nearPlane;
    farPlane = obj.farPlane;
    imagePan[0] = obj.imagePan[0];
    imagePan[1] = obj.imagePan[1];

    imageZoom = obj.imageZoom;
    perspective = obj.perspective;
    for(int i = 0; i < 4; ++i)
        windowCoords[i] = obj.windowCoords[i];

    for(int i = 0; i < 4; ++i)
        viewportCoords[i] = obj.viewportCoords[i];

    eyeAngle = obj.eyeAngle;

    ViewAttributes::SelectAll();
}

// Type map format string
const char *ViewAttributes::TypeMapFormatString = VIEWATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t ViewAttributes::TmfsStruct = {VIEWATTRIBUTES_TMFS};


// ****************************************************************************
// Method: ViewAttributes::ViewAttributes
//
// Purpose: 
//   Default constructor for the ViewAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ViewAttributes::ViewAttributes() : 
    AttributeSubject(ViewAttributes::TypeMapFormatString)
{
    ViewAttributes::Init();
}

// ****************************************************************************
// Method: ViewAttributes::ViewAttributes
//
// Purpose: 
//   Constructor for the derived classes of ViewAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ViewAttributes::ViewAttributes(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    ViewAttributes::Init();
}

// ****************************************************************************
// Method: ViewAttributes::ViewAttributes
//
// Purpose: 
//   Copy constructor for the ViewAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ViewAttributes::ViewAttributes(const ViewAttributes &obj) : 
    AttributeSubject(ViewAttributes::TypeMapFormatString)
{
    ViewAttributes::Copy(obj);
}

// ****************************************************************************
// Method: ViewAttributes::ViewAttributes
//
// Purpose: 
//   Copy constructor for derived classes of the ViewAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ViewAttributes::ViewAttributes(const ViewAttributes &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    ViewAttributes::Copy(obj);
}

// ****************************************************************************
// Method: ViewAttributes::~ViewAttributes
//
// Purpose: 
//   Destructor for the ViewAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ViewAttributes::~ViewAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: ViewAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the ViewAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

ViewAttributes& 
ViewAttributes::operator = (const ViewAttributes &obj)
{
    if (this == &obj) return *this;

    ViewAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: ViewAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the ViewAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ViewAttributes::operator == (const ViewAttributes &obj) const
{
    // Compare the viewNormal arrays.
    bool viewNormal_equal = true;
    for(int i = 0; i < 3 && viewNormal_equal; ++i)
        viewNormal_equal = (viewNormal[i] == obj.viewNormal[i]);

    // Compare the focus arrays.
    bool focus_equal = true;
    for(int i = 0; i < 3 && focus_equal; ++i)
        focus_equal = (focus[i] == obj.focus[i]);

    // Compare the viewUp arrays.
    bool viewUp_equal = true;
    for(int i = 0; i < 3 && viewUp_equal; ++i)
        viewUp_equal = (viewUp[i] == obj.viewUp[i]);

    // Compare the imagePan arrays.
    bool imagePan_equal = true;
    for(int i = 0; i < 2 && imagePan_equal; ++i)
        imagePan_equal = (imagePan[i] == obj.imagePan[i]);

    // Compare the windowCoords arrays.
    bool windowCoords_equal = true;
    for(int i = 0; i < 4 && windowCoords_equal; ++i)
        windowCoords_equal = (windowCoords[i] == obj.windowCoords[i]);

    // Compare the viewportCoords arrays.
    bool viewportCoords_equal = true;
    for(int i = 0; i < 4 && viewportCoords_equal; ++i)
        viewportCoords_equal = (viewportCoords[i] == obj.viewportCoords[i]);

    // Create the return value
    return (viewNormal_equal &&
            focus_equal &&
            viewUp_equal &&
            (viewAngle == obj.viewAngle) &&
            (setScale == obj.setScale) &&
            (parallelScale == obj.parallelScale) &&
            (nearPlane == obj.nearPlane) &&
            (farPlane == obj.farPlane) &&
            imagePan_equal &&
            (imageZoom == obj.imageZoom) &&
            (perspective == obj.perspective) &&
            windowCoords_equal &&
            viewportCoords_equal &&
            (eyeAngle == obj.eyeAngle));
}

// ****************************************************************************
// Method: ViewAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the ViewAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ViewAttributes::operator != (const ViewAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: ViewAttributes::TypeName
//
// Purpose: 
//   Type name method for the ViewAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
ViewAttributes::TypeName() const
{
    return "ViewAttributes";
}

// ****************************************************************************
// Method: ViewAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the ViewAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ViewAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const ViewAttributes *tmp = (const ViewAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: ViewAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the ViewAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
ViewAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new ViewAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: ViewAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the ViewAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
ViewAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new ViewAttributes(*this);
    else
        retval = new ViewAttributes;

    return retval;
}

// ****************************************************************************
// Method: ViewAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
ViewAttributes::SelectAll()
{
    Select(ID_viewNormal,     (void *)viewNormal, 3);
    Select(ID_focus,          (void *)focus, 3);
    Select(ID_viewUp,         (void *)viewUp, 3);
    Select(ID_viewAngle,      (void *)&viewAngle);
    Select(ID_setScale,       (void *)&setScale);
    Select(ID_parallelScale,  (void *)&parallelScale);
    Select(ID_nearPlane,      (void *)&nearPlane);
    Select(ID_farPlane,       (void *)&farPlane);
    Select(ID_imagePan,       (void *)imagePan, 2);
    Select(ID_imageZoom,      (void *)&imageZoom);
    Select(ID_perspective,    (void *)&perspective);
    Select(ID_windowCoords,   (void *)windowCoords, 4);
    Select(ID_viewportCoords, (void *)viewportCoords, 4);
    Select(ID_eyeAngle,       (void *)&eyeAngle);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ViewAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ViewAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    ViewAttributes defaultObject;
    bool addToParent = false;
    // Create a node for ViewAttributes.
    DataNode *node = new DataNode("ViewAttributes");

    if(completeSave || !FieldsEqual(ID_viewNormal, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("viewNormal", viewNormal, 3));
    }

    if(completeSave || !FieldsEqual(ID_focus, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("focus", focus, 3));
    }

    if(completeSave || !FieldsEqual(ID_viewUp, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("viewUp", viewUp, 3));
    }

    if(completeSave || !FieldsEqual(ID_viewAngle, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("viewAngle", viewAngle));
    }

    if(completeSave || !FieldsEqual(ID_setScale, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("setScale", setScale));
    }

    if(completeSave || !FieldsEqual(ID_parallelScale, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("parallelScale", parallelScale));
    }

    if(completeSave || !FieldsEqual(ID_nearPlane, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("nearPlane", nearPlane));
    }

    if(completeSave || !FieldsEqual(ID_farPlane, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("farPlane", farPlane));
    }

    if(completeSave || !FieldsEqual(ID_imagePan, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("imagePan", imagePan, 2));
    }

    if(completeSave || !FieldsEqual(ID_imageZoom, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("imageZoom", imageZoom));
    }

    if(completeSave || !FieldsEqual(ID_perspective, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("perspective", perspective));
    }

    if(completeSave || !FieldsEqual(ID_windowCoords, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("windowCoords", windowCoords, 4));
    }

    if(completeSave || !FieldsEqual(ID_viewportCoords, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("viewportCoords", viewportCoords, 4));
    }

    if(completeSave || !FieldsEqual(ID_eyeAngle, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("eyeAngle", eyeAngle));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: ViewAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
ViewAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("ViewAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("viewNormal")) != 0)
        SetViewNormal(node->AsDoubleArray());
    if((node = searchNode->GetNode("focus")) != 0)
        SetFocus(node->AsDoubleArray());
    if((node = searchNode->GetNode("viewUp")) != 0)
        SetViewUp(node->AsDoubleArray());
    if((node = searchNode->GetNode("viewAngle")) != 0)
        SetViewAngle(node->AsDouble());
    if((node = searchNode->GetNode("setScale")) != 0)
        SetSetScale(node->AsBool());
    if((node = searchNode->GetNode("parallelScale")) != 0)
        SetParallelScale(node->AsDouble());
    if((node = searchNode->GetNode("nearPlane")) != 0)
        SetNearPlane(node->AsDouble());
    if((node = searchNode->GetNode("farPlane")) != 0)
        SetFarPlane(node->AsDouble());
    if((node = searchNode->GetNode("imagePan")) != 0)
        SetImagePan(node->AsDoubleArray());
    if((node = searchNode->GetNode("imageZoom")) != 0)
        SetImageZoom(node->AsDouble());
    if((node = searchNode->GetNode("perspective")) != 0)
        SetPerspective(node->AsBool());
    if((node = searchNode->GetNode("windowCoords")) != 0)
        SetWindowCoords(node->AsDoubleArray());
    if((node = searchNode->GetNode("viewportCoords")) != 0)
        SetViewportCoords(node->AsDoubleArray());
    if((node = searchNode->GetNode("eyeAngle")) != 0)
        SetEyeAngle(node->AsDouble());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
ViewAttributes::SetViewNormal(const double *viewNormal_)
{
    viewNormal[0] = viewNormal_[0];
    viewNormal[1] = viewNormal_[1];
    viewNormal[2] = viewNormal_[2];
    Select(ID_viewNormal, (void *)viewNormal, 3);
}

void
ViewAttributes::SetFocus(const double *focus_)
{
    focus[0] = focus_[0];
    focus[1] = focus_[1];
    focus[2] = focus_[2];
    Select(ID_focus, (void *)focus, 3);
}

void
ViewAttributes::SetViewUp(const double *viewUp_)
{
    viewUp[0] = viewUp_[0];
    viewUp[1] = viewUp_[1];
    viewUp[2] = viewUp_[2];
    Select(ID_viewUp, (void *)viewUp, 3);
}

void
ViewAttributes::SetViewAngle(double viewAngle_)
{
    viewAngle = viewAngle_;
    Select(ID_viewAngle, (void *)&viewAngle);
}

void
ViewAttributes::SetSetScale(bool setScale_)
{
    setScale = setScale_;
    Select(ID_setScale, (void *)&setScale);
}

void
ViewAttributes::SetParallelScale(double parallelScale_)
{
    parallelScale = parallelScale_;
    Select(ID_parallelScale, (void *)&parallelScale);
}

void
ViewAttributes::SetNearPlane(double nearPlane_)
{
    nearPlane = nearPlane_;
    Select(ID_nearPlane, (void *)&nearPlane);
}

void
ViewAttributes::SetFarPlane(double farPlane_)
{
    farPlane = farPlane_;
    Select(ID_farPlane, (void *)&farPlane);
}

void
ViewAttributes::SetImagePan(const double *imagePan_)
{
    imagePan[0] = imagePan_[0];
    imagePan[1] = imagePan_[1];
    Select(ID_imagePan, (void *)imagePan, 2);
}

void
ViewAttributes::SetImageZoom(double imageZoom_)
{
    imageZoom = imageZoom_;
    Select(ID_imageZoom, (void *)&imageZoom);
}

void
ViewAttributes::SetPerspective(bool perspective_)
{
    perspective = perspective_;
    Select(ID_perspective, (void *)&perspective);
}

void
ViewAttributes::SetWindowCoords(const double *windowCoords_)
{
    windowCoords[0] = windowCoords_[0];
    windowCoords[1] = windowCoords_[1];
    windowCoords[2] = windowCoords_[2];
    windowCoords[3] = windowCoords_[3];
    Select(ID_windowCoords, (void *)windowCoords, 4);
}

void
ViewAttributes::SetViewportCoords(const double *viewportCoords_)
{
    viewportCoords[0] = viewportCoords_[0];
    viewportCoords[1] = viewportCoords_[1];
    viewportCoords[2] = viewportCoords_[2];
    viewportCoords[3] = viewportCoords_[3];
    Select(ID_viewportCoords, (void *)viewportCoords, 4);
}

void
ViewAttributes::SetEyeAngle(double eyeAngle_)
{
    eyeAngle = eyeAngle_;
    Select(ID_eyeAngle, (void *)&eyeAngle);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const double *
ViewAttributes::GetViewNormal() const
{
    return viewNormal;
}

double *
ViewAttributes::GetViewNormal()
{
    return viewNormal;
}

const double *
ViewAttributes::GetFocus() const
{
    return focus;
}

double *
ViewAttributes::GetFocus()
{
    return focus;
}

const double *
ViewAttributes::GetViewUp() const
{
    return viewUp;
}

double *
ViewAttributes::GetViewUp()
{
    return viewUp;
}

double
ViewAttributes::GetViewAngle() const
{
    return viewAngle;
}

bool
ViewAttributes::GetSetScale() const
{
    return setScale;
}

double
ViewAttributes::GetParallelScale() const
{
    return parallelScale;
}

double
ViewAttributes::GetNearPlane() const
{
    return nearPlane;
}

double
ViewAttributes::GetFarPlane() const
{
    return farPlane;
}

const double *
ViewAttributes::GetImagePan() const
{
    return imagePan;
}

double *
ViewAttributes::GetImagePan()
{
    return imagePan;
}

double
ViewAttributes::GetImageZoom() const
{
    return imageZoom;
}

bool
ViewAttributes::GetPerspective() const
{
    return perspective;
}

const double *
ViewAttributes::GetWindowCoords() const
{
    return windowCoords;
}

double *
ViewAttributes::GetWindowCoords()
{
    return windowCoords;
}

const double *
ViewAttributes::GetViewportCoords() const
{
    return viewportCoords;
}

double *
ViewAttributes::GetViewportCoords()
{
    return viewportCoords;
}

double
ViewAttributes::GetEyeAngle() const
{
    return eyeAngle;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
ViewAttributes::SelectViewNormal()
{
    Select(ID_viewNormal, (void *)viewNormal, 3);
}

void
ViewAttributes::SelectFocus()
{
    Select(ID_focus, (void *)focus, 3);
}

void
ViewAttributes::SelectViewUp()
{
    Select(ID_viewUp, (void *)viewUp, 3);
}

void
ViewAttributes::SelectImagePan()
{
    Select(ID_imagePan, (void *)imagePan, 2);
}

void
ViewAttributes::SelectWindowCoords()
{
    Select(ID_windowCoords, (void *)windowCoords, 4);
}

void
ViewAttributes::SelectViewportCoords()
{
    Select(ID_viewportCoords, (void *)viewportCoords, 4);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: ViewAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
ViewAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_viewNormal:     return "viewNormal";
    case ID_focus:          return "focus";
    case ID_viewUp:         return "viewUp";
    case ID_viewAngle:      return "viewAngle";
    case ID_setScale:       return "setScale";
    case ID_parallelScale:  return "parallelScale";
    case ID_nearPlane:      return "nearPlane";
    case ID_farPlane:       return "farPlane";
    case ID_imagePan:       return "imagePan";
    case ID_imageZoom:      return "imageZoom";
    case ID_perspective:    return "perspective";
    case ID_windowCoords:   return "windowCoords";
    case ID_viewportCoords: return "viewportCoords";
    case ID_eyeAngle:       return "eyeAngle";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ViewAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
ViewAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_viewNormal:     return FieldType_doubleArray;
    case ID_focus:          return FieldType_doubleArray;
    case ID_viewUp:         return FieldType_doubleArray;
    case ID_viewAngle:      return FieldType_double;
    case ID_setScale:       return FieldType_bool;
    case ID_parallelScale:  return FieldType_double;
    case ID_nearPlane:      return FieldType_double;
    case ID_farPlane:       return FieldType_double;
    case ID_imagePan:       return FieldType_doubleArray;
    case ID_imageZoom:      return FieldType_double;
    case ID_perspective:    return FieldType_bool;
    case ID_windowCoords:   return FieldType_doubleArray;
    case ID_viewportCoords: return FieldType_doubleArray;
    case ID_eyeAngle:       return FieldType_double;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: ViewAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
ViewAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_viewNormal:     return "doubleArray";
    case ID_focus:          return "doubleArray";
    case ID_viewUp:         return "doubleArray";
    case ID_viewAngle:      return "double";
    case ID_setScale:       return "bool";
    case ID_parallelScale:  return "double";
    case ID_nearPlane:      return "double";
    case ID_farPlane:       return "double";
    case ID_imagePan:       return "doubleArray";
    case ID_imageZoom:      return "double";
    case ID_perspective:    return "bool";
    case ID_windowCoords:   return "doubleArray";
    case ID_viewportCoords: return "doubleArray";
    case ID_eyeAngle:       return "double";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: ViewAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
ViewAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const ViewAttributes &obj = *((const ViewAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_viewNormal:
        {  // new scope
        // Compare the viewNormal arrays.
        bool viewNormal_equal = true;
        for(int i = 0; i < 3 && viewNormal_equal; ++i)
            viewNormal_equal = (viewNormal[i] == obj.viewNormal[i]);

        retval = viewNormal_equal;
        }
        break;
    case ID_focus:
        {  // new scope
        // Compare the focus arrays.
        bool focus_equal = true;
        for(int i = 0; i < 3 && focus_equal; ++i)
            focus_equal = (focus[i] == obj.focus[i]);

        retval = focus_equal;
        }
        break;
    case ID_viewUp:
        {  // new scope
        // Compare the viewUp arrays.
        bool viewUp_equal = true;
        for(int i = 0; i < 3 && viewUp_equal; ++i)
            viewUp_equal = (viewUp[i] == obj.viewUp[i]);

        retval = viewUp_equal;
        }
        break;
    case ID_viewAngle:
        {  // new scope
        retval = (viewAngle == obj.viewAngle);
        }
        break;
    case ID_setScale:
        {  // new scope
        retval = (setScale == obj.setScale);
        }
        break;
    case ID_parallelScale:
        {  // new scope
        retval = (parallelScale == obj.parallelScale);
        }
        break;
    case ID_nearPlane:
        {  // new scope
        retval = (nearPlane == obj.nearPlane);
        }
        break;
    case ID_farPlane:
        {  // new scope
        retval = (farPlane == obj.farPlane);
        }
        break;
    case ID_imagePan:
        {  // new scope
        // Compare the imagePan arrays.
        bool imagePan_equal = true;
        for(int i = 0; i < 2 && imagePan_equal; ++i)
            imagePan_equal = (imagePan[i] == obj.imagePan[i]);

        retval = imagePan_equal;
        }
        break;
    case ID_imageZoom:
        {  // new scope
        retval = (imageZoom == obj.imageZoom);
        }
        break;
    case ID_perspective:
        {  // new scope
        retval = (perspective == obj.perspective);
        }
        break;
    case ID_windowCoords:
        {  // new scope
        // Compare the windowCoords arrays.
        bool windowCoords_equal = true;
        for(int i = 0; i < 4 && windowCoords_equal; ++i)
            windowCoords_equal = (windowCoords[i] == obj.windowCoords[i]);

        retval = windowCoords_equal;
        }
        break;
    case ID_viewportCoords:
        {  // new scope
        // Compare the viewportCoords arrays.
        bool viewportCoords_equal = true;
        for(int i = 0; i < 4 && viewportCoords_equal; ++i)
            viewportCoords_equal = (viewportCoords[i] == obj.viewportCoords[i]);

        retval = viewportCoords_equal;
        }
        break;
    case ID_eyeAngle:
        {  // new scope
        retval = (eyeAngle == obj.eyeAngle);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

