/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyView3DAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PyView3DAttributes
//
// Purpose: 
//   This class contains the 3d view attributes.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a View3DAttributes.
//
struct View3DAttributesObject
{
    PyObject_HEAD
    View3DAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewView3DAttributes(int);

std::string
PyView3DAttributes_ToString(const View3DAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    {   const double *viewNormal = atts->GetViewNormal();
        SNPRINTF(tmpStr, 1000, "%sviewNormal = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", viewNormal[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const double *focus = atts->GetFocus();
        SNPRINTF(tmpStr, 1000, "%sfocus = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", focus[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const double *viewUp = atts->GetViewUp();
        SNPRINTF(tmpStr, 1000, "%sviewUp = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", viewUp[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    SNPRINTF(tmpStr, 1000, "%sviewAngle = %g\n", prefix, atts->GetViewAngle());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sparallelScale = %g\n", prefix, atts->GetParallelScale());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%snearPlane = %g\n", prefix, atts->GetNearPlane());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sfarPlane = %g\n", prefix, atts->GetFarPlane());
    str += tmpStr;
    {   const double *imagePan = atts->GetImagePan();
        SNPRINTF(tmpStr, 1000, "%simagePan = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 2; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", imagePan[i]);
            str += tmpStr;
            if(i < 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    SNPRINTF(tmpStr, 1000, "%simageZoom = %g\n", prefix, atts->GetImageZoom());
    str += tmpStr;
    if(atts->GetPerspective())
        SNPRINTF(tmpStr, 1000, "%sperspective = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sperspective = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%seyeAngle = %g\n", prefix, atts->GetEyeAngle());
    str += tmpStr;
    if(atts->GetCenterOfRotationSet())
        SNPRINTF(tmpStr, 1000, "%scenterOfRotationSet = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%scenterOfRotationSet = 0\n", prefix);
    str += tmpStr;
    {   const double *centerOfRotation = atts->GetCenterOfRotation();
        SNPRINTF(tmpStr, 1000, "%scenterOfRotation = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", centerOfRotation[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    if(atts->GetAxis3DScaleFlag())
        SNPRINTF(tmpStr, 1000, "%saxis3DScaleFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%saxis3DScaleFlag = 0\n", prefix);
    str += tmpStr;
    {   const double *axis3DScales = atts->GetAxis3DScales();
        SNPRINTF(tmpStr, 1000, "%saxis3DScales = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", axis3DScales[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const double *shear = atts->GetShear();
        SNPRINTF(tmpStr, 1000, "%sshear = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            SNPRINTF(tmpStr, 1000, "%g", shear[i]);
            str += tmpStr;
            if(i < 2)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    if(atts->GetWindowValid())
        SNPRINTF(tmpStr, 1000, "%swindowValid = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%swindowValid = 0\n", prefix);
    str += tmpStr;
    return str;
}

static PyObject *
View3DAttributes_Notify(PyObject *self, PyObject *args)
{
    View3DAttributesObject *obj = (View3DAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
View3DAttributes_SetViewNormal(PyObject *self, PyObject *args)
{
    View3DAttributesObject *obj = (View3DAttributesObject *)self;

    double *dvals = obj->data->GetViewNormal();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the viewNormal in the object as modified.
    obj->data->SelectViewNormal();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
View3DAttributes_GetViewNormal(PyObject *self, PyObject *args)
{
    View3DAttributesObject *obj = (View3DAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the viewNormal.
    PyObject *retval = PyTuple_New(3);
    const double *viewNormal = obj->data->GetViewNormal();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(viewNormal[i]));
    return retval;
}

/*static*/ PyObject *
View3DAttributes_SetFocus(PyObject *self, PyObject *args)
{
    View3DAttributesObject *obj = (View3DAttributesObject *)self;

    double *dvals = obj->data->GetFocus();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the focus in the object as modified.
    obj->data->SelectFocus();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
View3DAttributes_GetFocus(PyObject *self, PyObject *args)
{
    View3DAttributesObject *obj = (View3DAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the focus.
    PyObject *retval = PyTuple_New(3);
    const double *focus = obj->data->GetFocus();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(focus[i]));
    return retval;
}

/*static*/ PyObject *
View3DAttributes_SetViewUp(PyObject *self, PyObject *args)
{
    View3DAttributesObject *obj = (View3DAttributesObject *)self;

    double *dvals = obj->data->GetViewUp();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the viewUp in the object as modified.
    obj->data->SelectViewUp();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
View3DAttributes_GetViewUp(PyObject *self, PyObject *args)
{
    View3DAttributesObject *obj = (View3DAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the viewUp.
    PyObject *retval = PyTuple_New(3);
    const double *viewUp = obj->data->GetViewUp();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(viewUp[i]));
    return retval;
}

/*static*/ PyObject *
View3DAttributes_SetViewAngle(PyObject *self, PyObject *args)
{
    View3DAttributesObject *obj = (View3DAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the viewAngle in the object.
    obj->data->SetViewAngle(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
View3DAttributes_GetViewAngle(PyObject *self, PyObject *args)
{
    View3DAttributesObject *obj = (View3DAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetViewAngle());
    return retval;
}

/*static*/ PyObject *
View3DAttributes_SetParallelScale(PyObject *self, PyObject *args)
{
    View3DAttributesObject *obj = (View3DAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the parallelScale in the object.
    obj->data->SetParallelScale(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
View3DAttributes_GetParallelScale(PyObject *self, PyObject *args)
{
    View3DAttributesObject *obj = (View3DAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetParallelScale());
    return retval;
}

/*static*/ PyObject *
View3DAttributes_SetNearPlane(PyObject *self, PyObject *args)
{
    View3DAttributesObject *obj = (View3DAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the nearPlane in the object.
    obj->data->SetNearPlane(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
View3DAttributes_GetNearPlane(PyObject *self, PyObject *args)
{
    View3DAttributesObject *obj = (View3DAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetNearPlane());
    return retval;
}

/*static*/ PyObject *
View3DAttributes_SetFarPlane(PyObject *self, PyObject *args)
{
    View3DAttributesObject *obj = (View3DAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the farPlane in the object.
    obj->data->SetFarPlane(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
View3DAttributes_GetFarPlane(PyObject *self, PyObject *args)
{
    View3DAttributesObject *obj = (View3DAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetFarPlane());
    return retval;
}

/*static*/ PyObject *
View3DAttributes_SetImagePan(PyObject *self, PyObject *args)
{
    View3DAttributesObject *obj = (View3DAttributesObject *)self;

    double *dvals = obj->data->GetImagePan();
    if(!PyArg_ParseTuple(args, "dd", &dvals[0], &dvals[1]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 2)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the imagePan in the object as modified.
    obj->data->SelectImagePan();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
View3DAttributes_GetImagePan(PyObject *self, PyObject *args)
{
    View3DAttributesObject *obj = (View3DAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the imagePan.
    PyObject *retval = PyTuple_New(2);
    const double *imagePan = obj->data->GetImagePan();
    for(int i = 0; i < 2; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(imagePan[i]));
    return retval;
}

/*static*/ PyObject *
View3DAttributes_SetImageZoom(PyObject *self, PyObject *args)
{
    View3DAttributesObject *obj = (View3DAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the imageZoom in the object.
    obj->data->SetImageZoom(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
View3DAttributes_GetImageZoom(PyObject *self, PyObject *args)
{
    View3DAttributesObject *obj = (View3DAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetImageZoom());
    return retval;
}

/*static*/ PyObject *
View3DAttributes_SetPerspective(PyObject *self, PyObject *args)
{
    View3DAttributesObject *obj = (View3DAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the perspective in the object.
    obj->data->SetPerspective(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
View3DAttributes_GetPerspective(PyObject *self, PyObject *args)
{
    View3DAttributesObject *obj = (View3DAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetPerspective()?1L:0L);
    return retval;
}

/*static*/ PyObject *
View3DAttributes_SetEyeAngle(PyObject *self, PyObject *args)
{
    View3DAttributesObject *obj = (View3DAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the eyeAngle in the object.
    obj->data->SetEyeAngle(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
View3DAttributes_GetEyeAngle(PyObject *self, PyObject *args)
{
    View3DAttributesObject *obj = (View3DAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetEyeAngle());
    return retval;
}

/*static*/ PyObject *
View3DAttributes_SetCenterOfRotationSet(PyObject *self, PyObject *args)
{
    View3DAttributesObject *obj = (View3DAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the centerOfRotationSet in the object.
    obj->data->SetCenterOfRotationSet(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
View3DAttributes_GetCenterOfRotationSet(PyObject *self, PyObject *args)
{
    View3DAttributesObject *obj = (View3DAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetCenterOfRotationSet()?1L:0L);
    return retval;
}

/*static*/ PyObject *
View3DAttributes_SetCenterOfRotation(PyObject *self, PyObject *args)
{
    View3DAttributesObject *obj = (View3DAttributesObject *)self;

    double *dvals = obj->data->GetCenterOfRotation();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the centerOfRotation in the object as modified.
    obj->data->SelectCenterOfRotation();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
View3DAttributes_GetCenterOfRotation(PyObject *self, PyObject *args)
{
    View3DAttributesObject *obj = (View3DAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the centerOfRotation.
    PyObject *retval = PyTuple_New(3);
    const double *centerOfRotation = obj->data->GetCenterOfRotation();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(centerOfRotation[i]));
    return retval;
}

/*static*/ PyObject *
View3DAttributes_SetAxis3DScaleFlag(PyObject *self, PyObject *args)
{
    View3DAttributesObject *obj = (View3DAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the axis3DScaleFlag in the object.
    obj->data->SetAxis3DScaleFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
View3DAttributes_GetAxis3DScaleFlag(PyObject *self, PyObject *args)
{
    View3DAttributesObject *obj = (View3DAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetAxis3DScaleFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
View3DAttributes_SetAxis3DScales(PyObject *self, PyObject *args)
{
    View3DAttributesObject *obj = (View3DAttributesObject *)self;

    double *dvals = obj->data->GetAxis3DScales();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the axis3DScales in the object as modified.
    obj->data->SelectAxis3DScales();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
View3DAttributes_GetAxis3DScales(PyObject *self, PyObject *args)
{
    View3DAttributesObject *obj = (View3DAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the axis3DScales.
    PyObject *retval = PyTuple_New(3);
    const double *axis3DScales = obj->data->GetAxis3DScales();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(axis3DScales[i]));
    return retval;
}

/*static*/ PyObject *
View3DAttributes_SetShear(PyObject *self, PyObject *args)
{
    View3DAttributesObject *obj = (View3DAttributesObject *)self;

    double *dvals = obj->data->GetShear();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the shear in the object as modified.
    obj->data->SelectShear();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
View3DAttributes_GetShear(PyObject *self, PyObject *args)
{
    View3DAttributesObject *obj = (View3DAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the shear.
    PyObject *retval = PyTuple_New(3);
    const double *shear = obj->data->GetShear();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(shear[i]));
    return retval;
}

/*static*/ PyObject *
View3DAttributes_SetWindowValid(PyObject *self, PyObject *args)
{
    View3DAttributesObject *obj = (View3DAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the windowValid in the object.
    obj->data->SetWindowValid(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
View3DAttributes_GetWindowValid(PyObject *self, PyObject *args)
{
    View3DAttributesObject *obj = (View3DAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetWindowValid()?1L:0L);
    return retval;
}


// ****************************************************************************
// Method: RotateAxis
//
// Purpose: Python method to define the 'user-defined' method RotateAxis for
// the python object so a use could do something like...
//
//    v = GetView3D()
//    v.RotateAxis(2,30.0)
//
// Programmer: Mark C. Miller
// Created:    May 15, 2008
//
// ****************************************************************************

/*static*/ PyObject *
View3DAttributes_RotateAxis(PyObject *self, PyObject *args)
{
//
// THIS METHOD IS CUSTOM CODED!!!!!!.
//
    View3DAttributesObject *obj = (View3DAttributesObject *)self;

    int ival;
    double dval;
    if(!PyArg_ParseTuple(args, "id", &ival, &dval))
        return NULL;

    // Call the C++ method to change the view.
    obj->data->RotateAxis(ival, dval);

    Py_INCREF(Py_None);
    return Py_None;
}


PyMethodDef PyView3DAttributes_methods[VIEW3DATTRIBUTES_NMETH] = {
    {"Notify", View3DAttributes_Notify, METH_VARARGS},
    {"SetViewNormal", View3DAttributes_SetViewNormal, METH_VARARGS},
    {"GetViewNormal", View3DAttributes_GetViewNormal, METH_VARARGS},
    {"SetFocus", View3DAttributes_SetFocus, METH_VARARGS},
    {"GetFocus", View3DAttributes_GetFocus, METH_VARARGS},
    {"SetViewUp", View3DAttributes_SetViewUp, METH_VARARGS},
    {"GetViewUp", View3DAttributes_GetViewUp, METH_VARARGS},
    {"SetViewAngle", View3DAttributes_SetViewAngle, METH_VARARGS},
    {"GetViewAngle", View3DAttributes_GetViewAngle, METH_VARARGS},
    {"SetParallelScale", View3DAttributes_SetParallelScale, METH_VARARGS},
    {"GetParallelScale", View3DAttributes_GetParallelScale, METH_VARARGS},
    {"SetNearPlane", View3DAttributes_SetNearPlane, METH_VARARGS},
    {"GetNearPlane", View3DAttributes_GetNearPlane, METH_VARARGS},
    {"SetFarPlane", View3DAttributes_SetFarPlane, METH_VARARGS},
    {"GetFarPlane", View3DAttributes_GetFarPlane, METH_VARARGS},
    {"SetImagePan", View3DAttributes_SetImagePan, METH_VARARGS},
    {"GetImagePan", View3DAttributes_GetImagePan, METH_VARARGS},
    {"SetImageZoom", View3DAttributes_SetImageZoom, METH_VARARGS},
    {"GetImageZoom", View3DAttributes_GetImageZoom, METH_VARARGS},
    {"SetPerspective", View3DAttributes_SetPerspective, METH_VARARGS},
    {"GetPerspective", View3DAttributes_GetPerspective, METH_VARARGS},
    {"SetEyeAngle", View3DAttributes_SetEyeAngle, METH_VARARGS},
    {"GetEyeAngle", View3DAttributes_GetEyeAngle, METH_VARARGS},
    {"SetCenterOfRotationSet", View3DAttributes_SetCenterOfRotationSet, METH_VARARGS},
    {"GetCenterOfRotationSet", View3DAttributes_GetCenterOfRotationSet, METH_VARARGS},
    {"SetCenterOfRotation", View3DAttributes_SetCenterOfRotation, METH_VARARGS},
    {"GetCenterOfRotation", View3DAttributes_GetCenterOfRotation, METH_VARARGS},
    {"SetAxis3DScaleFlag", View3DAttributes_SetAxis3DScaleFlag, METH_VARARGS},
    {"GetAxis3DScaleFlag", View3DAttributes_GetAxis3DScaleFlag, METH_VARARGS},
    {"SetAxis3DScales", View3DAttributes_SetAxis3DScales, METH_VARARGS},
    {"GetAxis3DScales", View3DAttributes_GetAxis3DScales, METH_VARARGS},
    {"SetShear", View3DAttributes_SetShear, METH_VARARGS},
    {"GetShear", View3DAttributes_GetShear, METH_VARARGS},
    {"SetWindowValid", View3DAttributes_SetWindowValid, METH_VARARGS},
    {"GetWindowValid", View3DAttributes_GetWindowValid, METH_VARARGS},
    {"RotateAxis", View3DAttributes_RotateAxis, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
View3DAttributes_dealloc(PyObject *v)
{
   View3DAttributesObject *obj = (View3DAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
View3DAttributes_compare(PyObject *v, PyObject *w)
{
    View3DAttributes *a = ((View3DAttributesObject *)v)->data;
    View3DAttributes *b = ((View3DAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyView3DAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "viewNormal") == 0)
        return View3DAttributes_GetViewNormal(self, NULL);
    if(strcmp(name, "focus") == 0)
        return View3DAttributes_GetFocus(self, NULL);
    if(strcmp(name, "viewUp") == 0)
        return View3DAttributes_GetViewUp(self, NULL);
    if(strcmp(name, "viewAngle") == 0)
        return View3DAttributes_GetViewAngle(self, NULL);
    if(strcmp(name, "parallelScale") == 0)
        return View3DAttributes_GetParallelScale(self, NULL);
    if(strcmp(name, "nearPlane") == 0)
        return View3DAttributes_GetNearPlane(self, NULL);
    if(strcmp(name, "farPlane") == 0)
        return View3DAttributes_GetFarPlane(self, NULL);
    if(strcmp(name, "imagePan") == 0)
        return View3DAttributes_GetImagePan(self, NULL);
    if(strcmp(name, "imageZoom") == 0)
        return View3DAttributes_GetImageZoom(self, NULL);
    if(strcmp(name, "perspective") == 0)
        return View3DAttributes_GetPerspective(self, NULL);
    if(strcmp(name, "eyeAngle") == 0)
        return View3DAttributes_GetEyeAngle(self, NULL);
    if(strcmp(name, "centerOfRotationSet") == 0)
        return View3DAttributes_GetCenterOfRotationSet(self, NULL);
    if(strcmp(name, "centerOfRotation") == 0)
        return View3DAttributes_GetCenterOfRotation(self, NULL);
    if(strcmp(name, "axis3DScaleFlag") == 0)
        return View3DAttributes_GetAxis3DScaleFlag(self, NULL);
    if(strcmp(name, "axis3DScales") == 0)
        return View3DAttributes_GetAxis3DScales(self, NULL);
    if(strcmp(name, "shear") == 0)
        return View3DAttributes_GetShear(self, NULL);
    if(strcmp(name, "windowValid") == 0)
        return View3DAttributes_GetWindowValid(self, NULL);

    return Py_FindMethod(PyView3DAttributes_methods, self, name);
}

int
PyView3DAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "viewNormal") == 0)
        obj = View3DAttributes_SetViewNormal(self, tuple);
    else if(strcmp(name, "focus") == 0)
        obj = View3DAttributes_SetFocus(self, tuple);
    else if(strcmp(name, "viewUp") == 0)
        obj = View3DAttributes_SetViewUp(self, tuple);
    else if(strcmp(name, "viewAngle") == 0)
        obj = View3DAttributes_SetViewAngle(self, tuple);
    else if(strcmp(name, "parallelScale") == 0)
        obj = View3DAttributes_SetParallelScale(self, tuple);
    else if(strcmp(name, "nearPlane") == 0)
        obj = View3DAttributes_SetNearPlane(self, tuple);
    else if(strcmp(name, "farPlane") == 0)
        obj = View3DAttributes_SetFarPlane(self, tuple);
    else if(strcmp(name, "imagePan") == 0)
        obj = View3DAttributes_SetImagePan(self, tuple);
    else if(strcmp(name, "imageZoom") == 0)
        obj = View3DAttributes_SetImageZoom(self, tuple);
    else if(strcmp(name, "perspective") == 0)
        obj = View3DAttributes_SetPerspective(self, tuple);
    else if(strcmp(name, "eyeAngle") == 0)
        obj = View3DAttributes_SetEyeAngle(self, tuple);
    else if(strcmp(name, "centerOfRotationSet") == 0)
        obj = View3DAttributes_SetCenterOfRotationSet(self, tuple);
    else if(strcmp(name, "centerOfRotation") == 0)
        obj = View3DAttributes_SetCenterOfRotation(self, tuple);
    else if(strcmp(name, "axis3DScaleFlag") == 0)
        obj = View3DAttributes_SetAxis3DScaleFlag(self, tuple);
    else if(strcmp(name, "axis3DScales") == 0)
        obj = View3DAttributes_SetAxis3DScales(self, tuple);
    else if(strcmp(name, "shear") == 0)
        obj = View3DAttributes_SetShear(self, tuple);
    else if(strcmp(name, "windowValid") == 0)
        obj = View3DAttributes_SetWindowValid(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
View3DAttributes_print(PyObject *v, FILE *fp, int flags)
{
    View3DAttributesObject *obj = (View3DAttributesObject *)v;
    fprintf(fp, "%s", PyView3DAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
View3DAttributes_str(PyObject *v)
{
    View3DAttributesObject *obj = (View3DAttributesObject *)v;
    return PyString_FromString(PyView3DAttributes_ToString(obj->data,"").c_str());
}

static PyObject *
View3DAttributes_add(PyObject *v, PyObject *w)
{
    bool arg1isObject = PyView3DAttributes_Check(v);
    bool arg2isObject = PyView3DAttributes_Check(w);
    if(!arg1isObject || !arg2isObject)
    {
        cerr << "View3DAttributes_add: One or more arguments are not View3DAttributes!" << endl;
        return NULL;
    }

    PyObject *retval = NewView3DAttributes(0);
    View3DAttributes *c = PyView3DAttributes_FromPyObject(retval);
    View3DAttributes *a = ((View3DAttributesObject *)v)->data;
    View3DAttributes *b = ((View3DAttributesObject *)w)->data;

    c->GetViewNormal()[0] = a->GetViewNormal()[0] + b->GetViewNormal()[0];
    c->GetViewNormal()[1] = a->GetViewNormal()[1] + b->GetViewNormal()[1];
    c->GetViewNormal()[2] = a->GetViewNormal()[2] + b->GetViewNormal()[2];

    c->GetFocus()[0] = a->GetFocus()[0] + b->GetFocus()[0];
    c->GetFocus()[1] = a->GetFocus()[1] + b->GetFocus()[1];
    c->GetFocus()[2] = a->GetFocus()[2] + b->GetFocus()[2];

    c->GetViewUp()[0] = a->GetViewUp()[0] + b->GetViewUp()[0];
    c->GetViewUp()[1] = a->GetViewUp()[1] + b->GetViewUp()[1];
    c->GetViewUp()[2] = a->GetViewUp()[2] + b->GetViewUp()[2];

    c->SetViewAngle(a->GetViewAngle() + b->GetViewAngle());
    c->SetParallelScale(a->GetParallelScale() + b->GetParallelScale());
    c->SetNearPlane(a->GetNearPlane() + b->GetNearPlane());
    c->SetFarPlane(a->GetFarPlane() + b->GetFarPlane());
    c->SetPerspective(a->GetPerspective() + b->GetPerspective());

    c->GetImagePan()[0] = a->GetImagePan()[0] + b->GetImagePan()[0];
    c->GetImagePan()[1] = a->GetImagePan()[1] + b->GetImagePan()[1];
    c->SetImageZoom(a->GetImageZoom() + b->GetImageZoom());

    c->SetEyeAngle(a->GetEyeAngle() + b->GetEyeAngle());

    c->SetCenterOfRotationSet(a->GetCenterOfRotationSet() +
                              b->GetCenterOfRotationSet());
    c->GetCenterOfRotation()[0] = a->GetCenterOfRotation()[0] +
                                  b->GetCenterOfRotation()[0];
    c->GetCenterOfRotation()[1] = a->GetCenterOfRotation()[1] +
                                  b->GetCenterOfRotation()[1];
    c->GetCenterOfRotation()[2] = a->GetCenterOfRotation()[2] +
                                  b->GetCenterOfRotation()[2];
    return retval;
}

static PyObject *
View3DAttributes_mul(PyObject *v, PyObject *w)
{
    PyObject *retval = NewView3DAttributes(0);
    View3DAttributes *c = PyView3DAttributes_FromPyObject(retval);

    View3DAttributes *a;
    double val = 1.;
    bool arg1isObject = PyView3DAttributes_Check(v);
    bool arg2isObject = PyView3DAttributes_Check(w);

    if(arg1isObject && arg2isObject)
    {
        return NULL;
    }
    else
    {
        PyObject *num;

        if(arg1isObject)
        {
            a = ((View3DAttributesObject *)v)->data;
            num = w;
        }
        else
        {
            a = ((View3DAttributesObject *)w)->data;
            num = v;
        }

        if(PyFloat_Check(num))
            val = PyFloat_AS_DOUBLE(num);
        else if(PyInt_Check(num))
            val = double(PyInt_AS_LONG(num));
        else if(PyLong_Check(num))
            val = PyLong_AsDouble(num);
        else
        {
            cerr << "MUL: Expected numeric argument is not a number!" << endl;
        }

        c->GetViewNormal()[0] = a->GetViewNormal()[0] * val;
        c->GetViewNormal()[1] = a->GetViewNormal()[1] * val;
        c->GetViewNormal()[2] = a->GetViewNormal()[2] * val;

        c->GetFocus()[0] = a->GetFocus()[0] * val;
        c->GetFocus()[1] = a->GetFocus()[1] * val;
        c->GetFocus()[2] = a->GetFocus()[2] * val;

        c->GetViewUp()[0] = a->GetViewUp()[0] * val;
        c->GetViewUp()[1] = a->GetViewUp()[1] * val;
        c->GetViewUp()[2] = a->GetViewUp()[2] * val;

        c->SetViewAngle(a->GetViewAngle() * val);
        c->SetParallelScale(a->GetParallelScale() * val);
        c->SetNearPlane(a->GetNearPlane() * val);
        c->SetFarPlane(a->GetFarPlane() * val);
        c->SetPerspective(a->GetPerspective() * val);

        c->GetImagePan()[0] = a->GetImagePan()[0] * val;
        c->GetImagePan()[1] = a->GetImagePan()[1] * val;
        c->SetImageZoom(a->GetImageZoom() * val);

        c->SetEyeAngle(a->GetEyeAngle() * val);

        c->SetCenterOfRotationSet(a->GetCenterOfRotationSet() * val);
        c->GetCenterOfRotation()[0] = a->GetCenterOfRotation()[0] * val;
        c->GetCenterOfRotation()[1] = a->GetCenterOfRotation()[1] * val;
        c->GetCenterOfRotation()[2] = a->GetCenterOfRotation()[2] * val;
    }

    return retval;
}

//
// The type description structure
//
static PyNumberMethods View3DAttributes_as_number = {
    (binaryfunc)View3DAttributes_add, /*nb_add*/
    (binaryfunc)0, /*nb_subtract*/
    (binaryfunc)View3DAttributes_mul, /*nb_multiply*/
    (binaryfunc)0, /*nb_divide*/
    (binaryfunc)0,    /*nb_remainder*/
    (binaryfunc)0,    /*nb_divmod*/
    (ternaryfunc)0,    /*nb_power*/
    (unaryfunc)0,    /*nb_negative*/
    (unaryfunc)0,    /*nb_positive*/
    (unaryfunc)0,    /*nb_absolute*/
    (inquiry)0,    /*nb_nonzero*/
    (unaryfunc)0,    /*nb_invert*/
    (binaryfunc)0,    /*nb_lshift*/
    (binaryfunc)0,    /*nb_rshift*/
    (binaryfunc)0,    /*nb_and*/
    (binaryfunc)0,    /*nb_xor*/
    (binaryfunc)0,    /*nb_or*/
    0,            /*nb_coerce*/
    (unaryfunc)0,    /*nb_int*/
    (unaryfunc)0,    /*nb_long*/
    (unaryfunc)0,    /*nb_float*/
    (unaryfunc)0,    /*nb_oct*/
    (unaryfunc)0,     /*nb_hex*/
    0,            /*nb_inplace_add*/
    0,            /*nb_inplace_subtract*/
    0,            /*nb_inplace_multiply*/
    0,            /*nb_inplace_divide*/
    0,            /*nb_inplace_remainder*/
    0,            /*nb_inplace_power*/
    0,            /*nb_inplace_lshift*/
    0,            /*nb_inplace_rshift*/
    0,            /*nb_inplace_and*/
    0,            /*nb_inplace_xor*/
    0,            /*nb_inplace_or*/
};

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *View3DAttributes_Purpose = "This class contains the 3d view attributes.";
#else
static char *View3DAttributes_Purpose = "This class contains the 3d view attributes.";
#endif

//
// The type description structure
//
static PyTypeObject View3DAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "View3DAttributes",                    // tp_name
    sizeof(View3DAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)View3DAttributes_dealloc,  // tp_dealloc
    (printfunc)View3DAttributes_print,     // tp_print
    (getattrfunc)PyView3DAttributes_getattr, // tp_getattr
    (setattrfunc)PyView3DAttributes_setattr, // tp_setattr
    (cmpfunc)View3DAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    &View3DAttributes_as_number,         // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)View3DAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    View3DAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static View3DAttributes *defaultAtts = 0;
static View3DAttributes *currentAtts = 0;

static PyObject *
NewView3DAttributes(int useCurrent)
{
    View3DAttributesObject *newObject;
    newObject = PyObject_NEW(View3DAttributesObject, &View3DAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new View3DAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new View3DAttributes(*defaultAtts);
    else
        newObject->data = new View3DAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapView3DAttributes(const View3DAttributes *attr)
{
    View3DAttributesObject *newObject;
    newObject = PyObject_NEW(View3DAttributesObject, &View3DAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (View3DAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
View3DAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewView3DAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef View3DAttributesMethods[] = {
    {"View3DAttributes", View3DAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *View3DAttributesObserver = 0;

std::string
PyView3DAttributes_GetLogString()
{
    std::string s("View3DAtts = View3DAttributes()\n");
    if(currentAtts != 0)
        s += PyView3DAttributes_ToString(currentAtts, "View3DAtts.");
    return s;
}

static void
PyView3DAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("View3DAtts = View3DAttributes()\n");
        s += PyView3DAttributes_ToString(currentAtts, "View3DAtts.");
        cb(s);
    }
}

void
PyView3DAttributes_StartUp(View3DAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyView3DAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(View3DAttributesObserver == 0)
    {
        View3DAttributesObserver = new ObserverToCallback(subj,
            PyView3DAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyView3DAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete View3DAttributesObserver;
    View3DAttributesObserver = 0;
}

PyMethodDef *
PyView3DAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return View3DAttributesMethods;
}

bool
PyView3DAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &View3DAttributesType);
}

View3DAttributes *
PyView3DAttributes_FromPyObject(PyObject *obj)
{
    View3DAttributesObject *obj2 = (View3DAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyView3DAttributes_New()
{
    return NewView3DAttributes(0);
}

PyObject *
PyView3DAttributes_Wrap(const View3DAttributes *attr)
{
    return WrapView3DAttributes(attr);
}

void
PyView3DAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    View3DAttributesObject *obj2 = (View3DAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyView3DAttributes_SetDefaults(const View3DAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new View3DAttributes(*atts);
}

