/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyImageObject.h>
#include <ObserverToCallback.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyImageObject
//
// Purpose: 
//   Image Annotation Object
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   Thu Sep 2 08:34:00 PDT 2004
//
// Modifications:
//
//   Hank Childs, Wed Jun 14 17:33:39 PDT 2006
//   Make sure UpdateAnnotationHelper is called every time a "Set" method is
//   called.
//
//   Jeremy Meredith, Thu Aug  7 15:10:29 EDT 2008
//   Use %lf's in printfs for doubles.
//
// ****************************************************************************

/* CUSTOM - Functions that we need in visitmodule.C */
extern void UpdateAnnotationHelper(AnnotationObject *);
extern bool DeleteAnnotationObjectHelper(AnnotationObject *);

//
// This struct contains the Python type information and a ImageObject.
//
struct ImageObjectObject
{
    PyObject_HEAD
    AnnotationObject *data;
    bool owns;
};

//
// Internal prototypes
//
static PyObject *NewImageObject();

static PyObject *
ImageObject_Notify(PyObject *self, PyObject *args)
{
    ImageObjectObject *obj = (ImageObjectObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ImageObject_SetVisible(PyObject *self, PyObject *args)
{
    ImageObjectObject *obj = (ImageObjectObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the visible in the object.
    obj->data->SetVisible(ival != 0);
/*CUSTOM*/
    UpdateAnnotationHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ImageObject_GetVisible(PyObject *self, PyObject *args)
{
    ImageObjectObject *obj = (ImageObjectObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetVisible()?1L:0L);
    return retval;
}

static PyObject *
ImageObject_SetActive(PyObject *self, PyObject *args)
{
    ImageObjectObject *obj = (ImageObjectObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the active in the object.
    obj->data->SetActive(ival != 0);
/*CUSTOM*/
    UpdateAnnotationHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ImageObject_GetActive(PyObject *self, PyObject *args)
{
    ImageObjectObject *obj = (ImageObjectObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetActive()?1L:0L);
    return retval;
}

static PyObject *
ImageObject_SetPosition(PyObject *self, PyObject *args)
{
    ImageObjectObject *obj = (ImageObjectObject *)self;

    double *dvals = obj->data->GetPosition();
/* CUSTOM - Had to make position dd, not ddd. */
    if(!PyArg_ParseTuple(args, "dd", &dvals[0], &dvals[1]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 2)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = (PyFloat_AS_DOUBLE(item));
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = (PyLong_AsDouble(item));
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the position in the object as modified.
    obj->data->SelectPosition();
/*CUSTOM*/
    UpdateAnnotationHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ImageObject_GetPosition(PyObject *self, PyObject *args)
{
    ImageObjectObject *obj = (ImageObjectObject *)self;
    // Allocate a tuple the with enough entries to hold the position.
    PyObject *retval = PyTuple_New(3);
    const double *position = obj->data->GetPosition();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(double(position[i])));
    return retval;
}

static PyObject *
ImageObject_SetTransparencyColor(PyObject *self, PyObject *args)
{
    ImageObjectObject *obj = (ImageObjectObject *)self;

    int c[4];
    if(!PyArg_ParseTuple(args, "iiii", &c[0], &c[1], &c[2], &c[3]))
    {
        c[3] = 255;
        if(!PyArg_ParseTuple(args, "iii", &c[0], &c[1], &c[2]))
        {
            double dr, dg, db, da;
            if(PyArg_ParseTuple(args, "dddd", &dr, &dg, &db, &da))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = int(da);
            }
            else if(PyArg_ParseTuple(args, "ddd", &dr, &dg, &db))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = 255;
            }
            else
            {
                PyObject *tuple = NULL;
                if(!PyArg_ParseTuple(args, "O", &tuple))
                    return NULL;

                if(!PyTuple_Check(tuple))
                    return NULL;

                // Make sure that the tuple is the right size.
                if(PyTuple_Size(tuple) < 3 || PyTuple_Size(tuple) > 4)
                    return NULL;

                // Make sure that all elements in the tuple are ints.
                for(int i = 0; i < PyTuple_Size(tuple); ++i)
                {
                    PyObject *item = PyTuple_GET_ITEM(tuple, i);
                    if(PyInt_Check(item))
                        c[i] = int(PyInt_AS_LONG(PyTuple_GET_ITEM(tuple, i)));
                    else if(PyFloat_Check(item))
                        c[i] = int(PyFloat_AS_DOUBLE(PyTuple_GET_ITEM(tuple, i)));
                    else
                        return NULL;
                }
            }
        }
        PyErr_Clear();
    }

    // Set the transparencyColor in the object.
    ColorAttribute ca(c[0], c[1], c[2], c[3]);
/* CUSTOM */
    obj->data->SetColor1(ca);
    //obj->data->SetTransparencyColor(ca);
/*CUSTOM*/
    UpdateAnnotationHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ImageObject_GetTransparencyColor(PyObject *self, PyObject *args)
{
    ImageObjectObject *obj = (ImageObjectObject *)self;
    // Allocate a tuple the with enough entries to hold the transparencyColor.
    PyObject *retval = PyTuple_New(4);
/* CUSTOM */
    const unsigned char *transparencyColor = obj->data->GetColor1().GetColor();
    //const unsigned char *transparencyColor = obj->data->GetTransparencyColor().GetColor();
    PyTuple_SET_ITEM(retval, 0, PyInt_FromLong(long(transparencyColor[0])));
    PyTuple_SET_ITEM(retval, 1, PyInt_FromLong(long(transparencyColor[1])));
    PyTuple_SET_ITEM(retval, 2, PyInt_FromLong(long(transparencyColor[2])));
    PyTuple_SET_ITEM(retval, 3, PyInt_FromLong(long(transparencyColor[3])));
    return retval;
}

static PyObject *
ImageObject_SetUseTransparencyColor(PyObject *self, PyObject *args)
{
    ImageObjectObject *obj = (ImageObjectObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the useTransparencyColor in the object.
/* CUSTOM */
    obj->data->SetIntAttribute1(ival != 0);
    //obj->data->SetUseTransparencyColor(ival != 0);
/*CUSTOM*/
    UpdateAnnotationHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ImageObject_GetUseTransparencyColor(PyObject *self, PyObject *args)
{
    ImageObjectObject *obj = (ImageObjectObject *)self;
/* CUSTOM */
    PyObject *retval = PyInt_FromLong(obj->data->GetIntAttribute1()?1L:0L);
    //PyObject *retval = PyInt_FromLong(obj->data->GetUseTransparencyColor()?1L:0L);
    return retval;
}

static PyObject *
ImageObject_SetWidth(PyObject *self, PyObject *args)
{
    ImageObjectObject *obj = (ImageObjectObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the width in the object.
/* CUSTOM */
    obj->data->GetPosition2()[0] = ival;
    if(obj->data->GetFontShadow())
        obj->data->GetPosition2()[1] = ival;
    //obj->data->SetWidth(ival);
/*CUSTOM*/
    UpdateAnnotationHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ImageObject_GetWidth(PyObject *self, PyObject *args)
{
    ImageObjectObject *obj = (ImageObjectObject *)self;
/* CUSTOM */
    PyObject *retval = PyInt_FromLong(long(obj->data->GetPosition2()[0]));
    //PyObject *retval = PyInt_FromLong(long(obj->data->GetWidth()));
    return retval;
}

static PyObject *
ImageObject_SetHeight(PyObject *self, PyObject *args)
{
    ImageObjectObject *obj = (ImageObjectObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the height in the object.
/* CUSTOM */
    obj->data->GetPosition2()[1] = ival;
    if(obj->data->GetFontShadow())
        obj->data->GetPosition2()[0] = ival;
    //obj->data->SetHeight(ival);
/*CUSTOM*/
    UpdateAnnotationHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ImageObject_GetHeight(PyObject *self, PyObject *args)
{
    ImageObjectObject *obj = (ImageObjectObject *)self;
/* CUSTOM */
    PyObject *retval = PyInt_FromLong(long(obj->data->GetPosition2()[1]));
    //PyObject *retval = PyInt_FromLong(long(obj->data->GetHeight()));
    return retval;
}

static PyObject *
ImageObject_SetMaintainAspectRatio(PyObject *self, PyObject *args)
{
    ImageObjectObject *obj = (ImageObjectObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the maintainAspectRatio in the object.
/* CUSTOM */
    obj->data->SetFontShadow(ival != 0);
    //obj->data->SetMaintainAspectRatio(ival != 0);
/*CUSTOM*/
    UpdateAnnotationHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ImageObject_GetMaintainAspectRatio(PyObject *self, PyObject *args)
{
    ImageObjectObject *obj = (ImageObjectObject *)self;
/* CUSTOM */
    PyObject *retval = PyInt_FromLong(obj->data->GetFontShadow()?1L:0L);
    //PyObject *retval = PyInt_FromLong(obj->data->GetMaintainAspectRatio()?1L:0L);
    return retval;
}

static PyObject *
ImageObject_SetImage(PyObject *self, PyObject *args)
{
/* CUSTOM - Taken from PyText2DObject.C */
    ImageObjectObject *obj = (ImageObjectObject *)self;

    stringVector  &vec = obj->data->GetText();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyString_Check(item))
                vec[i] = std::string(PyString_AS_STRING(item));
            else
                vec[i] = std::string("");
        }
    }
    else if(PyString_Check(tuple))
    {
        vec.resize(1);
        vec[0] = std::string(PyString_AS_STRING(tuple));
    }
    else
        return NULL;

    // Mark the text in the object as modified.
    obj->data->SelectText();
/*CUSTOM*/
    UpdateAnnotationHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *
ImageObject_GetImage(PyObject *self, PyObject *args)
{
/* CUSTOM - Taken from PyText2DObject.C */
    ImageObjectObject *obj = (ImageObjectObject *)self;
    // Allocate a tuple the with enough entries to hold the text.
    const stringVector &text = obj->data->GetText();
    PyObject *retval = PyTuple_New(text.size());
    for(size_t i = 0; i < text.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyString_FromString(text[i].c_str()));
    return retval;
}

/* CUSTOM - Added this... */
static PyObject *
ImageObject_Delete(PyObject *self, PyObject *args)
{
    ImageObjectObject *obj = (ImageObjectObject *)self;

    // Tell the VisIt module to decrement the reference count for the
    // AnnotationObject pointed to by obj->data. If there are no more
    // references, this object will own it.
    obj->owns = DeleteAnnotationObjectHelper(obj->data);

    Py_INCREF(Py_None);
    return Py_None;
}

static struct PyMethodDef ImageObject_methods[] = {
    {"Notify", ImageObject_Notify, METH_VARARGS},
    {"SetVisible", ImageObject_SetVisible, METH_VARARGS},
    {"GetVisible", ImageObject_GetVisible, METH_VARARGS},
    {"SetActive", ImageObject_SetActive, METH_VARARGS},
    {"GetActive", ImageObject_GetActive, METH_VARARGS},
    {"SetPosition", ImageObject_SetPosition, METH_VARARGS},
    {"GetPosition", ImageObject_GetPosition, METH_VARARGS},
    {"SetTransparencyColor", ImageObject_SetTransparencyColor, METH_VARARGS},
    {"GetTransparencyColor", ImageObject_GetTransparencyColor, METH_VARARGS},
    {"SetUseTransparencyColor", ImageObject_SetUseTransparencyColor, METH_VARARGS},
    {"GetUseTransparencyColor", ImageObject_GetUseTransparencyColor, METH_VARARGS},
    {"SetWidth", ImageObject_SetWidth, METH_VARARGS},
    {"GetWidth", ImageObject_GetWidth, METH_VARARGS},
    {"SetHeight", ImageObject_SetHeight, METH_VARARGS},
    {"GetHeight", ImageObject_GetHeight, METH_VARARGS},
    {"SetMaintainAspectRatio", ImageObject_SetMaintainAspectRatio, METH_VARARGS},
    {"GetMaintainAspectRatio", ImageObject_GetMaintainAspectRatio, METH_VARARGS},
    {"SetImage", ImageObject_SetImage, METH_VARARGS},
    {"GetImage", ImageObject_GetImage, METH_VARARGS},
/* CUSTOM - Added this... */
    {"Delete", ImageObject_Delete, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
ImageObject_dealloc(PyObject *v)
{
   ImageObjectObject *obj = (ImageObjectObject *)v;
   if(obj->owns)
       delete obj->data;
}

static int
ImageObject_compare(PyObject *v, PyObject *w)
{
    AnnotationObject *a = ((ImageObjectObject *)v)->data;
    AnnotationObject *b = ((ImageObjectObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

static PyObject *
ImageObject_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "visible") == 0)
        return ImageObject_GetVisible(self, NULL);
    if(strcmp(name, "active") == 0)
        return ImageObject_GetActive(self, NULL);
    if(strcmp(name, "position") == 0)
        return ImageObject_GetPosition(self, NULL);
    if(strcmp(name, "transparencyColor") == 0)
        return ImageObject_GetTransparencyColor(self, NULL);
    if(strcmp(name, "useTransparencyColor") == 0)
        return ImageObject_GetUseTransparencyColor(self, NULL);
    if(strcmp(name, "width") == 0)
        return ImageObject_GetWidth(self, NULL);
    if(strcmp(name, "height") == 0)
        return ImageObject_GetHeight(self, NULL);
    if(strcmp(name, "maintainAspectRatio") == 0)
        return ImageObject_GetMaintainAspectRatio(self, NULL);
    if(strcmp(name, "image") == 0)
        return ImageObject_GetImage(self, NULL);

    return Py_FindMethod(ImageObject_methods, self, name);
}

static int
ImageObject_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    bool retval = false;

    if(strcmp(name, "visible") == 0)
        retval = (ImageObject_SetVisible(self, tuple) != NULL);
    else if(strcmp(name, "active") == 0)
        retval = (ImageObject_SetActive(self, tuple) != NULL);
    else if(strcmp(name, "position") == 0)
        retval = (ImageObject_SetPosition(self, tuple) != NULL);
    else if(strcmp(name, "transparencyColor") == 0)
        retval = (ImageObject_SetTransparencyColor(self, tuple) != NULL);
    else if(strcmp(name, "useTransparencyColor") == 0)
        retval = (ImageObject_SetUseTransparencyColor(self, tuple) != NULL);
    else if(strcmp(name, "width") == 0)
        retval = (ImageObject_SetWidth(self, tuple) != NULL);
    else if(strcmp(name, "height") == 0)
        retval = (ImageObject_SetHeight(self, tuple) != NULL);
    else if(strcmp(name, "maintainAspectRatio") == 0)
        retval = (ImageObject_SetMaintainAspectRatio(self, tuple) != NULL);
    else if(strcmp(name, "image") == 0)
        retval = (ImageObject_SetImage(self, tuple) != NULL);

    Py_DECREF(tuple);
    return retval ? 0 : -1;
}

static int
ImageObject_print(PyObject *v, FILE *fp, int flags)
{
    ImageObjectObject *obj = (ImageObjectObject *)v;

    if(obj->data->GetVisible())
        fprintf(fp, "visible = 1\n");
    else
        fprintf(fp, "visible = 0\n");
    if(obj->data->GetActive())
        fprintf(fp, "active = 1\n");
    else
        fprintf(fp, "active = 0\n");
    {   const double *position = obj->data->GetPosition();
        fprintf(fp, "position = (%g, %g)\n", position[0], position[1]);
    }

/* CUSTOM - Made various changes to where things are. */
    const unsigned char *transparencyColor = obj->data->GetColor1().GetColor();
    fprintf(fp, "transparencyColor = (%d, %d, %d, %d)\n", int(transparencyColor[0]), int(transparencyColor[1]), int(transparencyColor[2]), int(transparencyColor[3]));
    if(obj->data->GetIntAttribute1())
        fprintf(fp, "useTransparencyColor = 1\n");
    else
        fprintf(fp, "useTransparencyColor = 0\n");
    fprintf(fp, "width = %lf\n", obj->data->GetPosition2()[0]);
    fprintf(fp, "height = %lf\n", obj->data->GetPosition2()[1]);
    if(obj->data->GetFontShadow())
        fprintf(fp, "maintainAspectRatio = 1\n");
    else
        fprintf(fp, "maintainAspectRatio = 0\n");
    {   const stringVector &image = obj->data->GetText();
        fprintf(fp, "image = (");
        for(size_t i = 0; i < image.size(); ++i)
        {
            fprintf(fp, "\"%s\"", image[i].c_str());
            if(i < image.size() - 1)
                fprintf(fp, ", ");
        }
        fprintf(fp, ")\n");
    }

    return 0;
}

#include <snprintf.h>
PyObject *
PyImageObject_StringRepresentation(const AnnotationObject *atts)
{
    std::string str; 
    char tmpStr[1000]; 

    if(atts->GetVisible())
        SNPRINTF(tmpStr, 1000, "visible = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "visible = 0\n");
    str += tmpStr;
    if(atts->GetActive())
        SNPRINTF(tmpStr, 1000, "active = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "active = 0\n");
    str += tmpStr;
    {   const double *position = atts->GetPosition();
        SNPRINTF(tmpStr, 1000, "position = (%g, %g)\n", position[0], position[1]);
        str += tmpStr;
    }

/* CUSTOM - Made various changes to where things are. */
    const unsigned char *transparencyColor = atts->GetColor1().GetColor();
    SNPRINTF(tmpStr, 1000, "transparencyColor = (%d, %d, %d, %d)\n", int(transparencyColor[0]), int(transparencyColor[1]), int(transparencyColor[2]), int(transparencyColor[3]));
    str += tmpStr;
    if(atts->GetIntAttribute1())
        SNPRINTF(tmpStr, 1000, "useTransparencyColor = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "useTransparencyColor = 0\n");
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "width = %lf\n", atts->GetPosition2()[0]);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "height = %lf\n", atts->GetPosition2()[1]);
    str += tmpStr;
    if(atts->GetFontShadow())
        SNPRINTF(tmpStr, 1000, "maintainAspectRatio = 1\n");
    else
        SNPRINTF(tmpStr, 1000, "maintainAspectRatio = 0\n");
    str += tmpStr;
    {   const stringVector &image = atts->GetText();
        SNPRINTF(tmpStr, 1000, "image = (");
        str += tmpStr;
        for(size_t i = 0; i < image.size(); ++i)
        {
            SNPRINTF(tmpStr, 1000, "\"%s\"", image[i].c_str());
            str += tmpStr;
            if(i < image.size() - 1)
            {
                SNPRINTF(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        SNPRINTF(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    return PyString_FromString(str.c_str());
}

static PyObject *
ImageObject_str(PyObject *v)
{
    ImageObjectObject *obj = (ImageObjectObject *)v;
    return PyImageObject_StringRepresentation(obj->data);
}


//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *ImageObject_Purpose = "Image Annotation Object";
#else
static char *ImageObject_Purpose = "Image Annotation Object";
#endif

//
// The type description structure
//
static PyTypeObject ImageObjectType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "ImageObject",                    // tp_name
    sizeof(ImageObjectObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)ImageObject_dealloc,  // tp_dealloc
    (printfunc)ImageObject_print,     // tp_print
    (getattrfunc)ImageObject_getattr, // tp_getattr
    (setattrfunc)ImageObject_setattr, // tp_setattr
    (cmpfunc)ImageObject_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)ImageObject_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    ImageObject_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static AnnotationObject *defaultAtts = 0;

static PyObject *
NewImageObject()
{
    ImageObjectObject *newObject;
    newObject = PyObject_NEW(ImageObjectObject, &ImageObjectType);
    if(newObject == NULL)
        return NULL;
    if(defaultAtts)
        newObject->data = new AnnotationObject(*defaultAtts);
    else
        newObject->data = new AnnotationObject;
    newObject->owns = true;
    return (PyObject *)newObject;
}

static PyObject *
WrapImageObject(const AnnotationObject *attr)
{
    ImageObjectObject *newObject;
    newObject = PyObject_NEW(ImageObjectObject, &ImageObjectType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (AnnotationObject *)attr;
    newObject->owns = false;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
ImageObject_new(PyObject *self, PyObject *args)
{
    if (!PyArg_ParseTuple(args, ""))
        return NULL;
    return (PyObject *)NewImageObject();
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef ImageObjectMethods[] = {
    {"ImageObject", ImageObject_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *ImageObjectObserver = 0;
static bool ImageObjectEnableLogging = true;

static void
PyImageObject_WriteLog(Subject *subj, void *data)
{
    AnnotationObject *atts = (AnnotationObject *)subj; (void) atts;
    FILE *logFile = (FILE *)data;

    if(!ImageObjectEnableLogging || (logFile == NULL))
        return;

    fprintf(logFile, "# ImageObject_WriteLog()\n");
}

void
PyImageObject_StartUp(AnnotationObject *subj, FILE *logFile)
{
    if(subj == 0)
        return;

    PyImageObject_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(ImageObjectObserver == 0)
    {
        ImageObjectObserver = new ObserverToCallback(subj,
            PyImageObject_WriteLog, (void *)logFile);
    }

    ImageObjectEnableLogging = true;
}

void
PyImageObject_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete ImageObjectObserver;
    ImageObjectObserver = 0;
}

PyMethodDef *
PyImageObject_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return ImageObjectMethods;
}

bool
PyImageObject_Check(PyObject *obj)
{
    return (obj->ob_type == &ImageObjectType);
}

AnnotationObject *
PyImageObject_FromPyObject(PyObject *obj)
{
    ImageObjectObject *obj2 = (ImageObjectObject *)obj;
    return obj2->data;
}

PyObject *
PyImageObject_NewPyObject()
{
    return NewImageObject();
}

PyObject *
PyImageObject_WrapPyObject(const AnnotationObject *attr)
{
    return WrapImageObject(attr);
}

void
PyImageObject_SetLogging(bool val)
{
    ImageObjectEnableLogging = val;
}

void
PyImageObject_SetDefaults(const AnnotationObject *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new AnnotationObject(*atts);
}

