/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyMoleculeAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyMoleculeAttributes
//
// Purpose: 
//   This class contains the plot attributes for the molecule plot.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a MoleculeAttributes.
//
struct MoleculeAttributesObject
{
    PyObject_HEAD
    MoleculeAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewMoleculeAttributes(int);

std::string
PyMoleculeAttributes_ToString(const MoleculeAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    const char *drawAtomsAs_names = "NoAtoms, SphereAtoms, ImposterAtoms";
    switch (atts->GetDrawAtomsAs())
    {
      case MoleculeAttributes::NoAtoms:
          SNPRINTF(tmpStr, 1000, "%sdrawAtomsAs = %sNoAtoms  # %s\n", prefix, prefix, drawAtomsAs_names);
          str += tmpStr;
          break;
      case MoleculeAttributes::SphereAtoms:
          SNPRINTF(tmpStr, 1000, "%sdrawAtomsAs = %sSphereAtoms  # %s\n", prefix, prefix, drawAtomsAs_names);
          str += tmpStr;
          break;
      case MoleculeAttributes::ImposterAtoms:
          SNPRINTF(tmpStr, 1000, "%sdrawAtomsAs = %sImposterAtoms  # %s\n", prefix, prefix, drawAtomsAs_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const char *scaleRadiusBy_names = "Fixed, Covalent, Atomic, Variable";
    switch (atts->GetScaleRadiusBy())
    {
      case MoleculeAttributes::Fixed:
          SNPRINTF(tmpStr, 1000, "%sscaleRadiusBy = %sFixed  # %s\n", prefix, prefix, scaleRadiusBy_names);
          str += tmpStr;
          break;
      case MoleculeAttributes::Covalent:
          SNPRINTF(tmpStr, 1000, "%sscaleRadiusBy = %sCovalent  # %s\n", prefix, prefix, scaleRadiusBy_names);
          str += tmpStr;
          break;
      case MoleculeAttributes::Atomic:
          SNPRINTF(tmpStr, 1000, "%sscaleRadiusBy = %sAtomic  # %s\n", prefix, prefix, scaleRadiusBy_names);
          str += tmpStr;
          break;
      case MoleculeAttributes::Variable:
          SNPRINTF(tmpStr, 1000, "%sscaleRadiusBy = %sVariable  # %s\n", prefix, prefix, scaleRadiusBy_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const char *drawBondsAs_names = "NoBonds, LineBonds, CylinderBonds";
    switch (atts->GetDrawBondsAs())
    {
      case MoleculeAttributes::NoBonds:
          SNPRINTF(tmpStr, 1000, "%sdrawBondsAs = %sNoBonds  # %s\n", prefix, prefix, drawBondsAs_names);
          str += tmpStr;
          break;
      case MoleculeAttributes::LineBonds:
          SNPRINTF(tmpStr, 1000, "%sdrawBondsAs = %sLineBonds  # %s\n", prefix, prefix, drawBondsAs_names);
          str += tmpStr;
          break;
      case MoleculeAttributes::CylinderBonds:
          SNPRINTF(tmpStr, 1000, "%sdrawBondsAs = %sCylinderBonds  # %s\n", prefix, prefix, drawBondsAs_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const char *colorBonds_names = "ColorByAtom, SingleColor";
    switch (atts->GetColorBonds())
    {
      case MoleculeAttributes::ColorByAtom:
          SNPRINTF(tmpStr, 1000, "%scolorBonds = %sColorByAtom  # %s\n", prefix, prefix, colorBonds_names);
          str += tmpStr;
          break;
      case MoleculeAttributes::SingleColor:
          SNPRINTF(tmpStr, 1000, "%scolorBonds = %sSingleColor  # %s\n", prefix, prefix, colorBonds_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const unsigned char *bondSingleColor = atts->GetBondSingleColor().GetColor();
    SNPRINTF(tmpStr, 1000, "%sbondSingleColor = (%d, %d, %d, %d)\n", prefix, int(bondSingleColor[0]), int(bondSingleColor[1]), int(bondSingleColor[2]), int(bondSingleColor[3]));
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sradiusVariable = \"%s\"\n", prefix, atts->GetRadiusVariable().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sradiusScaleFactor = %g\n", prefix, atts->GetRadiusScaleFactor());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sradiusFixed = %g\n", prefix, atts->GetRadiusFixed());
    str += tmpStr;
    const char *atomSphereQuality_names = "Low, Medium, High, Super";
    switch (atts->GetAtomSphereQuality())
    {
      case MoleculeAttributes::Low:
          SNPRINTF(tmpStr, 1000, "%satomSphereQuality = %sLow  # %s\n", prefix, prefix, atomSphereQuality_names);
          str += tmpStr;
          break;
      case MoleculeAttributes::Medium:
          SNPRINTF(tmpStr, 1000, "%satomSphereQuality = %sMedium  # %s\n", prefix, prefix, atomSphereQuality_names);
          str += tmpStr;
          break;
      case MoleculeAttributes::High:
          SNPRINTF(tmpStr, 1000, "%satomSphereQuality = %sHigh  # %s\n", prefix, prefix, atomSphereQuality_names);
          str += tmpStr;
          break;
      case MoleculeAttributes::Super:
          SNPRINTF(tmpStr, 1000, "%satomSphereQuality = %sSuper  # %s\n", prefix, prefix, atomSphereQuality_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const char *bondCylinderQuality_names = "Low, Medium, High, Super";
    switch (atts->GetBondCylinderQuality())
    {
      case MoleculeAttributes::Low:
          SNPRINTF(tmpStr, 1000, "%sbondCylinderQuality = %sLow  # %s\n", prefix, prefix, bondCylinderQuality_names);
          str += tmpStr;
          break;
      case MoleculeAttributes::Medium:
          SNPRINTF(tmpStr, 1000, "%sbondCylinderQuality = %sMedium  # %s\n", prefix, prefix, bondCylinderQuality_names);
          str += tmpStr;
          break;
      case MoleculeAttributes::High:
          SNPRINTF(tmpStr, 1000, "%sbondCylinderQuality = %sHigh  # %s\n", prefix, prefix, bondCylinderQuality_names);
          str += tmpStr;
          break;
      case MoleculeAttributes::Super:
          SNPRINTF(tmpStr, 1000, "%sbondCylinderQuality = %sSuper  # %s\n", prefix, prefix, bondCylinderQuality_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    SNPRINTF(tmpStr, 1000, "%sbondRadius = %g\n", prefix, atts->GetBondRadius());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sbondLineWidth = %d\n", prefix, atts->GetBondLineWidth());
    str += tmpStr;
    const char *bondLineStyle_values[] = {"SOLID", "DASH", "DOT", "DOTDASH"};
    SNPRINTF(tmpStr, 1000, "%sbondLineStyle = %s%s  # SOLID, DASH, DOT, DOTDASH\n", prefix, prefix, bondLineStyle_values[atts->GetBondLineStyle()]);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%selementColorTable = \"%s\"\n", prefix, atts->GetElementColorTable().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sresidueTypeColorTable = \"%s\"\n", prefix, atts->GetResidueTypeColorTable().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sresidueSequenceColorTable = \"%s\"\n", prefix, atts->GetResidueSequenceColorTable().c_str());
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%scontinuousColorTable = \"%s\"\n", prefix, atts->GetContinuousColorTable().c_str());
    str += tmpStr;
    if(atts->GetLegendFlag())
        SNPRINTF(tmpStr, 1000, "%slegendFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%slegendFlag = 0\n", prefix);
    str += tmpStr;
    if(atts->GetMinFlag())
        SNPRINTF(tmpStr, 1000, "%sminFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%sminFlag = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sscalarMin = %g\n", prefix, atts->GetScalarMin());
    str += tmpStr;
    if(atts->GetMaxFlag())
        SNPRINTF(tmpStr, 1000, "%smaxFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%smaxFlag = 0\n", prefix);
    str += tmpStr;
    SNPRINTF(tmpStr, 1000, "%sscalarMax = %g\n", prefix, atts->GetScalarMax());
    str += tmpStr;
    return str;
}

static PyObject *
MoleculeAttributes_Notify(PyObject *self, PyObject *args)
{
    MoleculeAttributesObject *obj = (MoleculeAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MoleculeAttributes_SetDrawAtomsAs(PyObject *self, PyObject *args)
{
    MoleculeAttributesObject *obj = (MoleculeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the drawAtomsAs in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetDrawAtomsAs(MoleculeAttributes::AtomRenderingMode(ival));
    else
    {
        fprintf(stderr, "An invalid drawAtomsAs value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "NoAtoms, SphereAtoms, ImposterAtoms.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MoleculeAttributes_GetDrawAtomsAs(PyObject *self, PyObject *args)
{
    MoleculeAttributesObject *obj = (MoleculeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetDrawAtomsAs()));
    return retval;
}

/*static*/ PyObject *
MoleculeAttributes_SetScaleRadiusBy(PyObject *self, PyObject *args)
{
    MoleculeAttributesObject *obj = (MoleculeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the scaleRadiusBy in the object.
    if(ival >= 0 && ival < 4)
        obj->data->SetScaleRadiusBy(MoleculeAttributes::RadiusType(ival));
    else
    {
        fprintf(stderr, "An invalid scaleRadiusBy value was given. "
                        "Valid values are in the range of [0,3]. "
                        "You can also use the following names: "
                        "Fixed, Covalent, Atomic, Variable.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MoleculeAttributes_GetScaleRadiusBy(PyObject *self, PyObject *args)
{
    MoleculeAttributesObject *obj = (MoleculeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetScaleRadiusBy()));
    return retval;
}

/*static*/ PyObject *
MoleculeAttributes_SetDrawBondsAs(PyObject *self, PyObject *args)
{
    MoleculeAttributesObject *obj = (MoleculeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the drawBondsAs in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetDrawBondsAs(MoleculeAttributes::BondRenderingMode(ival));
    else
    {
        fprintf(stderr, "An invalid drawBondsAs value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "NoBonds, LineBonds, CylinderBonds.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MoleculeAttributes_GetDrawBondsAs(PyObject *self, PyObject *args)
{
    MoleculeAttributesObject *obj = (MoleculeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetDrawBondsAs()));
    return retval;
}

/*static*/ PyObject *
MoleculeAttributes_SetColorBonds(PyObject *self, PyObject *args)
{
    MoleculeAttributesObject *obj = (MoleculeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the colorBonds in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetColorBonds(MoleculeAttributes::BondColoringMode(ival));
    else
    {
        fprintf(stderr, "An invalid colorBonds value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "ColorByAtom, SingleColor.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MoleculeAttributes_GetColorBonds(PyObject *self, PyObject *args)
{
    MoleculeAttributesObject *obj = (MoleculeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetColorBonds()));
    return retval;
}

/*static*/ PyObject *
MoleculeAttributes_SetBondSingleColor(PyObject *self, PyObject *args)
{
    MoleculeAttributesObject *obj = (MoleculeAttributesObject *)self;

    int c[4];
    if(!PyArg_ParseTuple(args, "iiii", &c[0], &c[1], &c[2], &c[3]))
    {
        c[3] = 255;
        if(!PyArg_ParseTuple(args, "iii", &c[0], &c[1], &c[2]))
        {
            double dr, dg, db, da;
            if(PyArg_ParseTuple(args, "dddd", &dr, &dg, &db, &da))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = int(da);
            }
            else if(PyArg_ParseTuple(args, "ddd", &dr, &dg, &db))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = 255;
            }
            else
            {
                PyObject *tuple = NULL;
                if(!PyArg_ParseTuple(args, "O", &tuple))
                    return NULL;

                if(!PyTuple_Check(tuple))
                    return NULL;

                // Make sure that the tuple is the right size.
                if(PyTuple_Size(tuple) < 3 || PyTuple_Size(tuple) > 4)
                    return NULL;

                // Make sure that all elements in the tuple are ints.
                for(int i = 0; i < PyTuple_Size(tuple); ++i)
                {
                    PyObject *item = PyTuple_GET_ITEM(tuple, i);
                    if(PyInt_Check(item))
                        c[i] = int(PyInt_AS_LONG(PyTuple_GET_ITEM(tuple, i)));
                    else if(PyFloat_Check(item))
                        c[i] = int(PyFloat_AS_DOUBLE(PyTuple_GET_ITEM(tuple, i)));
                    else
                        return NULL;
                }
            }
        }
        PyErr_Clear();
    }

    // Set the bondSingleColor in the object.
    ColorAttribute ca(c[0], c[1], c[2], c[3]);
    obj->data->SetBondSingleColor(ca);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MoleculeAttributes_GetBondSingleColor(PyObject *self, PyObject *args)
{
    MoleculeAttributesObject *obj = (MoleculeAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the bondSingleColor.
    PyObject *retval = PyTuple_New(4);
    const unsigned char *bondSingleColor = obj->data->GetBondSingleColor().GetColor();
    PyTuple_SET_ITEM(retval, 0, PyInt_FromLong(long(bondSingleColor[0])));
    PyTuple_SET_ITEM(retval, 1, PyInt_FromLong(long(bondSingleColor[1])));
    PyTuple_SET_ITEM(retval, 2, PyInt_FromLong(long(bondSingleColor[2])));
    PyTuple_SET_ITEM(retval, 3, PyInt_FromLong(long(bondSingleColor[3])));
    return retval;
}

/*static*/ PyObject *
MoleculeAttributes_SetRadiusVariable(PyObject *self, PyObject *args)
{
    MoleculeAttributesObject *obj = (MoleculeAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the radiusVariable in the object.
    obj->data->SetRadiusVariable(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MoleculeAttributes_GetRadiusVariable(PyObject *self, PyObject *args)
{
    MoleculeAttributesObject *obj = (MoleculeAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetRadiusVariable().c_str());
    return retval;
}

/*static*/ PyObject *
MoleculeAttributes_SetRadiusScaleFactor(PyObject *self, PyObject *args)
{
    MoleculeAttributesObject *obj = (MoleculeAttributesObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the radiusScaleFactor in the object.
    obj->data->SetRadiusScaleFactor(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MoleculeAttributes_GetRadiusScaleFactor(PyObject *self, PyObject *args)
{
    MoleculeAttributesObject *obj = (MoleculeAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetRadiusScaleFactor()));
    return retval;
}

/*static*/ PyObject *
MoleculeAttributes_SetRadiusFixed(PyObject *self, PyObject *args)
{
    MoleculeAttributesObject *obj = (MoleculeAttributesObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the radiusFixed in the object.
    obj->data->SetRadiusFixed(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MoleculeAttributes_GetRadiusFixed(PyObject *self, PyObject *args)
{
    MoleculeAttributesObject *obj = (MoleculeAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetRadiusFixed()));
    return retval;
}

/*static*/ PyObject *
MoleculeAttributes_SetAtomSphereQuality(PyObject *self, PyObject *args)
{
    MoleculeAttributesObject *obj = (MoleculeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the atomSphereQuality in the object.
    if(ival >= 0 && ival < 4)
        obj->data->SetAtomSphereQuality(MoleculeAttributes::DetailLevel(ival));
    else
    {
        fprintf(stderr, "An invalid atomSphereQuality value was given. "
                        "Valid values are in the range of [0,3]. "
                        "You can also use the following names: "
                        "Low, Medium, High, Super.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MoleculeAttributes_GetAtomSphereQuality(PyObject *self, PyObject *args)
{
    MoleculeAttributesObject *obj = (MoleculeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetAtomSphereQuality()));
    return retval;
}

/*static*/ PyObject *
MoleculeAttributes_SetBondCylinderQuality(PyObject *self, PyObject *args)
{
    MoleculeAttributesObject *obj = (MoleculeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the bondCylinderQuality in the object.
    if(ival >= 0 && ival < 4)
        obj->data->SetBondCylinderQuality(MoleculeAttributes::DetailLevel(ival));
    else
    {
        fprintf(stderr, "An invalid bondCylinderQuality value was given. "
                        "Valid values are in the range of [0,3]. "
                        "You can also use the following names: "
                        "Low, Medium, High, Super.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MoleculeAttributes_GetBondCylinderQuality(PyObject *self, PyObject *args)
{
    MoleculeAttributesObject *obj = (MoleculeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetBondCylinderQuality()));
    return retval;
}

/*static*/ PyObject *
MoleculeAttributes_SetBondRadius(PyObject *self, PyObject *args)
{
    MoleculeAttributesObject *obj = (MoleculeAttributesObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the bondRadius in the object.
    obj->data->SetBondRadius(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MoleculeAttributes_GetBondRadius(PyObject *self, PyObject *args)
{
    MoleculeAttributesObject *obj = (MoleculeAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetBondRadius()));
    return retval;
}

/*static*/ PyObject *
MoleculeAttributes_SetBondLineWidth(PyObject *self, PyObject *args)
{
    MoleculeAttributesObject *obj = (MoleculeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the bondLineWidth in the object.
    obj->data->SetBondLineWidth(ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MoleculeAttributes_GetBondLineWidth(PyObject *self, PyObject *args)
{
    MoleculeAttributesObject *obj = (MoleculeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetBondLineWidth()));
    return retval;
}

/*static*/ PyObject *
MoleculeAttributes_SetBondLineStyle(PyObject *self, PyObject *args)
{
    MoleculeAttributesObject *obj = (MoleculeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the bondLineStyle in the object.
    if(ival >= 0 && ival <= 3)
        obj->data->SetBondLineStyle(ival);
    else
    {
        fprintf(stderr, "An invalid  value was given. "
                        "Valid values are in the range of [0,3]. "
                        "You can also use the following names: "
                        "\"SOLID\", \"DASH\", \"DOT\", \"DOTDASH\"\n");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MoleculeAttributes_GetBondLineStyle(PyObject *self, PyObject *args)
{
    MoleculeAttributesObject *obj = (MoleculeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetBondLineStyle()));
    return retval;
}

/*static*/ PyObject *
MoleculeAttributes_SetElementColorTable(PyObject *self, PyObject *args)
{
    MoleculeAttributesObject *obj = (MoleculeAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the elementColorTable in the object.
    obj->data->SetElementColorTable(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MoleculeAttributes_GetElementColorTable(PyObject *self, PyObject *args)
{
    MoleculeAttributesObject *obj = (MoleculeAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetElementColorTable().c_str());
    return retval;
}

/*static*/ PyObject *
MoleculeAttributes_SetResidueTypeColorTable(PyObject *self, PyObject *args)
{
    MoleculeAttributesObject *obj = (MoleculeAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the residueTypeColorTable in the object.
    obj->data->SetResidueTypeColorTable(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MoleculeAttributes_GetResidueTypeColorTable(PyObject *self, PyObject *args)
{
    MoleculeAttributesObject *obj = (MoleculeAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetResidueTypeColorTable().c_str());
    return retval;
}

/*static*/ PyObject *
MoleculeAttributes_SetResidueSequenceColorTable(PyObject *self, PyObject *args)
{
    MoleculeAttributesObject *obj = (MoleculeAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the residueSequenceColorTable in the object.
    obj->data->SetResidueSequenceColorTable(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MoleculeAttributes_GetResidueSequenceColorTable(PyObject *self, PyObject *args)
{
    MoleculeAttributesObject *obj = (MoleculeAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetResidueSequenceColorTable().c_str());
    return retval;
}

/*static*/ PyObject *
MoleculeAttributes_SetContinuousColorTable(PyObject *self, PyObject *args)
{
    MoleculeAttributesObject *obj = (MoleculeAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the continuousColorTable in the object.
    obj->data->SetContinuousColorTable(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MoleculeAttributes_GetContinuousColorTable(PyObject *self, PyObject *args)
{
    MoleculeAttributesObject *obj = (MoleculeAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetContinuousColorTable().c_str());
    return retval;
}

/*static*/ PyObject *
MoleculeAttributes_SetLegendFlag(PyObject *self, PyObject *args)
{
    MoleculeAttributesObject *obj = (MoleculeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the legendFlag in the object.
    obj->data->SetLegendFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MoleculeAttributes_GetLegendFlag(PyObject *self, PyObject *args)
{
    MoleculeAttributesObject *obj = (MoleculeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetLegendFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
MoleculeAttributes_SetMinFlag(PyObject *self, PyObject *args)
{
    MoleculeAttributesObject *obj = (MoleculeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the minFlag in the object.
    obj->data->SetMinFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MoleculeAttributes_GetMinFlag(PyObject *self, PyObject *args)
{
    MoleculeAttributesObject *obj = (MoleculeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetMinFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
MoleculeAttributes_SetScalarMin(PyObject *self, PyObject *args)
{
    MoleculeAttributesObject *obj = (MoleculeAttributesObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the scalarMin in the object.
    obj->data->SetScalarMin(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MoleculeAttributes_GetScalarMin(PyObject *self, PyObject *args)
{
    MoleculeAttributesObject *obj = (MoleculeAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetScalarMin()));
    return retval;
}

/*static*/ PyObject *
MoleculeAttributes_SetMaxFlag(PyObject *self, PyObject *args)
{
    MoleculeAttributesObject *obj = (MoleculeAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the maxFlag in the object.
    obj->data->SetMaxFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MoleculeAttributes_GetMaxFlag(PyObject *self, PyObject *args)
{
    MoleculeAttributesObject *obj = (MoleculeAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetMaxFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
MoleculeAttributes_SetScalarMax(PyObject *self, PyObject *args)
{
    MoleculeAttributesObject *obj = (MoleculeAttributesObject *)self;

    float fval;
    if(!PyArg_ParseTuple(args, "f", &fval))
        return NULL;

    // Set the scalarMax in the object.
    obj->data->SetScalarMax(fval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
MoleculeAttributes_GetScalarMax(PyObject *self, PyObject *args)
{
    MoleculeAttributesObject *obj = (MoleculeAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(double(obj->data->GetScalarMax()));
    return retval;
}



PyMethodDef PyMoleculeAttributes_methods[MOLECULEATTRIBUTES_NMETH] = {
    {"Notify", MoleculeAttributes_Notify, METH_VARARGS},
    {"SetDrawAtomsAs", MoleculeAttributes_SetDrawAtomsAs, METH_VARARGS},
    {"GetDrawAtomsAs", MoleculeAttributes_GetDrawAtomsAs, METH_VARARGS},
    {"SetScaleRadiusBy", MoleculeAttributes_SetScaleRadiusBy, METH_VARARGS},
    {"GetScaleRadiusBy", MoleculeAttributes_GetScaleRadiusBy, METH_VARARGS},
    {"SetDrawBondsAs", MoleculeAttributes_SetDrawBondsAs, METH_VARARGS},
    {"GetDrawBondsAs", MoleculeAttributes_GetDrawBondsAs, METH_VARARGS},
    {"SetColorBonds", MoleculeAttributes_SetColorBonds, METH_VARARGS},
    {"GetColorBonds", MoleculeAttributes_GetColorBonds, METH_VARARGS},
    {"SetBondSingleColor", MoleculeAttributes_SetBondSingleColor, METH_VARARGS},
    {"GetBondSingleColor", MoleculeAttributes_GetBondSingleColor, METH_VARARGS},
    {"SetRadiusVariable", MoleculeAttributes_SetRadiusVariable, METH_VARARGS},
    {"GetRadiusVariable", MoleculeAttributes_GetRadiusVariable, METH_VARARGS},
    {"SetRadiusScaleFactor", MoleculeAttributes_SetRadiusScaleFactor, METH_VARARGS},
    {"GetRadiusScaleFactor", MoleculeAttributes_GetRadiusScaleFactor, METH_VARARGS},
    {"SetRadiusFixed", MoleculeAttributes_SetRadiusFixed, METH_VARARGS},
    {"GetRadiusFixed", MoleculeAttributes_GetRadiusFixed, METH_VARARGS},
    {"SetAtomSphereQuality", MoleculeAttributes_SetAtomSphereQuality, METH_VARARGS},
    {"GetAtomSphereQuality", MoleculeAttributes_GetAtomSphereQuality, METH_VARARGS},
    {"SetBondCylinderQuality", MoleculeAttributes_SetBondCylinderQuality, METH_VARARGS},
    {"GetBondCylinderQuality", MoleculeAttributes_GetBondCylinderQuality, METH_VARARGS},
    {"SetBondRadius", MoleculeAttributes_SetBondRadius, METH_VARARGS},
    {"GetBondRadius", MoleculeAttributes_GetBondRadius, METH_VARARGS},
    {"SetBondLineWidth", MoleculeAttributes_SetBondLineWidth, METH_VARARGS},
    {"GetBondLineWidth", MoleculeAttributes_GetBondLineWidth, METH_VARARGS},
    {"SetBondLineStyle", MoleculeAttributes_SetBondLineStyle, METH_VARARGS},
    {"GetBondLineStyle", MoleculeAttributes_GetBondLineStyle, METH_VARARGS},
    {"SetElementColorTable", MoleculeAttributes_SetElementColorTable, METH_VARARGS},
    {"GetElementColorTable", MoleculeAttributes_GetElementColorTable, METH_VARARGS},
    {"SetResidueTypeColorTable", MoleculeAttributes_SetResidueTypeColorTable, METH_VARARGS},
    {"GetResidueTypeColorTable", MoleculeAttributes_GetResidueTypeColorTable, METH_VARARGS},
    {"SetResidueSequenceColorTable", MoleculeAttributes_SetResidueSequenceColorTable, METH_VARARGS},
    {"GetResidueSequenceColorTable", MoleculeAttributes_GetResidueSequenceColorTable, METH_VARARGS},
    {"SetContinuousColorTable", MoleculeAttributes_SetContinuousColorTable, METH_VARARGS},
    {"GetContinuousColorTable", MoleculeAttributes_GetContinuousColorTable, METH_VARARGS},
    {"SetLegendFlag", MoleculeAttributes_SetLegendFlag, METH_VARARGS},
    {"GetLegendFlag", MoleculeAttributes_GetLegendFlag, METH_VARARGS},
    {"SetMinFlag", MoleculeAttributes_SetMinFlag, METH_VARARGS},
    {"GetMinFlag", MoleculeAttributes_GetMinFlag, METH_VARARGS},
    {"SetScalarMin", MoleculeAttributes_SetScalarMin, METH_VARARGS},
    {"GetScalarMin", MoleculeAttributes_GetScalarMin, METH_VARARGS},
    {"SetMaxFlag", MoleculeAttributes_SetMaxFlag, METH_VARARGS},
    {"GetMaxFlag", MoleculeAttributes_GetMaxFlag, METH_VARARGS},
    {"SetScalarMax", MoleculeAttributes_SetScalarMax, METH_VARARGS},
    {"GetScalarMax", MoleculeAttributes_GetScalarMax, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
MoleculeAttributes_dealloc(PyObject *v)
{
   MoleculeAttributesObject *obj = (MoleculeAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
MoleculeAttributes_compare(PyObject *v, PyObject *w)
{
    MoleculeAttributes *a = ((MoleculeAttributesObject *)v)->data;
    MoleculeAttributes *b = ((MoleculeAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyMoleculeAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "drawAtomsAs") == 0)
        return MoleculeAttributes_GetDrawAtomsAs(self, NULL);
    if(strcmp(name, "NoAtoms") == 0)
        return PyInt_FromLong(long(MoleculeAttributes::NoAtoms));
    if(strcmp(name, "SphereAtoms") == 0)
        return PyInt_FromLong(long(MoleculeAttributes::SphereAtoms));
    if(strcmp(name, "ImposterAtoms") == 0)
        return PyInt_FromLong(long(MoleculeAttributes::ImposterAtoms));

    if(strcmp(name, "scaleRadiusBy") == 0)
        return MoleculeAttributes_GetScaleRadiusBy(self, NULL);
    if(strcmp(name, "Fixed") == 0)
        return PyInt_FromLong(long(MoleculeAttributes::Fixed));
    if(strcmp(name, "Covalent") == 0)
        return PyInt_FromLong(long(MoleculeAttributes::Covalent));
    if(strcmp(name, "Atomic") == 0)
        return PyInt_FromLong(long(MoleculeAttributes::Atomic));
    if(strcmp(name, "Variable") == 0)
        return PyInt_FromLong(long(MoleculeAttributes::Variable));

    if(strcmp(name, "drawBondsAs") == 0)
        return MoleculeAttributes_GetDrawBondsAs(self, NULL);
    if(strcmp(name, "NoBonds") == 0)
        return PyInt_FromLong(long(MoleculeAttributes::NoBonds));
    if(strcmp(name, "LineBonds") == 0)
        return PyInt_FromLong(long(MoleculeAttributes::LineBonds));
    if(strcmp(name, "CylinderBonds") == 0)
        return PyInt_FromLong(long(MoleculeAttributes::CylinderBonds));

    if(strcmp(name, "colorBonds") == 0)
        return MoleculeAttributes_GetColorBonds(self, NULL);
    if(strcmp(name, "ColorByAtom") == 0)
        return PyInt_FromLong(long(MoleculeAttributes::ColorByAtom));
    if(strcmp(name, "SingleColor") == 0)
        return PyInt_FromLong(long(MoleculeAttributes::SingleColor));

    if(strcmp(name, "bondSingleColor") == 0)
        return MoleculeAttributes_GetBondSingleColor(self, NULL);
    if(strcmp(name, "radiusVariable") == 0)
        return MoleculeAttributes_GetRadiusVariable(self, NULL);
    if(strcmp(name, "radiusScaleFactor") == 0)
        return MoleculeAttributes_GetRadiusScaleFactor(self, NULL);
    if(strcmp(name, "radiusFixed") == 0)
        return MoleculeAttributes_GetRadiusFixed(self, NULL);
    if(strcmp(name, "atomSphereQuality") == 0)
        return MoleculeAttributes_GetAtomSphereQuality(self, NULL);
    if(strcmp(name, "Low") == 0)
        return PyInt_FromLong(long(MoleculeAttributes::Low));
    if(strcmp(name, "Medium") == 0)
        return PyInt_FromLong(long(MoleculeAttributes::Medium));
    if(strcmp(name, "High") == 0)
        return PyInt_FromLong(long(MoleculeAttributes::High));
    if(strcmp(name, "Super") == 0)
        return PyInt_FromLong(long(MoleculeAttributes::Super));

    if(strcmp(name, "bondCylinderQuality") == 0)
        return MoleculeAttributes_GetBondCylinderQuality(self, NULL);
    if(strcmp(name, "Low") == 0)
        return PyInt_FromLong(long(MoleculeAttributes::Low));
    if(strcmp(name, "Medium") == 0)
        return PyInt_FromLong(long(MoleculeAttributes::Medium));
    if(strcmp(name, "High") == 0)
        return PyInt_FromLong(long(MoleculeAttributes::High));
    if(strcmp(name, "Super") == 0)
        return PyInt_FromLong(long(MoleculeAttributes::Super));

    if(strcmp(name, "bondRadius") == 0)
        return MoleculeAttributes_GetBondRadius(self, NULL);
    if(strcmp(name, "bondLineWidth") == 0)
        return MoleculeAttributes_GetBondLineWidth(self, NULL);
    if(strcmp(name, "bondLineStyle") == 0)
        return MoleculeAttributes_GetBondLineStyle(self, NULL);
    if(strcmp(name, "SOLID") == 0)
        return PyInt_FromLong(long(0));
    else if(strcmp(name, "DASH") == 0)
        return PyInt_FromLong(long(1));
    else if(strcmp(name, "DOT") == 0)
        return PyInt_FromLong(long(2));
    else if(strcmp(name, "DOTDASH") == 0)
        return PyInt_FromLong(long(3));

    if(strcmp(name, "elementColorTable") == 0)
        return MoleculeAttributes_GetElementColorTable(self, NULL);
    if(strcmp(name, "residueTypeColorTable") == 0)
        return MoleculeAttributes_GetResidueTypeColorTable(self, NULL);
    if(strcmp(name, "residueSequenceColorTable") == 0)
        return MoleculeAttributes_GetResidueSequenceColorTable(self, NULL);
    if(strcmp(name, "continuousColorTable") == 0)
        return MoleculeAttributes_GetContinuousColorTable(self, NULL);
    if(strcmp(name, "legendFlag") == 0)
        return MoleculeAttributes_GetLegendFlag(self, NULL);
    if(strcmp(name, "minFlag") == 0)
        return MoleculeAttributes_GetMinFlag(self, NULL);
    if(strcmp(name, "scalarMin") == 0)
        return MoleculeAttributes_GetScalarMin(self, NULL);
    if(strcmp(name, "maxFlag") == 0)
        return MoleculeAttributes_GetMaxFlag(self, NULL);
    if(strcmp(name, "scalarMax") == 0)
        return MoleculeAttributes_GetScalarMax(self, NULL);

    return Py_FindMethod(PyMoleculeAttributes_methods, self, name);
}

int
PyMoleculeAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "drawAtomsAs") == 0)
        obj = MoleculeAttributes_SetDrawAtomsAs(self, tuple);
    else if(strcmp(name, "scaleRadiusBy") == 0)
        obj = MoleculeAttributes_SetScaleRadiusBy(self, tuple);
    else if(strcmp(name, "drawBondsAs") == 0)
        obj = MoleculeAttributes_SetDrawBondsAs(self, tuple);
    else if(strcmp(name, "colorBonds") == 0)
        obj = MoleculeAttributes_SetColorBonds(self, tuple);
    else if(strcmp(name, "bondSingleColor") == 0)
        obj = MoleculeAttributes_SetBondSingleColor(self, tuple);
    else if(strcmp(name, "radiusVariable") == 0)
        obj = MoleculeAttributes_SetRadiusVariable(self, tuple);
    else if(strcmp(name, "radiusScaleFactor") == 0)
        obj = MoleculeAttributes_SetRadiusScaleFactor(self, tuple);
    else if(strcmp(name, "radiusFixed") == 0)
        obj = MoleculeAttributes_SetRadiusFixed(self, tuple);
    else if(strcmp(name, "atomSphereQuality") == 0)
        obj = MoleculeAttributes_SetAtomSphereQuality(self, tuple);
    else if(strcmp(name, "bondCylinderQuality") == 0)
        obj = MoleculeAttributes_SetBondCylinderQuality(self, tuple);
    else if(strcmp(name, "bondRadius") == 0)
        obj = MoleculeAttributes_SetBondRadius(self, tuple);
    else if(strcmp(name, "bondLineWidth") == 0)
        obj = MoleculeAttributes_SetBondLineWidth(self, tuple);
    else if(strcmp(name, "bondLineStyle") == 0)
        obj = MoleculeAttributes_SetBondLineStyle(self, tuple);
    else if(strcmp(name, "elementColorTable") == 0)
        obj = MoleculeAttributes_SetElementColorTable(self, tuple);
    else if(strcmp(name, "residueTypeColorTable") == 0)
        obj = MoleculeAttributes_SetResidueTypeColorTable(self, tuple);
    else if(strcmp(name, "residueSequenceColorTable") == 0)
        obj = MoleculeAttributes_SetResidueSequenceColorTable(self, tuple);
    else if(strcmp(name, "continuousColorTable") == 0)
        obj = MoleculeAttributes_SetContinuousColorTable(self, tuple);
    else if(strcmp(name, "legendFlag") == 0)
        obj = MoleculeAttributes_SetLegendFlag(self, tuple);
    else if(strcmp(name, "minFlag") == 0)
        obj = MoleculeAttributes_SetMinFlag(self, tuple);
    else if(strcmp(name, "scalarMin") == 0)
        obj = MoleculeAttributes_SetScalarMin(self, tuple);
    else if(strcmp(name, "maxFlag") == 0)
        obj = MoleculeAttributes_SetMaxFlag(self, tuple);
    else if(strcmp(name, "scalarMax") == 0)
        obj = MoleculeAttributes_SetScalarMax(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
MoleculeAttributes_print(PyObject *v, FILE *fp, int flags)
{
    MoleculeAttributesObject *obj = (MoleculeAttributesObject *)v;
    fprintf(fp, "%s", PyMoleculeAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
MoleculeAttributes_str(PyObject *v)
{
    MoleculeAttributesObject *obj = (MoleculeAttributesObject *)v;
    return PyString_FromString(PyMoleculeAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *MoleculeAttributes_Purpose = "This class contains the plot attributes for the molecule plot.";
#else
static char *MoleculeAttributes_Purpose = "This class contains the plot attributes for the molecule plot.";
#endif

//
// The type description structure
//
static PyTypeObject MoleculeAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "MoleculeAttributes",                    // tp_name
    sizeof(MoleculeAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)MoleculeAttributes_dealloc,  // tp_dealloc
    (printfunc)MoleculeAttributes_print,     // tp_print
    (getattrfunc)PyMoleculeAttributes_getattr, // tp_getattr
    (setattrfunc)PyMoleculeAttributes_setattr, // tp_setattr
    (cmpfunc)MoleculeAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)MoleculeAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    MoleculeAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static MoleculeAttributes *defaultAtts = 0;
static MoleculeAttributes *currentAtts = 0;

static PyObject *
NewMoleculeAttributes(int useCurrent)
{
    MoleculeAttributesObject *newObject;
    newObject = PyObject_NEW(MoleculeAttributesObject, &MoleculeAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new MoleculeAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new MoleculeAttributes(*defaultAtts);
    else
        newObject->data = new MoleculeAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapMoleculeAttributes(const MoleculeAttributes *attr)
{
    MoleculeAttributesObject *newObject;
    newObject = PyObject_NEW(MoleculeAttributesObject, &MoleculeAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (MoleculeAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
MoleculeAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewMoleculeAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef MoleculeAttributesMethods[] = {
    {"MoleculeAttributes", MoleculeAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *MoleculeAttributesObserver = 0;

std::string
PyMoleculeAttributes_GetLogString()
{
    std::string s("MoleculeAtts = MoleculeAttributes()\n");
    if(currentAtts != 0)
        s += PyMoleculeAttributes_ToString(currentAtts, "MoleculeAtts.");
    return s;
}

static void
PyMoleculeAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("MoleculeAtts = MoleculeAttributes()\n");
        s += PyMoleculeAttributes_ToString(currentAtts, "MoleculeAtts.");
        cb(s);
    }
}

void
PyMoleculeAttributes_StartUp(MoleculeAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyMoleculeAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(MoleculeAttributesObserver == 0)
    {
        MoleculeAttributesObserver = new ObserverToCallback(subj,
            PyMoleculeAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyMoleculeAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete MoleculeAttributesObserver;
    MoleculeAttributesObserver = 0;
}

PyMethodDef *
PyMoleculeAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return MoleculeAttributesMethods;
}

bool
PyMoleculeAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &MoleculeAttributesType);
}

MoleculeAttributes *
PyMoleculeAttributes_FromPyObject(PyObject *obj)
{
    MoleculeAttributesObject *obj2 = (MoleculeAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyMoleculeAttributes_New()
{
    return NewMoleculeAttributes(0);
}

PyObject *
PyMoleculeAttributes_Wrap(const MoleculeAttributes *attr)
{
    return WrapMoleculeAttributes(attr);
}

void
PyMoleculeAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    MoleculeAttributesObject *obj2 = (MoleculeAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyMoleculeAttributes_SetDefaults(const MoleculeAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new MoleculeAttributes(*atts);
}

