// ***************************************************************************
//
// Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
// Produced at the Lawrence Livermore National Laboratory
// LLNL-CODE-442911
// All rights reserved.
//
// This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
// full copyright notice is contained in the file COPYRIGHT located at the root
// of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
//
// Redistribution  and  use  in  source  and  binary  forms,  with  or  without
// modification, are permitted provided that the following conditions are met:
//
//  - Redistributions of  source code must  retain the above  copyright notice,
//    this list of conditions and the disclaimer below.
//  - Redistributions in binary form must reproduce the above copyright notice,
//    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
//    documentation and/or other materials provided with the distribution.
//  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
//    be used to endorse or promote products derived from this software without
//    specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
// ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
// LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
// DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
// SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
// CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
// LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
// OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
// DAMAGE.
//
// ***************************************************************************

package llnl.visit.operators;

import llnl.visit.AttributeSubject;
import llnl.visit.CommunicationBuffer;
import llnl.visit.Plugin;
import java.lang.Double;
import java.util.Vector;
import llnl.visit.ColorAttribute;

// ****************************************************************************
// Class: PoincareAttributes
//
// Purpose:
//    Attributes for the Poincare
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

public class PoincareAttributes extends AttributeSubject implements Plugin
{
    private static int PoincareAttributes_numAdditionalAtts = 77;

    // Enum values
    public final static int SOURCETYPE_SPECIFIEDPOINT = 0;
    public final static int SOURCETYPE_POINTLIST = 1;
    public final static int SOURCETYPE_SPECIFIEDLINE = 2;

    public final static int FIELDTYPE_DEFAULT = 0;
    public final static int FIELDTYPE_FLASHFIELD = 1;
    public final static int FIELDTYPE_M3DC12DFIELD = 2;
    public final static int FIELDTYPE_M3DC13DFIELD = 3;
    public final static int FIELDTYPE_NEK5000FIELD = 4;
    public final static int FIELDTYPE_NEKTARPPFIELD = 5;
    public final static int FIELDTYPE_NIMRODFIELD = 6;

    public final static int INTEGRATIONTYPE_EULER = 0;
    public final static int INTEGRATIONTYPE_LEAPFROG = 1;
    public final static int INTEGRATIONTYPE_DORMANDPRINCE = 2;
    public final static int INTEGRATIONTYPE_ADAMSBASHFORTH = 3;
    public final static int INTEGRATIONTYPE_RK4 = 4;
    public final static int INTEGRATIONTYPE_M3DC12DINTEGRATOR = 5;

    public final static int SIZETYPE_ABSOLUTE = 0;
    public final static int SIZETYPE_FRACTIONOFBBOX = 1;

    public final static int COORDINATESYSTEM_CARTESIAN = 0;
    public final static int COORDINATESYSTEM_CYLINDRICAL = 1;

    public final static int OVERLAPTYPE_RAW = 0;
    public final static int OVERLAPTYPE_REMOVE = 1;
    public final static int OVERLAPTYPE_MERGE = 2;
    public final static int OVERLAPTYPE_SMOOTH = 3;

    public final static int SHOWMESHTYPE_CURVES = 0;
    public final static int SHOWMESHTYPE_SURFACES = 1;

    public final static int PUNCTUREPLOTTYPE_SINGLE = 0;
    public final static int PUNCTUREPLOTTYPE_DOUBLE = 1;

    public final static int PUNCTUREPLANETYPE_POLOIDAL = 0;
    public final static int PUNCTUREPLANETYPE_TOROIDAL = 1;
    public final static int PUNCTUREPLANETYPE_ARBITRARY = 2;

    public final static int ANALYSISTYPE_NONE = 0;
    public final static int ANALYSISTYPE_NORMAL = 1;

    public final static int COLORINGMETHOD_COLORBYSINGLECOLOR = 0;
    public final static int COLORINGMETHOD_COLORBYCOLORTABLE = 1;

    public final static int OPACITY_EXPLICIT = 0;
    public final static int OPACITY_COLORTABLE = 1;

    public final static int DATAVALUE_SOLID = 0;
    public final static int DATAVALUE_SAFETYFACTORQ = 1;
    public final static int DATAVALUE_SAFETYFACTORP = 2;
    public final static int DATAVALUE_SAFETYFACTORQ_NOTP = 3;
    public final static int DATAVALUE_SAFETYFACTORP_NOTQ = 4;
    public final static int DATAVALUE_TOROIDALWINDINGS = 5;
    public final static int DATAVALUE_POLOIDALWINDINGSQ = 6;
    public final static int DATAVALUE_POLOIDALWINDINGSP = 7;
    public final static int DATAVALUE_FIELDLINEORDER = 8;
    public final static int DATAVALUE_POINTORDER = 9;
    public final static int DATAVALUE_PLANEORDER = 10;
    public final static int DATAVALUE_WINDINGGROUPORDER = 11;
    public final static int DATAVALUE_WINDINGPOINTORDER = 12;
    public final static int DATAVALUE_WINDINGPOINTORDERMODULO = 13;

    public final static int PARALLELIZATIONALGORITHMTYPE_LOADONDEMAND = 0;
    public final static int PARALLELIZATIONALGORITHMTYPE_PARALLELSTATICDOMAINS = 1;
    public final static int PARALLELIZATIONALGORITHMTYPE_MASTERSLAVE = 2;
    public final static int PARALLELIZATIONALGORITHMTYPE_VISITSELECTS = 3;

    public final static int PATHLINESCMFE_CONN_CMFE = 0;
    public final static int PATHLINESCMFE_POS_CMFE = 1;

    public final static int POINTTYPE_BOX = 0;
    public final static int POINTTYPE_AXIS = 1;
    public final static int POINTTYPE_ICOSAHEDRON = 2;
    public final static int POINTTYPE_OCTAHEDRON = 3;
    public final static int POINTTYPE_TETRAHEDRON = 4;
    public final static int POINTTYPE_SPHEREGEOMETRY = 5;
    public final static int POINTTYPE_POINT = 6;
    public final static int POINTTYPE_SPHERE = 7;


    public PoincareAttributes()
    {
        super(PoincareAttributes_numAdditionalAtts);

        opacityType = OPACITY_EXPLICIT;
        opacity = 1;
        minPunctures = 50;
        maxPunctures = 500;
        puncturePlotType = PUNCTUREPLOTTYPE_SINGLE;
        maxSteps = 1000;
        terminateByTime = false;
        termTime = 10;
        puncturePeriodTolerance = 0.01;
        puncturePlane = PUNCTUREPLANETYPE_POLOIDAL;
        sourceType = SOURCETYPE_SPECIFIEDPOINT;
        pointSource = new double[3];
        pointSource[0] = 0;
        pointSource[1] = 0;
        pointSource[2] = 0;
        pointList = new Vector();
        pointList.addElement(new Double(0));
        pointList.addElement(new Double(0));
        pointList.addElement(new Double(0));
        pointList.addElement(new Double(1));
        pointList.addElement(new Double(0));
        pointList.addElement(new Double(0));
        pointList.addElement(new Double(0));
        pointList.addElement(new Double(1));
        pointList.addElement(new Double(0));
        lineStart = new double[3];
        lineStart[0] = 0;
        lineStart[1] = 0;
        lineStart[2] = 0;
        lineEnd = new double[3];
        lineEnd[0] = 1;
        lineEnd[1] = 0;
        lineEnd[2] = 0;
        pointDensity = 1;
        fieldType = FIELDTYPE_DEFAULT;
        forceNodeCenteredData = false;
        fieldConstant = 1;
        velocitySource = new double[3];
        velocitySource[0] = 0;
        velocitySource[1] = 0;
        velocitySource[2] = 0;
        integrationType = INTEGRATIONTYPE_ADAMSBASHFORTH;
        coordinateSystem = COORDINATESYSTEM_CARTESIAN;
        maxStepLength = 0.1;
        limitMaximumTimestep = false;
        maxTimeStep = 0.1;
        relTol = 0.0001;
        absTolSizeType = SIZETYPE_FRACTIONOFBBOX;
        absTolAbsolute = 1e-05;
        absTolBBox = 1e-06;
        analysis = ANALYSISTYPE_NORMAL;
        maximumToroidalWinding = 0;
        overrideToroidalWinding = 0;
        overridePoloidalWinding = 0;
        windingPairConfidence = 0.9;
        rationalSurfaceFactor = 0.1;
        overlaps = OVERLAPTYPE_REMOVE;
        meshType = SHOWMESHTYPE_CURVES;
        numberPlanes = 1;
        singlePlane = 0;
        min = 0;
        max = 0;
        minFlag = false;
        maxFlag = false;
        colorType = COLORINGMETHOD_COLORBYCOLORTABLE;
        singleColor = new ColorAttribute(0, 0, 0);
        colorTableName = new String("Default");
        dataValue = DATAVALUE_SAFETYFACTORQ;
        showRationalSurfaces = false;
        RationalSurfaceMaxIterations = 2;
        showOPoints = false;
        OPointMaxIterations = 2;
        showXPoints = false;
        XPointMaxIterations = 2;
        performOLineAnalysis = false;
        OLineToroidalWinding = 1;
        OLineAxisFileName = new String("");
        showChaotic = false;
        showIslands = false;
        SummaryFlag = true;
        verboseFlag = false;
        show1DPlots = false;
        showLines = true;
        showPoints = false;
        parallelizationAlgorithmType = PARALLELIZATIONALGORITHMTYPE_VISITSELECTS;
        maxProcessCount = 10;
        maxDomainCacheSize = 3;
        workGroupSize = 32;
        pathlines = false;
        pathlinesOverrideStartingTimeFlag = false;
        pathlinesOverrideStartingTime = 0;
        pathlinesPeriod = 0;
        pathlinesCMFE = PATHLINESCMFE_POS_CMFE;
        issueTerminationWarnings = true;
        issueStepsizeWarnings = true;
        issueStiffnessWarnings = true;
        issueCriticalPointsWarnings = true;
        criticalPointThreshold = 0.001;
    }

    public PoincareAttributes(int nMoreFields)
    {
        super(PoincareAttributes_numAdditionalAtts + nMoreFields);

        opacityType = OPACITY_EXPLICIT;
        opacity = 1;
        minPunctures = 50;
        maxPunctures = 500;
        puncturePlotType = PUNCTUREPLOTTYPE_SINGLE;
        maxSteps = 1000;
        terminateByTime = false;
        termTime = 10;
        puncturePeriodTolerance = 0.01;
        puncturePlane = PUNCTUREPLANETYPE_POLOIDAL;
        sourceType = SOURCETYPE_SPECIFIEDPOINT;
        pointSource = new double[3];
        pointSource[0] = 0;
        pointSource[1] = 0;
        pointSource[2] = 0;
        pointList = new Vector();
        pointList.addElement(new Double(0));
        pointList.addElement(new Double(0));
        pointList.addElement(new Double(0));
        pointList.addElement(new Double(1));
        pointList.addElement(new Double(0));
        pointList.addElement(new Double(0));
        pointList.addElement(new Double(0));
        pointList.addElement(new Double(1));
        pointList.addElement(new Double(0));
        lineStart = new double[3];
        lineStart[0] = 0;
        lineStart[1] = 0;
        lineStart[2] = 0;
        lineEnd = new double[3];
        lineEnd[0] = 1;
        lineEnd[1] = 0;
        lineEnd[2] = 0;
        pointDensity = 1;
        fieldType = FIELDTYPE_DEFAULT;
        forceNodeCenteredData = false;
        fieldConstant = 1;
        velocitySource = new double[3];
        velocitySource[0] = 0;
        velocitySource[1] = 0;
        velocitySource[2] = 0;
        integrationType = INTEGRATIONTYPE_ADAMSBASHFORTH;
        coordinateSystem = COORDINATESYSTEM_CARTESIAN;
        maxStepLength = 0.1;
        limitMaximumTimestep = false;
        maxTimeStep = 0.1;
        relTol = 0.0001;
        absTolSizeType = SIZETYPE_FRACTIONOFBBOX;
        absTolAbsolute = 1e-05;
        absTolBBox = 1e-06;
        analysis = ANALYSISTYPE_NORMAL;
        maximumToroidalWinding = 0;
        overrideToroidalWinding = 0;
        overridePoloidalWinding = 0;
        windingPairConfidence = 0.9;
        rationalSurfaceFactor = 0.1;
        overlaps = OVERLAPTYPE_REMOVE;
        meshType = SHOWMESHTYPE_CURVES;
        numberPlanes = 1;
        singlePlane = 0;
        min = 0;
        max = 0;
        minFlag = false;
        maxFlag = false;
        colorType = COLORINGMETHOD_COLORBYCOLORTABLE;
        singleColor = new ColorAttribute(0, 0, 0);
        colorTableName = new String("Default");
        dataValue = DATAVALUE_SAFETYFACTORQ;
        showRationalSurfaces = false;
        RationalSurfaceMaxIterations = 2;
        showOPoints = false;
        OPointMaxIterations = 2;
        showXPoints = false;
        XPointMaxIterations = 2;
        performOLineAnalysis = false;
        OLineToroidalWinding = 1;
        OLineAxisFileName = new String("");
        showChaotic = false;
        showIslands = false;
        SummaryFlag = true;
        verboseFlag = false;
        show1DPlots = false;
        showLines = true;
        showPoints = false;
        parallelizationAlgorithmType = PARALLELIZATIONALGORITHMTYPE_VISITSELECTS;
        maxProcessCount = 10;
        maxDomainCacheSize = 3;
        workGroupSize = 32;
        pathlines = false;
        pathlinesOverrideStartingTimeFlag = false;
        pathlinesOverrideStartingTime = 0;
        pathlinesPeriod = 0;
        pathlinesCMFE = PATHLINESCMFE_POS_CMFE;
        issueTerminationWarnings = true;
        issueStepsizeWarnings = true;
        issueStiffnessWarnings = true;
        issueCriticalPointsWarnings = true;
        criticalPointThreshold = 0.001;
    }

    public PoincareAttributes(PoincareAttributes obj)
    {
        super(obj);

        int i;

        opacityType = obj.opacityType;
        opacity = obj.opacity;
        minPunctures = obj.minPunctures;
        maxPunctures = obj.maxPunctures;
        puncturePlotType = obj.puncturePlotType;
        maxSteps = obj.maxSteps;
        terminateByTime = obj.terminateByTime;
        termTime = obj.termTime;
        puncturePeriodTolerance = obj.puncturePeriodTolerance;
        puncturePlane = obj.puncturePlane;
        sourceType = obj.sourceType;
        pointSource = new double[3];
        pointSource[0] = obj.pointSource[0];
        pointSource[1] = obj.pointSource[1];
        pointSource[2] = obj.pointSource[2];

        pointList = new Vector(obj.pointList.size());
        for(i = 0; i < obj.pointList.size(); ++i)
        {
            Double dv = (Double)obj.pointList.elementAt(i);
            pointList.addElement(new Double(dv.doubleValue()));
        }

        lineStart = new double[3];
        lineStart[0] = obj.lineStart[0];
        lineStart[1] = obj.lineStart[1];
        lineStart[2] = obj.lineStart[2];

        lineEnd = new double[3];
        lineEnd[0] = obj.lineEnd[0];
        lineEnd[1] = obj.lineEnd[1];
        lineEnd[2] = obj.lineEnd[2];

        pointDensity = obj.pointDensity;
        fieldType = obj.fieldType;
        forceNodeCenteredData = obj.forceNodeCenteredData;
        fieldConstant = obj.fieldConstant;
        velocitySource = new double[3];
        velocitySource[0] = obj.velocitySource[0];
        velocitySource[1] = obj.velocitySource[1];
        velocitySource[2] = obj.velocitySource[2];

        integrationType = obj.integrationType;
        coordinateSystem = obj.coordinateSystem;
        maxStepLength = obj.maxStepLength;
        limitMaximumTimestep = obj.limitMaximumTimestep;
        maxTimeStep = obj.maxTimeStep;
        relTol = obj.relTol;
        absTolSizeType = obj.absTolSizeType;
        absTolAbsolute = obj.absTolAbsolute;
        absTolBBox = obj.absTolBBox;
        analysis = obj.analysis;
        maximumToroidalWinding = obj.maximumToroidalWinding;
        overrideToroidalWinding = obj.overrideToroidalWinding;
        overridePoloidalWinding = obj.overridePoloidalWinding;
        windingPairConfidence = obj.windingPairConfidence;
        rationalSurfaceFactor = obj.rationalSurfaceFactor;
        overlaps = obj.overlaps;
        meshType = obj.meshType;
        numberPlanes = obj.numberPlanes;
        singlePlane = obj.singlePlane;
        min = obj.min;
        max = obj.max;
        minFlag = obj.minFlag;
        maxFlag = obj.maxFlag;
        colorType = obj.colorType;
        singleColor = new ColorAttribute(obj.singleColor);
        colorTableName = new String(obj.colorTableName);
        dataValue = obj.dataValue;
        showRationalSurfaces = obj.showRationalSurfaces;
        RationalSurfaceMaxIterations = obj.RationalSurfaceMaxIterations;
        showOPoints = obj.showOPoints;
        OPointMaxIterations = obj.OPointMaxIterations;
        showXPoints = obj.showXPoints;
        XPointMaxIterations = obj.XPointMaxIterations;
        performOLineAnalysis = obj.performOLineAnalysis;
        OLineToroidalWinding = obj.OLineToroidalWinding;
        OLineAxisFileName = new String(obj.OLineAxisFileName);
        showChaotic = obj.showChaotic;
        showIslands = obj.showIslands;
        SummaryFlag = obj.SummaryFlag;
        verboseFlag = obj.verboseFlag;
        show1DPlots = obj.show1DPlots;
        showLines = obj.showLines;
        showPoints = obj.showPoints;
        parallelizationAlgorithmType = obj.parallelizationAlgorithmType;
        maxProcessCount = obj.maxProcessCount;
        maxDomainCacheSize = obj.maxDomainCacheSize;
        workGroupSize = obj.workGroupSize;
        pathlines = obj.pathlines;
        pathlinesOverrideStartingTimeFlag = obj.pathlinesOverrideStartingTimeFlag;
        pathlinesOverrideStartingTime = obj.pathlinesOverrideStartingTime;
        pathlinesPeriod = obj.pathlinesPeriod;
        pathlinesCMFE = obj.pathlinesCMFE;
        issueTerminationWarnings = obj.issueTerminationWarnings;
        issueStepsizeWarnings = obj.issueStepsizeWarnings;
        issueStiffnessWarnings = obj.issueStiffnessWarnings;
        issueCriticalPointsWarnings = obj.issueCriticalPointsWarnings;
        criticalPointThreshold = obj.criticalPointThreshold;

        SelectAll();
    }

    public int Offset()
    {
        return super.Offset() + super.GetNumAdditionalAttributes();
    }

    public int GetNumAdditionalAttributes()
    {
        return PoincareAttributes_numAdditionalAtts;
    }

    public boolean equals(PoincareAttributes obj)
    {
        int i;

        // Compare the pointSource arrays.
        boolean pointSource_equal = true;
        for(i = 0; i < 3 && pointSource_equal; ++i)
            pointSource_equal = (pointSource[i] == obj.pointSource[i]);

        // Compare the elements in the pointList vector.
        boolean pointList_equal = (obj.pointList.size() == pointList.size());
        for(i = 0; (i < pointList.size()) && pointList_equal; ++i)
        {
            // Make references to Double from Object.
            Double pointList1 = (Double)pointList.elementAt(i);
            Double pointList2 = (Double)obj.pointList.elementAt(i);
            pointList_equal = pointList1.equals(pointList2);
        }
        // Compare the lineStart arrays.
        boolean lineStart_equal = true;
        for(i = 0; i < 3 && lineStart_equal; ++i)
            lineStart_equal = (lineStart[i] == obj.lineStart[i]);

        // Compare the lineEnd arrays.
        boolean lineEnd_equal = true;
        for(i = 0; i < 3 && lineEnd_equal; ++i)
            lineEnd_equal = (lineEnd[i] == obj.lineEnd[i]);

        // Compare the velocitySource arrays.
        boolean velocitySource_equal = true;
        for(i = 0; i < 3 && velocitySource_equal; ++i)
            velocitySource_equal = (velocitySource[i] == obj.velocitySource[i]);

        // Create the return value
        return ((opacityType == obj.opacityType) &&
                (opacity == obj.opacity) &&
                (minPunctures == obj.minPunctures) &&
                (maxPunctures == obj.maxPunctures) &&
                (puncturePlotType == obj.puncturePlotType) &&
                (maxSteps == obj.maxSteps) &&
                (terminateByTime == obj.terminateByTime) &&
                (termTime == obj.termTime) &&
                (puncturePeriodTolerance == obj.puncturePeriodTolerance) &&
                (puncturePlane == obj.puncturePlane) &&
                (sourceType == obj.sourceType) &&
                pointSource_equal &&
                pointList_equal &&
                lineStart_equal &&
                lineEnd_equal &&
                (pointDensity == obj.pointDensity) &&
                (fieldType == obj.fieldType) &&
                (forceNodeCenteredData == obj.forceNodeCenteredData) &&
                (fieldConstant == obj.fieldConstant) &&
                velocitySource_equal &&
                (integrationType == obj.integrationType) &&
                (coordinateSystem == obj.coordinateSystem) &&
                (maxStepLength == obj.maxStepLength) &&
                (limitMaximumTimestep == obj.limitMaximumTimestep) &&
                (maxTimeStep == obj.maxTimeStep) &&
                (relTol == obj.relTol) &&
                (absTolSizeType == obj.absTolSizeType) &&
                (absTolAbsolute == obj.absTolAbsolute) &&
                (absTolBBox == obj.absTolBBox) &&
                (analysis == obj.analysis) &&
                (maximumToroidalWinding == obj.maximumToroidalWinding) &&
                (overrideToroidalWinding == obj.overrideToroidalWinding) &&
                (overridePoloidalWinding == obj.overridePoloidalWinding) &&
                (windingPairConfidence == obj.windingPairConfidence) &&
                (rationalSurfaceFactor == obj.rationalSurfaceFactor) &&
                (overlaps == obj.overlaps) &&
                (meshType == obj.meshType) &&
                (numberPlanes == obj.numberPlanes) &&
                (singlePlane == obj.singlePlane) &&
                (min == obj.min) &&
                (max == obj.max) &&
                (minFlag == obj.minFlag) &&
                (maxFlag == obj.maxFlag) &&
                (colorType == obj.colorType) &&
                (singleColor == obj.singleColor) &&
                (colorTableName.equals(obj.colorTableName)) &&
                (dataValue == obj.dataValue) &&
                (showRationalSurfaces == obj.showRationalSurfaces) &&
                (RationalSurfaceMaxIterations == obj.RationalSurfaceMaxIterations) &&
                (showOPoints == obj.showOPoints) &&
                (OPointMaxIterations == obj.OPointMaxIterations) &&
                (showXPoints == obj.showXPoints) &&
                (XPointMaxIterations == obj.XPointMaxIterations) &&
                (performOLineAnalysis == obj.performOLineAnalysis) &&
                (OLineToroidalWinding == obj.OLineToroidalWinding) &&
                (OLineAxisFileName.equals(obj.OLineAxisFileName)) &&
                (showChaotic == obj.showChaotic) &&
                (showIslands == obj.showIslands) &&
                (SummaryFlag == obj.SummaryFlag) &&
                (verboseFlag == obj.verboseFlag) &&
                (show1DPlots == obj.show1DPlots) &&
                (showLines == obj.showLines) &&
                (showPoints == obj.showPoints) &&
                (parallelizationAlgorithmType == obj.parallelizationAlgorithmType) &&
                (maxProcessCount == obj.maxProcessCount) &&
                (maxDomainCacheSize == obj.maxDomainCacheSize) &&
                (workGroupSize == obj.workGroupSize) &&
                (pathlines == obj.pathlines) &&
                (pathlinesOverrideStartingTimeFlag == obj.pathlinesOverrideStartingTimeFlag) &&
                (pathlinesOverrideStartingTime == obj.pathlinesOverrideStartingTime) &&
                (pathlinesPeriod == obj.pathlinesPeriod) &&
                (pathlinesCMFE == obj.pathlinesCMFE) &&
                (issueTerminationWarnings == obj.issueTerminationWarnings) &&
                (issueStepsizeWarnings == obj.issueStepsizeWarnings) &&
                (issueStiffnessWarnings == obj.issueStiffnessWarnings) &&
                (issueCriticalPointsWarnings == obj.issueCriticalPointsWarnings) &&
                (criticalPointThreshold == obj.criticalPointThreshold));
    }

    public String GetName() { return "Poincare"; }
    public String GetVersion() { return "3.0"; }

    // Property setting methods
    public void SetOpacityType(int opacityType_)
    {
        opacityType = opacityType_;
        Select(0);
    }

    public void SetOpacity(double opacity_)
    {
        opacity = opacity_;
        Select(1);
    }

    public void SetMinPunctures(int minPunctures_)
    {
        minPunctures = minPunctures_;
        Select(2);
    }

    public void SetMaxPunctures(int maxPunctures_)
    {
        maxPunctures = maxPunctures_;
        Select(3);
    }

    public void SetPuncturePlotType(int puncturePlotType_)
    {
        puncturePlotType = puncturePlotType_;
        Select(4);
    }

    public void SetMaxSteps(int maxSteps_)
    {
        maxSteps = maxSteps_;
        Select(5);
    }

    public void SetTerminateByTime(boolean terminateByTime_)
    {
        terminateByTime = terminateByTime_;
        Select(6);
    }

    public void SetTermTime(double termTime_)
    {
        termTime = termTime_;
        Select(7);
    }

    public void SetPuncturePeriodTolerance(double puncturePeriodTolerance_)
    {
        puncturePeriodTolerance = puncturePeriodTolerance_;
        Select(8);
    }

    public void SetPuncturePlane(int puncturePlane_)
    {
        puncturePlane = puncturePlane_;
        Select(9);
    }

    public void SetSourceType(int sourceType_)
    {
        sourceType = sourceType_;
        Select(10);
    }

    public void SetPointSource(double[] pointSource_)
    {
        pointSource[0] = pointSource_[0];
        pointSource[1] = pointSource_[1];
        pointSource[2] = pointSource_[2];
        Select(11);
    }

    public void SetPointSource(double e0, double e1, double e2)
    {
        pointSource[0] = e0;
        pointSource[1] = e1;
        pointSource[2] = e2;
        Select(11);
    }

    public void SetPointList(Vector pointList_)
    {
        pointList = pointList_;
        Select(12);
    }

    public void SetLineStart(double[] lineStart_)
    {
        lineStart[0] = lineStart_[0];
        lineStart[1] = lineStart_[1];
        lineStart[2] = lineStart_[2];
        Select(13);
    }

    public void SetLineStart(double e0, double e1, double e2)
    {
        lineStart[0] = e0;
        lineStart[1] = e1;
        lineStart[2] = e2;
        Select(13);
    }

    public void SetLineEnd(double[] lineEnd_)
    {
        lineEnd[0] = lineEnd_[0];
        lineEnd[1] = lineEnd_[1];
        lineEnd[2] = lineEnd_[2];
        Select(14);
    }

    public void SetLineEnd(double e0, double e1, double e2)
    {
        lineEnd[0] = e0;
        lineEnd[1] = e1;
        lineEnd[2] = e2;
        Select(14);
    }

    public void SetPointDensity(int pointDensity_)
    {
        pointDensity = pointDensity_;
        Select(15);
    }

    public void SetFieldType(int fieldType_)
    {
        fieldType = fieldType_;
        Select(16);
    }

    public void SetForceNodeCenteredData(boolean forceNodeCenteredData_)
    {
        forceNodeCenteredData = forceNodeCenteredData_;
        Select(17);
    }

    public void SetFieldConstant(double fieldConstant_)
    {
        fieldConstant = fieldConstant_;
        Select(18);
    }

    public void SetVelocitySource(double[] velocitySource_)
    {
        velocitySource[0] = velocitySource_[0];
        velocitySource[1] = velocitySource_[1];
        velocitySource[2] = velocitySource_[2];
        Select(19);
    }

    public void SetVelocitySource(double e0, double e1, double e2)
    {
        velocitySource[0] = e0;
        velocitySource[1] = e1;
        velocitySource[2] = e2;
        Select(19);
    }

    public void SetIntegrationType(int integrationType_)
    {
        integrationType = integrationType_;
        Select(20);
    }

    public void SetCoordinateSystem(int coordinateSystem_)
    {
        coordinateSystem = coordinateSystem_;
        Select(21);
    }

    public void SetMaxStepLength(double maxStepLength_)
    {
        maxStepLength = maxStepLength_;
        Select(22);
    }

    public void SetLimitMaximumTimestep(boolean limitMaximumTimestep_)
    {
        limitMaximumTimestep = limitMaximumTimestep_;
        Select(23);
    }

    public void SetMaxTimeStep(double maxTimeStep_)
    {
        maxTimeStep = maxTimeStep_;
        Select(24);
    }

    public void SetRelTol(double relTol_)
    {
        relTol = relTol_;
        Select(25);
    }

    public void SetAbsTolSizeType(int absTolSizeType_)
    {
        absTolSizeType = absTolSizeType_;
        Select(26);
    }

    public void SetAbsTolAbsolute(double absTolAbsolute_)
    {
        absTolAbsolute = absTolAbsolute_;
        Select(27);
    }

    public void SetAbsTolBBox(double absTolBBox_)
    {
        absTolBBox = absTolBBox_;
        Select(28);
    }

    public void SetAnalysis(int analysis_)
    {
        analysis = analysis_;
        Select(29);
    }

    public void SetMaximumToroidalWinding(int maximumToroidalWinding_)
    {
        maximumToroidalWinding = maximumToroidalWinding_;
        Select(30);
    }

    public void SetOverrideToroidalWinding(int overrideToroidalWinding_)
    {
        overrideToroidalWinding = overrideToroidalWinding_;
        Select(31);
    }

    public void SetOverridePoloidalWinding(int overridePoloidalWinding_)
    {
        overridePoloidalWinding = overridePoloidalWinding_;
        Select(32);
    }

    public void SetWindingPairConfidence(double windingPairConfidence_)
    {
        windingPairConfidence = windingPairConfidence_;
        Select(33);
    }

    public void SetRationalSurfaceFactor(double rationalSurfaceFactor_)
    {
        rationalSurfaceFactor = rationalSurfaceFactor_;
        Select(34);
    }

    public void SetOverlaps(int overlaps_)
    {
        overlaps = overlaps_;
        Select(35);
    }

    public void SetMeshType(int meshType_)
    {
        meshType = meshType_;
        Select(36);
    }

    public void SetNumberPlanes(int numberPlanes_)
    {
        numberPlanes = numberPlanes_;
        Select(37);
    }

    public void SetSinglePlane(double singlePlane_)
    {
        singlePlane = singlePlane_;
        Select(38);
    }

    public void SetMin(double min_)
    {
        min = min_;
        Select(39);
    }

    public void SetMax(double max_)
    {
        max = max_;
        Select(40);
    }

    public void SetMinFlag(boolean minFlag_)
    {
        minFlag = minFlag_;
        Select(41);
    }

    public void SetMaxFlag(boolean maxFlag_)
    {
        maxFlag = maxFlag_;
        Select(42);
    }

    public void SetColorType(int colorType_)
    {
        colorType = colorType_;
        Select(43);
    }

    public void SetSingleColor(ColorAttribute singleColor_)
    {
        singleColor = singleColor_;
        Select(44);
    }

    public void SetColorTableName(String colorTableName_)
    {
        colorTableName = colorTableName_;
        Select(45);
    }

    public void SetDataValue(int dataValue_)
    {
        dataValue = dataValue_;
        Select(46);
    }

    public void SetShowRationalSurfaces(boolean showRationalSurfaces_)
    {
        showRationalSurfaces = showRationalSurfaces_;
        Select(47);
    }

    public void SetRationalSurfaceMaxIterations(int RationalSurfaceMaxIterations_)
    {
        RationalSurfaceMaxIterations = RationalSurfaceMaxIterations_;
        Select(48);
    }

    public void SetShowOPoints(boolean showOPoints_)
    {
        showOPoints = showOPoints_;
        Select(49);
    }

    public void SetOPointMaxIterations(int OPointMaxIterations_)
    {
        OPointMaxIterations = OPointMaxIterations_;
        Select(50);
    }

    public void SetShowXPoints(boolean showXPoints_)
    {
        showXPoints = showXPoints_;
        Select(51);
    }

    public void SetXPointMaxIterations(int XPointMaxIterations_)
    {
        XPointMaxIterations = XPointMaxIterations_;
        Select(52);
    }

    public void SetPerformOLineAnalysis(boolean performOLineAnalysis_)
    {
        performOLineAnalysis = performOLineAnalysis_;
        Select(53);
    }

    public void SetOLineToroidalWinding(int OLineToroidalWinding_)
    {
        OLineToroidalWinding = OLineToroidalWinding_;
        Select(54);
    }

    public void SetOLineAxisFileName(String OLineAxisFileName_)
    {
        OLineAxisFileName = OLineAxisFileName_;
        Select(55);
    }

    public void SetShowChaotic(boolean showChaotic_)
    {
        showChaotic = showChaotic_;
        Select(56);
    }

    public void SetShowIslands(boolean showIslands_)
    {
        showIslands = showIslands_;
        Select(57);
    }

    public void SetSummaryFlag(boolean SummaryFlag_)
    {
        SummaryFlag = SummaryFlag_;
        Select(58);
    }

    public void SetVerboseFlag(boolean verboseFlag_)
    {
        verboseFlag = verboseFlag_;
        Select(59);
    }

    public void SetShow1DPlots(boolean show1DPlots_)
    {
        show1DPlots = show1DPlots_;
        Select(60);
    }

    public void SetShowLines(boolean showLines_)
    {
        showLines = showLines_;
        Select(61);
    }

    public void SetShowPoints(boolean showPoints_)
    {
        showPoints = showPoints_;
        Select(62);
    }

    public void SetParallelizationAlgorithmType(int parallelizationAlgorithmType_)
    {
        parallelizationAlgorithmType = parallelizationAlgorithmType_;
        Select(63);
    }

    public void SetMaxProcessCount(int maxProcessCount_)
    {
        maxProcessCount = maxProcessCount_;
        Select(64);
    }

    public void SetMaxDomainCacheSize(int maxDomainCacheSize_)
    {
        maxDomainCacheSize = maxDomainCacheSize_;
        Select(65);
    }

    public void SetWorkGroupSize(int workGroupSize_)
    {
        workGroupSize = workGroupSize_;
        Select(66);
    }

    public void SetPathlines(boolean pathlines_)
    {
        pathlines = pathlines_;
        Select(67);
    }

    public void SetPathlinesOverrideStartingTimeFlag(boolean pathlinesOverrideStartingTimeFlag_)
    {
        pathlinesOverrideStartingTimeFlag = pathlinesOverrideStartingTimeFlag_;
        Select(68);
    }

    public void SetPathlinesOverrideStartingTime(double pathlinesOverrideStartingTime_)
    {
        pathlinesOverrideStartingTime = pathlinesOverrideStartingTime_;
        Select(69);
    }

    public void SetPathlinesPeriod(double pathlinesPeriod_)
    {
        pathlinesPeriod = pathlinesPeriod_;
        Select(70);
    }

    public void SetPathlinesCMFE(int pathlinesCMFE_)
    {
        pathlinesCMFE = pathlinesCMFE_;
        Select(71);
    }

    public void SetIssueTerminationWarnings(boolean issueTerminationWarnings_)
    {
        issueTerminationWarnings = issueTerminationWarnings_;
        Select(72);
    }

    public void SetIssueStepsizeWarnings(boolean issueStepsizeWarnings_)
    {
        issueStepsizeWarnings = issueStepsizeWarnings_;
        Select(73);
    }

    public void SetIssueStiffnessWarnings(boolean issueStiffnessWarnings_)
    {
        issueStiffnessWarnings = issueStiffnessWarnings_;
        Select(74);
    }

    public void SetIssueCriticalPointsWarnings(boolean issueCriticalPointsWarnings_)
    {
        issueCriticalPointsWarnings = issueCriticalPointsWarnings_;
        Select(75);
    }

    public void SetCriticalPointThreshold(double criticalPointThreshold_)
    {
        criticalPointThreshold = criticalPointThreshold_;
        Select(76);
    }

    // Property getting methods
    public int            GetOpacityType() { return opacityType; }
    public double         GetOpacity() { return opacity; }
    public int            GetMinPunctures() { return minPunctures; }
    public int            GetMaxPunctures() { return maxPunctures; }
    public int            GetPuncturePlotType() { return puncturePlotType; }
    public int            GetMaxSteps() { return maxSteps; }
    public boolean        GetTerminateByTime() { return terminateByTime; }
    public double         GetTermTime() { return termTime; }
    public double         GetPuncturePeriodTolerance() { return puncturePeriodTolerance; }
    public int            GetPuncturePlane() { return puncturePlane; }
    public int            GetSourceType() { return sourceType; }
    public double[]       GetPointSource() { return pointSource; }
    public Vector         GetPointList() { return pointList; }
    public double[]       GetLineStart() { return lineStart; }
    public double[]       GetLineEnd() { return lineEnd; }
    public int            GetPointDensity() { return pointDensity; }
    public int            GetFieldType() { return fieldType; }
    public boolean        GetForceNodeCenteredData() { return forceNodeCenteredData; }
    public double         GetFieldConstant() { return fieldConstant; }
    public double[]       GetVelocitySource() { return velocitySource; }
    public int            GetIntegrationType() { return integrationType; }
    public int            GetCoordinateSystem() { return coordinateSystem; }
    public double         GetMaxStepLength() { return maxStepLength; }
    public boolean        GetLimitMaximumTimestep() { return limitMaximumTimestep; }
    public double         GetMaxTimeStep() { return maxTimeStep; }
    public double         GetRelTol() { return relTol; }
    public int            GetAbsTolSizeType() { return absTolSizeType; }
    public double         GetAbsTolAbsolute() { return absTolAbsolute; }
    public double         GetAbsTolBBox() { return absTolBBox; }
    public int            GetAnalysis() { return analysis; }
    public int            GetMaximumToroidalWinding() { return maximumToroidalWinding; }
    public int            GetOverrideToroidalWinding() { return overrideToroidalWinding; }
    public int            GetOverridePoloidalWinding() { return overridePoloidalWinding; }
    public double         GetWindingPairConfidence() { return windingPairConfidence; }
    public double         GetRationalSurfaceFactor() { return rationalSurfaceFactor; }
    public int            GetOverlaps() { return overlaps; }
    public int            GetMeshType() { return meshType; }
    public int            GetNumberPlanes() { return numberPlanes; }
    public double         GetSinglePlane() { return singlePlane; }
    public double         GetMin() { return min; }
    public double         GetMax() { return max; }
    public boolean        GetMinFlag() { return minFlag; }
    public boolean        GetMaxFlag() { return maxFlag; }
    public int            GetColorType() { return colorType; }
    public ColorAttribute GetSingleColor() { return singleColor; }
    public String         GetColorTableName() { return colorTableName; }
    public int            GetDataValue() { return dataValue; }
    public boolean        GetShowRationalSurfaces() { return showRationalSurfaces; }
    public int            GetRationalSurfaceMaxIterations() { return RationalSurfaceMaxIterations; }
    public boolean        GetShowOPoints() { return showOPoints; }
    public int            GetOPointMaxIterations() { return OPointMaxIterations; }
    public boolean        GetShowXPoints() { return showXPoints; }
    public int            GetXPointMaxIterations() { return XPointMaxIterations; }
    public boolean        GetPerformOLineAnalysis() { return performOLineAnalysis; }
    public int            GetOLineToroidalWinding() { return OLineToroidalWinding; }
    public String         GetOLineAxisFileName() { return OLineAxisFileName; }
    public boolean        GetShowChaotic() { return showChaotic; }
    public boolean        GetShowIslands() { return showIslands; }
    public boolean        GetSummaryFlag() { return SummaryFlag; }
    public boolean        GetVerboseFlag() { return verboseFlag; }
    public boolean        GetShow1DPlots() { return show1DPlots; }
    public boolean        GetShowLines() { return showLines; }
    public boolean        GetShowPoints() { return showPoints; }
    public int            GetParallelizationAlgorithmType() { return parallelizationAlgorithmType; }
    public int            GetMaxProcessCount() { return maxProcessCount; }
    public int            GetMaxDomainCacheSize() { return maxDomainCacheSize; }
    public int            GetWorkGroupSize() { return workGroupSize; }
    public boolean        GetPathlines() { return pathlines; }
    public boolean        GetPathlinesOverrideStartingTimeFlag() { return pathlinesOverrideStartingTimeFlag; }
    public double         GetPathlinesOverrideStartingTime() { return pathlinesOverrideStartingTime; }
    public double         GetPathlinesPeriod() { return pathlinesPeriod; }
    public int            GetPathlinesCMFE() { return pathlinesCMFE; }
    public boolean        GetIssueTerminationWarnings() { return issueTerminationWarnings; }
    public boolean        GetIssueStepsizeWarnings() { return issueStepsizeWarnings; }
    public boolean        GetIssueStiffnessWarnings() { return issueStiffnessWarnings; }
    public boolean        GetIssueCriticalPointsWarnings() { return issueCriticalPointsWarnings; }
    public double         GetCriticalPointThreshold() { return criticalPointThreshold; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteInt(opacityType);
        if(WriteSelect(1, buf))
            buf.WriteDouble(opacity);
        if(WriteSelect(2, buf))
            buf.WriteInt(minPunctures);
        if(WriteSelect(3, buf))
            buf.WriteInt(maxPunctures);
        if(WriteSelect(4, buf))
            buf.WriteInt(puncturePlotType);
        if(WriteSelect(5, buf))
            buf.WriteInt(maxSteps);
        if(WriteSelect(6, buf))
            buf.WriteBool(terminateByTime);
        if(WriteSelect(7, buf))
            buf.WriteDouble(termTime);
        if(WriteSelect(8, buf))
            buf.WriteDouble(puncturePeriodTolerance);
        if(WriteSelect(9, buf))
            buf.WriteInt(puncturePlane);
        if(WriteSelect(10, buf))
            buf.WriteInt(sourceType);
        if(WriteSelect(11, buf))
            buf.WriteDoubleArray(pointSource);
        if(WriteSelect(12, buf))
            buf.WriteDoubleVector(pointList);
        if(WriteSelect(13, buf))
            buf.WriteDoubleArray(lineStart);
        if(WriteSelect(14, buf))
            buf.WriteDoubleArray(lineEnd);
        if(WriteSelect(15, buf))
            buf.WriteInt(pointDensity);
        if(WriteSelect(16, buf))
            buf.WriteInt(fieldType);
        if(WriteSelect(17, buf))
            buf.WriteBool(forceNodeCenteredData);
        if(WriteSelect(18, buf))
            buf.WriteDouble(fieldConstant);
        if(WriteSelect(19, buf))
            buf.WriteDoubleArray(velocitySource);
        if(WriteSelect(20, buf))
            buf.WriteInt(integrationType);
        if(WriteSelect(21, buf))
            buf.WriteInt(coordinateSystem);
        if(WriteSelect(22, buf))
            buf.WriteDouble(maxStepLength);
        if(WriteSelect(23, buf))
            buf.WriteBool(limitMaximumTimestep);
        if(WriteSelect(24, buf))
            buf.WriteDouble(maxTimeStep);
        if(WriteSelect(25, buf))
            buf.WriteDouble(relTol);
        if(WriteSelect(26, buf))
            buf.WriteInt(absTolSizeType);
        if(WriteSelect(27, buf))
            buf.WriteDouble(absTolAbsolute);
        if(WriteSelect(28, buf))
            buf.WriteDouble(absTolBBox);
        if(WriteSelect(29, buf))
            buf.WriteInt(analysis);
        if(WriteSelect(30, buf))
            buf.WriteInt(maximumToroidalWinding);
        if(WriteSelect(31, buf))
            buf.WriteInt(overrideToroidalWinding);
        if(WriteSelect(32, buf))
            buf.WriteInt(overridePoloidalWinding);
        if(WriteSelect(33, buf))
            buf.WriteDouble(windingPairConfidence);
        if(WriteSelect(34, buf))
            buf.WriteDouble(rationalSurfaceFactor);
        if(WriteSelect(35, buf))
            buf.WriteInt(overlaps);
        if(WriteSelect(36, buf))
            buf.WriteInt(meshType);
        if(WriteSelect(37, buf))
            buf.WriteInt(numberPlanes);
        if(WriteSelect(38, buf))
            buf.WriteDouble(singlePlane);
        if(WriteSelect(39, buf))
            buf.WriteDouble(min);
        if(WriteSelect(40, buf))
            buf.WriteDouble(max);
        if(WriteSelect(41, buf))
            buf.WriteBool(minFlag);
        if(WriteSelect(42, buf))
            buf.WriteBool(maxFlag);
        if(WriteSelect(43, buf))
            buf.WriteInt(colorType);
        if(WriteSelect(44, buf))
            singleColor.Write(buf);
        if(WriteSelect(45, buf))
            buf.WriteString(colorTableName);
        if(WriteSelect(46, buf))
            buf.WriteInt(dataValue);
        if(WriteSelect(47, buf))
            buf.WriteBool(showRationalSurfaces);
        if(WriteSelect(48, buf))
            buf.WriteInt(RationalSurfaceMaxIterations);
        if(WriteSelect(49, buf))
            buf.WriteBool(showOPoints);
        if(WriteSelect(50, buf))
            buf.WriteInt(OPointMaxIterations);
        if(WriteSelect(51, buf))
            buf.WriteBool(showXPoints);
        if(WriteSelect(52, buf))
            buf.WriteInt(XPointMaxIterations);
        if(WriteSelect(53, buf))
            buf.WriteBool(performOLineAnalysis);
        if(WriteSelect(54, buf))
            buf.WriteInt(OLineToroidalWinding);
        if(WriteSelect(55, buf))
            buf.WriteString(OLineAxisFileName);
        if(WriteSelect(56, buf))
            buf.WriteBool(showChaotic);
        if(WriteSelect(57, buf))
            buf.WriteBool(showIslands);
        if(WriteSelect(58, buf))
            buf.WriteBool(SummaryFlag);
        if(WriteSelect(59, buf))
            buf.WriteBool(verboseFlag);
        if(WriteSelect(60, buf))
            buf.WriteBool(show1DPlots);
        if(WriteSelect(61, buf))
            buf.WriteBool(showLines);
        if(WriteSelect(62, buf))
            buf.WriteBool(showPoints);
        if(WriteSelect(63, buf))
            buf.WriteInt(parallelizationAlgorithmType);
        if(WriteSelect(64, buf))
            buf.WriteInt(maxProcessCount);
        if(WriteSelect(65, buf))
            buf.WriteInt(maxDomainCacheSize);
        if(WriteSelect(66, buf))
            buf.WriteInt(workGroupSize);
        if(WriteSelect(67, buf))
            buf.WriteBool(pathlines);
        if(WriteSelect(68, buf))
            buf.WriteBool(pathlinesOverrideStartingTimeFlag);
        if(WriteSelect(69, buf))
            buf.WriteDouble(pathlinesOverrideStartingTime);
        if(WriteSelect(70, buf))
            buf.WriteDouble(pathlinesPeriod);
        if(WriteSelect(71, buf))
            buf.WriteInt(pathlinesCMFE);
        if(WriteSelect(72, buf))
            buf.WriteBool(issueTerminationWarnings);
        if(WriteSelect(73, buf))
            buf.WriteBool(issueStepsizeWarnings);
        if(WriteSelect(74, buf))
            buf.WriteBool(issueStiffnessWarnings);
        if(WriteSelect(75, buf))
            buf.WriteBool(issueCriticalPointsWarnings);
        if(WriteSelect(76, buf))
            buf.WriteDouble(criticalPointThreshold);
    }

    public void ReadAtts(int index, CommunicationBuffer buf)
    {
        switch(index)
        {
        case 0:
            SetOpacityType(buf.ReadInt());
            break;
        case 1:
            SetOpacity(buf.ReadDouble());
            break;
        case 2:
            SetMinPunctures(buf.ReadInt());
            break;
        case 3:
            SetMaxPunctures(buf.ReadInt());
            break;
        case 4:
            SetPuncturePlotType(buf.ReadInt());
            break;
        case 5:
            SetMaxSteps(buf.ReadInt());
            break;
        case 6:
            SetTerminateByTime(buf.ReadBool());
            break;
        case 7:
            SetTermTime(buf.ReadDouble());
            break;
        case 8:
            SetPuncturePeriodTolerance(buf.ReadDouble());
            break;
        case 9:
            SetPuncturePlane(buf.ReadInt());
            break;
        case 10:
            SetSourceType(buf.ReadInt());
            break;
        case 11:
            SetPointSource(buf.ReadDoubleArray());
            break;
        case 12:
            SetPointList(buf.ReadDoubleVector());
            break;
        case 13:
            SetLineStart(buf.ReadDoubleArray());
            break;
        case 14:
            SetLineEnd(buf.ReadDoubleArray());
            break;
        case 15:
            SetPointDensity(buf.ReadInt());
            break;
        case 16:
            SetFieldType(buf.ReadInt());
            break;
        case 17:
            SetForceNodeCenteredData(buf.ReadBool());
            break;
        case 18:
            SetFieldConstant(buf.ReadDouble());
            break;
        case 19:
            SetVelocitySource(buf.ReadDoubleArray());
            break;
        case 20:
            SetIntegrationType(buf.ReadInt());
            break;
        case 21:
            SetCoordinateSystem(buf.ReadInt());
            break;
        case 22:
            SetMaxStepLength(buf.ReadDouble());
            break;
        case 23:
            SetLimitMaximumTimestep(buf.ReadBool());
            break;
        case 24:
            SetMaxTimeStep(buf.ReadDouble());
            break;
        case 25:
            SetRelTol(buf.ReadDouble());
            break;
        case 26:
            SetAbsTolSizeType(buf.ReadInt());
            break;
        case 27:
            SetAbsTolAbsolute(buf.ReadDouble());
            break;
        case 28:
            SetAbsTolBBox(buf.ReadDouble());
            break;
        case 29:
            SetAnalysis(buf.ReadInt());
            break;
        case 30:
            SetMaximumToroidalWinding(buf.ReadInt());
            break;
        case 31:
            SetOverrideToroidalWinding(buf.ReadInt());
            break;
        case 32:
            SetOverridePoloidalWinding(buf.ReadInt());
            break;
        case 33:
            SetWindingPairConfidence(buf.ReadDouble());
            break;
        case 34:
            SetRationalSurfaceFactor(buf.ReadDouble());
            break;
        case 35:
            SetOverlaps(buf.ReadInt());
            break;
        case 36:
            SetMeshType(buf.ReadInt());
            break;
        case 37:
            SetNumberPlanes(buf.ReadInt());
            break;
        case 38:
            SetSinglePlane(buf.ReadDouble());
            break;
        case 39:
            SetMin(buf.ReadDouble());
            break;
        case 40:
            SetMax(buf.ReadDouble());
            break;
        case 41:
            SetMinFlag(buf.ReadBool());
            break;
        case 42:
            SetMaxFlag(buf.ReadBool());
            break;
        case 43:
            SetColorType(buf.ReadInt());
            break;
        case 44:
            singleColor.Read(buf);
            Select(44);
            break;
        case 45:
            SetColorTableName(buf.ReadString());
            break;
        case 46:
            SetDataValue(buf.ReadInt());
            break;
        case 47:
            SetShowRationalSurfaces(buf.ReadBool());
            break;
        case 48:
            SetRationalSurfaceMaxIterations(buf.ReadInt());
            break;
        case 49:
            SetShowOPoints(buf.ReadBool());
            break;
        case 50:
            SetOPointMaxIterations(buf.ReadInt());
            break;
        case 51:
            SetShowXPoints(buf.ReadBool());
            break;
        case 52:
            SetXPointMaxIterations(buf.ReadInt());
            break;
        case 53:
            SetPerformOLineAnalysis(buf.ReadBool());
            break;
        case 54:
            SetOLineToroidalWinding(buf.ReadInt());
            break;
        case 55:
            SetOLineAxisFileName(buf.ReadString());
            break;
        case 56:
            SetShowChaotic(buf.ReadBool());
            break;
        case 57:
            SetShowIslands(buf.ReadBool());
            break;
        case 58:
            SetSummaryFlag(buf.ReadBool());
            break;
        case 59:
            SetVerboseFlag(buf.ReadBool());
            break;
        case 60:
            SetShow1DPlots(buf.ReadBool());
            break;
        case 61:
            SetShowLines(buf.ReadBool());
            break;
        case 62:
            SetShowPoints(buf.ReadBool());
            break;
        case 63:
            SetParallelizationAlgorithmType(buf.ReadInt());
            break;
        case 64:
            SetMaxProcessCount(buf.ReadInt());
            break;
        case 65:
            SetMaxDomainCacheSize(buf.ReadInt());
            break;
        case 66:
            SetWorkGroupSize(buf.ReadInt());
            break;
        case 67:
            SetPathlines(buf.ReadBool());
            break;
        case 68:
            SetPathlinesOverrideStartingTimeFlag(buf.ReadBool());
            break;
        case 69:
            SetPathlinesOverrideStartingTime(buf.ReadDouble());
            break;
        case 70:
            SetPathlinesPeriod(buf.ReadDouble());
            break;
        case 71:
            SetPathlinesCMFE(buf.ReadInt());
            break;
        case 72:
            SetIssueTerminationWarnings(buf.ReadBool());
            break;
        case 73:
            SetIssueStepsizeWarnings(buf.ReadBool());
            break;
        case 74:
            SetIssueStiffnessWarnings(buf.ReadBool());
            break;
        case 75:
            SetIssueCriticalPointsWarnings(buf.ReadBool());
            break;
        case 76:
            SetCriticalPointThreshold(buf.ReadDouble());
            break;
        }
    }

    public String toString(String indent)
    {
        String str = new String();
        str = str + indent + "opacityType = ";
        if(opacityType == OPACITY_EXPLICIT)
            str = str + "OPACITY_EXPLICIT";
        if(opacityType == OPACITY_COLORTABLE)
            str = str + "OPACITY_COLORTABLE";
        str = str + "\n";
        str = str + doubleToString("opacity", opacity, indent) + "\n";
        str = str + intToString("minPunctures", minPunctures, indent) + "\n";
        str = str + intToString("maxPunctures", maxPunctures, indent) + "\n";
        str = str + indent + "puncturePlotType = ";
        if(puncturePlotType == PUNCTUREPLOTTYPE_SINGLE)
            str = str + "PUNCTUREPLOTTYPE_SINGLE";
        if(puncturePlotType == PUNCTUREPLOTTYPE_DOUBLE)
            str = str + "PUNCTUREPLOTTYPE_DOUBLE";
        str = str + "\n";
        str = str + intToString("maxSteps", maxSteps, indent) + "\n";
        str = str + boolToString("terminateByTime", terminateByTime, indent) + "\n";
        str = str + doubleToString("termTime", termTime, indent) + "\n";
        str = str + doubleToString("puncturePeriodTolerance", puncturePeriodTolerance, indent) + "\n";
        str = str + indent + "puncturePlane = ";
        if(puncturePlane == PUNCTUREPLANETYPE_POLOIDAL)
            str = str + "PUNCTUREPLANETYPE_POLOIDAL";
        if(puncturePlane == PUNCTUREPLANETYPE_TOROIDAL)
            str = str + "PUNCTUREPLANETYPE_TOROIDAL";
        if(puncturePlane == PUNCTUREPLANETYPE_ARBITRARY)
            str = str + "PUNCTUREPLANETYPE_ARBITRARY";
        str = str + "\n";
        str = str + indent + "sourceType = ";
        if(sourceType == SOURCETYPE_SPECIFIEDPOINT)
            str = str + "SOURCETYPE_SPECIFIEDPOINT";
        if(sourceType == SOURCETYPE_POINTLIST)
            str = str + "SOURCETYPE_POINTLIST";
        if(sourceType == SOURCETYPE_SPECIFIEDLINE)
            str = str + "SOURCETYPE_SPECIFIEDLINE";
        str = str + "\n";
        str = str + doubleArrayToString("pointSource", pointSource, indent) + "\n";
        str = str + doubleVectorToString("pointList", pointList, indent) + "\n";
        str = str + doubleArrayToString("lineStart", lineStart, indent) + "\n";
        str = str + doubleArrayToString("lineEnd", lineEnd, indent) + "\n";
        str = str + intToString("pointDensity", pointDensity, indent) + "\n";
        str = str + indent + "fieldType = ";
        if(fieldType == FIELDTYPE_DEFAULT)
            str = str + "FIELDTYPE_DEFAULT";
        if(fieldType == FIELDTYPE_FLASHFIELD)
            str = str + "FIELDTYPE_FLASHFIELD";
        if(fieldType == FIELDTYPE_M3DC12DFIELD)
            str = str + "FIELDTYPE_M3DC12DFIELD";
        if(fieldType == FIELDTYPE_M3DC13DFIELD)
            str = str + "FIELDTYPE_M3DC13DFIELD";
        if(fieldType == FIELDTYPE_NEK5000FIELD)
            str = str + "FIELDTYPE_NEK5000FIELD";
        if(fieldType == FIELDTYPE_NEKTARPPFIELD)
            str = str + "FIELDTYPE_NEKTARPPFIELD";
        if(fieldType == FIELDTYPE_NIMRODFIELD)
            str = str + "FIELDTYPE_NIMRODFIELD";
        str = str + "\n";
        str = str + boolToString("forceNodeCenteredData", forceNodeCenteredData, indent) + "\n";
        str = str + doubleToString("fieldConstant", fieldConstant, indent) + "\n";
        str = str + doubleArrayToString("velocitySource", velocitySource, indent) + "\n";
        str = str + indent + "integrationType = ";
        if(integrationType == INTEGRATIONTYPE_EULER)
            str = str + "INTEGRATIONTYPE_EULER";
        if(integrationType == INTEGRATIONTYPE_LEAPFROG)
            str = str + "INTEGRATIONTYPE_LEAPFROG";
        if(integrationType == INTEGRATIONTYPE_DORMANDPRINCE)
            str = str + "INTEGRATIONTYPE_DORMANDPRINCE";
        if(integrationType == INTEGRATIONTYPE_ADAMSBASHFORTH)
            str = str + "INTEGRATIONTYPE_ADAMSBASHFORTH";
        if(integrationType == INTEGRATIONTYPE_RK4)
            str = str + "INTEGRATIONTYPE_RK4";
        if(integrationType == INTEGRATIONTYPE_M3DC12DINTEGRATOR)
            str = str + "INTEGRATIONTYPE_M3DC12DINTEGRATOR";
        str = str + "\n";
        str = str + indent + "coordinateSystem = ";
        if(coordinateSystem == COORDINATESYSTEM_CARTESIAN)
            str = str + "COORDINATESYSTEM_CARTESIAN";
        if(coordinateSystem == COORDINATESYSTEM_CYLINDRICAL)
            str = str + "COORDINATESYSTEM_CYLINDRICAL";
        str = str + "\n";
        str = str + doubleToString("maxStepLength", maxStepLength, indent) + "\n";
        str = str + boolToString("limitMaximumTimestep", limitMaximumTimestep, indent) + "\n";
        str = str + doubleToString("maxTimeStep", maxTimeStep, indent) + "\n";
        str = str + doubleToString("relTol", relTol, indent) + "\n";
        str = str + indent + "absTolSizeType = ";
        if(absTolSizeType == SIZETYPE_ABSOLUTE)
            str = str + "SIZETYPE_ABSOLUTE";
        if(absTolSizeType == SIZETYPE_FRACTIONOFBBOX)
            str = str + "SIZETYPE_FRACTIONOFBBOX";
        str = str + "\n";
        str = str + doubleToString("absTolAbsolute", absTolAbsolute, indent) + "\n";
        str = str + doubleToString("absTolBBox", absTolBBox, indent) + "\n";
        str = str + indent + "analysis = ";
        if(analysis == ANALYSISTYPE_NONE)
            str = str + "ANALYSISTYPE_NONE";
        if(analysis == ANALYSISTYPE_NORMAL)
            str = str + "ANALYSISTYPE_NORMAL";
        str = str + "\n";
        str = str + intToString("maximumToroidalWinding", maximumToroidalWinding, indent) + "\n";
        str = str + intToString("overrideToroidalWinding", overrideToroidalWinding, indent) + "\n";
        str = str + intToString("overridePoloidalWinding", overridePoloidalWinding, indent) + "\n";
        str = str + doubleToString("windingPairConfidence", windingPairConfidence, indent) + "\n";
        str = str + doubleToString("rationalSurfaceFactor", rationalSurfaceFactor, indent) + "\n";
        str = str + indent + "overlaps = ";
        if(overlaps == OVERLAPTYPE_RAW)
            str = str + "OVERLAPTYPE_RAW";
        if(overlaps == OVERLAPTYPE_REMOVE)
            str = str + "OVERLAPTYPE_REMOVE";
        if(overlaps == OVERLAPTYPE_MERGE)
            str = str + "OVERLAPTYPE_MERGE";
        if(overlaps == OVERLAPTYPE_SMOOTH)
            str = str + "OVERLAPTYPE_SMOOTH";
        str = str + "\n";
        str = str + indent + "meshType = ";
        if(meshType == SHOWMESHTYPE_CURVES)
            str = str + "SHOWMESHTYPE_CURVES";
        if(meshType == SHOWMESHTYPE_SURFACES)
            str = str + "SHOWMESHTYPE_SURFACES";
        str = str + "\n";
        str = str + intToString("numberPlanes", numberPlanes, indent) + "\n";
        str = str + doubleToString("singlePlane", singlePlane, indent) + "\n";
        str = str + doubleToString("min", min, indent) + "\n";
        str = str + doubleToString("max", max, indent) + "\n";
        str = str + boolToString("minFlag", minFlag, indent) + "\n";
        str = str + boolToString("maxFlag", maxFlag, indent) + "\n";
        str = str + indent + "colorType = ";
        if(colorType == COLORINGMETHOD_COLORBYSINGLECOLOR)
            str = str + "COLORINGMETHOD_COLORBYSINGLECOLOR";
        if(colorType == COLORINGMETHOD_COLORBYCOLORTABLE)
            str = str + "COLORINGMETHOD_COLORBYCOLORTABLE";
        str = str + "\n";
        str = str + indent + "singleColor = {" + singleColor.Red() + ", " + singleColor.Green() + ", " + singleColor.Blue() + ", " + singleColor.Alpha() + "}\n";
        str = str + stringToString("colorTableName", colorTableName, indent) + "\n";
        str = str + indent + "dataValue = ";
        if(dataValue == DATAVALUE_SOLID)
            str = str + "DATAVALUE_SOLID";
        if(dataValue == DATAVALUE_SAFETYFACTORQ)
            str = str + "DATAVALUE_SAFETYFACTORQ";
        if(dataValue == DATAVALUE_SAFETYFACTORP)
            str = str + "DATAVALUE_SAFETYFACTORP";
        if(dataValue == DATAVALUE_SAFETYFACTORQ_NOTP)
            str = str + "DATAVALUE_SAFETYFACTORQ_NOTP";
        if(dataValue == DATAVALUE_SAFETYFACTORP_NOTQ)
            str = str + "DATAVALUE_SAFETYFACTORP_NOTQ";
        if(dataValue == DATAVALUE_TOROIDALWINDINGS)
            str = str + "DATAVALUE_TOROIDALWINDINGS";
        if(dataValue == DATAVALUE_POLOIDALWINDINGSQ)
            str = str + "DATAVALUE_POLOIDALWINDINGSQ";
        if(dataValue == DATAVALUE_POLOIDALWINDINGSP)
            str = str + "DATAVALUE_POLOIDALWINDINGSP";
        if(dataValue == DATAVALUE_FIELDLINEORDER)
            str = str + "DATAVALUE_FIELDLINEORDER";
        if(dataValue == DATAVALUE_POINTORDER)
            str = str + "DATAVALUE_POINTORDER";
        if(dataValue == DATAVALUE_PLANEORDER)
            str = str + "DATAVALUE_PLANEORDER";
        if(dataValue == DATAVALUE_WINDINGGROUPORDER)
            str = str + "DATAVALUE_WINDINGGROUPORDER";
        if(dataValue == DATAVALUE_WINDINGPOINTORDER)
            str = str + "DATAVALUE_WINDINGPOINTORDER";
        if(dataValue == DATAVALUE_WINDINGPOINTORDERMODULO)
            str = str + "DATAVALUE_WINDINGPOINTORDERMODULO";
        str = str + "\n";
        str = str + boolToString("showRationalSurfaces", showRationalSurfaces, indent) + "\n";
        str = str + intToString("RationalSurfaceMaxIterations", RationalSurfaceMaxIterations, indent) + "\n";
        str = str + boolToString("showOPoints", showOPoints, indent) + "\n";
        str = str + intToString("OPointMaxIterations", OPointMaxIterations, indent) + "\n";
        str = str + boolToString("showXPoints", showXPoints, indent) + "\n";
        str = str + intToString("XPointMaxIterations", XPointMaxIterations, indent) + "\n";
        str = str + boolToString("performOLineAnalysis", performOLineAnalysis, indent) + "\n";
        str = str + intToString("OLineToroidalWinding", OLineToroidalWinding, indent) + "\n";
        str = str + stringToString("OLineAxisFileName", OLineAxisFileName, indent) + "\n";
        str = str + boolToString("showChaotic", showChaotic, indent) + "\n";
        str = str + boolToString("showIslands", showIslands, indent) + "\n";
        str = str + boolToString("SummaryFlag", SummaryFlag, indent) + "\n";
        str = str + boolToString("verboseFlag", verboseFlag, indent) + "\n";
        str = str + boolToString("show1DPlots", show1DPlots, indent) + "\n";
        str = str + boolToString("showLines", showLines, indent) + "\n";
        str = str + boolToString("showPoints", showPoints, indent) + "\n";
        str = str + indent + "parallelizationAlgorithmType = ";
        if(parallelizationAlgorithmType == PARALLELIZATIONALGORITHMTYPE_LOADONDEMAND)
            str = str + "PARALLELIZATIONALGORITHMTYPE_LOADONDEMAND";
        if(parallelizationAlgorithmType == PARALLELIZATIONALGORITHMTYPE_PARALLELSTATICDOMAINS)
            str = str + "PARALLELIZATIONALGORITHMTYPE_PARALLELSTATICDOMAINS";
        if(parallelizationAlgorithmType == PARALLELIZATIONALGORITHMTYPE_MASTERSLAVE)
            str = str + "PARALLELIZATIONALGORITHMTYPE_MASTERSLAVE";
        if(parallelizationAlgorithmType == PARALLELIZATIONALGORITHMTYPE_VISITSELECTS)
            str = str + "PARALLELIZATIONALGORITHMTYPE_VISITSELECTS";
        str = str + "\n";
        str = str + intToString("maxProcessCount", maxProcessCount, indent) + "\n";
        str = str + intToString("maxDomainCacheSize", maxDomainCacheSize, indent) + "\n";
        str = str + intToString("workGroupSize", workGroupSize, indent) + "\n";
        str = str + boolToString("pathlines", pathlines, indent) + "\n";
        str = str + boolToString("pathlinesOverrideStartingTimeFlag", pathlinesOverrideStartingTimeFlag, indent) + "\n";
        str = str + doubleToString("pathlinesOverrideStartingTime", pathlinesOverrideStartingTime, indent) + "\n";
        str = str + doubleToString("pathlinesPeriod", pathlinesPeriod, indent) + "\n";
        str = str + indent + "pathlinesCMFE = ";
        if(pathlinesCMFE == PATHLINESCMFE_CONN_CMFE)
            str = str + "PATHLINESCMFE_CONN_CMFE";
        if(pathlinesCMFE == PATHLINESCMFE_POS_CMFE)
            str = str + "PATHLINESCMFE_POS_CMFE";
        str = str + "\n";
        str = str + boolToString("issueTerminationWarnings", issueTerminationWarnings, indent) + "\n";
        str = str + boolToString("issueStepsizeWarnings", issueStepsizeWarnings, indent) + "\n";
        str = str + boolToString("issueStiffnessWarnings", issueStiffnessWarnings, indent) + "\n";
        str = str + boolToString("issueCriticalPointsWarnings", issueCriticalPointsWarnings, indent) + "\n";
        str = str + doubleToString("criticalPointThreshold", criticalPointThreshold, indent) + "\n";
        return str;
    }


    // Attributes
    private int            opacityType;
    private double         opacity;
    private int            minPunctures;
    private int            maxPunctures;
    private int            puncturePlotType;
    private int            maxSteps;
    private boolean        terminateByTime;
    private double         termTime;
    private double         puncturePeriodTolerance;
    private int            puncturePlane;
    private int            sourceType;
    private double[]       pointSource;
    private Vector         pointList; // vector of Double objects
    private double[]       lineStart;
    private double[]       lineEnd;
    private int            pointDensity;
    private int            fieldType;
    private boolean        forceNodeCenteredData;
    private double         fieldConstant;
    private double[]       velocitySource;
    private int            integrationType;
    private int            coordinateSystem;
    private double         maxStepLength;
    private boolean        limitMaximumTimestep;
    private double         maxTimeStep;
    private double         relTol;
    private int            absTolSizeType;
    private double         absTolAbsolute;
    private double         absTolBBox;
    private int            analysis;
    private int            maximumToroidalWinding;
    private int            overrideToroidalWinding;
    private int            overridePoloidalWinding;
    private double         windingPairConfidence;
    private double         rationalSurfaceFactor;
    private int            overlaps;
    private int            meshType;
    private int            numberPlanes;
    private double         singlePlane;
    private double         min;
    private double         max;
    private boolean        minFlag;
    private boolean        maxFlag;
    private int            colorType;
    private ColorAttribute singleColor;
    private String         colorTableName;
    private int            dataValue;
    private boolean        showRationalSurfaces;
    private int            RationalSurfaceMaxIterations;
    private boolean        showOPoints;
    private int            OPointMaxIterations;
    private boolean        showXPoints;
    private int            XPointMaxIterations;
    private boolean        performOLineAnalysis;
    private int            OLineToroidalWinding;
    private String         OLineAxisFileName;
    private boolean        showChaotic;
    private boolean        showIslands;
    private boolean        SummaryFlag;
    private boolean        verboseFlag;
    private boolean        show1DPlots;
    private boolean        showLines;
    private boolean        showPoints;
    private int            parallelizationAlgorithmType;
    private int            maxProcessCount;
    private int            maxDomainCacheSize;
    private int            workGroupSize;
    private boolean        pathlines;
    private boolean        pathlinesOverrideStartingTimeFlag;
    private double         pathlinesOverrideStartingTime;
    private double         pathlinesPeriod;
    private int            pathlinesCMFE;
    private boolean        issueTerminationWarnings;
    private boolean        issueStepsizeWarnings;
    private boolean        issueStiffnessWarnings;
    private boolean        issueCriticalPointsWarnings;
    private double         criticalPointThreshold;
}

