/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include "QvisChannelCommWindow.h"

#include <ChannelCommAttributes.h>

#include <QLabel>
#include <QLayout>
#include <QLineEdit>
#include <QvisVariableButton.h>


// ****************************************************************************
// Method: QvisChannelCommWindow::QvisChannelCommWindow
//
// Purpose: 
//   Constructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisChannelCommWindow::QvisChannelCommWindow(const int type,
                         ChannelCommAttributes *subj,
                         const QString &caption,
                         const QString &shortName,
                         QvisNotepadArea *notepad)
    : QvisOperatorWindow(type,subj, caption, shortName, notepad)
{
    atts = subj;
}


// ****************************************************************************
// Method: QvisChannelCommWindow::~QvisChannelCommWindow
//
// Purpose: 
//   Destructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisChannelCommWindow::~QvisChannelCommWindow()
{
}


// ****************************************************************************
// Method: QvisChannelCommWindow::CreateWindowContents
//
// Purpose: 
//   Creates the widgets for the window.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisChannelCommWindow::CreateWindowContents()
{
    QGridLayout *mainLayout = new QGridLayout(0);
    topLayout->addLayout(mainLayout);

    numInXLabel = new QLabel(tr("Number in X"), central);
    mainLayout->addWidget(numInXLabel,0,0);
    numInX = new QLineEdit(central);
    connect(numInX, SIGNAL(returnPressed()),
            this, SLOT(numInXProcessText()));
    mainLayout->addWidget(numInX, 0,1);

    numInYLabel = new QLabel(tr("Number in Y"), central);
    mainLayout->addWidget(numInYLabel,1,0);
    numInY = new QLineEdit(central);
    connect(numInY, SIGNAL(returnPressed()),
            this, SLOT(numInYProcessText()));
    mainLayout->addWidget(numInY, 1,1);

    velocityLabel = new QLabel(tr("velocity"), central);
    mainLayout->addWidget(velocityLabel,2,0);
    int velocityMask = QvisVariableButton::Vectors;
    velocity = new QvisVariableButton(true, true, true, velocityMask, central);
    connect(velocity, SIGNAL(activated(const QString&)),
            this, SLOT(velocityChanged(const QString&)));
    mainLayout->addWidget(velocity, 2,1);

}


// ****************************************************************************
// Method: QvisChannelCommWindow::UpdateWindow
//
// Purpose: 
//   Updates the widgets in the window when the subject changes.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisChannelCommWindow::UpdateWindow(bool doAll)
{

    for(int i = 0; i < atts->NumAttributes(); ++i)
    {
        if(!doAll)
        {
            if(!atts->IsSelected(i))
            {
                continue;
            }
        }

        switch(i)
        {
          case ChannelCommAttributes::ID_numInX:
            numInX->setText(IntToQString(atts->GetNumInX()));
            break;
          case ChannelCommAttributes::ID_numInY:
            numInY->setText(IntToQString(atts->GetNumInY()));
            break;
          case ChannelCommAttributes::ID_velocity:
            velocity->blockSignals(true);
            velocity->setText(QString(atts->GetVelocity().c_str()));
            velocity->blockSignals(false);
            break;
        }
    }
}


// ****************************************************************************
// Method: QvisChannelCommWindow::GetCurrentValues
//
// Purpose: 
//   Gets values from certain widgets and stores them in the subject.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisChannelCommWindow::GetCurrentValues(int which_widget)
{
    bool doAll = (which_widget == -1);

    // Do numInX
    if(which_widget == ChannelCommAttributes::ID_numInX || doAll)
    {
        int val;
        if(LineEditGetInt(numInX, val))
            atts->SetNumInX(val);
        else
        {
            ResettingError(tr("Number in X"),
                IntToQString(atts->GetNumInX()));
            atts->SetNumInX(atts->GetNumInX());
        }
    }

    // Do numInY
    if(which_widget == ChannelCommAttributes::ID_numInY || doAll)
    {
        int val;
        if(LineEditGetInt(numInY, val))
            atts->SetNumInY(val);
        else
        {
            ResettingError(tr("Number in Y"),
                IntToQString(atts->GetNumInY()));
            atts->SetNumInY(atts->GetNumInY());
        }
    }

}


//
// Qt Slot functions
//


void
QvisChannelCommWindow::numInXProcessText()
{
    GetCurrentValues(ChannelCommAttributes::ID_numInX);
    Apply();
}


void
QvisChannelCommWindow::numInYProcessText()
{
    GetCurrentValues(ChannelCommAttributes::ID_numInY);
    Apply();
}


void
QvisChannelCommWindow::velocityChanged(const QString &varName)
{
    atts->SetVelocity(varName.toStdString());
    SetUpdate(false);
    Apply();
}


