/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

// ************************************************************************* //
//                       avtWavefrontOBJWriter.C                             //
// ************************************************************************* //

#include <avtWavefrontOBJWriter.h>

#include <vector>

#include <vtkAlgorithm.h>
#include <vtkAppendPolyData.h>
#include <vtkDataSet.h>
#include <vtkGeometryFilter.h>
#include <vtkDataSetWriter.h>
#include <vtkPolyDataReader.h>
#include <vtkPolyDataWriter.h>
#include <vtkCharArray.h>
#include <vtkPolyData.h>
#include <vtkTriangleFilter.h>
#include <avtDatabaseMetaData.h>
#include <DBOptionsAttributes.h>
#include <vtkOBJWriter.h>

#include <avtDatabaseMetaData.h>
#include <DebugStream.h>
#include <avtParallelContext.h>

using     std::string;
using     std::vector;


// ****************************************************************************
//  Method: avtWavefrontOBJWriter constructor
//
//  Programmer: pugmire -- generated by xml2avt
//  Creation:   Tue Apr 16 08:33:21 PDT 2013
//
// ****************************************************************************

avtWavefrontOBJWriter::avtWavefrontOBJWriter(void)
{
}

// ****************************************************************************
//  Method: avtWavefrontOBJWriter::OpenFile
//
//  Purpose:
//      Does no actual work.  Just records the stem name for the files.
//
//  Programmer: pugmire -- generated by xml2avt
//  Creation:   Tue Apr 16 08:33:21 PDT 2013
//
// ****************************************************************************

void
avtWavefrontOBJWriter::OpenFile(const string &stemname, int numblocks)
{
    stem = stemname;
}


// ****************************************************************************
//  Method: avtWavefrontOBJWriter::WriteHeaders
//
//  Purpose:
//      Writes out a VisIt file to tie the WavefrontOBJ files together.
//
//  Programmer: pugmire -- generated by xml2avt
//  Creation:   Tue Apr 16 08:33:21 PDT 2013
//
// ****************************************************************************

void
avtWavefrontOBJWriter::WriteHeaders(const avtDatabaseMetaData *md,
                                    const vector<string> &scalars,
                                    const vector<string> &vectors,
                                    const vector<string> &materials)
{
    // WRITE OUT HEADER INFO
}


// ****************************************************************************
//  Method: avtWavefrontOBJWriter::WriteChunk
//
//  Purpose:
//      This writes out one chunk of an avtDataset.
//
//  Programmer: pugmire -- generated by xml2avt
//  Creation:   Tue Apr 16 08:33:21 PDT 2013
//
//  Modifications:
//    Brad Whitlock, Tue Sep  8 17:04:07 PDT 2015
//    Rely on base class for geometry consolidation. This method will only
//    be called on group leaders.
//
// ****************************************************************************

void
avtWavefrontOBJWriter::WriteChunk(vtkDataSet *ds, int chunk)
{
    std::string filename;
    if(writeContext.GroupSize() > 1)
    {
        char ext[20];
        SNPRINTF(ext, 20, ".%d.obj", writeContext.GroupRank());
        filename = stem + ext;
    }
    else
        filename = stem + ".obj";

    vtkOBJWriter *writer = vtkOBJWriter::New();  
    writer->SetFileName(filename.c_str());
    writer->SetInputData(ds);
    writer->Update();
    writer->Delete();
}

// ****************************************************************************
//  Method: avtWavefrontOBJWriter::CloseFile
//
//  Purpose:
//      Closes the file.  This does nothing in this case.
//
//  Programmer: pugmire -- generated by xml2avt
//  Creation:   Tue Apr 16 08:33:21 PDT 2013
//
// ****************************************************************************

void
avtWavefrontOBJWriter::CloseFile(void)
{
}

// ****************************************************************************
// Method: avtWavefrontOBJWriter::CreateTrianglePolyData
//
// Purpose:
//   Tell VisIt's export that we'll want triangles.
//
// Returns:    True
//
// Programmer: Brad Whitlock
// Creation:   Tue Sep  8 17:00:23 PDT 2015
//
// Modifications:
//
// ****************************************************************************

bool
avtWavefrontOBJWriter::CreateTrianglePolyData() const
{
    return true;
}

// ****************************************************************************
//  Method: avtTecplotWriter::GetCombineMode
//
//  Purpose:
//     Provides a hint to the export mechanism to tell it how to combine data.
//
//  Note: We combine geometry because WavefrontOBJ tools will want 1 file.
//
//  Programmer: Brad Whitlock
//  Creation:   Tue Sep  8 15:36:45 PDT 2015
//
// ****************************************************************************

avtDatabaseWriter::CombineMode
avtWavefrontOBJWriter::GetCombineMode(const std::string &) const
{
    return CombineAll;
}
