/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include "QvisSurfCompPrepWindow.h"

#include <SurfCompPrepAttributes.h>

#include <QLabel>
#include <QLayout>
#include <QLineEdit>
#include <QButtonGroup>
#include <QRadioButton>


// ****************************************************************************
// Method: QvisSurfCompPrepWindow::QvisSurfCompPrepWindow
//
// Purpose: 
//   Constructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisSurfCompPrepWindow::QvisSurfCompPrepWindow(const int type,
                         SurfCompPrepAttributes *subj,
                         const QString &caption,
                         const QString &shortName,
                         QvisNotepadArea *notepad)
    : QvisOperatorWindow(type,subj, caption, shortName, notepad)
{
    atts = subj;
}


// ****************************************************************************
// Method: QvisSurfCompPrepWindow::~QvisSurfCompPrepWindow
//
// Purpose: 
//   Destructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisSurfCompPrepWindow::~QvisSurfCompPrepWindow()
{
}


// ****************************************************************************
// Method: QvisSurfCompPrepWindow::CreateWindowContents
//
// Purpose: 
//   Creates the widgets for the window.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisSurfCompPrepWindow::CreateWindowContents()
{
    QGridLayout *mainLayout = new QGridLayout(0);
    topLayout->addLayout(mainLayout);

    surfaceTypeLabel = new QLabel(tr("Method for inferring surface"), central);
    mainLayout->addWidget(surfaceTypeLabel,0,0);
    QWidget *surfaceTypeWidget = new QWidget(central);
    surfaceType = new QButtonGroup(surfaceTypeWidget);
    QHBoxLayout *surfaceTypeLayout = new QHBoxLayout(surfaceTypeWidget);
    surfaceTypeLayout->setMargin(0);
    surfaceTypeLayout->setSpacing(10);
    QRadioButton *surfaceTypeSurfaceTypeClosest = new QRadioButton(tr("Closest"), surfaceTypeWidget);
    surfaceType->addButton(surfaceTypeSurfaceTypeClosest,0);
    surfaceTypeLayout->addWidget(surfaceTypeSurfaceTypeClosest);
    QRadioButton *surfaceTypeSurfaceTypeFarthest = new QRadioButton(tr("Farthest"), surfaceTypeWidget);
    surfaceType->addButton(surfaceTypeSurfaceTypeFarthest,1);
    surfaceTypeLayout->addWidget(surfaceTypeSurfaceTypeFarthest);
    QRadioButton *surfaceTypeSurfaceTypeAverage = new QRadioButton(tr("Average"), surfaceTypeWidget);
    surfaceType->addButton(surfaceTypeSurfaceTypeAverage,2);
    surfaceTypeLayout->addWidget(surfaceTypeSurfaceTypeAverage);
    connect(surfaceType, SIGNAL(buttonClicked(int)),
            this, SLOT(surfaceTypeChanged(int)));
    mainLayout->addWidget(surfaceTypeWidget, 0,1);

    coordSystemLabel = new QLabel(tr("Coordinate System"), central);
    mainLayout->addWidget(coordSystemLabel,1,0);
    
    QWidget *coordSystemWidget = new QWidget(central);
    coordSystem = new QButtonGroup(coordSystemWidget);
    QHBoxLayout *coordSystemLayout = new QHBoxLayout(coordSystemWidget);
    coordSystemLayout->setMargin(0);
    coordSystemLayout->setSpacing(10);
    QRadioButton *coordSystemCoordinateSystemCartesian = new QRadioButton(tr("Cartesian"), coordSystemWidget);
    coordSystem->addButton(coordSystemCoordinateSystemCartesian,0);
    coordSystemLayout->addWidget(coordSystemCoordinateSystemCartesian);
    QRadioButton *coordSystemCoordinateSystemCylindrical = new QRadioButton(tr("Cylindrical"), coordSystemWidget);
    coordSystem->addButton(coordSystemCoordinateSystemCylindrical,1);
    coordSystemLayout->addWidget(coordSystemCoordinateSystemCylindrical);
    QRadioButton *coordSystemCoordinateSystemSpherical = new QRadioButton(tr("Spherical"), coordSystemWidget);
    coordSystem->addButton(coordSystemCoordinateSystemSpherical,2);
    coordSystemLayout->addWidget(coordSystemCoordinateSystemSpherical);
    connect(coordSystem, SIGNAL(buttonClicked(int)),
            this, SLOT(coordSystemChanged(int)));
    mainLayout->addWidget(coordSystemWidget, 1,1);

    thetaStartLabel = new QLabel(tr("Start for Theta (degrees)"), central);
    mainLayout->addWidget(thetaStartLabel,2,0);
    thetaStart = new QLineEdit(central);
    connect(thetaStart, SIGNAL(returnPressed()),
            this, SLOT(thetaStartProcessText()));
    mainLayout->addWidget(thetaStart, 2,1);

    thetaStopLabel = new QLabel(tr("Stop for Theta (degrees)"), central);
    mainLayout->addWidget(thetaStopLabel,3,0);
    thetaStop = new QLineEdit(central);
    connect(thetaStop, SIGNAL(returnPressed()),
            this, SLOT(thetaStopProcessText()));
    mainLayout->addWidget(thetaStop, 3,1);

    thetaStepsLabel = new QLabel(tr("Number of samples in Theta"), central);
    mainLayout->addWidget(thetaStepsLabel,4,0);
    thetaSteps = new QLineEdit(central);
    connect(thetaSteps, SIGNAL(returnPressed()),
            this, SLOT(thetaStepsProcessText()));
    mainLayout->addWidget(thetaSteps, 4,1);

    phiStartLabel = new QLabel(tr("Start for Phi (degrees)"), central);
    mainLayout->addWidget(phiStartLabel,5,0);
    phiStart = new QLineEdit(central);
    connect(phiStart, SIGNAL(returnPressed()),
            this, SLOT(phiStartProcessText()));
    mainLayout->addWidget(phiStart, 5,1);

    phiStopLabel = new QLabel(tr("Stop for Phi (degrees)"), central);
    mainLayout->addWidget(phiStopLabel,6,0);
    phiStop = new QLineEdit(central);
    connect(phiStop, SIGNAL(returnPressed()),
            this, SLOT(phiStopProcessText()));
    mainLayout->addWidget(phiStop, 6,1);

    phiStepsLabel = new QLabel(tr("Number of samples in Phi"), central);
    mainLayout->addWidget(phiStepsLabel,7,0);
    phiSteps = new QLineEdit(central);
    connect(phiSteps, SIGNAL(returnPressed()),
            this, SLOT(phiStepsProcessText()));
    mainLayout->addWidget(phiSteps, 7,1);

    startRadiusLabel = new QLabel(tr("First radius to sample"), central);
    mainLayout->addWidget(startRadiusLabel,8,0);
    startRadius = new QLineEdit(central);
    connect(startRadius, SIGNAL(returnPressed()),
            this, SLOT(startRadiusProcessText()));
    mainLayout->addWidget(startRadius, 8,1);

    endRadiusLabel = new QLabel(tr("Last radius to sample"), central);
    mainLayout->addWidget(endRadiusLabel,9,0);
    endRadius = new QLineEdit(central);
    connect(endRadius, SIGNAL(returnPressed()),
            this, SLOT(endRadiusProcessText()));
    mainLayout->addWidget(endRadius, 9,1);

    radiusStepsLabel = new QLabel(tr("Number of samples in radius"), central);
    mainLayout->addWidget(radiusStepsLabel,10,0);
    radiusSteps = new QLineEdit(central);
    connect(radiusSteps, SIGNAL(returnPressed()),
            this, SLOT(radiusStepsProcessText()));
    mainLayout->addWidget(radiusSteps, 10,1);

    xStartLabel = new QLabel(tr("Starting point for X"), central);
    mainLayout->addWidget(xStartLabel,11,0);
    xStart = new QLineEdit(central);
    connect(xStart, SIGNAL(returnPressed()),
            this, SLOT(xStartProcessText()));
    mainLayout->addWidget(xStart, 11,1);

    xStopLabel = new QLabel(tr("Ending point for X"), central);
    mainLayout->addWidget(xStopLabel,12,0);
    xStop = new QLineEdit(central);
    connect(xStop, SIGNAL(returnPressed()),
            this, SLOT(xStopProcessText()));
    mainLayout->addWidget(xStop, 12,1);

    xStepsLabel = new QLabel(tr("Number of steps in X"), central);
    mainLayout->addWidget(xStepsLabel,13,0);
    xSteps = new QLineEdit(central);
    connect(xSteps, SIGNAL(returnPressed()),
            this, SLOT(xStepsProcessText()));
    mainLayout->addWidget(xSteps, 13,1);

    yStartLabel = new QLabel(tr("Starting point for Y"), central);
    mainLayout->addWidget(yStartLabel,14,0);
    yStart = new QLineEdit(central);
    connect(yStart, SIGNAL(returnPressed()),
            this, SLOT(yStartProcessText()));
    mainLayout->addWidget(yStart, 14,1);

    yStopLabel = new QLabel(tr("Ending point for Y"), central);
    mainLayout->addWidget(yStopLabel,15,0);
    yStop = new QLineEdit(central);
    connect(yStop, SIGNAL(returnPressed()),
            this, SLOT(yStopProcessText()));
    mainLayout->addWidget(yStop, 15,1);

    yStepsLabel = new QLabel(tr("Number of steps in Y"), central);
    mainLayout->addWidget(yStepsLabel,16,0);
    ySteps = new QLineEdit(central);
    connect(ySteps, SIGNAL(returnPressed()),
            this, SLOT(yStepsProcessText()));
    mainLayout->addWidget(ySteps, 16,1);

    zStartLabel = new QLabel(tr("Starting point for Z"), central);
    mainLayout->addWidget(zStartLabel,17,0);
    zStart = new QLineEdit(central);
    connect(zStart, SIGNAL(returnPressed()),
            this, SLOT(zStartProcessText()));
    mainLayout->addWidget(zStart, 17,1);

    zStopLabel = new QLabel(tr("Ending point for Z"), central);
    mainLayout->addWidget(zStopLabel,18,0);
    zStop = new QLineEdit(central);
    connect(zStop, SIGNAL(returnPressed()),
            this, SLOT(zStopProcessText()));
    mainLayout->addWidget(zStop, 18,1);

    zStepsLabel = new QLabel(tr("Number of steps in Z"), central);
    mainLayout->addWidget(zStepsLabel,19,0);
    zSteps = new QLineEdit(central);
    connect(zSteps, SIGNAL(returnPressed()),
            this, SLOT(zStepsProcessText()));
    mainLayout->addWidget(zSteps, 19,1);

}


// ****************************************************************************
// Method: QvisSurfCompPrepWindow::UpdateWindow
//
// Purpose: 
//   Updates the widgets in the window when the subject changes.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisSurfCompPrepWindow::UpdateWindow(bool doAll)
{

    for(int i = 0; i < atts->NumAttributes(); ++i)
    {
        if(!doAll)
        {
            if(!atts->IsSelected(i))
            {
                continue;
            }
        }

        switch(i)
        {
          case SurfCompPrepAttributes::ID_surfaceType:
            surfaceType->blockSignals(true);
            if(surfaceType->button((int)atts->GetSurfaceType()) != 0)
                surfaceType->button((int)atts->GetSurfaceType())->setChecked(true);
            surfaceType->blockSignals(false);
            break;
          case SurfCompPrepAttributes::ID_coordSystem:
            if (atts->GetCoordSystem() == SurfCompPrepAttributes::Spherical || atts->GetCoordSystem() == SurfCompPrepAttributes::Cylindrical)
            {
                thetaStart->setEnabled(true);
                if(thetaStartLabel)
                    thetaStartLabel->setEnabled(true);
            }
            else
            {
                thetaStart->setEnabled(false);
                if(thetaStartLabel)
                    thetaStartLabel->setEnabled(false);
            }
            if (atts->GetCoordSystem() == SurfCompPrepAttributes::Spherical || atts->GetCoordSystem() == SurfCompPrepAttributes::Cylindrical)
            {
                thetaStop->setEnabled(true);
                if(thetaStopLabel)
                    thetaStopLabel->setEnabled(true);
            }
            else
            {
                thetaStop->setEnabled(false);
                if(thetaStopLabel)
                    thetaStopLabel->setEnabled(false);
            }
            if (atts->GetCoordSystem() == SurfCompPrepAttributes::Spherical || atts->GetCoordSystem() == SurfCompPrepAttributes::Cylindrical)
            {
                thetaSteps->setEnabled(true);
                if(thetaStepsLabel)
                    thetaStepsLabel->setEnabled(true);
            }
            else
            {
                thetaSteps->setEnabled(false);
                if(thetaStepsLabel)
                    thetaStepsLabel->setEnabled(false);
            }
            if (atts->GetCoordSystem() == SurfCompPrepAttributes::Spherical)
            {
                phiStart->setEnabled(true);
                if(phiStartLabel)
                    phiStartLabel->setEnabled(true);
            }
            else
            {
                phiStart->setEnabled(false);
                if(phiStartLabel)
                    phiStartLabel->setEnabled(false);
            }
            if (atts->GetCoordSystem() == SurfCompPrepAttributes::Spherical)
            {
                phiStop->setEnabled(true);
                if(phiStopLabel)
                    phiStopLabel->setEnabled(true);
            }
            else
            {
                phiStop->setEnabled(false);
                if(phiStopLabel)
                    phiStopLabel->setEnabled(false);
            }
            if (atts->GetCoordSystem() == SurfCompPrepAttributes::Spherical)
            {
                phiSteps->setEnabled(true);
                if(phiStepsLabel)
                    phiStepsLabel->setEnabled(true);
            }
            else
            {
                phiSteps->setEnabled(false);
                if(phiStepsLabel)
                    phiStepsLabel->setEnabled(false);
            }
            if (atts->GetCoordSystem() == SurfCompPrepAttributes::Cylindrical || atts->GetCoordSystem() == SurfCompPrepAttributes::Spherical)
            {
                startRadius->setEnabled(true);
                if(startRadiusLabel)
                    startRadiusLabel->setEnabled(true);
            }
            else
            {
                startRadius->setEnabled(false);
                if(startRadiusLabel)
                    startRadiusLabel->setEnabled(false);
            }
            if (atts->GetCoordSystem() == SurfCompPrepAttributes::Cylindrical || atts->GetCoordSystem() == SurfCompPrepAttributes::Spherical)
            {
                endRadius->setEnabled(true);
                if(endRadiusLabel)
                    endRadiusLabel->setEnabled(true);
            }
            else
            {
                endRadius->setEnabled(false);
                if(endRadiusLabel)
                    endRadiusLabel->setEnabled(false);
            }
            if (atts->GetCoordSystem() == SurfCompPrepAttributes::Cylindrical || atts->GetCoordSystem() == SurfCompPrepAttributes::Spherical)
            {
                radiusSteps->setEnabled(true);
                if(radiusStepsLabel)
                    radiusStepsLabel->setEnabled(true);
            }
            else
            {
                radiusSteps->setEnabled(false);
                if(radiusStepsLabel)
                    radiusStepsLabel->setEnabled(false);
            }
            if (atts->GetCoordSystem() == SurfCompPrepAttributes::Cartesian)
            {
                xStart->setEnabled(true);
                if(xStartLabel)
                    xStartLabel->setEnabled(true);
            }
            else
            {
                xStart->setEnabled(false);
                if(xStartLabel)
                    xStartLabel->setEnabled(false);
            }
            if (atts->GetCoordSystem() == SurfCompPrepAttributes::Cartesian)
            {
                xStop->setEnabled(true);
                if(xStopLabel)
                    xStopLabel->setEnabled(true);
            }
            else
            {
                xStop->setEnabled(false);
                if(xStopLabel)
                    xStopLabel->setEnabled(false);
            }
            if (atts->GetCoordSystem() == SurfCompPrepAttributes::Cartesian)
            {
                xSteps->setEnabled(true);
                if(xStepsLabel)
                    xStepsLabel->setEnabled(true);
            }
            else
            {
                xSteps->setEnabled(false);
                if(xStepsLabel)
                    xStepsLabel->setEnabled(false);
            }
            if (atts->GetCoordSystem() == SurfCompPrepAttributes::Cartesian)
            {
                yStart->setEnabled(true);
                if(yStartLabel)
                    yStartLabel->setEnabled(true);
            }
            else
            {
                yStart->setEnabled(false);
                if(yStartLabel)
                    yStartLabel->setEnabled(false);
            }
            if (atts->GetCoordSystem() == SurfCompPrepAttributes::Cartesian)
            {
                yStop->setEnabled(true);
                if(yStopLabel)
                    yStopLabel->setEnabled(true);
            }
            else
            {
                yStop->setEnabled(false);
                if(yStopLabel)
                    yStopLabel->setEnabled(false);
            }
            if (atts->GetCoordSystem() == SurfCompPrepAttributes::Cartesian)
            {
                ySteps->setEnabled(true);
                if(yStepsLabel)
                    yStepsLabel->setEnabled(true);
            }
            else
            {
                ySteps->setEnabled(false);
                if(yStepsLabel)
                    yStepsLabel->setEnabled(false);
            }
            if (atts->GetCoordSystem() == SurfCompPrepAttributes::Cartesian || atts->GetCoordSystem() == SurfCompPrepAttributes::Cylindrical)
            {
                zStart->setEnabled(true);
                if(zStartLabel)
                    zStartLabel->setEnabled(true);
            }
            else
            {
                zStart->setEnabled(false);
                if(zStartLabel)
                    zStartLabel->setEnabled(false);
            }
            if (atts->GetCoordSystem() == SurfCompPrepAttributes::Cartesian || atts->GetCoordSystem() == SurfCompPrepAttributes::Cylindrical)
            {
                zStop->setEnabled(true);
                if(zStopLabel)
                    zStopLabel->setEnabled(true);
            }
            else
            {
                zStop->setEnabled(false);
                if(zStopLabel)
                    zStopLabel->setEnabled(false);
            }
            if (atts->GetCoordSystem() == SurfCompPrepAttributes::Cartesian || atts->GetCoordSystem() == SurfCompPrepAttributes::Cylindrical)
            {
                zSteps->setEnabled(true);
                if(zStepsLabel)
                    zStepsLabel->setEnabled(true);
            }
            else
            {
                zSteps->setEnabled(false);
                if(zStepsLabel)
                    zStepsLabel->setEnabled(false);
            }
            coordSystem->blockSignals(true);
            if(coordSystem->button((int)atts->GetCoordSystem()) != 0)
                coordSystem->button((int)atts->GetCoordSystem())->setChecked(true);
            coordSystem->blockSignals(false);
            break;
          case SurfCompPrepAttributes::ID_thetaStart:
            thetaStart->setText(DoubleToQString(atts->GetThetaStart()));
            break;
          case SurfCompPrepAttributes::ID_thetaStop:
            thetaStop->setText(DoubleToQString(atts->GetThetaStop()));
            break;
          case SurfCompPrepAttributes::ID_thetaSteps:
            thetaSteps->setText(IntToQString(atts->GetThetaSteps()));
            break;
          case SurfCompPrepAttributes::ID_phiStart:
            phiStart->setText(DoubleToQString(atts->GetPhiStart()));
            break;
          case SurfCompPrepAttributes::ID_phiStop:
            phiStop->setText(DoubleToQString(atts->GetPhiStop()));
            break;
          case SurfCompPrepAttributes::ID_phiSteps:
            phiSteps->setText(IntToQString(atts->GetPhiSteps()));
            break;
          case SurfCompPrepAttributes::ID_startRadius:
            startRadius->setText(DoubleToQString(atts->GetStartRadius()));
            break;
          case SurfCompPrepAttributes::ID_endRadius:
            endRadius->setText(DoubleToQString(atts->GetEndRadius()));
            break;
          case SurfCompPrepAttributes::ID_radiusSteps:
            radiusSteps->setText(IntToQString(atts->GetRadiusSteps()));
            break;
          case SurfCompPrepAttributes::ID_xStart:
            xStart->setText(DoubleToQString(atts->GetXStart()));
            break;
          case SurfCompPrepAttributes::ID_xStop:
            xStop->setText(DoubleToQString(atts->GetXStop()));
            break;
          case SurfCompPrepAttributes::ID_xSteps:
            xSteps->setText(IntToQString(atts->GetXSteps()));
            break;
          case SurfCompPrepAttributes::ID_yStart:
            yStart->setText(DoubleToQString(atts->GetYStart()));
            break;
          case SurfCompPrepAttributes::ID_yStop:
            yStop->setText(DoubleToQString(atts->GetYStop()));
            break;
          case SurfCompPrepAttributes::ID_ySteps:
            ySteps->setText(IntToQString(atts->GetYSteps()));
            break;
          case SurfCompPrepAttributes::ID_zStart:
            zStart->setText(DoubleToQString(atts->GetZStart()));
            break;
          case SurfCompPrepAttributes::ID_zStop:
            zStop->setText(DoubleToQString(atts->GetZStop()));
            break;
          case SurfCompPrepAttributes::ID_zSteps:
            zSteps->setText(IntToQString(atts->GetZSteps()));
            break;
        }
    }
}


// ****************************************************************************
// Method: QvisSurfCompPrepWindow::GetCurrentValues
//
// Purpose: 
//   Gets values from certain widgets and stores them in the subject.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisSurfCompPrepWindow::GetCurrentValues(int which_widget)
{
    bool doAll = (which_widget == -1);

    // Do thetaStart
    if(which_widget == SurfCompPrepAttributes::ID_thetaStart || doAll)
    {
        double val;
        if(LineEditGetDouble(thetaStart, val))
            atts->SetThetaStart(val);
        else
        {
            ResettingError(tr("Start for Theta (degrees)"),
                DoubleToQString(atts->GetThetaStart()));
            atts->SetThetaStart(atts->GetThetaStart());
        }
    }

    // Do thetaStop
    if(which_widget == SurfCompPrepAttributes::ID_thetaStop || doAll)
    {
        double val;
        if(LineEditGetDouble(thetaStop, val))
            atts->SetThetaStop(val);
        else
        {
            ResettingError(tr("Stop for Theta (degrees)"),
                DoubleToQString(atts->GetThetaStop()));
            atts->SetThetaStop(atts->GetThetaStop());
        }
    }

    // Do thetaSteps
    if(which_widget == SurfCompPrepAttributes::ID_thetaSteps || doAll)
    {
        int val;
        if(LineEditGetInt(thetaSteps, val))
            atts->SetThetaSteps(val);
        else
        {
            ResettingError(tr("Number of samples in Theta"),
                IntToQString(atts->GetThetaSteps()));
            atts->SetThetaSteps(atts->GetThetaSteps());
        }
    }

    // Do phiStart
    if(which_widget == SurfCompPrepAttributes::ID_phiStart || doAll)
    {
        double val;
        if(LineEditGetDouble(phiStart, val))
            atts->SetPhiStart(val);
        else
        {
            ResettingError(tr("Start for Phi (degrees)"),
                DoubleToQString(atts->GetPhiStart()));
            atts->SetPhiStart(atts->GetPhiStart());
        }
    }

    // Do phiStop
    if(which_widget == SurfCompPrepAttributes::ID_phiStop || doAll)
    {
        double val;
        if(LineEditGetDouble(phiStop, val))
            atts->SetPhiStop(val);
        else
        {
            ResettingError(tr("Stop for Phi (degrees)"),
                DoubleToQString(atts->GetPhiStop()));
            atts->SetPhiStop(atts->GetPhiStop());
        }
    }

    // Do phiSteps
    if(which_widget == SurfCompPrepAttributes::ID_phiSteps || doAll)
    {
        int val;
        if(LineEditGetInt(phiSteps, val))
            atts->SetPhiSteps(val);
        else
        {
            ResettingError(tr("Number of samples in Phi"),
                IntToQString(atts->GetPhiSteps()));
            atts->SetPhiSteps(atts->GetPhiSteps());
        }
    }

    // Do startRadius
    if(which_widget == SurfCompPrepAttributes::ID_startRadius || doAll)
    {
        double val;
        if(LineEditGetDouble(startRadius, val))
            atts->SetStartRadius(val);
        else
        {
            ResettingError(tr("First radius to sample"),
                DoubleToQString(atts->GetStartRadius()));
            atts->SetStartRadius(atts->GetStartRadius());
        }
    }

    // Do endRadius
    if(which_widget == SurfCompPrepAttributes::ID_endRadius || doAll)
    {
        double val;
        if(LineEditGetDouble(endRadius, val))
            atts->SetEndRadius(val);
        else
        {
            ResettingError(tr("Last radius to sample"),
                DoubleToQString(atts->GetEndRadius()));
            atts->SetEndRadius(atts->GetEndRadius());
        }
    }

    // Do radiusSteps
    if(which_widget == SurfCompPrepAttributes::ID_radiusSteps || doAll)
    {
        int val;
        if(LineEditGetInt(radiusSteps, val))
            atts->SetRadiusSteps(val);
        else
        {
            ResettingError(tr("Number of samples in radius"),
                IntToQString(atts->GetRadiusSteps()));
            atts->SetRadiusSteps(atts->GetRadiusSteps());
        }
    }

    // Do xStart
    if(which_widget == SurfCompPrepAttributes::ID_xStart || doAll)
    {
        double val;
        if(LineEditGetDouble(xStart, val))
            atts->SetXStart(val);
        else
        {
            ResettingError(tr("Starting point for X"),
                DoubleToQString(atts->GetXStart()));
            atts->SetXStart(atts->GetXStart());
        }
    }

    // Do xStop
    if(which_widget == SurfCompPrepAttributes::ID_xStop || doAll)
    {
        double val;
        if(LineEditGetDouble(xStop, val))
            atts->SetXStop(val);
        else
        {
            ResettingError(tr("Ending point for X"),
                DoubleToQString(atts->GetXStop()));
            atts->SetXStop(atts->GetXStop());
        }
    }

    // Do xSteps
    if(which_widget == SurfCompPrepAttributes::ID_xSteps || doAll)
    {
        int val;
        if(LineEditGetInt(xSteps, val))
            atts->SetXSteps(val);
        else
        {
            ResettingError(tr("Number of steps in X"),
                IntToQString(atts->GetXSteps()));
            atts->SetXSteps(atts->GetXSteps());
        }
    }

    // Do yStart
    if(which_widget == SurfCompPrepAttributes::ID_yStart || doAll)
    {
        double val;
        if(LineEditGetDouble(yStart, val))
            atts->SetYStart(val);
        else
        {
            ResettingError(tr("Starting point for Y"),
                DoubleToQString(atts->GetYStart()));
            atts->SetYStart(atts->GetYStart());
        }
    }

    // Do yStop
    if(which_widget == SurfCompPrepAttributes::ID_yStop || doAll)
    {
        double val;
        if(LineEditGetDouble(yStop, val))
            atts->SetYStop(val);
        else
        {
            ResettingError(tr("Ending point for Y"),
                DoubleToQString(atts->GetYStop()));
            atts->SetYStop(atts->GetYStop());
        }
    }

    // Do ySteps
    if(which_widget == SurfCompPrepAttributes::ID_ySteps || doAll)
    {
        int val;
        if(LineEditGetInt(ySteps, val))
            atts->SetYSteps(val);
        else
        {
            ResettingError(tr("Number of steps in Y"),
                IntToQString(atts->GetYSteps()));
            atts->SetYSteps(atts->GetYSteps());
        }
    }

    // Do zStart
    if(which_widget == SurfCompPrepAttributes::ID_zStart || doAll)
    {
        double val;
        if(LineEditGetDouble(zStart, val))
            atts->SetZStart(val);
        else
        {
            ResettingError(tr("Starting point for Z"),
                DoubleToQString(atts->GetZStart()));
            atts->SetZStart(atts->GetZStart());
        }
    }

    // Do zStop
    if(which_widget == SurfCompPrepAttributes::ID_zStop || doAll)
    {
        double val;
        if(LineEditGetDouble(zStop, val))
            atts->SetZStop(val);
        else
        {
            ResettingError(tr("Ending point for Z"),
                DoubleToQString(atts->GetZStop()));
            atts->SetZStop(atts->GetZStop());
        }
    }

    // Do zSteps
    if(which_widget == SurfCompPrepAttributes::ID_zSteps || doAll)
    {
        int val;
        if(LineEditGetInt(zSteps, val))
            atts->SetZSteps(val);
        else
        {
            ResettingError(tr("Number of steps in Z"),
                IntToQString(atts->GetZSteps()));
            atts->SetZSteps(atts->GetZSteps());
        }
    }

}


//
// Qt Slot functions
//


void
QvisSurfCompPrepWindow::surfaceTypeChanged(int val)
{
    if(val != atts->GetSurfaceType())
    {
        atts->SetSurfaceType(SurfCompPrepAttributes::SurfaceType(val));
        SetUpdate(false);
        Apply();
    }
}


void
QvisSurfCompPrepWindow::coordSystemChanged(int val)
{
    if(val != atts->GetCoordSystem())
    {
        atts->SetCoordSystem(SurfCompPrepAttributes::CoordinateSystem(val));
        Apply();
    }
}


void
QvisSurfCompPrepWindow::thetaStartProcessText()
{
    GetCurrentValues(SurfCompPrepAttributes::ID_thetaStart);
    Apply();
}


void
QvisSurfCompPrepWindow::thetaStopProcessText()
{
    GetCurrentValues(SurfCompPrepAttributes::ID_thetaStop);
    Apply();
}


void
QvisSurfCompPrepWindow::thetaStepsProcessText()
{
    GetCurrentValues(SurfCompPrepAttributes::ID_thetaSteps);
    Apply();
}


void
QvisSurfCompPrepWindow::phiStartProcessText()
{
    GetCurrentValues(SurfCompPrepAttributes::ID_phiStart);
    Apply();
}


void
QvisSurfCompPrepWindow::phiStopProcessText()
{
    GetCurrentValues(SurfCompPrepAttributes::ID_phiStop);
    Apply();
}


void
QvisSurfCompPrepWindow::phiStepsProcessText()
{
    GetCurrentValues(SurfCompPrepAttributes::ID_phiSteps);
    Apply();
}


void
QvisSurfCompPrepWindow::startRadiusProcessText()
{
    GetCurrentValues(SurfCompPrepAttributes::ID_startRadius);
    Apply();
}


void
QvisSurfCompPrepWindow::endRadiusProcessText()
{
    GetCurrentValues(SurfCompPrepAttributes::ID_endRadius);
    Apply();
}


void
QvisSurfCompPrepWindow::radiusStepsProcessText()
{
    GetCurrentValues(SurfCompPrepAttributes::ID_radiusSteps);
    Apply();
}


void
QvisSurfCompPrepWindow::xStartProcessText()
{
    GetCurrentValues(SurfCompPrepAttributes::ID_xStart);
    Apply();
}


void
QvisSurfCompPrepWindow::xStopProcessText()
{
    GetCurrentValues(SurfCompPrepAttributes::ID_xStop);
    Apply();
}


void
QvisSurfCompPrepWindow::xStepsProcessText()
{
    GetCurrentValues(SurfCompPrepAttributes::ID_xSteps);
    Apply();
}


void
QvisSurfCompPrepWindow::yStartProcessText()
{
    GetCurrentValues(SurfCompPrepAttributes::ID_yStart);
    Apply();
}


void
QvisSurfCompPrepWindow::yStopProcessText()
{
    GetCurrentValues(SurfCompPrepAttributes::ID_yStop);
    Apply();
}


void
QvisSurfCompPrepWindow::yStepsProcessText()
{
    GetCurrentValues(SurfCompPrepAttributes::ID_ySteps);
    Apply();
}


void
QvisSurfCompPrepWindow::zStartProcessText()
{
    GetCurrentValues(SurfCompPrepAttributes::ID_zStart);
    Apply();
}


void
QvisSurfCompPrepWindow::zStopProcessText()
{
    GetCurrentValues(SurfCompPrepAttributes::ID_zStop);
    Apply();
}


void
QvisSurfCompPrepWindow::zStepsProcessText()
{
    GetCurrentValues(SurfCompPrepAttributes::ID_zSteps);
    Apply();
}


