/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyProgrammableOpAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PyProgrammableOpAttributes
//
// Purpose: 
//   ProgrammableOpAttributes
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a ProgrammableOpAttributes.
//
struct ProgrammableOpAttributesObject
{
    PyObject_HEAD
    ProgrammableOpAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewProgrammableOpAttributes(int);

std::string
PyProgrammableOpAttributes_ToString(const ProgrammableOpAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    SNPRINTF(tmpStr, 1000, "%sscriptMap = \"%s\"\n", prefix, atts->GetScriptMap().c_str());
    str += tmpStr;
    return str;
}

static PyObject *
ProgrammableOpAttributes_Notify(PyObject *self, PyObject *args)
{
    ProgrammableOpAttributesObject *obj = (ProgrammableOpAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ProgrammableOpAttributes_SetScriptMap(PyObject *self, PyObject *args)
{
    ProgrammableOpAttributesObject *obj = (ProgrammableOpAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the scriptMap in the object.
    obj->data->SetScriptMap(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
ProgrammableOpAttributes_GetScriptMap(PyObject *self, PyObject *args)
{
    ProgrammableOpAttributesObject *obj = (ProgrammableOpAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetScriptMap().c_str());
    return retval;
}


PyObject* ScriptVisItError = PyErr_NewException((char*)"visit.ScriptException", NULL, NULL);

void
VisItErrorFunc(const char *errString)
{
    PyErr_SetString(ScriptVisItError, errString);
}

/*static*/ PyObject *
VisItErrorFuncX(PyObject *self, PyObject *args)
{
    Py_INCREF(Py_None);
    return Py_None;
}

bool
GetJSONVectorFromPyObject(PyObject *obj, JSONNode &vec)
{
    bool retval = true;

    if(obj == 0)
    {
        retval = false;
    }
    else if(PyBool_Check(obj))
    {
        vec = obj == Py_True ? true : false;
    }
    else if(PyTuple_Check(obj))
    {
        // Extract arguments from the tuple.
        vec = JSONNode::JSONArray();

        for(int i = 0; i < PyTuple_Size(obj); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(obj, i);
            JSONNode node;
            if(!GetJSONVectorFromPyObject(item,node))
                return false;
            vec.Append(node);
        }
    }
    else if(PyList_Check(obj))
    {
        vec = JSONNode::JSONArray();

        // Extract arguments from the list.
        for(int i = 0; i < PyList_Size(obj); ++i)
        {
            PyObject *item = PyList_GET_ITEM(obj, i);
            JSONNode node;
            if(!GetJSONVectorFromPyObject(item,node))
                return false;
            vec.Append(node);
        }
    }
    else if(PyString_Check(obj))
    {
        vec = PyString_AS_STRING(obj);
    }
    else if(PyInt_Check(obj))
    {
        vec = PyInt_AsLong(obj);
    }
    else if(PyFloat_Check(obj))
    {
        vec = PyFloat_AsDouble(obj);
    }
    else if(PyDict_Check(obj))
    {
        vec = JSONNode::JSONObject();

        PyObject* keys = PyDict_Keys(obj);
        for(int i = 0; i < PyList_Size(keys); ++i)
        {
            PyObject *item = PyList_GET_ITEM(keys, i);
            if(!PyString_Check(item))
            {
                std::cerr << "unknown element type, skipping " << std::endl;
                continue;
            }

            JSONNode node;

            std::string key = PyString_AsString(item);

            PyObject *value = PyDict_GetItem(obj,item);
            if(!GetJSONVectorFromPyObject(value,node))
                return false;
            vec[key] = node;
        }
    }
    else
    {
        retval = false;
        VisItErrorFunc("The object could not be converted to a "
                       "vector of strings.");
    }

    return retval;
}

/*static*/ PyObject *
GetJSONVectorFromPyObjectX(PyObject *self, PyObject *args)
{
    Py_INCREF(Py_None);
    return Py_None;
}

bool
GetStringVectorFromPyObject(PyObject *obj, stringVector &vec)
{
    bool retval = true;

    if(obj == 0)
    {
        retval = false;
    }
    else if(PyTuple_Check(obj))
    {
        // Extract arguments from the tuple.
        for(int i = 0; i < PyTuple_Size(obj); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(obj, i);
            if(PyString_Check(item))
                vec.push_back(PyString_AS_STRING(item));
            else
            {
                VisItErrorFunc("The tuple must contain all strings.");
                retval = false;
                break;
            }
        }
    }
    else if(PyList_Check(obj))
    {
        // Extract arguments from the list.
        for(int i = 0; i < PyList_Size(obj); ++i)
        {
            PyObject *item = PyList_GET_ITEM(obj, i);
            if(PyString_Check(item))
                vec.push_back(PyString_AS_STRING(item));
            else
            {
                VisItErrorFunc("The list must contain all strings.");
                retval = false;
                break;
            }
        }
    }
    else if(PyString_Check(obj))
    {
        vec.push_back(PyString_AS_STRING(obj));
    }
    else
    {
        retval = false;
        VisItErrorFunc("The object could not be converted to a "
                       "vector of strings.");
    }

    return retval;
}

/*static*/ PyObject *
GetStringVectorFromPyObjectX(PyObject *self, PyObject *args)
{
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
AddConstant(PyObject *self, PyObject *args)
{
    ProgrammableOpAttributesObject *obj = (ProgrammableOpAttributesObject *)self;

    const char *name = 0;
    const char *constant = 0;


    if(!PyArg_ParseTuple(args, "ss", &name,&constant))
    {
        VisItErrorFunc("Arguments are ('name', 'constant')");
        return NULL;
    }

    obj->data->AddConstant(name,constant);

    Py_INCREF(Py_None);
    return Py_None;
}


/*static*/ PyObject *
AddFunction(PyObject *self, PyObject *args)
{
    ProgrammableOpAttributesObject *obj = (ProgrammableOpAttributesObject *)self;

    const char *name = 0;
    PyObject* arglist = 0;
    stringVector vec;

    if(!PyArg_ParseTuple(args, "sO", &name,&arglist))
    {
        VisItErrorFunc("Arguments are ('name',('arg1','arg2',...))");
        return NULL;
    }

    if(!GetStringVectorFromPyObject(arglist,vec))
    {
        VisItErrorFunc("Arguments are ('name',('arg1','arg2',...))");
        return NULL;
    }

    obj->data->AddFunction(name,vec);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
AddRScript(PyObject *self, PyObject *args)
{
    ProgrammableOpAttributesObject *obj = (ProgrammableOpAttributesObject *)self;

    const char *name = 0;
    const char *code = 0;
    PyObject* arglist = 0;
    stringVector vec;

    if(!PyArg_ParseTuple(args, "sOs", &name,&arglist,&code))
    {
        VisItErrorFunc("Arguments are ('name',('arg1','arg2',...), 'code')");
        return NULL;
    }

    if(!GetStringVectorFromPyObject(arglist,vec))
    {
        VisItErrorFunc("Arguments are ('name',('arg1','arg2',...), 'code')");
        return NULL;
    }

    obj->data->AddRScript(name,vec,code);
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
AddPythonScript(PyObject *self, PyObject *args)
{
    ProgrammableOpAttributesObject *obj = (ProgrammableOpAttributesObject *)self;

    const char *name = 0;
    const char *code = 0;
    PyObject* arglist = 0;
    stringVector vec;

    if(!PyArg_ParseTuple(args, "sOs", &name,&arglist,&code))
    {
        VisItErrorFunc("Arguments are ('name',('arg1','arg2',...), 'code')");
        return NULL;
    }

    if(!GetStringVectorFromPyObject(arglist,vec))
    {
        VisItErrorFunc("Arguments are ('name',('arg1','arg2',...), 'code')");
        return NULL;
    }

    obj->data->AddPythonScript(name,vec,code);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
AddNode(PyObject *self, PyObject *args)
{
    ProgrammableOpAttributesObject *obj = (ProgrammableOpAttributesObject *)self;
    const char* name = 0;
    const char* type = 0;
    //wrap this in a function..
    if(!PyArg_ParseTuple(args, "ss", &name,&type))
    {
        VisItErrorFunc("Arguments are ('name', '[script_name|as_ndarray|as_vtkarray|as_rarray]')");
        return NULL;
    }

    obj->data->AddNode(name,type);

    /*
    std::string node_type = type;
    if(!obj->node["scripts"].HasKey(node_type) &&
             node_type != "as_ndarray" &&
             node_type != "as_vtkarray" &&
             node_type != "as_rarray")
    {
        VisItErrorFunc("Type must be [script_name|as_ndarray|as_vtkarray|as_rarray]')");
        return NULL;
    }

    JSONNode node;
    node["type"] = node_type;
    obj->node["nodes"][name] = node;

    MapNode mapnode;
    mapnode["filter"] = obj->node.ToString();
    obj->data->SetScriptMap(mapnode);
    */
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
AddConnection(PyObject *self, PyObject *args)
{
    ProgrammableOpAttributesObject *obj = (ProgrammableOpAttributesObject *)self;

    const char* from = 0;
    const char* to = 0;
    const char* port = 0;

    if(!PyArg_ParseTuple(args, "sss", &from,&to,&port))
    {
        VisItErrorFunc("Arguments are ('from_node', 'to_node', 'connection_name')");
        return NULL;
    }

    obj->data->AddConnection(from,to,port);
    /// TODO: error check input & output ports..

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LoadRKernel(PyObject *self, PyObject *args)
{
    ProgrammableOpAttributesObject *obj = (ProgrammableOpAttributesObject *)self;

    const char *name = 0;
    const char *code = 0;
    PyObject* arglist = 0;

    if(!PyArg_ParseTuple(args, "sOs", &name,&arglist,&code))
    {
        VisItErrorFunc("Arguments are ('name',('arg1','arg2',...), 'code')");
        return NULL;
    }

    JSONNode node;
    if(!GetJSONVectorFromPyObject(arglist,node))
    {
        VisItErrorFunc("Arguments are ('name',('arg1','arg2',...), 'code')");
        return NULL;
    }

    obj->data->LoadRKernel(name,node,code);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LoadPythonKernel(PyObject *self, PyObject *args)
{
    ProgrammableOpAttributesObject *obj = (ProgrammableOpAttributesObject *)self;

    const char *name = 0;
    const char *code = 0;
    PyObject* arglist = 0;

    if(!PyArg_ParseTuple(args, "sOs", &name,&arglist,&code))
    {
        VisItErrorFunc("Arguments are ('name',('arg1','arg2',...), 'code')");
        return NULL;
    }

    JSONNode node;
    if(!GetJSONVectorFromPyObject(arglist,node))
    {
        VisItErrorFunc("Arguments are ('name',('arg1','arg2',...), 'code')");
        return NULL;
    }

    //std::cout << node.ToString() << std::endl;

//    obj->data->AddPythonScript(name,vec,code);
    obj->data->LoadPythonKernel(name,node,code);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
AddFinalOutputConnection(PyObject *self, PyObject *args)
{
    ProgrammableOpAttributesObject *obj = (ProgrammableOpAttributesObject *)self;

    const char* from = 0;
    if(!PyArg_ParseTuple(args, "s", &from))
    {
        VisItErrorFunc("Arguments are ('from_node')");
        return NULL;
    }

    obj->data->AddFinalOutputConnection(from);

    Py_INCREF(Py_None);
    return Py_None;
}


PyMethodDef PyProgrammableOpAttributes_methods[PROGRAMMABLEOPATTRIBUTES_NMETH] = {
    {"Notify", ProgrammableOpAttributes_Notify, METH_VARARGS},
    {"SetScriptMap", ProgrammableOpAttributes_SetScriptMap, METH_VARARGS},
    {"GetScriptMap", ProgrammableOpAttributes_GetScriptMap, METH_VARARGS},
    {"VisItErrorFuncX", VisItErrorFuncX, METH_VARARGS},
    {"GetJSONVectorFromPyObjectX", GetJSONVectorFromPyObjectX, METH_VARARGS},
    {"GetStringVectorFromPyObjectX", GetStringVectorFromPyObjectX, METH_VARARGS},
    {"AddConstant", AddConstant, METH_VARARGS},
    {"AddFunction", AddFunction, METH_VARARGS},
    {"AddRScript", AddRScript, METH_VARARGS},
    {"AddPythonScript", AddPythonScript, METH_VARARGS},
    {"AddNode", AddNode, METH_VARARGS},
    {"AddConnection", AddConnection, METH_VARARGS},
    {"LoadRKernel", LoadRKernel, METH_VARARGS},
    {"LoadPythonKernel", LoadPythonKernel, METH_VARARGS},
    {"AddFinalOutputConnection", AddFinalOutputConnection, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
ProgrammableOpAttributes_dealloc(PyObject *v)
{
   ProgrammableOpAttributesObject *obj = (ProgrammableOpAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
ProgrammableOpAttributes_compare(PyObject *v, PyObject *w)
{
    ProgrammableOpAttributes *a = ((ProgrammableOpAttributesObject *)v)->data;
    ProgrammableOpAttributes *b = ((ProgrammableOpAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyProgrammableOpAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "scriptMap") == 0)
        return ProgrammableOpAttributes_GetScriptMap(self, NULL);

    return Py_FindMethod(PyProgrammableOpAttributes_methods, self, name);
}

int
PyProgrammableOpAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "scriptMap") == 0)
        obj = ProgrammableOpAttributes_SetScriptMap(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
ProgrammableOpAttributes_print(PyObject *v, FILE *fp, int flags)
{
    ProgrammableOpAttributesObject *obj = (ProgrammableOpAttributesObject *)v;
    fprintf(fp, "%s", PyProgrammableOpAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
ProgrammableOpAttributes_str(PyObject *v)
{
    ProgrammableOpAttributesObject *obj = (ProgrammableOpAttributesObject *)v;
    return PyString_FromString(PyProgrammableOpAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *ProgrammableOpAttributes_Purpose = "ProgrammableOpAttributes";
#else
static char *ProgrammableOpAttributes_Purpose = "ProgrammableOpAttributes";
#endif

//
// The type description structure
//
static PyTypeObject ProgrammableOpAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "ProgrammableOpAttributes",                    // tp_name
    sizeof(ProgrammableOpAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)ProgrammableOpAttributes_dealloc,  // tp_dealloc
    (printfunc)ProgrammableOpAttributes_print,     // tp_print
    (getattrfunc)PyProgrammableOpAttributes_getattr, // tp_getattr
    (setattrfunc)PyProgrammableOpAttributes_setattr, // tp_setattr
    (cmpfunc)ProgrammableOpAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)ProgrammableOpAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    ProgrammableOpAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static ProgrammableOpAttributes *defaultAtts = 0;
static ProgrammableOpAttributes *currentAtts = 0;

static PyObject *
NewProgrammableOpAttributes(int useCurrent)
{
    ProgrammableOpAttributesObject *newObject;
    newObject = PyObject_NEW(ProgrammableOpAttributesObject, &ProgrammableOpAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new ProgrammableOpAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new ProgrammableOpAttributes(*defaultAtts);
    else
        newObject->data = new ProgrammableOpAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapProgrammableOpAttributes(const ProgrammableOpAttributes *attr)
{
    ProgrammableOpAttributesObject *newObject;
    newObject = PyObject_NEW(ProgrammableOpAttributesObject, &ProgrammableOpAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (ProgrammableOpAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
ProgrammableOpAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewProgrammableOpAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef ProgrammableOpAttributesMethods[] = {
    {"ProgrammableOpAttributes", ProgrammableOpAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *ProgrammableOpAttributesObserver = 0;

std::string
PyProgrammableOpAttributes_GetLogString()
{
    std::string s("ProgrammableOpAtts = ProgrammableOpAttributes()\n");
    if(currentAtts != 0)
        s += PyProgrammableOpAttributes_ToString(currentAtts, "ProgrammableOpAtts.");
    return s;
}

static void
PyProgrammableOpAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("ProgrammableOpAtts = ProgrammableOpAttributes()\n");
        s += PyProgrammableOpAttributes_ToString(currentAtts, "ProgrammableOpAtts.");
        cb(s);
    }
}

void
PyProgrammableOpAttributes_StartUp(ProgrammableOpAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyProgrammableOpAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(ProgrammableOpAttributesObserver == 0)
    {
        ProgrammableOpAttributesObserver = new ObserverToCallback(subj,
            PyProgrammableOpAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyProgrammableOpAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete ProgrammableOpAttributesObserver;
    ProgrammableOpAttributesObserver = 0;
}

PyMethodDef *
PyProgrammableOpAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return ProgrammableOpAttributesMethods;
}

bool
PyProgrammableOpAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &ProgrammableOpAttributesType);
}

ProgrammableOpAttributes *
PyProgrammableOpAttributes_FromPyObject(PyObject *obj)
{
    ProgrammableOpAttributesObject *obj2 = (ProgrammableOpAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyProgrammableOpAttributes_New()
{
    return NewProgrammableOpAttributes(0);
}

PyObject *
PyProgrammableOpAttributes_Wrap(const ProgrammableOpAttributes *attr)
{
    return WrapProgrammableOpAttributes(attr);
}

void
PyProgrammableOpAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    ProgrammableOpAttributesObject *obj2 = (ProgrammableOpAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyProgrammableOpAttributes_SetDefaults(const ProgrammableOpAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new ProgrammableOpAttributes(*atts);
}

