/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

// ************************************************************************* //
//  File: avtPersistentParticlesFilter.h
// ************************************************************************* //

#ifndef AVT_PersistentParticles_FILTER_H
#define AVT_PersistentParticles_FILTER_H

#include <avtExecuteThenTimeLoopFilter.h>
#include <avtPluginFilter.h>

#include <PersistentParticlesAttributes.h>
#include <vtkType.h>
#include <map>
#include <string>
#include <vector>

class vtkPoints;
class vtkDataSet;
class vtkUnstructuredGrid;
class vtkDataSetAttributes;

// ****************************************************************************
//  Class: avtPersistentParticlesFilter
//
//  Purpose:
//      A plugin operator for PersistentParticles. This operator traces 
//      a set of particles based on a given ID variable through time. The
//      operator iterates through the time series and connects the locations
//      of the given particles to compute theit path. The operator creates
//      a new vtkUnstructuredGrid dataset with the pahts as output.
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Fri Jan 25 11:02:55 PDT 2008
//
// ****************************************************************************

class avtPersistentParticlesFilter 
   : virtual public avtPluginFilter,
     virtual public avtExecuteThenTimeLoopFilter
{
  public:
                         avtPersistentParticlesFilter();
    virtual             ~avtPersistentParticlesFilter();

    static avtFilter    *Create();

    virtual const char  *GetType(void)  { return "avtPersistentParticlesFilter"; };
    virtual const char  *GetDescription(void)
                             { return "PersistentParticles"; };

    virtual void         SetAtts(const AttributeGroup*);
    virtual bool         Equivalent(const AttributeGroup*);
    virtual void         ExamineContract(avtContract_p);

  protected:
    PersistentParticlesAttributes   atts;
    std::vector<avtDataTree_p>      trees;
    std::map<double, vtkIdType>        particlePaths;
    vtkUnstructuredGrid*            particlePathData;


    virtual void                    Execute(void);
    virtual void                    InspectPrincipalData(void);
    virtual void                    Iterate(int, avtDataTree_p);
    virtual void                    Finalize(void);
    virtual avtContract_p           ModifyContract(avtContract_p);  
    virtual void                    UpdateDataObjectInfo(void);

  private:
    void IterateMergeData(int, avtDataTree_p);
    void IterateTraceData(int, avtDataTree_p);

    void ComputeGlobalSizeAndOffset( vtkDataArray *indexVariable,
                                     int *numPerProc,
                                     int &globalSize, int &myOffset) const;

    void GlobalizeData( vtkDataArray *indexVariable, const int component,
                        const int globalSize, const int myOffset,
                        double *&alIds, int *&allIndexes) const;
  
    void GlobalizeData( vtkPoints *currPoints,
                        vtkDataArray *currXData,
                        vtkDataArray *currYData,
                        vtkDataArray *currZData,
                        int globalSize, int myOffset,
                        double *&allPoints) const;

    void GlobalizeData( vtkDataSetAttributes *attributes,
                        const int globalSize, const int myOffset,
                        int &nComponents, double *&allData) const;

    void GetDecomp( int *numPerProc,
                    int &firstIndex,
                    int &lastIndex,
                    int &total ) const;

    std::string mainVariable;   
    int activeTimeStep;
    int startTimeSlice;
    int stopTimeSlice;
    bool haveData;
};
#endif
