/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <DualMeshAttributes.h>
#include <DataNode.h>

//
// Enum conversion methods for DualMeshAttributes::ConversionMode
//

static const char *ConversionMode_strings[] = {
"Auto", "NodesToZones", "ZonesToNodes"
};

std::string
DualMeshAttributes::ConversionMode_ToString(DualMeshAttributes::ConversionMode t)
{
    int index = int(t);
    if(index < 0 || index >= 3) index = 0;
    return ConversionMode_strings[index];
}

std::string
DualMeshAttributes::ConversionMode_ToString(int t)
{
    int index = (t < 0 || t >= 3) ? 0 : t;
    return ConversionMode_strings[index];
}

bool
DualMeshAttributes::ConversionMode_FromString(const std::string &s, DualMeshAttributes::ConversionMode &val)
{
    val = DualMeshAttributes::Auto;
    for(int i = 0; i < 3; ++i)
    {
        if(s == ConversionMode_strings[i])
        {
            val = (ConversionMode)i;
            return true;
        }
    }
    return false;
}

// ****************************************************************************
// Method: DualMeshAttributes::DualMeshAttributes
//
// Purpose: 
//   Init utility for the DualMeshAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void DualMeshAttributes::Init()
{
    mode = Auto;

    DualMeshAttributes::SelectAll();
}

// ****************************************************************************
// Method: DualMeshAttributes::DualMeshAttributes
//
// Purpose: 
//   Copy utility for the DualMeshAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void DualMeshAttributes::Copy(const DualMeshAttributes &obj)
{
    mode = obj.mode;

    DualMeshAttributes::SelectAll();
}

// Type map format string
const char *DualMeshAttributes::TypeMapFormatString = DUALMESHATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t DualMeshAttributes::TmfsStruct = {DUALMESHATTRIBUTES_TMFS};


// ****************************************************************************
// Method: DualMeshAttributes::DualMeshAttributes
//
// Purpose: 
//   Default constructor for the DualMeshAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

DualMeshAttributes::DualMeshAttributes() : 
    AttributeSubject(DualMeshAttributes::TypeMapFormatString)
{
    DualMeshAttributes::Init();
}

// ****************************************************************************
// Method: DualMeshAttributes::DualMeshAttributes
//
// Purpose: 
//   Constructor for the derived classes of DualMeshAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

DualMeshAttributes::DualMeshAttributes(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    DualMeshAttributes::Init();
}

// ****************************************************************************
// Method: DualMeshAttributes::DualMeshAttributes
//
// Purpose: 
//   Copy constructor for the DualMeshAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

DualMeshAttributes::DualMeshAttributes(const DualMeshAttributes &obj) : 
    AttributeSubject(DualMeshAttributes::TypeMapFormatString)
{
    DualMeshAttributes::Copy(obj);
}

// ****************************************************************************
// Method: DualMeshAttributes::DualMeshAttributes
//
// Purpose: 
//   Copy constructor for derived classes of the DualMeshAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

DualMeshAttributes::DualMeshAttributes(const DualMeshAttributes &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    DualMeshAttributes::Copy(obj);
}

// ****************************************************************************
// Method: DualMeshAttributes::~DualMeshAttributes
//
// Purpose: 
//   Destructor for the DualMeshAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

DualMeshAttributes::~DualMeshAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: DualMeshAttributes::operator = 
//
// Purpose: 
//   Assignment operator for the DualMeshAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

DualMeshAttributes& 
DualMeshAttributes::operator = (const DualMeshAttributes &obj)
{
    if (this == &obj) return *this;

    DualMeshAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: DualMeshAttributes::operator == 
//
// Purpose: 
//   Comparison operator == for the DualMeshAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
DualMeshAttributes::operator == (const DualMeshAttributes &obj) const
{
    // Create the return value
    return ((mode == obj.mode));
}

// ****************************************************************************
// Method: DualMeshAttributes::operator != 
//
// Purpose: 
//   Comparison operator != for the DualMeshAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
DualMeshAttributes::operator != (const DualMeshAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: DualMeshAttributes::TypeName
//
// Purpose: 
//   Type name method for the DualMeshAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
DualMeshAttributes::TypeName() const
{
    return "DualMeshAttributes";
}

// ****************************************************************************
// Method: DualMeshAttributes::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the DualMeshAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
DualMeshAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const DualMeshAttributes *tmp = (const DualMeshAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: DualMeshAttributes::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the DualMeshAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
DualMeshAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new DualMeshAttributes(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: DualMeshAttributes::NewInstance
//
// Purpose: 
//   NewInstance method for the DualMeshAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
DualMeshAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new DualMeshAttributes(*this);
    else
        retval = new DualMeshAttributes;

    return retval;
}

// ****************************************************************************
// Method: DualMeshAttributes::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
DualMeshAttributes::SelectAll()
{
    Select(ID_mode, (void *)&mode);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: DualMeshAttributes::CreateNode
//
// Purpose: 
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
DualMeshAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    DualMeshAttributes defaultObject;
    bool addToParent = false;
    // Create a node for DualMeshAttributes.
    DataNode *node = new DataNode("DualMeshAttributes");

    if(completeSave || !FieldsEqual(ID_mode, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("mode", ConversionMode_ToString(mode)));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: DualMeshAttributes::SetFromNode
//
// Purpose: 
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
DualMeshAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("DualMeshAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("mode")) != 0)
    {
        // Allow enums to be int or string in the config file
        if(node->GetNodeType() == INT_NODE)
        {
            int ival = node->AsInt();
            if(ival >= 0 && ival < 3)
                SetMode(ConversionMode(ival));
        }
        else if(node->GetNodeType() == STRING_NODE)
        {
            ConversionMode value;
            if(ConversionMode_FromString(node->AsString(), value))
                SetMode(value);
        }
    }
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
DualMeshAttributes::SetMode(DualMeshAttributes::ConversionMode mode_)
{
    mode = mode_;
    Select(ID_mode, (void *)&mode);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

DualMeshAttributes::ConversionMode
DualMeshAttributes::GetMode() const
{
    return ConversionMode(mode);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: DualMeshAttributes::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
DualMeshAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_mode: return "mode";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: DualMeshAttributes::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
DualMeshAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_mode: return FieldType_enum;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: DualMeshAttributes::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
DualMeshAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_mode: return "enum";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: DualMeshAttributes::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
DualMeshAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const DualMeshAttributes &obj = *((const DualMeshAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_mode:
        {  // new scope
        retval = (mode == obj.mode);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

