// ***************************************************************************
//
// Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
// Produced at the Lawrence Livermore National Laboratory
// LLNL-CODE-442911
// All rights reserved.
//
// This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
// full copyright notice is contained in the file COPYRIGHT located at the root
// of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
//
// Redistribution  and  use  in  source  and  binary  forms,  with  or  without
// modification, are permitted provided that the following conditions are met:
//
//  - Redistributions of  source code must  retain the above  copyright notice,
//    this list of conditions and the disclaimer below.
//  - Redistributions in binary form must reproduce the above copyright notice,
//    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
//    documentation and/or other materials provided with the distribution.
//  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
//    be used to endorse or promote products derived from this software without
//    specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
// ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
// LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
// DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
// SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
// CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
// LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
// OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
// DAMAGE.
//
// ***************************************************************************

package llnl.visit.operators;

import llnl.visit.AttributeSubject;
import llnl.visit.CommunicationBuffer;
import llnl.visit.Plugin;

// ****************************************************************************
// Class: ChannelCommAttributes
//
// Purpose:
//    Attributes for ChannelComm operator
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

public class ChannelCommAttributes extends AttributeSubject implements Plugin
{
    private static int ChannelCommAttributes_numAdditionalAtts = 3;

    public ChannelCommAttributes()
    {
        super(ChannelCommAttributes_numAdditionalAtts);

        numInX = 10;
        numInY = 10;
        velocity = new String("");
    }

    public ChannelCommAttributes(int nMoreFields)
    {
        super(ChannelCommAttributes_numAdditionalAtts + nMoreFields);

        numInX = 10;
        numInY = 10;
        velocity = new String("");
    }

    public ChannelCommAttributes(ChannelCommAttributes obj)
    {
        super(obj);

        numInX = obj.numInX;
        numInY = obj.numInY;
        velocity = new String(obj.velocity);

        SelectAll();
    }

    public int Offset()
    {
        return super.Offset() + super.GetNumAdditionalAttributes();
    }

    public int GetNumAdditionalAttributes()
    {
        return ChannelCommAttributes_numAdditionalAtts;
    }

    public boolean equals(ChannelCommAttributes obj)
    {
        // Create the return value
        return ((numInX == obj.numInX) &&
                (numInY == obj.numInY) &&
                (velocity.equals(obj.velocity)));
    }

    public String GetName() { return "ChannelComm"; }
    public String GetVersion() { return "1.0"; }

    // Property setting methods
    public void SetNumInX(int numInX_)
    {
        numInX = numInX_;
        Select(0);
    }

    public void SetNumInY(int numInY_)
    {
        numInY = numInY_;
        Select(1);
    }

    public void SetVelocity(String velocity_)
    {
        velocity = velocity_;
        Select(2);
    }

    // Property getting methods
    public int    GetNumInX() { return numInX; }
    public int    GetNumInY() { return numInY; }
    public String GetVelocity() { return velocity; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteInt(numInX);
        if(WriteSelect(1, buf))
            buf.WriteInt(numInY);
        if(WriteSelect(2, buf))
            buf.WriteString(velocity);
    }

    public void ReadAtts(int index, CommunicationBuffer buf)
    {
        switch(index)
        {
        case 0:
            SetNumInX(buf.ReadInt());
            break;
        case 1:
            SetNumInY(buf.ReadInt());
            break;
        case 2:
            SetVelocity(buf.ReadString());
            break;
        }
    }

    public String toString(String indent)
    {
        String str = new String();
        str = str + intToString("numInX", numInX, indent) + "\n";
        str = str + intToString("numInY", numInY, indent) + "\n";
        str = str + stringToString("velocity", velocity, indent) + "\n";
        return str;
    }


    // Attributes
    private int    numInX;
    private int    numInY;
    private String velocity;
}

