#ifndef QVIS_SESSION_FILE_OPEN_DIALOG_H
#define QVIS_SESSION_FILE_OPEN_DIALOG_H
/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/
#include <QvisFileOpenDialog.h>
#include <string>

// ****************************************************************************
// Class: QvisSessionFileDialog
//
// Purpose:
//   This is a dialog version of the file open window for use to load or Save
//   Session files. It has support to save or load from remote hosts.
//
// Notes:      
//
// Programmer: David Camp
// Creation:   Tue Aug  4 11:04:14 PDT 2015
//
// Modifications:
//   Kathleen Biagas, Tue Oct 13 09:21:01 PDT 2015
//   Add storage for original filter, grouping settings retrieved from 
//   file server.
//
//   Kathleen Biagas, Tue Mar 15 18:27:17 MST 2016
//   Added RestoreFileServerSettings method.
//
// ****************************************************************************

class QvisSessionFileDialog : public QvisFileOpenDialog
{
public:
    enum DLG_TYPE { OPEN_DLG, SAVE_DLG };

    QvisSessionFileDialog(const QString &caption);
    virtual ~QvisSessionFileDialog();

    // Blocking function to use the dialog to get a filename.
    void getFileName(DLG_TYPE type,
                     const QString &initialFile, 
                     QualifiedFilename &filename);

private:
    void RestoreFileServerSettings(void);
    std::string origFilter;
    bool autoFileGrouping;
    bool smartFileGrouping;
};

#endif

