/*****************************************************************************
*
* Copyright (c) 2000 - 2017, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <PyTruecolorAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <snprintf.h>

// ****************************************************************************
// Module: PyTruecolorAttributes
//
// Purpose: 
//   Truecolor plot
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a TruecolorAttributes.
//
struct TruecolorAttributesObject
{
    PyObject_HEAD
    TruecolorAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewTruecolorAttributes(int);

std::string
PyTruecolorAttributes_ToString(const TruecolorAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    SNPRINTF(tmpStr, 1000, "%sopacity = %g\n", prefix, atts->GetOpacity());
    str += tmpStr;
    if(atts->GetLightingFlag())
        SNPRINTF(tmpStr, 1000, "%slightingFlag = 1\n", prefix);
    else
        SNPRINTF(tmpStr, 1000, "%slightingFlag = 0\n", prefix);
    str += tmpStr;
    return str;
}

static PyObject *
TruecolorAttributes_Notify(PyObject *self, PyObject *args)
{
    TruecolorAttributesObject *obj = (TruecolorAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TruecolorAttributes_SetOpacity(PyObject *self, PyObject *args)
{
    TruecolorAttributesObject *obj = (TruecolorAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the opacity in the object.
    obj->data->SetOpacity(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TruecolorAttributes_GetOpacity(PyObject *self, PyObject *args)
{
    TruecolorAttributesObject *obj = (TruecolorAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetOpacity());
    return retval;
}

/*static*/ PyObject *
TruecolorAttributes_SetLightingFlag(PyObject *self, PyObject *args)
{
    TruecolorAttributesObject *obj = (TruecolorAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the lightingFlag in the object.
    obj->data->SetLightingFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
TruecolorAttributes_GetLightingFlag(PyObject *self, PyObject *args)
{
    TruecolorAttributesObject *obj = (TruecolorAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetLightingFlag()?1L:0L);
    return retval;
}



PyMethodDef PyTruecolorAttributes_methods[TRUECOLORATTRIBUTES_NMETH] = {
    {"Notify", TruecolorAttributes_Notify, METH_VARARGS},
    {"SetOpacity", TruecolorAttributes_SetOpacity, METH_VARARGS},
    {"GetOpacity", TruecolorAttributes_GetOpacity, METH_VARARGS},
    {"SetLightingFlag", TruecolorAttributes_SetLightingFlag, METH_VARARGS},
    {"GetLightingFlag", TruecolorAttributes_GetLightingFlag, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
TruecolorAttributes_dealloc(PyObject *v)
{
   TruecolorAttributesObject *obj = (TruecolorAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
TruecolorAttributes_compare(PyObject *v, PyObject *w)
{
    TruecolorAttributes *a = ((TruecolorAttributesObject *)v)->data;
    TruecolorAttributes *b = ((TruecolorAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyTruecolorAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "opacity") == 0)
        return TruecolorAttributes_GetOpacity(self, NULL);
    if(strcmp(name, "lightingFlag") == 0)
        return TruecolorAttributes_GetLightingFlag(self, NULL);

    return Py_FindMethod(PyTruecolorAttributes_methods, self, name);
}

int
PyTruecolorAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "opacity") == 0)
        obj = TruecolorAttributes_SetOpacity(self, tuple);
    else if(strcmp(name, "lightingFlag") == 0)
        obj = TruecolorAttributes_SetLightingFlag(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
TruecolorAttributes_print(PyObject *v, FILE *fp, int flags)
{
    TruecolorAttributesObject *obj = (TruecolorAttributesObject *)v;
    fprintf(fp, "%s", PyTruecolorAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
TruecolorAttributes_str(PyObject *v)
{
    TruecolorAttributesObject *obj = (TruecolorAttributesObject *)v;
    return PyString_FromString(PyTruecolorAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *TruecolorAttributes_Purpose = "Truecolor plot";
#else
static char *TruecolorAttributes_Purpose = "Truecolor plot";
#endif

//
// The type description structure
//
static PyTypeObject TruecolorAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "TruecolorAttributes",                    // tp_name
    sizeof(TruecolorAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)TruecolorAttributes_dealloc,  // tp_dealloc
    (printfunc)TruecolorAttributes_print,     // tp_print
    (getattrfunc)PyTruecolorAttributes_getattr, // tp_getattr
    (setattrfunc)PyTruecolorAttributes_setattr, // tp_setattr
    (cmpfunc)TruecolorAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)TruecolorAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    TruecolorAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static TruecolorAttributes *defaultAtts = 0;
static TruecolorAttributes *currentAtts = 0;

static PyObject *
NewTruecolorAttributes(int useCurrent)
{
    TruecolorAttributesObject *newObject;
    newObject = PyObject_NEW(TruecolorAttributesObject, &TruecolorAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new TruecolorAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new TruecolorAttributes(*defaultAtts);
    else
        newObject->data = new TruecolorAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapTruecolorAttributes(const TruecolorAttributes *attr)
{
    TruecolorAttributesObject *newObject;
    newObject = PyObject_NEW(TruecolorAttributesObject, &TruecolorAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (TruecolorAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
TruecolorAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewTruecolorAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef TruecolorAttributesMethods[] = {
    {"TruecolorAttributes", TruecolorAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *TruecolorAttributesObserver = 0;

std::string
PyTruecolorAttributes_GetLogString()
{
    std::string s("TruecolorAtts = TruecolorAttributes()\n");
    if(currentAtts != 0)
        s += PyTruecolorAttributes_ToString(currentAtts, "TruecolorAtts.");
    return s;
}

static void
PyTruecolorAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("TruecolorAtts = TruecolorAttributes()\n");
        s += PyTruecolorAttributes_ToString(currentAtts, "TruecolorAtts.");
        cb(s);
    }
}

void
PyTruecolorAttributes_StartUp(TruecolorAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyTruecolorAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(TruecolorAttributesObserver == 0)
    {
        TruecolorAttributesObserver = new ObserverToCallback(subj,
            PyTruecolorAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyTruecolorAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete TruecolorAttributesObserver;
    TruecolorAttributesObserver = 0;
}

PyMethodDef *
PyTruecolorAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return TruecolorAttributesMethods;
}

bool
PyTruecolorAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &TruecolorAttributesType);
}

TruecolorAttributes *
PyTruecolorAttributes_FromPyObject(PyObject *obj)
{
    TruecolorAttributesObject *obj2 = (TruecolorAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyTruecolorAttributes_New()
{
    return NewTruecolorAttributes(0);
}

PyObject *
PyTruecolorAttributes_Wrap(const TruecolorAttributes *attr)
{
    return WrapTruecolorAttributes(attr);
}

void
PyTruecolorAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    TruecolorAttributesObject *obj2 = (TruecolorAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyTruecolorAttributes_SetDefaults(const TruecolorAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new TruecolorAttributes(*atts);
}

