/* generated by gen_poly_imp.c */

#define GLL_LAG_FIX_MAX 24

static void gll_lag_02(double *restrict p, double *restrict w,
                       unsigned n, int d, double xh)
{
  const double x = xh*2;
  const double d00=x+2            ,d01=x-2            ;
  const double u0_01=    1*d00;
  const double v0_00=d01*    1;
  p[ 0]=w[ 0]*    1*v0_00; p[ 1]=w[ 1]*u0_01*    1;
  if(d>0) {
    p[2+ 0]=2*w[ 0]*(                      1);
    p[2+ 1]=2*w[ 1]*(    1                  );
    if(d>1) {
      p[2*2+ 0]=0;
      p[2*2+ 1]=0;
    }
  }
}

static void gll_lag_03(double *restrict p, double *restrict w,
                       unsigned n, int d, double xh)
{
  const double x = xh*2;
  const double d00=x+2            ,d01=x              ,d02=x-2            ;
  const double u0_01=    1*d00,u0_02=u0_01*d01;
  const double v0_01=d02*    1,v0_00=d01*v0_01;
  p[ 0]=w[ 0]*    1*v0_00; p[ 1]=w[ 1]*u0_01*v0_01; p[ 2]=w[ 2]*u0_02*    1;
  if(d>0) {
    const double u1_02=    1*d01+u0_01;
    const double v1_00=d01*    1+v0_01;
    p[3+ 0]=2*w[ 0]*(                  v1_00);
    p[3+ 1]=2*w[ 1]*(    1*v0_01+u0_01*    1);
    p[3+ 2]=2*w[ 2]*(u1_02                  );
    if(d>1) {
      p[2*3+ 0]=4*w[ 0]*(                         +    1*    2);
      p[2*3+ 1]=4*w[ 1]*(           +2*    1*    1            );
      p[2*3+ 2]=4*w[ 2]*(    2*    1                          );
    }
  }
}

static const double gllz_04[ 1] = {
  0.44721359549995793928183473374625524708812367192231
};

static void gll_lag_04(double *restrict p, double *restrict w,
                       unsigned n, int d, double xh)
{
  const double x = xh*2;
  const double d00=x+2            ,d01=x+2*gllz_04[ 0],d02=x-2*gllz_04[ 0],
               d03=x-2            ;
  const double u0_01=    1*d00,u0_02=u0_01*d01,u0_03=u0_02*d02;
  const double v0_02=d03*    1,v0_01=d02*v0_02,v0_00=d01*v0_01;
  p[ 0]=w[ 0]*    1*v0_00; p[ 1]=w[ 1]*u0_01*v0_01; p[ 2]=w[ 2]*u0_02*v0_02;
  p[ 3]=w[ 3]*u0_03*    1;
  if(d>0) {
    const double u1_02=    1*d01+u0_01,u1_03=u1_02*d02+u0_02;
    const double v1_01=d02*    1+v0_02,v1_00=d01*v1_01+v0_01;
    p[4+ 0]=2*w[ 0]*(                  v1_00);
    p[4+ 1]=2*w[ 1]*(    1*v0_01+u0_01*v1_01);
    p[4+ 2]=2*w[ 2]*(u1_02*v0_02+u0_02*    1);
    p[4+ 3]=2*w[ 3]*(u1_03                  );
    if(d>1) {
      const double u2_03=    2*d02+2*u1_02;
      const double v2_00=d01*    2+2*v1_01;
      p[2*4+ 0]=4*w[ 0]*(                         +    1*v2_00);
      p[2*4+ 1]=4*w[ 1]*(           +2*    1*v1_01+u0_01*    2);
      p[2*4+ 2]=4*w[ 2]*(    2*v0_02+2*u1_02*    1            );
      p[2*4+ 3]=4*w[ 3]*(u2_03*    1                          );
    }
  }
}

static const double gllz_05[ 1] = {
  0.65465367070797714379829245624685835556920808239542
};

static void gll_lag_05(double *restrict p, double *restrict w,
                       unsigned n, int d, double xh)
{
  const double x = xh*2;
  const double d00=x+2            ,d01=x+2*gllz_05[ 0],d02=x              ,
               d03=x-2*gllz_05[ 0],d04=x-2            ;
  const double u0_01=    1*d00,u0_02=u0_01*d01,u0_03=u0_02*d02,
               u0_04=u0_03*d03;
  const double v0_03=d04*    1,v0_02=d03*v0_03,v0_01=d02*v0_02,
               v0_00=d01*v0_01;
  p[ 0]=w[ 0]*    1*v0_00; p[ 1]=w[ 1]*u0_01*v0_01; p[ 2]=w[ 2]*u0_02*v0_02;
  p[ 3]=w[ 3]*u0_03*v0_03; p[ 4]=w[ 4]*u0_04*    1;
  if(d>0) {
    const double u1_02=    1*d01+u0_01,u1_03=u1_02*d02+u0_02,
                 u1_04=u1_03*d03+u0_03;
    const double v1_02=d03*    1+v0_03,v1_01=d02*v1_02+v0_02,
                 v1_00=d01*v1_01+v0_01;
    p[5+ 0]=2*w[ 0]*(                  v1_00);
    p[5+ 1]=2*w[ 1]*(    1*v0_01+u0_01*v1_01);
    p[5+ 2]=2*w[ 2]*(u1_02*v0_02+u0_02*v1_02);
    p[5+ 3]=2*w[ 3]*(u1_03*v0_03+u0_03*    1);
    p[5+ 4]=2*w[ 4]*(u1_04                  );
    if(d>1) {
      const double u2_03=    2*d02+2*u1_02,u2_04=u2_03*d03+2*u1_03;
      const double v2_01=d02*    2+2*v1_02,v2_00=d01*v2_01+2*v1_01;
      p[2*5+ 0]=4*w[ 0]*(                         +    1*v2_00);
      p[2*5+ 1]=4*w[ 1]*(           +2*    1*v1_01+u0_01*v2_01);
      p[2*5+ 2]=4*w[ 2]*(    2*v0_02+2*u1_02*v1_02+u0_02*    2);
      p[2*5+ 3]=4*w[ 3]*(u2_03*v0_03+2*u1_03*    1            );
      p[2*5+ 4]=4*w[ 4]*(u2_04*    1                          );
    }
  }
}

static const double gllz_06[ 2] = {
  0.7650553239294646928510029739593381503657356885361,
  0.28523151648064509631415099404087907191900347272643
};

static void gll_lag_06(double *restrict p, double *restrict w,
                       unsigned n, int d, double xh)
{
  const double x = xh*2;
  const double d00=x+2            ,d01=x+2*gllz_06[ 0],d02=x+2*gllz_06[ 1],
               d03=x-2*gllz_06[ 1],d04=x-2*gllz_06[ 0],d05=x-2            ;
  const double u0_01=    1*d00,u0_02=u0_01*d01,u0_03=u0_02*d02,
               u0_04=u0_03*d03,u0_05=u0_04*d04;
  const double v0_04=d05*    1,v0_03=d04*v0_04,v0_02=d03*v0_03,
               v0_01=d02*v0_02,v0_00=d01*v0_01;
  p[ 0]=w[ 0]*    1*v0_00; p[ 1]=w[ 1]*u0_01*v0_01; p[ 2]=w[ 2]*u0_02*v0_02;
  p[ 3]=w[ 3]*u0_03*v0_03; p[ 4]=w[ 4]*u0_04*v0_04; p[ 5]=w[ 5]*u0_05*    1;
  if(d>0) {
    const double u1_02=    1*d01+u0_01,u1_03=u1_02*d02+u0_02,
                 u1_04=u1_03*d03+u0_03,u1_05=u1_04*d04+u0_04;
    const double v1_03=d04*    1+v0_04,v1_02=d03*v1_03+v0_03,
                 v1_01=d02*v1_02+v0_02,v1_00=d01*v1_01+v0_01;
    p[6+ 0]=2*w[ 0]*(                  v1_00);
    p[6+ 1]=2*w[ 1]*(    1*v0_01+u0_01*v1_01);
    p[6+ 2]=2*w[ 2]*(u1_02*v0_02+u0_02*v1_02);
    p[6+ 3]=2*w[ 3]*(u1_03*v0_03+u0_03*v1_03);
    p[6+ 4]=2*w[ 4]*(u1_04*v0_04+u0_04*    1);
    p[6+ 5]=2*w[ 5]*(u1_05                  );
    if(d>1) {
      const double u2_03=    2*d02+2*u1_02,u2_04=u2_03*d03+2*u1_03,
                   u2_05=u2_04*d04+2*u1_04;
      const double v2_02=d03*    2+2*v1_03,v2_01=d02*v2_02+2*v1_02,
                   v2_00=d01*v2_01+2*v1_01;
      p[2*6+ 0]=4*w[ 0]*(                         +    1*v2_00);
      p[2*6+ 1]=4*w[ 1]*(           +2*    1*v1_01+u0_01*v2_01);
      p[2*6+ 2]=4*w[ 2]*(    2*v0_02+2*u1_02*v1_02+u0_02*v2_02);
      p[2*6+ 3]=4*w[ 3]*(u2_03*v0_03+2*u1_03*v1_03+u0_03*    2);
      p[2*6+ 4]=4*w[ 4]*(u2_04*v0_04+2*u1_04*    1            );
      p[2*6+ 5]=4*w[ 5]*(u2_05*    1                          );
    }
  }
}

static const double gllz_07[ 2] = {
  0.830223896278566929872032213967465139587170364872,
  0.46884879347071421380377188190876632940559747167184
};

static void gll_lag_07(double *restrict p, double *restrict w,
                       unsigned n, int d, double xh)
{
  const double x = xh*2;
  const double d00=x+2            ,d01=x+2*gllz_07[ 0],d02=x+2*gllz_07[ 1],
               d03=x              ,d04=x-2*gllz_07[ 1],d05=x-2*gllz_07[ 0],
               d06=x-2            ;
  const double u0_01=    1*d00,u0_02=u0_01*d01,u0_03=u0_02*d02,
               u0_04=u0_03*d03,u0_05=u0_04*d04,u0_06=u0_05*d05;
  const double v0_05=d06*    1,v0_04=d05*v0_05,v0_03=d04*v0_04,
               v0_02=d03*v0_03,v0_01=d02*v0_02,v0_00=d01*v0_01;
  p[ 0]=w[ 0]*    1*v0_00; p[ 1]=w[ 1]*u0_01*v0_01; p[ 2]=w[ 2]*u0_02*v0_02;
  p[ 3]=w[ 3]*u0_03*v0_03; p[ 4]=w[ 4]*u0_04*v0_04; p[ 5]=w[ 5]*u0_05*v0_05;
  p[ 6]=w[ 6]*u0_06*    1;
  if(d>0) {
    const double u1_02=    1*d01+u0_01,u1_03=u1_02*d02+u0_02,
                 u1_04=u1_03*d03+u0_03,u1_05=u1_04*d04+u0_04,
                 u1_06=u1_05*d05+u0_05;
    const double v1_04=d05*    1+v0_05,v1_03=d04*v1_04+v0_04,
                 v1_02=d03*v1_03+v0_03,v1_01=d02*v1_02+v0_02,
                 v1_00=d01*v1_01+v0_01;
    p[7+ 0]=2*w[ 0]*(                  v1_00);
    p[7+ 1]=2*w[ 1]*(    1*v0_01+u0_01*v1_01);
    p[7+ 2]=2*w[ 2]*(u1_02*v0_02+u0_02*v1_02);
    p[7+ 3]=2*w[ 3]*(u1_03*v0_03+u0_03*v1_03);
    p[7+ 4]=2*w[ 4]*(u1_04*v0_04+u0_04*v1_04);
    p[7+ 5]=2*w[ 5]*(u1_05*v0_05+u0_05*    1);
    p[7+ 6]=2*w[ 6]*(u1_06                  );
    if(d>1) {
      const double u2_03=    2*d02+2*u1_02,u2_04=u2_03*d03+2*u1_03,
                   u2_05=u2_04*d04+2*u1_04,u2_06=u2_05*d05+2*u1_05;
      const double v2_03=d04*    2+2*v1_04,v2_02=d03*v2_03+2*v1_03,
                   v2_01=d02*v2_02+2*v1_02,v2_00=d01*v2_01+2*v1_01;
      p[2*7+ 0]=4*w[ 0]*(                         +    1*v2_00);
      p[2*7+ 1]=4*w[ 1]*(           +2*    1*v1_01+u0_01*v2_01);
      p[2*7+ 2]=4*w[ 2]*(    2*v0_02+2*u1_02*v1_02+u0_02*v2_02);
      p[2*7+ 3]=4*w[ 3]*(u2_03*v0_03+2*u1_03*v1_03+u0_03*v2_03);
      p[2*7+ 4]=4*w[ 4]*(u2_04*v0_04+2*u1_04*v1_04+u0_04*    2);
      p[2*7+ 5]=4*w[ 5]*(u2_05*v0_05+2*u1_05*    1            );
      p[2*7+ 6]=4*w[ 6]*(u2_06*    1                          );
    }
  }
}

static const double gllz_08[ 3] = {
  0.87174014850960661533744576122066343810378066967698,
  0.59170018143314230214451073139795318994570098951733,
  0.20929921790247886876865726034535125529554540508668
};

static void gll_lag_08(double *restrict p, double *restrict w,
                       unsigned n, int d, double xh)
{
  const double x = xh*2;
  const double d00=x+2            ,d01=x+2*gllz_08[ 0],d02=x+2*gllz_08[ 1],
               d03=x+2*gllz_08[ 2],d04=x-2*gllz_08[ 2],d05=x-2*gllz_08[ 1],
               d06=x-2*gllz_08[ 0],d07=x-2            ;
  const double u0_01=    1*d00,u0_02=u0_01*d01,u0_03=u0_02*d02,
               u0_04=u0_03*d03,u0_05=u0_04*d04,u0_06=u0_05*d05,
               u0_07=u0_06*d06;
  const double v0_06=d07*    1,v0_05=d06*v0_06,v0_04=d05*v0_05,
               v0_03=d04*v0_04,v0_02=d03*v0_03,v0_01=d02*v0_02,
               v0_00=d01*v0_01;
  p[ 0]=w[ 0]*    1*v0_00; p[ 1]=w[ 1]*u0_01*v0_01; p[ 2]=w[ 2]*u0_02*v0_02;
  p[ 3]=w[ 3]*u0_03*v0_03; p[ 4]=w[ 4]*u0_04*v0_04; p[ 5]=w[ 5]*u0_05*v0_05;
  p[ 6]=w[ 6]*u0_06*v0_06; p[ 7]=w[ 7]*u0_07*    1;
  if(d>0) {
    const double u1_02=    1*d01+u0_01,u1_03=u1_02*d02+u0_02,
                 u1_04=u1_03*d03+u0_03,u1_05=u1_04*d04+u0_04,
                 u1_06=u1_05*d05+u0_05,u1_07=u1_06*d06+u0_06;
    const double v1_05=d06*    1+v0_06,v1_04=d05*v1_05+v0_05,
                 v1_03=d04*v1_04+v0_04,v1_02=d03*v1_03+v0_03,
                 v1_01=d02*v1_02+v0_02,v1_00=d01*v1_01+v0_01;
    p[8+ 0]=2*w[ 0]*(                  v1_00);
    p[8+ 1]=2*w[ 1]*(    1*v0_01+u0_01*v1_01);
    p[8+ 2]=2*w[ 2]*(u1_02*v0_02+u0_02*v1_02);
    p[8+ 3]=2*w[ 3]*(u1_03*v0_03+u0_03*v1_03);
    p[8+ 4]=2*w[ 4]*(u1_04*v0_04+u0_04*v1_04);
    p[8+ 5]=2*w[ 5]*(u1_05*v0_05+u0_05*v1_05);
    p[8+ 6]=2*w[ 6]*(u1_06*v0_06+u0_06*    1);
    p[8+ 7]=2*w[ 7]*(u1_07                  );
    if(d>1) {
      const double u2_03=    2*d02+2*u1_02,u2_04=u2_03*d03+2*u1_03,
                   u2_05=u2_04*d04+2*u1_04,u2_06=u2_05*d05+2*u1_05,
                   u2_07=u2_06*d06+2*u1_06;
      const double v2_04=d05*    2+2*v1_05,v2_03=d04*v2_04+2*v1_04,
                   v2_02=d03*v2_03+2*v1_03,v2_01=d02*v2_02+2*v1_02,
                   v2_00=d01*v2_01+2*v1_01;
      p[2*8+ 0]=4*w[ 0]*(                         +    1*v2_00);
      p[2*8+ 1]=4*w[ 1]*(           +2*    1*v1_01+u0_01*v2_01);
      p[2*8+ 2]=4*w[ 2]*(    2*v0_02+2*u1_02*v1_02+u0_02*v2_02);
      p[2*8+ 3]=4*w[ 3]*(u2_03*v0_03+2*u1_03*v1_03+u0_03*v2_03);
      p[2*8+ 4]=4*w[ 4]*(u2_04*v0_04+2*u1_04*v1_04+u0_04*v2_04);
      p[2*8+ 5]=4*w[ 5]*(u2_05*v0_05+2*u1_05*v1_05+u0_05*    2);
      p[2*8+ 6]=4*w[ 6]*(u2_06*v0_06+2*u1_06*    1            );
      p[2*8+ 7]=4*w[ 7]*(u2_07*    1                          );
    }
  }
}

static const double gllz_09[ 3] = {
  0.8997579954114601573123452444183379580514802955661,
  0.67718627951073775344588542709134245071102964761391,
  0.36311746382617815871075206870865921302064227760088
};

static void gll_lag_09(double *restrict p, double *restrict w,
                       unsigned n, int d, double xh)
{
  const double x = xh*2;
  const double d00=x+2            ,d01=x+2*gllz_09[ 0],d02=x+2*gllz_09[ 1],
               d03=x+2*gllz_09[ 2],d04=x              ,d05=x-2*gllz_09[ 2],
               d06=x-2*gllz_09[ 1],d07=x-2*gllz_09[ 0],d08=x-2            ;
  const double u0_01=    1*d00,u0_02=u0_01*d01,u0_03=u0_02*d02,
               u0_04=u0_03*d03,u0_05=u0_04*d04,u0_06=u0_05*d05,
               u0_07=u0_06*d06,u0_08=u0_07*d07;
  const double v0_07=d08*    1,v0_06=d07*v0_07,v0_05=d06*v0_06,
               v0_04=d05*v0_05,v0_03=d04*v0_04,v0_02=d03*v0_03,
               v0_01=d02*v0_02,v0_00=d01*v0_01;
  p[ 0]=w[ 0]*    1*v0_00; p[ 1]=w[ 1]*u0_01*v0_01; p[ 2]=w[ 2]*u0_02*v0_02;
  p[ 3]=w[ 3]*u0_03*v0_03; p[ 4]=w[ 4]*u0_04*v0_04; p[ 5]=w[ 5]*u0_05*v0_05;
  p[ 6]=w[ 6]*u0_06*v0_06; p[ 7]=w[ 7]*u0_07*v0_07; p[ 8]=w[ 8]*u0_08*    1;
  if(d>0) {
    const double u1_02=    1*d01+u0_01,u1_03=u1_02*d02+u0_02,
                 u1_04=u1_03*d03+u0_03,u1_05=u1_04*d04+u0_04,
                 u1_06=u1_05*d05+u0_05,u1_07=u1_06*d06+u0_06,
                 u1_08=u1_07*d07+u0_07;
    const double v1_06=d07*    1+v0_07,v1_05=d06*v1_06+v0_06,
                 v1_04=d05*v1_05+v0_05,v1_03=d04*v1_04+v0_04,
                 v1_02=d03*v1_03+v0_03,v1_01=d02*v1_02+v0_02,
                 v1_00=d01*v1_01+v0_01;
    p[9+ 0]=2*w[ 0]*(                  v1_00);
    p[9+ 1]=2*w[ 1]*(    1*v0_01+u0_01*v1_01);
    p[9+ 2]=2*w[ 2]*(u1_02*v0_02+u0_02*v1_02);
    p[9+ 3]=2*w[ 3]*(u1_03*v0_03+u0_03*v1_03);
    p[9+ 4]=2*w[ 4]*(u1_04*v0_04+u0_04*v1_04);
    p[9+ 5]=2*w[ 5]*(u1_05*v0_05+u0_05*v1_05);
    p[9+ 6]=2*w[ 6]*(u1_06*v0_06+u0_06*v1_06);
    p[9+ 7]=2*w[ 7]*(u1_07*v0_07+u0_07*    1);
    p[9+ 8]=2*w[ 8]*(u1_08                  );
    if(d>1) {
      const double u2_03=    2*d02+2*u1_02,u2_04=u2_03*d03+2*u1_03,
                   u2_05=u2_04*d04+2*u1_04,u2_06=u2_05*d05+2*u1_05,
                   u2_07=u2_06*d06+2*u1_06,u2_08=u2_07*d07+2*u1_07;
      const double v2_05=d06*    2+2*v1_06,v2_04=d05*v2_05+2*v1_05,
                   v2_03=d04*v2_04+2*v1_04,v2_02=d03*v2_03+2*v1_03,
                   v2_01=d02*v2_02+2*v1_02,v2_00=d01*v2_01+2*v1_01;
      p[2*9+ 0]=4*w[ 0]*(                         +    1*v2_00);
      p[2*9+ 1]=4*w[ 1]*(           +2*    1*v1_01+u0_01*v2_01);
      p[2*9+ 2]=4*w[ 2]*(    2*v0_02+2*u1_02*v1_02+u0_02*v2_02);
      p[2*9+ 3]=4*w[ 3]*(u2_03*v0_03+2*u1_03*v1_03+u0_03*v2_03);
      p[2*9+ 4]=4*w[ 4]*(u2_04*v0_04+2*u1_04*v1_04+u0_04*v2_04);
      p[2*9+ 5]=4*w[ 5]*(u2_05*v0_05+2*u1_05*v1_05+u0_05*v2_05);
      p[2*9+ 6]=4*w[ 6]*(u2_06*v0_06+2*u1_06*v1_06+u0_06*    2);
      p[2*9+ 7]=4*w[ 7]*(u2_07*v0_07+2*u1_07*    1            );
      p[2*9+ 8]=4*w[ 8]*(u2_08*    1                          );
    }
  }
}

static const double gllz_10[ 4] = {
  0.91953390816645881382893266082233813415354307544628,
  0.73877386510550507500310617485983072501618510137693,
  0.47792494981044449566117509273125799788677289333057,
  0.16527895766638702462621976595817353323115034354948
};

static void gll_lag_10(double *restrict p, double *restrict w,
                       unsigned n, int d, double xh)
{
  const double x = xh*2;
  const double d00=x+2            ,d01=x+2*gllz_10[ 0],d02=x+2*gllz_10[ 1],
               d03=x+2*gllz_10[ 2],d04=x+2*gllz_10[ 3],d05=x-2*gllz_10[ 3],
               d06=x-2*gllz_10[ 2],d07=x-2*gllz_10[ 1],d08=x-2*gllz_10[ 0],
               d09=x-2            ;
  const double u0_01=    1*d00,u0_02=u0_01*d01,u0_03=u0_02*d02,
               u0_04=u0_03*d03,u0_05=u0_04*d04,u0_06=u0_05*d05,
               u0_07=u0_06*d06,u0_08=u0_07*d07,u0_09=u0_08*d08;
  const double v0_08=d09*    1,v0_07=d08*v0_08,v0_06=d07*v0_07,
               v0_05=d06*v0_06,v0_04=d05*v0_05,v0_03=d04*v0_04,
               v0_02=d03*v0_03,v0_01=d02*v0_02,v0_00=d01*v0_01;
  p[ 0]=w[ 0]*    1*v0_00; p[ 1]=w[ 1]*u0_01*v0_01; p[ 2]=w[ 2]*u0_02*v0_02;
  p[ 3]=w[ 3]*u0_03*v0_03; p[ 4]=w[ 4]*u0_04*v0_04; p[ 5]=w[ 5]*u0_05*v0_05;
  p[ 6]=w[ 6]*u0_06*v0_06; p[ 7]=w[ 7]*u0_07*v0_07; p[ 8]=w[ 8]*u0_08*v0_08;
  p[ 9]=w[ 9]*u0_09*    1;
  if(d>0) {
    const double u1_02=    1*d01+u0_01,u1_03=u1_02*d02+u0_02,
                 u1_04=u1_03*d03+u0_03,u1_05=u1_04*d04+u0_04,
                 u1_06=u1_05*d05+u0_05,u1_07=u1_06*d06+u0_06,
                 u1_08=u1_07*d07+u0_07,u1_09=u1_08*d08+u0_08;
    const double v1_07=d08*    1+v0_08,v1_06=d07*v1_07+v0_07,
                 v1_05=d06*v1_06+v0_06,v1_04=d05*v1_05+v0_05,
                 v1_03=d04*v1_04+v0_04,v1_02=d03*v1_03+v0_03,
                 v1_01=d02*v1_02+v0_02,v1_00=d01*v1_01+v0_01;
    p[10+ 0]=2*w[ 0]*(                  v1_00);
    p[10+ 1]=2*w[ 1]*(    1*v0_01+u0_01*v1_01);
    p[10+ 2]=2*w[ 2]*(u1_02*v0_02+u0_02*v1_02);
    p[10+ 3]=2*w[ 3]*(u1_03*v0_03+u0_03*v1_03);
    p[10+ 4]=2*w[ 4]*(u1_04*v0_04+u0_04*v1_04);
    p[10+ 5]=2*w[ 5]*(u1_05*v0_05+u0_05*v1_05);
    p[10+ 6]=2*w[ 6]*(u1_06*v0_06+u0_06*v1_06);
    p[10+ 7]=2*w[ 7]*(u1_07*v0_07+u0_07*v1_07);
    p[10+ 8]=2*w[ 8]*(u1_08*v0_08+u0_08*    1);
    p[10+ 9]=2*w[ 9]*(u1_09                  );
    if(d>1) {
      const double u2_03=    2*d02+2*u1_02,u2_04=u2_03*d03+2*u1_03,
                   u2_05=u2_04*d04+2*u1_04,u2_06=u2_05*d05+2*u1_05,
                   u2_07=u2_06*d06+2*u1_06,u2_08=u2_07*d07+2*u1_07,
                   u2_09=u2_08*d08+2*u1_08;
      const double v2_06=d07*    2+2*v1_07,v2_05=d06*v2_06+2*v1_06,
                   v2_04=d05*v2_05+2*v1_05,v2_03=d04*v2_04+2*v1_04,
                   v2_02=d03*v2_03+2*v1_03,v2_01=d02*v2_02+2*v1_02,
                   v2_00=d01*v2_01+2*v1_01;
      p[2*10+ 0]=4*w[ 0]*(                         +    1*v2_00);
      p[2*10+ 1]=4*w[ 1]*(           +2*    1*v1_01+u0_01*v2_01);
      p[2*10+ 2]=4*w[ 2]*(    2*v0_02+2*u1_02*v1_02+u0_02*v2_02);
      p[2*10+ 3]=4*w[ 3]*(u2_03*v0_03+2*u1_03*v1_03+u0_03*v2_03);
      p[2*10+ 4]=4*w[ 4]*(u2_04*v0_04+2*u1_04*v1_04+u0_04*v2_04);
      p[2*10+ 5]=4*w[ 5]*(u2_05*v0_05+2*u1_05*v1_05+u0_05*v2_05);
      p[2*10+ 6]=4*w[ 6]*(u2_06*v0_06+2*u1_06*v1_06+u0_06*v2_06);
      p[2*10+ 7]=4*w[ 7]*(u2_07*v0_07+2*u1_07*v1_07+u0_07*    2);
      p[2*10+ 8]=4*w[ 8]*(u2_08*v0_08+2*u1_08*    1            );
      p[2*10+ 9]=4*w[ 9]*(u2_09*    1                          );
    }
  }
}

static const double gllz_11[ 4] = {
  0.93400143040805913433227413609938363453991733010996,
  0.78448347366314441862241781610845810350719745509406,
  0.56523532699620500647096396947775166428305214556202,
  0.2957581355869393914319115155590575089410064343486
};

static void gll_lag_11(double *restrict p, double *restrict w,
                       unsigned n, int d, double xh)
{
  const double x = xh*2;
  const double d00=x+2            ,d01=x+2*gllz_11[ 0],d02=x+2*gllz_11[ 1],
               d03=x+2*gllz_11[ 2],d04=x+2*gllz_11[ 3],d05=x              ,
               d06=x-2*gllz_11[ 3],d07=x-2*gllz_11[ 2],d08=x-2*gllz_11[ 1],
               d09=x-2*gllz_11[ 0],d10=x-2            ;
  const double u0_01=    1*d00,u0_02=u0_01*d01,u0_03=u0_02*d02,
               u0_04=u0_03*d03,u0_05=u0_04*d04,u0_06=u0_05*d05,
               u0_07=u0_06*d06,u0_08=u0_07*d07,u0_09=u0_08*d08,
               u0_10=u0_09*d09;
  const double v0_09=d10*    1,v0_08=d09*v0_09,v0_07=d08*v0_08,
               v0_06=d07*v0_07,v0_05=d06*v0_06,v0_04=d05*v0_05,
               v0_03=d04*v0_04,v0_02=d03*v0_03,v0_01=d02*v0_02,
               v0_00=d01*v0_01;
  p[ 0]=w[ 0]*    1*v0_00; p[ 1]=w[ 1]*u0_01*v0_01; p[ 2]=w[ 2]*u0_02*v0_02;
  p[ 3]=w[ 3]*u0_03*v0_03; p[ 4]=w[ 4]*u0_04*v0_04; p[ 5]=w[ 5]*u0_05*v0_05;
  p[ 6]=w[ 6]*u0_06*v0_06; p[ 7]=w[ 7]*u0_07*v0_07; p[ 8]=w[ 8]*u0_08*v0_08;
  p[ 9]=w[ 9]*u0_09*v0_09; p[10]=w[10]*u0_10*    1;
  if(d>0) {
    const double u1_02=    1*d01+u0_01,u1_03=u1_02*d02+u0_02,
                 u1_04=u1_03*d03+u0_03,u1_05=u1_04*d04+u0_04,
                 u1_06=u1_05*d05+u0_05,u1_07=u1_06*d06+u0_06,
                 u1_08=u1_07*d07+u0_07,u1_09=u1_08*d08+u0_08,
                 u1_10=u1_09*d09+u0_09;
    const double v1_08=d09*    1+v0_09,v1_07=d08*v1_08+v0_08,
                 v1_06=d07*v1_07+v0_07,v1_05=d06*v1_06+v0_06,
                 v1_04=d05*v1_05+v0_05,v1_03=d04*v1_04+v0_04,
                 v1_02=d03*v1_03+v0_03,v1_01=d02*v1_02+v0_02,
                 v1_00=d01*v1_01+v0_01;
    p[11+ 0]=2*w[ 0]*(                  v1_00);
    p[11+ 1]=2*w[ 1]*(    1*v0_01+u0_01*v1_01);
    p[11+ 2]=2*w[ 2]*(u1_02*v0_02+u0_02*v1_02);
    p[11+ 3]=2*w[ 3]*(u1_03*v0_03+u0_03*v1_03);
    p[11+ 4]=2*w[ 4]*(u1_04*v0_04+u0_04*v1_04);
    p[11+ 5]=2*w[ 5]*(u1_05*v0_05+u0_05*v1_05);
    p[11+ 6]=2*w[ 6]*(u1_06*v0_06+u0_06*v1_06);
    p[11+ 7]=2*w[ 7]*(u1_07*v0_07+u0_07*v1_07);
    p[11+ 8]=2*w[ 8]*(u1_08*v0_08+u0_08*v1_08);
    p[11+ 9]=2*w[ 9]*(u1_09*v0_09+u0_09*    1);
    p[11+10]=2*w[10]*(u1_10                  );
    if(d>1) {
      const double u2_03=    2*d02+2*u1_02,u2_04=u2_03*d03+2*u1_03,
                   u2_05=u2_04*d04+2*u1_04,u2_06=u2_05*d05+2*u1_05,
                   u2_07=u2_06*d06+2*u1_06,u2_08=u2_07*d07+2*u1_07,
                   u2_09=u2_08*d08+2*u1_08,u2_10=u2_09*d09+2*u1_09;
      const double v2_07=d08*    2+2*v1_08,v2_06=d07*v2_07+2*v1_07,
                   v2_05=d06*v2_06+2*v1_06,v2_04=d05*v2_05+2*v1_05,
                   v2_03=d04*v2_04+2*v1_04,v2_02=d03*v2_03+2*v1_03,
                   v2_01=d02*v2_02+2*v1_02,v2_00=d01*v2_01+2*v1_01;
      p[2*11+ 0]=4*w[ 0]*(                         +    1*v2_00);
      p[2*11+ 1]=4*w[ 1]*(           +2*    1*v1_01+u0_01*v2_01);
      p[2*11+ 2]=4*w[ 2]*(    2*v0_02+2*u1_02*v1_02+u0_02*v2_02);
      p[2*11+ 3]=4*w[ 3]*(u2_03*v0_03+2*u1_03*v1_03+u0_03*v2_03);
      p[2*11+ 4]=4*w[ 4]*(u2_04*v0_04+2*u1_04*v1_04+u0_04*v2_04);
      p[2*11+ 5]=4*w[ 5]*(u2_05*v0_05+2*u1_05*v1_05+u0_05*v2_05);
      p[2*11+ 6]=4*w[ 6]*(u2_06*v0_06+2*u1_06*v1_06+u0_06*v2_06);
      p[2*11+ 7]=4*w[ 7]*(u2_07*v0_07+2*u1_07*v1_07+u0_07*v2_07);
      p[2*11+ 8]=4*w[ 8]*(u2_08*v0_08+2*u1_08*v1_08+u0_08*    2);
      p[2*11+ 9]=4*w[ 9]*(u2_09*v0_09+2*u1_09*    1            );
      p[2*11+10]=4*w[10]*(u2_10*    1                          );
    }
  }
}

static const double gllz_12[ 5] = {
  0.94489927222288222340758013830321871361125655195003,
  0.81927932164400667834864158171690266069046665790364,
  0.6328761530318606776624048544436558582438437454015,
  0.39953094096534893226434979156696690052774803279531,
  0.13655293285492755486406185573969389689841411128206
};

static void gll_lag_12(double *restrict p, double *restrict w,
                       unsigned n, int d, double xh)
{
  const double x = xh*2;
  const double d00=x+2            ,d01=x+2*gllz_12[ 0],d02=x+2*gllz_12[ 1],
               d03=x+2*gllz_12[ 2],d04=x+2*gllz_12[ 3],d05=x+2*gllz_12[ 4],
               d06=x-2*gllz_12[ 4],d07=x-2*gllz_12[ 3],d08=x-2*gllz_12[ 2],
               d09=x-2*gllz_12[ 1],d10=x-2*gllz_12[ 0],d11=x-2            ;
  const double u0_01=    1*d00,u0_02=u0_01*d01,u0_03=u0_02*d02,
               u0_04=u0_03*d03,u0_05=u0_04*d04,u0_06=u0_05*d05,
               u0_07=u0_06*d06,u0_08=u0_07*d07,u0_09=u0_08*d08,
               u0_10=u0_09*d09,u0_11=u0_10*d10;
  const double v0_10=d11*    1,v0_09=d10*v0_10,v0_08=d09*v0_09,
               v0_07=d08*v0_08,v0_06=d07*v0_07,v0_05=d06*v0_06,
               v0_04=d05*v0_05,v0_03=d04*v0_04,v0_02=d03*v0_03,
               v0_01=d02*v0_02,v0_00=d01*v0_01;
  p[ 0]=w[ 0]*    1*v0_00; p[ 1]=w[ 1]*u0_01*v0_01; p[ 2]=w[ 2]*u0_02*v0_02;
  p[ 3]=w[ 3]*u0_03*v0_03; p[ 4]=w[ 4]*u0_04*v0_04; p[ 5]=w[ 5]*u0_05*v0_05;
  p[ 6]=w[ 6]*u0_06*v0_06; p[ 7]=w[ 7]*u0_07*v0_07; p[ 8]=w[ 8]*u0_08*v0_08;
  p[ 9]=w[ 9]*u0_09*v0_09; p[10]=w[10]*u0_10*v0_10; p[11]=w[11]*u0_11*    1;
  if(d>0) {
    const double u1_02=    1*d01+u0_01,u1_03=u1_02*d02+u0_02,
                 u1_04=u1_03*d03+u0_03,u1_05=u1_04*d04+u0_04,
                 u1_06=u1_05*d05+u0_05,u1_07=u1_06*d06+u0_06,
                 u1_08=u1_07*d07+u0_07,u1_09=u1_08*d08+u0_08,
                 u1_10=u1_09*d09+u0_09,u1_11=u1_10*d10+u0_10;
    const double v1_09=d10*    1+v0_10,v1_08=d09*v1_09+v0_09,
                 v1_07=d08*v1_08+v0_08,v1_06=d07*v1_07+v0_07,
                 v1_05=d06*v1_06+v0_06,v1_04=d05*v1_05+v0_05,
                 v1_03=d04*v1_04+v0_04,v1_02=d03*v1_03+v0_03,
                 v1_01=d02*v1_02+v0_02,v1_00=d01*v1_01+v0_01;
    p[12+ 0]=2*w[ 0]*(                  v1_00);
    p[12+ 1]=2*w[ 1]*(    1*v0_01+u0_01*v1_01);
    p[12+ 2]=2*w[ 2]*(u1_02*v0_02+u0_02*v1_02);
    p[12+ 3]=2*w[ 3]*(u1_03*v0_03+u0_03*v1_03);
    p[12+ 4]=2*w[ 4]*(u1_04*v0_04+u0_04*v1_04);
    p[12+ 5]=2*w[ 5]*(u1_05*v0_05+u0_05*v1_05);
    p[12+ 6]=2*w[ 6]*(u1_06*v0_06+u0_06*v1_06);
    p[12+ 7]=2*w[ 7]*(u1_07*v0_07+u0_07*v1_07);
    p[12+ 8]=2*w[ 8]*(u1_08*v0_08+u0_08*v1_08);
    p[12+ 9]=2*w[ 9]*(u1_09*v0_09+u0_09*v1_09);
    p[12+10]=2*w[10]*(u1_10*v0_10+u0_10*    1);
    p[12+11]=2*w[11]*(u1_11                  );
    if(d>1) {
      const double u2_03=    2*d02+2*u1_02,u2_04=u2_03*d03+2*u1_03,
                   u2_05=u2_04*d04+2*u1_04,u2_06=u2_05*d05+2*u1_05,
                   u2_07=u2_06*d06+2*u1_06,u2_08=u2_07*d07+2*u1_07,
                   u2_09=u2_08*d08+2*u1_08,u2_10=u2_09*d09+2*u1_09,
                   u2_11=u2_10*d10+2*u1_10;
      const double v2_08=d09*    2+2*v1_09,v2_07=d08*v2_08+2*v1_08,
                   v2_06=d07*v2_07+2*v1_07,v2_05=d06*v2_06+2*v1_06,
                   v2_04=d05*v2_05+2*v1_05,v2_03=d04*v2_04+2*v1_04,
                   v2_02=d03*v2_03+2*v1_03,v2_01=d02*v2_02+2*v1_02,
                   v2_00=d01*v2_01+2*v1_01;
      p[2*12+ 0]=4*w[ 0]*(                         +    1*v2_00);
      p[2*12+ 1]=4*w[ 1]*(           +2*    1*v1_01+u0_01*v2_01);
      p[2*12+ 2]=4*w[ 2]*(    2*v0_02+2*u1_02*v1_02+u0_02*v2_02);
      p[2*12+ 3]=4*w[ 3]*(u2_03*v0_03+2*u1_03*v1_03+u0_03*v2_03);
      p[2*12+ 4]=4*w[ 4]*(u2_04*v0_04+2*u1_04*v1_04+u0_04*v2_04);
      p[2*12+ 5]=4*w[ 5]*(u2_05*v0_05+2*u1_05*v1_05+u0_05*v2_05);
      p[2*12+ 6]=4*w[ 6]*(u2_06*v0_06+2*u1_06*v1_06+u0_06*v2_06);
      p[2*12+ 7]=4*w[ 7]*(u2_07*v0_07+2*u1_07*v1_07+u0_07*v2_07);
      p[2*12+ 8]=4*w[ 8]*(u2_08*v0_08+2*u1_08*v1_08+u0_08*v2_08);
      p[2*12+ 9]=4*w[ 9]*(u2_09*v0_09+2*u1_09*v1_09+u0_09*    2);
      p[2*12+10]=4*w[10]*(u2_10*v0_10+2*u1_10*    1            );
      p[2*12+11]=4*w[11]*(u2_11*    1                          );
    }
  }
}

static const double gllz_13[ 5] = {
  0.95330984664216391189690546475544915162650788869736,
  0.84634756465187231686592560709875335957803665971441,
  0.68618846908175742607275903956635555292917619812438,
  0.48290982109133620174693723363693362077219326211859,
  0.24928693010623999256867370037422698148881131249298
};

static void gll_lag_13(double *restrict p, double *restrict w,
                       unsigned n, int d, double xh)
{
  const double x = xh*2;
  const double d00=x+2            ,d01=x+2*gllz_13[ 0],d02=x+2*gllz_13[ 1],
               d03=x+2*gllz_13[ 2],d04=x+2*gllz_13[ 3],d05=x+2*gllz_13[ 4],
               d06=x              ,d07=x-2*gllz_13[ 4],d08=x-2*gllz_13[ 3],
               d09=x-2*gllz_13[ 2],d10=x-2*gllz_13[ 1],d11=x-2*gllz_13[ 0],
               d12=x-2            ;
  const double u0_01=    1*d00,u0_02=u0_01*d01,u0_03=u0_02*d02,
               u0_04=u0_03*d03,u0_05=u0_04*d04,u0_06=u0_05*d05,
               u0_07=u0_06*d06,u0_08=u0_07*d07,u0_09=u0_08*d08,
               u0_10=u0_09*d09,u0_11=u0_10*d10,u0_12=u0_11*d11;
  const double v0_11=d12*    1,v0_10=d11*v0_11,v0_09=d10*v0_10,
               v0_08=d09*v0_09,v0_07=d08*v0_08,v0_06=d07*v0_07,
               v0_05=d06*v0_06,v0_04=d05*v0_05,v0_03=d04*v0_04,
               v0_02=d03*v0_03,v0_01=d02*v0_02,v0_00=d01*v0_01;
  p[ 0]=w[ 0]*    1*v0_00; p[ 1]=w[ 1]*u0_01*v0_01; p[ 2]=w[ 2]*u0_02*v0_02;
  p[ 3]=w[ 3]*u0_03*v0_03; p[ 4]=w[ 4]*u0_04*v0_04; p[ 5]=w[ 5]*u0_05*v0_05;
  p[ 6]=w[ 6]*u0_06*v0_06; p[ 7]=w[ 7]*u0_07*v0_07; p[ 8]=w[ 8]*u0_08*v0_08;
  p[ 9]=w[ 9]*u0_09*v0_09; p[10]=w[10]*u0_10*v0_10; p[11]=w[11]*u0_11*v0_11;
  p[12]=w[12]*u0_12*    1;
  if(d>0) {
    const double u1_02=    1*d01+u0_01,u1_03=u1_02*d02+u0_02,
                 u1_04=u1_03*d03+u0_03,u1_05=u1_04*d04+u0_04,
                 u1_06=u1_05*d05+u0_05,u1_07=u1_06*d06+u0_06,
                 u1_08=u1_07*d07+u0_07,u1_09=u1_08*d08+u0_08,
                 u1_10=u1_09*d09+u0_09,u1_11=u1_10*d10+u0_10,
                 u1_12=u1_11*d11+u0_11;
    const double v1_10=d11*    1+v0_11,v1_09=d10*v1_10+v0_10,
                 v1_08=d09*v1_09+v0_09,v1_07=d08*v1_08+v0_08,
                 v1_06=d07*v1_07+v0_07,v1_05=d06*v1_06+v0_06,
                 v1_04=d05*v1_05+v0_05,v1_03=d04*v1_04+v0_04,
                 v1_02=d03*v1_03+v0_03,v1_01=d02*v1_02+v0_02,
                 v1_00=d01*v1_01+v0_01;
    p[13+ 0]=2*w[ 0]*(                  v1_00);
    p[13+ 1]=2*w[ 1]*(    1*v0_01+u0_01*v1_01);
    p[13+ 2]=2*w[ 2]*(u1_02*v0_02+u0_02*v1_02);
    p[13+ 3]=2*w[ 3]*(u1_03*v0_03+u0_03*v1_03);
    p[13+ 4]=2*w[ 4]*(u1_04*v0_04+u0_04*v1_04);
    p[13+ 5]=2*w[ 5]*(u1_05*v0_05+u0_05*v1_05);
    p[13+ 6]=2*w[ 6]*(u1_06*v0_06+u0_06*v1_06);
    p[13+ 7]=2*w[ 7]*(u1_07*v0_07+u0_07*v1_07);
    p[13+ 8]=2*w[ 8]*(u1_08*v0_08+u0_08*v1_08);
    p[13+ 9]=2*w[ 9]*(u1_09*v0_09+u0_09*v1_09);
    p[13+10]=2*w[10]*(u1_10*v0_10+u0_10*v1_10);
    p[13+11]=2*w[11]*(u1_11*v0_11+u0_11*    1);
    p[13+12]=2*w[12]*(u1_12                  );
    if(d>1) {
      const double u2_03=    2*d02+2*u1_02,u2_04=u2_03*d03+2*u1_03,
                   u2_05=u2_04*d04+2*u1_04,u2_06=u2_05*d05+2*u1_05,
                   u2_07=u2_06*d06+2*u1_06,u2_08=u2_07*d07+2*u1_07,
                   u2_09=u2_08*d08+2*u1_08,u2_10=u2_09*d09+2*u1_09,
                   u2_11=u2_10*d10+2*u1_10,u2_12=u2_11*d11+2*u1_11;
      const double v2_09=d10*    2+2*v1_10,v2_08=d09*v2_09+2*v1_09,
                   v2_07=d08*v2_08+2*v1_08,v2_06=d07*v2_07+2*v1_07,
                   v2_05=d06*v2_06+2*v1_06,v2_04=d05*v2_05+2*v1_05,
                   v2_03=d04*v2_04+2*v1_04,v2_02=d03*v2_03+2*v1_03,
                   v2_01=d02*v2_02+2*v1_02,v2_00=d01*v2_01+2*v1_01;
      p[2*13+ 0]=4*w[ 0]*(                         +    1*v2_00);
      p[2*13+ 1]=4*w[ 1]*(           +2*    1*v1_01+u0_01*v2_01);
      p[2*13+ 2]=4*w[ 2]*(    2*v0_02+2*u1_02*v1_02+u0_02*v2_02);
      p[2*13+ 3]=4*w[ 3]*(u2_03*v0_03+2*u1_03*v1_03+u0_03*v2_03);
      p[2*13+ 4]=4*w[ 4]*(u2_04*v0_04+2*u1_04*v1_04+u0_04*v2_04);
      p[2*13+ 5]=4*w[ 5]*(u2_05*v0_05+2*u1_05*v1_05+u0_05*v2_05);
      p[2*13+ 6]=4*w[ 6]*(u2_06*v0_06+2*u1_06*v1_06+u0_06*v2_06);
      p[2*13+ 7]=4*w[ 7]*(u2_07*v0_07+2*u1_07*v1_07+u0_07*v2_07);
      p[2*13+ 8]=4*w[ 8]*(u2_08*v0_08+2*u1_08*v1_08+u0_08*v2_08);
      p[2*13+ 9]=4*w[ 9]*(u2_09*v0_09+2*u1_09*v1_09+u0_09*v2_09);
      p[2*13+10]=4*w[10]*(u2_10*v0_10+2*u1_10*v1_10+u0_10*    2);
      p[2*13+11]=4*w[11]*(u2_11*v0_11+2*u1_11*    1            );
      p[2*13+12]=4*w[12]*(u2_12*    1                          );
    }
  }
}

static const double gllz_14[ 6] = {
  0.95993504526726090135510016201542438906639151857265,
  0.86780105383034725100022020290826421324987235309444,
  0.72886859909132614058467240052088159565733953169432,
  0.55063940292864705531662270585908063446213831955391,
  0.34272401334271284504390340364167464483311353414031,
  0.11633186888370386765877670973616016794150904425628
};

static void gll_lag_14(double *restrict p, double *restrict w,
                       unsigned n, int d, double xh)
{
  const double x = xh*2;
  const double d00=x+2            ,d01=x+2*gllz_14[ 0],d02=x+2*gllz_14[ 1],
               d03=x+2*gllz_14[ 2],d04=x+2*gllz_14[ 3],d05=x+2*gllz_14[ 4],
               d06=x+2*gllz_14[ 5],d07=x-2*gllz_14[ 5],d08=x-2*gllz_14[ 4],
               d09=x-2*gllz_14[ 3],d10=x-2*gllz_14[ 2],d11=x-2*gllz_14[ 1],
               d12=x-2*gllz_14[ 0],d13=x-2            ;
  const double u0_01=    1*d00,u0_02=u0_01*d01,u0_03=u0_02*d02,
               u0_04=u0_03*d03,u0_05=u0_04*d04,u0_06=u0_05*d05,
               u0_07=u0_06*d06,u0_08=u0_07*d07,u0_09=u0_08*d08,
               u0_10=u0_09*d09,u0_11=u0_10*d10,u0_12=u0_11*d11,
               u0_13=u0_12*d12;
  const double v0_12=d13*    1,v0_11=d12*v0_12,v0_10=d11*v0_11,
               v0_09=d10*v0_10,v0_08=d09*v0_09,v0_07=d08*v0_08,
               v0_06=d07*v0_07,v0_05=d06*v0_06,v0_04=d05*v0_05,
               v0_03=d04*v0_04,v0_02=d03*v0_03,v0_01=d02*v0_02,
               v0_00=d01*v0_01;
  p[ 0]=w[ 0]*    1*v0_00; p[ 1]=w[ 1]*u0_01*v0_01; p[ 2]=w[ 2]*u0_02*v0_02;
  p[ 3]=w[ 3]*u0_03*v0_03; p[ 4]=w[ 4]*u0_04*v0_04; p[ 5]=w[ 5]*u0_05*v0_05;
  p[ 6]=w[ 6]*u0_06*v0_06; p[ 7]=w[ 7]*u0_07*v0_07; p[ 8]=w[ 8]*u0_08*v0_08;
  p[ 9]=w[ 9]*u0_09*v0_09; p[10]=w[10]*u0_10*v0_10; p[11]=w[11]*u0_11*v0_11;
  p[12]=w[12]*u0_12*v0_12; p[13]=w[13]*u0_13*    1;
  if(d>0) {
    const double u1_02=    1*d01+u0_01,u1_03=u1_02*d02+u0_02,
                 u1_04=u1_03*d03+u0_03,u1_05=u1_04*d04+u0_04,
                 u1_06=u1_05*d05+u0_05,u1_07=u1_06*d06+u0_06,
                 u1_08=u1_07*d07+u0_07,u1_09=u1_08*d08+u0_08,
                 u1_10=u1_09*d09+u0_09,u1_11=u1_10*d10+u0_10,
                 u1_12=u1_11*d11+u0_11,u1_13=u1_12*d12+u0_12;
    const double v1_11=d12*    1+v0_12,v1_10=d11*v1_11+v0_11,
                 v1_09=d10*v1_10+v0_10,v1_08=d09*v1_09+v0_09,
                 v1_07=d08*v1_08+v0_08,v1_06=d07*v1_07+v0_07,
                 v1_05=d06*v1_06+v0_06,v1_04=d05*v1_05+v0_05,
                 v1_03=d04*v1_04+v0_04,v1_02=d03*v1_03+v0_03,
                 v1_01=d02*v1_02+v0_02,v1_00=d01*v1_01+v0_01;
    p[14+ 0]=2*w[ 0]*(                  v1_00);
    p[14+ 1]=2*w[ 1]*(    1*v0_01+u0_01*v1_01);
    p[14+ 2]=2*w[ 2]*(u1_02*v0_02+u0_02*v1_02);
    p[14+ 3]=2*w[ 3]*(u1_03*v0_03+u0_03*v1_03);
    p[14+ 4]=2*w[ 4]*(u1_04*v0_04+u0_04*v1_04);
    p[14+ 5]=2*w[ 5]*(u1_05*v0_05+u0_05*v1_05);
    p[14+ 6]=2*w[ 6]*(u1_06*v0_06+u0_06*v1_06);
    p[14+ 7]=2*w[ 7]*(u1_07*v0_07+u0_07*v1_07);
    p[14+ 8]=2*w[ 8]*(u1_08*v0_08+u0_08*v1_08);
    p[14+ 9]=2*w[ 9]*(u1_09*v0_09+u0_09*v1_09);
    p[14+10]=2*w[10]*(u1_10*v0_10+u0_10*v1_10);
    p[14+11]=2*w[11]*(u1_11*v0_11+u0_11*v1_11);
    p[14+12]=2*w[12]*(u1_12*v0_12+u0_12*    1);
    p[14+13]=2*w[13]*(u1_13                  );
    if(d>1) {
      const double u2_03=    2*d02+2*u1_02,u2_04=u2_03*d03+2*u1_03,
                   u2_05=u2_04*d04+2*u1_04,u2_06=u2_05*d05+2*u1_05,
                   u2_07=u2_06*d06+2*u1_06,u2_08=u2_07*d07+2*u1_07,
                   u2_09=u2_08*d08+2*u1_08,u2_10=u2_09*d09+2*u1_09,
                   u2_11=u2_10*d10+2*u1_10,u2_12=u2_11*d11+2*u1_11,
                   u2_13=u2_12*d12+2*u1_12;
      const double v2_10=d11*    2+2*v1_11,v2_09=d10*v2_10+2*v1_10,
                   v2_08=d09*v2_09+2*v1_09,v2_07=d08*v2_08+2*v1_08,
                   v2_06=d07*v2_07+2*v1_07,v2_05=d06*v2_06+2*v1_06,
                   v2_04=d05*v2_05+2*v1_05,v2_03=d04*v2_04+2*v1_04,
                   v2_02=d03*v2_03+2*v1_03,v2_01=d02*v2_02+2*v1_02,
                   v2_00=d01*v2_01+2*v1_01;
      p[2*14+ 0]=4*w[ 0]*(                         +    1*v2_00);
      p[2*14+ 1]=4*w[ 1]*(           +2*    1*v1_01+u0_01*v2_01);
      p[2*14+ 2]=4*w[ 2]*(    2*v0_02+2*u1_02*v1_02+u0_02*v2_02);
      p[2*14+ 3]=4*w[ 3]*(u2_03*v0_03+2*u1_03*v1_03+u0_03*v2_03);
      p[2*14+ 4]=4*w[ 4]*(u2_04*v0_04+2*u1_04*v1_04+u0_04*v2_04);
      p[2*14+ 5]=4*w[ 5]*(u2_05*v0_05+2*u1_05*v1_05+u0_05*v2_05);
      p[2*14+ 6]=4*w[ 6]*(u2_06*v0_06+2*u1_06*v1_06+u0_06*v2_06);
      p[2*14+ 7]=4*w[ 7]*(u2_07*v0_07+2*u1_07*v1_07+u0_07*v2_07);
      p[2*14+ 8]=4*w[ 8]*(u2_08*v0_08+2*u1_08*v1_08+u0_08*v2_08);
      p[2*14+ 9]=4*w[ 9]*(u2_09*v0_09+2*u1_09*v1_09+u0_09*v2_09);
      p[2*14+10]=4*w[10]*(u2_10*v0_10+2*u1_10*v1_10+u0_10*v2_10);
      p[2*14+11]=4*w[11]*(u2_11*v0_11+2*u1_11*v1_11+u0_11*    2);
      p[2*14+12]=4*w[12]*(u2_12*v0_12+2*u1_12*    1            );
      p[2*14+13]=4*w[13]*(u2_13*    1                          );
    }
  }
}

static const double gllz_15[ 6] = {
  0.96524592650383857279585139206960117770765013599709,
  0.88508204422297629882540163148222965198871408520748,
  0.76351968995181520070411847597629161817736852031529,
  0.60625320546984571112352993863673350717973103375992,
  0.42063805471367248092189693873858041298433820549243,
  0.21535395536379423822567944627291771265215790120304
};

static void gll_lag_15(double *restrict p, double *restrict w,
                       unsigned n, int d, double xh)
{
  const double x = xh*2;
  const double d00=x+2            ,d01=x+2*gllz_15[ 0],d02=x+2*gllz_15[ 1],
               d03=x+2*gllz_15[ 2],d04=x+2*gllz_15[ 3],d05=x+2*gllz_15[ 4],
               d06=x+2*gllz_15[ 5],d07=x              ,d08=x-2*gllz_15[ 5],
               d09=x-2*gllz_15[ 4],d10=x-2*gllz_15[ 3],d11=x-2*gllz_15[ 2],
               d12=x-2*gllz_15[ 1],d13=x-2*gllz_15[ 0],d14=x-2            ;
  const double u0_01=    1*d00,u0_02=u0_01*d01,u0_03=u0_02*d02,
               u0_04=u0_03*d03,u0_05=u0_04*d04,u0_06=u0_05*d05,
               u0_07=u0_06*d06,u0_08=u0_07*d07,u0_09=u0_08*d08,
               u0_10=u0_09*d09,u0_11=u0_10*d10,u0_12=u0_11*d11,
               u0_13=u0_12*d12,u0_14=u0_13*d13;
  const double v0_13=d14*    1,v0_12=d13*v0_13,v0_11=d12*v0_12,
               v0_10=d11*v0_11,v0_09=d10*v0_10,v0_08=d09*v0_09,
               v0_07=d08*v0_08,v0_06=d07*v0_07,v0_05=d06*v0_06,
               v0_04=d05*v0_05,v0_03=d04*v0_04,v0_02=d03*v0_03,
               v0_01=d02*v0_02,v0_00=d01*v0_01;
  p[ 0]=w[ 0]*    1*v0_00; p[ 1]=w[ 1]*u0_01*v0_01; p[ 2]=w[ 2]*u0_02*v0_02;
  p[ 3]=w[ 3]*u0_03*v0_03; p[ 4]=w[ 4]*u0_04*v0_04; p[ 5]=w[ 5]*u0_05*v0_05;
  p[ 6]=w[ 6]*u0_06*v0_06; p[ 7]=w[ 7]*u0_07*v0_07; p[ 8]=w[ 8]*u0_08*v0_08;
  p[ 9]=w[ 9]*u0_09*v0_09; p[10]=w[10]*u0_10*v0_10; p[11]=w[11]*u0_11*v0_11;
  p[12]=w[12]*u0_12*v0_12; p[13]=w[13]*u0_13*v0_13; p[14]=w[14]*u0_14*    1;
  if(d>0) {
    const double u1_02=    1*d01+u0_01,u1_03=u1_02*d02+u0_02,
                 u1_04=u1_03*d03+u0_03,u1_05=u1_04*d04+u0_04,
                 u1_06=u1_05*d05+u0_05,u1_07=u1_06*d06+u0_06,
                 u1_08=u1_07*d07+u0_07,u1_09=u1_08*d08+u0_08,
                 u1_10=u1_09*d09+u0_09,u1_11=u1_10*d10+u0_10,
                 u1_12=u1_11*d11+u0_11,u1_13=u1_12*d12+u0_12,
                 u1_14=u1_13*d13+u0_13;
    const double v1_12=d13*    1+v0_13,v1_11=d12*v1_12+v0_12,
                 v1_10=d11*v1_11+v0_11,v1_09=d10*v1_10+v0_10,
                 v1_08=d09*v1_09+v0_09,v1_07=d08*v1_08+v0_08,
                 v1_06=d07*v1_07+v0_07,v1_05=d06*v1_06+v0_06,
                 v1_04=d05*v1_05+v0_05,v1_03=d04*v1_04+v0_04,
                 v1_02=d03*v1_03+v0_03,v1_01=d02*v1_02+v0_02,
                 v1_00=d01*v1_01+v0_01;
    p[15+ 0]=2*w[ 0]*(                  v1_00);
    p[15+ 1]=2*w[ 1]*(    1*v0_01+u0_01*v1_01);
    p[15+ 2]=2*w[ 2]*(u1_02*v0_02+u0_02*v1_02);
    p[15+ 3]=2*w[ 3]*(u1_03*v0_03+u0_03*v1_03);
    p[15+ 4]=2*w[ 4]*(u1_04*v0_04+u0_04*v1_04);
    p[15+ 5]=2*w[ 5]*(u1_05*v0_05+u0_05*v1_05);
    p[15+ 6]=2*w[ 6]*(u1_06*v0_06+u0_06*v1_06);
    p[15+ 7]=2*w[ 7]*(u1_07*v0_07+u0_07*v1_07);
    p[15+ 8]=2*w[ 8]*(u1_08*v0_08+u0_08*v1_08);
    p[15+ 9]=2*w[ 9]*(u1_09*v0_09+u0_09*v1_09);
    p[15+10]=2*w[10]*(u1_10*v0_10+u0_10*v1_10);
    p[15+11]=2*w[11]*(u1_11*v0_11+u0_11*v1_11);
    p[15+12]=2*w[12]*(u1_12*v0_12+u0_12*v1_12);
    p[15+13]=2*w[13]*(u1_13*v0_13+u0_13*    1);
    p[15+14]=2*w[14]*(u1_14                  );
    if(d>1) {
      const double u2_03=    2*d02+2*u1_02,u2_04=u2_03*d03+2*u1_03,
                   u2_05=u2_04*d04+2*u1_04,u2_06=u2_05*d05+2*u1_05,
                   u2_07=u2_06*d06+2*u1_06,u2_08=u2_07*d07+2*u1_07,
                   u2_09=u2_08*d08+2*u1_08,u2_10=u2_09*d09+2*u1_09,
                   u2_11=u2_10*d10+2*u1_10,u2_12=u2_11*d11+2*u1_11,
                   u2_13=u2_12*d12+2*u1_12,u2_14=u2_13*d13+2*u1_13;
      const double v2_11=d12*    2+2*v1_12,v2_10=d11*v2_11+2*v1_11,
                   v2_09=d10*v2_10+2*v1_10,v2_08=d09*v2_09+2*v1_09,
                   v2_07=d08*v2_08+2*v1_08,v2_06=d07*v2_07+2*v1_07,
                   v2_05=d06*v2_06+2*v1_06,v2_04=d05*v2_05+2*v1_05,
                   v2_03=d04*v2_04+2*v1_04,v2_02=d03*v2_03+2*v1_03,
                   v2_01=d02*v2_02+2*v1_02,v2_00=d01*v2_01+2*v1_01;
      p[2*15+ 0]=4*w[ 0]*(                         +    1*v2_00);
      p[2*15+ 1]=4*w[ 1]*(           +2*    1*v1_01+u0_01*v2_01);
      p[2*15+ 2]=4*w[ 2]*(    2*v0_02+2*u1_02*v1_02+u0_02*v2_02);
      p[2*15+ 3]=4*w[ 3]*(u2_03*v0_03+2*u1_03*v1_03+u0_03*v2_03);
      p[2*15+ 4]=4*w[ 4]*(u2_04*v0_04+2*u1_04*v1_04+u0_04*v2_04);
      p[2*15+ 5]=4*w[ 5]*(u2_05*v0_05+2*u1_05*v1_05+u0_05*v2_05);
      p[2*15+ 6]=4*w[ 6]*(u2_06*v0_06+2*u1_06*v1_06+u0_06*v2_06);
      p[2*15+ 7]=4*w[ 7]*(u2_07*v0_07+2*u1_07*v1_07+u0_07*v2_07);
      p[2*15+ 8]=4*w[ 8]*(u2_08*v0_08+2*u1_08*v1_08+u0_08*v2_08);
      p[2*15+ 9]=4*w[ 9]*(u2_09*v0_09+2*u1_09*v1_09+u0_09*v2_09);
      p[2*15+10]=4*w[10]*(u2_10*v0_10+2*u1_10*v1_10+u0_10*v2_10);
      p[2*15+11]=4*w[11]*(u2_11*v0_11+2*u1_11*v1_11+u0_11*v2_11);
      p[2*15+12]=4*w[12]*(u2_12*v0_12+2*u1_12*v1_12+u0_12*    2);
      p[2*15+13]=4*w[13]*(u2_13*v0_13+2*u1_13*    1            );
      p[2*15+14]=4*w[14]*(u2_14*    1                          );
    }
  }
}

static const double gllz_16[ 7] = {
  0.96956804627021793295224273836745924138899074650383,
  0.89920053309347209299462826151984947674999760904514,
  0.7920082918618150639310882709631457058080738279802,
  0.65238870288249308946788321964058148032155801282957,
  0.48605942188713761178189078584687469688897730429825,
  0.29983046890076320809835345472230064781546097690778,
  0.10132627352194944784303300504591776253324091440019
};

static void gll_lag_16(double *restrict p, double *restrict w,
                       unsigned n, int d, double xh)
{
  const double x = xh*2;
  const double d00=x+2            ,d01=x+2*gllz_16[ 0],d02=x+2*gllz_16[ 1],
               d03=x+2*gllz_16[ 2],d04=x+2*gllz_16[ 3],d05=x+2*gllz_16[ 4],
               d06=x+2*gllz_16[ 5],d07=x+2*gllz_16[ 6],d08=x-2*gllz_16[ 6],
               d09=x-2*gllz_16[ 5],d10=x-2*gllz_16[ 4],d11=x-2*gllz_16[ 3],
               d12=x-2*gllz_16[ 2],d13=x-2*gllz_16[ 1],d14=x-2*gllz_16[ 0],
               d15=x-2            ;
  const double u0_01=    1*d00,u0_02=u0_01*d01,u0_03=u0_02*d02,
               u0_04=u0_03*d03,u0_05=u0_04*d04,u0_06=u0_05*d05,
               u0_07=u0_06*d06,u0_08=u0_07*d07,u0_09=u0_08*d08,
               u0_10=u0_09*d09,u0_11=u0_10*d10,u0_12=u0_11*d11,
               u0_13=u0_12*d12,u0_14=u0_13*d13,u0_15=u0_14*d14;
  const double v0_14=d15*    1,v0_13=d14*v0_14,v0_12=d13*v0_13,
               v0_11=d12*v0_12,v0_10=d11*v0_11,v0_09=d10*v0_10,
               v0_08=d09*v0_09,v0_07=d08*v0_08,v0_06=d07*v0_07,
               v0_05=d06*v0_06,v0_04=d05*v0_05,v0_03=d04*v0_04,
               v0_02=d03*v0_03,v0_01=d02*v0_02,v0_00=d01*v0_01;
  p[ 0]=w[ 0]*    1*v0_00; p[ 1]=w[ 1]*u0_01*v0_01; p[ 2]=w[ 2]*u0_02*v0_02;
  p[ 3]=w[ 3]*u0_03*v0_03; p[ 4]=w[ 4]*u0_04*v0_04; p[ 5]=w[ 5]*u0_05*v0_05;
  p[ 6]=w[ 6]*u0_06*v0_06; p[ 7]=w[ 7]*u0_07*v0_07; p[ 8]=w[ 8]*u0_08*v0_08;
  p[ 9]=w[ 9]*u0_09*v0_09; p[10]=w[10]*u0_10*v0_10; p[11]=w[11]*u0_11*v0_11;
  p[12]=w[12]*u0_12*v0_12; p[13]=w[13]*u0_13*v0_13; p[14]=w[14]*u0_14*v0_14;
  p[15]=w[15]*u0_15*    1;
  if(d>0) {
    const double u1_02=    1*d01+u0_01,u1_03=u1_02*d02+u0_02,
                 u1_04=u1_03*d03+u0_03,u1_05=u1_04*d04+u0_04,
                 u1_06=u1_05*d05+u0_05,u1_07=u1_06*d06+u0_06,
                 u1_08=u1_07*d07+u0_07,u1_09=u1_08*d08+u0_08,
                 u1_10=u1_09*d09+u0_09,u1_11=u1_10*d10+u0_10,
                 u1_12=u1_11*d11+u0_11,u1_13=u1_12*d12+u0_12,
                 u1_14=u1_13*d13+u0_13,u1_15=u1_14*d14+u0_14;
    const double v1_13=d14*    1+v0_14,v1_12=d13*v1_13+v0_13,
                 v1_11=d12*v1_12+v0_12,v1_10=d11*v1_11+v0_11,
                 v1_09=d10*v1_10+v0_10,v1_08=d09*v1_09+v0_09,
                 v1_07=d08*v1_08+v0_08,v1_06=d07*v1_07+v0_07,
                 v1_05=d06*v1_06+v0_06,v1_04=d05*v1_05+v0_05,
                 v1_03=d04*v1_04+v0_04,v1_02=d03*v1_03+v0_03,
                 v1_01=d02*v1_02+v0_02,v1_00=d01*v1_01+v0_01;
    p[16+ 0]=2*w[ 0]*(                  v1_00);
    p[16+ 1]=2*w[ 1]*(    1*v0_01+u0_01*v1_01);
    p[16+ 2]=2*w[ 2]*(u1_02*v0_02+u0_02*v1_02);
    p[16+ 3]=2*w[ 3]*(u1_03*v0_03+u0_03*v1_03);
    p[16+ 4]=2*w[ 4]*(u1_04*v0_04+u0_04*v1_04);
    p[16+ 5]=2*w[ 5]*(u1_05*v0_05+u0_05*v1_05);
    p[16+ 6]=2*w[ 6]*(u1_06*v0_06+u0_06*v1_06);
    p[16+ 7]=2*w[ 7]*(u1_07*v0_07+u0_07*v1_07);
    p[16+ 8]=2*w[ 8]*(u1_08*v0_08+u0_08*v1_08);
    p[16+ 9]=2*w[ 9]*(u1_09*v0_09+u0_09*v1_09);
    p[16+10]=2*w[10]*(u1_10*v0_10+u0_10*v1_10);
    p[16+11]=2*w[11]*(u1_11*v0_11+u0_11*v1_11);
    p[16+12]=2*w[12]*(u1_12*v0_12+u0_12*v1_12);
    p[16+13]=2*w[13]*(u1_13*v0_13+u0_13*v1_13);
    p[16+14]=2*w[14]*(u1_14*v0_14+u0_14*    1);
    p[16+15]=2*w[15]*(u1_15                  );
    if(d>1) {
      const double u2_03=    2*d02+2*u1_02,u2_04=u2_03*d03+2*u1_03,
                   u2_05=u2_04*d04+2*u1_04,u2_06=u2_05*d05+2*u1_05,
                   u2_07=u2_06*d06+2*u1_06,u2_08=u2_07*d07+2*u1_07,
                   u2_09=u2_08*d08+2*u1_08,u2_10=u2_09*d09+2*u1_09,
                   u2_11=u2_10*d10+2*u1_10,u2_12=u2_11*d11+2*u1_11,
                   u2_13=u2_12*d12+2*u1_12,u2_14=u2_13*d13+2*u1_13,
                   u2_15=u2_14*d14+2*u1_14;
      const double v2_12=d13*    2+2*v1_13,v2_11=d12*v2_12+2*v1_12,
                   v2_10=d11*v2_11+2*v1_11,v2_09=d10*v2_10+2*v1_10,
                   v2_08=d09*v2_09+2*v1_09,v2_07=d08*v2_08+2*v1_08,
                   v2_06=d07*v2_07+2*v1_07,v2_05=d06*v2_06+2*v1_06,
                   v2_04=d05*v2_05+2*v1_05,v2_03=d04*v2_04+2*v1_04,
                   v2_02=d03*v2_03+2*v1_03,v2_01=d02*v2_02+2*v1_02,
                   v2_00=d01*v2_01+2*v1_01;
      p[2*16+ 0]=4*w[ 0]*(                         +    1*v2_00);
      p[2*16+ 1]=4*w[ 1]*(           +2*    1*v1_01+u0_01*v2_01);
      p[2*16+ 2]=4*w[ 2]*(    2*v0_02+2*u1_02*v1_02+u0_02*v2_02);
      p[2*16+ 3]=4*w[ 3]*(u2_03*v0_03+2*u1_03*v1_03+u0_03*v2_03);
      p[2*16+ 4]=4*w[ 4]*(u2_04*v0_04+2*u1_04*v1_04+u0_04*v2_04);
      p[2*16+ 5]=4*w[ 5]*(u2_05*v0_05+2*u1_05*v1_05+u0_05*v2_05);
      p[2*16+ 6]=4*w[ 6]*(u2_06*v0_06+2*u1_06*v1_06+u0_06*v2_06);
      p[2*16+ 7]=4*w[ 7]*(u2_07*v0_07+2*u1_07*v1_07+u0_07*v2_07);
      p[2*16+ 8]=4*w[ 8]*(u2_08*v0_08+2*u1_08*v1_08+u0_08*v2_08);
      p[2*16+ 9]=4*w[ 9]*(u2_09*v0_09+2*u1_09*v1_09+u0_09*v2_09);
      p[2*16+10]=4*w[10]*(u2_10*v0_10+2*u1_10*v1_10+u0_10*v2_10);
      p[2*16+11]=4*w[11]*(u2_11*v0_11+2*u1_11*v1_11+u0_11*v2_11);
      p[2*16+12]=4*w[12]*(u2_12*v0_12+2*u1_12*v1_12+u0_12*v2_12);
      p[2*16+13]=4*w[13]*(u2_13*v0_13+2*u1_13*v1_13+u0_13*    2);
      p[2*16+14]=4*w[14]*(u2_14*v0_14+2*u1_14*    1            );
      p[2*16+15]=4*w[15]*(u2_15*    1                          );
    }
  }
}

static const double gllz_17[ 7] = {
  0.97313217663141831415697950187372143058895914912251,
  0.91087999591557359562380250639772646753087945186873,
  0.81569625122177030710675055323752665471640239706712,
  0.69102898062768470539491935737245329680641306219042,
  0.54138539933010153912373340750406325167514664796483,
  0.37217443356547704190723468073525781255981731440028,
  0.1895119735183173883042630147531139713449924229225
};

static void gll_lag_17(double *restrict p, double *restrict w,
                       unsigned n, int d, double xh)
{
  const double x = xh*2;
  const double d00=x+2            ,d01=x+2*gllz_17[ 0],d02=x+2*gllz_17[ 1],
               d03=x+2*gllz_17[ 2],d04=x+2*gllz_17[ 3],d05=x+2*gllz_17[ 4],
               d06=x+2*gllz_17[ 5],d07=x+2*gllz_17[ 6],d08=x              ,
               d09=x-2*gllz_17[ 6],d10=x-2*gllz_17[ 5],d11=x-2*gllz_17[ 4],
               d12=x-2*gllz_17[ 3],d13=x-2*gllz_17[ 2],d14=x-2*gllz_17[ 1],
               d15=x-2*gllz_17[ 0],d16=x-2            ;
  const double u0_01=    1*d00,u0_02=u0_01*d01,u0_03=u0_02*d02,
               u0_04=u0_03*d03,u0_05=u0_04*d04,u0_06=u0_05*d05,
               u0_07=u0_06*d06,u0_08=u0_07*d07,u0_09=u0_08*d08,
               u0_10=u0_09*d09,u0_11=u0_10*d10,u0_12=u0_11*d11,
               u0_13=u0_12*d12,u0_14=u0_13*d13,u0_15=u0_14*d14,
               u0_16=u0_15*d15;
  const double v0_15=d16*    1,v0_14=d15*v0_15,v0_13=d14*v0_14,
               v0_12=d13*v0_13,v0_11=d12*v0_12,v0_10=d11*v0_11,
               v0_09=d10*v0_10,v0_08=d09*v0_09,v0_07=d08*v0_08,
               v0_06=d07*v0_07,v0_05=d06*v0_06,v0_04=d05*v0_05,
               v0_03=d04*v0_04,v0_02=d03*v0_03,v0_01=d02*v0_02,
               v0_00=d01*v0_01;
  p[ 0]=w[ 0]*    1*v0_00; p[ 1]=w[ 1]*u0_01*v0_01; p[ 2]=w[ 2]*u0_02*v0_02;
  p[ 3]=w[ 3]*u0_03*v0_03; p[ 4]=w[ 4]*u0_04*v0_04; p[ 5]=w[ 5]*u0_05*v0_05;
  p[ 6]=w[ 6]*u0_06*v0_06; p[ 7]=w[ 7]*u0_07*v0_07; p[ 8]=w[ 8]*u0_08*v0_08;
  p[ 9]=w[ 9]*u0_09*v0_09; p[10]=w[10]*u0_10*v0_10; p[11]=w[11]*u0_11*v0_11;
  p[12]=w[12]*u0_12*v0_12; p[13]=w[13]*u0_13*v0_13; p[14]=w[14]*u0_14*v0_14;
  p[15]=w[15]*u0_15*v0_15; p[16]=w[16]*u0_16*    1;
  if(d>0) {
    const double u1_02=    1*d01+u0_01,u1_03=u1_02*d02+u0_02,
                 u1_04=u1_03*d03+u0_03,u1_05=u1_04*d04+u0_04,
                 u1_06=u1_05*d05+u0_05,u1_07=u1_06*d06+u0_06,
                 u1_08=u1_07*d07+u0_07,u1_09=u1_08*d08+u0_08,
                 u1_10=u1_09*d09+u0_09,u1_11=u1_10*d10+u0_10,
                 u1_12=u1_11*d11+u0_11,u1_13=u1_12*d12+u0_12,
                 u1_14=u1_13*d13+u0_13,u1_15=u1_14*d14+u0_14,
                 u1_16=u1_15*d15+u0_15;
    const double v1_14=d15*    1+v0_15,v1_13=d14*v1_14+v0_14,
                 v1_12=d13*v1_13+v0_13,v1_11=d12*v1_12+v0_12,
                 v1_10=d11*v1_11+v0_11,v1_09=d10*v1_10+v0_10,
                 v1_08=d09*v1_09+v0_09,v1_07=d08*v1_08+v0_08,
                 v1_06=d07*v1_07+v0_07,v1_05=d06*v1_06+v0_06,
                 v1_04=d05*v1_05+v0_05,v1_03=d04*v1_04+v0_04,
                 v1_02=d03*v1_03+v0_03,v1_01=d02*v1_02+v0_02,
                 v1_00=d01*v1_01+v0_01;
    p[17+ 0]=2*w[ 0]*(                  v1_00);
    p[17+ 1]=2*w[ 1]*(    1*v0_01+u0_01*v1_01);
    p[17+ 2]=2*w[ 2]*(u1_02*v0_02+u0_02*v1_02);
    p[17+ 3]=2*w[ 3]*(u1_03*v0_03+u0_03*v1_03);
    p[17+ 4]=2*w[ 4]*(u1_04*v0_04+u0_04*v1_04);
    p[17+ 5]=2*w[ 5]*(u1_05*v0_05+u0_05*v1_05);
    p[17+ 6]=2*w[ 6]*(u1_06*v0_06+u0_06*v1_06);
    p[17+ 7]=2*w[ 7]*(u1_07*v0_07+u0_07*v1_07);
    p[17+ 8]=2*w[ 8]*(u1_08*v0_08+u0_08*v1_08);
    p[17+ 9]=2*w[ 9]*(u1_09*v0_09+u0_09*v1_09);
    p[17+10]=2*w[10]*(u1_10*v0_10+u0_10*v1_10);
    p[17+11]=2*w[11]*(u1_11*v0_11+u0_11*v1_11);
    p[17+12]=2*w[12]*(u1_12*v0_12+u0_12*v1_12);
    p[17+13]=2*w[13]*(u1_13*v0_13+u0_13*v1_13);
    p[17+14]=2*w[14]*(u1_14*v0_14+u0_14*v1_14);
    p[17+15]=2*w[15]*(u1_15*v0_15+u0_15*    1);
    p[17+16]=2*w[16]*(u1_16                  );
    if(d>1) {
      const double u2_03=    2*d02+2*u1_02,u2_04=u2_03*d03+2*u1_03,
                   u2_05=u2_04*d04+2*u1_04,u2_06=u2_05*d05+2*u1_05,
                   u2_07=u2_06*d06+2*u1_06,u2_08=u2_07*d07+2*u1_07,
                   u2_09=u2_08*d08+2*u1_08,u2_10=u2_09*d09+2*u1_09,
                   u2_11=u2_10*d10+2*u1_10,u2_12=u2_11*d11+2*u1_11,
                   u2_13=u2_12*d12+2*u1_12,u2_14=u2_13*d13+2*u1_13,
                   u2_15=u2_14*d14+2*u1_14,u2_16=u2_15*d15+2*u1_15;
      const double v2_13=d14*    2+2*v1_14,v2_12=d13*v2_13+2*v1_13,
                   v2_11=d12*v2_12+2*v1_12,v2_10=d11*v2_11+2*v1_11,
                   v2_09=d10*v2_10+2*v1_10,v2_08=d09*v2_09+2*v1_09,
                   v2_07=d08*v2_08+2*v1_08,v2_06=d07*v2_07+2*v1_07,
                   v2_05=d06*v2_06+2*v1_06,v2_04=d05*v2_05+2*v1_05,
                   v2_03=d04*v2_04+2*v1_04,v2_02=d03*v2_03+2*v1_03,
                   v2_01=d02*v2_02+2*v1_02,v2_00=d01*v2_01+2*v1_01;
      p[2*17+ 0]=4*w[ 0]*(                         +    1*v2_00);
      p[2*17+ 1]=4*w[ 1]*(           +2*    1*v1_01+u0_01*v2_01);
      p[2*17+ 2]=4*w[ 2]*(    2*v0_02+2*u1_02*v1_02+u0_02*v2_02);
      p[2*17+ 3]=4*w[ 3]*(u2_03*v0_03+2*u1_03*v1_03+u0_03*v2_03);
      p[2*17+ 4]=4*w[ 4]*(u2_04*v0_04+2*u1_04*v1_04+u0_04*v2_04);
      p[2*17+ 5]=4*w[ 5]*(u2_05*v0_05+2*u1_05*v1_05+u0_05*v2_05);
      p[2*17+ 6]=4*w[ 6]*(u2_06*v0_06+2*u1_06*v1_06+u0_06*v2_06);
      p[2*17+ 7]=4*w[ 7]*(u2_07*v0_07+2*u1_07*v1_07+u0_07*v2_07);
      p[2*17+ 8]=4*w[ 8]*(u2_08*v0_08+2*u1_08*v1_08+u0_08*v2_08);
      p[2*17+ 9]=4*w[ 9]*(u2_09*v0_09+2*u1_09*v1_09+u0_09*v2_09);
      p[2*17+10]=4*w[10]*(u2_10*v0_10+2*u1_10*v1_10+u0_10*v2_10);
      p[2*17+11]=4*w[11]*(u2_11*v0_11+2*u1_11*v1_11+u0_11*v2_11);
      p[2*17+12]=4*w[12]*(u2_12*v0_12+2*u1_12*v1_12+u0_12*v2_12);
      p[2*17+13]=4*w[13]*(u2_13*v0_13+2*u1_13*v1_13+u0_13*v2_13);
      p[2*17+14]=4*w[14]*(u2_14*v0_14+2*u1_14*v1_14+u0_14*    2);
      p[2*17+15]=4*w[15]*(u2_15*v0_15+2*u1_15*    1            );
      p[2*17+16]=4*w[16]*(u2_16*    1                          );
    }
  }
}

static const double gllz_18[ 8] = {
  0.97610555741219854286451892434170006676181344271919,
  0.92064918534753387383785462543127742356235348618904,
  0.83559353521809021371364636232793725743367075916582,
  0.72367932928324268130621036530207067914952520415476,
  0.58850483431866176117353589319355946900083678931622,
  0.43441503691212397534228713674067479584975844516369,
  0.26636265287828098416766533202559594206513618931826,
  0.089749093484652111022645010088561734960603901041125
};

static void gll_lag_18(double *restrict p, double *restrict w,
                       unsigned n, int d, double xh)
{
  const double x = xh*2;
  const double d00=x+2            ,d01=x+2*gllz_18[ 0],d02=x+2*gllz_18[ 1],
               d03=x+2*gllz_18[ 2],d04=x+2*gllz_18[ 3],d05=x+2*gllz_18[ 4],
               d06=x+2*gllz_18[ 5],d07=x+2*gllz_18[ 6],d08=x+2*gllz_18[ 7],
               d09=x-2*gllz_18[ 7],d10=x-2*gllz_18[ 6],d11=x-2*gllz_18[ 5],
               d12=x-2*gllz_18[ 4],d13=x-2*gllz_18[ 3],d14=x-2*gllz_18[ 2],
               d15=x-2*gllz_18[ 1],d16=x-2*gllz_18[ 0],d17=x-2            ;
  const double u0_01=    1*d00,u0_02=u0_01*d01,u0_03=u0_02*d02,
               u0_04=u0_03*d03,u0_05=u0_04*d04,u0_06=u0_05*d05,
               u0_07=u0_06*d06,u0_08=u0_07*d07,u0_09=u0_08*d08,
               u0_10=u0_09*d09,u0_11=u0_10*d10,u0_12=u0_11*d11,
               u0_13=u0_12*d12,u0_14=u0_13*d13,u0_15=u0_14*d14,
               u0_16=u0_15*d15,u0_17=u0_16*d16;
  const double v0_16=d17*    1,v0_15=d16*v0_16,v0_14=d15*v0_15,
               v0_13=d14*v0_14,v0_12=d13*v0_13,v0_11=d12*v0_12,
               v0_10=d11*v0_11,v0_09=d10*v0_10,v0_08=d09*v0_09,
               v0_07=d08*v0_08,v0_06=d07*v0_07,v0_05=d06*v0_06,
               v0_04=d05*v0_05,v0_03=d04*v0_04,v0_02=d03*v0_03,
               v0_01=d02*v0_02,v0_00=d01*v0_01;
  p[ 0]=w[ 0]*    1*v0_00; p[ 1]=w[ 1]*u0_01*v0_01; p[ 2]=w[ 2]*u0_02*v0_02;
  p[ 3]=w[ 3]*u0_03*v0_03; p[ 4]=w[ 4]*u0_04*v0_04; p[ 5]=w[ 5]*u0_05*v0_05;
  p[ 6]=w[ 6]*u0_06*v0_06; p[ 7]=w[ 7]*u0_07*v0_07; p[ 8]=w[ 8]*u0_08*v0_08;
  p[ 9]=w[ 9]*u0_09*v0_09; p[10]=w[10]*u0_10*v0_10; p[11]=w[11]*u0_11*v0_11;
  p[12]=w[12]*u0_12*v0_12; p[13]=w[13]*u0_13*v0_13; p[14]=w[14]*u0_14*v0_14;
  p[15]=w[15]*u0_15*v0_15; p[16]=w[16]*u0_16*v0_16; p[17]=w[17]*u0_17*    1;
  if(d>0) {
    const double u1_02=    1*d01+u0_01,u1_03=u1_02*d02+u0_02,
                 u1_04=u1_03*d03+u0_03,u1_05=u1_04*d04+u0_04,
                 u1_06=u1_05*d05+u0_05,u1_07=u1_06*d06+u0_06,
                 u1_08=u1_07*d07+u0_07,u1_09=u1_08*d08+u0_08,
                 u1_10=u1_09*d09+u0_09,u1_11=u1_10*d10+u0_10,
                 u1_12=u1_11*d11+u0_11,u1_13=u1_12*d12+u0_12,
                 u1_14=u1_13*d13+u0_13,u1_15=u1_14*d14+u0_14,
                 u1_16=u1_15*d15+u0_15,u1_17=u1_16*d16+u0_16;
    const double v1_15=d16*    1+v0_16,v1_14=d15*v1_15+v0_15,
                 v1_13=d14*v1_14+v0_14,v1_12=d13*v1_13+v0_13,
                 v1_11=d12*v1_12+v0_12,v1_10=d11*v1_11+v0_11,
                 v1_09=d10*v1_10+v0_10,v1_08=d09*v1_09+v0_09,
                 v1_07=d08*v1_08+v0_08,v1_06=d07*v1_07+v0_07,
                 v1_05=d06*v1_06+v0_06,v1_04=d05*v1_05+v0_05,
                 v1_03=d04*v1_04+v0_04,v1_02=d03*v1_03+v0_03,
                 v1_01=d02*v1_02+v0_02,v1_00=d01*v1_01+v0_01;
    p[18+ 0]=2*w[ 0]*(                  v1_00);
    p[18+ 1]=2*w[ 1]*(    1*v0_01+u0_01*v1_01);
    p[18+ 2]=2*w[ 2]*(u1_02*v0_02+u0_02*v1_02);
    p[18+ 3]=2*w[ 3]*(u1_03*v0_03+u0_03*v1_03);
    p[18+ 4]=2*w[ 4]*(u1_04*v0_04+u0_04*v1_04);
    p[18+ 5]=2*w[ 5]*(u1_05*v0_05+u0_05*v1_05);
    p[18+ 6]=2*w[ 6]*(u1_06*v0_06+u0_06*v1_06);
    p[18+ 7]=2*w[ 7]*(u1_07*v0_07+u0_07*v1_07);
    p[18+ 8]=2*w[ 8]*(u1_08*v0_08+u0_08*v1_08);
    p[18+ 9]=2*w[ 9]*(u1_09*v0_09+u0_09*v1_09);
    p[18+10]=2*w[10]*(u1_10*v0_10+u0_10*v1_10);
    p[18+11]=2*w[11]*(u1_11*v0_11+u0_11*v1_11);
    p[18+12]=2*w[12]*(u1_12*v0_12+u0_12*v1_12);
    p[18+13]=2*w[13]*(u1_13*v0_13+u0_13*v1_13);
    p[18+14]=2*w[14]*(u1_14*v0_14+u0_14*v1_14);
    p[18+15]=2*w[15]*(u1_15*v0_15+u0_15*v1_15);
    p[18+16]=2*w[16]*(u1_16*v0_16+u0_16*    1);
    p[18+17]=2*w[17]*(u1_17                  );
    if(d>1) {
      const double u2_03=    2*d02+2*u1_02,u2_04=u2_03*d03+2*u1_03,
                   u2_05=u2_04*d04+2*u1_04,u2_06=u2_05*d05+2*u1_05,
                   u2_07=u2_06*d06+2*u1_06,u2_08=u2_07*d07+2*u1_07,
                   u2_09=u2_08*d08+2*u1_08,u2_10=u2_09*d09+2*u1_09,
                   u2_11=u2_10*d10+2*u1_10,u2_12=u2_11*d11+2*u1_11,
                   u2_13=u2_12*d12+2*u1_12,u2_14=u2_13*d13+2*u1_13,
                   u2_15=u2_14*d14+2*u1_14,u2_16=u2_15*d15+2*u1_15,
                   u2_17=u2_16*d16+2*u1_16;
      const double v2_14=d15*    2+2*v1_15,v2_13=d14*v2_14+2*v1_14,
                   v2_12=d13*v2_13+2*v1_13,v2_11=d12*v2_12+2*v1_12,
                   v2_10=d11*v2_11+2*v1_11,v2_09=d10*v2_10+2*v1_10,
                   v2_08=d09*v2_09+2*v1_09,v2_07=d08*v2_08+2*v1_08,
                   v2_06=d07*v2_07+2*v1_07,v2_05=d06*v2_06+2*v1_06,
                   v2_04=d05*v2_05+2*v1_05,v2_03=d04*v2_04+2*v1_04,
                   v2_02=d03*v2_03+2*v1_03,v2_01=d02*v2_02+2*v1_02,
                   v2_00=d01*v2_01+2*v1_01;
      p[2*18+ 0]=4*w[ 0]*(                         +    1*v2_00);
      p[2*18+ 1]=4*w[ 1]*(           +2*    1*v1_01+u0_01*v2_01);
      p[2*18+ 2]=4*w[ 2]*(    2*v0_02+2*u1_02*v1_02+u0_02*v2_02);
      p[2*18+ 3]=4*w[ 3]*(u2_03*v0_03+2*u1_03*v1_03+u0_03*v2_03);
      p[2*18+ 4]=4*w[ 4]*(u2_04*v0_04+2*u1_04*v1_04+u0_04*v2_04);
      p[2*18+ 5]=4*w[ 5]*(u2_05*v0_05+2*u1_05*v1_05+u0_05*v2_05);
      p[2*18+ 6]=4*w[ 6]*(u2_06*v0_06+2*u1_06*v1_06+u0_06*v2_06);
      p[2*18+ 7]=4*w[ 7]*(u2_07*v0_07+2*u1_07*v1_07+u0_07*v2_07);
      p[2*18+ 8]=4*w[ 8]*(u2_08*v0_08+2*u1_08*v1_08+u0_08*v2_08);
      p[2*18+ 9]=4*w[ 9]*(u2_09*v0_09+2*u1_09*v1_09+u0_09*v2_09);
      p[2*18+10]=4*w[10]*(u2_10*v0_10+2*u1_10*v1_10+u0_10*v2_10);
      p[2*18+11]=4*w[11]*(u2_11*v0_11+2*u1_11*v1_11+u0_11*v2_11);
      p[2*18+12]=4*w[12]*(u2_12*v0_12+2*u1_12*v1_12+u0_12*v2_12);
      p[2*18+13]=4*w[13]*(u2_13*v0_13+2*u1_13*v1_13+u0_13*v2_13);
      p[2*18+14]=4*w[14]*(u2_14*v0_14+2*u1_14*v1_14+u0_14*v2_14);
      p[2*18+15]=4*w[15]*(u2_15*v0_15+2*u1_15*v1_15+u0_15*    2);
      p[2*18+16]=4*w[16]*(u2_16*v0_16+2*u1_16*    1            );
      p[2*18+17]=4*w[17]*(u2_17*    1                          );
    }
  }
}

static const double gllz_19[ 8] = {
  0.97861176622208009515263406311022256281427733781081,
  0.92890152815258624371794025879654861245016818225195,
  0.85246057779664609308595597004106262523709538083887,
  0.7514942025526130141636374896339440404036593556658,
  0.62890813726522049776683230622873254706861115718956,
  0.48822928568071350277790963762492336977121559965148,
  0.33350484782449861029850010384492701192296337547773,
  0.16918602340928157137515415344488042375289555076585
};

static void gll_lag_19(double *restrict p, double *restrict w,
                       unsigned n, int d, double xh)
{
  const double x = xh*2;
  const double d00=x+2            ,d01=x+2*gllz_19[ 0],d02=x+2*gllz_19[ 1],
               d03=x+2*gllz_19[ 2],d04=x+2*gllz_19[ 3],d05=x+2*gllz_19[ 4],
               d06=x+2*gllz_19[ 5],d07=x+2*gllz_19[ 6],d08=x+2*gllz_19[ 7],
               d09=x              ,d10=x-2*gllz_19[ 7],d11=x-2*gllz_19[ 6],
               d12=x-2*gllz_19[ 5],d13=x-2*gllz_19[ 4],d14=x-2*gllz_19[ 3],
               d15=x-2*gllz_19[ 2],d16=x-2*gllz_19[ 1],d17=x-2*gllz_19[ 0],
               d18=x-2            ;
  const double u0_01=    1*d00,u0_02=u0_01*d01,u0_03=u0_02*d02,
               u0_04=u0_03*d03,u0_05=u0_04*d04,u0_06=u0_05*d05,
               u0_07=u0_06*d06,u0_08=u0_07*d07,u0_09=u0_08*d08,
               u0_10=u0_09*d09,u0_11=u0_10*d10,u0_12=u0_11*d11,
               u0_13=u0_12*d12,u0_14=u0_13*d13,u0_15=u0_14*d14,
               u0_16=u0_15*d15,u0_17=u0_16*d16,u0_18=u0_17*d17;
  const double v0_17=d18*    1,v0_16=d17*v0_17,v0_15=d16*v0_16,
               v0_14=d15*v0_15,v0_13=d14*v0_14,v0_12=d13*v0_13,
               v0_11=d12*v0_12,v0_10=d11*v0_11,v0_09=d10*v0_10,
               v0_08=d09*v0_09,v0_07=d08*v0_08,v0_06=d07*v0_07,
               v0_05=d06*v0_06,v0_04=d05*v0_05,v0_03=d04*v0_04,
               v0_02=d03*v0_03,v0_01=d02*v0_02,v0_00=d01*v0_01;
  p[ 0]=w[ 0]*    1*v0_00; p[ 1]=w[ 1]*u0_01*v0_01; p[ 2]=w[ 2]*u0_02*v0_02;
  p[ 3]=w[ 3]*u0_03*v0_03; p[ 4]=w[ 4]*u0_04*v0_04; p[ 5]=w[ 5]*u0_05*v0_05;
  p[ 6]=w[ 6]*u0_06*v0_06; p[ 7]=w[ 7]*u0_07*v0_07; p[ 8]=w[ 8]*u0_08*v0_08;
  p[ 9]=w[ 9]*u0_09*v0_09; p[10]=w[10]*u0_10*v0_10; p[11]=w[11]*u0_11*v0_11;
  p[12]=w[12]*u0_12*v0_12; p[13]=w[13]*u0_13*v0_13; p[14]=w[14]*u0_14*v0_14;
  p[15]=w[15]*u0_15*v0_15; p[16]=w[16]*u0_16*v0_16; p[17]=w[17]*u0_17*v0_17;
  p[18]=w[18]*u0_18*    1;
  if(d>0) {
    const double u1_02=    1*d01+u0_01,u1_03=u1_02*d02+u0_02,
                 u1_04=u1_03*d03+u0_03,u1_05=u1_04*d04+u0_04,
                 u1_06=u1_05*d05+u0_05,u1_07=u1_06*d06+u0_06,
                 u1_08=u1_07*d07+u0_07,u1_09=u1_08*d08+u0_08,
                 u1_10=u1_09*d09+u0_09,u1_11=u1_10*d10+u0_10,
                 u1_12=u1_11*d11+u0_11,u1_13=u1_12*d12+u0_12,
                 u1_14=u1_13*d13+u0_13,u1_15=u1_14*d14+u0_14,
                 u1_16=u1_15*d15+u0_15,u1_17=u1_16*d16+u0_16,
                 u1_18=u1_17*d17+u0_17;
    const double v1_16=d17*    1+v0_17,v1_15=d16*v1_16+v0_16,
                 v1_14=d15*v1_15+v0_15,v1_13=d14*v1_14+v0_14,
                 v1_12=d13*v1_13+v0_13,v1_11=d12*v1_12+v0_12,
                 v1_10=d11*v1_11+v0_11,v1_09=d10*v1_10+v0_10,
                 v1_08=d09*v1_09+v0_09,v1_07=d08*v1_08+v0_08,
                 v1_06=d07*v1_07+v0_07,v1_05=d06*v1_06+v0_06,
                 v1_04=d05*v1_05+v0_05,v1_03=d04*v1_04+v0_04,
                 v1_02=d03*v1_03+v0_03,v1_01=d02*v1_02+v0_02,
                 v1_00=d01*v1_01+v0_01;
    p[19+ 0]=2*w[ 0]*(                  v1_00);
    p[19+ 1]=2*w[ 1]*(    1*v0_01+u0_01*v1_01);
    p[19+ 2]=2*w[ 2]*(u1_02*v0_02+u0_02*v1_02);
    p[19+ 3]=2*w[ 3]*(u1_03*v0_03+u0_03*v1_03);
    p[19+ 4]=2*w[ 4]*(u1_04*v0_04+u0_04*v1_04);
    p[19+ 5]=2*w[ 5]*(u1_05*v0_05+u0_05*v1_05);
    p[19+ 6]=2*w[ 6]*(u1_06*v0_06+u0_06*v1_06);
    p[19+ 7]=2*w[ 7]*(u1_07*v0_07+u0_07*v1_07);
    p[19+ 8]=2*w[ 8]*(u1_08*v0_08+u0_08*v1_08);
    p[19+ 9]=2*w[ 9]*(u1_09*v0_09+u0_09*v1_09);
    p[19+10]=2*w[10]*(u1_10*v0_10+u0_10*v1_10);
    p[19+11]=2*w[11]*(u1_11*v0_11+u0_11*v1_11);
    p[19+12]=2*w[12]*(u1_12*v0_12+u0_12*v1_12);
    p[19+13]=2*w[13]*(u1_13*v0_13+u0_13*v1_13);
    p[19+14]=2*w[14]*(u1_14*v0_14+u0_14*v1_14);
    p[19+15]=2*w[15]*(u1_15*v0_15+u0_15*v1_15);
    p[19+16]=2*w[16]*(u1_16*v0_16+u0_16*v1_16);
    p[19+17]=2*w[17]*(u1_17*v0_17+u0_17*    1);
    p[19+18]=2*w[18]*(u1_18                  );
    if(d>1) {
      const double u2_03=    2*d02+2*u1_02,u2_04=u2_03*d03+2*u1_03,
                   u2_05=u2_04*d04+2*u1_04,u2_06=u2_05*d05+2*u1_05,
                   u2_07=u2_06*d06+2*u1_06,u2_08=u2_07*d07+2*u1_07,
                   u2_09=u2_08*d08+2*u1_08,u2_10=u2_09*d09+2*u1_09,
                   u2_11=u2_10*d10+2*u1_10,u2_12=u2_11*d11+2*u1_11,
                   u2_13=u2_12*d12+2*u1_12,u2_14=u2_13*d13+2*u1_13,
                   u2_15=u2_14*d14+2*u1_14,u2_16=u2_15*d15+2*u1_15,
                   u2_17=u2_16*d16+2*u1_16,u2_18=u2_17*d17+2*u1_17;
      const double v2_15=d16*    2+2*v1_16,v2_14=d15*v2_15+2*v1_15,
                   v2_13=d14*v2_14+2*v1_14,v2_12=d13*v2_13+2*v1_13,
                   v2_11=d12*v2_12+2*v1_12,v2_10=d11*v2_11+2*v1_11,
                   v2_09=d10*v2_10+2*v1_10,v2_08=d09*v2_09+2*v1_09,
                   v2_07=d08*v2_08+2*v1_08,v2_06=d07*v2_07+2*v1_07,
                   v2_05=d06*v2_06+2*v1_06,v2_04=d05*v2_05+2*v1_05,
                   v2_03=d04*v2_04+2*v1_04,v2_02=d03*v2_03+2*v1_03,
                   v2_01=d02*v2_02+2*v1_02,v2_00=d01*v2_01+2*v1_01;
      p[2*19+ 0]=4*w[ 0]*(                         +    1*v2_00);
      p[2*19+ 1]=4*w[ 1]*(           +2*    1*v1_01+u0_01*v2_01);
      p[2*19+ 2]=4*w[ 2]*(    2*v0_02+2*u1_02*v1_02+u0_02*v2_02);
      p[2*19+ 3]=4*w[ 3]*(u2_03*v0_03+2*u1_03*v1_03+u0_03*v2_03);
      p[2*19+ 4]=4*w[ 4]*(u2_04*v0_04+2*u1_04*v1_04+u0_04*v2_04);
      p[2*19+ 5]=4*w[ 5]*(u2_05*v0_05+2*u1_05*v1_05+u0_05*v2_05);
      p[2*19+ 6]=4*w[ 6]*(u2_06*v0_06+2*u1_06*v1_06+u0_06*v2_06);
      p[2*19+ 7]=4*w[ 7]*(u2_07*v0_07+2*u1_07*v1_07+u0_07*v2_07);
      p[2*19+ 8]=4*w[ 8]*(u2_08*v0_08+2*u1_08*v1_08+u0_08*v2_08);
      p[2*19+ 9]=4*w[ 9]*(u2_09*v0_09+2*u1_09*v1_09+u0_09*v2_09);
      p[2*19+10]=4*w[10]*(u2_10*v0_10+2*u1_10*v1_10+u0_10*v2_10);
      p[2*19+11]=4*w[11]*(u2_11*v0_11+2*u1_11*v1_11+u0_11*v2_11);
      p[2*19+12]=4*w[12]*(u2_12*v0_12+2*u1_12*v1_12+u0_12*v2_12);
      p[2*19+13]=4*w[13]*(u2_13*v0_13+2*u1_13*v1_13+u0_13*v2_13);
      p[2*19+14]=4*w[14]*(u2_14*v0_14+2*u1_14*v1_14+u0_14*v2_14);
      p[2*19+15]=4*w[15]*(u2_15*v0_15+2*u1_15*v1_15+u0_15*v2_15);
      p[2*19+16]=4*w[16]*(u2_16*v0_16+2*u1_16*v1_16+u0_16*    2);
      p[2*19+17]=4*w[17]*(u2_17*v0_17+2*u1_17*    1            );
      p[2*19+18]=4*w[18]*(u2_18*    1                          );
    }
  }
}

static const double gllz_20[ 9] = {
  0.98074370489391417192544643858423091522991062312625,
  0.93593449881266543571618158493062692991557383318105,
  0.86687797808995014130984721461628521396291128831699,
  0.77536826095205587041431752759469134337272185947653,
  0.66377640229031128984640332297115885247574574199149,
  0.53499286403188626164813596182898398300685156913752,
  0.39235318371390929938647470381582436666520332929891,
  0.23955170592298649518240135692708807194151780992738,
  0.080545937238821837975944518159554463022392870092908
};

static void gll_lag_20(double *restrict p, double *restrict w,
                       unsigned n, int d, double xh)
{
  const double x = xh*2;
  const double d00=x+2            ,d01=x+2*gllz_20[ 0],d02=x+2*gllz_20[ 1],
               d03=x+2*gllz_20[ 2],d04=x+2*gllz_20[ 3],d05=x+2*gllz_20[ 4],
               d06=x+2*gllz_20[ 5],d07=x+2*gllz_20[ 6],d08=x+2*gllz_20[ 7],
               d09=x+2*gllz_20[ 8],d10=x-2*gllz_20[ 8],d11=x-2*gllz_20[ 7],
               d12=x-2*gllz_20[ 6],d13=x-2*gllz_20[ 5],d14=x-2*gllz_20[ 4],
               d15=x-2*gllz_20[ 3],d16=x-2*gllz_20[ 2],d17=x-2*gllz_20[ 1],
               d18=x-2*gllz_20[ 0],d19=x-2            ;
  const double u0_01=    1*d00,u0_02=u0_01*d01,u0_03=u0_02*d02,
               u0_04=u0_03*d03,u0_05=u0_04*d04,u0_06=u0_05*d05,
               u0_07=u0_06*d06,u0_08=u0_07*d07,u0_09=u0_08*d08,
               u0_10=u0_09*d09,u0_11=u0_10*d10,u0_12=u0_11*d11,
               u0_13=u0_12*d12,u0_14=u0_13*d13,u0_15=u0_14*d14,
               u0_16=u0_15*d15,u0_17=u0_16*d16,u0_18=u0_17*d17,
               u0_19=u0_18*d18;
  const double v0_18=d19*    1,v0_17=d18*v0_18,v0_16=d17*v0_17,
               v0_15=d16*v0_16,v0_14=d15*v0_15,v0_13=d14*v0_14,
               v0_12=d13*v0_13,v0_11=d12*v0_12,v0_10=d11*v0_11,
               v0_09=d10*v0_10,v0_08=d09*v0_09,v0_07=d08*v0_08,
               v0_06=d07*v0_07,v0_05=d06*v0_06,v0_04=d05*v0_05,
               v0_03=d04*v0_04,v0_02=d03*v0_03,v0_01=d02*v0_02,
               v0_00=d01*v0_01;
  p[ 0]=w[ 0]*    1*v0_00; p[ 1]=w[ 1]*u0_01*v0_01; p[ 2]=w[ 2]*u0_02*v0_02;
  p[ 3]=w[ 3]*u0_03*v0_03; p[ 4]=w[ 4]*u0_04*v0_04; p[ 5]=w[ 5]*u0_05*v0_05;
  p[ 6]=w[ 6]*u0_06*v0_06; p[ 7]=w[ 7]*u0_07*v0_07; p[ 8]=w[ 8]*u0_08*v0_08;
  p[ 9]=w[ 9]*u0_09*v0_09; p[10]=w[10]*u0_10*v0_10; p[11]=w[11]*u0_11*v0_11;
  p[12]=w[12]*u0_12*v0_12; p[13]=w[13]*u0_13*v0_13; p[14]=w[14]*u0_14*v0_14;
  p[15]=w[15]*u0_15*v0_15; p[16]=w[16]*u0_16*v0_16; p[17]=w[17]*u0_17*v0_17;
  p[18]=w[18]*u0_18*v0_18; p[19]=w[19]*u0_19*    1;
  if(d>0) {
    const double u1_02=    1*d01+u0_01,u1_03=u1_02*d02+u0_02,
                 u1_04=u1_03*d03+u0_03,u1_05=u1_04*d04+u0_04,
                 u1_06=u1_05*d05+u0_05,u1_07=u1_06*d06+u0_06,
                 u1_08=u1_07*d07+u0_07,u1_09=u1_08*d08+u0_08,
                 u1_10=u1_09*d09+u0_09,u1_11=u1_10*d10+u0_10,
                 u1_12=u1_11*d11+u0_11,u1_13=u1_12*d12+u0_12,
                 u1_14=u1_13*d13+u0_13,u1_15=u1_14*d14+u0_14,
                 u1_16=u1_15*d15+u0_15,u1_17=u1_16*d16+u0_16,
                 u1_18=u1_17*d17+u0_17,u1_19=u1_18*d18+u0_18;
    const double v1_17=d18*    1+v0_18,v1_16=d17*v1_17+v0_17,
                 v1_15=d16*v1_16+v0_16,v1_14=d15*v1_15+v0_15,
                 v1_13=d14*v1_14+v0_14,v1_12=d13*v1_13+v0_13,
                 v1_11=d12*v1_12+v0_12,v1_10=d11*v1_11+v0_11,
                 v1_09=d10*v1_10+v0_10,v1_08=d09*v1_09+v0_09,
                 v1_07=d08*v1_08+v0_08,v1_06=d07*v1_07+v0_07,
                 v1_05=d06*v1_06+v0_06,v1_04=d05*v1_05+v0_05,
                 v1_03=d04*v1_04+v0_04,v1_02=d03*v1_03+v0_03,
                 v1_01=d02*v1_02+v0_02,v1_00=d01*v1_01+v0_01;
    p[20+ 0]=2*w[ 0]*(                  v1_00);
    p[20+ 1]=2*w[ 1]*(    1*v0_01+u0_01*v1_01);
    p[20+ 2]=2*w[ 2]*(u1_02*v0_02+u0_02*v1_02);
    p[20+ 3]=2*w[ 3]*(u1_03*v0_03+u0_03*v1_03);
    p[20+ 4]=2*w[ 4]*(u1_04*v0_04+u0_04*v1_04);
    p[20+ 5]=2*w[ 5]*(u1_05*v0_05+u0_05*v1_05);
    p[20+ 6]=2*w[ 6]*(u1_06*v0_06+u0_06*v1_06);
    p[20+ 7]=2*w[ 7]*(u1_07*v0_07+u0_07*v1_07);
    p[20+ 8]=2*w[ 8]*(u1_08*v0_08+u0_08*v1_08);
    p[20+ 9]=2*w[ 9]*(u1_09*v0_09+u0_09*v1_09);
    p[20+10]=2*w[10]*(u1_10*v0_10+u0_10*v1_10);
    p[20+11]=2*w[11]*(u1_11*v0_11+u0_11*v1_11);
    p[20+12]=2*w[12]*(u1_12*v0_12+u0_12*v1_12);
    p[20+13]=2*w[13]*(u1_13*v0_13+u0_13*v1_13);
    p[20+14]=2*w[14]*(u1_14*v0_14+u0_14*v1_14);
    p[20+15]=2*w[15]*(u1_15*v0_15+u0_15*v1_15);
    p[20+16]=2*w[16]*(u1_16*v0_16+u0_16*v1_16);
    p[20+17]=2*w[17]*(u1_17*v0_17+u0_17*v1_17);
    p[20+18]=2*w[18]*(u1_18*v0_18+u0_18*    1);
    p[20+19]=2*w[19]*(u1_19                  );
    if(d>1) {
      const double u2_03=    2*d02+2*u1_02,u2_04=u2_03*d03+2*u1_03,
                   u2_05=u2_04*d04+2*u1_04,u2_06=u2_05*d05+2*u1_05,
                   u2_07=u2_06*d06+2*u1_06,u2_08=u2_07*d07+2*u1_07,
                   u2_09=u2_08*d08+2*u1_08,u2_10=u2_09*d09+2*u1_09,
                   u2_11=u2_10*d10+2*u1_10,u2_12=u2_11*d11+2*u1_11,
                   u2_13=u2_12*d12+2*u1_12,u2_14=u2_13*d13+2*u1_13,
                   u2_15=u2_14*d14+2*u1_14,u2_16=u2_15*d15+2*u1_15,
                   u2_17=u2_16*d16+2*u1_16,u2_18=u2_17*d17+2*u1_17,
                   u2_19=u2_18*d18+2*u1_18;
      const double v2_16=d17*    2+2*v1_17,v2_15=d16*v2_16+2*v1_16,
                   v2_14=d15*v2_15+2*v1_15,v2_13=d14*v2_14+2*v1_14,
                   v2_12=d13*v2_13+2*v1_13,v2_11=d12*v2_12+2*v1_12,
                   v2_10=d11*v2_11+2*v1_11,v2_09=d10*v2_10+2*v1_10,
                   v2_08=d09*v2_09+2*v1_09,v2_07=d08*v2_08+2*v1_08,
                   v2_06=d07*v2_07+2*v1_07,v2_05=d06*v2_06+2*v1_06,
                   v2_04=d05*v2_05+2*v1_05,v2_03=d04*v2_04+2*v1_04,
                   v2_02=d03*v2_03+2*v1_03,v2_01=d02*v2_02+2*v1_02,
                   v2_00=d01*v2_01+2*v1_01;
      p[2*20+ 0]=4*w[ 0]*(                         +    1*v2_00);
      p[2*20+ 1]=4*w[ 1]*(           +2*    1*v1_01+u0_01*v2_01);
      p[2*20+ 2]=4*w[ 2]*(    2*v0_02+2*u1_02*v1_02+u0_02*v2_02);
      p[2*20+ 3]=4*w[ 3]*(u2_03*v0_03+2*u1_03*v1_03+u0_03*v2_03);
      p[2*20+ 4]=4*w[ 4]*(u2_04*v0_04+2*u1_04*v1_04+u0_04*v2_04);
      p[2*20+ 5]=4*w[ 5]*(u2_05*v0_05+2*u1_05*v1_05+u0_05*v2_05);
      p[2*20+ 6]=4*w[ 6]*(u2_06*v0_06+2*u1_06*v1_06+u0_06*v2_06);
      p[2*20+ 7]=4*w[ 7]*(u2_07*v0_07+2*u1_07*v1_07+u0_07*v2_07);
      p[2*20+ 8]=4*w[ 8]*(u2_08*v0_08+2*u1_08*v1_08+u0_08*v2_08);
      p[2*20+ 9]=4*w[ 9]*(u2_09*v0_09+2*u1_09*v1_09+u0_09*v2_09);
      p[2*20+10]=4*w[10]*(u2_10*v0_10+2*u1_10*v1_10+u0_10*v2_10);
      p[2*20+11]=4*w[11]*(u2_11*v0_11+2*u1_11*v1_11+u0_11*v2_11);
      p[2*20+12]=4*w[12]*(u2_12*v0_12+2*u1_12*v1_12+u0_12*v2_12);
      p[2*20+13]=4*w[13]*(u2_13*v0_13+2*u1_13*v1_13+u0_13*v2_13);
      p[2*20+14]=4*w[14]*(u2_14*v0_14+2*u1_14*v1_14+u0_14*v2_14);
      p[2*20+15]=4*w[15]*(u2_15*v0_15+2*u1_15*v1_15+u0_15*v2_15);
      p[2*20+16]=4*w[16]*(u2_16*v0_16+2*u1_16*v1_16+u0_16*v2_16);
      p[2*20+17]=4*w[17]*(u2_17*v0_17+2*u1_17*v1_17+u0_17*    2);
      p[2*20+18]=4*w[18]*(u2_18*v0_18+2*u1_18*    1            );
      p[2*20+19]=4*w[19]*(u2_19*    1                          );
    }
  }
}

static const double gllz_21[ 9] = {
  0.98257229660454802823448127655540587685917158823641,
  0.94197629695974553429610265066143517664965087404401,
  0.8792947553235904644511535963049440477105815515092,
  0.79600192607771240474431258966035863909041966054978,
  0.69405102606222323262731639319466662875771600610585,
  0.57583196026183068692702187033808528733577300855848,
  0.44411578327900210119451634960735128473505748656706,
  0.30198985650876488727535186785875223202107103406039,
  0.15278551580218546600635832848566943551774899331328
};

static void gll_lag_21(double *restrict p, double *restrict w,
                       unsigned n, int d, double xh)
{
  const double x = xh*2;
  const double d00=x+2            ,d01=x+2*gllz_21[ 0],d02=x+2*gllz_21[ 1],
               d03=x+2*gllz_21[ 2],d04=x+2*gllz_21[ 3],d05=x+2*gllz_21[ 4],
               d06=x+2*gllz_21[ 5],d07=x+2*gllz_21[ 6],d08=x+2*gllz_21[ 7],
               d09=x+2*gllz_21[ 8],d10=x              ,d11=x-2*gllz_21[ 8],
               d12=x-2*gllz_21[ 7],d13=x-2*gllz_21[ 6],d14=x-2*gllz_21[ 5],
               d15=x-2*gllz_21[ 4],d16=x-2*gllz_21[ 3],d17=x-2*gllz_21[ 2],
               d18=x-2*gllz_21[ 1],d19=x-2*gllz_21[ 0],d20=x-2            ;
  const double u0_01=    1*d00,u0_02=u0_01*d01,u0_03=u0_02*d02,
               u0_04=u0_03*d03,u0_05=u0_04*d04,u0_06=u0_05*d05,
               u0_07=u0_06*d06,u0_08=u0_07*d07,u0_09=u0_08*d08,
               u0_10=u0_09*d09,u0_11=u0_10*d10,u0_12=u0_11*d11,
               u0_13=u0_12*d12,u0_14=u0_13*d13,u0_15=u0_14*d14,
               u0_16=u0_15*d15,u0_17=u0_16*d16,u0_18=u0_17*d17,
               u0_19=u0_18*d18,u0_20=u0_19*d19;
  const double v0_19=d20*    1,v0_18=d19*v0_19,v0_17=d18*v0_18,
               v0_16=d17*v0_17,v0_15=d16*v0_16,v0_14=d15*v0_15,
               v0_13=d14*v0_14,v0_12=d13*v0_13,v0_11=d12*v0_12,
               v0_10=d11*v0_11,v0_09=d10*v0_10,v0_08=d09*v0_09,
               v0_07=d08*v0_08,v0_06=d07*v0_07,v0_05=d06*v0_06,
               v0_04=d05*v0_05,v0_03=d04*v0_04,v0_02=d03*v0_03,
               v0_01=d02*v0_02,v0_00=d01*v0_01;
  p[ 0]=w[ 0]*    1*v0_00; p[ 1]=w[ 1]*u0_01*v0_01; p[ 2]=w[ 2]*u0_02*v0_02;
  p[ 3]=w[ 3]*u0_03*v0_03; p[ 4]=w[ 4]*u0_04*v0_04; p[ 5]=w[ 5]*u0_05*v0_05;
  p[ 6]=w[ 6]*u0_06*v0_06; p[ 7]=w[ 7]*u0_07*v0_07; p[ 8]=w[ 8]*u0_08*v0_08;
  p[ 9]=w[ 9]*u0_09*v0_09; p[10]=w[10]*u0_10*v0_10; p[11]=w[11]*u0_11*v0_11;
  p[12]=w[12]*u0_12*v0_12; p[13]=w[13]*u0_13*v0_13; p[14]=w[14]*u0_14*v0_14;
  p[15]=w[15]*u0_15*v0_15; p[16]=w[16]*u0_16*v0_16; p[17]=w[17]*u0_17*v0_17;
  p[18]=w[18]*u0_18*v0_18; p[19]=w[19]*u0_19*v0_19; p[20]=w[20]*u0_20*    1;
  if(d>0) {
    const double u1_02=    1*d01+u0_01,u1_03=u1_02*d02+u0_02,
                 u1_04=u1_03*d03+u0_03,u1_05=u1_04*d04+u0_04,
                 u1_06=u1_05*d05+u0_05,u1_07=u1_06*d06+u0_06,
                 u1_08=u1_07*d07+u0_07,u1_09=u1_08*d08+u0_08,
                 u1_10=u1_09*d09+u0_09,u1_11=u1_10*d10+u0_10,
                 u1_12=u1_11*d11+u0_11,u1_13=u1_12*d12+u0_12,
                 u1_14=u1_13*d13+u0_13,u1_15=u1_14*d14+u0_14,
                 u1_16=u1_15*d15+u0_15,u1_17=u1_16*d16+u0_16,
                 u1_18=u1_17*d17+u0_17,u1_19=u1_18*d18+u0_18,
                 u1_20=u1_19*d19+u0_19;
    const double v1_18=d19*    1+v0_19,v1_17=d18*v1_18+v0_18,
                 v1_16=d17*v1_17+v0_17,v1_15=d16*v1_16+v0_16,
                 v1_14=d15*v1_15+v0_15,v1_13=d14*v1_14+v0_14,
                 v1_12=d13*v1_13+v0_13,v1_11=d12*v1_12+v0_12,
                 v1_10=d11*v1_11+v0_11,v1_09=d10*v1_10+v0_10,
                 v1_08=d09*v1_09+v0_09,v1_07=d08*v1_08+v0_08,
                 v1_06=d07*v1_07+v0_07,v1_05=d06*v1_06+v0_06,
                 v1_04=d05*v1_05+v0_05,v1_03=d04*v1_04+v0_04,
                 v1_02=d03*v1_03+v0_03,v1_01=d02*v1_02+v0_02,
                 v1_00=d01*v1_01+v0_01;
    p[21+ 0]=2*w[ 0]*(                  v1_00);
    p[21+ 1]=2*w[ 1]*(    1*v0_01+u0_01*v1_01);
    p[21+ 2]=2*w[ 2]*(u1_02*v0_02+u0_02*v1_02);
    p[21+ 3]=2*w[ 3]*(u1_03*v0_03+u0_03*v1_03);
    p[21+ 4]=2*w[ 4]*(u1_04*v0_04+u0_04*v1_04);
    p[21+ 5]=2*w[ 5]*(u1_05*v0_05+u0_05*v1_05);
    p[21+ 6]=2*w[ 6]*(u1_06*v0_06+u0_06*v1_06);
    p[21+ 7]=2*w[ 7]*(u1_07*v0_07+u0_07*v1_07);
    p[21+ 8]=2*w[ 8]*(u1_08*v0_08+u0_08*v1_08);
    p[21+ 9]=2*w[ 9]*(u1_09*v0_09+u0_09*v1_09);
    p[21+10]=2*w[10]*(u1_10*v0_10+u0_10*v1_10);
    p[21+11]=2*w[11]*(u1_11*v0_11+u0_11*v1_11);
    p[21+12]=2*w[12]*(u1_12*v0_12+u0_12*v1_12);
    p[21+13]=2*w[13]*(u1_13*v0_13+u0_13*v1_13);
    p[21+14]=2*w[14]*(u1_14*v0_14+u0_14*v1_14);
    p[21+15]=2*w[15]*(u1_15*v0_15+u0_15*v1_15);
    p[21+16]=2*w[16]*(u1_16*v0_16+u0_16*v1_16);
    p[21+17]=2*w[17]*(u1_17*v0_17+u0_17*v1_17);
    p[21+18]=2*w[18]*(u1_18*v0_18+u0_18*v1_18);
    p[21+19]=2*w[19]*(u1_19*v0_19+u0_19*    1);
    p[21+20]=2*w[20]*(u1_20                  );
    if(d>1) {
      const double u2_03=    2*d02+2*u1_02,u2_04=u2_03*d03+2*u1_03,
                   u2_05=u2_04*d04+2*u1_04,u2_06=u2_05*d05+2*u1_05,
                   u2_07=u2_06*d06+2*u1_06,u2_08=u2_07*d07+2*u1_07,
                   u2_09=u2_08*d08+2*u1_08,u2_10=u2_09*d09+2*u1_09,
                   u2_11=u2_10*d10+2*u1_10,u2_12=u2_11*d11+2*u1_11,
                   u2_13=u2_12*d12+2*u1_12,u2_14=u2_13*d13+2*u1_13,
                   u2_15=u2_14*d14+2*u1_14,u2_16=u2_15*d15+2*u1_15,
                   u2_17=u2_16*d16+2*u1_16,u2_18=u2_17*d17+2*u1_17,
                   u2_19=u2_18*d18+2*u1_18,u2_20=u2_19*d19+2*u1_19;
      const double v2_17=d18*    2+2*v1_18,v2_16=d17*v2_17+2*v1_17,
                   v2_15=d16*v2_16+2*v1_16,v2_14=d15*v2_15+2*v1_15,
                   v2_13=d14*v2_14+2*v1_14,v2_12=d13*v2_13+2*v1_13,
                   v2_11=d12*v2_12+2*v1_12,v2_10=d11*v2_11+2*v1_11,
                   v2_09=d10*v2_10+2*v1_10,v2_08=d09*v2_09+2*v1_09,
                   v2_07=d08*v2_08+2*v1_08,v2_06=d07*v2_07+2*v1_07,
                   v2_05=d06*v2_06+2*v1_06,v2_04=d05*v2_05+2*v1_05,
                   v2_03=d04*v2_04+2*v1_04,v2_02=d03*v2_03+2*v1_03,
                   v2_01=d02*v2_02+2*v1_02,v2_00=d01*v2_01+2*v1_01;
      p[2*21+ 0]=4*w[ 0]*(                         +    1*v2_00);
      p[2*21+ 1]=4*w[ 1]*(           +2*    1*v1_01+u0_01*v2_01);
      p[2*21+ 2]=4*w[ 2]*(    2*v0_02+2*u1_02*v1_02+u0_02*v2_02);
      p[2*21+ 3]=4*w[ 3]*(u2_03*v0_03+2*u1_03*v1_03+u0_03*v2_03);
      p[2*21+ 4]=4*w[ 4]*(u2_04*v0_04+2*u1_04*v1_04+u0_04*v2_04);
      p[2*21+ 5]=4*w[ 5]*(u2_05*v0_05+2*u1_05*v1_05+u0_05*v2_05);
      p[2*21+ 6]=4*w[ 6]*(u2_06*v0_06+2*u1_06*v1_06+u0_06*v2_06);
      p[2*21+ 7]=4*w[ 7]*(u2_07*v0_07+2*u1_07*v1_07+u0_07*v2_07);
      p[2*21+ 8]=4*w[ 8]*(u2_08*v0_08+2*u1_08*v1_08+u0_08*v2_08);
      p[2*21+ 9]=4*w[ 9]*(u2_09*v0_09+2*u1_09*v1_09+u0_09*v2_09);
      p[2*21+10]=4*w[10]*(u2_10*v0_10+2*u1_10*v1_10+u0_10*v2_10);
      p[2*21+11]=4*w[11]*(u2_11*v0_11+2*u1_11*v1_11+u0_11*v2_11);
      p[2*21+12]=4*w[12]*(u2_12*v0_12+2*u1_12*v1_12+u0_12*v2_12);
      p[2*21+13]=4*w[13]*(u2_13*v0_13+2*u1_13*v1_13+u0_13*v2_13);
      p[2*21+14]=4*w[14]*(u2_14*v0_14+2*u1_14*v1_14+u0_14*v2_14);
      p[2*21+15]=4*w[15]*(u2_15*v0_15+2*u1_15*v1_15+u0_15*v2_15);
      p[2*21+16]=4*w[16]*(u2_16*v0_16+2*u1_16*v1_16+u0_16*v2_16);
      p[2*21+17]=4*w[17]*(u2_17*v0_17+2*u1_17*v1_17+u0_17*v2_17);
      p[2*21+18]=4*w[18]*(u2_18*v0_18+2*u1_18*v1_18+u0_18*    2);
      p[2*21+19]=4*w[19]*(u2_19*v0_19+2*u1_19*    1            );
      p[2*21+20]=4*w[20]*(u2_20*    1                          );
    }
  }
}

static const double gllz_22[10] = {
  0.98415243845764617655228962221207029660551353611952,
  0.94720428399922868052421376661572950991206204534136,
  0.89006229019090447052965782577908679019953408284715,
  0.8139489276119211360454418480561350424386685149071,
  0.7204872399612021581198818963984657585933454261195,
  0.6116694382842589712262116058699265993454403046077,
  0.48981487518990234980875123568327004167127163579515,
  0.35752071013891953806095728024017912928330710394294,
  0.21760658515928504178795509346539276327500669401419,
  0.073054540010898334761088790464107356192779236333516
};

static void gll_lag_22(double *restrict p, double *restrict w,
                       unsigned n, int d, double xh)
{
  const double x = xh*2;
  const double d00=x+2            ,d01=x+2*gllz_22[ 0],d02=x+2*gllz_22[ 1],
               d03=x+2*gllz_22[ 2],d04=x+2*gllz_22[ 3],d05=x+2*gllz_22[ 4],
               d06=x+2*gllz_22[ 5],d07=x+2*gllz_22[ 6],d08=x+2*gllz_22[ 7],
               d09=x+2*gllz_22[ 8],d10=x+2*gllz_22[ 9],d11=x-2*gllz_22[ 9],
               d12=x-2*gllz_22[ 8],d13=x-2*gllz_22[ 7],d14=x-2*gllz_22[ 6],
               d15=x-2*gllz_22[ 5],d16=x-2*gllz_22[ 4],d17=x-2*gllz_22[ 3],
               d18=x-2*gllz_22[ 2],d19=x-2*gllz_22[ 1],d20=x-2*gllz_22[ 0],
               d21=x-2            ;
  const double u0_01=    1*d00,u0_02=u0_01*d01,u0_03=u0_02*d02,
               u0_04=u0_03*d03,u0_05=u0_04*d04,u0_06=u0_05*d05,
               u0_07=u0_06*d06,u0_08=u0_07*d07,u0_09=u0_08*d08,
               u0_10=u0_09*d09,u0_11=u0_10*d10,u0_12=u0_11*d11,
               u0_13=u0_12*d12,u0_14=u0_13*d13,u0_15=u0_14*d14,
               u0_16=u0_15*d15,u0_17=u0_16*d16,u0_18=u0_17*d17,
               u0_19=u0_18*d18,u0_20=u0_19*d19,u0_21=u0_20*d20;
  const double v0_20=d21*    1,v0_19=d20*v0_20,v0_18=d19*v0_19,
               v0_17=d18*v0_18,v0_16=d17*v0_17,v0_15=d16*v0_16,
               v0_14=d15*v0_15,v0_13=d14*v0_14,v0_12=d13*v0_13,
               v0_11=d12*v0_12,v0_10=d11*v0_11,v0_09=d10*v0_10,
               v0_08=d09*v0_09,v0_07=d08*v0_08,v0_06=d07*v0_07,
               v0_05=d06*v0_06,v0_04=d05*v0_05,v0_03=d04*v0_04,
               v0_02=d03*v0_03,v0_01=d02*v0_02,v0_00=d01*v0_01;
  p[ 0]=w[ 0]*    1*v0_00; p[ 1]=w[ 1]*u0_01*v0_01; p[ 2]=w[ 2]*u0_02*v0_02;
  p[ 3]=w[ 3]*u0_03*v0_03; p[ 4]=w[ 4]*u0_04*v0_04; p[ 5]=w[ 5]*u0_05*v0_05;
  p[ 6]=w[ 6]*u0_06*v0_06; p[ 7]=w[ 7]*u0_07*v0_07; p[ 8]=w[ 8]*u0_08*v0_08;
  p[ 9]=w[ 9]*u0_09*v0_09; p[10]=w[10]*u0_10*v0_10; p[11]=w[11]*u0_11*v0_11;
  p[12]=w[12]*u0_12*v0_12; p[13]=w[13]*u0_13*v0_13; p[14]=w[14]*u0_14*v0_14;
  p[15]=w[15]*u0_15*v0_15; p[16]=w[16]*u0_16*v0_16; p[17]=w[17]*u0_17*v0_17;
  p[18]=w[18]*u0_18*v0_18; p[19]=w[19]*u0_19*v0_19; p[20]=w[20]*u0_20*v0_20;
  p[21]=w[21]*u0_21*    1;
  if(d>0) {
    const double u1_02=    1*d01+u0_01,u1_03=u1_02*d02+u0_02,
                 u1_04=u1_03*d03+u0_03,u1_05=u1_04*d04+u0_04,
                 u1_06=u1_05*d05+u0_05,u1_07=u1_06*d06+u0_06,
                 u1_08=u1_07*d07+u0_07,u1_09=u1_08*d08+u0_08,
                 u1_10=u1_09*d09+u0_09,u1_11=u1_10*d10+u0_10,
                 u1_12=u1_11*d11+u0_11,u1_13=u1_12*d12+u0_12,
                 u1_14=u1_13*d13+u0_13,u1_15=u1_14*d14+u0_14,
                 u1_16=u1_15*d15+u0_15,u1_17=u1_16*d16+u0_16,
                 u1_18=u1_17*d17+u0_17,u1_19=u1_18*d18+u0_18,
                 u1_20=u1_19*d19+u0_19,u1_21=u1_20*d20+u0_20;
    const double v1_19=d20*    1+v0_20,v1_18=d19*v1_19+v0_19,
                 v1_17=d18*v1_18+v0_18,v1_16=d17*v1_17+v0_17,
                 v1_15=d16*v1_16+v0_16,v1_14=d15*v1_15+v0_15,
                 v1_13=d14*v1_14+v0_14,v1_12=d13*v1_13+v0_13,
                 v1_11=d12*v1_12+v0_12,v1_10=d11*v1_11+v0_11,
                 v1_09=d10*v1_10+v0_10,v1_08=d09*v1_09+v0_09,
                 v1_07=d08*v1_08+v0_08,v1_06=d07*v1_07+v0_07,
                 v1_05=d06*v1_06+v0_06,v1_04=d05*v1_05+v0_05,
                 v1_03=d04*v1_04+v0_04,v1_02=d03*v1_03+v0_03,
                 v1_01=d02*v1_02+v0_02,v1_00=d01*v1_01+v0_01;
    p[22+ 0]=2*w[ 0]*(                  v1_00);
    p[22+ 1]=2*w[ 1]*(    1*v0_01+u0_01*v1_01);
    p[22+ 2]=2*w[ 2]*(u1_02*v0_02+u0_02*v1_02);
    p[22+ 3]=2*w[ 3]*(u1_03*v0_03+u0_03*v1_03);
    p[22+ 4]=2*w[ 4]*(u1_04*v0_04+u0_04*v1_04);
    p[22+ 5]=2*w[ 5]*(u1_05*v0_05+u0_05*v1_05);
    p[22+ 6]=2*w[ 6]*(u1_06*v0_06+u0_06*v1_06);
    p[22+ 7]=2*w[ 7]*(u1_07*v0_07+u0_07*v1_07);
    p[22+ 8]=2*w[ 8]*(u1_08*v0_08+u0_08*v1_08);
    p[22+ 9]=2*w[ 9]*(u1_09*v0_09+u0_09*v1_09);
    p[22+10]=2*w[10]*(u1_10*v0_10+u0_10*v1_10);
    p[22+11]=2*w[11]*(u1_11*v0_11+u0_11*v1_11);
    p[22+12]=2*w[12]*(u1_12*v0_12+u0_12*v1_12);
    p[22+13]=2*w[13]*(u1_13*v0_13+u0_13*v1_13);
    p[22+14]=2*w[14]*(u1_14*v0_14+u0_14*v1_14);
    p[22+15]=2*w[15]*(u1_15*v0_15+u0_15*v1_15);
    p[22+16]=2*w[16]*(u1_16*v0_16+u0_16*v1_16);
    p[22+17]=2*w[17]*(u1_17*v0_17+u0_17*v1_17);
    p[22+18]=2*w[18]*(u1_18*v0_18+u0_18*v1_18);
    p[22+19]=2*w[19]*(u1_19*v0_19+u0_19*v1_19);
    p[22+20]=2*w[20]*(u1_20*v0_20+u0_20*    1);
    p[22+21]=2*w[21]*(u1_21                  );
    if(d>1) {
      const double u2_03=    2*d02+2*u1_02,u2_04=u2_03*d03+2*u1_03,
                   u2_05=u2_04*d04+2*u1_04,u2_06=u2_05*d05+2*u1_05,
                   u2_07=u2_06*d06+2*u1_06,u2_08=u2_07*d07+2*u1_07,
                   u2_09=u2_08*d08+2*u1_08,u2_10=u2_09*d09+2*u1_09,
                   u2_11=u2_10*d10+2*u1_10,u2_12=u2_11*d11+2*u1_11,
                   u2_13=u2_12*d12+2*u1_12,u2_14=u2_13*d13+2*u1_13,
                   u2_15=u2_14*d14+2*u1_14,u2_16=u2_15*d15+2*u1_15,
                   u2_17=u2_16*d16+2*u1_16,u2_18=u2_17*d17+2*u1_17,
                   u2_19=u2_18*d18+2*u1_18,u2_20=u2_19*d19+2*u1_19,
                   u2_21=u2_20*d20+2*u1_20;
      const double v2_18=d19*    2+2*v1_19,v2_17=d18*v2_18+2*v1_18,
                   v2_16=d17*v2_17+2*v1_17,v2_15=d16*v2_16+2*v1_16,
                   v2_14=d15*v2_15+2*v1_15,v2_13=d14*v2_14+2*v1_14,
                   v2_12=d13*v2_13+2*v1_13,v2_11=d12*v2_12+2*v1_12,
                   v2_10=d11*v2_11+2*v1_11,v2_09=d10*v2_10+2*v1_10,
                   v2_08=d09*v2_09+2*v1_09,v2_07=d08*v2_08+2*v1_08,
                   v2_06=d07*v2_07+2*v1_07,v2_05=d06*v2_06+2*v1_06,
                   v2_04=d05*v2_05+2*v1_05,v2_03=d04*v2_04+2*v1_04,
                   v2_02=d03*v2_03+2*v1_03,v2_01=d02*v2_02+2*v1_02,
                   v2_00=d01*v2_01+2*v1_01;
      p[2*22+ 0]=4*w[ 0]*(                         +    1*v2_00);
      p[2*22+ 1]=4*w[ 1]*(           +2*    1*v1_01+u0_01*v2_01);
      p[2*22+ 2]=4*w[ 2]*(    2*v0_02+2*u1_02*v1_02+u0_02*v2_02);
      p[2*22+ 3]=4*w[ 3]*(u2_03*v0_03+2*u1_03*v1_03+u0_03*v2_03);
      p[2*22+ 4]=4*w[ 4]*(u2_04*v0_04+2*u1_04*v1_04+u0_04*v2_04);
      p[2*22+ 5]=4*w[ 5]*(u2_05*v0_05+2*u1_05*v1_05+u0_05*v2_05);
      p[2*22+ 6]=4*w[ 6]*(u2_06*v0_06+2*u1_06*v1_06+u0_06*v2_06);
      p[2*22+ 7]=4*w[ 7]*(u2_07*v0_07+2*u1_07*v1_07+u0_07*v2_07);
      p[2*22+ 8]=4*w[ 8]*(u2_08*v0_08+2*u1_08*v1_08+u0_08*v2_08);
      p[2*22+ 9]=4*w[ 9]*(u2_09*v0_09+2*u1_09*v1_09+u0_09*v2_09);
      p[2*22+10]=4*w[10]*(u2_10*v0_10+2*u1_10*v1_10+u0_10*v2_10);
      p[2*22+11]=4*w[11]*(u2_11*v0_11+2*u1_11*v1_11+u0_11*v2_11);
      p[2*22+12]=4*w[12]*(u2_12*v0_12+2*u1_12*v1_12+u0_12*v2_12);
      p[2*22+13]=4*w[13]*(u2_13*v0_13+2*u1_13*v1_13+u0_13*v2_13);
      p[2*22+14]=4*w[14]*(u2_14*v0_14+2*u1_14*v1_14+u0_14*v2_14);
      p[2*22+15]=4*w[15]*(u2_15*v0_15+2*u1_15*v1_15+u0_15*v2_15);
      p[2*22+16]=4*w[16]*(u2_16*v0_16+2*u1_16*v1_16+u0_16*v2_16);
      p[2*22+17]=4*w[17]*(u2_17*v0_17+2*u1_17*v1_17+u0_17*v2_17);
      p[2*22+18]=4*w[18]*(u2_18*v0_18+2*u1_18*v1_18+u0_18*v2_18);
      p[2*22+19]=4*w[19]*(u2_19*v0_19+2*u1_19*v1_19+u0_19*    2);
      p[2*22+20]=4*w[20]*(u2_20*v0_20+2*u1_20*    1            );
      p[2*22+21]=4*w[21]*(u2_21*    1                          );
    }
  }
}

static const double gllz_23[10] = {
  0.98552715587873257808146276673809909902061079213965,
  0.9517579557107102041356396798514291558483519254488,
  0.89945855804034501095016032034736715791179834813929,
  0.82965109665128588622320061929000488459851188301333,
  0.74369504117206068394516354306699679128721922895386,
  0.6432636444601362084761455336027687438913118818023,
  0.53031177113684416813011532015229981113034651492734,
  0.40703793791447482919595048821509563955195372399417,
  0.27584154894579306710687763267913520417319110660942,
  0.13927620404066839859186261298276693390854445717444
};

static void gll_lag_23(double *restrict p, double *restrict w,
                       unsigned n, int d, double xh)
{
  const double x = xh*2;
  const double d00=x+2            ,d01=x+2*gllz_23[ 0],d02=x+2*gllz_23[ 1],
               d03=x+2*gllz_23[ 2],d04=x+2*gllz_23[ 3],d05=x+2*gllz_23[ 4],
               d06=x+2*gllz_23[ 5],d07=x+2*gllz_23[ 6],d08=x+2*gllz_23[ 7],
               d09=x+2*gllz_23[ 8],d10=x+2*gllz_23[ 9],d11=x              ,
               d12=x-2*gllz_23[ 9],d13=x-2*gllz_23[ 8],d14=x-2*gllz_23[ 7],
               d15=x-2*gllz_23[ 6],d16=x-2*gllz_23[ 5],d17=x-2*gllz_23[ 4],
               d18=x-2*gllz_23[ 3],d19=x-2*gllz_23[ 2],d20=x-2*gllz_23[ 1],
               d21=x-2*gllz_23[ 0],d22=x-2            ;
  const double u0_01=    1*d00,u0_02=u0_01*d01,u0_03=u0_02*d02,
               u0_04=u0_03*d03,u0_05=u0_04*d04,u0_06=u0_05*d05,
               u0_07=u0_06*d06,u0_08=u0_07*d07,u0_09=u0_08*d08,
               u0_10=u0_09*d09,u0_11=u0_10*d10,u0_12=u0_11*d11,
               u0_13=u0_12*d12,u0_14=u0_13*d13,u0_15=u0_14*d14,
               u0_16=u0_15*d15,u0_17=u0_16*d16,u0_18=u0_17*d17,
               u0_19=u0_18*d18,u0_20=u0_19*d19,u0_21=u0_20*d20,
               u0_22=u0_21*d21;
  const double v0_21=d22*    1,v0_20=d21*v0_21,v0_19=d20*v0_20,
               v0_18=d19*v0_19,v0_17=d18*v0_18,v0_16=d17*v0_17,
               v0_15=d16*v0_16,v0_14=d15*v0_15,v0_13=d14*v0_14,
               v0_12=d13*v0_13,v0_11=d12*v0_12,v0_10=d11*v0_11,
               v0_09=d10*v0_10,v0_08=d09*v0_09,v0_07=d08*v0_08,
               v0_06=d07*v0_07,v0_05=d06*v0_06,v0_04=d05*v0_05,
               v0_03=d04*v0_04,v0_02=d03*v0_03,v0_01=d02*v0_02,
               v0_00=d01*v0_01;
  p[ 0]=w[ 0]*    1*v0_00; p[ 1]=w[ 1]*u0_01*v0_01; p[ 2]=w[ 2]*u0_02*v0_02;
  p[ 3]=w[ 3]*u0_03*v0_03; p[ 4]=w[ 4]*u0_04*v0_04; p[ 5]=w[ 5]*u0_05*v0_05;
  p[ 6]=w[ 6]*u0_06*v0_06; p[ 7]=w[ 7]*u0_07*v0_07; p[ 8]=w[ 8]*u0_08*v0_08;
  p[ 9]=w[ 9]*u0_09*v0_09; p[10]=w[10]*u0_10*v0_10; p[11]=w[11]*u0_11*v0_11;
  p[12]=w[12]*u0_12*v0_12; p[13]=w[13]*u0_13*v0_13; p[14]=w[14]*u0_14*v0_14;
  p[15]=w[15]*u0_15*v0_15; p[16]=w[16]*u0_16*v0_16; p[17]=w[17]*u0_17*v0_17;
  p[18]=w[18]*u0_18*v0_18; p[19]=w[19]*u0_19*v0_19; p[20]=w[20]*u0_20*v0_20;
  p[21]=w[21]*u0_21*v0_21; p[22]=w[22]*u0_22*    1;
  if(d>0) {
    const double u1_02=    1*d01+u0_01,u1_03=u1_02*d02+u0_02,
                 u1_04=u1_03*d03+u0_03,u1_05=u1_04*d04+u0_04,
                 u1_06=u1_05*d05+u0_05,u1_07=u1_06*d06+u0_06,
                 u1_08=u1_07*d07+u0_07,u1_09=u1_08*d08+u0_08,
                 u1_10=u1_09*d09+u0_09,u1_11=u1_10*d10+u0_10,
                 u1_12=u1_11*d11+u0_11,u1_13=u1_12*d12+u0_12,
                 u1_14=u1_13*d13+u0_13,u1_15=u1_14*d14+u0_14,
                 u1_16=u1_15*d15+u0_15,u1_17=u1_16*d16+u0_16,
                 u1_18=u1_17*d17+u0_17,u1_19=u1_18*d18+u0_18,
                 u1_20=u1_19*d19+u0_19,u1_21=u1_20*d20+u0_20,
                 u1_22=u1_21*d21+u0_21;
    const double v1_20=d21*    1+v0_21,v1_19=d20*v1_20+v0_20,
                 v1_18=d19*v1_19+v0_19,v1_17=d18*v1_18+v0_18,
                 v1_16=d17*v1_17+v0_17,v1_15=d16*v1_16+v0_16,
                 v1_14=d15*v1_15+v0_15,v1_13=d14*v1_14+v0_14,
                 v1_12=d13*v1_13+v0_13,v1_11=d12*v1_12+v0_12,
                 v1_10=d11*v1_11+v0_11,v1_09=d10*v1_10+v0_10,
                 v1_08=d09*v1_09+v0_09,v1_07=d08*v1_08+v0_08,
                 v1_06=d07*v1_07+v0_07,v1_05=d06*v1_06+v0_06,
                 v1_04=d05*v1_05+v0_05,v1_03=d04*v1_04+v0_04,
                 v1_02=d03*v1_03+v0_03,v1_01=d02*v1_02+v0_02,
                 v1_00=d01*v1_01+v0_01;
    p[23+ 0]=2*w[ 0]*(                  v1_00);
    p[23+ 1]=2*w[ 1]*(    1*v0_01+u0_01*v1_01);
    p[23+ 2]=2*w[ 2]*(u1_02*v0_02+u0_02*v1_02);
    p[23+ 3]=2*w[ 3]*(u1_03*v0_03+u0_03*v1_03);
    p[23+ 4]=2*w[ 4]*(u1_04*v0_04+u0_04*v1_04);
    p[23+ 5]=2*w[ 5]*(u1_05*v0_05+u0_05*v1_05);
    p[23+ 6]=2*w[ 6]*(u1_06*v0_06+u0_06*v1_06);
    p[23+ 7]=2*w[ 7]*(u1_07*v0_07+u0_07*v1_07);
    p[23+ 8]=2*w[ 8]*(u1_08*v0_08+u0_08*v1_08);
    p[23+ 9]=2*w[ 9]*(u1_09*v0_09+u0_09*v1_09);
    p[23+10]=2*w[10]*(u1_10*v0_10+u0_10*v1_10);
    p[23+11]=2*w[11]*(u1_11*v0_11+u0_11*v1_11);
    p[23+12]=2*w[12]*(u1_12*v0_12+u0_12*v1_12);
    p[23+13]=2*w[13]*(u1_13*v0_13+u0_13*v1_13);
    p[23+14]=2*w[14]*(u1_14*v0_14+u0_14*v1_14);
    p[23+15]=2*w[15]*(u1_15*v0_15+u0_15*v1_15);
    p[23+16]=2*w[16]*(u1_16*v0_16+u0_16*v1_16);
    p[23+17]=2*w[17]*(u1_17*v0_17+u0_17*v1_17);
    p[23+18]=2*w[18]*(u1_18*v0_18+u0_18*v1_18);
    p[23+19]=2*w[19]*(u1_19*v0_19+u0_19*v1_19);
    p[23+20]=2*w[20]*(u1_20*v0_20+u0_20*v1_20);
    p[23+21]=2*w[21]*(u1_21*v0_21+u0_21*    1);
    p[23+22]=2*w[22]*(u1_22                  );
    if(d>1) {
      const double u2_03=    2*d02+2*u1_02,u2_04=u2_03*d03+2*u1_03,
                   u2_05=u2_04*d04+2*u1_04,u2_06=u2_05*d05+2*u1_05,
                   u2_07=u2_06*d06+2*u1_06,u2_08=u2_07*d07+2*u1_07,
                   u2_09=u2_08*d08+2*u1_08,u2_10=u2_09*d09+2*u1_09,
                   u2_11=u2_10*d10+2*u1_10,u2_12=u2_11*d11+2*u1_11,
                   u2_13=u2_12*d12+2*u1_12,u2_14=u2_13*d13+2*u1_13,
                   u2_15=u2_14*d14+2*u1_14,u2_16=u2_15*d15+2*u1_15,
                   u2_17=u2_16*d16+2*u1_16,u2_18=u2_17*d17+2*u1_17,
                   u2_19=u2_18*d18+2*u1_18,u2_20=u2_19*d19+2*u1_19,
                   u2_21=u2_20*d20+2*u1_20,u2_22=u2_21*d21+2*u1_21;
      const double v2_19=d20*    2+2*v1_20,v2_18=d19*v2_19+2*v1_19,
                   v2_17=d18*v2_18+2*v1_18,v2_16=d17*v2_17+2*v1_17,
                   v2_15=d16*v2_16+2*v1_16,v2_14=d15*v2_15+2*v1_15,
                   v2_13=d14*v2_14+2*v1_14,v2_12=d13*v2_13+2*v1_13,
                   v2_11=d12*v2_12+2*v1_12,v2_10=d11*v2_11+2*v1_11,
                   v2_09=d10*v2_10+2*v1_10,v2_08=d09*v2_09+2*v1_09,
                   v2_07=d08*v2_08+2*v1_08,v2_06=d07*v2_07+2*v1_07,
                   v2_05=d06*v2_06+2*v1_06,v2_04=d05*v2_05+2*v1_05,
                   v2_03=d04*v2_04+2*v1_04,v2_02=d03*v2_03+2*v1_03,
                   v2_01=d02*v2_02+2*v1_02,v2_00=d01*v2_01+2*v1_01;
      p[2*23+ 0]=4*w[ 0]*(                         +    1*v2_00);
      p[2*23+ 1]=4*w[ 1]*(           +2*    1*v1_01+u0_01*v2_01);
      p[2*23+ 2]=4*w[ 2]*(    2*v0_02+2*u1_02*v1_02+u0_02*v2_02);
      p[2*23+ 3]=4*w[ 3]*(u2_03*v0_03+2*u1_03*v1_03+u0_03*v2_03);
      p[2*23+ 4]=4*w[ 4]*(u2_04*v0_04+2*u1_04*v1_04+u0_04*v2_04);
      p[2*23+ 5]=4*w[ 5]*(u2_05*v0_05+2*u1_05*v1_05+u0_05*v2_05);
      p[2*23+ 6]=4*w[ 6]*(u2_06*v0_06+2*u1_06*v1_06+u0_06*v2_06);
      p[2*23+ 7]=4*w[ 7]*(u2_07*v0_07+2*u1_07*v1_07+u0_07*v2_07);
      p[2*23+ 8]=4*w[ 8]*(u2_08*v0_08+2*u1_08*v1_08+u0_08*v2_08);
      p[2*23+ 9]=4*w[ 9]*(u2_09*v0_09+2*u1_09*v1_09+u0_09*v2_09);
      p[2*23+10]=4*w[10]*(u2_10*v0_10+2*u1_10*v1_10+u0_10*v2_10);
      p[2*23+11]=4*w[11]*(u2_11*v0_11+2*u1_11*v1_11+u0_11*v2_11);
      p[2*23+12]=4*w[12]*(u2_12*v0_12+2*u1_12*v1_12+u0_12*v2_12);
      p[2*23+13]=4*w[13]*(u2_13*v0_13+2*u1_13*v1_13+u0_13*v2_13);
      p[2*23+14]=4*w[14]*(u2_14*v0_14+2*u1_14*v1_14+u0_14*v2_14);
      p[2*23+15]=4*w[15]*(u2_15*v0_15+2*u1_15*v1_15+u0_15*v2_15);
      p[2*23+16]=4*w[16]*(u2_16*v0_16+2*u1_16*v1_16+u0_16*v2_16);
      p[2*23+17]=4*w[17]*(u2_17*v0_17+2*u1_17*v1_17+u0_17*v2_17);
      p[2*23+18]=4*w[18]*(u2_18*v0_18+2*u1_18*v1_18+u0_18*v2_18);
      p[2*23+19]=4*w[19]*(u2_19*v0_19+2*u1_19*v1_19+u0_19*v2_19);
      p[2*23+20]=4*w[20]*(u2_20*v0_20+2*u1_20*v1_20+u0_20*    2);
      p[2*23+21]=4*w[21]*(u2_21*v0_21+2*u1_21*    1            );
      p[2*23+22]=4*w[22]*(u2_22*    1                          );
    }
  }
}

static const double gllz_24[11] = {
  0.9867305535051608835530867381544749753719197924133,
  0.95574822092988635802697713055064483107073304295574,
  0.90770567511350652199515299646620774920842011387828,
  0.84346407015487204062330503742334228584107610081033,
  0.7641704824204933077873752809522936513210604492369,
  0.67124010526412869983566485818700675657402328894643,
  0.56633135797929531218940954454228377043889499712648,
  0.45131637321432261824821849156962244882308821831249,
  0.3282476133755109120333891793596093437011778687727,
  0.19932125339083266723657253912499073081187559142148,
  0.066837993737228578113641808391677309796223208917628
};

static void gll_lag_24(double *restrict p, double *restrict w,
                       unsigned n, int d, double xh)
{
  const double x = xh*2;
  const double d00=x+2            ,d01=x+2*gllz_24[ 0],d02=x+2*gllz_24[ 1],
               d03=x+2*gllz_24[ 2],d04=x+2*gllz_24[ 3],d05=x+2*gllz_24[ 4],
               d06=x+2*gllz_24[ 5],d07=x+2*gllz_24[ 6],d08=x+2*gllz_24[ 7],
               d09=x+2*gllz_24[ 8],d10=x+2*gllz_24[ 9],d11=x+2*gllz_24[10],
               d12=x-2*gllz_24[10],d13=x-2*gllz_24[ 9],d14=x-2*gllz_24[ 8],
               d15=x-2*gllz_24[ 7],d16=x-2*gllz_24[ 6],d17=x-2*gllz_24[ 5],
               d18=x-2*gllz_24[ 4],d19=x-2*gllz_24[ 3],d20=x-2*gllz_24[ 2],
               d21=x-2*gllz_24[ 1],d22=x-2*gllz_24[ 0],d23=x-2            ;
  const double u0_01=    1*d00,u0_02=u0_01*d01,u0_03=u0_02*d02,
               u0_04=u0_03*d03,u0_05=u0_04*d04,u0_06=u0_05*d05,
               u0_07=u0_06*d06,u0_08=u0_07*d07,u0_09=u0_08*d08,
               u0_10=u0_09*d09,u0_11=u0_10*d10,u0_12=u0_11*d11,
               u0_13=u0_12*d12,u0_14=u0_13*d13,u0_15=u0_14*d14,
               u0_16=u0_15*d15,u0_17=u0_16*d16,u0_18=u0_17*d17,
               u0_19=u0_18*d18,u0_20=u0_19*d19,u0_21=u0_20*d20,
               u0_22=u0_21*d21,u0_23=u0_22*d22;
  const double v0_22=d23*    1,v0_21=d22*v0_22,v0_20=d21*v0_21,
               v0_19=d20*v0_20,v0_18=d19*v0_19,v0_17=d18*v0_18,
               v0_16=d17*v0_17,v0_15=d16*v0_16,v0_14=d15*v0_15,
               v0_13=d14*v0_14,v0_12=d13*v0_13,v0_11=d12*v0_12,
               v0_10=d11*v0_11,v0_09=d10*v0_10,v0_08=d09*v0_09,
               v0_07=d08*v0_08,v0_06=d07*v0_07,v0_05=d06*v0_06,
               v0_04=d05*v0_05,v0_03=d04*v0_04,v0_02=d03*v0_03,
               v0_01=d02*v0_02,v0_00=d01*v0_01;
  p[ 0]=w[ 0]*    1*v0_00; p[ 1]=w[ 1]*u0_01*v0_01; p[ 2]=w[ 2]*u0_02*v0_02;
  p[ 3]=w[ 3]*u0_03*v0_03; p[ 4]=w[ 4]*u0_04*v0_04; p[ 5]=w[ 5]*u0_05*v0_05;
  p[ 6]=w[ 6]*u0_06*v0_06; p[ 7]=w[ 7]*u0_07*v0_07; p[ 8]=w[ 8]*u0_08*v0_08;
  p[ 9]=w[ 9]*u0_09*v0_09; p[10]=w[10]*u0_10*v0_10; p[11]=w[11]*u0_11*v0_11;
  p[12]=w[12]*u0_12*v0_12; p[13]=w[13]*u0_13*v0_13; p[14]=w[14]*u0_14*v0_14;
  p[15]=w[15]*u0_15*v0_15; p[16]=w[16]*u0_16*v0_16; p[17]=w[17]*u0_17*v0_17;
  p[18]=w[18]*u0_18*v0_18; p[19]=w[19]*u0_19*v0_19; p[20]=w[20]*u0_20*v0_20;
  p[21]=w[21]*u0_21*v0_21; p[22]=w[22]*u0_22*v0_22; p[23]=w[23]*u0_23*    1;
  if(d>0) {
    const double u1_02=    1*d01+u0_01,u1_03=u1_02*d02+u0_02,
                 u1_04=u1_03*d03+u0_03,u1_05=u1_04*d04+u0_04,
                 u1_06=u1_05*d05+u0_05,u1_07=u1_06*d06+u0_06,
                 u1_08=u1_07*d07+u0_07,u1_09=u1_08*d08+u0_08,
                 u1_10=u1_09*d09+u0_09,u1_11=u1_10*d10+u0_10,
                 u1_12=u1_11*d11+u0_11,u1_13=u1_12*d12+u0_12,
                 u1_14=u1_13*d13+u0_13,u1_15=u1_14*d14+u0_14,
                 u1_16=u1_15*d15+u0_15,u1_17=u1_16*d16+u0_16,
                 u1_18=u1_17*d17+u0_17,u1_19=u1_18*d18+u0_18,
                 u1_20=u1_19*d19+u0_19,u1_21=u1_20*d20+u0_20,
                 u1_22=u1_21*d21+u0_21,u1_23=u1_22*d22+u0_22;
    const double v1_21=d22*    1+v0_22,v1_20=d21*v1_21+v0_21,
                 v1_19=d20*v1_20+v0_20,v1_18=d19*v1_19+v0_19,
                 v1_17=d18*v1_18+v0_18,v1_16=d17*v1_17+v0_17,
                 v1_15=d16*v1_16+v0_16,v1_14=d15*v1_15+v0_15,
                 v1_13=d14*v1_14+v0_14,v1_12=d13*v1_13+v0_13,
                 v1_11=d12*v1_12+v0_12,v1_10=d11*v1_11+v0_11,
                 v1_09=d10*v1_10+v0_10,v1_08=d09*v1_09+v0_09,
                 v1_07=d08*v1_08+v0_08,v1_06=d07*v1_07+v0_07,
                 v1_05=d06*v1_06+v0_06,v1_04=d05*v1_05+v0_05,
                 v1_03=d04*v1_04+v0_04,v1_02=d03*v1_03+v0_03,
                 v1_01=d02*v1_02+v0_02,v1_00=d01*v1_01+v0_01;
    p[24+ 0]=2*w[ 0]*(                  v1_00);
    p[24+ 1]=2*w[ 1]*(    1*v0_01+u0_01*v1_01);
    p[24+ 2]=2*w[ 2]*(u1_02*v0_02+u0_02*v1_02);
    p[24+ 3]=2*w[ 3]*(u1_03*v0_03+u0_03*v1_03);
    p[24+ 4]=2*w[ 4]*(u1_04*v0_04+u0_04*v1_04);
    p[24+ 5]=2*w[ 5]*(u1_05*v0_05+u0_05*v1_05);
    p[24+ 6]=2*w[ 6]*(u1_06*v0_06+u0_06*v1_06);
    p[24+ 7]=2*w[ 7]*(u1_07*v0_07+u0_07*v1_07);
    p[24+ 8]=2*w[ 8]*(u1_08*v0_08+u0_08*v1_08);
    p[24+ 9]=2*w[ 9]*(u1_09*v0_09+u0_09*v1_09);
    p[24+10]=2*w[10]*(u1_10*v0_10+u0_10*v1_10);
    p[24+11]=2*w[11]*(u1_11*v0_11+u0_11*v1_11);
    p[24+12]=2*w[12]*(u1_12*v0_12+u0_12*v1_12);
    p[24+13]=2*w[13]*(u1_13*v0_13+u0_13*v1_13);
    p[24+14]=2*w[14]*(u1_14*v0_14+u0_14*v1_14);
    p[24+15]=2*w[15]*(u1_15*v0_15+u0_15*v1_15);
    p[24+16]=2*w[16]*(u1_16*v0_16+u0_16*v1_16);
    p[24+17]=2*w[17]*(u1_17*v0_17+u0_17*v1_17);
    p[24+18]=2*w[18]*(u1_18*v0_18+u0_18*v1_18);
    p[24+19]=2*w[19]*(u1_19*v0_19+u0_19*v1_19);
    p[24+20]=2*w[20]*(u1_20*v0_20+u0_20*v1_20);
    p[24+21]=2*w[21]*(u1_21*v0_21+u0_21*v1_21);
    p[24+22]=2*w[22]*(u1_22*v0_22+u0_22*    1);
    p[24+23]=2*w[23]*(u1_23                  );
    if(d>1) {
      const double u2_03=    2*d02+2*u1_02,u2_04=u2_03*d03+2*u1_03,
                   u2_05=u2_04*d04+2*u1_04,u2_06=u2_05*d05+2*u1_05,
                   u2_07=u2_06*d06+2*u1_06,u2_08=u2_07*d07+2*u1_07,
                   u2_09=u2_08*d08+2*u1_08,u2_10=u2_09*d09+2*u1_09,
                   u2_11=u2_10*d10+2*u1_10,u2_12=u2_11*d11+2*u1_11,
                   u2_13=u2_12*d12+2*u1_12,u2_14=u2_13*d13+2*u1_13,
                   u2_15=u2_14*d14+2*u1_14,u2_16=u2_15*d15+2*u1_15,
                   u2_17=u2_16*d16+2*u1_16,u2_18=u2_17*d17+2*u1_17,
                   u2_19=u2_18*d18+2*u1_18,u2_20=u2_19*d19+2*u1_19,
                   u2_21=u2_20*d20+2*u1_20,u2_22=u2_21*d21+2*u1_21,
                   u2_23=u2_22*d22+2*u1_22;
      const double v2_20=d21*    2+2*v1_21,v2_19=d20*v2_20+2*v1_20,
                   v2_18=d19*v2_19+2*v1_19,v2_17=d18*v2_18+2*v1_18,
                   v2_16=d17*v2_17+2*v1_17,v2_15=d16*v2_16+2*v1_16,
                   v2_14=d15*v2_15+2*v1_15,v2_13=d14*v2_14+2*v1_14,
                   v2_12=d13*v2_13+2*v1_13,v2_11=d12*v2_12+2*v1_12,
                   v2_10=d11*v2_11+2*v1_11,v2_09=d10*v2_10+2*v1_10,
                   v2_08=d09*v2_09+2*v1_09,v2_07=d08*v2_08+2*v1_08,
                   v2_06=d07*v2_07+2*v1_07,v2_05=d06*v2_06+2*v1_06,
                   v2_04=d05*v2_05+2*v1_05,v2_03=d04*v2_04+2*v1_04,
                   v2_02=d03*v2_03+2*v1_03,v2_01=d02*v2_02+2*v1_02,
                   v2_00=d01*v2_01+2*v1_01;
      p[2*24+ 0]=4*w[ 0]*(                         +    1*v2_00);
      p[2*24+ 1]=4*w[ 1]*(           +2*    1*v1_01+u0_01*v2_01);
      p[2*24+ 2]=4*w[ 2]*(    2*v0_02+2*u1_02*v1_02+u0_02*v2_02);
      p[2*24+ 3]=4*w[ 3]*(u2_03*v0_03+2*u1_03*v1_03+u0_03*v2_03);
      p[2*24+ 4]=4*w[ 4]*(u2_04*v0_04+2*u1_04*v1_04+u0_04*v2_04);
      p[2*24+ 5]=4*w[ 5]*(u2_05*v0_05+2*u1_05*v1_05+u0_05*v2_05);
      p[2*24+ 6]=4*w[ 6]*(u2_06*v0_06+2*u1_06*v1_06+u0_06*v2_06);
      p[2*24+ 7]=4*w[ 7]*(u2_07*v0_07+2*u1_07*v1_07+u0_07*v2_07);
      p[2*24+ 8]=4*w[ 8]*(u2_08*v0_08+2*u1_08*v1_08+u0_08*v2_08);
      p[2*24+ 9]=4*w[ 9]*(u2_09*v0_09+2*u1_09*v1_09+u0_09*v2_09);
      p[2*24+10]=4*w[10]*(u2_10*v0_10+2*u1_10*v1_10+u0_10*v2_10);
      p[2*24+11]=4*w[11]*(u2_11*v0_11+2*u1_11*v1_11+u0_11*v2_11);
      p[2*24+12]=4*w[12]*(u2_12*v0_12+2*u1_12*v1_12+u0_12*v2_12);
      p[2*24+13]=4*w[13]*(u2_13*v0_13+2*u1_13*v1_13+u0_13*v2_13);
      p[2*24+14]=4*w[14]*(u2_14*v0_14+2*u1_14*v1_14+u0_14*v2_14);
      p[2*24+15]=4*w[15]*(u2_15*v0_15+2*u1_15*v1_15+u0_15*v2_15);
      p[2*24+16]=4*w[16]*(u2_16*v0_16+2*u1_16*v1_16+u0_16*v2_16);
      p[2*24+17]=4*w[17]*(u2_17*v0_17+2*u1_17*v1_17+u0_17*v2_17);
      p[2*24+18]=4*w[18]*(u2_18*v0_18+2*u1_18*v1_18+u0_18*v2_18);
      p[2*24+19]=4*w[19]*(u2_19*v0_19+2*u1_19*v1_19+u0_19*v2_19);
      p[2*24+20]=4*w[20]*(u2_20*v0_20+2*u1_20*v1_20+u0_20*v2_20);
      p[2*24+21]=4*w[21]*(u2_21*v0_21+2*u1_21*v1_21+u0_21*    2);
      p[2*24+22]=4*w[22]*(u2_22*v0_22+2*u1_22*    1            );
      p[2*24+23]=4*w[23]*(u2_23*    1                          );
    }
  }
}

static const double *const gllz_table[21] = {
  gllz_04, gllz_05, gllz_06, gllz_07, gllz_08, gllz_09, gllz_10, gllz_11,
  gllz_12, gllz_13, gllz_14, gllz_15, gllz_16, gllz_17, gllz_18, gllz_19,
  gllz_20, gllz_21, gllz_22, gllz_23, gllz_24
};

static lagrange_fun *const gll_lag_table[23] = {
  &gll_lag_02, &gll_lag_03, &gll_lag_04, &gll_lag_05, &gll_lag_06, &gll_lag_07,
  &gll_lag_08, &gll_lag_09, &gll_lag_10, &gll_lag_11, &gll_lag_12, &gll_lag_13,
  &gll_lag_14, &gll_lag_15, &gll_lag_16, &gll_lag_17, &gll_lag_18, &gll_lag_19,
  &gll_lag_20, &gll_lag_21, &gll_lag_22, &gll_lag_23, &gll_lag_24
};

