# Brief

This project contains VTK filters that uses CGAL for mesh processing.

This project is distributed under a BSD-3 License, but as it is linked to
CGAL, any binary generated with it retains the GPLv3 license.

# How to install

The vtkCGAL project requires the [CMake](https://cmake.org/) build system, the [VTK library](https://vtk.org/) and [CGAL](https://doc.cgal.org/latest/Manual/usage.html)

### conda libraries
```
conda create -n <env> python=3.9.*
conda install intel-openmp boost

```
### cmake ( RHEL7)

```
wget https://github.com/Kitware/CMake/releases/download/v3.22.2/cmake-3.22.2-linux-x86_64.sh
chmod +x cmake-3.22.2-linux-x86_64.sh 
sudo mkdir /opt/cmake.3.22
cd /opt/cmake.3.22/
sudo bash ~/cmake-3.22.2-linux-x86_64.sh 
```

### VTK

We need VTK >= 9.0. It can be installed:
* using the package manager of your system (including brew on OSX, or vcpkg on Windows),
* manually using [CMake instructions](https://vtk.org/Wiki/VTK/Configure_and_Build) (RHEL7)
```


wget https://www.vtk.org/files/release/9.1/VTK-9.1.0.tar.gz
tar xvzf VTK-9.1.0.tar.gz 
cd VTK-9.1.0/
mkdir build
cd build/
/opt/cmake.3.22/cmake-3.22.2-linux-x86_64/bin/ccmake ../VTK-9.1.0
make -j40
sudo mkdir /opt/VTK
sudo mv * /opt/VTK/ 
```
  - Environment vars
![vtk build params](vtk_build_params.png)

```
sudo make install
```
### CGAL

We need CGAL >= 5.3. It can be installed:
* using the package manager of your system (including brew on OSX, or vcpkg on Windows),
* manually using [CMake instructions](https://doc.cgal.org/latest/Manual/installation.html#installation_configwithcmake) (RHEL7)
```
wget https://github.com/CGAL/cgal/releases/download/v5.4/CGAL-5.4-library.tar.xz
tar xvf CGAL-5.4-library.tar.xz 
cd CGAL-5.4/
mkdir build
cd build/
/opt/cmake.3.22/cmake-3.22.2-linux-x86_64/bin/cmake ..
sudo make install
ll /opt/CGAL/lib/cmake/CGAL/
```

### GMP
```
wget https://gmplib.org/download/gmp/gmp-6.2.1.tar.xz
tar -xf gmp-6.2.1.tar.xz
cd gmp-6.2.1
PREFIX=/opt/gmp
./configure --prefix=$PREFIX
sudo make all
sudo make install
cp gmpxx.h $PREFIX/include
export GMP_INCLUDE_DIR=$PREFIX/include
export GMP_LIBRARIES=$PREFIX/lib
```
### vtkCGAL

Then, we can install this project using the standard CMake procedure:

1. Clone the project repository
   ```
   wget https://gitlab.kitware.com/vtk-cgal/vtk-cgal/-/archive/master/vtk-cgal-master.tar.gz
   ```
2. Create a build folder
3. Launch CMake with this repository as source folder
4. Configure the project. It will need VTK and CGAL.
	`ccmake .` to configure the specific libraries folder
   - If you have installed a library in a custom folder, you can find it in CMake
     by giving the folder: **install_dir**/lib/cmake/**project-version**. For example,
     for VTK: **install_dir**/lib/cmake/vtk-9.1.
   - You can provide a custom `CMAKE_INSTALL_PREFIX` if you do not want to install
     this project system wide.
5. Build and install this project (please refer to the
   [VTK tutorial](https://vtk.org/Wiki/VTK/Configure_and_Build#Build_VTK)
   if you do not know how to proceed).
```
cd /path/to/vtkCGAL-build
make -j8
```

### MPFR
choosen path is 
`/data/anaconda3/pkgs/mpfr-4.0.2-he80fd80_1/lib/`
`/data/anaconda3/pkgs/mpfr-4.0.2-he80fd80_1/include`

# Test

1. Test your setup
	`ctest`
	`ctest -VV` if something goes wrong


