/**
 * @class   vtkCGALPoisson
 * @brief   remesh using the CGAL delaunay
 *
 * vtkCGALPoisson allows to create closed delaunay meshes
 * from a set of points.
 * Requires the InputArrayToProcess to be the normals on each point.
 */

#ifndef vtkCGALPoisson_h
#define vtkCGALPoisson_h

#include "vtkPolyDataAlgorithm.h"

// CGAL includes
#include <CGAL/Exact_predicates_inexact_constructions_kernel.h>
#include <CGAL/Polyhedron_3.h>

using CGAL_Kernel     = CGAL::Exact_predicates_inexact_constructions_kernel;
using CGAL_Point      = CGAL_Kernel::Point_3;
using CGAL_Vector     = CGAL_Kernel::Vector_3;
using CGAL_Polyhedron = CGAL::Polyhedron_3<CGAL_Kernel>;

#include "vtkCGALReconstructionModule.h" // For export macro

class VTKCGALRECONSTRUCTION_EXPORT vtkCGALPoisson : public vtkPolyDataAlgorithm
{
public:
  static vtkCGALPoisson* New();
  vtkTypeMacro(vtkCGALPoisson, vtkPolyDataAlgorithm);
  void PrintSelf(ostream& os, vtkIndent indent) override;

protected:
  vtkCGALPoisson()           = default;
  ~vtkCGALPoisson() override = default;

  int RequestData(vtkInformation*, vtkInformationVector**, vtkInformationVector*) override;

private:
  vtkCGALPoisson(const vtkCGALPoisson&) = delete;
  void operator=(const vtkCGALPoisson&) = delete;
};

#endif
