/**
 * @class   vtkCGALAdvancingFront
 * @brief   remesh using the CGAL delaunay
 *
 * vtkCGALAdvancingFront allows to create plannar delaunay meshes
 * from a set of planar points, edges and polygons.
 * From now on, the input mesh needs to be planar along x, y or z.
 * Constraints should not overlap each others.
 */

#ifndef vtkCGALAdvancingFront_h
#define vtkCGALAdvancingFront_h

#include "vtkPolyDataAlgorithm.h"

// CGAL includes
#include <CGAL/Surface_mesh.h>
#include <CGAL/Simple_cartesian.h>

using CGAL_Kernel  = CGAL::Simple_cartesian<double>;

#include "vtkCGALReconstructionModule.h" // For export macro

class VTKCGALRECONSTRUCTION_EXPORT vtkCGALAdvancingFront : public vtkPolyDataAlgorithm
{
public:
  static vtkCGALAdvancingFront* New();
  vtkTypeMacro(vtkCGALAdvancingFront, vtkPolyDataAlgorithm);
  void PrintSelf(ostream& os, vtkIndent indent) override;

protected:
  vtkCGALAdvancingFront()           = default;
  ~vtkCGALAdvancingFront() override = default;

  int RequestData(vtkInformation*, vtkInformationVector**, vtkInformationVector*) override;

private:
  vtkCGALAdvancingFront(const vtkCGALAdvancingFront&) = delete;
  void operator=(const vtkCGALAdvancingFront&) = delete;
};

#endif
