#include <iostream>

#include <vtkNew.h>
#include <vtkPointData.h>
#include <vtkPolyDataNormals.h>
#include <vtkTestUtilities.h>
#include <vtkXMLPolyDataReader.h>
#include <vtkXMLPolyDataWriter.h>

#include "vtkCGALPoisson.h"

int TestPoissonExecution(int, char* argv[])
{
  // Open data

  vtkNew<vtkXMLPolyDataReader> reader2;
  std::string                  cfname2(argv[1]);
  cfname2 += "shrink_sphere.vtp";
  reader2->SetFileName(cfname2.c_str());

  vtkNew<vtkPolyDataNormals> norm;
  norm->SetInputConnection(reader2->GetOutputPort());
  norm->Update();
  norm->GetOutput()->GetPointData()->SetActiveNormals("Normals");

  // Remesh

  vtkNew<vtkCGALPoisson> pr;
  pr->SetInputConnection(norm->GetOutputPort());

  // Save result

  vtkNew<vtkXMLPolyDataWriter> writer;

  writer->SetInputConnection(pr->GetOutputPort());
  writer->SetFileName("poisson_reconstruct.vtp");
  writer->Write();

  return 0;
}
