#include <iostream>

#include <vtkNew.h>
#include <vtkTestUtilities.h>
#include <vtkXMLPolyDataReader.h>
#include <vtkXMLPolyDataWriter.h>

#include "vtkCGALAdvancingFront.h"

int TestAdvancingFrontExecution(int, char* argv[])
{
  // Open data

  vtkNew<vtkXMLPolyDataReader> reader2;
  std::string                  cfname2(argv[1]);
  cfname2 += "shrink_sphere.vtp";
  reader2->SetFileName(cfname2.c_str());

  // Remesh

  vtkNew<vtkCGALAdvancingFront> af;
  af->SetInputConnection(reader2->GetOutputPort());

  // Save result

  vtkNew<vtkXMLPolyDataWriter> writer;

  writer->SetInputConnection(af->GetOutputPort());
  writer->SetFileName("advancing_reconstruct.vtp");
  writer->Write();

  return 0;
}
