/**
 * @class   vtkCGALAlphaWrapping
 * @brief   remesh using the CGAL isotropic remeshing
 *
 * vtkCGALAlphaWrapping is a filter allowing to reconstruct
 * a 2-manifold from an arbitrary polygon soup
 */

#ifndef vtkCGALAlphaWrapping_h
#define vtkCGALAlphaWrapping_h

#include "vtkCGALPolyDataAlgorithm.h"

#include "vtkCGALPMPModule.h" // For export macro

class VTKCGALPMP_EXPORT vtkCGALAlphaWrapping : public vtkCGALPolyDataAlgorithm
{
public:
  static vtkCGALAlphaWrapping* New();
  vtkTypeMacro(vtkCGALAlphaWrapping, vtkCGALPolyDataAlgorithm);
  void PrintSelf(ostream& os, vtkIndent indent) override;

  //@{
  /**
   * Get / Set the alpha property, a small alpha
   * lead to a finer reconstruction (but more computation).
   * The value is relative to the diagonal lenght of the input
   **/
  vtkGetMacro(Alpha, double);
  vtkSetMacro(Alpha, double);
  //@}

  //@{
  /**
   * Get / Set the offset property, drive a dilatation
   * on the resulting mesh. The goal is to fix degenerancies
   * and keep a 2-manifold output.
   * The value is relative to the diagonal lenght of the input
   **/
  vtkGetMacro(Offset, double);
  vtkSetMacro(Offset, double);
  //@}

protected:
  vtkCGALAlphaWrapping()           = default;
  ~vtkCGALAlphaWrapping() override = default;

  int RequestData(vtkInformation*, vtkInformationVector**, vtkInformationVector*) override;

  // Fields

  double Alpha  = 5;
  double Offset = 3;

private:
  vtkCGALAlphaWrapping(const vtkCGALAlphaWrapping&) = delete;
  void operator=(const vtkCGALAlphaWrapping&)       = delete;
};

#endif
