import imp
import os
import sys

import smtk
if smtk.wrappingProtocol() == 'pybind11':
  import smtk.bridge.polygon
  import smtk.model


# Add path to adhcommon.py script
abs_path = os.path.abspath(__file__)
abs_dir = os.path.dirname(abs_path)
module_dir = os.path.join(abs_dir, os.pardir, os.pardir)
sys.path.append(module_dir)
import SW2D as sw2D

# Currently hard-coded to exodus models only
SESSION_TYPE = 'polygon'

#----------------------------------------------------------------------
def load_smtk_model(model_manager, session_type, smtk_file):
  '''Imports and returns smtk model.

  Application should check validity
  '''
  print 'importing model file'
  mgr = smtk.model.Manager.create()
  sess = model_manager.createSession(session_type)
  sess.assignDefaultName()
  #SetActiveSession(sess)

  op = sess.op("load smtk model")
  #print 'op', op
  op.findFile("filename", smtk.attribute.ALL_CHILDREN).setValue(0, smtk_file)
  #print 'able to operate?', op.ableToOperate()
  result = op.operate()
  #print smtk_file
  #LoadSMTKModel(smtk_file)
  #result = GetLastResult()

  outcome = result.findInt('outcome').value(0)
  print 'outcome ok?', outcome == smtk.model.OPERATION_SUCCEEDED
  model = result.findModelEntity('created').value(0)
  print 'model valid?', model.isValid()
  return model

#----------------------------------------------------------------------
def load_resources(model_manager, resource_file):
  '''Reads and returns smtk.common.ResourceSet
  '''
  print 'loading resource file'
  resources = smtk.common.ResourceSet()
  reader = smtk.io.ResourceSetReader(model_manager)
  logger = smtk.io.Logger()

  hasErrors = reader.readFile(resource_file, resources, logger)
  if hasErrors:
      print "Reader has errors:"
      print logger.convertToString()

  return resources

#----------------------------------------------------------------------
def load_attributes(model_manager, att_file):
  '''Reads and returns attribute system
  '''
  print 'loading attribute file'
  att_system = smtk.attribute.System()
  att_system.setRefModelManager(model_manager)
  reader = smtk.io.AttributeReader()
  logger = smtk.io.Logger()
  read_err = reader.read(att_system, att_file, logger)
  print 'read ok?', not read_err
  return att_system

#----------------------------------------------------------------------
class MockExportSpec:
  '''
  '''
  def __init__(self, sim_atts, export_atts=None):
    self.sim_atts = sim_atts
    self.export_atts = export_atts
    self.logger = smtk.io.Logger()

  def getSimulationAttributes(self):
    return self.sim_atts

  def getExportAttributes(self):
    return self.export_atts

  def getLogger(self):
    return self.logger


#----------------------------------------------------------------------
if __name__ == '__main__':

  input_model = 'simple_SW2D.smtk'
  input_crf_file = 'simple_SW2D_default.crf'

  # Load model
  this_dir = os.path.dirname(os.path.abspath(__file__))
  model_path = os.path.join(this_dir, input_model)
  model_manager = smtk.model.Manager.create()
  currModel = load_smtk_model(model_manager, SESSION_TYPE, model_path)
  if not currModel.isValid():
    print 'ERROR loading model file', model_path
    sys.exit(-1)

  # Load resource file
  resource_set = load_resources(model_manager, input_crf_file)

  # Initialize simuation attributes
  simbuilder_resource = resource_set.get('simbuilder')
  if smtk.wrappingProtocol() == 'shiboken':
    sim_atts = smtk.attribute.System.CastTo(simbuilder_resource)
  else:
    sim_atts = simbuilder_resource

  #print 'sim_atts', sim_atts
  sim_atts.setRefModelManager(model_manager)

  export_resource = resource_set.get('export')
  if smtk.wrappingProtocol() == 'shiboken':
    export_atts = smtk.attribute.System.CastTo(export_resource)
  else:
    export_atts = export_resource
    
  print 'export_atts', export_atts

  # Initialize export attributes
  export_spec_att = None
  att_list = export_atts.findAttributes('ExportSpec')
  if att_list:
    export_spec_att = att_list[0]
  else:
    export_spec_defn = export_atts.findDefinition('ExportSpec')
    export_spec_att = export_atts.createAttribute(
      'ExportSpec', export_spec_defn)

  analysis_item = export_spec_att.findString('AnalysisTypes')
  analysis_item.setValue(0, 'Constituent Transport')

  meshes = model_manager.meshes()
  meshColls = meshes.associatedCollections(currModel)
  meshSet = meshColls[0].meshes()
  mesh_item = export_spec_att.findMesh('mesh')
  mesh_item.setValue(0, meshSet)

  dir_item = export_spec_att.findDirectory('OutputDirectory')
  dir_item.setValue(0,this_dir)

  filebase_item = export_spec_att.findString('FileBase')
  filebase_item.setValue(0,input_model.split(".")[0])

  pythonScript = export_spec_att.findFile('PythonScript')
  pythonScript.setValue(0,'SW2D.py')
  # Initialize MockExportSpec and run export script
  export_spec = MockExportSpec(sim_atts, export_atts)
  completed = sw2D.ExportCMB(export_spec)

  #print 'finish, completed:', completed
