<?xml version="1.0"?>
<SMTK_AttributeManager Version="1">
  <Includes>
    <!-- Uses same definitions as surface water -->
    <File>SW2DDefinitions.sbt</File>
  </Includes>

  <!-- Adds extrusion meshing attribute -->
  <Categories>
    <Cat>Meshing</Cat>
  </Categories>

  <Definitions>
    <AttDef Type="Extrusion" Label="Extrusion" Unique="true" Associations="f">
      <ItemDefinitions>
        <Int Name="NumberOfLayers">
          <Categories>Meshing</Categories>
          <DefaultValue>1</DefaultValue>
          <RangeInfo>
            <Min Exclusive="false">1</Min>
          </RangeInfo>
        </Int>
      </ItemDefinitions>
    </AttDef>
  </Definitions>

  <!--********** Workflow Views ***********-->
  <!-- Same as surface water PLUS meshing view -->
  <RootView Title="SimBuilder">
    <DefaultColor>1., 1., 0.5, 1.</DefaultColor>
    <InvalidColor>1, 0.5, 0.5, 1</InvalidColor>

    <InstancedView Title="Solvers">
      <InstancedAttributes>
        <Att Type="Solvers">Solvers</Att>
      </InstancedAttributes>
    </InstancedView>

    <InstancedView Title="Time">
      <InstancedAttributes>
        <Att Type="Time">Time</Att>
      </InstancedAttributes>
    </InstancedView>

    <InstancedView Title="Globals">
      <InstancedAttributes>
        <Att Type="Globals">Globals</Att>
      </InstancedAttributes>
    </InstancedView>

    <SimpleExpressionView Title="XY Series">
      <Definition>XYSeries</Definition>
    </SimpleExpressionView>

    <AttributeView Title="Materials" ModelEntityFilter="f" CreateEntities="true">
      <AttributeTypes>
        <Type>SWMaterial</Type>
      </AttributeTypes>
    </AttributeView>


    <AttributeView Title="Friction" ModelEntityFilter="f" CreateEntities="true">
      <AttributeTypes>
        <Type>Friction</Type>
      </AttributeTypes>
    </AttributeView>

    <AttributeView Title="BoundaryConditions" ModelEntityFilter="e">
      <AttributeTypes>
        <Type>WaterSurfElev</Type>
        <Type>TotalDischarge</Type>
        <Type>VelocityNB</Type>
        <Type>VelocityDB</Type>
        <Type>LidElevation</Type>
        <Type>SupercriticalInflow</Type>
        <Type>WaterDepthLid</Type>
        <Type>UnitFlow</Type>
        <Type>FloatingStationary</Type>
      </AttributeTypes>
    </AttributeView>

    <AttributeView Title="Extrusions" ModelEntityFilter="f">
      <AttributeTypes>
        <Type>Extrusion</Type>
      </AttributeTypes>
    </AttributeView>

    <GroupView Title="Constituents" Style="Tiled">
      <AttributeView Title="Constituent Definitions" CreateEntities="true">
        <AttributeTypes>
          <Type>GeneralConstituent</Type>
          <Type>SalinityConstituent</Type>
          <Type>TemperatureConstituent</Type>
          <Type>VorticityConstituent</Type>
        </AttributeTypes>
      </AttributeView>
    </GroupView>

  </RootView>


</SMTK_AttributeManager>
