<?xml version="1.0"?>
<!--Created by XmlV1StringWriter-->
<SMTK_AttributeManager Version="1">
  <!--**********  Category and Analysis Infomation ***********-->
  <Categories>
    <Cat>Time</Cat>
    <Cat>Flow</Cat>
    <Cat>General</Cat>
    <Cat>Constituent</Cat>
  </Categories>
  <Analyses>
    <Analysis Type="Hydro Only">
      <Cat>Flow</Cat>
      <Cat>General</Cat>
      <Cat>Time</Cat>
    </Analysis>
    <Analysis Type="Constituent Transport">
      <Cat>Flow</Cat>
      <Cat>Constituent</Cat>
      <Cat>General</Cat>
      <Cat>Time</Cat>
    </Analysis>
  </Analyses>
  <!--**********  Attribute Definitions ***********-->
  <Definitions>
    <!--***  Constituent Definitions ***-->
    <AttDef Type="Constituent" BaseType="" Label="Constituent" Version="0" Abstract="1">
    </AttDef>
    <AttDef Type="DensityConstituent" Label="DensityConstituent" BaseType="Constituent" Abstract="1" Version="0">
      <ItemDefinitions>
        <Double Name="ReferenceConcentration" Label="Reference Concentration:" Version="0" AdvanceLevel="0" NumberOfRequiredValues="1">
          <RangeInfo>
            <Min Inclusive="false">0.0</Min>
          </RangeInfo>
          <DefaultValue>1.0</DefaultValue>
          <Categories>
            <Cat>Constituent</Cat>
          </Categories>
        </Double>
        <Group Name="ConstituentParams" Label="Transport Parameters:">
          <!--Category here makes sure that the dropdown list shows up as Constituent.-->
          <Categories>
           <Cat>Constituent</Cat>
          </Categories>
          <ItemDefinitions>
            <Group Name="DefaultTransportParams" Label="Default Transport Parameters:" Version="0" AdvanceLevel="0" NumberOfRequiredGroups="1">
              <ItemDefinitions>
                <Double Name="DefaultTurbulentDiffRate" Label="Default Turbulent Diffusion Rate:" Version="0" AdvanceLevel="0" NumberOfRequiredValues="1">
                  <BriefDescription>The default value applied to any constituents not assigned individually.</BriefDescription>
                  <Categories>
                   <Cat>Constituent</Cat>
                  </Categories>
                  <DefaultValue>1.0E-06</DefaultValue>
                  <RangeInfo>
                    <Min Inclusive="false">0</Min>
                  </RangeInfo>
                </Double>
                <Double Name="DefaultTransportRefTol" Label="Default Transport Refinement Tolerance:" Version="0" AdvanceLevel="0" NumberOfRequiredValues="1">
                  <BriefDescription>The default value applied to any constituents not assigned individually.</BriefDescription>
                  <Categories>
                    <Cat>Constituent</Cat>
                  </Categories>
                  <DefaultValue>1.0</DefaultValue>
                  <RangeInfo>
                    <Min Inclusive="false">0</Min>
                  </RangeInfo>
                </Double>
              </ItemDefinitions>
            </Group>
            <Group Name="MatSpecificTransportParams" Label="Material Specific Transport Parameters:" Version="0" AdvanceLevel="0" NumberOfRequiredGroups="1" Optional="true">
              <ItemDefinitions>
                <Group Name="MaterialSpecifics" Label="Material Specifics" Version="0" AdvanceLevel="0"
                 Extensible="true" NumberOfRequiredGroups="0">
                  <BriefDescription>Constituent information for a specific material.</BriefDescription>
                  <ItemDefinitions>
                    <AttributeRef Name="Material" Label="Material" Version="0" AdvanceLevel="0" NumberOfRequiredValues="1">
                      <AttDef>SWMaterial</AttDef>
                    </AttributeRef>
                    <Double Name="TurbulentDiffRate" Label="Turbulent Diffusion Rate:" Version="0" AdvanceLevel="0" NumberOfRequiredValues="1">
                      <BriefDescription>The turbulent diffusion rate of the constituent in a specific material.</BriefDescription>
                      <Categories>
                        <Cat>Constituent</Cat>
                      </Categories>
                      <DefaultValue>1.0E-06</DefaultValue>
                      <RangeInfo>
                        <Min Inclusive="false">0</Min>
                      </RangeInfo>
                    </Double>
                    <Double Name="TransportRefTol" Label="Transport Refinement Tolerance:" Version="0" AdvanceLevel="0" NumberOfRequiredValues="1">
                      <Categories>
                        <Cat>Constituent</Cat>
                      </Categories>
                      <DefaultValue>1.0</DefaultValue>
                      <RangeInfo>
                        <Min Inclusive="false">0</Min>
                      </RangeInfo>
                    </Double>
                  </ItemDefinitions>
                </Group>
                </ItemDefinitions>
              </Group>
            </ItemDefinitions>
        </Group>
        <Group Name="ConstituentBCs" Label="Constituent Boundary Concentrations:">
          <Categories>
           <Cat>Constituent</Cat>
          </Categories>
          <ItemDefinitions>
            <Group Name="DefaultConstituentBC" Label="Default Constituent Boundary Concentration" NumberOfRequiredGroups="1">
              <ItemDefinitions>
                <Int Name="ConstituentBCType" Label="Default Boundary Condition Type:" Version="0" AdvanceLevel="0" NumberOfRequiredValues="1">
                  <Categories>
                    <Cat>Constituent</Cat>
                  </Categories>
                  <DiscreteInfo DefaultIndex="0">
                    <Value Enum="Dirichlet Transport (DB TRN)">0</Value>
                    <Value Enum="Natural Transport (NB TRN)">1</Value>
                  </DiscreteInfo>
                </Int>
                <Double Name="Value" Label="Default Concentration Values:" Version="0" NumberOfRequiredValues="1">
                  <ExpressionType>XYSeries</ExpressionType>
                  <DefaultValue>0.0</DefaultValue>
                  <Categories>
                    <Cat>Constituent</Cat>
                  </Categories>
                </Double>
              </ItemDefinitions>
            </Group>
            <Group Name="BoundarySpecificBC" Label="Boundary Specific Concentration Values:" Version="0" AdvanceLevel="0" NumberOfRequiredGroups="1" Optional="true">
              <ItemDefinitions>
                <Group Name="BoundarySpecifics" Label="Boundary Specifics" Version="0" AdvanceLevel="0"
                 Extensible="true" NumberOfRequiredGroups="0">
                  <BriefDescription>Concentration values for a specific boundary.</BriefDescription>
                  <ItemDefinitions>
                    <AttributeRef Name="ConstituentBoundary" Label="Boundary" Version="0" AdvanceLevel="0" NumberOfRequiredValues="1">
                      <AttDef>BoundaryConditionWithConstituent</AttDef>
                    </AttributeRef>
                    <Int Name="ConstituentBCType" Label="Boundary Condition Type:" Version="0" AdvanceLevel="0" NumberOfRequiredValues="1">
                      <Categories>
                        <Cat>Constituent</Cat>
                      </Categories>
                      <DiscreteInfo DefaultIndex="0">
                        <Value Enum="Dirichlet Transport (DB TRN)">0</Value>
                        <Value Enum="Natural Transport (NB TRN)">1</Value>
                      </DiscreteInfo>
                    </Int>
                    <Double Name="Value" Label="Concentration Values:" Version="0" NumberOfRequiredValues="1">
                      <ExpressionType>XYSeries</ExpressionType>
                      <DefaultValue>0.0</DefaultValue>
                      <Categories>
                        <Cat>Constituent</Cat>
                      </Categories>
                    </Double>
                  </ItemDefinitions>
                </Group>
              </ItemDefinitions>
            </Group>
          </ItemDefinitions>
        </Group>
      </ItemDefinitions>
    </AttDef>
    <AttDef Type="GeneralConstituent" BaseType="DensityConstituent" Label="General Constituent" Version="0">
    </AttDef>
    <AttDef Type="VorticityConstituent" BaseType="Constituent" Label="Vorticity" Version="0">
      <ItemDefinitions>
        <Group Name="VortConstituentParams" Label="Vorticity Parameters"
         Version="0" AdvanceLevel="0" NumberOfRequiredGroups="1">
          <ItemDefinitions>
            <Double Name="NormalizationFactor" Label="Normalization Factor" Version="0" AdvanceLevel="0" NumberOfRequiredValues="1">
              <RangeInfo>
                <Min Inclusive="false">0.0</Min>
              </RangeInfo>
              <DefaultValue>1.0</DefaultValue>
              <Categories>
                <Cat>Constituent</Cat>
              </Categories>
            </Double>
            <Double Name="AsTerm" Label="As Term" Version="0" AdvanceLevel="0" NumberOfRequiredValues="1">
              <RangeInfo>
                <Min Inclusive="true">0.0</Min>
              </RangeInfo>
              <DefaultValue>5.0</DefaultValue>
            </Double>
            <Double Name="DsTerm" Label="Ds Term" Version="0" AdvanceLevel="0" NumberOfRequiredValues="1">
              <RangeInfo>
                <Min Inclusive="true">0.0</Min>
              </RangeInfo>
              <DefaultValue>0.5</DefaultValue>
            </Double>
          </ItemDefinitions>
        </Group>
        <Group Name="ConstituentParams" Label="Transport Parameters:">
          <!--Category here makes sure that the dropdown list shows up as Constituent.-->
          <Categories>
           <Cat>Constituent</Cat>
          </Categories>
          <ItemDefinitions>
            <Group Name="DefaultTransportParams" Label="Default Transport Parameters:" Version="0" AdvanceLevel="0" NumberOfRequiredGroups="1">
              <ItemDefinitions>
                <Double Name="DefaultTurbulentDiffRate" Label="Default Turbulent Diffusion Rate:" Version="0" AdvanceLevel="0" NumberOfRequiredValues="1">
                  <BriefDescription>The default value applied to any constituents not assigned individually.</BriefDescription>
                  <Categories>
                   <Cat>Constituent</Cat>
                  </Categories>
                  <DefaultValue>1.0E-06</DefaultValue>
                  <RangeInfo>
                    <Min Inclusive="false">0</Min>
                  </RangeInfo>
                </Double>
                <Double Name="DefaultTransportRefTol" Label="Default Transport Refinement Tolerance:" Version="0" AdvanceLevel="0" NumberOfRequiredValues="1">
                  <BriefDescription>The default value applied to any constituents not assigned individually.</BriefDescription>
                  <Categories>
                    <Cat>Constituent</Cat>
                  </Categories>
                  <DefaultValue>1.0</DefaultValue>
                  <RangeInfo>
                    <Min Inclusive="false">0</Min>
                  </RangeInfo>
                </Double>
              </ItemDefinitions>
            </Group>
            <Group Name="MatSpecificTransportParams" Label="Material Specific Transport Parameters:" Version="0" AdvanceLevel="0" NumberOfRequiredGroups="1" Optional="true">
              <ItemDefinitions>
                <Group Name="MaterialSpecifics" Label="Material Specifics" Version="0" AdvanceLevel="0"
                 Extensible="true" NumberOfRequiredGroups="0">
                  <BriefDescription>Constituent information for a specific material.</BriefDescription>
                  <ItemDefinitions>
                    <AttributeRef Name="Material" Label="Material" Version="0" AdvanceLevel="0" NumberOfRequiredValues="1">
                      <AttDef>SWMaterial</AttDef>
                    </AttributeRef>
                    <Double Name="TurbulentDiffRate" Label="Turbulent Diffusion Rate:" Version="0" AdvanceLevel="0" NumberOfRequiredValues="1">
                      <BriefDescription>The turbulent diffusion rate of the constituent in a specific material.</BriefDescription>
                      <Categories>
                        <Cat>Constituent</Cat>
                      </Categories>
                      <DefaultValue>1.0E-06</DefaultValue>
                      <RangeInfo>
                        <Min Inclusive="false">0</Min>
                      </RangeInfo>
                    </Double>
                    <Double Name="TransportRefTol" Label="Transport Refinement Tolerance:" Version="0" AdvanceLevel="0" NumberOfRequiredValues="1">
                      <Categories>
                        <Cat>Constituent</Cat>
                      </Categories>
                      <DefaultValue>1.0</DefaultValue>
                      <RangeInfo>
                        <Min Inclusive="false">0</Min>
                      </RangeInfo>
                    </Double>
                  </ItemDefinitions>
                </Group>
                </ItemDefinitions>
              </Group>
          </ItemDefinitions>
        </Group>
      </ItemDefinitions>
    </AttDef>
    <AttDef Type="SalinityConstituent" BaseType="DensityConstituent" Label="Salinity" Version="0">
    </AttDef>
    <AttDef Type="TemperatureConstituent" BaseType="Constituent" Label="Temperature" Version="0">
      <ItemDefinitions>
        <Double Name="BoundaryTemp" Label="Boundary Temperature" Version="0" AdvanceLevel="0" NumberOfRequiredValues="1">
          <RangeInfo>
            <Min Inclusive="true">0.0</Min>
          </RangeInfo>
          <DefaultValue>0.0</DefaultValue>
          <Categories>
            <Cat>Constituent</Cat>
          </Categories>
        </Double>
        <Group Name="HeatTransfer" Label="Heat Transfer through Air/Water Interface" Version="0" AdvanceLevel="0" Optional="true">
          <ItemDefinitions>
            <Group Name="BoundarySpecifics" Label="Boundary Specifics" Version="0" AdvanceLevel="0"
             Extensible="true" NumberOfRequiredGroups="0">
              <ItemDefinitions>
                <AttributeRef Name="ConstituentBoundary" Label="Boundary" Version="0" AdvanceLevel="0" NumberOfRequiredValues="1">
                  <AttDef>BoundaryConditionWithConstituent</AttDef>
                </AttributeRef>
                <Double Name="SWR" Label="Short Wave Radiation:" Version="0" NumberOfRequiredValues="1">
                  <ExpressionType>XYSeries</ExpressionType>
                  <Categories>
                    <Cat>Flow</Cat>
                  </Categories>
                </Double>
                <Double Name="DPT" Label="Dew Point Temperature (Celsius):" Version="0" NumberOfRequiredValues="1">
                  <ExpressionType>XYSeries</ExpressionType>
                  <Categories>
                    <Cat>Flow</Cat>
                  </Categories>
                </Double>
              </ItemDefinitions>
            </Group>
          </ItemDefinitions>
        </Group>
      </ItemDefinitions>
    </AttDef>

    <!--***  Material Definitions ***-->
    <AttDef Type="SWMaterial" Label="SW Material" BaseType="" Version="0" Unique="true" Associations="f">
      <ItemDefinitions>
        <Group Name="KinematicEddyViscosity" Label="Kinematic eddy viscosity (MP EVS):" Version="0" AdvanceLevel="0" NumberOfRequiredGroups="1">
          <ItemDefinitions>
            <Double Name="Exx" Label="Exx" Version="0" NumberOfRequiredValues="1">
              <RangeInfo>
                <Min Inclusive="false">0</Min>
              </RangeInfo>
              <Categories>
                <Cat>Flow</Cat>
              </Categories>
              <DefaultValue>0.5</DefaultValue>
            </Double>
            <Double Name="Eyy" Label="Eyy" Version="0" NumberOfRequiredValues="1">
              <RangeInfo>
                <Min Inclusive="false">0</Min>
              </RangeInfo>
              <Categories>
                <Cat>Flow</Cat>
              </Categories>
              <DefaultValue>0.5</DefaultValue>
            </Double>
            <Double Name="Exy" Label="Exy" Version="0" NumberOfRequiredValues="1">
              <RangeInfo>
                <Min Inclusive="false">0</Min>
              </RangeInfo>
              <Categories>
                <Cat>Flow</Cat>
              </Categories>
              <DefaultValue>0.5</DefaultValue>
            </Double>
          </ItemDefinitions>
        </Group>
        <Double Name="CoriolisLatitude" Label="Coriolis Latitude (MP COR):" Version="0" AdvanceLevel="0" NumberOfRequiredValues="1">
          <RangeInfo>
            <Min Inclusive="true">-90</Min>
            <Max Inclusive="true">90</Max>
          </RangeInfo>
          <DefaultValue>0.0</DefaultValue>
          <Categories>
            <Cat>Flow</Cat>
          </Categories>
        </Double>
        <Group Name="RefinementParameters"  Label="Refinement Parameters:" Version="0" AdvanceLevel="1" NumberOfRequiredGroups="1">
          <ItemDefinitions>
            <Int Name="MaxRefineLevels" Label="Maximum Levels of Refinement (MP ML):" Version="0" AdvanceLevel="1" NumberOfRequiredValues="1">
              <RangeInfo>
                <Min Inclusive="true">0</Min>
              </RangeInfo>
              <DefaultValue>0</DefaultValue>
              <Categories>
                <Cat>General</Cat>
              </Categories>
            </Int>

            <Double Name="HydroRefineTol" Label="Hydro refinement tolerance (MP SRT):" Version="0" AdvanceLevel="1" NumberOfRequiredValues="1">
              <RangeInfo>
                <Min Inclusive="false">0</Min>
              </RangeInfo>
              <DefaultValue>1.0</DefaultValue>
              <Categories>
                <Cat>Flow</Cat>
              </Categories>
            </Double>
          </ItemDefinitions>
        </Group>
        <String Name="FrictionType" Label="Friction Type:" Version="0" AdvanceLevel="0" NumberOfRequiredValues="1">
          <Categories>
            <Cat>Flow</Cat>
          </Categories>
          <ChildrenDefinitions>
            <Double Name="MNGValue" Label="Manning's N Roughness Value:" Version="0" AdvanceLevel="0" NumberOfRequiredValues="1">
              <Categories>
                <Cat>Flow</Cat>
              </Categories>
              <DefaultValue>0</DefaultValue>
              <RangeInfo>
                <Min Inclusive="false">0.0</Min>
              </RangeInfo>
            </Double> 
            <Double Name="ERHValue" Label="Effective Roughness Height:" Version="0" AdvanceLevel="0" NumberOfRequiredValues="1">
              <RangeInfo>
                <Min Inclusive="true">0.0</Min>
              </RangeInfo>
            </Double>
            <Double Name="SAVERHValue" Label="Effective Roughness Height:" Version="0" AdvanceLevel="0" NumberOfRequiredValues="1">
              <RangeInfo>
                <Min Inclusive="false">0.0</Min>
              </RangeInfo>
            </Double>
            <Double Name="SAVUSHValue" Label="Undeflected Stem Height:" Version="0" AdvanceLevel="0" NumberOfRequiredValues="1">
              <RangeInfo>
                <Min Inclusive="true">0.0</Min>
              </RangeInfo>
            </Double>
            <Double Name="URVERHValue" Label="Effective Roughness Height:" NumberOfRequiredValues="1">
              <RangeInfo>
                <Min Inclusive="false">0.0</Min>
              </RangeInfo>
            </Double>
            <Double Name="AvgStemDiameter" Label="Average Stem Diameter:" NumberOfRequiredValues="1">
              <RangeInfo>
                <Min Inclusive="true">0.0</Min>
              </RangeInfo>
            </Double>
            <Double Name="AvgStemDensity" Label="Average Stem Density:" NumberOfRequiredValues="1">
              <RangeInfo>
                <Min Inclusive="true">0.0</Min>
              </RangeInfo>
            </Double>
          </ChildrenDefinitions>
          <DiscreteInfo DefaultIndex="0">
            <Structure>
              <Value Enum="Manning's N Roughness (FR MNG)">MNGParams</Value>
              <Items>
                <Item>MNGValue</Item>
              </Items>
            </Structure>
            <Structure>
              <Value Enum="Effective Roughness Height (FR ERH)">ERHParams</Value>
              <Items>
                <Item>ERHValue</Item>
              </Items>
            </Structure>
            <Structure>
              <Value Enum="Submerged Aquatic Vegetation (FR SAV)">SAVParams</Value>
              <Items>
                <Item>SAVERHValue</Item>
                <Item>SAVUSHValue</Item>
              </Items>
            </Structure>
            <Structure>
              <Value Enum="Unsubmerged Rigid Vegetation (FR URV)">URVParams</Value>
              <Items>
                <Item>URVERHValue</Item>
                <Item>AvgStemDiameter</Item>
                <Item>AvgStemDensity</Item>
              </Items>
            </Structure>
          </DiscreteInfo>
        </String>
      </ItemDefinitions>
    </AttDef>
      
    <!--***  BoundaryCondition Definitions ***-->
    <AttDef Type="BoundaryCondition" BaseType="" Abstract="1" Version="0" Unique="true" Associations="e"></AttDef>
    <AttDef Type="BoundaryConditionWithConstituent" BaseType="BoundaryCondition" Abstract="1" Version="0" Unique="true" Associations="e"></AttDef>
    <AttDef Type="BoundaryConditionWithTempConstituent" BaseType="BoundaryCondition" Abstract="1" Version="0" Unique="true" Associations="e"></AttDef>
    <AttDef Type="WaterSurfElev" Label="Water Surface Elevation (NB OTW)" BaseType="BoundaryConditionWithConstituent" Version="0" Unique="true" Associations="g">
      <ItemDefinitions>
        <Group Name="WSEParameters" Label="" NumberOfRequiredGroups="1">
          <ItemDefinitions>
            <Double Name="Value" Label="Water Surface Elevation:" Version="0" NumberOfRequiredValues="1">
              <ExpressionType>XYSeries</ExpressionType>
              <Categories>
                <Cat>Flow</Cat>
              </Categories>
            </Double>
            <Int Name="Units" Label="Input Time Units" Version="0" AdvanceLevel="0" NumberOfRequiredValues="1">
              <DiscreteInfo DefaultIndex="0">
                <Value Enum="Seconds">0</Value>
                <Value Enum="Minutes">1</Value>
                <Value Enum="Hours">2</Value>
                <Value Enum="Days">3</Value>
                <Value Enum="Weeks">4</Value>
              </DiscreteInfo>
            </Int>
          </ItemDefinitions>
        </Group>
      </ItemDefinitions>
    </AttDef>
    <AttDef Type="TotalDischarge" Label="Total Discharge (NB DIS)" BaseType="BoundaryConditionWithConstituent"
      Version="0" Unique="true" Associations="e">
      <ItemDefinitions>
        <Group Name="TDParameters" Label="" NumberOfRequiredGroups="1">
          <ItemDefinitions>
            <Double Name="Value" Label="Total Discharge (positive in):" Version="0" NumberOfRequiredValues="1">
              <ExpressionType>XYSeries</ExpressionType>
              <Categories>
                <Cat>Flow</Cat>
              </Categories>
            </Double>
            <Int Name="Units" Label="Input Time Units" Version="0" AdvanceLevel="0" NumberOfRequiredValues="1">
              <DiscreteInfo DefaultIndex="0">
                <Value Enum="Seconds">0</Value>
                <Value Enum="Minutes">1</Value>
                <Value Enum="Hours">2</Value>
                <Value Enum="Days">3</Value>
                <Value Enum="Weeks">4</Value>
              </DiscreteInfo>
            </Int>
          </ItemDefinitions>
        </Group>
      </ItemDefinitions>
    </AttDef>
    <AttDef Type="VelocityNB" Label="Average Velocity (NB OVL)" BaseType="BoundaryConditionWithConstituent" Version="0" Unique="true" Associations="e">
      <ItemDefinitions>
        <Group Name="NeumannVelocity" Label="Neumann Velocity:" Version="0" AdvanceLevel="0" NumberOfRequiredGroups="1">
          <ItemDefinitions>
            <Double Name="Value" Label="Flow Rate (positive in):" Version="0" NumberOfRequiredValues="1">
              <ExpressionType>XYSeries</ExpressionType>
              <Categories>
                <Cat>Flow</Cat>
              </Categories>
              <BriefDescription>For face strings the flow rate represents the flow per unit area (positive in); for edge strings the flow rate represents the flow per unit lenght (positive in).</BriefDescription>
            </Double>
            <Int Name="Units" Label="Input Time Units" Version="0" AdvanceLevel="0" NumberOfRequiredValues="1">
              <DiscreteInfo DefaultIndex="0">
                <Value Enum="Seconds">0</Value>
                <Value Enum="Minutes">1</Value>
                <Value Enum="Hours">2</Value>
                <Value Enum="Days">3</Value>
                <Value Enum="Weeks">4</Value>
              </DiscreteInfo>
            </Int>
          </ItemDefinitions>
        </Group>
      </ItemDefinitions>
    </AttDef>
    <AttDef Type="Rainfall/Evaporation" Label="Average Rainfall/Evaporation (NB OVL)" BaseType="BoundaryConditionWithConstituent" Version="0" Unique="true" Associations="f">
      <ItemDefinitions>
        <Group Name="NeumannVelocity" Label="Neumann Velocity:" Version="0" AdvanceLevel="0" NumberOfRequiredGroups="1">
          <ItemDefinitions>
            <Double Name="Value" Label="Rainfall Rate:" Version="0" NumberOfRequiredValues="1">
              <ExpressionType>XYSeries</ExpressionType>
              <Categories>
                <Cat>Flow</Cat>
              </Categories>
              <RangeInfo>
                <Min Inclusive="true">0</Min>
              </RangeInfo>
            </Double>
            <Int Name="Units" Label="Input Time Units" Version="0" AdvanceLevel="0" NumberOfRequiredValues="1">
              <DiscreteInfo DefaultIndex="0">
                <Value Enum="Seconds">0</Value>
                <Value Enum="Minutes">1</Value>
                <Value Enum="Hours">2</Value>
                <Value Enum="Days">3</Value>
                <Value Enum="Weeks">4</Value>
              </DiscreteInfo>
            </Int>
          </ItemDefinitions>
        </Group>
      </ItemDefinitions>
    </AttDef>
    <AttDef Type="VelocityDB" Label="Velocity (DB OVL)" BaseType="BoundaryConditionWithConstituent" Version="0" Unique="true" Nodal="true" Associations="e" AdvanceLevel="1">
      <ItemDefinitions>
        <Group Name="DirichletVelocity" Label="Dirichlet velocity:" Version="0"  NumberOfRequiredGroups="1">
          <ItemDefinitions>
            <Double Name="XValue" Label="X Component" Version="0" NumberOfRequiredValues="1">
              <ExpressionType>XYSeries</ExpressionType>
              <Categories>
                <Cat>Flow</Cat>
              </Categories>
            </Double>
            <Int Name="XUnits" Label="X Input Time Units" Version="0" AdvanceLevel="0" NumberOfRequiredValues="1">
              <DiscreteInfo DefaultIndex="0">
                <Value Enum="Seconds">0</Value>
                <Value Enum="Minutes">1</Value>
                <Value Enum="Hours">2</Value>
                <Value Enum="Days">3</Value>
                <Value Enum="Weeks">4</Value>
              </DiscreteInfo>
            </Int>
            <Double Name="YValue" Label="Y Component" Version="0" NumberOfRequiredValues="1">
              <ExpressionType>XYSeries</ExpressionType>
              <Categories>
                <Cat>Flow</Cat>
              </Categories>
            </Double>
            <Int Name="YUnits" Label="Y Input Time Units" Version="0" AdvanceLevel="0" NumberOfRequiredValues="1">
              <DiscreteInfo DefaultIndex="0">
                <Value Enum="Seconds">0</Value>
                <Value Enum="Minutes">1</Value>
                <Value Enum="Hours">2</Value>
                <Value Enum="Days">3</Value>
                <Value Enum="Weeks">4</Value>
              </DiscreteInfo>
            </Int>
          </ItemDefinitions>
        </Group>
      </ItemDefinitions>
    </AttDef>
    <AttDef Type="SupercriticalInflow" Label="Supercritical Inflow (DB OVH)" BaseType="BoundaryConditionWithConstituent" Version="0" Unique="true" Nodal="true"
      Associations="e">
      <Categories>
        <Cat>Flow</Cat>
      </Categories>
      <ItemDefinitions>
        <Group Name="DirichletVelocityDepth" Label="Dirichlet Velocity and Depth Values Needed for Supercritical Inflow:" Version="0" NumberOfRequiredGroups="1">
          <ItemDefinitions>
            <Double Name="XValue" Label="X Component" Version="0" NumberOfRequiredValues="1">
              <ExpressionType>XYSeries</ExpressionType>
              <Categories>
                <Cat>Flow</Cat>
              </Categories>
            </Double>
            <Int Name="XUnits" Label="X Input Time Units" Version="0" AdvanceLevel="0" NumberOfRequiredValues="1">
              <DiscreteInfo DefaultIndex="0">
                <Value Enum="Seconds">0</Value>
                <Value Enum="Minutes">1</Value>
                <Value Enum="Hours">2</Value>
                <Value Enum="Days">3</Value>
                <Value Enum="Weeks">4</Value>
              </DiscreteInfo>
            </Int>
            <Double Name="YValue" Label="Y Component" Version="0" NumberOfRequiredValues="1">
              <ExpressionType>XYSeries</ExpressionType>
              <Categories>
                <Cat>Flow</Cat>
              </Categories>
            </Double>
            <Int Name="YUnits" Label="Y Input Time Units" Version="0" AdvanceLevel="0" NumberOfRequiredValues="1">
              <DiscreteInfo DefaultIndex="0">
                <Value Enum="Seconds">0</Value>
                <Value Enum="Minutes">1</Value>
                <Value Enum="Hours">2</Value>
                <Value Enum="Days">3</Value>
                <Value Enum="Weeks">4</Value>
              </DiscreteInfo>
            </Int>
            <Double Name="DValue" Label="Depth" Version="0" NumberOfRequiredValues="1">
              <ExpressionType>XYSeries</ExpressionType>
              <Categories>
                <Cat>Flow</Cat>
              </Categories>
            </Double>
            <Int Name="DUnits" Label="Depth Input Time Units" Version="0" AdvanceLevel="0" NumberOfRequiredValues="1">
              <DiscreteInfo DefaultIndex="0">
                <Value Enum="Seconds">0</Value>
                <Value Enum="Minutes">1</Value>
                <Value Enum="Hours">2</Value>
                <Value Enum="Days">3</Value>
                <Value Enum="Weeks">4</Value>
              </DiscreteInfo>
            </Int>
          </ItemDefinitions>
        </Group>
      </ItemDefinitions>
    </AttDef>
    <AttDef Type="LidElevation" Label="Lid Elevation (DB LDE)" BaseType="BoundaryCondition"
      Version="0" Unique="true" Nodal="true" Associations="f">
      <ItemDefinitions>
        <Group Name="LidParameters" Label="" NumberOfRequiredGroups="1">
          <ItemDefinitions>
            <Double Name="Value" Label="Stationary Lid Elevation:" Version="0" NumberOfRequiredValues="1">
              <ExpressionType>XYSeries</ExpressionType>
              <Categories>
                <Cat>Flow</Cat>
              </Categories>
            </Double>
            <Int Name="Units" Label="Input Time Units" Version="0" AdvanceLevel="0" NumberOfRequiredValues="1">
              <DiscreteInfo DefaultIndex="0">
                <Value Enum="Seconds">0</Value>
                <Value Enum="Minutes">1</Value>
                <Value Enum="Hours">2</Value>
                <Value Enum="Days">3</Value>
                <Value Enum="Weeks">4</Value>
              </DiscreteInfo>
            </Int>
          </ItemDefinitions>
        </Group>
      </ItemDefinitions>
    </AttDef>
    <AttDef Type="WaterDepthLid" Label="Water Depth Lid BC (DB LDH)" BaseType="BoundaryCondition"
      Version="0" Unique="true" Nodal="true" Associations="f">
      <ItemDefinitions>
        <Group Name="WDLParameters" Label="" NumberOfRequiredGroups="1">
          <ItemDefinitions>
            <Double Name="Value" Label="Water Depth Under Stationary Lid:" Version="0" NumberOfRequiredValues="1">
              <ExpressionType>XYSeries</ExpressionType>
              <Categories>
                <Cat>Flow</Cat>
              </Categories>
            </Double>
            <Int Name="Units" Label="Input Time Units" Version="0" AdvanceLevel="0" NumberOfRequiredValues="1">
              <DiscreteInfo DefaultIndex="0">
                <Value Enum="Seconds">0</Value>
                <Value Enum="Minutes">1</Value>
                <Value Enum="Hours">2</Value>
                <Value Enum="Days">3</Value>
                <Value Enum="Weeks">4</Value>
              </DiscreteInfo>
            </Int>
          </ItemDefinitions>
        </Group>
      </ItemDefinitions>
    </AttDef>
    <AttDef Type="FloatingStationary" Label="Floating Stationary (DB LID)" BaseType="BoundaryCondition"
      Version="0" Unique="true" Nodal="true" Associations="f">
      <ItemDefinitions>
        <Group Name="FSParameters" Label="" NumberOfRequiredGroups="1">
          <ItemDefinitions>
            <Double Name="Value" Label="Draft of the Lid:" Version="0" NumberOfRequiredValues="1">
              <ExpressionType>XYSeries</ExpressionType>
              <Categories>
                <Cat>Flow</Cat>
              </Categories>
            </Double>
            <Int Name="Units" Label="Input Time Units" Version="0" AdvanceLevel="0" NumberOfRequiredValues="1">
              <DiscreteInfo DefaultIndex="0">
                <Value Enum="Seconds">0</Value>
                <Value Enum="Minutes">1</Value>
                <Value Enum="Hours">2</Value>
                <Value Enum="Days">3</Value>
                <Value Enum="Weeks">4</Value>
              </DiscreteInfo>
            </Int>
          </ItemDefinitions>
        </Group>
      </ItemDefinitions>
    </AttDef>
    <AttDef Type="FrictionBC" Label="Friction BC" BaseType="BoundaryCondition" Version="0" Unique="true" Nodal="false" Associations="e">
      <ItemDefinitions>
        <String Name="FrictionType" Label="Friction Type:" Version="0" AdvanceLevel="0" NumberOfRequiredValues="1">
          <ChildrenDefinitions>
            <Group Name="MNGParams" Label="Manning's N Roughness Parameters:" Version="0" NumberOfRequiredValues="1">
              <ItemDefinitions>
                <Double Name="MNGValue" Label="Manning's N Roughness Value:" Version="0" AdvanceLevel="0" NumberOfRequiredValues="1">
                  <Categories>
                    <Cat>Flow</Cat>
                  </Categories>
                  <DefaultValue>0</DefaultValue>
                  <RangeInfo>
                    <Min Inclusive="false">0.0</Min>
                  </RangeInfo>
                </Double> 
              </ItemDefinitions>
            </Group>
            <Group Name="ERHParams" Label="Effective Roughness Height Parameters:" Version="0" NumberOfRequiredValues="1">
              <ItemDefinitions>
                <Double Name="ERHValue" Label="Effective Roughness Height:" Version="0" AdvanceLevel="0" NumberOfRequiredValues="1">
                  <RangeInfo>
                    <Min Inclusive="true">0.0</Min>
                  </RangeInfo>
                </Double>
              </ItemDefinitions>
            </Group>
            <Group Name="SAVParams" Label="Submerged Aquatic Vegetation Parameters:" Version="0" NumberOfRequiredValues="1">
              <ItemDefinitions>
                <Double Name="SAVERHValue" Label="Effective Roughness Height:" Version="0" AdvanceLevel="0" NumberOfRequiredValues="1">
                  <RangeInfo>
                    <Min Inclusive="false">0.0</Min>
                  </RangeInfo>
                </Double>
                <Double Name="SAVUSHValue" Label="Undeflected Stem Height:" Version="0" AdvanceLevel="0" NumberOfRequiredValues="1">
                  <RangeInfo>
                    <Min Inclusive="true">0.0</Min>
                  </RangeInfo>
                </Double>
              </ItemDefinitions>
            </Group>
            <Group Name="URVParams" Label="Unsubmerged Rigid Vegetation Parameters:" NumberOfRequiredValues="1">
              <ItemDefinitions>
                <Double Name="URVERHValue" Label="Effective Roughness Height:" NumberOfRequiredValues="1">
                  <RangeInfo>
                    <Min Inclusive="false">0.0</Min>
                  </RangeInfo>
                </Double>
                <Double Name="AvgStemDiameter" Label="Average Stem Diameter:" NumberOfRequiredValues="1">
                  <RangeInfo>
                    <Min Inclusive="true">0.0</Min>
                  </RangeInfo>
                </Double>
                <Double Name="AvgStemDensity" Label="Average Stem Density:" NumberOfRequiredValues="1">
                  <RangeInfo>
                    <Min Inclusive="true">0.0</Min>
                  </RangeInfo>
                </Double>
              </ItemDefinitions>
            </Group>
          </ChildrenDefinitions>
          <DiscreteInfo DefaultIndex="0">
            <Structure>
              <Value Enum="Manning's N Roughness (FR MNG)">0</Value>
              <Items>
                <Item>MNGParams</Item>
              </Items>
            </Structure>
            <Structure>
              <Value Enum="Effective Roughness Height (FR ERH)">1</Value>
              <Items>
                <Item>ERHParams</Item>
              </Items>
            </Structure>
            <Structure>
              <Value Enum="Submerged Aquatic Vegetation (FR SAV)">2</Value>
              <Items>
                <Item>SAVParams</Item>
              </Items>
            </Structure>
            <Structure>
              <Value Enum="Unsubmerged Rigid Vegetation (FR URV)">3</Value>
              <Items>
                <Item>URVParams</Item>
              </Items>
            </Structure>
          </DiscreteInfo>
        </String>
      </ItemDefinitions>
    </AttDef>

    <!--***  Expression Definitions ***-->
    <AttDef Type="SimExpression" Abstract="1" Association="None" />
    <AttDef Type="SimInterpolation" BaseType="SimExpression" Abstract="1" />
    <AttDef Type="XYSeries" Label="XY Series" BaseType="SimInterpolation" Version="0" Unique="true" Associations="">
      <ItemDefinitions>
        <Group Name="ValuePairs" Label="Value Pairs" NumberOfRequiredGroups="1">
          <ItemDefinitions>
            <Double Name="X" Version="0" AdvanceLevel="0" NumberOfRequiredValues="0" Extensible="true"/>
            <Double Name="Value" Version="0" AdvanceLevel="0" NumberOfRequiredValues="0" Extensible="true" />
          </ItemDefinitions>
        </Group>
        <String Name="Sim1DLinearExp" Version="0" AdvanceLevel="0" NumberOfRequiredValues="1"/>
      </ItemDefinitions>
    </AttDef>

    <!--***  Iteration Parameters Definitions ***-->
    <AttDef Type="Solvers" Label="Solver Parameters" BaseType="" Version="0" Unique="true" Associations="">
      <ItemDefinitions>
        <Group Name="IterationParams" Label="Iteration Parameters:" Version="0" AdvanceLevel="0" NumberOfRequiredGroups="1">
          <ItemDefinitions>
            <Int Name="MaxNonLinearIters" Label="Maximum nonlinear iterations per time step (IP NIT):" Version="0" AdvanceLevel="0" NumberOfRequiredValues="1">
              <RangeInfo>
                <Min Inclusive="false">0</Min>
              </RangeInfo>
              <Categories>
                <Cat>General</Cat>
              </Categories>
              <DefaultValue>6</DefaultValue>
            </Int>
            <Double Name="NonLinearTolMaxNorm" Label="Non-Linear Tolerance (Max Norm) (IP NTL):" Version="0" AdvanceLevel="0" NumberOfRequiredValues="1">
              <RangeInfo>
                <Min Inclusive="false">0.0</Min>
              </RangeInfo>
              <Categories>
                <Cat>General</Cat>
              </Categories>
              <DefaultValue>1.0E-03</DefaultValue>
            </Double>
            <Double Name="NonLinearTolMaxChange" Label="Increment Tolerance (Maximum Change in Iteration) (IP ITL):" Version="0" AdvanceLevel="0" NumberOfRequiredValues="1"
              Optional="true" IsEnabledByDefault="false">
              <RangeInfo>
                <Min Inclusive="true">0.0</Min>
              </RangeInfo>
              <Categories>
                <Cat>General</Cat>
              </Categories>
              <DefaultValue>1.0E-02</DefaultValue>
            </Double>
            <Int Name="MaxLinearIters" Label="Maximum linear iterations per nonlinear iteration (IP MIT):" Version="0"
             AdvanceLevel="0"  NumberOfRequiredValues="1">
              <RangeInfo>
                <Min Inclusive="true">1</Min>
              </RangeInfo>
              <Categories>
                <Cat>General</Cat>
              </Categories>
              <DefaultValue>100</DefaultValue>
            </Int>
            <Void Name="RungeKuttaTol" Label="Runge-Kutta tolerance for reactive constituents (IP RTL):" Version="0" AdvanceLevel="1" NumberOfRequiredValues="0"
              Optional="true" IsEnabledByDefault="false">
              <Categories>
                <Cat>General</Cat>
              </Categories>
            </Void>
          </ItemDefinitions>
        </Group>
        <Group Name="OperationParams" Label="Operation Parameters:" Version="0" AdvanceLevel="1" NumberOfRequiredGroups="1">
          <ItemDefinitions>
            <Int Name="MemoryIncrementBlockSize" Label="Block size for memory increment (OP INC):" Version="0" AdvanceLevel="1" NumberOfRequiredValues="1">
              <Categories>
                <Cat>General</Cat>
              </Categories>
              <DefaultValue>40</DefaultValue>
              <RangeInfo>
                <Min Inclusive="false">0</Min>
              </RangeInfo>
            </Int>
            <Int Name="PreconditioningBlocks" Label="Subdomain blocks per processor for preconditioning (OP BLK):" Version="0" AdvanceLevel="1" NumberOfRequiredValues="1">
              <Categories>
                <Cat>General</Cat>
              </Categories>
              <DefaultValue>1</DefaultValue>
              <RangeInfo>
                <Min Inclusive="false">0</Min>
              </RangeInfo>
            </Int>
            <Int Name="PreconditionerType" Label="Preconditioner Type (OP PRE):" Version="0" AdvanceLevel="1" NumberOfRequiredValues="1">
              <Categories>
                <Cat>General</Cat>
              </Categories>
              <DiscreteInfo DefaultIndex="1">
                <Value Enum="No preconditioner">0</Value>
                <Value Enum="1 Level Additive Schwartz">1</Value>
                <Value Enum="2 Level Additive Schwartz">2</Value>
                <Value Enum="2 Level Hybrid">3</Value>
              </DiscreteInfo>
            </Int>
          </ItemDefinitions>
        </Group>
        <Group Name="VesselMovementBox" Label="Vessel simulation options:" Version="0" AdvanceLevel="1" NumberOfRequiredGroups="1">
          <ItemDefinitions>
            <Void Name="VesselMovement" Label="Enable vessel movement (OP BT)" Version="0" AdvanceLevel="1" NumberOfRequiredValues="0"
              Optional="true" IsEnabledByDefault="false">
              <Categories>
                <Cat>General</Cat>
              </Categories>
            </Void>
            <Void Name="VesselEntrainment" Label="Enable vessel entrainment (OP BTS)" Version="0" AdvanceLevel="1" NumberOfRequiredValues="0"
              Optional="true" IsEnabledByDefault="false">
              <Categories>
                <Cat>General</Cat>
              </Categories>
            </Void>
          </ItemDefinitions>
        </Group>
        <Group Name="TemporalSchemeBox" Label="Enable second order temporal scheme (OP TEM):" Version="0" AdvanceLevel="1" NumberOfRequiredGroups="1"
          Optional="true" IsEnabledByDefault="false">
          <ItemDefinitions>
            <Double Name="TemporalSchemeCoefficient" Label="Alpha Term:" Version="0" AdvanceLevel="1" NumberOfRequiredValues="1">
              <RangeInfo>
                <Min Inclusive="true">0.0</Min>
                <Max Inclusive="true">1.0</Max>
              </RangeInfo>
              <Categories>
                <Cat>General</Cat>
              </Categories>
              <DefaultValue>0.0</DefaultValue>
            </Double>
          </ItemDefinitions>
        </Group>
        <Group Name="PetrovGalerkinBox" Label="Specify Streamwise Upwind Petrov-Galerkin (SUPG) coefficient (OP TPG):" Version="0" AdvanceLevel="1" NumberOfRequiredGroups="1"
          Optional="true" IsEnabledByDefault="false">
          <ItemDefinitions>
            <Double Name="PetrovGalerkinCoefficient" Label="Coefficient Value:" Version="0" AdvanceLevel="1" NumberOfRequiredValues="1">
              <RangeInfo>
                <Min Inclusive="true">0.0</Min>
                <Max Inclusive="true">0.5</Max>
              </RangeInfo>
              <Categories>
                <Cat>General</Cat>
              </Categories>
              <DefaultValue>0.0</DefaultValue>
            </Double>
          </ItemDefinitions>
        </Group>
        <Void Name="SW2Gradients" Label="Compute SW2 gradients (OP NF2)" Version="0" AdvanceLevel="1" AdvanceLevel="1" NumberOfRequiredValues="0" Optional="true" IsEnabledByDefault="false">
          <Categories>
            <Cat>General</Cat>
          </Categories>
        </Void>
      </ItemDefinitions>
    </AttDef>

    <!--*** Time Definitions ***-->
    <AttDef Type="Time" Label="Time" BaseType="" Version="0" Unique="true" Associations="">
      <ItemDefinitions>
        <Group Name="StartTime" Label="Simulation Start Time (TC T0):" Version="0" AdvanceLevel="0" NumberOfRequiredGroups="1">
          <ItemDefinitions>
            <Double Name="Value" Label="Start Time:" Version="0" AdvanceLevel="0" NumberOfRequiredValues="1">
              <RangeInfo>
                <Min Inclusive="true">0.0</Min>
              </RangeInfo>
              <DefaultValue>0.0</DefaultValue>
              <Categories>
                <Cat>General</Cat>
              </Categories>
            </Double>
            <Int Name="Units" Label="Units" Version="0" AdvanceLevel="0" NumberOfRequiredValues="1">
              <DiscreteInfo DefaultIndex="0">
                <Value Enum="Seconds">0</Value>
                <Value Enum="Minutes">1</Value>
                <Value Enum="Hours">2</Value>
                <Value Enum="Days">3</Value>
                <Value Enum="Weeks">4</Value>
              </DiscreteInfo>
              <DefaultIndex>0</DefaultIndex>
            </Int>
          </ItemDefinitions>
        </Group>
        <Group Name="EndTime" Label="Simulation End Time (TC TF):" Version="0" AdvanceLevel="0" NumberOfRequiredGroups="1">
          <ItemDefinitions>
            <Double Name="Value" Label="End Time:" Version="0" AdvanceLevel="0" NumberOfRequiredValues="1">
              <RangeInfo>
                <Min Inclusive="false">0.0</Min>
              </RangeInfo>
              <DefaultValue>1000</DefaultValue>
              <Categories>
                <Cat>General</Cat>
              </Categories>
            </Double>
            <Int Name="Units" Label="Units" Version="0" AdvanceLevel="0" NumberOfRequiredValues="1">
              <DiscreteInfo DefaultIndex="0">
                <Value Enum="Seconds">0</Value>
                <Value Enum="Minutes">1</Value>
                <Value Enum="Hours">2</Value>
                <Value Enum="Days">3</Value>
                <Value Enum="Weeks">4</Value>
              </DiscreteInfo>
              <DefaultIndex>0</DefaultIndex>
            </Int>
          </ItemDefinitions>
        </Group>
        <Group Name="TimestepSizeParameters" Label="Timestep Size Parameters" NumberOfRequiredGroups="1">
          <ItemDefinitions>
            <String Name="TimestepSizeType" Label="Timestep Size Type:" >
              <Categories>
               <Cat>Time</Cat>
              </Categories>
              <ChildrenDefinitions>
                <Double Name="TimestepSizeSeries" Label="Maximum Timestep Size:" Version="0" AdvanceLevel="0" NumberOfRequiredValues="1">
                  <ExpressionType>XYSeries</ExpressionType>
                  <DefaultValue>200</DefaultValue>
                  <RangeInfo>
                    <Min Inclusive="false">0.0</Min>
                  </RangeInfo>
                </Double>
                <Int Name="InputTimeUnits" Label="Input Time Units" Version="0" AdvanceLevel="0" NumberOfRequiredValues="1">
                  <DiscreteInfo DefaultIndex="0">
                    <Value Enum="Seconds">0</Value>
                    <Value Enum="Minutes">1</Value>
                    <Value Enum="Hours">2</Value>
                    <Value Enum="Days">3</Value>
                    <Value Enum="Weeks">4</Value>
                  </DiscreteInfo>
                </Int>
                <Double Name="InitialTimeStep" Label="Initial Timestep Size:" Version="0" AdvanceLevel="0" NumberOfRequiredValues="1">
                  <RangeInfo>
                    <Min Inclusive="false">0.0</Min>
                  </RangeInfo>
                </Double>
                <Double Name="TimeSeries" Label="Maximum Timestep Size Series:">
                  <ExpressionType>XYSeries</ExpressionType>
                </Double>
                <Double Name="MaximumTimestepSize" Label="Maximum Timestep Size" Version="0" AdvanceLevel="0" NumberOfRequiredValues="1">
                  <RangeInfo>
                    <Min Inclusive="false">0.0</Min>
                  </RangeInfo>
                </Double>
                <Double Name="SteadyStateHydrodynamicCondition" Label="Steady State Hydrodynamic Condition" Version="0" AdvanceLevel="0" NumberOfRequiredValues="1">
                  <BriefDescription>Select Function</BriefDescription>
                  <ExpressionType>XYSeries</ExpressionType>
                </Double>
                <Int Name="MaxIterations" Label="Max iterations for steady state solve" Version="0" AdvanceLevel="0" NumberOfRequiredValues="1">
                  <RangeInfo>
                    <Min Inclusive="false">0</Min>
                  </RangeInfo>
                </Int>
                <Double Name="InitialTimeStepSize" Label="Initial time step for steady state calculation" Version="0" AdvanceLevel="0" NumberOfRequiredValues="1">
                  <RangeInfo>
                    <Min Inclusive="false">0.0</Min>
                  </RangeInfo>
                </Double>
                <Double Name="HydrodynamicsTol" Label="Quasi-unsteady tolerance for hydrodynamics (IP SST):" Version="0" AdvanceLevel="0" Optional="true" EnabledByDefault="false" NumberOfRequiredValues="1">
                  <Categories>
                    <Cat>Time</Cat>
                  </Categories>
                  <RangeInfo>
                    <Min Inclusive="false">0.0</Min>
                  </RangeInfo>
                  <DefaultValue>1.0E-04</DefaultValue>
                </Double>
              </ChildrenDefinitions>
              <DiscreteInfo DefaultIndex="0">
                <Structure>
                  <Value Enum="Maximum Timestep (TC IDT)">MaxParams</Value>
                  <Items>
                    <Item>TimestepSizeSeries</Item>
                    <Item>InputTimeUnits</Item>
                  </Items>
                </Structure>
                <Structure>
                  <Value Enum="Automatic Timestep (TC ATF)">AutoParams</Value>
                  <Items>
                    <Item>InitialTimeStep</Item>
                    <Item>TimeSeries</Item>
                    <Item>InputTimeUnits</Item>
                  </Items>
                </Structure>
                <Structure>
                  <Value Enum="Steady State Timestep (TC STD)">SteadyStateParams</Value>
                  <Items>
                    <Item>InitialTimeStep</Item>
                    <Item>MaximumTimestepSize</Item>
                  </Items>
                </Structure>
                <Structure>
                  <Value Enum="Quasi-Unsteady Timestep (TC STH)">QuasiUnsteadyParams</Value>
                  <Items>
                    <Item>SteadyStateHydrodynamicCondition</Item>
                    <Item>InputTimeUnits</Item>
                    <Item>MaxIterations</Item>
                    <Item>InitialTimeStepSize</Item>
                    <Item>HydrodynamicsTol</Item>
                  </Items>
                </Structure>
              </DiscreteInfo>
            </String>
          </ItemDefinitions>
        </Group>
        <String Name="OutputSeriesType" Label="Output Function" >
          <Categories>
            <Cat>Time</Cat>
          </Categories>
          <ChildrenDefinitions>
            <Double Name="OutputFunction" Label="Output Series">
              <ExpressionType>XYSeries</ExpressionType>
            </Double>
            <Group Name="TimeSeriesData" Label="Series (OS)" Extensible="true" NumberOfRequiredGroups="1" >
              <ItemDefinitions>
                <Double Name="StartTime" Label="Start Time">
                  <DefaultValue>0</DefaultValue>
                  <RangeInfo>
                    <Min Inclusive="true">0.0</Min>
                    <DefaultValue>0</DefaultValue>
                  </RangeInfo>
                </Double>
                <Double Name="EndTime" Label="End Time">
                  <DefaultValue>1000</DefaultValue>
                  <RangeInfo>
                    <Min Inclusive="false">0.0</Min>
                  </RangeInfo>
                </Double>
                <Double Name="TimeInterval" Label="Progression Interval">
                  <RangeInfo>
                    <Min Inclusive="false">0.0</Min>
                  </RangeInfo>
                  <DefaultValue>200</DefaultValue>
                </Double>
                <Int Name="Units" Label="Input Time Units" Version="0" AdvanceLevel="0" NumberOfRequiredValues="1">
                  <DiscreteInfo DefaultIndex="0">
                    <Value Enum="Seconds">0</Value>
                    <Value Enum="Minutes">1</Value>
                    <Value Enum="Hours">2</Value>
                    <Value Enum="Days">3</Value>
                    <Value Enum="Weeks">4</Value>
                  </DiscreteInfo>
                </Int>
              </ItemDefinitions>
            </Group>
          </ChildrenDefinitions>
          <DiscreteInfo DefaultIndex="0">
            <Structure>
              <Value Enum="Auto-Build (OS)">AutoOutputParams</Value>
              <Items>
                <Item>TimeSeriesData</Item>
              </Items>
            </Structure>
            <Structure>
              <Value Enum="XY Series (OC)">OutputParams</Value>
              <Items>
                <Item>OutputFunction</Item>
              </Items>
            </Structure>
          </DiscreteInfo>
        </String>
        <Void Name="PrintAdaptedMeshes" Label="Print Adapted Meshes (PC ADP):" Version="0" AdvanceLevel="1" NumberOfRequiredValues="0"
          Optional="true" IsEnabledByDefault="false">
          <Categories>
            <Cat>General</Cat>
          </Categories>
        </Void>
        <Int Name="HotStartFile" Label="Print Hotstart File at Specified Timestep Intervals (PC HOT)" Version="0" AdvanceLevel="1" NumberOfRequiredValues="1"
          Optional="true" IsEnabledByDefault="false">
          <RangeInfo>
            <Min Inclusive="false">0</Min>
          </RangeInfo>
        </Int>
      </ItemDefinitions>
    </AttDef>

    <!--***  Globals Definitions ***-->
    <AttDef Type="Globals" Label="Globals" BaseType="" Version="0" Unique="true">
      <ItemDefinitions>
        <Double Name="Gravity" Label="Gravity (MP G):" Units="m/s^2" Version="0" AdvanceLevel="0" NumberOfRequiredValues="1">
          <Categories>
            <Cat>General</Cat>
          </Categories>
          <RangeInfo>
            <Min Inclusive="false">0.0</Min>
          </RangeInfo>
          <DefaultValue>9.81</DefaultValue>
        </Double>
        <Double Name="KinMolViscosity" Label="Kinematic Molecular Viscosity (MP MU):" Version="0" AdvanceLevel="0" NumberOfRequiredValues="1">
          <Categories>
            <Cat>General</Cat>
          </Categories>
          <RangeInfo>
            <Min Inclusive="false">0.0</Min>
          </RangeInfo>
          <DefaultValue>1.0e-06</DefaultValue>
        </Double>
        <Double Name="ReferenceDensity" Label="Fluid Density (MP RHO):" Version="0" AdvanceLevel="0" NumberOfRequiredValues="1">
          <Categories>
            <Cat>General</Cat>
          </Categories>
          <RangeInfo>
            <Min Inclusive="false">0.0</Min>
          </RangeInfo>
          <DefaultValue>1000.0</DefaultValue>
        </Double>
        <Double Name="ManningsUnitConstant" Label="Manning's Unit Constant (MP MUC):" Version="0" AdvanceLevel="1" NumberOfRequiredValues="1">
          <Categories>
            <Cat>General</Cat>
          </Categories>
          <DiscreteInfo DefaultIndex="0">
            <Value Enum="1.0 (SI)">1.0</Value>
            <Value Enum="1.486 (English)">1.486</Value>
          </DiscreteInfo>
          <DefaultIndex>0</DefaultIndex>
        </Double>
        <Double Name="WetDryLimits" Label="Wet/dry Shock Capturing Limit (MP DTL):" Version="0" AdvanceLevel="0" NumberOfRequiredValues="1">
          <Categories>
            <Cat>General</Cat>
          </Categories>
          <RangeInfo>
            <Min Inclusive="true">0.0</Min>
          </RangeInfo>
          <DefaultValue>0.01</DefaultValue>
        </Double>
      </ItemDefinitions>
    </AttDef>
  </Definitions>

<!--**********  Attribute Instances ***********-->
<Attributes>
</Attributes>

</SMTK_AttributeManager>
