//=========================================================================
//  Copyright (c) Kitware, Inc.
//  All rights reserved.
//  See LICENSE.txt for details.
//
//  This software is distributed WITHOUT ANY WARRANTY; without even
//  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
//  PURPOSE.  See the above copyright notice for more information.
//
//  This file was developed by Shreeraj Jadhav, Kitware, Inc. based
//  on templates generated using SlicerExtensionWizard & SlicerCustomAppTemplate,
//  and was partially funded by NIH grant R01EB025212.
//=========================================================================

/*==============================================================================

  Copyright (c) Laboratory for Percutaneous Surgery (PerkLab)
  Queen's University, Kingston, ON, Canada. All Rights Reserved.

  See COPYRIGHT.txt
  or http://www.slicer.org/copyright/copyright.txt for details.

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.

  This file was originally developed by Jennifer Andrea, PerkLab, Queen's University
  and was supported through the Applied Cancer Research Unit program of Cancer Care
  Ontario with funds provided by the Natural Sciences and Engineering Research Council
  of Canada.

==============================================================================*/

/// Qt includes
#include <QFileInfo>

// CTK includes
#include <ctkFlowLayout.h>
#include <ctkUtils.h>

/// SMTKFileWriter includes
#include "qSlicerIOOptions_p.h"
#include "qSlicerSMTKFileWriterOptionsWidget.h"
#include "ui_qSlicerSMTKFileWriterOptionsWidget.h"

//-----------------------------------------------------------------------------
/// \ingroup SlicerRt_QtModules_SMTKFileWriter
class qSlicerSMTKFileWriterOptionsWidgetPrivate
  : public qSlicerIOOptionsPrivate
  , public Ui_qSlicerSMTKFileWriterOptionsWidget
{
public:
};

//-----------------------------------------------------------------------------
qSlicerSMTKFileWriterOptionsWidget::qSlicerSMTKFileWriterOptionsWidget(QWidget* parentWidget)
  : qSlicerIOOptionsWidget(new qSlicerSMTKFileWriterOptionsWidgetPrivate, parentWidget)
{
  Q_D(qSlicerSMTKFileWriterOptionsWidget);
  d->setupUi(this);

  ctkFlowLayout::replaceLayout(this);

  connect(d->UseImageIntensityScaleAndOffsetCheckBox, SIGNAL(toggled(bool)),
          this, SLOT(updateProperties()));

  // Image intensity scale and offset turned off by default
  d->UseImageIntensityScaleAndOffsetCheckBox->setChecked(false);
}

//-----------------------------------------------------------------------------
qSlicerSMTKFileWriterOptionsWidget::~qSlicerSMTKFileWriterOptionsWidget() = default;

//-----------------------------------------------------------------------------
void qSlicerSMTKFileWriterOptionsWidget::updateProperties()
{
  Q_D(qSlicerSMTKFileWriterOptionsWidget);

  d->Properties["imageIntensityScaleAndOffset"] = d->UseImageIntensityScaleAndOffsetCheckBox->isChecked();
}
