set(proj netgen)

# Set dependency list
set(${proj}_DEPENDENCIES zlib)

# Include dependent projects if any
ExternalProject_Include_Dependencies(${proj} PROJECT_VAR proj DEPENDS_VAR ${proj}_DEPENDENCIES)

if(Slicer_USE_SYSTEM_${proj})
  message(FATAL_ERROR "Enabling Slicer_USE_SYSTEM_${proj} is not supported !")
endif()

# Sanity checks
if(DEFINED netgen_DIR AND NOT EXISTS ${netgen_DIR})
  message(FATAL_ERROR "netgen_DIR variable is defined but corresponds to nonexistent directory")
endif()

if(NOT Slicer_USE_SYSTEM_${proj})

  include(ExternalProjectForNonCMakeProject)

  # environment
  set(_env_script ${CMAKE_BINARY_DIR}/${proj}_Env.cmake)
  ExternalProject_Write_SetPythonSetupEnv_Commands(${_env_script})

  set(EXTERNAL_PROJECT_OPTIONAL_CMAKE_CACHE_ARGS)

  set(netgen_ADDITONAL_CMAKE_CACHE_ARGS)
  

  ExternalProject_SetIfNotDefined(
    Slicer_${proj}_GIT_REPOSITORY
    "${EP_GIT_PROTOCOL}://github.com/NGSolve/netgen.git"
    QUIET
    )

  ExternalProject_SetIfNotDefined(
    Slicer_${proj}_GIT_TAG
    "v6.2.2007"  
    QUIET
    )

  set(EP_SOURCE_DIR ${CMAKE_BINARY_DIR}/${proj})
  set(EP_BINARY_DIR ${CMAKE_BINARY_DIR}/${proj}-build)
  set(EP_INSTALL_DIR ${CMAKE_BINARY_DIR}/${proj}-install)  

  ExternalProject_add(netgen
    ${${proj}_EP_ARGS}
    GIT_REPOSITORY "${Slicer_${proj}_GIT_REPOSITORY}"
    GIT_TAG "${Slicer_${proj}_GIT_TAG}"
    SOURCE_DIR ${EP_SOURCE_DIR}
    BINARY_DIR ${EP_BINARY_DIR}
    INSTALL_DIR ${EP_INSTALL_DIR}
    CMAKE_CACHE_ARGS
      -DCMAKE_CXX_COMPILER:FILEPATH=${CMAKE_CXX_COMPILER}
      -DCMAKE_CXX_FLAGS:STRING=${ep_common_cxx_flags}
      -DCMAKE_C_COMPILER:FILEPATH=${CMAKE_C_COMPILER}
      -DCMAKE_C_FLAGS:STRING=${ep_common_c_flags}
      -DCMAKE_CXX_STANDARD:STRING=${CMAKE_CXX_STANDARD}
      -DCMAKE_CXX_STANDARD_REQUIRED:BOOL=${CMAKE_CXX_STANDARD_REQUIRED}
      -DCMAKE_CXX_EXTENSIONS:BOOL=${CMAKE_CXX_EXTENSIONS}
      -DCMAKE_CXX_VISIBILITY_PRESET:BOOL=default
      -DUSE_SUPERBUILD:BOOL=OFF
      -DUSE_OCC:BOOL=OFF #${occt_enabled}
      #-DOCC_INCLUDE_DIR:PATH=<INSTALL_DIR>/include/opencascade
      #-DOCC_LIBRARY:PATH=<INSTALL_DIR>/lib
      -DUSE_PYTHON:BOOL=OFF #${python3_enabled}
      -DUSE_INTERNAL_TCL:BOOL=OFF
      -DUSE_GUI:BOOL=OFF
      #-DCMAKE_INSTALL_PREFIX=<INSTALL_DIR>
      -DNETGEN_NO_DEB_PACKAGER=ON
      # The install directories below are required on
      # at least some platforms. (Netgen will otherwise
      # install to /Application/Netgen.app on macos.)
      #-DNG_INSTALL_DIR_BIN:STRING=bin # for windows DLLs
      #-DNG_INSTALL_DIR_LIB:STRING=lib
      -DNG_INSTALL_DIR_CMAKE:STRING=lib/cmake/netgen
      # -DNG_INSTALL_DIR_PYTHON:STRING=lib/python3.7 # TODO: version number from superbuild?
      -DNG_INSTALL_DIR_RES:STRING=share
      -DNG_INSTALL_DIR_INCLUDE:STRING=include
      -DZLIB_INCLUDE_DIR:PATH=${ZLIB_INCLUDE_DIR}
      -DZLIB_LIBRARY:PATH=${ZLIB_LIBRARY}
    #   -DPYTHON_EXECUTABLE:PATH=${PYTHON_EXECUTABLE}
    #   -DPYTHON_LIBRARY:FILEPATH=${PYTHON_LIBRARY}
    #   -DPYTHON_INCLUDE_DIR:PATH=${PYTHON_INCLUDE_DIR}
      -DUSE_PYTHON:BOOL=OFF    
      -DCMAKE_INSTALL_PREFIX:FILEPATH=${EP_INSTALL_DIR} 
      ${EXTERNAL_PROJECT_OPTIONAL_CMAKE_CACHE_ARGS}
    #
    #
    DEPENDS ${${proj}_DEPENDENCIES}
    )
  set(Netgen_DIR ${CMAKE_BINARY_DIR}/netgen-install/lib/cmake/netgen)
  set(Netgen_BIN_DIR ${CMAKE_BINARY_DIR}/netgen-install/bin)

  set(_lib_subdir lib)
  if(WIN32)
    set(_lib_subdir bin)
  endif()

  #-----------------------------------------------------------------------------
  # Launcher setting specific to build tree

  set(${proj}_LIBRARY_PATHS_LAUNCHER_BUILD ${netgen_DIR}/${_lib_subdir}/<CMAKE_CFG_INTDIR>)
  mark_as_superbuild(
    VARS ${proj}_LIBRARY_PATHS_LAUNCHER_BUILD
    LABELS "LIBRARY_PATHS_LAUNCHER_BUILD"
    )

else()
  ExternalProject_Add_Empty(${proj} DEPENDS ${${proj}_DEPENDENCIES})
endif()

mark_as_superbuild(Netgen_DIR:PATH)
mark_as_superbuild(Netgen_BIN_DIR:PATH)