/*=========================================================================

   Program: ParaView
   Module:    aevaAboutDialogReaction.cxx

   Copyright (c) 2005,2006 Sandia Corporation, Kitware Inc.
   All rights reserved.

   ParaView is a free software; you can redistribute it and/or modify it
   under the terms of the ParaView license version 1.2.

   See License_v1.2.txt for the full ParaView license.
   A copy of this license can be obtained by contacting
   Kitware Inc.
   28 Corporate Drive
   Clifton Park, NY 12065
   USA

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR
CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

========================================================================*/
#include "aevaAboutDialogReaction.h"

#include "aeva/mbVersion.h"

#include "pqAboutDialog.h"
#include "pqCoreUtilities.h"

#include <QLabel>
#include <QTabWidget>
#include <QTextBrowser>
#include <QTreeWidget>

//-----------------------------------------------------------------------------
aevaAboutDialogReaction::aevaAboutDialogReaction(QAction* parentObject)
  : Superclass(parentObject)
{
}

//-----------------------------------------------------------------------------
void aevaAboutDialogReaction::showAboutDialog()
{
  pqAboutDialog aboutDialog(pqCoreUtilities::mainWidget());

  // Customize the dialog for aeva
  // 1. Provide different clickable URLs.
  aboutDialog.findChild<QLabel*>("ParaViewLinkLabel")
    ->setText("<html><head/><body><p>"
              "<a href=\"https://simtk.org/projects/aeva-apps\">"
              "<span style=\"text-decoration: none; color:palette(link);\">"
              "https://simtk.org/projects/aeva-apps</a>"
              "</span>"
              "</p></body></html>");
  aboutDialog.findChild<QLabel*>("VersionLabel")
    ->setText(QString("Version: ") + QString(aeva_VERSION));
  aboutDialog.findChild<QLabel*>("KitwareLinkLabel")
    ->setText("<html><head/><body><p>"
              "<span style=\"text-decoration: none; color:palette(link);\">"
              "<a href=\"https://kitware.com/\">https://kitware.com/</a>"
              "</span>"
              "</p></body></html>");

  // 2. Add a "licenses" tab for FMA license (and perhaps others)
  auto tabs = aboutDialog.findChild<QTabWidget*>("tabWidget");
  auto acknowledgments = new QTextBrowser;
  acknowledgments->setReadOnly(true);
  acknowledgments->setHtml(
    "<html><head/><body><p>"
    "Funding by National Institute of Biomedical Imaging and Bioengineering, "
    "National Institutes of Health (R01EB025212) awarded to "
    "Cleveland Clinic and Kitware Inc."
    "</p></body></html>"
  );
  tabs->addTab(acknowledgments, "Acknowledgment");
  auto licenses = new QTextBrowser;
  licenses->setReadOnly(true);
  licenses->setOpenExternalLinks(true);
  tabs->addTab(licenses, "License");
  licenses->setHtml(
    "<html><head/><body>"
    "<p>"
    "This program is distributed under the "
    "<a href=\"https://gitlab.kitware.com/aeva/aeva/-/blob/master/LICENSE.txt\">"
    "<span style=\"text-decoration: none; color:palette(link);\">"
    "3-clause BSD license"
    "</span>"
    "</a> provided with its source code. Exceptions are noted below.</p>"
    "<hr>"

    "<p>The Foundational Model of Anatomy ontology is distributed under the "
    "<a href=\"http://creativecommons.org/licenses/by/3.0/\">"
    "<span style=\"text-decoration: none; color:palette(link);\">"
    "Creative Commons Attribution 3.0 Unported License"
    "</span>"
    "</a>.</p>"

    "<p>nlohmann_json is distributed under the "
    "<a href=\"https://github.com/nlohmann/json/blob/develop/LICENSE.MIT\">"
    "<span style=\"text-decoration: none; color:palette(link);\">"
    "MIT License"
    "</span>"
    "</a>.</p>"

    "<p>Boost is distributed under the "
    "<a href=\"https://www.boost.org/users/license.html\">"
    "<span style=\"text-decoration: none; color:palette(link);\">"
    "Boost Software License"
    "</span>"
    "</a>.</p>"

    "<p>pugi is distributed under the "
    "<a href=\"https://pugixml.org/license.html\">"
    "<span style=\"text-decoration: none; color:palette(link);\">"
    "MIT License"
    "</span>"
    "</a>.</p>"

    "<p>PEGTL is distributed under the "
    "<a href=\"https://github.com/taocpp/PEGTL/blob/master/LICENSE\">"
    "<span style=\"text-decoration: none; color:palette(link);\">"
    "MIT License"
    "</span>"
    "</a>.</p>"

    "</body></html>"
  );

  // 3. Add version numbers to the client information.
  auto clientInfo = aboutDialog.findChild<QTreeWidget*>("ClientInformation");
  auto items = clientInfo->findItems("Version", Qt::MatchExactly, 0);
  if (!items.empty())
  {
    (*items.begin())->setText(0, "ParaView Version");
  }
  QTreeWidgetItem* aevaVersion = new QTreeWidgetItem;
  aevaVersion->setText(0, "aeva Version");
  aevaVersion->setText(1, QString(aeva_VERSION));
  clientInfo->insertTopLevelItem(0, aevaVersion);

  aboutDialog.exec();
}
