"""Entry point module: process-chunk

Implements the entry-point by using Python or any other languages.
"""

import json
import os
import time

from diva_evaluation_cli.src.implementation.process_chunks.random_systems \
    import Randomizer


def entry_point(chunk_id, system_cache_dir):
    """Method to complete: you have to raise an exception if an error occured
    in the program.

    Process a chunk.

    Args:
        chunk_id (str): Chunk id
        system_cache_dir (str): Path to system cache directory
    """
    chunk_acts = {}
    chunk_acts['filesProcessed'] = []
    chunk_acts['activities'] = []

    chunk_file = os.path.join(system_cache_dir, "data.json")
    with open(chunk_file, 'r') as fd:
        chunk_data = json.load(fd)

    for video in chunk_data['files']:
        randomizer = Randomizer(video, chunk_data['activities'])
        f_acts = randomizer.generate_random_activities()
        chunk_acts['filesProcessed'].extend(f_acts['filesProcessed'])
        chunk_acts['activities'].extend(f_acts['activities'])

    output = os.path.join(system_cache_dir, 'output.json')
    with open(output, 'w') as fd:
        json.dump(chunk_acts, fd)
    time.sleep(60)
