"""Entry point module: experiment-init

Implements the entry-point by using Python or any other languages.
"""

import json
import os


def entry_point(file_index, activity_index, chunks,
                video_location, system_cache_dir, config_file=None):
    """Method to complete: you have to raise an exception if an error occured
    in the program.

    Start servers, starts cluster, etc.

    Args:
        file_index(str): Path to file index json file for test set
        activity_index(str): Path to activity index json file for test set
        chunks (str): Path to chunks json file
        video_location (str): Path to videos content
        system_cache_dir (str): Path to system cache directory
        config_file (str, optional): Path to config file
    """
    with open(chunks, 'r') as fd:
        chunks_data = json.load(fd)
    chunk = chunks_data["Chunk0"]
    for i in range(len(chunk['files'])):
        if video_location not in chunk['files'][i]:
            chunk['files'][i] = os.path.join(video_location, chunk['files'][i])
    fn = os.path.join(system_cache_dir, 'data.json')
    with open(os.path.join(system_cache_dir, "data.json"), 'w') as fd:
        json.dump(chunk, fd)
