'''
This module implements unit tests of the actev status command.
'''

import sys
import os
import unittest

from diva_evaluation_cli.bin.cli import cli_parser

cdir = os.path.dirname(os.path.abspath(__file__))
res = os.path.join(cdir, "resources")


class TestStatus(unittest.TestCase):
    """
    Test the actev status command.
    """

    def setUp(self):
        sys.argv[1:] = ["status"]

    def _test_cli(error_msg):
        try:
            cli_parser()
        except Exception:
            self.fail(error_msg)

    def test_status_chunk_query(self):
        chunk_id = 0
        sys.argv.extend(["chunk-query", "-i", chunk_id])
        _test_cli('`actev status chunk-query` failed.')

    def test_status_experiment_query(self):
        sys.argv.append("experiment-query")
        _test_cli('`actev status experiment-query` failed.')

    def test_status_system_query(self):
        sys.argv.append("system-query")
        _test_cli('`actev status system-query` failed.')


if __name__ == '__main__':
    unittest.main()
