"""Entry point module: reset-chunk

Implements the entry-point by using Python or any other languages.

"""
import os

def entry_point(chunk_id, system_cache_dir):
    """Method to complete: you have to raise an exception if an error occured in the program.

    Delete all cached information for ChunkID so that the chunk can be re-run.

    Args:
        chunk_id (str): Chunk id
        system_cache_dir (str): Path to system cache directory
    """
    if not system_cache_dir:
        raise Exception("reset_chunk.sh needs system-cache-dir argument, please provide it")

    # go into the right directory to execute the script
    path = os.path.dirname(__file__)
    script = os.path.join(path, '../implementation/reset_chunk.sh')

    # status is a 16-bit long integer
    # The 8 strongest bits are exit_code
    # The 8 weakest bits are signal_number
    status = os.system(script)
    exit_code = status >> 8
    signal_number = status & (2**8 - 1)
    if status != 0:
        if signal_number == 2:  # SIGINT
            raise KeyboardInterrupt
        else:
            raise Exception("Error occured in reset_chunk.sh")
