"""Entry point module: post-process-chunk

Implements the entry-point by using Python or any other languages.

"""
import os

def entry_point(chunk_id, system_cache_dir):
    """Method to complete: you have to raise an exception if an error occured in the program.

    Post-process a chunk.

    Args:
        chunk_id (str): Chunk id
        system_cache_dir (str): Path to system cache directory

    """
    # go into the right directory to execute the script
    path = os.path.dirname(__file__)
    script = os.path.join(path, '../implementation/post_process_chunk.sh')

    # status is a 16-bit long integer
    # The 8 strongest bits are exit_code
    # The 8 weakest bits are signal_number
    status = os.system(script)
    exit_code = status >> 8
    signal_number = status & (2**8 - 1)
    if status != 0:
        if signal_number == 2:  # SIGINT
            raise KeyboardInterrupt
        else:
            raise Exception("Error occured in post_process_chunk.sh")
