#!/bin/bash

#####################################################
# Command Line Interface actev: installation script #
#####################################################

# NOTES: 
# - conda is used if ROOT/environment.yml exists
# - if conda, the environment should be activated outside of this script
# - ..

usage() {
  echo "usage: install.sh [-h | --help] [--cli-env | -c CLI_ENV_PATH] [--scorer-env | -s SCORER_ENV_PATH] [--all]"
}

CURRENT_DIR=`pwd`

[[ -f "$CURRENT_DIR"

# Requirements
python3 -h &> /dev/null
if [[ $? -ne "0" ]]; then
  echo "Python3 is required to install and run the CLI."
  echo "Please install Python3.X >= 3.7 and make sure \`python3 -h\` is working."
  exit 1
fi
conda -h &> /dev/null
if [[ $? -ne "0" ]]; then
  echo "conda is required to install and run the CLI."
  echo "Please install conda and make sure \`conda -h\` is working."
  exit 1
fi

# Check that .local/bin path is in $PATH
echo $PATH | grep /.local/bin > /dev/null
EXIT_STATUS=$?

if [ $EXIT_STATUS -ne 0 ];then
  echo "Please add ~/.local/bin to your PATH  before running the script:"
  echo "export PATH=\"${PATH}:${HOME}/.local/bin\""
  exit 1
fi

cd "$(dirname "$0")"

# Install dependencies (e.g. ActEV scorer) contained in `install.sh` scripts
# if '--all' is passed as an argument
envs="~/.conda_envs"
cli_env="$envs/cli.env"
scorer_env="$envs/scorer.env"
all=0
force_env=0
while [ "$1" != "" ]; do
  case $1 in
    -c | --cli-env )      shift
                          cli_env=$1
                          ;;
    -s | --scorer-env )   shift
                          scorer_env=$1
                          ;;
    -f | --force-conda )  force_env=1
                          ;;
    -h | --help )         usage
                          exit
                          ;;
    --all )               all=1
                          ;;
    * )                   usage
                          exit 1
  esac
  shift
done

# back to ./, creating CLI conda env
cd ../..
conda env create -f environment.yml -p $cli_env
conda_script="$(conda shell.bash hook)"
# Adding it to bashrc for execution flow
if [[ $force_env -eq 1 ]]; then
  echo "# Activate ActEV-CLI conda environment" >> ~/.bashrc
  echo $conda_script >> ~/.bashrc
  echo "conda activate $cli_env" >> ~/.bashrc
  echo '' >> ~/.bashrc
fi
# Activating it and installing the CLI
eval "$conda_script"
conda activate $cli_env
python3 setup.py develop --prefix $cli_env
conda deactivate

# Exporting scorer env directory to the CLI shell env
cd "$(dirname "$0")"
echo "SCORER_CONDA_ENV=$scorer_env" >> ./private_src/implementation/utils/actev_cli_environment.env

# TODO replace ca par juste lui du scorer
# conda le scorer etc
if [[ $all -eq 1 ]]; then
  cd "$(dirname "$0")"
  echo "Installation in progress: ActEV_Scorer"
  ./private_src/implementation/validate_execution/install.sh $scorer_env
  echo "Installation done: ActEV_Scorer"
fi
