"""Utils module

Can be used by any other module of the CLI
Implements function to call shell commands and get correct informations on fail
"""

import subprocess


class ShellException(Exception):
    """
    Bare exception class for running shell commands.
    """
    def __init__(self, exception):
        Exception.__init__(self)
        self.exception = exception

    def __str__(self):
        return "Failed to execute: {}\nError code: {}\nstderr: {}".format(
            self.exception.cmd, self.exception.returncode,
            self.exception.stderr)


def run_shell(command: tuple):
    """
    Run shell script or command.
    """
    try:
        process = subprocess.run(command, shell=True, capture_output=True,
                                 text=True, check=True)
    except subprocess.CalledProcessError as e:
        raise ShellException(e)
